.equ	WE_RAM		= 6 ;PB6
.equ	A14_RAM 	= 7 ;PB7

POnRAM:
	clr	temp
	out	PORTA,temp
	out	PORTB,temp
	out	PORTC,temp
	out	PORTD,temp
	out	PORTE,temp
	sbi	PORTD,led
	sbi	PORTE,VccEEPROM
	sbi	PORTE,CS
	sbi	PORTE,OE
	sbi	PORTB,WE_RAM
	ser	temp
	out	DDRE,temp
	out	DDRA,temp
	out	DDRB,temp
	out	DDRC,temp
	out	DDRD,temp
	ldz	Do_End
	ijmp

ReadBlockRAM:
	ld	addrL,Y+
	ld	addrH,Y+
	ld	temp,Y+
	ldz	Tx_Dat
	ldi	loop,0x80
ReadBlockRAM_loop:
	rcall	ReadByteRAM
	st	Z+,temp
	adiw	addrL,1
	dec	loop
	brne	ReadBlockRAM_loop
	ldi	loop,0x80
	ldz	Do_End
	ijmp

WriteBlockRAM:
	ld	addrL,Y+
	ld	addrH,Y+
	ld	temp,Y+
	ldi	cmd,C_Err
	ldi	loop,0x80
WriteBlockRAM_loop:
	ld	temp,Y+
	rcall	WriteByteRAM
	adiw	addrL,1
	dec	loop
	brne	WriteBlockRAM_loop
	ldi	loop,0x80
	ldz	Do_End
	ijmp

;A14/A15 => PORTB.6/7 => WE_RAM/A14_RAM
ReadByteRAM:
	mov	temp,addrH
	lsl	temp
	andi	temp,0b10000000		;A14
	or	addrH,temp
	ori	addrH,0b01000000	;WE high
	clr	temp
	out	DDRA,temp
	ser	temp
	out	PORTA,temp
	rjmp	ReadByte
 
WriteByteRAM:
	ser	temp2
	out	DDRA,temp2
	out	PORTA,temp
	mov	temp,addrH
	lsl	temp
	andi	temp,0b10000000		;A14
	or	addrH,temp
	ori	addrH,0b01000000	;WE high
	out	PORTC,addrL
	out	PORTB,addrH
	cbi	PORTE,CS
	cbi	PORTB,WE_RAM
	nop
	nop
	sbi	PORTB,WE_RAM
	sbi	PORTE,CS
	ret
