/*
 * demo1.c
 *
 * Copyright (c) 1996 by Paul W. Lee
 *
 * Permission is granted to anyone to use this software for any purpose
 * on any computer system, and to redistribute it freely, with the
 * following restrictions:
 * 1) No charge may be made other than reasonable charges for reproduction.
 * 2) Modified versions must be clearly marked as such.
 * 3) The authors are not responsible for any harmful consequences
 *    of using this software, even if they result from defects in it.
 *
 *
 * This program will load in the Atari 800 character set and display
 * it on the Genesis.  
 */

#include "genesis.h"

/*
 * Function prototypes
 */
void init_gfx();
void load_tiles();
void show_tiles();
void set_colors();

/*
 *  External Vars.
 */
extern ulong tiledata[];

/*
 *  Main program
 */
void main()
{
    /* Initialize Genesis GFX registers */
    init_gfx();

    /* Load the character set */
    load_tiles();

    /* Set the first two colors */
    set_colors();

    /* Show the character set */
    show_tiles();

    /* LOOP FOREVER */
    while (1)
    {
        asm("nop");
    }
}

/*
 * Initilize the GFX.
 */
void init_gfx()
{
    register uint *pw;

    pw = (uint *) GFXCNTL;

    *pw = 0x8016;   /* reg. 80 - Enable HBL */
    *pw = 0x8174;   /* reg. 81 - Enable VBL */
    *pw = 0x8238;   /* reg. 82 - Plane A = $E000 */
    *pw = 0x8338;   /* reg. 83 -    "        "   */
    *pw = 0x8407;   /* reg. 84 - Plane B = $E000 */
    *pw = 0x857e;
    *pw = 0x8600;
    *pw = 0x8700;
    *pw = 0x8801;
    *pw = 0x8901;
    *pw = 0x8a01;
    *pw = 0x8b00;
    *pw = 0x8c08;
    *pw = 0x8d08;
    *pw = 0x8f02;
    *pw = 0x9000;
    *pw = 0x9100;
    *pw = 0x92ff;
}

/*
 * Load the tile data for my character set.
 */
void load_tiles()
{
    register ulong *pl;
    register uint i;

    pl = (ulong *) GFXCNTL;
    *pl = GFX_WRITE_ADDR(0);

    pl = (ulong *) GFXDATA;

    for (i = 0; i < 128 * 8; i++)
        *pl = tiledata[i];
}

/*
 * Set the first two color in the
 * first palette.
 */
void set_colors()
{
    register ulong *pl;
    register uint *pw;

    pl = (ulong *) GFXCNTL;
    *pl = GFX_COLOR_WRITE_ADDR(0);

    pw = (uint *) GFXDATA;
    *pw = 0;        /* color 0 - black */
    *pw = 0x0eee;   /* color 1 - white */
}

/*
 * Show the tiles by writing the tile
 * number (1-128) to the GFX memory.
 */
void show_tiles()
{
    register ulong *pl;
    register uint *pw;
    register uint i;

    pl = (ulong *) GFXCNTL;
    *pl = GFX_WRITE_ADDR(0xe000);

    pw = (uint *) GFXDATA;
    for (i = 0; i < 128; i++)
        *pw = 0x8000 + i;
}

