/*
 * demo3.c
 *
 * Copyright (c) 1996 by Paul W. Lee
 *
 * Permission is granted to anyone to use this software for any purpose
 * on any computer system, and to redistribute it freely, with the
 * following restrictions:
 * 1) No charge may be made other than reasonable charges for reproduction.
 * 2) Modified versions must be clearly marked as such.
 * 3) The authors are not responsible for any harmful consequences
 *    of using this software, even if they result from defects in it.
 *
 *
 * This program will play a digitized sample using the Z80.
 *
 */

#include "genesis.h"

/*
 *  Function prototypes
 */
void play_sample(addr, len);

/*
 *  External references...
 */
extern uchar SOUND[];
extern uchar SOUND_END[];

/*
 *  Main program
 */
void main()
{
    /* Play 'SEGA' digitized sound */
    play_sample(SOUND, SOUND_END-SOUND);

    /* LOOP FOREVER */
    while (1)
    {
        asm("nop");
    }
}

/*
 *  Play sample
 */
void play_sample(addr, len)
ulong addr;
ulong len;
{
    register uint *pw;
    register uchar *pb;

    /* Halt the Z80 */
    pw = (uint *) Z80_HALT;
    *pw = 0x100;

    /* Point to Z80 RAM */
    /* This is the location for 'start_flag' */
    /* in the Z80 driver.                    */
    pb = (uchar *) 0xa00039;

    /* Flag to begin playing */
    *pb++ = 1;

    /* Store address of sample */
    *pb++ = addr & 0xff;
    *pb++ = (addr >> 8) & 0xff;
    *pb++ = (addr >> 16) & 0xff;

    /* Store length of sample */
    *pb++ = len & 0xff;
    *pb++ = (len >> 8) & 0xff;
    *pb++ = (len >> 16) & 0xff;

    /* Enable Z80 and begin playing */
    pw = (uint *) Z80_HALT;
    *pw = 0;

}
