/*
 * demo6.c
 *
 * Copyright (c) 1996 by Paul W. Lee
 *
 * Permission is granted to anyone to use this software for any purpose
 * on any computer system, and to redistribute it freely, with the
 * following restrictions:
 * 1) No charge may be made other than reasonable charges for reproduction.
 * 2) Modified versions must be clearly marked as such.
 * 3) The authors are not responsible for any harmful consequences
 *    of using this software, even if they result from defects in it.
 *
 *
 * This program will display a simple sprite and use the joypad to
 * move it around the screen.
 *
 */

#include "genesis.h"

/*
 * Function prototypes
 */
void init_gfx();
void load_tiles();
void set_colors();
void wait_sync();
void init_joypad();
uint read_joypad();
void show_sprite();

/*
 *  Tile/Sprite data
 */
ulong tiledata[] = {
    0x00000000,    /* first tile blank , tile #0 */
    0x00000000,
    0x00000000,
    0x00000000,
    0x00000000,
    0x00000000,
    0x00000000,
    0x00000000,
    
    0x00000000,    /* smiley face , tile #1 */
    0x00000000,
    0x00000000, 
    0x00000000, 
    0x00001111,
    0x00110011,
    0x11110011,
    0x11111111,

    0x11001111,    /* tile #2 */
    0x11110000,
    0x00111111,
    0x00001111,
    0x00000000, 
    0x00000000, 
    0x00000000, 
    0x00000000, 
        
    0x00000000,    /* tile #3 */
    0x00000000, 
    0x00000000, 
    0x00000000, 
    0x11000000,
    0x00110000,
    0x00111100,
    0x11111100,

    0x11001100,    /* tile #4 */
    0x00111100,
    0x11110000,
    0x11000000,
    0x00000000, 
    0x00000000, 
    0x00000000, 
    0x00000000 
};

/*
 *  Variables...
 */
ulong vtimer;   /* VBL timer */
uint  xpos, ypos;

/*
 *  Main program
 */
void main()
{
    register uint i;

    /* Initialize Genesis GFX registers */
    init_gfx();

    /* Load tile data */
    load_tiles();

    /* Set the colors */
    set_colors();

    /* Initialize Joypads */
    init_joypad();

    /* Initial x, y position */
    xpos = 164;
    ypos = 164;

    /* LOOP FOREVER */
    while (1)
    {
        i = read_joypad();
        if (i)
        {
            /* Just check the joypad */
            switch(i & 0xf)
            {
                case JOY_UP:
                    ypos--;
                    break;
                case JOY_DOWN:
                    ypos++;
                    break;
                case JOY_LEFT:
                    xpos--;
                    break;
                case JOY_RIGHT:
                    xpos++;
                    break;
                case JOY_LEFT + JOY_UP:
                    xpos--;
                    ypos--;
                    break;
                case JOY_LEFT + JOY_DOWN:
                    xpos--;
                    ypos++;
                    break;
                case JOY_RIGHT + JOY_UP:
                    xpos++;
                    ypos--;
                    break;
                case JOY_RIGHT + JOY_DOWN:
                    xpos++;
                    ypos++;
                    break;
            }
        }
        wait_sync();
        show_sprite();
    }
}

/*
 * Initilize the GFX.
 */
void init_gfx()
{
    register uint *pw;

    pw = (uint *) GFXCNTL;

    *pw = 0x8016;   /* reg. 80 - Enable HBL */
    *pw = 0x8174;   /* reg. 81 - Enable VBL */
    *pw = 0x8238;   /* reg. 82 - Plane A =E000 */
    *pw = 0x8338;   /* reg. 83 -    "        "   */
    *pw = 0x8407;   /* reg. 84 - Plane B =E000 */
    *pw = 0x8560;   /* reg. 85 - sprite table begins at $C000 */
    *pw = 0x8600;
    *pw = 0x8700;
    *pw = 0x8801;
    *pw = 0x8901;
    *pw = 0x8a01;
    *pw = 0x8b00;
    *pw = 0x8c08;
    *pw = 0x8d08;
    *pw = 0x8f02;
    *pw = 0x9000;
    *pw = 0x9100;
    *pw = 0x92ff;
}

/*
 * Load the tile data for sprite.
 */
void load_tiles()
{
        register ulong *pl;
        register uint i;

        pl = (ulong *) GFXCNTL;
        *pl = GFX_WRITE_ADDR(0);

        pl = (ulong *) GFXDATA;

        for (i = 0; i < 5 * 8; i++)
                *pl = tiledata[i];
}

/*
 * Set the first two color in the
 * first palette.
 */
void set_colors()
{
        register ulong *pl;
        register uint *pw;
        register int x;

        pl = (ulong *) GFXCNTL;
        *pl = GFX_COLOR_WRITE_ADDR(0);

        pw = (uint *) GFXDATA;
        *pw = 0;        /* color 0 - black */
        *pw = 0x0eee;   /* color 1 - white */
}
/*
 *  Wait for VBL.
 */
void wait_sync()
{
    register ulong x;

    x = vtimer;
    while (x == vtimer);
}

/*
 *  Initialize Joypads
 */
void init_joypad()
{
    register uchar *pb;

    pb = (uchar *) 0xa10009;
    *pb = 0x40;
    pb += 2;
    *pb = 0x40;
    pb += 2;
    *pb = 0x40;
}

/*
 *  Read joypad #1
 */
uint read_joypad()
{
    register uchar *pb;
    register uint i, j;

    pb = (uchar *) 0xa10003;

    *pb = 0x40;        /* check joypad */
    asm("nop");
    asm("nop");
    i = *pb & 0x3f;

    *pb = 0;           /* check buttons */
    asm("nop");
    asm("nop");
    j = (*pb & 0x30) << 2;

    return(~(i | j));
}

/*
 *  Show the smiley face sprite
 */
void show_sprite()
{
    register ulong *pl;
    register uint *pw;

    /* Sprite table begins at $C000            */
    /* Note: We set this address using         */
    /*       reg. 85 int the init_gfx routine. */
    pl = (ulong *) GFXCNTL;
    *pl = GFX_WRITE_ADDR(0xC000);

    pw = (uint *) GFXDATA;
    *pw = ypos;   /* Set the position */

    /* We need to set the size and number of the */
    /* sprite we want to show.  0=last, 1=first, */
    /* 2=second, etc...                          */
    /* 0x500 = 2x2 tile sprite                   */
    /* 0 = last sprite                           */
    *pw = 0x500 | 0;

    /* Tile number of sprite is 1.  The genesis  */
    /* shows sprites x then y.  Note: Look at    */
    /* the tile data.                            */
    *pw = 1;

    /* x position */
    *pw = xpos;
}
