/*
 * genesis.h
 *
 * Copyright (c) 1996 by Paul W. Lee
 *
 * Permission is granted to anyone to use this software for any purpose
 * on any computer system, and to redistribute it freely, with the
 * following restrictions:
 * 1) No charge may be made other than reasonable charges for reproduction.
 * 2) Modified versions must be clearly marked as such.
 * 3) The authors are not responsible for any harmful consequences
 *    of using this software, even if they result from defects in it.
 */

/*
 *      GFX Registers
 */
#define GFXDATA 0xc00000
#define GFXCNTL 0xc00004

#define Z80_HALT  0xa11100
#define Z80_RESET 0xa11200
/*
 *      Joypad definitions
 */
#define JOY_UP          1
#define JOY_DOWN        2
#define JOY_LEFT        4
#define JOY_RIGHT       8
#define BUTTON_A        0x40
#define BUTTON_B        0x10
#define BUTTON_C        0x20
#define BUTTON_S        0x80

/*
 *      GFX address macros
 */
#define GFX_WRITE_ADDR(x) ((0x4000 + (x & 0x3fff)) << 16) + (x >> 14)
#define GFX_DMA_ADDR(x)   ((0x4000 + (x & 0x3fff)) << 16) + ((x >> 14) | 0x80)
#define GFX_COLOR_WRITE_ADDR(x) ((0xc000 + (x & 0x3fff)) << 16) + (x >> 14)

#define GFX_VERT_SCROLL(x) ((0x4000 + (x & 0x3fff)) << 16) + ((x >> 14) | 0x10)
#define GFX_HORZ_SCROLL(x) ((0x4000 + (x & 0x3fff)) << 16) + (x >> 14)   

/*
 *      Misc defines
 */
#define FALSE   0
#define TRUE    1

#define uchar   unsigned char
#define uint    unsigned int
#define ulong   unsigned long
