#include "Z80.h"
#include "bus.h"
#include <string.h>

CZ80::CZ80(CBus *abus)
// 
{
	bus = abus;
    reset();
}


CZ80::~CZ80(void)
// 
{
}


void CZ80::reset(void)
//  
{
    memset(bank0.f, 0, 8);
	memset(bank1.f, 0, 8);
	memset(regs16.f, 0, 8);
	I = 0;
	R = 0;
	state = 0;
	iflags = 1;
}


void CZ80::clock(void)
/*
    
   .
   
   
  , 
     
      
   .
*/
{

    switch(state) {

    case 0:
		//    
        bus->setaddress(regs16.w.PC);
		state++;
		return;

    case 1:
		//     

		if((GET_DD != 0) || (GET_FD != 0))
		    bus->setaction(ACT_MEMR);

		else
			bus->setaction(ACT_RDOPCODE);

        state++;
        return;			

    case 2:
		//      
		bus->doaction();
		state++;
        return;             

    case 3:
		//    
        command = bus->read();
		regs16.w.PC++;
		// ""   
		R++;
		R %= 0x80;

        //     NOP/#DD/#FD
        switch(command) {

        case 0:
			state = 0;
			return;

        case 0xDD:
			SET_DD(1);
			state = 0;
			return;

        case 0xFD:
			SET_FD(1);
			state = 0;
			return;

        default:
			state++;
			return;
        }

    default:
		decode();
		return;
	}

}


void CZ80::setbank(int value)
/*
    
   
*/
{
    SET_BANK(value);
}


int  CZ80::getbank(void)
/*
   
    
*/
{
	return GET_BANK;
}


void CZ80::decode(void)
/*
    
   .
*/
{
	switch(command) {

    case 0xCB:
		do_prefix_CB();
        return;

    case 0xED:
		do_prefix_ED();
		return;

    default:
		return;

    }

}


BOOL CZ80::parity(BYTE value)
/*
   TRUE,   
  value   
*/
{

	int counter;
	BYTE mask;

    mask = 1;
	counter = 0;

    while(mask != 0) {
		
		if((value & mask) != 0)
            counter++;
        
        mask = mask << 1;
    }

	return((counter & 1) == 0);
}


//----------------------------------------


void CZ80::do_prefix_CB(void)
/*
  ,  
   #CB 
*/
{
    
	BYTE t;

	switch(state) {

   //     2- 
	case 4:
        bus->setaddress(regs16.w.PC);
		bus->setaction(ACT_MEMR);
		state++;
        return;

    case 5:
		bus->doaction();
		state++;
        return;

    case 6:
		temp[0] = bus->read();
		regs16.w.PC++;
		state++;
        return;

    default:
        //  7-    2- 

		if(GET_DD != 0) {
            do_RLC_IX_index();
			return;
        }

		if(GET_FD != 0) {
            do_RLC_IY_index();
			return;
        }

        t = temp[0];

		if(t < 6 || t == 7)
			do_RLC_reg(0);

		else if(t == 6)
			do_RLC_HL(0);

		else if(t < 0x0E || t == 0x0F)
			do_RLC_reg(1);

		else if(t == 0x0E)
			do_RLC_HL(1);

        return;

	}

}


void CZ80::do_prefix_ED(void)
{
}


void CZ80::do_RLC_reg(int dir)
// RLC/RRC reg 
{

	BYTE n, r, c;

	n = temp[0] & 0x07; //  
	
	if(GET_BANK == 0) {
    //     
		r = bank0.f[n];
	    c = bank0.b.F;
    }

	else {
		r = bank1.f[n];
        c = bank1.b.F;
    }

	//   

    if(dir == 0) // 
	    __asm {
		    mov    byte ptr c, 0
            rol    byte ptr r, 1
		    jnc    m0000
		    or     byte ptr c, 1
		    m0000:
	   }

	else // 
	    __asm {
		    mov    byte ptr c, 0
            ror    byte ptr r, 1
		    jnc    m0001
		    or     byte ptr c, 1
		    m0001:
	   }


    //     F / F'
	if(parity(r)) //
		c |= 4;

	if(r == 0)    //  
        c |= 0x40;

    if((r & 0x80) != 0)  // 
		c |= 0x80;

	//    
    if(GET_BANK == 0) {
		bank0.f[n] = r;
		bank0.b.F = c;
    }

	else {
		bank1.f[n] = r;
		bank1.b.F = c;
    }

		SET_DD(0);
		SET_FD(0);
		state = 0;
}


void CZ80::do_RLC_HL(int dir)
// RLC/RRC (HL)
{

    BYTE b, c;

	switch(state) {
		 
	case 7:
	    //      (1 )
	    if(GET_BANK == 0) {
			temp[3] = bank0.b.F;
		    temp[2] = bank0.b.H;
		    temp[1] = bank0.b.L;
		}

	    else {
			temp[3] = bank1.b.F;
		    temp[2] = bank1.b.H;
		    temp[1] = bank1.b.L;
		}

		state++;
		return;

    case 8: 		
	    //     (3 )
        temp[4] = (regs16.w.PC) & 0xFF;
		temp[5] = (regs16.w.PC) >> 8;
		regs16.w.PC = (temp[2] << 8) + temp[1];
		bus->setaddress(regs16.w.PC);
		bus->setaction(ACT_MEMR);
		state++;
        return;

    case 9:
        bus->doaction();
        state++;
		return;

    case 10:
		temp[6] = bus->read();
		state++;
		return;

    case 11:
	    //  1 
		b = temp[6];
		c = temp[3];
       
		if(dir == 0) // 
 		    __asm {
			    mov    byte ptr c, 0
			    rol    byte ptr b, 1
			    jnc    m1000
			    or     byte ptr c, 1
                m1000:
			} 

        else // 
 		    __asm {
			    mov    byte ptr c, 0
			    ror    byte ptr b, 1
			    jnc    m1001
			    or     byte ptr c, 1
                m1001:
			}
		
	       //     F / F'
	       if(parity(b)) //
		       c |= 4;

	       if(b == 0)    //  
               c |= 0x40;

           if((b & 0x80) != 0)  // 
		       c |= 0x80;

		   temp[6] = b;
		   temp[3] = c;
           state++;
		   return;
		
    case 12:
		//   3 
		bus->setaddress(regs16.w.PC);
		bus->setdata(temp[6]);
	    state++;
		return;

    case 13:
		bus->setaction(ACT_MEMW);
		state++;
		return;

    case 14:
		bus->doaction();
		regs16.w.PC = (temp[5] << 8) + temp[4];

		if(GET_BANK == 0)
			bank0.b.F = temp[3];

		else
			bank1.b.F = temp[3];

		SET_DD(0);
		SET_FD(0);
		state = 0;
		return;
    }
}


void CZ80::do_RLC_IX_index(void)
// RLC (IX+index)
{
    
    WORD a;
	BYTE b, c;
	BYTE op, dir, n;

    switch(state) {

	case 7:
        //  IX  

        if(GET_BANK == 0)
		    temp[3] = bank0.b.F;
		else
            temp[3] = bank1.b.F;

		temp[2] = (regs16.w.IX) >> 8;
		temp[1] = (regs16.w.IX) & 0x00FF;
		state++;
        return;

    case 8:
        //   
        a = temp[2] << 8;
		a += temp[1];
		b = temp[0];
		
		__asm {
			movsx  ax, byte ptr b
            add    word ptr a, ax
        }

		temp[2] = a >> 8;
		temp[1] = a & 0x00FF;
		state++;
		return;

    case 9:
		 //     (IX + index)  3 
		temp[5] = (regs16.w.PC) >> 8;
		temp[4] = (regs16.w.PC) & 0x0F;
		regs16.w.PC = (temp[2] << 8) + temp[1];
		bus->setaddress(regs16.w.PC);
		bus->setaction(ACT_MEMR);
		state++;
        return;

    case 10:
		bus->doaction();
		state++;
        return;

    case 11:
		temp[6] = bus->read();
		state++;
        return;

    case 12:
		 //    (3 )
		regs16.w.PC = (temp[5] << 8) + temp[4];
		bus->setaddress(regs16.w.PC);
		bus->setaction(ACT_MEMR);
		state++;
        return;

    case 13:
		bus->doaction();
		state++;
        return;

    case 14:
		temp[7] = bus->read();
		regs16.w.PC++;
		state++;
        return;

    case 15:
		 //  
		op = (temp[7] & 0xC0) >> 6;  //  .  
		dir = (temp[7] & 0x38) >> 3; // 
		n = temp[7] & 0x07;          //   - 
		
		switch(op) {

        case 0x00:

            b = temp[6]; // 
            c = temp[3]; // 

			switch(dir) {

            case 0x00: case 0x01:
    
				if(dir == 0)

				    __asm {
					    mov    byte ptr c, 0
                        rol    byte ptr b, 1
					    jnc    m2000
					    or     byte ptr c, 1
                        m2000:
					}

				else

					__asm {
					    mov    byte ptr c, 0
                        ror    byte ptr b, 1
					    jnc    m2001
					    or     byte ptr c, 1
                        m2001:
					}

				break;
            } //     

            break;

        case 0x01:
			do_BIT_bit_IX_index();
			break;

        case 0x02:
			do_RES_bit_IX_index();
			break;

        case 0x03:
			do_SET_bit_IX_index();
			break;
        } //   : RLC..., BIT..., ...

        if(parity(b))
			c |= 4;

		if(b == 0)
			c |= 0x40;

		if((b & 0x80) != 0)
			c |= 0x80;

		temp[6] = b;
		temp[3] = c;
		state++;
		return;

    case 16:
		temp[5] = (regs16.w.PC) >> 8;
		temp[4] = (regs16.w.PC) & 0x000F;
        regs16.w.PC = (temp[2] << 8) + temp[1];
		bus->setaddress(regs16.w.PC);
		bus->setdata(temp[6]);
		state++;
        return;

    case 17:
		bus->setaction(ACT_MEMW);
		state++;
		return;

    case 18:
		bus->doaction();
        regs16.w.PC = (temp[5] << 8) + temp[4];

		if(GET_BANK == 0)
			bank0.b.F = c;

		else
			bank1.b.F = c;

		state = 0;
		SET_DD(0);
		SET_FD(0);
		return;
    } //    
}


void CZ80::do_RLC_IY_index(void)
// RLC (IY+index)
{
}


void CZ80::do_BIT_bit_IX_index()
{
}
 

void CZ80::do_SET_bit_reg(void)
// SET bit,reg
{
}


void CZ80::do_RES_bit_IX_index(void)
{
}

void CZ80::do_SET_bit_IX_index(void)
{
}




