/*----------------------------------
       Z80
 ----------------------------------*/

#ifndef __Z80_H__
#define __Z80_H__

#include <windows.h>
#include "bus.h"

//   
#define IF_INT    0x0001    //   INT
#define IF_NMI    0x0002    //   NMI
#define IF_IM     0x000C    //   
#define IF_BANK   0x0010    //   
#define IF_IFL    0x0020    //   

// 
#define IF_DD     0x0040
#define IF_FD     0x0080

//   iflags
#define GET_INT   ((iflags)  & (IF_INT))
#define GET_NMI   (((iflags) & (IF_NMI))  >>  1)
#define GET_IM    (((iflags) & (IF_IM))   >>  2)
#define GET_BANK  (((iflags) & (IF_BANK)) >>  4)
#define GET_IFL   (((iflags) & (IF_IFL))  >>  5)
#define GET_DD    (((iflags) & (IF_DD))   >>  6)
#define GET_FD    (((iflags) & (IF_FD))   >>  7)
#define NO_ANY_PREFIX ((GET_DD == 0) && (GET_FD == 0))
                   

//   iflags
#define SET_INT(v)   iflags &= 0xFFFE; iflags |= (v)
#define SET_NMI(v)   iflags &= 0xFFFD; iflags |= ((v) << 1)
#define SET_IM(v)    iflags &= 0xFFF3; iflags |= ((v) << 2)
#define SET_BANK(v)  iflags &= 0xFFEF; iflags |= ((v) << 4)
#define SET_IFL(v)   iflags &= 0xFFDF; iflags |= ((v) << 5)
#define SET_DD(v)    iflags &= 0xFFBF; iflags |= ((v) << 6)
#define SET_FD(v)    iflags &= 0xFF7F; iflags |= ((v) << 7)

//   
#define _B 0
#define _C 1
#define _D 2
#define _E 3
#define _H 4
#define _L 5
#define _F 6
#define _A 7

// 16- 
#define _IX 0;
#define _IY 1;
#define _SP 2;
#define _PC 3;
#define _IR 4;


typedef union Regs8 { //  

struct b {
	BYTE B;
	BYTE C;
	BYTE D;
    BYTE E;
	BYTE H;
	BYTE L;
	BYTE F;
	BYTE A;
} b;

BYTE f[8];

} Regs8;


typedef union Regs16 { // 16- 

struct w {
    WORD IX;
	WORD IY;
	WORD SP;
	WORD PC;
} w;

WORD f[4];

};


class CZ80 { //  Z80

public:
        // 
	    CZ80(CBus *abus);
		~CZ80(void);
	    void reset(void);
	    void clock(void);
		void setbank(int value);
        int getbank(void);

		//  
	    Regs8 bank0;
	    Regs8 bank1;

		//  
	    Regs16 regs16;
		BYTE I; //  I
		BYTE R; //  R

private:
	    BYTE command; //  
		BYTE temp[8];

        WORD iflags;  /*   ,  :
	                       ,  
			              INT, ...
                       */	  
   	    BYTE state;   //    - ()
	    CBus *bus;    //    

        //  
		void decode(void);
		BOOL parity(BYTE value);

//--------------    Z80 ------------
    
		void do_prefix_CB(void);
		void do_prefix_ED(void);
		void do_RLC_reg(int dir);
        void do_RLC_HL(int dir);
		void do_RLC_IX_index(void);
		void do_RLC_IY_index(void);
		void do_BIT_bit_IX_index(void);
        void do_SET_bit_reg(void);
		void do_RES_bit_IX_index(void);
		void do_SET_bit_IX_index(void);
};


#endif
