#include "memspace.h"
#include "bus.h"

CBus::CBus(CMemSpace *amemspace)
{
    memspace = amemspace;
	data = 0xFF;
}


CBus::~CBus()
{
}


void CBus::setaddress(WORD adr)
{
	address = adr;
}


void CBus::setdata(BYTE adata)
{
	data = adata;
}


void CBus::setaction(int act)
{
    action = act;
}


BYTE CBus::read(void)
{
    
    BYTE d;

    d = data;
	data = 0xFF;

	return d;
}


void CBus::doaction(void)
{

    switch(action) {

	case ACT_RDOPCODE:
		data = memspace->read(address, TRUE);
		return;   

    case ACT_MEMR:
		data = memspace->read(address, FALSE);
        return; 
		
    case ACT_MEMW:
		memspace->write(address, data);
		data = 0xFF;
		return;

    }

}


