#include <stdio.h>
#include "Z80.h"
#include "memspace.h"
#include "bus.h"

CMemSpace *memspace = new CMemSpace;
CBus *bus = new CBus(memspace);
CZ80 *z80 = new CZ80(bus);

void init(void)
{
    memspace->write(0x0000, 0xDD);
	memspace->write(0x0001, 0xCB);
	memspace->write(0x0002, 0x00);
	memspace->write(0x0003, 0x06);
	memspace->write(0x0004, 0xCB);
	memspace->write(0x0005, 0x06);
	//----------------------------
	memspace->write(0x0088, 0xC1);
	memspace->write(0x0108, 0xC1);
    z80->bank0.b.B = 0x81;
	z80->bank0.b.H = 0x01;
	z80->bank0.b.L = 0x08;
	z80->regs16.w.IX = 0x0108;
	z80->setbank(0);
}

void dump(void)
{
         
    BYTE fromHL;
	
	if(z80->getbank() == 0) { 
  
		fromHL = memspace->read( 
		         ((z80->bank0.b.H) << 8) + z80->bank0.b.L, FALSE);

		printf("Bank 0\n---------\n"
			   "AF=%04X\n"
			   "BC=%04X\n"
			   "DE=%04X\n"
               "HL=%04X\n"
			   "(HL)=%04X\n\n",
			    ((z80->bank0.b.A) << 8) + z80->bank0.b.F,
				((z80->bank0.b.B) << 8) + z80->bank0.b.C,
                ((z80->bank0.b.D) << 8) + z80->bank0.b.E,
				((z80->bank0.b.H) << 8) + z80->bank0.b.L,
				fromHL);
    }
	            
	else {

		fromHL = memspace->read( 
		         ((z80->bank1.b.H) << 8) + z80->bank1.b.L, FALSE);

		printf("Bank 1\n---------\n"
			   "AF'=%04X\n"
			   "BC'=%04X\n"
			   "DE'=%04X\n"
               "HL'=%04X\n"
			   "(HL')=%04X\n\n",
			    ((z80->bank1.b.A) << 8) + z80->bank1.b.F,
				((z80->bank1.b.B) << 8) + z80->bank1.b.C,
                ((z80->bank1.b.D) << 8) + z80->bank1.b.E,
				((z80->bank1.b.H) << 8) + z80->bank1.b.L,
				fromHL);
    }


	printf("IX=%04X  IY=%04X  SP=%04X  PC=%04X  "
		   "(IX+00)=%02X  (IY+00)=%02X\n\n",
		   z80->regs16.w.IX,
		   z80->regs16.w.IY,
		   z80->regs16.w.SP,
		   z80->regs16.w.PC,
		   memspace->read(z80->regs16.w.IX, FALSE),
		   memspace->read(z80->regs16.w.IY, FALSE));
}

int main()
{

    int i = 0;

    init();
    printf("Before:\n\n");
	dump();

	while(i < 46) {
		z80->clock();
		i++;
    }  

    printf("After:\n\n");
	dump();
	printf("Cicles %d\n\n", i);  

    delete z80;
	delete bus;
	delete memspace;

	return 0;
}


