        ASEG
        ORG  100h
Start:  DI
        MVI  A,0C3h
        STA  53FDh ; Replace with 0H when making the ROM file
        STA  0038h
        LXI  H,Progrm
        SHLD 53FEh ; Replace with 1H when making the ROM file
        LXI  H,Init
        SHLD 0039h
        XRA  A
        OUT  10h
        JMP PROGRM
;
; Screen: Palette, background, scroll and border
;
Border: DB 0
;
Color:  DB 00h
COLR1:  DB 07h
COLR2:  DB 38h
COLR3:  DB 16h
COLR4:  DB 0C0h
COLR5:  DB 86h
COLR6:  DB 20h
COLR7:  DB 0C5h
COLR8:  DB 3Fh
COLR9:  DB 04h
COLR10: DB 52h
COLR11: DB 98h
COLR12: DB 80h
COLR13: DB 24h
COLR14: DB 0ffh
COLR15: DB 0f7h
;
Blank:  DB 00h
BLNK1:  DB 00h
BLNK2:  DB 00h
BLNK3:  DB 00h
BLNK4:  DB 00h
BLNK5:  DB 00h
BLNK6:  DB 00h
BLNK7:  DB 00h
BLNK8:  DB 00h
BLNK9:  DB 00h
BLNK10: DB 00h
BLNK11: DB 00h
BLNK12: DB 00h
BLNK13: DB 00h
BLNK14: DB 00h
BLNK15: DB 00h
;
PALTBL: DW COLR15
;
Scroll: DB 0FFh
;
; Keyboard data
;
KeyKod: DB 0FFh
Down    EQU 7Fh
Up      EQU 0DFh
Right   EQU 0BFh
Left    EQU 0EFh
BackSp  EQU 0F7h
CR      EQU 0FBh
LF      EQU 0FDh
TAB     EQU 0FEh
;
IndRUS: DB  00h
Rele:   DB  00h
;
SPSave: DW 0
;
INIT:   PUSH H
        PUSH B
        PUSH D
        PUSH PSW
        MVI  A,88h
        OUT  00
        LHLD PALTBL
        MVI  D,16
        MVI  E,15
INIT1:  MOV  A,E
        OUT  02
        MOV  A,M
        OUT  0Ch
        OUT  0Ch
        OUT  0Ch
        OUT  0Ch
        OUT  0Ch
        DCX  H
        OUT  0Ch
        DCR  E
        OUT  0Ch
        DCR  D
        OUT  0Ch
        JNZ  INIT1
        MVI  A,8Ah
        OUT  00
        MVI  A,0FEh
        OUT  03
        IN   02
        STA  KeyKod
        MVI  A,88h
        OUT  00
        LDA  Border
        OUT  02
        LDA  Scroll
        OUT  03
        LDA  IndRus
        MOV  B,A
        LDA  Rele
        ORA  B
        OUT  01
        POP  PSW
        POP  D
        POP  B
        POP  H
        EI
        RET
;
; Main program starts here
;
Progrm: LXI  SP,53FFh
        LXI H, BLNK15       ; Black the screen out before cleaning
        SHLD PALTBL
        EI
        HLT                 ; Wait for initialization
        DI
; Saving the stack
        LXI H,0H
        DAD SP
				SHLD SPSave
; Clear the screen 
        LXI H,0H
        SPHL
        LXI B,0000h
        MVI A,40H
clrscr1:PUSH H
        INX B 
				CMP B
				JNZ clrscr1
; Draw the tiled columns
				LXI SP, 0C100H
				CALL DwCol
				LXI SP, 0C200H
				CALL DwCol
				LXI SP, 0C300H
				CALL DwCol
				LXI SP, 0C400H
				CALL DwCol
				LXI SP, 0C500H
				CALL DwCol
				LXI SP, 0C600H
				CALL DwCol
				LXI SP, 0C700H
				CALL DwCol
				LXI SP, 0C800H
				CALL DwCol
				LXI SP, 0C900H
				CALL DwCol
				LXI SP, 0CA00H
				CALL DwCol
				LXI SP, 0CB00H
				CALL DwCol
				LXI SP, 0CC00H
				CALL DwCol
				LXI SP, 0CD00H
				CALL DwCol
				LXI SP, 0CE00H
				CALL DwCol
				LXI SP, 0CF00H
				CALL DwCol
				LXI SP, 0D000H
				CALL DwCol
				LXI SP, 0D100H
				CALL DwCol
				LXI SP, 0D200H
				CALL DwCol
				LXI SP, 0D300H
				CALL DwCol
				LXI SP, 0D400H
				CALL DwCol
				LXI SP, 0D500H
				CALL DwCol
; Restoring the stack, setting the normal 
; pallette and re-enabling interrupts
				LHLD SPSave
				SPHL
				LXI H,COLR15
				SHLD PALTBL
				EI
				XRA A
;
; Scroll the columns down
;
ScLoop: HLT ; Wait for VSync
        DI
				LXI D, 0C000H
				CALL SdCol
				LXI D, 0C100H
				CALL SdCol
				LXI D, 0C200H
				CALL SdCol
				LXI D, 0C300H
				CALL SdCol
				LXI D, 0C400H
				CALL SdCol
				LXI D, 0C500H
				CALL SdCol
				LXI D, 0C600H
				CALL SdCol
				LXI D, 0C700H
				CALL SdCol
				LXI D, 0C800H
				CALL SdCol
				LXI D, 0C900H
				CALL SdCol
				LXI D, 0CA00H
				CALL SdCol
				LXI D, 0CB00H
				CALL SdCol
				LXI D, 0CC00H
				CALL SdCol
				LXI D, 0CD00H
				CALL SdCol
				LXI D, 0CE00H
				CALL SdCol
				LXI D, 0CF00H
				CALL SdCol
				LXI D, 0D000H
				CALL SdCol
				LXI D, 0D100H
				CALL SdCol
				LXI D, 0D200H
				CALL SdCol
				LXI D, 0D300H
				CALL SdCol
				LXI D, 0D400H
				CALL SdCol
; Fill the topmost scanline
				XRA A
				MOV B, A
				LDA CurRow
				MOV C, A
				LXI H, Tile
				DAD B
				MOV A, M
				LXI D, 0C0FFh
        CALL ClTopL
        MOV A, C
        INR A
        ANI 7
        STA CurRow
        EI
; Halt the program till BackSpace is pressed
				MVI B, BackSp 
Loop:		LDA KeyKod
				CMP B
				JNZ ScLoop
				JMP 0				
;----------------
;Subroutines
;----------------
;
; Draws a column of tiles
;
DwCol:	POP H
        SHLD DwCol2 + 1
				LXI H, 0FF81H
				LXI D, 0A995H
				LXI B, 81FFH
				MVI A, 32
DwCol1:	PUSH H
				PUSH D
				PUSH D
				PUSH B
				DCR A
				JNZ DwCol1
DwCol2:	JMP 0
;
; Scrolls down a column of tiles
; Modifies SP so requires disabled
; interrupts
;
SDCol:  
				LXI H, 0
				DAD SP
				XCHG
				INR L
				SPHL
				DCR L
				MVI A, 15
; Moving down a block of 16 bytes
SDCol1:	POP B      ;1
				MOV M, C
				INR L
				MOV M, B
				INR L
				POP B      ;2
				MOV M, C
				INR L
				MOV M, B
				INR L
				POP B      ;3
				MOV M, C
				INR L
				MOV M, B
				INR L
				POP B      ;4
				MOV M, C
				INR L
				MOV M, B
				INR L
				POP B      ;5
				MOV M, C
				INR L
				MOV M, B
				INR L
				POP B      ;6
				MOV M, C
				INR L
				MOV M, B
				INR L
				POP B      ;7
				MOV M, C
				INR L
				MOV M, B
				INR L
				POP B      ;8
				MOV M, C
				INR L
				MOV M, B
				INR L
				DCR A
				JNZ SDCol1
        POP B      ;1 - Moving down remaining 15 bytes
				MOV M, C
				INR L
				MOV M, B
				INR L
				POP B      ;2
				MOV M, C
				INR L
				MOV M, B
				INR L
				POP B      ;3
				MOV M, C
				INR L
				MOV M, B
				INR L
				POP B      ;4
				MOV M, C
				INR L
				MOV M, B
				INR L
				POP B      ;5
				MOV M, C
				INR L
				MOV M, B
				INR L
				POP B      ;6
				MOV M, C
				INR L
				MOV M, B
				INR L
				POP B      ;7
				MOV M, C
				INR L
				MOV M, B
				INR L
				POP B      ;8 - only one byte
        MOV M, C
				XCHG
				SPHL
SDCol2: RET
;
; Fills the topmost scanline with the value of A
; The beginning of the scan line is in DE
;
ClTopL: MVI B, 21
ClTopL1:STAX D
				INR D
				DCR B
				JNZ ClTopL1
        RET
;
; Data
;
Tile:   DB 0FFH, 81H, 0A9H, 95H, 0A9H, 95H, 81H, 0FFh 
CurRow: DB 0
        END
