/*
**      CAS2CAS
** Gienek plug@poczta.fm
**
*/

#include <iostream.h>
#include <fstream.h>

//------------------------------------------
// RECORD
class RECORD
{
public:
        unsigned char status;
        unsigned long int extra_sum;
        unsigned int interval;
        unsigned int size;
        unsigned char data[2048];
        void Normalize_Interval();
        unsigned char Calculate_checksum();
        unsigned long int Calculate_extrasum();
        void CreateEOF();
        void Clear();
        RECORD() {Clear();};
        RECORD(RECORD &);
};

// Clear Record
RECORD::RECORD(RECORD &a)
{
for (int i=0; i < 2048; i++) {data[i]=a.data[i];};
size=a.size;
interval=a.interval;
status=a.status;
extra_sum=a.extra_sum;
};

// Clear Record
void RECORD::Clear()
{
for (int i=0; i < 2048; i++) {data[i]=0;};
size=0;
interval=0;
status=0;
extra_sum=0;
};

// Create standart EOF
void RECORD::CreateEOF()
{
size=132;
data[0]=0x55;
data[1]=0x55;
data[2]=0xFE;
for (int i=0; i<128; i++) {data[i+3]=0;};
data[131]=0xA9;
};

// Calculate Atari checksum
unsigned char RECORD::Calculate_checksum()
{
unsigned int sum = 0x00;
if (size>0)
 {
 for (unsigned int i=0; i<(size-1); i++)
        {
        sum+=(unsigned int)data[i];
        if (sum>255)
                {
                sum&=0x00ff;
                sum++;
                };
        };
 };
return sum;
};
// Calculate Extra checksum
unsigned long int RECORD::Calculate_extrasum()
{
unsigned long int sum = 0x00000000;
if (size>0)
 {
 for (unsigned int i=0; i<(size-1); i++)
        {
        sum+=(unsigned int)data[i];
        };
 };
return sum;
};
// END of RECORD
//------------------------------------------

int operator==(RECORD &a, RECORD &b)
{
int r=1;
if (a.size==b.size)
 {
 for (unsigned int i=0; i<a.size; i++)
  {
  if (!(a.data[i]==b.data[i]))
   {
   r=0;
   i=a.size;
   };
  };
 }
else
 {
 r=0;
 };
return r;
};

//------------------------------------------
// CAS_FILE
class CAS_FILE
{
public:
        fstream cas;
        char Name[255];
        unsigned int Boud;
        unsigned int NumRec;
	RECORD t[512];
        int Load();
        int SaveHEX(char []);
        int SaveCAS(char []);
        int LoadHEX(char []);
        int LoadCAS(char []);
        void Clear();
        void Analize();
        void Normalize(int s=1);
        void ShowInfo(char []);
        CAS_FILE() {Clear();};
};

void CAS_FILE::Clear()
{
int i;
for (i=0; i<255; i++) {Name[i]=0;};
for (i=0; i<512; i++) {t[i].Clear();};
NumRec=0;
Boud=600;
}

int CAS_FILE::LoadHEX(char fn[])
{
cas.open(fn,ios::in);
cas.getline(Name,255);
Boud=600;
NumRec=0;
unsigned char end=1;
unsigned int i;
while (end)
 {
 cas >> i;
 if (!((cas.eof()) || (NumRec>511)))
  {
  t[NumRec].interval=i;
  cas >> t[NumRec].size;
  char hx[255];
  for (i=0; i<t[NumRec].size; i++)
     {
     cas >>hx;
     unsigned char a,b;
     a=hx[0];
     b=hx[1];
     if (a<='9') {a-='0';} else {a-='a';a+=10;};
     if (b<='9') {b-='0';} else {b-='a';b+=10;};
     t[NumRec].data[i]=a*16+b;
     };
  cas >>hx;
  cas >>hx;
  NumRec++;
  }
 else
  {
  end=0;
  };
 };
cas.close();
return 1;
};

int CAS_FILE::LoadCAS(char fn[])
{
cas.open(fn,ios::in | ios::binary);
unsigned int i;
char b;
cas.get(b);
if (b=='F')
 {
 for (i=0; i<3; i++) {cas.get(b);};
 cas.get(b);
 unsigned int o=(unsigned char)(b);
 for (i=0; i<3; i++) {cas.get(b);};
 for (i=0; i<o; i++) {cas.get(b);Name[i]=b;};
 Name[o]=0;
 for (i=0; i<4; i++) {cas.get(b);};
 cas.get(b);
 cas.get(b);
 cas.get(b);Boud=(unsigned char)(b);
 cas.get(b);Boud+=(unsigned int)((unsigned char)(b))<<8;
 unsigned char end=1;
 NumRec=0;
 while (end)
  {
  cas.get(b);
  if (b=='d')
   {
   for (i=0; i<3; i++) {cas.get(b);};
   cas.get(b);t[NumRec].size=(unsigned char)(b);
   cas.get(b);t[NumRec].size+=(unsigned int)((unsigned char)(b))<<8;
   cas.get(b);t[NumRec].interval=(unsigned char)(b);
   cas.get(b);t[NumRec].interval+=(unsigned int)((unsigned char)(b))<<8;
   for (i=0; i<t[NumRec].size; i++) {cas.get(b);t[NumRec].data[i]=b;};
   NumRec++;
   if (NumRec>512) {end=0;};
   }
  else
   {
   end=0;
   };
  };
 };
cas.close();
return 1;
};

char bh[3];
char *extraHEX(unsigned char v)
{
char ht[]="0123456789abcdef";
bh[0]=ht[v/16];bh[1]=ht[v%16];bh[2]=0;
return bh;
}

int CAS_FILE::SaveHEX(char fn[])
{
cas.open(fn,ios::out);
cas << Name << endl;
for (unsigned int i=0; i<NumRec; i++)
 {
 if (t[i].interval<10000) {cas << "0";};
 if (t[i].interval<1000) {cas << "0";};
 cas << t[i].interval <<" ";
 cas << t[i].size <<" ";
 for (unsigned int j=0; j<t[i].size; j++) {cas << extraHEX(t[i].data[j]) <<" ";};
 cas << extraHEX(t[i].Calculate_checksum()) << " ok" << endl;
 };
cas.close();
return 1;
};

int CAS_FILE::SaveCAS(char fn[])
{
cas.open(fn,ios::out | ios::binary);
// CAS Format
cas << "FUJI";
unsigned int i=0;
while ((Name[i]) && (i<255)) {i++;};
cas.put(i);
cas.put(0x00);
cas.put(0x00);
cas.put(0x00);
cas <<Name;
// 600 boud
cas <<"baud";
cas.put(0x00);
cas.put(0x00);
cas.put(Boud%256);
cas.put(Boud/256);

for (i=0; i<NumRec; i++)
 {
 cas << "data";
 cas.put(t[i].size%256);
 cas.put(t[i].size/256);
 cas.put(t[i].interval%256);
 cas.put(t[i].interval/256);
 for (unsigned int j=0; j<t[i].size; j++) {cas.put(t[i].data[j]);};
 };
cas.close();
return 1;
};

void CAS_FILE::Normalize(int s)
{
for (unsigned int i=0; i<NumRec; i++)
 {
 if (Boud<1300) {Boud=600;};
if (s)
 {
 if (t[i].interval>8000) {t[i].interval=20000;};
 if ((t[i].interval>=1000) && (t[i].interval<=8000)) {t[i].interval=3000;};
 if (t[i].interval<1000) {t[i].interval=250;};
 };
 if (t[i].size==132)
  {
  t[i].data[t[i].size-1]=t[i].Calculate_checksum();
  };
 };
};

// Status
// 0 - undefined
// 1 - standart block - sum ok
// 2 - standart block - sum bad
// 3 - standart block - not full
// 4 - nonstandart block - sum ok
// 5 - nonstandart block - sum bad

void CAS_FILE::Analize()
{
unsigned char status=0;
unsigned int i;
for (i=0; i<NumRec; i++)
   {
   t[i].Calculate_extrasum();
   if (t[i].data[t[i].size-1]==t[i].Calculate_checksum())
    {
    if (t[i].size==132) {status=1;}
    else {status=4;};
    }
   else
    {
    if (t[i].size==132) {status=2;}
    else {status=5;};
    };
   t[i].status=status;
   };
// Search "not full" standart block
for (i=0; i<NumRec; i++)
   {
   if (t[i].status==5)
    {
    for (unsigned int j=i+1; j<NumRec; j++)
     {
     if (t[j].size==132) {j=NumRec;t[i].status=3;};
     };
    };
   };
};
void CAS_FILE::ShowInfo(char fn[])
{
unsigned int b1=0,b2=0,b3=0,b4=0,b5=0;
for (unsigned int i=0; i<NumRec; i++)
 {
 switch (t[i].status)
  {
   case 1:{b1++;break;}
   case 2:{b2++;break;}
   case 3:{b3++;break;}
   case 4:{b4++;break;}
   case 5:{b5++;break;}
  };
 };
cout << fn <<endl;
cout << "File name: " << Name <<endl;
cout << "Num of Rec: " << NumRec <<endl;
cout << "Boud: " << Boud <<endl;
cout << "(1) Standart Record Sum OK: "<<b1<<endl;
cout << "(2) Standart Record Sum BAD: "<<b2<<endl;
cout << "(3) Standart Record - NOT FULL: "<<b3<<endl;
cout << "(4) Unknow Record Sum OK: "<<b4<<endl;
cout << "(5) Unknow Record Sum BAD: "<<b5<<endl;
cout << endl;
};
// END of CAS_FILE
//------------------------------------------

void Mes(unsigned int i,RECORD &a, RECORD &b, RECORD &c, char m[])
{
cout << "Record:"<<i;
cout <<" Status:"<<int(a.status)<<int(b.status)<<int(c.status);
cout <<" Out:"<<m<<endl;
};

unsigned char should(unsigned char a, unsigned char b, unsigned char c)
{
unsigned char o;
o=((b & c ) | ( a & c) | ( a & b) | ( a & b & c));
return o;
};

void Sort(CAS_FILE &a, CAS_FILE &b, CAS_FILE &c, CAS_FILE &o)
{
for (int n=0; ((n<255) && (a.Name[n])); n++)
 {o.Name[n]=a.Name[n];};
unsigned char end=1;
unsigned int al=0,bl=0,cl=0,ol=0;
while (end)
 {
 // All files have identical block
 if (((a.t[al].status==1) && (b.t[bl].status==1) && (c.t[cl].status==1)
       && (a.t[al]==b.t[bl]) && (b.t[al]==c.t[cl])) ||
    ((a.t[al].status==4) && (b.t[bl].status==4) && (c.t[cl].status==4)
       && (a.t[al]==b.t[bl]) && (b.t[al]==c.t[cl])))
        {
        o.t[ol]=a.t[al];
        Mes(ol,a.t[al],b.t[bl],c.t[cl],"perfect");
        al++; bl++; cl++; ol++; o.NumRec++;
        }
 // One file is bad
 else
 if (((a.t[al].status!=1) && (b.t[bl].status==1) && (c.t[cl].status==1)
       && (b.t[bl]==c.t[cl])) ||
    ((a.t[al].status!=4) && (b.t[bl].status==4) && (c.t[cl].status==4)
       && (b.t[bl]==c.t[cl])))
        {
        o.t[ol]=b.t[al];
        Mes(ol,a.t[al],b.t[bl],c.t[cl],"good");
        al++; bl++; cl++; ol++; o.NumRec++;
        }
 else
 if (((a.t[al].status==1) && (b.t[bl].status!=1) && (c.t[cl].status==1)
       && (a.t[al]==c.t[cl])) ||
    ((a.t[al].status==4) && (b.t[bl].status!=4) && (c.t[cl].status==4)
       && (a.t[bl]==c.t[cl])))
        {
        o.t[ol]=a.t[al];
        Mes(ol,a.t[al],b.t[bl],c.t[cl],"good");
        al++; bl++; cl++; ol++; o.NumRec++;
        }
 else
 if (((a.t[al].status==1) && (b.t[bl].status==1) && (c.t[cl].status!=1)
       && (a.t[al]==b.t[bl])) ||
    ((a.t[al].status==4) && (b.t[bl].status==4) && (c.t[cl].status!=4)
       && (a.t[bl]==b.t[cl])))
        {
        o.t[ol]=a.t[al];
        Mes(ol,a.t[al],b.t[bl],c.t[cl],"good");
        al++; bl++; cl++; ol++; o.NumRec++;
        }
 // One file is good
 else
 if (((a.t[al].status==1) && (b.t[bl].status!=1) && (c.t[cl].status!=1)) ||
    ((a.t[al].status==4) && (b.t[bl].status!=4) && (c.t[cl].status!=4)))
        {
        o.t[ol]=a.t[al];
        Mes(ol,a.t[al],b.t[bl],c.t[cl],"lucky1");
        al++; bl++; cl++; ol++; o.NumRec++;
        }
 else
 if (((a.t[al].status!=1) && (b.t[bl].status==1) && (c.t[cl].status!=1)) ||
    ((a.t[al].status!=4) && (b.t[bl].status==4) && (c.t[cl].status!=4)))
        {
        o.t[ol]=b.t[al];
        Mes(ol,a.t[al],b.t[bl],c.t[cl],"lucky2");
        al++; bl++; cl++; ol++; o.NumRec++;
        }
 else
 if (((a.t[al].status!=1) && (b.t[bl].status!=1) && (c.t[cl].status==1)) ||
    ((a.t[al].status!=4) && (b.t[bl].status!=4) && (c.t[cl].status==4)))
        {
        o.t[ol]=c.t[al];
        Mes(ol,a.t[al],b.t[bl],c.t[cl],"lucky3");
        al++; bl++; cl++; ol++; o.NumRec++;
        }
 // Repair
 else
 if (((a.t[al].status==2) && (b.t[bl].status==2) && (c.t[cl].status==2)) ||
    ((a.t[al].status==5) && (b.t[bl].status==5) && (c.t[cl].status==5) &&
     (a.t[al].size==b.t[bl].size) && (a.t[al].size==c.t[cl].size)))
        {
        int ok=1;
        o.t[ol]=a.t[al];
        for (unsigned int p=0; p<((a.t[al].size)-1); p++)
         {
         unsigned char aa,bb,cc,oo;
         aa=a.t[al].data[p];
         bb=b.t[bl].data[p];
         cc=c.t[cl].data[p];
         if (aa==bb) {oo=aa;}
         else
          {
          if (aa==cc) {oo=aa;}
          else
           {
           if (bb==cc) {oo=bb;}
           else {oo=should(aa,bb,cc); ok=0;};
           };
          };
         o.t[ol].data[p]=oo;
         };
        o.t[ol].data[o.t[ol].size-1]=o.t[ol].Calculate_checksum();
        if (ok) {Mes(ol,a.t[al],b.t[bl],c.t[cl],"repair");}
        else    {Mes(ol,a.t[al],b.t[bl],c.t[cl],"lost");};
        al++; bl++; cl++; ol++; o.NumRec++;
        }
 else
 if ((a.t[al].status==5) && (b.t[bl].status==5) && (c.t[cl].status==5))
        {
        o.t[ol]=a.t[al];
        Mes(ol,a.t[al],b.t[bl],c.t[cl],"imposible");
        al++; bl++; cl++; ol++; o.NumRec++;
        }
 else
 // Synchornize
        {
        unsigned int aa=al,ab=bl,ac=cl;
        unsigned int ba=al,bb=bl,bc=cl;
        unsigned int ca=al,cb=bl,cc=cl;
        unsigned int s;
        al++;
        for (s=al; s<a.NumRec; s++)
                {if (a.t[s].status<3) {aa=s;s=a.NumRec;};};
        for (s=bl; s<b.NumRec; s++)
                {if (a.t[aa]==b.t[s]) {ab=s;s=b.NumRec;};};
        for (s=cl; s<c.NumRec; s++)
                {if (a.t[aa]==c.t[s]) {ac=s;s=c.NumRec;};};
        bl++;
        for (s=bl; s<b.NumRec; s++)
               {if (b.t[s].status<3) {bb=s;s=b.NumRec;};};
        for (s=al; s<a.NumRec; s++)
               {if (b.t[bb]==a.t[s]) {ba=s;s=a.NumRec;};};
        for (s=cl; s<c.NumRec; s++)
               {if (b.t[bb]==c.t[s]) {bc=s;s=c.NumRec;};};
        cl++;
        for (s=cl; s<c.NumRec; s++)
               {if (c.t[s].status<3) {cc=s;s=c.NumRec;};};
        for (s=al; s<a.NumRec; s++)
               {if (c.t[cc]==a.t[s]) {ca=s;s=a.NumRec;};};
        for (s=bl; s<b.NumRec; s++)
               {if (c.t[cc]==b.t[s]) {cb=s;s=b.NumRec;};};
        if ((aa<<bb) && (aa<<cc)) {al=aa;bl=ab;cl=ac;};
        if ((bb<<aa) && (bb<<cc)) {al=ba;bl=bb;cl=bc;};
        if ((cc<<aa) && (cc<<bb)) {al=ca;bl=cb;cl=cc;};
        cout << "Synchronize "<<al<<" "<<bl<<" "<<cl<<endl;
        };
 if ((al==a.NumRec) || (bl==b.NumRec) || (cl==c.NumRec))
        {end=0;};
 };
cout << endl;
};

//-----------------------------------------------------------------
//                               MAIN
//-----------------------------------------------------------------
CAS_FILE file1;
CAS_FILE file2;
CAS_FILE file3;
CAS_FILE file_out;

void main(int argc, char *argv[])
{
 int i;
 int orgsp=1;
 cout << "CAS2CAS v0.2"<<endl;
 cout << "by Gienek plug@poczta.fm"<<endl<<endl;
 if ( (!( argc == 5 )) && (!( argc == 6 )) )
        {
        cout << "Use: CAS2CAS file1.cas file2.cas file3.hex good.cas"<<endl;
	cout << "or" << endl; 
        cout << "Use: CAS2CAS file1.cas file2.cas file3.hex good.cas -orgsp"<<endl;
        }
 else
 {
 if ( argc == 6 )
        {
	orgsp=0;
	};
 // Load File1
 i=0;
 while ((argv[1][i]) && (i<255)) {i++;};
 if ((argv[1][i-1]=='s') || (argv[1][i-1]=='S')) {file1.LoadCAS(argv[1]);}
 else {file1.LoadHEX(argv[1]);};
 // Load File2
 i=0;
 while ((argv[2][i]) && (i<255)) {i++;};
 if ((argv[2][i-1]=='s') || (argv[2][i-1]=='S')) {file2.LoadCAS(argv[2]);}
 else {file2.LoadHEX(argv[2]);};
 // Load File3
 i=0;
 while ((argv[3][i]) && (i<255)) {i++;};
 if ((argv[3][i-1]=='s') || (argv[3][i-1]=='S')) {file3.LoadCAS(argv[3]);}
 else {file3.LoadHEX(argv[3]);};
 file1.Analize();
 file1.ShowInfo(argv[1]);
 file2.Analize();
 file2.ShowInfo(argv[2]);
 file3.Analize();
 file3.ShowInfo(argv[3]);
 // Search best result
 Sort(file1,file2,file3,file_out);
 // End search
 file_out.Normalize(orgsp);
 file_out.Analize();
 file_out.ShowInfo(argv[4]);
 // Save CAS/HEX FILE
 i=0;
 while ((argv[4][i]) && (i<255)) {i++;};
 if ((argv[4][i-1]=='s') || (argv[4][i-1]=='S')) {file_out.SaveCAS(argv[4]);}
 else {file_out.SaveHEX(argv[4]);};
 cout << "Done" << endl;
 };
}
