program bin2mif;

{$APPTYPE CONSOLE}

uses
  SysUtils;
  { TODO -oUser -cConsole Main : Insert code here }
const
  Digits         : array[0..$F] of Char = '0123456789ABCDEF';

  function HexW(W : Word) : String;
  var
    TmpStr : string;
  begin
    SetLength(TmpStr, 4);
    TmpStr[1] := Digits[Hi(W) shr 4];
    TmpStr[2] := Digits[Hi(W) and $F];
    TmpStr[3] := Digits[Lo(W) shr 4];
    TmpStr[4] := Digits[Lo(W) and $F];
    HexW := TmpStr;
  end;

  function HexB(B : byte) : String;
  var
    TmpStr : string;
  begin
    SetLength(TmpStr, 2);
    TmpStr[1] := Digits[B shr 4];
    TmpStr[2] := Digits[B and $F];
    HexB := TmpStr;
  end;
                                   
var
  InFile : file of byte;
  OutFile : text;
  Count : word;
  InByte : byte;
  InFileSize : longint;
  S : string;
begin
  if ParamCount <> 2 then
    begin
      WriteLn('Usage : bin2mif bin_file_name mif_file_name');
      exit;
    end;
  Assign(InFile,ParamStr(1));
{$I-}
  Reset(InFile);
  if IOResult <> 0 then
    begin
      WriteLn('bin2mif error : can''t open file ',ParamStr(1));
      exit;
    end;
  Assign(OutFile,ParamStr(2));
  ReWrite(OutFile);
  if IOResult <> 0 then
    begin
      WriteLn('bin2mif error : can''t create file ',ParamStr(2));
      close(InFile);
      exit;
    end;
{$I+}
  InFileSize := FileSize(InFile);
  if InFileSize > $FFFF then
    begin
      WriteLn('bin2mif error : input file is too large.');
      close(InFile);
      close(OutFile);
      exit;
    end;
{    Writeln(OutFile, 'DEPTH = 512;');}
    Writeln(OutFile, 'DEPTH = ', InFileSize, ';');
    Writeln(OutFile, 'WIDTH = 8;');
    Writeln(OutFile);
    Writeln(OutFile, 'ADDRESS_RADIX = HEX;');
    Writeln(OutFile, 'DATA_RADIX = HEX;');
    Writeln(OutFile);
    Writeln(OutFile, 'CONTENT');
    Writeln(OutFile, '  BEGIN');
    Count := 0;
    while not Eof(InFile) do
      begin
        Read(InFile,InByte);
        S :=  '    ' + HexW(Count) + ' :  ' + HexB(InByte) + ' ;';
        Writeln(OutFile, S);
        inc(Count);
      end;
  Writeln(OutFile, '  END;');

  close(InFile);
  close(OutFile);

end.
