bool WINAPI extract( BYTE* source, HANDLE dest, DWORD )
{

  BYTE *from = source + sizeof(HoHdr);

  if( from[0] != 'H' || from[1] != 'R' ) from += 0x103;

  BBStream s( from + 12, from[4] + 256*from[5] );

  BYTE  result[0xffff];
  BYTE* to = result;

  *to++ = s.getByte();

  BYTE noBits = 2;
  BYTE mask[] = { 0, 0, 0xfc, 0xf8, 0xf0, 0xe0, 0xc0, 0x80, 0 };

  while( !s.error() )
  {
    while( s.getBit() ) *to++ = s.getByte();

    WORD len = 0;
    BYTE bb  = 0;
    do
    {
      bb = s.getBits( 2 );
      len += bb;
    } while( bb == 0x03 && len != 0x0f );

    short offset = 0;

    if( len == 0 )
    {
      offset = 0xfff8 + s.getBits( 3 );
      *to++ = to[offset];
      continue;
    }

    if( len == 1 )
    {
      BYTE code = s.getBits(2);

      if( code == 2 )
      {
        BYTE b = s.getByte();
        if( b >= 0xe0 )
        {
          b <<= 1; ++b; // rlca
          b ^= 2;       // xor c

          if( b == 0xff ) { ++noBits; continue; }

          offset = 0xff00 + b - 0x0f;

          *to++ = to[offset];
          *to++ = s.getByte();
          *to++ = to[offset];
          continue;
        }
        offset = 0xff00 + b;
      }

      if( code == 0 || code == 1 )
      {
        offset = s.getByte();
        offset += 256*(code ? 0xfe : 0xfd );
      }
      if( code == 3 ) offset = 0xffe0 + s.getBits( 5 );

      for( BYTE i = 0; i < 2; ++i ) *to++ = to[offset];
      continue;
    }

    if( len == 3 )
    {
      if( s.getBit() )
      {
        offset = 0xfff0 + s.getBits( 4 );
        *to++ = to[offset];
        *to++ = s.getByte();
        *to++ = to[offset];
        continue;
      }

      if( s.getBit() )
      {
        BYTE noBytes = 6 + s.getBits(4);
        for( BYTE i = 0; i < 2*noBytes; ++i ) *to++ = s.getByte();
        continue;
      }

      len = s.getBits( 7 );
      if( len == 0x0f ) break; // EOF
      if( len <  0x0f ) len = 256*len + s.getByte();
    }

    if( len == 2 ) ++len;

    BYTE code = s.getBits( 2 );

    if( code == 1 )
    {
      BYTE b = s.getByte();

      if( b >= 0xe0 )
      {
        if( len > 3 ) return false;

        b <<= 1; ++b; // rlca
        b ^= 3;       // xor c

        offset = 0xff00 + b - 0x0f;

        *to++ = to[offset];
        *to++ = s.getByte();
        *to++ = to[offset];
        continue;
      }
      offset = 0xff00 + b;
    }

    if( code == 0 ) offset = 0xfe00 + s.getByte();
    if( code == 2 ) offset = 0xffe0 + s.getBits( 5 );
    if( code == 3 )
    {
      offset  = 256*( mask[noBits] + s.getBits(noBits) );
      offset += s.getByte();
    }

    for( WORD i = 0; i < len; ++i ) *to++ = to[offset];
  }

  for( int i = 0; i < 6; ++i ) *to++ = from[6+i];

  DWORD write;
  WriteFile( dest, result, to-result, &write, 0 );

  return true;
}
