library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity system is
  Port(clk            : in     std_logic;
-- PARALLEL ADC1 (AD9214)
       ad9214_data1   : in     std_logic_vector(9 downto 0);
       ad9214_or1     : in     std_logic;
       ad9214_encode1 : out    std_logic;
-- PARALLEL ADC2 (AD9214)
       ad9214_data2   : in     std_logic_vector(9 downto 0);
       ad9214_or2     : in     std_logic;
       ad9214_encode2 : out    std_logic;
-- LEDS       
       led_1          : out    std_logic;  
       led_2          : out    std_logic;
-- Interrupt outputs
       INT0           : out    std_logic;  
       INT1           : out    std_logic;  
       INT2           : out    std_logic;  
       INT3           : out    std_logic;  
-- System BUS
       Mux_BUS_L      : inout  std_logic_vector(7 downto 0);              
       Mux_BUS_M      : in     std_logic_vector(7 downto 0);              
       ALE            : in     std_logic;
       RD             : in     std_logic;
       WR             : in     std_logic
      );
end system;

architecture Behavioral of system is
  component led_blink is
    Port(clk 	      : in     std_logic;
         led_A        : out    std_logic;
         led_B        : out    std_logic
        );        
  end component led_blink;
  component addr_bus is
    Port(--clk          : in     std_logic;
         ale          : in     std_logic;
         addr_l       : in     std_logic_vector(7 downto 0);
         addr_h       : in     std_logic_vector(7 downto 0);
         addrSys      : out    std_logic_vector(15 downto 0)
        );
  end component addr_bus;  
  signal ledStatus1   : std_logic;
  signal ledStatus2   : std_logic;
  signal temp         : std_logic;
  signal addrSysBus   : std_logic_vector(15 downto 0);
  begin
--    
  write_proc: process(clk)
    begin
     if clk'event and clk='1' then
       if WR = '0' then          
         case (addrSysBus) is
            when X"1200"  => led_1     <= Mux_BUS_L(0); ledStatus1 <= Mux_BUS_L(0);
            when X"1300"  => led_1     <= Mux_BUS_L(0); ledStatus2 <= Mux_BUS_L(0);
            when others => null;
         end case;
       elsif RD = '0' then
         case (addrSysBus) is
            when X"1200"  => Mux_BUS_L <= X"BA";--ledStatus1;
            when X"1300"  => Mux_BUS_L <= X"AF";--ledStatus2;
            when others => null;
         end case;
       --else
       --  lcd_strobe <= '0';
       end if;
     end if;
  end process;

  
--    
  --led_inst: led_blink 
  --Port map(clk            => clk, 
  --         led_A          => led_1, 
  --         led_B          => led_2
  --        );
--                
  addr_bus_inst: addr_bus
  Port map(--clk            => clk,
           ale            => ALE,
           addr_l         => Mux_BUS_L,
           addr_h         => Mux_BUS_M,
           addrSys        => addrSysBus
          ); 

end Behavioral;
