--------------------------------------------------------------------------------
--     : "ZXKit1 -  VGA & PAL"                  --                        
--  :  V1.0.0.22                                          : 090728  --
--  :                                                     --
--                                                                            --
--  : EPM3128ATC100-10 (128 MACROCELLS,  TQFP100)                   --
--  :  K6R4016V1D-TI10 (256K * 16 )                                     --
--   : 14 ,                              --
--   : Quartus II Version 9.0 Web Edition                      --
--------------------------------------------------------------------------------

-- Compilation Report:
-- Warnings        = 21
-- Total macrocels = 112/128
-- Total pins      = 63/116

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
entity VGA_PAL is
	port
	(
--------------------------------------------------------------------------------
--                                       090722  --
--------------------------------------------------------------------------------

R_IN          : in std_logic := '1'; --  RED
G_IN          : in std_logic := '1'; --  GREEN
B_IN          : in std_logic := '1'; --  BLUE
I_IN          : in std_logic := '1'; --  BRIGHT

KSI_IN        : in std_logic := '1'; --  
SSI_IN        : in std_logic := '1'; --  
--F14MHZ        : in std_logic := '1'; --    14 
F14        : in std_logic := '1'; --    14 


--------------------------------------------------------------------------------
--              /               090722  --
--------------------------------------------------------------------------------

INVERSE_RGBI  : in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .
                                      
INVERSE_KSI   : in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .
                                      
INVERSE_SSI   : in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .
                                      
INVERSE_F14MHZ: in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .

VGA_SCART     : in std_logic := '1'; --     VGA: 
                                     -- 0 -  SCART, 1 -  VGA.

SET_FK_IN     : in std_logic := '1'; --    : 
                                     -- 0 - 50 (312 ), 1 - 48 (320 .)
                                      
SET_FK_OUT    : in std_logic := '1'; --    : 
                                     -- 0 - 60 , 1 - 50/48 .


--------------------------------------------------------------------------------
--                         VGA                    090722  --
--------------------------------------------------------------------------------

R_VGA         : out std_logic := '1'; --  RED
G_VGA         : out std_logic := '1'; --  GREEN
B_VGA         : out std_logic := '1'; --  BLUE

IR_VGA        : out std_logic := '1'; --  BRIGHT  RED  ( 0/Z)
IG_VGA        : out std_logic := '1'; --  BRIGHT  GREEN( 0/Z)
IB_VGA        : out std_logic := '1'; --  BRIGHT  BLUE ( 0/Z)

VSYNC_VGA     : out std_logic := '1'; --  /. SCART
HSYNC_VGA     : out std_logic := '1'; --  /enable RGB SCART


--------------------------------------------------------------------------------
--                         VIDEO                  090722  --
--------------------------------------------------------------------------------

R_VIDEO       : out std_logic := '1'; --  RED
G_VIDEO       : out std_logic := '1'; --  GREEN
B_VIDEO       : out std_logic := '1'; --  BLUE

IR_VIDEO      : out std_logic := '1'; --  BRIGHT  RED  ( 0/Z)
IG_VIDEO      : out std_logic := '1'; --  BRIGHT  GREEN( 0/Z)
IB_VIDEO      : out std_logic := '1'; --  BRIGHT  BLUE ( 0/Z)

SYNC_VIDEO    : out std_logic := '1'; --     .


--------------------------------------------------------------------------------
--                                             090722  --
--------------------------------------------------------------------------------

A             : out std_logic_vector(17 downto 0) := "ZZZZZZZZZZZZZZZZZZ"; -- 

WE            : out std_logic := '1'; --       
OE            : out std_logic := '1'; --       
UB            : out std_logic := '1'; --     (D15..D8)
LB            : out std_logic := '1'; --      (D7..D0)


--------------------------------------------------------------------------------
--                                      090727  --
--------------------------------------------------------------------------------

D             : inout std_logic_vector(7 downto 0) := "ZZZZZZZZ" -- 

	);
    end VGA_PAL;
architecture RTL of VGA_PAL is

--------------------------------------------------------------------------------
--                                               090722  --
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--                                       090722  --
--------------------------------------------------------------------------------

signal R      : std_logic := '1'; --  RED
signal G      : std_logic := '1'; --  GREEN
signal B      : std_logic := '1'; --  BLUE
signal I      : std_logic := '1'; --  BRIGHT

signal KSI    : std_logic := '1'; --  
signal SSI    : std_logic := '1'; --  
--signal F14    : std_logic := '1'; --    14 

--------------------------------------------------------------------------------
--                                            090726  --
--------------------------------------------------------------------------------

signal R2     : std_logic := '1'; --  RED
signal G2     : std_logic := '1'; --  GREEN
signal B2     : std_logic := '1'; --  BLUE
signal I2     : std_logic := '1'; --  BRIGHT

signal R3     : std_logic := '1'; --  RED      --    
signal G3     : std_logic := '1'; --  GREEN
signal B3     : std_logic := '1'; --  BLUE
signal I3     : std_logic := '1'; --  BRIGHT

signal R4     : std_logic := '1'; --  RED
signal G4     : std_logic := '1'; --  GREEN
signal B4     : std_logic := '1'; --  BLUE
signal I4     : std_logic := '1'; --  BRIGHT

--------------------------------------------------------------------------------
--                                           090726  --
--------------------------------------------------------------------------------

signal KSI_2  : std_logic; --   
signal SSI_2  : std_logic; --   

--------------------------------------------------------------------------------
--                     VGA  VIDEO              090726  --
--------------------------------------------------------------------------------

signal VGA_H  : std_logic_vector(8 downto 0); -- .     VGA
signal VGA_V  : std_logic_vector(9 downto 0); -- .      VGA

signal VIDEO_H: std_logic_vector(9 downto 0); -- .     VIDEO
signal VIDEO_V: std_logic_vector(8 downto 0); -- .      VIDEO


--------------------------------------------------------------------------------
--                       VGA  VIDEO                 090726  --
--------------------------------------------------------------------------------

signal VGA_KSI     : std_logic; --    VGA
signal VGA_SSI     : std_logic; --    VGA

signal VIDEO_KSI   : std_logic; --    VIDEO
signal VIDEO_SSI1  : std_logic; --     VIDEO
signal VIDEO_SSI2  : std_logic; --   .  VIDEO
signal VIDEO_SSI3  : std_logic; --   -   VIDEO
signal VIDEO_SYNC  : std_logic; --   VIDEO

--------------------------------------------------------------------------------
--                       VGA  VIDEO                090726  --
--------------------------------------------------------------------------------

signal VGA_KGI     : std_logic; --     VGA
signal VGA_SGI     : std_logic; --     VGA
signal VGA_BLANK   : std_logic; --    VGA

signal VIDEO_KGI   : std_logic; --     VIDEO
signal VIDEO_SGI   : std_logic; --     VIDEO
signal VIDEO_BLANK : std_logic; --   VIDEO

--------------------------------------------------------------------------------
--                                      090726  --
--------------------------------------------------------------------------------

signal WR_REG     : std_logic_vector(7 downto 0); --  3-R, 2-G, 1-B, 0-I

--------------------------------------------------------------------------------
--                                      090726  --
--------------------------------------------------------------------------------

signal RD_REG     : std_logic_vector(7 downto 0); --  3-R, 2-G, 1-B, 0-I

begin

--------------------------------------------------------------------------------
--                                                            090726  --
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--                                         090726  --
--------------------------------------------------------------------------------

--   /    ON, 
--    ,   .
--          F14

--------------------------------------------------------------------------------
--   :
-- F14 <= F14MHZ when INVERSE_F14MHZ = '1' else not F14MHZ;

--------------------------------------------------------------------------------
process (F14)    --   ,    
begin
  if (falling_edge(F14)) then  --    ,   1  0
--------------------------------------------------------------------------------
      if (INVERSE_RGBI = '1') then --    :
          R <= R_IN;               --    
          G <= G_IN;
          B <= B_IN;
          I <= I_IN;  
--------------------------------------------------------------------------------
      else                         -- :
          R <= not R_IN;           --   
          G <= not G_IN;
          B <= not B_IN;
          I <= not I_IN;          
      end if;
--------------------------------------------------------------------------------
      if (INVERSE_KSI = '1') then  --   
          KSI <= KSI_IN;
      else
          KSI <= not KSI_IN;
      end if;
--------------------------------------------------------------------------------
      if (INVERSE_SSI = '1') then  --   
          SSI <= SSI_IN;
      else
          SSI <= not SSI_IN;
      end if;
--------------------------------------------------------------------------------
  end if;
--------------------------------------------------------------------------------
--                              090725  --
--------------------------------------------------------------------------------
  if (rising_edge(F14)) then  --    ,   0  1
      SSI_2 <= SSI;           --   - 
      KSI_2 <= KSI;           --   
  end if;
end process;


--process (F14) 
--begin
--end process;


--------------------------------------------------------------------------------
--                                   090726  --
--------------------------------------------------------------------------------
process (F14, SSI, SSI_2)
begin
  if (SSI = '0') and (SSI_2 = '1') then --    :
      
      VGA_H   <= (others => '0');       --     
      VIDEO_H <= (others => '0');
      
  elsif (falling_edge(F14)) then        -- ,    :
      
      if (VGA_H = 447) then             --    VGA,
          VGA_H <= (others => '0');     --   VGA
      else
          VGA_H   <= VGA_H   + 1;       --  -    VGA
      end if;    

      VIDEO_H <= VIDEO_H + 1;           --    VIDEO,
      
  end if;   
end process;


--------------------------------------------------------------------------------
--                                     090726  --
--------------------------------------------------------------------------------

process (KSI, KSI_2, VGA_H(8), VIDEO_H(9))
begin
  if (KSI = '0') and (KSI_2 = '1') then --    :
      

      VIDEO_V <= (others => '0');       --    VIDEO

    else                                -- :
--------------------------------------------------------------------------------
      if (falling_edge(VGA_H(8))) then  --      

          --     60      :
          if (SET_FK_OUT = '0') and (VGA_V = 523) then
              VGA_V <= (others => '0');     --    VGA
          else                              --  
              VGA_V   <= VGA_V   + 1;       --    VGA
          end if;    
          
      end if;    
--------------------------------------------------------------------------------
      if (falling_edge(VIDEO_H(9))) then    --   .   
          VIDEO_V <= VIDEO_V + 1;           --    VIDEO,
      end if;    
--------------------------------------------------------------------------------
  end if;   
end process;

--------------------------------------------------------------------------------
--                                       090726  --
--------------------------------------------------------------------------------
A(17) <= '0'; --   

process (SET_FK_OUT, VIDEO_H, VIDEO_V, VGA_V)
begin
  
  if (VIDEO_H(0) = '1') then --     :
--------------------------------------------------------------------------------
      A(7 downto 0)  <= VIDEO_H(9 downto 2); -- .  -   VIDEO
--------------------------------------------------------------------------------
      if (SET_FK_OUT = '1') then        --     50/48 
          A(16 downto 8) <= "00000000" & VIDEO_V(0); --   
      else                     -- , 60 :
          A(16 downto 8) <= VIDEO_V(8 downto 0);
      end if;    
   else                       -- ,    :    
--------------------------------------------------------------------------------
      A(7 downto 0)  <= VGA_V(8 downto 1);   -- .  -   VGA
--------------------------------------------------------------------------------
      if SET_FK_OUT = '1' then --     50/48 :
          A(16 downto 8) <= "00000000" & (not VIDEO_V(0)); --  
      else                     -- , 60 :
          A(16 downto 8) <= VGA_V(9 downto 1);
      end if;  

  end if;   
end process;


--------------------------------------------------------------------------------
--                                              090726  --
--------------------------------------------------------------------------------
--      (    WE) 
D(7 downto 0) <= WR_REG when VIDEO_H(0) = '1' else (others => 'Z');

process (F14, VIDEO_H)                   
begin
  if (rising_edge(F14) and VIDEO_H(0) = '0') then --   OE
--------------------------------------------------------------------------------
      --     VIDEO      
      if VIDEO_H(1) = '0' then  
--          WR_REG(3) <= R2; --      
--          WR_REG(2) <= G2;
--          WR_REG(1) <= B2;
--          WR_REG(0) <= I2;
      else
--          WR_REG(7) <= R2; --      
--          WR_REG(6) <= G2;
--          WR_REG(5) <= B2;
--          WR_REG(4) <= I2;
      end if;
--------------------------------------------------------------------------------
      --            VGA
      RD_REG <= D(7 downto 0);
--------------------------------------------------------------------------------
  end if;
end process;



--------------------------------------------------------------------------------
--                                   090726  --
--------------------------------------------------------------------------------

--       
WE <= '0' when (VIDEO_H(1) = '1' and VIDEO_H(0) = '1' and F14 = '0') else '1';
--       
OE <= '0' when (VIDEO_H(0) = '0' and F14 = '0') else '1';
UB <= '1'; --    (D15..D8)   
LB <= '0'; --      (D7..D0)


--------------------------------------------------------------------------------
--                                       090726  --
--------------------------------------------------------------------------------
--    VGA
VGA_SSI    <= '0' when VGA_H < 53 else '1';

--     VGA
VGA_SGI    <= '0' when VGA_H < 80 or VGA_H > 438 else '1';

--     VIDEO
VIDEO_SSI1 <= '0' when VIDEO_H < 66 else '1';

--     VIDEO
VIDEO_SSI2 <= '0' when VIDEO_H < 33 or (VIDEO_H >447 and VIDEO_H <481) else '1';

--   -   VIDEO
VIDEO_SSI3 <= '0' when VIDEO_H <382 or (VIDEO_H >447 and VIDEO_H <830) else '1';

--     VIDEO
VIDEO_SGI  <= '0' when VIDEO_H < 147 or VIDEO_H > 874 else '1';


--------------------------------------------------------------------------------
--                                       090726  --
--------------------------------------------------------------------------------
--    VGA
VGA_KSI    <= '0' when VGA_V = 10 or VGA_V = 11 else '1';

--     VGA
VGA_KGI    <= '0' when VGA_V < 45 else '1';

--    VIDEO
VIDEO_KSI  <= '0' when VIDEO_V = 3 or VIDEO_V = 4 
                                 or (VIDEO_V = 5 and VIDEO_H(9) = '0') else '1';

--     VIDEO
VIDEO_KGI  <= '0' when VIDEO_V < 8 else '1';


--------------------------------------------------------------------------------
--                       VIDEO              090726  --
--------------------------------------------------------------------------------
process (VIDEO_KGI, VIDEO_KSI, VIDEO_SSI1, VIDEO_SSI2, VIDEO_SSI3)
begin
if VIDEO_KGI = '0' then           --     :

    if VIDEO_KSI = '0' then       --   :    
        VIDEO_SYNC <= VIDEO_SSI3; --   -   VIDEO    
    else                          -- ,     :    
        VIDEO_SYNC <= VIDEO_SSI2; --     :    
    end if;

else
        VIDEO_SYNC <= VIDEO_SSI1; --     VIDEO
end if;    
end process;


--------------------------------------------------------------------------------
--                                   090726  --
--------------------------------------------------------------------------------

--    VGA
VGA_BLANK   <= '0' when VGA_KGI   = '0' or VGA_SGI   = '0' else '1';

--    VIDEO
VIDEO_BLANK <= '0' when VIDEO_KGI = '0' or VIDEO_SGI = '0' else '1';


--------------------------------------------------------------------------------
--                      RGBI VIDEO                090726  --
--------------------------------------------------------------------------------
--  VIDEO
R2  <= '0' when VIDEO_BLANK = '0' else R; 
G2  <= '0' when VIDEO_BLANK = '0' else G;
B2  <= '0' when VIDEO_BLANK = '0' else B;
I2  <= '0' when VIDEO_BLANK = '0' else I;

--      
R3  <= RD_REG(3) when VIDEO_H(0) = '0' else RD_REG(7);
G3  <= RD_REG(2) when VIDEO_H(0) = '0' else RD_REG(6);
B3  <= RD_REG(1) when VIDEO_H(0) = '0' else RD_REG(5);
I3  <= RD_REG(0) when VIDEO_H(0) = '0' else RD_REG(4);

--  VGA
R4  <= '0' when VGA_BLANK = '0' else R3;  
G4  <= '0' when VGA_BLANK = '0' else G3;
B4  <= '0' when VGA_BLANK = '0' else B3;
I4  <= '0' when VGA_BLANK = '0' else I3;

--------------------------------------------------------------------------------
--                          VGA                  090726  --
--------------------------------------------------------------------------------
process (F14) 
begin
  if (rising_edge(F14)) then   --    ,   0  1
--if (falling_edge(F14)) then  --    ,   1  0
    
    if VGA_SCART = '1' then    --     VGA: 
    
      R_VGA  <= R4;            --    
      G_VGA  <= G4;
      B_VGA  <= B4;

      if I4 = '0'  then        --   :
          IR_VGA <= '0';       --      0
          IG_VGA <= '0';
          IB_VGA <= '0';
      else
          IR_VGA <= 'Z';       --  
          IG_VGA <= 'Z';
          IB_VGA <= 'Z';
      end if;

      VSYNC_VGA <= VGA_KSI;    --    VGA
      HSYNC_VGA <= VGA_SSI;    --    VGA
    
    else                       -- ,    SCART
    
      R_VGA  <= R2;            --    
      G_VGA  <= G2;
      B_VGA  <= B2;

      if I2 = '0'  then        --   :
          IR_VGA <= '0';       --      0
          IG_VGA <= '0';
          IB_VGA <= '0';
      else
          IR_VGA <= 'Z';       --  
          IG_VGA <= 'Z';
          IB_VGA <= 'Z';
      end if;

      VSYNC_VGA <= VIDEO_SYNC; --  VIDEO
      HSYNC_VGA <= '1';        --  RGB  SCART
    
    end if;
  end if;
end process;


--------------------------------------------------------------------------------
--                         PAL-CODER                   090726  --
--------------------------------------------------------------------------------
process (F14) 
begin
  if (rising_edge(F14)) then   --    ,   0  1
--  if (falling_edge(F14)) then  --    ,   1  0
  
      R_VIDEO  <= R2;          --    
      G_VIDEO  <= G2;
      B_VIDEO  <= B2;

      if I2 = '0'  then        --   :
          IR_VIDEO <= '0';     --      0
          IG_VIDEO <= '0';
          IB_VIDEO <= '0';
      else
          IR_VIDEO <= 'Z';     --  
          IG_VIDEO <= 'Z';
          IB_VIDEO <= 'Z';
      end if;

      SYNC_VIDEO <= VIDEO_SYNC;--   VIDEO

  end if;
end process;



--------------------------------------------------------------------------------

end RTL;

