--------------------------------------------------------------------------------
--     : "ZXKit1 -  VGA & PAL"                  --                        
--  :  V2.0.2.01                                          : 090830  --
--  :                                                     --
--                                                                            --
--  : EPM3128ATC100-10 (128 MACROCELLS,  TQFP100)                   --
--  :  K6R4016V1D-TI10 (256K * 16 )                                     --
--   : 14 ,                              --
--   : Quartus II Version 9.0 Web Edition                      --
--------------------------------------------------------------------------------

-- Compilation Report:
-- Warnings        = 39
-- Total macrocels = 122/128
-- Total pins      = 64/80

library IEEE;
library altera; 
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
use altera.altera_primitives_components.all;

entity VGA_PAL is
	port
	(

--------------------------------------------------------------------------------
--                                       090817  --
--------------------------------------------------------------------------------

R_IN          : in std_logic := '1'; --  RED
G_IN          : in std_logic := '1'; --  GREEN
B_IN          : in std_logic := '1'; --  BLUE
I_IN          : in std_logic := '1'; --  BRIGHT

KSI_IN        : in std_logic := '1'; --  
SSI_IN        : in std_logic := '1'; --  
F14        : in std_logic := '1'; --    14 
--SYNC_IN       : in std_logic := '1'; 


--------------------------------------------------------------------------------
--              /               090812  --
--------------------------------------------------------------------------------

INVERSE_RGBI  : in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .
                                      
INVERSE_KSI   : in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .
                                      
INVERSE_SSI   : in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .
                                      
INVERSE_F14MHZ: in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .

VGA_SCART     : in std_logic := '1'; --     VGA: 
                                     -- 0 -  SCART, 1 -  VGA.

SET_FK_IN     : in std_logic := '1'; --    : 
                                     -- 0 - 50 (312 ), 1 - 48 (320 .)
                                      
SET_FK_OUT    : in std_logic := '1'; --    : 
                                     -- 1 - 60 , 0 - 50/48 .

--------------------------------------------------------------------------------
--                         VGA                    090830  --
--------------------------------------------------------------------------------

R_VGA     : out std_logic := '0'; --  RED
G_VGA     : out std_logic := '0'; --  GREEN
B_VGA     : out std_logic := '0'; --  BLUE
I_VGA     : out std_logic_vector (2 downto 0) := "000"; --   VGA

VSYNC_VGA : buffer std_logic := '1'; --  /. SCART
HSYNC_VGA : buffer std_logic := '1'; --  /enable RGB SCART



--------------------------------------------------------------------------------
--                         VIDEO                  090830  --
--------------------------------------------------------------------------------

--R_VIDEO  : out std_logic := '0'; --  RED
--G_VIDEO  : out std_logic := '0'; --  GREEN
--B_VIDEO  : out std_logic := '0'; --  BLUE
--I_VIDEO  : out std_logic_vector (2 downto 0) := "000"; --   VIDEO

SYNC_VIDEO : out std_logic := '1'; --     .


--------------------------------------------------------------------------------
--                                             090803  --
--------------------------------------------------------------------------------
A17        : out std_logic; --     
A          : out std_logic_vector(16 downto 0); -- 

WE         : out std_logic := '1'; --       
OE         : buffer std_logic := '1'; --       
UB         : out std_logic := '1'; --      (D15..D8)
LB         : out std_logic := '1'; --       (D7..D0)


--------------------------------------------------------------------------------
--                                      090821  --
--------------------------------------------------------------------------------

D          : inout std_logic_vector(15 downto 0) := "ZZZZZZZZZZZZZZZZ" -- 

	);
    end VGA_PAL;
architecture RTL of VGA_PAL is

--------------------------------------------------------------------------------
--                                               090804  --
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--                                       090805  --
--------------------------------------------------------------------------------

signal R      : std_logic; --  RED
signal G      : std_logic; --  GREEN
signal B      : std_logic; --  BLUE
signal I      : std_logic; --  BRIGHT
signal RGBI_CLK : std_logic; --     

--signal KSI_IN : std_logic; --     1/4  3/4 
signal KSI    : std_logic; --  
signal SSI    : std_logic; --  

--------------------------------------------------------------------------------
--                                            090826  --
--------------------------------------------------------------------------------
signal R3        : std_logic; --  RED      --    
signal G3        : std_logic; --  GREEN
signal B3        : std_logic; --  BLUE
signal I3        : std_logic; --  BRIGHT
signal I_VGA_COM : std_logic; --   BRIGHT  VGA

--------------------------------------------------------------------------------
--                                           090726  --
--------------------------------------------------------------------------------

signal KSI_2  : std_logic; --   
signal SSI_2  : std_logic; --   

--------------------------------------------------------------------------------
--                     VGA  VIDEO              090803  --
--------------------------------------------------------------------------------

signal VGA_H  : std_logic_vector(8 downto 0); -- .     VGA
signal VGA_V  : std_logic_vector(9 downto 0); -- .      VGA

signal VIDEO_H: std_logic_vector(9 downto 0); -- .     VIDEO
signal VIDEO_V: std_logic_vector(8 downto 0); -- .      VIDEO

signal H_MAX  : std_logic_vector(8 downto 0); --    

--------------------------------------------------------------------------------
--                       VGA  VIDEO                 090820  --
--------------------------------------------------------------------------------

signal VGA_KSI     : std_logic; --    VGA
signal VGA_SSI     : std_logic; --    VGA

--signal VIDEO_KSI   : std_logic; --    VIDEO
--signal VIDEO_SSI1  : std_logic; --     VIDEO
--signal VIDEO_SSI2  : std_logic; --   -   VIDEO
--signal VIDEO_SYNC  : std_logic; --   VIDEO

-- 0 -         .  
--signal RESET_ZONE  : std_logic; --   VIDEO
 
--------------------------------------------------------------------------------
--                       VGA  VIDEO                090726  --
--------------------------------------------------------------------------------

signal VGA_KGI     : std_logic; --     VGA
signal VGA_SGI     : std_logic; --     VGA
signal VGA_BLANK   : std_logic; --    VGA

--signal VIDEO_KGI   : std_logic; --     VIDEO
--signal VIDEO_SGI   : std_logic; --     VIDEO
--signal VIDEO_BLANK : std_logic; --    VIDEO

--------------------------------------------------------------------------------
--                                   090821  --
--------------------------------------------------------------------------------

signal WR_REG     : std_logic_vector(15 downto 0); --  3-R, 2-G, 1-B, 0-I

--------------------------------------------------------------------------------
--                                   090821  --
--------------------------------------------------------------------------------

signal RD_REG     : std_logic_vector(15 downto 0); --  3-R, 2-G, 1-B, 0-I

begin

--------------------------------------------------------------------------------
--                                                                    --
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--                                         090826  --
--------------------------------------------------------------------------------

--   /    ON, 
--    ,   .
--    
--------------------------------------------------------------------------------
RGBI_CLK <= F14 xnor INVERSE_F14MHZ; --   
--------------------------------------------------------------------------------
process (RGBI_CLK)   
begin
  if (falling_edge(RGBI_CLK)) then --    
--------------------------------------------------------------------------------
        B   <=   B_IN xnor INVERSE_RGBI;    --   -  
        R   <=   R_IN xnor INVERSE_RGBI; 
        G   <=   G_IN xnor INVERSE_RGBI;
        I   <=   I_IN xnor INVERSE_RGBI;
  end if;
end process;

--------------------------------------------------------------------------------
--                              090812  --
--------------------------------------------------------------------------------

process (F14, VIDEO_H(8),VIDEO_H(9))
begin

  if (rising_edge(F14)) then  --    ,   0  1
--if (falling_edge(F14)) then --     ,   1  0
      SSI   <= SSI_IN xnor INVERSE_SSI;
      SSI_2 <= not SSI;       --   -  
  end if;
end process;

--RESET_ZONE <= (not VIDEO_V(8) or VIDEO_V(7)); --    


--------------------------------------------------------------------------------
--                                  090825  --
--------------------------------------------------------------------------------

process (SSI)
begin
  if (falling_edge(SSI)) then --     ,
     H_MAX <= VIDEO_H(9 downto 1);        --     VIDEO
  end if;
end process;

--------------------------------------------------------------------------------
--                                   090825  --
--------------------------------------------------------------------------------
process (F14, SSI, SSI_2)
begin  
  if (falling_edge(F14)) then         -- ,    :

  --         . :
    if (SSI or SSI_2) = '0'  then
          VGA_H   <= (others => '0'); --   VGA
          VIDEO_H <= (others => '0'); --   VIDEO
    else
    
--      if (VGA_H = 447) then           --      VGA,
      if (VGA_H = H_MAX) then --      VGA,
          VGA_H <= (others => '0');   --   VGA
      else
          VGA_H   <= VGA_H   + 1;     --  -    VGA
      end if;    

--      if (VIDEO_H = 895)   then     --   :
--        VIDEO_H <= (others => '0');   --   VIDEO
--      else
        VIDEO_H   <= VIDEO_H   + 1;   --    VIDEO,
--      end if;    
   end if;   
  end if;   
end process;


--------------------------------------------------------------------------------
--                                     090813  --
--------------------------------------------------------------------------------
--         VGA 60  
--  62     , 
--   64  VGA.


process (KSI, KSI_2, VGA_H(8), VIDEO_H(9))
begin
  --       3/4  VIDEO
  if (rising_edge(VIDEO_H(8)) and VIDEO_H(9)='1') then
      KSI   <= KSI_IN xnor INVERSE_KSI;
      KSI_2 <= not KSI;       --     
  end if;

--------------------------------------------------------------------------------
--   VGA:
  if (falling_edge(VGA_H(8))) then   --      

    --     48/50 
    if (SET_FK_OUT = '0') then
      if (KSI or KSI_2) = '0' then   --    :
        VGA_V <= (others => '0');    --    VGA
      else                           --  
        VGA_V <= VGA_V   + 1;        --    VGA
      end if;    
    else  

    -- ,     60 
      if VGA_V = 587 then            --      (523+64=587):
        VGA_V <= ("0001000000");     --    VGA:  44
      else                           --  
        VGA_V <= VGA_V   + 1;        --    VGA
      end if;    

    end if;    
  end if;    
--------------------------------------------------------------------------------
--   VIDEO:
  if (falling_edge(VIDEO_H(9))) then --   .   
    if (KSI or KSI_2) = '0' then     --    :
      VIDEO_V <= (others => '0');    --    VIDEO
    else    
      VIDEO_V <= VIDEO_V + 1;        --    VIDEO
    end if;    
  end if;    
-------------------------------------------------------------------------------
end process;


--------------------------------------------------------------------------------
--                                       090828  --
--------------------------------------------------------------------------------
--    VGA
VGA_SSI    <= '0' when VGA_H > 8 and VGA_H < 62 else '1';
--VGA_SSI    <= '0' when VGA_H > 8 and VGA_H < 115 else '1';

--     VGA
--VGA_SGI    <= '0' when VGA_H < 89 else '1';
VGA_SGI    <= '0' when VGA_H < 142 else '1';

--------------------------------------------------------------------------------
--                                       090821  --
--------------------------------------------------------------------------------
--         VGA 60  
--  32     , 
--   64  VGA.

--    VGA
--    60 : 
VGA_KSI  <= '0' when ((VGA_V = 74 or VGA_V = 75) and SET_FK_OUT = '1')
--    48/50 : 
                  or ((VGA_V = 10 or VGA_V = 11) and SET_FK_OUT = '0') else '1';

--     VGA
--    60 : 
VGA_KGI  <= '0' when (VGA_V < 109 and SET_FK_OUT = '1')
--    48/50 : 
                  or (VGA_V < 65 and SET_FK_OUT = '0') else '1';

--------------------------------------------------------------------------------
--                                       090812  --
--------------------------------------------------------------------------------

--        50/48 :
A <= "00000000" & VIDEO_V(0) & VIDEO_H(9 downto 2)
                                        when (VIDEO_H(0)='1' and SET_FK_OUT='0')

--        60 :
else VIDEO_V(8 downto 0) & VIDEO_H(9 downto 2) 
                                        when (VIDEO_H(0)='1' and SET_FK_OUT='1')

--        50/48 :
else "00000000" & (not VIDEO_V(0)) & VGA_H(8 downto 1) 
                                        when (VIDEO_H(0)='0' and SET_FK_OUT='0')

--        60 :
else VGA_V(9 downto 1) & VGA_H(8 downto 1);


--------------------------------------------------------------------------------
--                                              090823  --
--------------------------------------------------------------------------------
--      (    WE) 
D(15 downto 0) <= WR_REG when VIDEO_H(0) = '1' else (others => 'Z');

process (F14)                   
begin
  if (falling_edge(F14)) then --   
--------------------------------------------------------------------------------
    --     VIDEO      16  :
    case VIDEO_H(1 downto 0) is
      when "00" =>      
        WR_REG(11 downto  8) <= R & G & B & I; --     
      when "01" =>      
        WR_REG( 7 downto  4) <= R & G & B & I; --      
      when "10" =>      
        WR_REG( 3 downto  0) <= R & G & B & I; --     .  
      when "11" =>      
        WR_REG(15 downto 12) <= R & G & B & I; --      
    end case;
--------------------------------------------------------------------------------
  end if;

  if (rising_edge(F14) and VGA_H(0)='0') then --   OE
      --            VGA
      RD_REG <= D(15 downto 0);

--------------------------------------------------------------------------------
  end if;

end process;


--------------------------------------------------------------------------------
--                                   090821  --
--------------------------------------------------------------------------------

--       
WE <= F14 or (VIDEO_H(1) nand VIDEO_H(0));
--       
OE <= F14 or VIDEO_H(0);
UB <= '0'; --      (D15..D8)
LB <= '0'; --      ( D7..D0)


--------------------------------------------------------------------------------
--                          VGA                  090830  --
--------------------------------------------------------------------------------

--        :

process (F14, VGA_H(0))                   
variable sel:std_logic_vector(1 downto 0);
begin
sel:=VGA_H(0) & F14 ;
  case sel is
    when "00" =>       --   
      R3 <= RD_REG(3); 
      G3 <= RD_REG(2);
      B3 <= RD_REG(1);
      I3 <= RD_REG(0);
    when "01" =>       --   
      R3 <= RD_REG(15);
      G3 <= RD_REG(14);
      B3 <= RD_REG(13);
      I3 <= RD_REG(12);
    when "10" =>       --   
      R3 <= RD_REG(11);
      G3 <= RD_REG(10);
      B3 <= RD_REG(9);
      I3 <= RD_REG(8);
    when "11" =>       --   
      R3 <= RD_REG(7);
      G3 <= RD_REG(6);
      B3 <= RD_REG(5);
      I3 <= RD_REG(4);
  end case;
end process;

--------------------------------------------------------------------------------
--      

process (F14) 
begin
if (rising_edge(F14)) then  --    ,   0  1
      --    VGA
      VGA_BLANK   <= VGA_KGI and VGA_SGI;

      VSYNC_VGA <= VGA_KSI;      --    VGA
      HSYNC_VGA <= VGA_SSI;      --    VGA
  end if;
end process;

      SYNC_VIDEO <= VSYNC_VGA xor HSYNC_VGA; --  VGA

--------------------------------------------------------------------------------
--    VGA   

ODR0 : OPNDRN port map (a_in => I_VGA_COM, a_out => I_VGA(0));
ODR1 : OPNDRN port map (a_in => I_VGA_COM, a_out => I_VGA(1));
ODR2 : OPNDRN port map (a_in => I_VGA_COM, a_out => I_VGA(2));

--------------------------------------------------------------------------------
--  RGBI   VGA

R_VGA     <= R3 and VGA_BLANK;
G_VGA     <= G3 and VGA_BLANK;
B_VGA     <= B3 and VGA_BLANK;
I_VGA_COM <= I3 and VGA_BLANK;
--------------------------------------------------------------------------------

end RTL;

