--------------------------------------------------------------------------------
--     : "ZXKit1 -  VGA & PAL"                  --                        
--  :  V1.0.0.45.22 TEST                                  : 091008  --
--  :                                                     --
--                                                                            --
--  : EPM3128ATC100-10 (128 MACROCELLS,  TQFP100)                   --
--  :  K6R4016V1D-TI10 (256K * 16 )                                     --
--   : 14 ,                              --
--   : Quartus II Version 9.0 Web Edition                      --
--------------------------------------------------------------------------------

-- Compilation Report:
-- Warnings        = 84
-- Total macrocels = 66/128
-- Total pins      = 63/116

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
entity VGA_PAL is
	port
	(

--------------------------------------------------------------------------------
--                                       090808  --
--------------------------------------------------------------------------------

R_IN          : in std_logic := '1'; --  RED
G_IN          : in std_logic := '1'; --  GREEN
B_IN          : in std_logic := '1'; --  BLUE
I_IN          : in std_logic := '1'; --  BRIGHT

KSI_IN        : in std_logic := '1'; --  
SSI_IN        : in std_logic := '1'; --  
-- F14MHZ        : in std_logic := '1'; --    14 
F14        : in std_logic := '1'; --    14 
SYNC_IN       : in std_logic := '1'; 
--F14MHZ        : in std_logic := '1'; --    14 


--------------------------------------------------------------------------------
--              /               090808  --
--------------------------------------------------------------------------------

INVERSE_RGBI  : in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .
                                      
INVERSE_KSI   : in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .
                                      
INVERSE_SSI   : in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .
                                      
INVERSE_F14MHZ: in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .

VGA_SCART     : in std_logic := '1'; --     VGA: 
                                     -- 0 -  SCART, 1 -  VGA.

SET_FK_IN     : in std_logic := '1'; --    : 
                                     -- 0 - 50 (312 ), 1 - 48 (320 .)
                                      
SET_FK_OUT    : in std_logic := '1'; --    : 
                                     -- 0 - 60 , 1 - 50/48 .

--------------------------------------------------------------------------------
--                         VGA                    090728  --
--------------------------------------------------------------------------------

R_VGA      : out std_logic := '0'; --  RED
G_VGA      : out std_logic := '0'; --  GREEN
B_VGA      : out std_logic := '0'; --  BLUE
I_VGA      : out std_logic_vector (2 downto 0) := "000"; --   VGA

VSYNC_VGA  : out std_logic := '1'; --  /. SCART
HSYNC_VGA  : out std_logic := '1'; --  /enable RGB SCART


--------------------------------------------------------------------------------
--                         VIDEO                  090728  --
--------------------------------------------------------------------------------

R_VIDEO    : out std_logic := '0'; --  RED
G_VIDEO    : out std_logic := '0'; --  GREEN
B_VIDEO    : out std_logic := '0'; --  BLUE
I_VIDEO    : out std_logic_vector (2 downto 0) := "000"; --   VIDEO

SYNC_VIDEO : out std_logic := '1'; --     .


--------------------------------------------------------------------------------
--                                             090803  --
--------------------------------------------------------------------------------
A17        : out std_logic; --     
A          : out std_logic_vector(16 downto 0); -- 

WE         : out std_logic := '1'; --       
OE         : out std_logic := '1'; --       
UB         : out std_logic := '1'; --      (D15..D8)
LB         : out std_logic := '1'; --       (D7..D0)


--------------------------------------------------------------------------------
--                                      090727  --
--------------------------------------------------------------------------------

D          : inout std_logic_vector(7 downto 0) := "ZZZZZZZZ" -- 

	);
    end VGA_PAL;
architecture RTL of VGA_PAL is

--------------------------------------------------------------------------------
--                                               090804  --
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--                                              090808  --
--------------------------------------------------------------------------------

signal SCR_VGA60 : std_logic; --  0 -    VGA 60  

--------------------------------------------------------------------------------
--                                       090804  --
--------------------------------------------------------------------------------

signal R      : std_logic; --  RED
signal G      : std_logic; --  GREEN
signal B      : std_logic; --  BLUE
signal I      : std_logic; --  BRIGHT

--signal KSI_IN : std_logic; --     1/4  3/4 
signal KSI    : std_logic; --  
signal SSI    : std_logic; --  
--signal F14    : std_logic; --    14 

--------------------------------------------------------------------------------
--                                            090802  --
--------------------------------------------------------------------------------
signal R3     : std_logic; --  RED      --    
signal G3     : std_logic; --  GREEN
signal B3     : std_logic; --  BLUE
signal I3     : std_logic; --  BRIGHT

--------------------------------------------------------------------------------
--                                           090726  --
--------------------------------------------------------------------------------

signal KSI_2  : std_logic; --   
signal SSI_2  : std_logic; --   

--------------------------------------------------------------------------------
--                     VGA  VIDEO              091008  --
--------------------------------------------------------------------------------

signal VGA_H  : std_logic_vector(8 downto 0); -- .     VGA
signal VGA_V  : std_logic_vector(9 downto 0); -- .      VGA

signal VIDEO_H: std_logic_vector(9 downto 0); -- .     VIDEO
signal VIDEO_V: std_logic_vector(8 downto 0); -- .      VIDEO

signal H_MAX  : std_logic_vector(9 downto 0); --    

--------------------------------------------------------------------------------
--                       VGA  VIDEO                 090726  --
--------------------------------------------------------------------------------

signal VGA_KSI     : std_logic; --    VGA
signal VGA_SSI     : std_logic; --    VGA

signal VIDEO_KSI   : std_logic; --    VIDEO
signal VIDEO_SSI1  : std_logic; --     VIDEO
signal VIDEO_SSI2  : std_logic; --   .  VIDEO
signal VIDEO_SSI3  : std_logic; --   -   VIDEO
signal VIDEO_SYNC  : std_logic; --   VIDEO

-- 0 -         .  
signal RESET_ZONE  : std_logic; --   VIDEO
 
--------------------------------------------------------------------------------
--                       VGA  VIDEO                090726  --
--------------------------------------------------------------------------------

signal VGA_KGI     : std_logic; --     VGA
signal VGA_SGI     : std_logic; --     VGA
signal VGA_BLANK   : std_logic; --    VGA

signal VIDEO_KGI   : std_logic; --     VIDEO
signal VIDEO_SGI   : std_logic; --     VIDEO
signal VIDEO_BLANK : std_logic; --    VIDEO

--------------------------------------------------------------------------------
--                                      090726  --
--------------------------------------------------------------------------------

signal WR_REG     : std_logic_vector(7 downto 0); --  3-R, 2-G, 1-B, 0-I

--------------------------------------------------------------------------------
--                                      090726  --
--------------------------------------------------------------------------------

signal RD_REG     : std_logic_vector(7 downto 0); --  3-R, 2-G, 1-B, 0-I

begin

--------------------------------------------------------------------------------
--                                                            090808  --
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--               -                   090808  --
--------------------------------------------------------------------------------

  WE         <= '1';
  OE         <= '1';
  UB         <= '1';
  LB         <= '1';




--------------------------------------------------------------------------------
--                                   091008  --
--------------------------------------------------------------------------------
process (F14, SSI, SSI_2)
begin  
  if (falling_edge(F14)) then         -- ,    :
    if (VGA_H = 223) then             --      VGA,
        VGA_H <= (others => '0');     --   VGA
    else
        VGA_H   <= VGA_H   + 1;       --  -    VGA
    end if;    
  end if;   
end process;

--------------------------------------------------------------------------------
--                                     091008  --
--------------------------------------------------------------------------------

process (KSI, KSI_2, VGA_H(7), VIDEO_H(9))
begin
      if (falling_edge(VGA_H(7))) then      --      
          if (VGA_V = 623) then
              VGA_V <= (others => '0');     --    VGA
          else                              --  
              VGA_V   <= VGA_V   + 1;       --    VGA
          end if;    
          
      end if;    
end process;

--------------------------------------------------------------------------------
--                                      091008  --
--------------------------------------------------------------------------------
--  0 -    VGA 60 
SCR_VGA60 <= '0' when VGA_V > 159 and VGA_V < 544 
                  and VGA_H >  63 and VGA_H < 192 else '1'; 

process (SCR_VGA60)
begin
    if SCR_VGA60 = '0' then --  :

      R3 <= VGA_H(5);  --    16 
      G3 <= not VGA_H(6);
      B3 <= VGA_H(4);

      if VGA_V < 352 then  --     128 :
        I3 <= '1';                         --   
      else                                 -- ,    :
        I3 <= '0';                         --  
      end if;

    else                   -- , border:
        I3 <= '0';         --  border  
 
        if VGA_V(4) = '0' then  
          R3 <= '1';       -- 16     
          G3 <= '0';
          B3 <= '0';
        else 
          R3 <= '0';       -- 16        
          G3 <= '0';
          B3 <= '1';
        end if;
    end if;

end process;

--------------------------------------------------------------------------------
--                                       091008  --
--------------------------------------------------------------------------------
--    VGA
VGA_SSI    <= '0' when VGA_H > 2 and VGA_H < 21 else '1';

--     VGA
VGA_SGI    <= '0' when VGA_H < 36 or VGA_H > 219 else '1';

--     VIDEO
VIDEO_SSI1 <= '0' when VIDEO_H < 66 else '1';

--     VIDEO
VIDEO_SSI2 <= '0' when VIDEO_H < 33 or (VIDEO_H >447 and VIDEO_H <481) else '1';

--   -   VIDEO
VIDEO_SSI3 <= '0' when VIDEO_H <382 or (VIDEO_H >447 and VIDEO_H <830) else '1';

--     VIDEO
VIDEO_SGI  <= '0' when VIDEO_H < 147 or VIDEO_H > 874 else '1';


--------------------------------------------------------------------------------
--                                       091008  --
--------------------------------------------------------------------------------
--    VGA
VGA_KSI    <= '1' when VGA_V > 0 and VGA_V < 4 else '0';

--     VGA
VGA_KGI    <= '0' when VGA_V < 80  else '1';

--    VIDEO
VIDEO_KSI  <= '0' when VIDEO_V = 3 or VIDEO_V = 4 
                                 or (VIDEO_V = 5 and VIDEO_H(9) = '0') else '1';

--     VIDEO
VIDEO_KGI  <= '0' when VIDEO_V < 8 else '1';


--------------------------------------------------------------------------------
--                       VIDEO              090726  --
--------------------------------------------------------------------------------
process (VIDEO_KGI, VIDEO_KSI, VIDEO_SSI1, VIDEO_SSI2, VIDEO_SSI3)
begin
if VIDEO_KGI = '0' then           --     :

    if VIDEO_KSI = '0' then       --   :    
        VIDEO_SYNC <= VIDEO_SSI3; --   -   VIDEO    
    else                          -- ,     :    
        VIDEO_SYNC <= VIDEO_SSI2; --     :    
    end if;

else
        VIDEO_SYNC <= VIDEO_SSI1; --     VIDEO
end if;    
end process;


--------------------------------------------------------------------------------
--                                   090726  --
--------------------------------------------------------------------------------

--    VGA
VGA_BLANK   <= '0' when VGA_KGI   = '0' or VGA_SGI   = '0' else '1';

--    VIDEO
VIDEO_BLANK <= '0' when VIDEO_KGI = '0' or VIDEO_SGI = '0' else '1';



--------------------------------------------------------------------------------
--                          VGA                  090808  --
--------------------------------------------------------------------------------
process (F14) 
begin
  if (rising_edge(F14)) then  --    ,   0  1
--if (falling_edge(F14)) then  --    ,   1  0

    if VGA_SCART = '1' then      --     VGA: 

      R_VGA  <= VGA_BLANK and R3; --   VGA  
      G_VGA  <= VGA_BLANK and G3;
      B_VGA  <= VGA_BLANK and B3;

      if (I3 and VGA_BLANK) = '0'  then          --   :
          I_VGA <= "000";        --      0
      else
          I_VGA <= "ZZZ";        --  
      end if;

      VSYNC_VGA <= VGA_KSI;      --    VGA
      HSYNC_VGA <= VGA_SSI;      --    VGA
    
    else                         -- ,    SCART
    
      R_VGA  <= VIDEO_BLANK and R; --   VIDEO  
      G_VGA  <= VIDEO_BLANK and G;
      B_VGA  <= VIDEO_BLANK and B;

      if (I and VIDEO_BLANK) = '0'  then          --   :
          I_VGA <= "000";        --      0
      else
          I_VGA <= "ZZZ";        --  
      end if;

      VSYNC_VGA <= VIDEO_SYNC;   --  VIDEO
      HSYNC_VGA <= '1';          --  RGB  SCART
    
    end if;
  end if;
end process;




--------------------------------------------------------------------------------

end RTL;

