;const defs

	.equ	UartClock,204	;timer 1 reload value for clocking uart
				;(SMOD set)

	.equ	BadTry,10	;if we detect 10 bad uart bytes sequentially,
				;then stop detection, turn on amiga mouse

	.equ	WaitTry,4	;wait 4 timer overflows before trying to
				;detect sermouse again

;byte defs
		.equ	XCoord,0x30
		.equ	YCoord,0x31

		.equ	Count,0x32	;   

		.equ	M3b0,0x33
		.equ	M3b1,0x34
		.equ	M3b2,0x35
		
		.equ	M5b0,0x36
		.equ	M5b3,0x37
		.equ	M5b4,0x38

		.equ	WaitCount,0x39



		.equ	MFlags,0x20	; 
;bit defs
		.equ	Is3byte,0	;byte MFlags
		.equ	Is5byte,1
		.equ	Yes3byte,2
		.equ	Yes5byte,3


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		.org	0
		ajmp	ProgBeg

		.org	0x1B
Tim1Int:
		ajmp	Timer1Int


		.org	0x23
SerInt:
		clr	RI		; RI

		push	psw
		push	acc

		mov	r0,SBUF		; ,  

		jb	Yes3byte,SerWrk3byte
		jb	Yes5byte,SerWrk5byte

		jb	Is3byte,SerIs3byte
		jb	Is5byte,SerIs5byte
		
		;  ''  ,    

		djnz	WaitCount,WhileAllRulez	;   

		clr	REN	;. uart
		anl	TCON,#0b00111111;     
		mov	IE,#0b10001000	;   ,    uart
		mov	TMOD,#0b00010000	;   16bit
		mov	TL1,#0
		mov	TH1,#0	;  (  )
		mov	WaitCount,#WaitTry	; 
		setb	TR1	;. 
		sjmp	SerEnd	;  

WhileAllRulez:
		mov	a,r0
		anl	a,#0b11111000
		cjne	a,#0b10000000,SerChk3byte	;  5byteformat

		setb	Is5byte
		mov	Count,#5
		mov	WaitCount,#BadTry	;.  
		sjmp	SerEnd
SerChk3byte:
		acall	Fail3bfirst
		setb	Is3byte
		mov	Count,#3
		mov	WaitCount,#BadTry
		sjmp	SerEnd
SerIs5byte:
		djnz	Count,SerEnd
		acall	Fail5byte
		setb	Yes5byte
		sjmp	SerWrk5byte
SerIs3byte:
		djnz	Count,SerIs3btst
		acall	Fail3bfirst
		setb	Yes3byte
		sjmp	SerWrk3byte
SerIs3btst:
		acall	Fail3bother
		sjmp	SerEnd
SerWrk5byte:
		mov	a,Count
		inc	Count
		jz	Ser5b0
		cjne	a,#3,SerWrk5skip
		sjmp	Ser5b3
SerWrk5skip:
		cjne	a,#4,SerEnd
Ser5b4:
		mov	Count,#0
		mov	M5b4,r0
		sjmp	Ser5Decode
Ser5b0:
		acall	Fail5byte
		mov	M5b0,r0
		sjmp	SerEnd
Ser5b3:
		mov	M5b3,r0
		sjmp	SerEnd

SerWrk3byte:
		mov	a,Count
		inc	Count
		jz	Ser3b0
		cjne	a,#2,Ser3b1
Ser3b2:		
		mov	Count,#0
		acall	Fail3bother
		mov	M3b2,r0
		sjmp	Ser3Decode
Ser3b1:
		acall	Fail3bother
		mov	M3b1,r0
		sjmp	SerEnd
Ser3b0:
		acall	Fail3bfirst
		mov	M3b0,r0

SerEnd:
		pop	acc
		pop	psw
		reti
SerFail:
		mov	MFlags,#0	;if fail, start new detection
					;also begin to work with amiga mouse
		sjmp	SerEnd

Ser5Decode:
		mov	a,M5b3
		add	a,XCoord
		mov	XCoord,a
		mov	P1,a
		setb	P3.4
		clr	P3.4
		mov	a,M5b4
		add	a,YCoord
		mov	YCoord,a
		mov	P1,a
		setb	P3.5
		clr	P3.5
		mov	a,M5b0
		mov	c,acc.2
		rlc	a
		orl	a,#0b11111000
		mov	P1,a
		setb	P3.7
		clr	P3.7
		sjmp	SerEnd

Ser3Decode:
		anl	M3b1,#0b00111111
		mov	a,M3b0
		rr	a
		rr	a
		anl	a,#0b11000000
		orl	a,M3b1
		add	a,XCoord
		mov	XCoord,a
		mov	P1,a
		setb	P3.4
		clr	P3.4
		anl	M3b2,#0b00111111
		mov	a,M3b0
		swap	a
		anl	a,#0b11000000
		orl	a,M3b2
		cpl	a	;due to lack of intellect in microsoft mouse
		inc	a
		add	a,YCoord
		mov	YCoord,a
		mov	P1,a
		setb	P3.5
		clr	P3.5
		mov	a,M3b0
		cpl	a
		swap	a
		rrc	a
		mov	acc.1,c
		orl	a,#0b11111100
		mov	P1,a
		setb	P3.7
		clr	P3.7
		sjmp	SerEnd


ProgBeg:
		mov	SP,#0x6F	;16    (0x70 - 0x7F)
					; !! {????}

		clr	a

		mov	MFlags,a	;   

		mov	XCoord,a	; 
		mov	YCoord,a

		mov	P1,a
		mov	P3,#0x0F	;  P3
		mov	P3,#0x3F	;   P1  - x/y
		mov	P3,#0x0F

		dec	P1		; 0xFF  - 
		setb	P3.7
		clr	P3.7

		mov	dptr,#AMouseData ;    

		mov	WaitCount,#BadTry

		mov	TMOD,#0b00100000	;  1  uart
		mov	TH1,#UartClock		;1200 baud (+SMOD)
		mov	TL1,#UartClock		;  
		setb	TR1			;.  1
		
		mov	IE,#0b10010000	;   uart'a

		mov	PCON,#0x80		; SMOD
		mov	SCON,#0b01010000	;  uart'a


;\/\/\/\/\/\/\/\/ this program uses r5,r6,r7
;               ints should not use r5,r6,r7

		mov	a,P3		; .  
		anl	a,#0x0F
		mov	r7,a
amouzloop:
		mov	P1,#0xFF	; and    amiga
		setb	P3.7		;    
		clr	P3.7
		
		mov	a,P3
		anl	a,#0x0F
		mov	r6,a		; -  r6,   r7
		
		anl	a,#0x03
		mov	r5,a
		mov	a,r7
		anl	a,#0x03
		rl	a		;   
		rl	a
		orl	a,r5
		movc	a,@a+dptr
		add	a,XCoord		; 
		mov	XCoord,a
		mov	P1,a		;    
		setb	P3.4
		clr	P3.4

		mov	a,r6		;   
		anl	a,#0x0C
		mov	r5,a
		mov	a,r7
		anl	a,#0x0C
		rr	a
		rr	a
		orl	a,r5
		movc	a,@a+dptr
		add	a,YCoord
		mov	YCoord,a
		mov	P1,a
		setb	P3.5
		clr	P3.5

StopIfSer:
		jb	Yes5byte,StopIfSer	;   
		jb	Yes3Byte,StopIfSer	;sermous',   


		mov	a,r6	; -> ...
		mov	r7,a

		sjmp	amouzloop	; ...



Timer1Int:
		push	psw
		push	acc
		
		djnz	WaitCount,Timer1iex
		
		clr	TR1		; 
		mov	TMOD,#0b00100000	;  1  uart
		mov	TH1,#UartClock		;1200 baud (+SMOD)
		mov	TL1,#UartClock		;  
		mov	IE,#0b10010000	;   uart'a
		setb	TR1		;.  1
		setb	REN		;. uart

		mov	WaitCount,#BadTry	;  

Timer1iex:
		pop	acc
		pop	psw
		reti		




Fail5byte:
		mov	a,r0
		anl	a,#0b11111000
		cjne	a,#0b10000000,Fail2serfail
		ret
Fail3bfirst:
		mov	a,r0
		anl	a,#0b11000000
		cjne	a,#0b11000000,Fail2serfail
		ret		
Fail3bother:
		mov	a,r0
		anl	a,#0b11000000
		cjne	a,#0b10000000,Fail2serfail
		ret
Fail2serfail:
		dec	SP	;release return address
		dec	SP
		ajmp	SerFail




AMouseData:
	.db	 0		;0000		  
	.db	 1		;0001		   .  .
	.db	-1		;0010		 ''  
	.db	 0		;0011		  
	.db	-1		;0100
	.db	 0		;0101
	.db	 0		;0110
	.db	 1		;0111
	.db	 1		;1000
	.db	 0		;1001
	.db	 0		;1010
	.db	-1		;1011
	.db	 0		;1100
	.db	-1		;1101
	.db	 1		;1110
	.db	 0		;1111
