
#ifndef Z80_H
#define Z80_H


#define Z80_SF 0x80u
#define Z80_ZF 0x40u
#define Z80_YF 0x20u
#define Z80_HF 0x10u
#define Z80_XF 0x08u
#define Z80_PF 0x04u
#define Z80_NF 0x02u
#define Z80_CF 0x01u

#define Z80_BC (z80_regs[0])
#define Z80_DE (z80_regs[1])
#define Z80_HL (z80_regs[2])
#define Z80_IX (z80_regs[3])
#define Z80_IY (z80_regs[4])

#define Z80_R ((Z80_R8 & 0x80) | (Z80_R7 & 0x7f))
#define Z80_IR LIB_UZX_DATA_PAIR(Z80_I, Z80_R)

#ifndef z80_fetch_acc
#define z80_fetch_acc(a) (z80_ram[(a)])
#endif
#ifndef z80_read_acc
#define z80_read_acc(a) (z80_ram[(a)])
#endif
#ifndef z80_write_acc
#define z80_write_acc(a, b) ((void) (z80_ram[(a)] = (b)))
#endif
#ifndef z80_input_acc
#define z80_input_acc(a) (((void) (a)), 0xff)
#endif
#ifndef z80_output_acc
#define z80_output_acc(a, b) (((void) (a)), ((void) (b)))
#endif


extern unsigned z80_prefix, z80_regs[5], z80_alts[4];  /* BC', DE', HL', and AF' */
extern unsigned Z80_AF, Z80_SP, Z80_PC, Z80_I, Z80_R8, Z80_R7, z80_MEMPTR;
extern unsigned Z80_IFF1, Z80_IFF2, Z80_IM, Z80_HALT, Z80_INT_disabled;
extern unsigned long Z80_ticks, xZ80_INT_tick;


void z80_init(void);

unsigned z80_step(unsigned long tc);


#endif
