--------------------------------------------------------------------------------
--     : "ZXKit1 -  VGA & PAL"                  --                        
--  :  V3.0.1.02                                          : 091223  --
--  :                                                     --
--                                                                            --
--  : EPM3128ATC100-10N (128 MACROCELLS,  TQFP100)                  --
--  :  K6R4016V1D-UI10 (256K * 16 )                                     --
--   : 14 ,                              --
--   : Quartus II Version 9.0 Web Edition                      --
--------------------------------------------------------------------------------

-- Compilation Report:
-- Warnings        = 76
-- Total macrocels = 121/128
-- Total pins      = 72/80

library IEEE;
library altera; 
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
use altera.altera_primitives_components.all;

entity VGA_PAL is
	port
	(

--------------------------------------------------------------------------------
--                                       091018  --
--------------------------------------------------------------------------------

R_IN        : in std_logic := '1'; --  RED
G_IN        : in std_logic := '1'; --  GREEN
B_IN        : in std_logic := '1'; --  BLUE
I_IN        : in std_logic := '1'; --  BRIGHT

KSI_IN      : in std_logic := '1'; --  
SSI_IN      : in std_logic := '1'; --  
F14         : in std_logic := '1'; --    14 
F14_2       : in std_logic := '1'; -- F12,     

--------------------------------------------------------------------------------
--              /               090812  --
--------------------------------------------------------------------------------

INVERSE_RGBI  : in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .
                                      
INVERSE_KSI   : in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .
                                      
INVERSE_SSI   : in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .
                                      
INVERSE_F14MHZ: in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .

VGA_SCART     : in std_logic := '1'; --     VGA: 
                                     -- 0 -  SCART, 1 -  VGA.

SET_FK_IN     : in std_logic := '1'; --    : 
                                     -- 0 - 50 (312 ), 1 - 48 (320 .)
                                      
SET_FK_OUT    : in std_logic := '1'; --    : 
                                     -- 1 - 100/96 , 0 - 50/48 .

--------------------------------------------------------------------------------
--                         VGA                    090728  --
--------------------------------------------------------------------------------

R_VGA      : out std_logic := '0'; --  RED
G_VGA      : out std_logic := '0'; --  GREEN
B_VGA      : out std_logic := '0'; --  BLUE
I_VGA      : out std_logic_vector (2 downto 0) := "000"; --   VGA

VSYNC_VGA  : out std_logic := '1'; --  /. SCART
HSYNC_VGA  : out std_logic := '1'; --  /enable RGB SCART

--------------------------------------------------------------------------------
--                         VIDEO                  091025  --
--------------------------------------------------------------------------------

R_VIDEO    : out std_logic := '0'; --  RED
G_VIDEO    : out std_logic := '0'; --  GREEN
B_VIDEO    : out std_logic := '0'; --  BLUE
I_VIDEO    : out std_logic_vector (2 downto 0) := "000"; --   VIDEO

SYNC_VIDEO : out std_logic := '1'; --     .


--------------------------------------------------------------------------------
--                                             091016  --
--------------------------------------------------------------------------------
A17        : out std_logic;        --     
A          : out std_logic_vector(16 downto 0); -- 

WE         : out std_logic := '1'; --       
OE         : buffer std_logic := '1'; --       
UB         : out std_logic := '1'; --      (D15..D8)
LB         : out std_logic := '1'; --       (D7..D0)


--------------------------------------------------------------------------------
--                                      090821  --
--------------------------------------------------------------------------------

D          : inout std_logic_vector(15 downto 0) := "ZZZZZZZZZZZZZZZZ" -- 

	);
    end VGA_PAL;
architecture RTL of VGA_PAL is

--------------------------------------------------------------------------------
--                                                       --
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--                                       090805  --
--------------------------------------------------------------------------------

signal R           : std_logic; --  RED
signal G           : std_logic; --  GREEN
signal B           : std_logic; --  BLUE
signal I           : std_logic; --  BRIGHT
signal RGBI_CLK    : std_logic; --     
signal KSI         : std_logic; --  
signal SSI         : std_logic; --  

--------------------------------------------------------------------------------
--                                            091025  --
--------------------------------------------------------------------------------
signal R3          : std_logic; --  RED      --    
signal G3          : std_logic; --  GREEN
signal B3          : std_logic; --  BLUE
signal I3          : std_logic; --  BRIGHT
signal I_VGA_COM   : std_logic; --   BRIGHT  VGA
signal I_VIDEO_COM : std_logic; --   BRIGHT  VIDEO


--------------------------------------------------------------------------------
--                                           090726  --
--------------------------------------------------------------------------------

signal KSI_2       : std_logic; --   
signal SSI_2       : std_logic; --   

--------------------------------------------------------------------------------
--                     VGA  VIDEO              091024  --
--------------------------------------------------------------------------------

signal VGA_H     : std_logic_vector(8 downto 0); -- .     VGA
signal VGA_V     : std_logic_vector(9 downto 0); -- .      VGA

signal VGA_H_MIN : std_logic_vector(8 downto 0); -- .  .  
signal VGA_H_MAX : std_logic_vector(8 downto 0); -- . .  
signal VGA_V_MIN : std_logic_vector(9 downto 0); -- .  .   
signal VGA_V_MAX : std_logic_vector(9 downto 0); -- . .   

signal VGA_V_CLK : std_logic; --     VGA  

signal VIDEO_H   : std_logic_vector(9 downto 0); -- .     VIDEO
signal VIDEO_V   : std_logic_vector(8 downto 0); -- .      VIDEO



signal H_TYPE : std_logic; --   - /    : 
                --  0 -     ,   14 
                --        896  (895 = 1101111111)
                
                --  1 -   ,   12 
                --        768  (767 = 1011111111)

signal V_TYPE : std_logic; --   - /    : 
                --  0 - 312  (311 = 100110111)
                --  1 - 320  (319 = 100111111)
signal BUF    : std_logic; --       

--------------------------------------------------------------------------------
--                       VGA  VIDEO                 091222  --
--------------------------------------------------------------------------------

signal VGA_KSI      : std_logic; --    VGA
signal VGA_SSI      : std_logic; --    VGA

signal VIDEO_KSI    : std_logic; --    VIDEO
signal VIDEO_SSI1   : std_logic; --     VIDEO
signal VIDEO_SSI2   : std_logic; --   -   VIDEO
signal VIDEO_SYNC   : std_logic; --   VIDEO

signal VGA_RBGI_CLK : std_logic; --     VGA 
signal RESET_ZONE   : std_logic; --     
signal RESET_H      : std_logic; --  0,         
signal RESET_V      : std_logic; --  0,         

--------------------------------------------------------------------------------
--                       VGA  VIDEO                091025  --
--------------------------------------------------------------------------------

signal VGA_KGI     : std_logic; --     VGA
signal VGA_SGI     : std_logic; --     VGA
signal VGA_BLANK   : std_logic; --    VGA

signal VIDEO_KGI   : std_logic; --     VIDEO
signal VIDEO_SGI   : std_logic; --     VIDEO
signal VIDEO_BLANK : std_logic; --    VIDEO

--------------------------------------------------------------------------------
--                                           091024  --
--------------------------------------------------------------------------------

signal RAM_MODE    : std_logic;    --    : 1 - , 0 - 
signal WR_REG_MUX  : std_logic_vector(1 downto 0);   --   
signal RD_REG_MUX  : std_logic_vector(1 downto 0);   --   
signal WR_ADR      : std_logic_vector(16 downto 0);  --      
signal RD_ADR      : std_logic_vector(16 downto 0);  --     

--------------------------------------------------------------------------------
--                                   091024  --
--------------------------------------------------------------------------------

signal WR_REG      : std_logic_vector(15 downto 0); --  3-R, 2-G, 1-B, 0-I
signal WR_REG_CLK  : std_logic; --       
--------------------------------------------------------------------------------
--                                   090821  --
--------------------------------------------------------------------------------

signal RD_REG      : std_logic_vector(15 downto 0); --  3-R, 2-G, 1-B, 0-I

begin

--------------------------------------------------------------------------------
--                                                                    --
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--                                         090826  --
--------------------------------------------------------------------------------

--   /    ON, 
--    ,   .
--    
--------------------------------------------------------------------------------
RGBI_CLK <= F14 xnor INVERSE_F14MHZ; --   
--------------------------------------------------------------------------------
process (RGBI_CLK)   
begin
  if (falling_edge(RGBI_CLK)) then --    
--------------------------------------------------------------------------------
        B   <=   B_IN xnor INVERSE_RGBI;    --   -  
        R   <=   R_IN xnor INVERSE_RGBI; 
        G   <=   G_IN xnor INVERSE_RGBI;
        I   <=   I_IN xnor INVERSE_RGBI;
  end if;
end process;

--------------------------------------------------------------------------------
--                              091222  --
--------------------------------------------------------------------------------
process (F14, VIDEO_H(8),VIDEO_H(9))
begin

  if (rising_edge(F14)) then  --    ,   0  1
      SSI   <= SSI_IN xnor INVERSE_SSI;
      SSI_2 <= not SSI;       --     
  end if;
end process;

process (KSI, KSI_2, VGA_H(8), VIDEO_H(9))
begin
  --       1/4...1/2  VIDEO
  if (rising_edge(VIDEO_H(8)) and VIDEO_H(9)='0') then
      KSI   <= KSI_IN xnor INVERSE_KSI;
      KSI_2 <= not KSI;       --      
  end if;
end process;

RESET_H <= SSI or SSI_2;      --  0,         
RESET_V <= KSI or KSI_2;      --  0,     
--    , 0     -
RESET_ZONE <= (not VIDEO_V(7) or VIDEO_V(8)); 

--------------------------------------------------------------------------------
--                                  091222  --
--------------------------------------------------------------------------------

--process (SSI)
--begin
--  if (falling_edge(SSI)) then --     ,
--    if RESET_ZONE = '0'  then --     
--      --       
--                --  10 -     
--                --         "",   14 
--                --         896  (895 = 1 10 1111111)
--                
--                --  01 -   "",   12 
--                --         768  (767 = 1 01 1111111)
--
--                --  00 -   "",   10 
--                --         640  (639 = 1 00 1111111)
--
--                --  11 -   "",   8 
--                --         512  (511 = 0 11 1111111)
--      H_TYPE <= VIDEO_H(8 downto 7);
--    end if;
--  end if;
--end process;

process (SSI)
begin
  if (falling_edge(SSI)) then --     ,
    if RESET_ZONE = '0'  then --     
    H_TYPE <= VIDEO_H(7); --      VIDEO
    end if;               -- 0 = 896  (14 ), 1 = 768  (12 )
  end if;
end process;

--------------------------------------------------------------------------------
--                                    091016  --
--------------------------------------------------------------------------------
process (KSI)
begin
  if (falling_edge(KSI)) then --     ,
    V_TYPE <= VIDEO_V(3); --      VIDEO
                          -- 0 = 312 , 1 = 320 
  end if;
end process;

--------------------------------------------------------------------------------
--                                   091223  --
--------------------------------------------------------------------------------
process (F14, SSI, SSI_2)
begin  
  --         
  if (SET_FK_OUT='0') then     --     50/48 :
    VGA_H_MIN <= "000000000";  --   0 -      VGA
    VGA_H_MAX <= "110111111";  -- 447 -     VGA
    
  else                         --     100/96 :
    VGA_H_MIN <= "000000000";  --   0 -      VGA
    VGA_H_MAX <= "011011111";  -- 223 -     VGA 
  end if;  
--------------------------------------------------------------------------------
  if (falling_edge(F14)) then         --    :

    --           -:
    --      
    if (RESET_H or RESET_ZONE) = '0'  then
      VGA_H     <= (others => '0');    --    VGA
      VIDEO_H   <= (others => '0');    --    VIDEO
      
    else                               --  -  :
   
      if (VGA_H = VGA_H_MAX) then      --      VGA,
        VGA_H   <= (others => '0');    --    VGA
      else
        VGA_H   <= VGA_H + 1;          --  -   
      end if;    

      if (VIDEO_H = 895) then --  .    VIDEO,
        VIDEO_H <= (others => '0');    --    VGA
      else
        VIDEO_H <= VIDEO_H + 1;        --  -   
      end if;    

   end if;   
  end if;   
end process;



--------------------------------------------------------------------------------
--                                     091223  --
--------------------------------------------------------------------------------

process (KSI, KSI_2, VGA_H(8), VIDEO_H(9))
begin
  --         
  if (SET_FK_OUT='0') then     --     50/48 :
    VGA_V_CLK <= VGA_H(8) ;
    VGA_V_MIN <= "0000000000"; --   0 -      VGA
    VGA_V_MAX <= "0110111111"; -- 447 -     VGA
    
  else                         --     100/96 :
    VGA_V_CLK <= VGA_H(7);
    VGA_V_MIN <= "0000000000"; --   0 -      VGA
                               -- V_TYPE = 0 - 312  (311 = 100110111)
                               -- V_TYPE = 1 - 320  (319 = 100111111)
    VGA_V_MAX <= "10011" & V_TYPE & "1111";
  end if;  
    
--------------------------------------------------------------------------------
--   VGA:
  if (falling_edge(VGA_V_CLK)) then  --      

    --     48/50 
    if (SET_FK_OUT = '0') then
      if (RESET_V = '0') then        --    :
        VGA_V <= VGA_V_MIN;          --    VGA
      else                           --  
        VGA_V <= VGA_V   + 1;        --    VGA
      end if;    
    else  

-- ,     100/96 
      if (RESET_V = '0') then   --    :
        VGA_V <= VGA_V_MIN;          --    VGA
      else                           --  
        if VGA_V = VGA_V_MAX then    --     
          VGA_V <= VGA_V_MIN;        --    VGA
        else 
          VGA_V <= VGA_V   + 1;      --    VGA
        end if;    
      end if;    

    end if;    
  end if;    
--------------------------------------------------------------------------------
--   VIDEO:
  if (falling_edge(VIDEO_H(9))) then --   .   
    if (RESET_V = '0') then          --    :
      VIDEO_V <= (others => '0');    --    VIDEO
      BUF     <= not BUF;            --    /
    else    
      VIDEO_V <= VIDEO_V + 1;        --    VIDEO
    end if;    
  end if;    
--------------------------------------------------------------------------------
end process;

--------------------------------------------------------------------------------
--                                       091025  --
--------------------------------------------------------------------------------
process (SET_FK_OUT)                   
begin

if (SET_FK_OUT='0') then  --     50/48 :
  --    VGA
  if (VGA_H > 8 and VGA_H < 62) then
     VGA_SSI    <= '0';
  else
     VGA_SSI    <= '1';
  end if;     
  
  --     VGA
  if (VGA_H < 89) then
    VGA_SGI    <= '0' ;
  else
    VGA_SGI    <= '1';
  end if;       
  
else                      --     100/96 :
  --    VGA
  if (VGA_H < 18) then
    VGA_SSI    <= '0' ;
  else
    VGA_SSI    <= '1';
  end if;       

  --     VGA
  if (VGA_H < 42) then 
    VGA_SGI    <= '0' ;
  else
    VGA_SGI    <= '1';
  end if;       

end if;  
end process;

--     VIDEO
VIDEO_SSI1 <= '0' when VIDEO_H > 20 and VIDEO_H < 87 else '1';

--   -   VIDEO
VIDEO_SSI2 <= '0' when VIDEO_H > 20 and VIDEO_H < 851 else '1';

--     VIDEO
VIDEO_SGI  <= '0' when VIDEO_H < 168 else '1';

--------------------------------------------------------------------------------
--                                       091025  --
--------------------------------------------------------------------------------
process (SET_FK_OUT)                   
begin

if (SET_FK_OUT='0') then  --     50/48 :
  --    VGA
  if (VGA_V = 10 or VGA_V = 11)  then
     VGA_KSI   <= '0' ;
  else
     VGA_KSI   <= '1';
  end if;     
  
  --     VGA
  if (VGA_V < 65) then
    VGA_KGI    <= '0' ;
  else
    VGA_KGI    <= '1';
  end if;       
  
else                      --     100/96 :
  --    VGA
  if (VGA_V > 0 and VGA_V < 4) then
    VGA_KSI    <= '1' ;
  else
    VGA_KSI    <= '0';
  end if;       

  --     VGA
  if (VGA_V < 80 or VGA_V > 617) then 
    VGA_KGI    <= '0' ;
  else
    VGA_KGI    <= '1';
  end if;       

end if;  
end process;

--    VIDEO
VIDEO_KSI  <= '0' when VIDEO_V < 4 else '1';

--     VIDEO
VIDEO_KGI  <= '0' when VIDEO_V < 16 else '1';

--------------------------------------------------------------------------------
--                       VIDEO              090820  --
--------------------------------------------------------------------------------
VIDEO_SYNC <= VIDEO_SSI2 when VIDEO_KSI = '0' else VIDEO_SSI1;

--------------------------------------------------------------------------------
--                                   091025  --
--------------------------------------------------------------------------------
--    VGA
VGA_BLANK   <= VGA_KGI and VGA_SGI;

--    VIDEO
VIDEO_BLANK <= VIDEO_KGI and VIDEO_SGI;

--------------------------------------------------------------------------------
--                                   091025  --
--------------------------------------------------------------------------------
UB <= '0'; --      (D15..D8)
LB <= '0'; --      ( D7..D0)
RAM_MODE <= VIDEO_H(0);     --    : 1 - , 0 - 

process (SET_FK_OUT)                   
begin
  --      
  if (SET_FK_OUT='0') then  --     50/48 :
    WE     <= F14 or (not(VIDEO_H(1) and VIDEO_H(0)) ); --       
    WR_REG_MUX <= VIDEO_H(1) & VIDEO_H(0);   --    
    WR_REG_CLK <= F14;
  else                      --     100/96 :
    WE     <= F14 or (not(VIDEO_H(2) and VIDEO_H(1) and VIDEO_H(0)));
    WR_REG_MUX <= VIDEO_H(2 downto 1);   --    
    WR_REG_CLK <= F14 and VIDEO_H(0);
  end if;  

  --     
  if (SET_FK_OUT='0') then  --     50/48 :
    OE     <= F14 or VGA_H(0);                   --       
    RD_REG_MUX <= VGA_H(0) & F14;        --        
  else                      --     100/96 :
    OE     <= F14 or VGA_H(0);                   --       
    RD_REG_MUX <= VGA_H(0) & F14;        --        
  end if;  

end process;

--------------------------------------------------------------------------------
--                                       091024  --
--------------------------------------------------------------------------------
process (RAM_MODE, SET_FK_OUT)                   
begin
  --      
  if (SET_FK_OUT='0') then  --     50/48 :
    WR_ADR <= "00000000" & VIDEO_V(0) & VIDEO_H(9 downto 2); 
  else                      --     100 :
    WR_ADR <= BUF & VIDEO_V(8 downto 0) & VIDEO_H(9 downto 3); 
  end if;    
  
  --     
  if (SET_FK_OUT='0') then  --     50/48 :
    RD_ADR <= "00000000" & (not VIDEO_V(0)) & VGA_H(8 downto 1);  
  else                      --     100 :
    RD_ADR <= (not BUF) & VGA_V(9 downto 1) & VGA_H(7 downto 1);
  end if;  
  
  --     /  
  if RAM_MODE ='1' then --   :
    A <= WR_ADR;        --  
  else                  -- :   
    A <= RD_ADR;        --  
  end if;  

end process;

--------------------------------------------------------------------------------
--                                              091025  --
--------------------------------------------------------------------------------
--      (    WE) 
D(15 downto 0) <= WR_REG when RAM_MODE = '1' else (others => 'Z');

process (WR_REG_CLK)                   
begin
  if (rising_edge(WR_REG_CLK))  then --   
--------------------------------------------------------------------------------
    --     VIDEO      16  :
    case WR_REG_MUX is
      when "11" =>      
        WR_REG( 3 downto  0) <= R & G & B & I; --      
      when "00" =>      
        WR_REG( 7 downto  4) <= R & G & B & I; --     
      when "01" =>      
        WR_REG(11 downto  8) <= R & G & B & I; --      
      when "10" =>      
        WR_REG(15 downto 12) <= R & G & B & I; --     .  
    end case;
--------------------------------------------------------------------------------
  end if;

  if (rising_edge(OE)) then --   OE
      --            VGA
       RD_REG <= D;
  end if;    
--------------------------------------------------------------------------------

end process;

--------------------------------------------------------------------------------
--                          VGA                  091025  --
--------------------------------------------------------------------------------
--        :

process (RD_REG_MUX)                   
begin
  case RD_REG_MUX is
 
    when "01" =>       --   
      R3 <= RD_REG(3); 
      G3 <= RD_REG(2);
      B3 <= RD_REG(1);
      I3 <= RD_REG(0);

    when "10" =>       --   
      R3 <= RD_REG(7);
      G3 <= RD_REG(6);
      B3 <= RD_REG(5);
      I3 <= RD_REG(4);

    when "11" =>       --   
      R3 <= RD_REG(11);
      G3 <= RD_REG(10);
      B3 <= RD_REG(9);
      I3 <= RD_REG(8);

    when "00" =>       --   
      R3 <= RD_REG(15);
      G3 <= RD_REG(14);
      B3 <= RD_REG(13);
      I3 <= RD_REG(12);

  end case;
end process;

--------------------------------------------------------------------------------
--      
--------------------------------------------------------------------------------
process (F14) 
begin
if (rising_edge(F14)) then  --    ,   0  1
      VSYNC_VGA <= VGA_KSI;      --    VGA
      HSYNC_VGA <= VGA_SSI;      --    VGA
  end if;
end process;

--------------------------------------------------------------------------------
--    VGA  VIDEO   
--------------------------------------------------------------------------------
ODR0 : OPNDRN port map (a_in => I_VGA_COM,   a_out => I_VGA(0));
ODR1 : OPNDRN port map (a_in => I_VGA_COM,   a_out => I_VGA(1));
ODR2 : OPNDRN port map (a_in => I_VGA_COM,   a_out => I_VGA(2));

ODR3 : OPNDRN port map (a_in => I_VIDEO_COM, a_out => I_VIDEO(0));
ODR4 : OPNDRN port map (a_in => I_VIDEO_COM, a_out => I_VIDEO(1));
ODR5 : OPNDRN port map (a_in => I_VIDEO_COM, a_out => I_VIDEO(2));

--      
VGA_RBGI_CLK <= (not F14) xor F14_2; 
      
--------------------------------------------------------------------------------
--                       RGBI   VGA                      091024  --
--------------------------------------------------------------------------------
process (VGA_RBGI_CLK) 
begin
  if (rising_edge(VGA_RBGI_CLK)) then  --    ,
    R_VGA     <= R3 and VGA_BLANK;
    G_VGA     <= G3 and VGA_BLANK;
    B_VGA     <= B3 and VGA_BLANK;
    I_VGA_COM <= I3 and VGA_BLANK;
  end if;
end process;

--------------------------------------------------------------------------------
--                         PAL-CODER                   091025  --
--------------------------------------------------------------------------------
process (F14) 
begin
if (rising_edge(F14)) then  --    ,   0  1
--if (falling_edge(F14)) then  --    ,   1  0
      R_VIDEO     <= VIDEO_BLANK and R;       --    
      G_VIDEO     <= VIDEO_BLANK and G;
      B_VIDEO     <= VIDEO_BLANK and B;
      I_VIDEO_COM <= VIDEO_BLANK and I;

      SYNC_VIDEO  <= VIDEO_SYNC;              --   VIDEO
  end if;
end process;
--------------------------------------------------------------------------------

end RTL;

