
bool l48, l128;
unsigned char p7FFD, pEFF7, pageC000;

void Calc()
 {
  l128 = (pEFF7 & 0x04);
  l48 = ((p7FFD & 0x20) && l128);
  pageC000 = p7FFD & 0x07;
  if (!l128) pageC000 |= ((p7FFD & 0x40) >> 3) |
                         ((p7FFD & 0x80) >> 3) |
                          (p7FFD & 0x20);
 }

void ResetEvent()
 {
  p7FFD = 0;
  pEFF7 = 16; // for more compatible with old software (turbo is off at reset)
  Calc();
 }

void Out7FFD(unsigned char D)
 {
  if (!l48)
   {
    p7FFD = D;
    Calc();
   }
 }

void OutEFF7(unsigned char D)
 {
  pEFF7 = D;
  Calc();
 }

bool lock48()
 {
  return l48;
 }

bool lock128()
 {
  return l128;
 }

unsigned char RAMPAGE()
 {
  return pageC000;
 }
