Unit Pent1Mb;

INTERFACE

Procedure ResetEvent;
Procedure Out7FFD(D:byte);
Procedure OutEFF7(D:byte);
Function lock48:boolean;
Function lock128:boolean;
Function RAMPAGE:byte;

IMPLEMENTATION

var
 l48, l128              :boolean;
 p7FFD, pEFF7, pageC000 :byte;

Procedure Calc;
 begin
  l128:=(pEFF7 and $04)<>0;
  l48:=((p7FFD and $20)<>0) and l128;
  pageC000:=p7FFD and $07;
  if not l128 then pageC000:=pageC000 or
                             ((p7FFD and $40) shr 3) or
                             ((p7FFD and $80) shr 3) or
                              (p7FFD and $20);
 end;

Procedure ResetEvent;
 begin
  p7FFD:=0;
  pEFF7:=16; { for more compatible with old software (turbo is off at reset) }
  Calc;
 end;

Procedure Out7FFD(D:byte);
 begin
  if not l48 then
   begin
    p7FFD:=D;
    Calc;
   end;
 end;

Procedure OutEFF7(D:byte);
 begin
  pEFF7:=D;
  Calc;
 end;

Function lock48:boolean;
 begin
  lock48:=l48;
 end;

Function lock128:boolean;
 begin
  lock128:=l128;
 end;

Function RAMPAGE:byte;
 begin
  RAMPAGE:=pageC000;
 end;

begin
 ResetEvent;
end.
