   1 REM  GOSUB 100 - simulate Reset Event
   2 REM  GOSUB 200 - simulate OUT (7FFD),D
   3 REM  GOSUB 300 - simulate OUT (EFF7),D
   4 REM  D - input data
   5 REM  p7FFD - internal register status
   6 REM  pEFF7 - internal register status
   7 REM  lock48 - lock for 7FFD-port
   8 REM  lock128 - lock for memory above 128K
   9 REM  RAMPAGE - RAM page in C000-FFFF window
  10 CLS : GO SUB 100:
  11 LET D=82: GO SUB 200:
  12 LET D=4: GO SUB 300:
  13 LET D=0: GO SUB 300:
  14 LET D=4: GO SUB 300:
  15 LET D=80: GO SUB 200:
  16 LET D=113: GO SUB 200:
  17 LET D=114: GO SUB 200:
  18 LET D=0: GO SUB 300:
  99 STOP
 100 LET p7FFD=0: LET pEFF7=16: GO SUB 900
 101 REM  pEFF7=16 - for more compatible with old software (turbo is off at reset)
 102 PRINT "Reset          ","- ";RAMPAGE
 103 RETURN
 200 IF lock48=0 THEN LET p7FFD=D: GO SUB 900
 201 PRINT "OUT (#7FFD),";D,"- ";RAMPAGE
 202 RETURN
 300 LET pEFF7=D: GO SUB 900
 301 PRINT "OUT (#EFF7),";D,"- ";RAMPAGE
 302 RETURN
 900 LET lock48=0: LET lock128=0: LET RAMPAGE=0: LET tmp1=p7FFD: LET tmp2=pEFF7
 901 IF tmp2>127 THEN LET tmp2=tmp2-128
 902 IF tmp2>63 THEN LET tmp2=tmp2-64
 903 IF tmp2>31 THEN LET tmp2=tmp2-32
 904 IF tmp2>15 THEN LET tmp2=tmp2-16
 905 IF tmp2>7 THEN LET tmp2=tmp2-8
 906 IF tmp2>3 THEN LET lock128=1
 907 IF tmp1>127 THEN LET tmp1=tmp1-128: IF lock128=0 THEN LET RAMPAGE=RAMPAGE+16
 908 IF tmp1>63 THEN LET tmp1=tmp1-64: IF lock128=0 THEN LET RAMPAGE=RAMPAGE+8
 909 IF tmp1>31 AND lock128=0 THEN LET RAMPAGE=RAMPAGE+32
 910 IF tmp1>31 AND lock128=1 THEN LET lock48=1
 911 IF tmp1>31 THEN LET tmp1=tmp1-32
 912 IF tmp1>15 THEN LET tmp1=tmp1-16
 913 IF tmp1>7 THEN LET tmp1=tmp1-8
 914 LET RAMPAGE=RAMPAGE+tmp1
 915 RETURN
