--------------------------------------------------------------------------------
--     : "ZXKit1 -  VGA & PAL"                  --                        
--  :  V1.0.2.00                                          : 100216  --
--  :                                                     --
--                                                                            --
--  : EPM3128ATC100-10N (128 MACROCELLS,  TQFP100)                  --
--  :  K6R4016V1D-UI10 (256K * 16 )                                     --
--   : 14 ,                              --
--   : Quartus II Version 9.0 Web Edition                      --
--------------------------------------------------------------------------------

-- Compilation Report:
-- Warnings        = 29
-- Total macrocels = 128/128
-- Total pins      = 64/80

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;


entity VGA_PAL is
	port
	(

--------------------------------------------------------------------------------
--                                       091218  --
--------------------------------------------------------------------------------

R_IN       : in std_logic := '1'; --  RED
G_IN       : in std_logic := '1'; --  GREEN
B_IN       : in std_logic := '1'; --  BLUE
I_IN       : in std_logic := '1'; --  BRIGHT

KSI_IN     : in std_logic := '1'; --  
SSI_IN     : in std_logic := '1'; --  
F14        : in std_logic := '1'; --    14 
F14_2      : in std_logic := '1'; -- F12,     


--------------------------------------------------------------------------------
--              /               090812  --
--------------------------------------------------------------------------------

INVERSE_RGBI  : in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .
                                      
INVERSE_KSI   : in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .
                                      
INVERSE_SSI   : in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .
                                      
INVERSE_F14MHZ: in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .

VGA_SCART     : in std_logic := '1'; --     VGA: 
                                     -- 0 -  SCART, 1 -  VGA.

SET_FK_IN     : in std_logic := '1'; --    : 
                                     -- 0 - 50 (312 ), 1 - 48 (320 .)
                                      
SET_FK_OUT    : in std_logic := '1'; --    : 
                                     -- 1 - 60 , 0 - 50/48 .

--------------------------------------------------------------------------------
--                         VGA                    090728  --
--------------------------------------------------------------------------------

R_VGA      : out std_logic := '0'; --  RED
G_VGA      : out std_logic := '0'; --  GREEN
B_VGA      : out std_logic := '0'; --  BLUE
I_VGA      : out std_logic_vector (2 downto 0) := "000"; --   VGA

VSYNC_VGA  : out std_logic := '1'; --  /. SCART
HSYNC_VGA  : out std_logic := '1'; --  /enable RGB SCART


--------------------------------------------------------------------------------
--                         VIDEO                  090728  --
--------------------------------------------------------------------------------

R_VIDEO    : out std_logic := '0'; --  RED
G_VIDEO    : out std_logic := '0'; --  GREEN
B_VIDEO    : out std_logic := '0'; --  BLUE
I_VIDEO    : out std_logic_vector (2 downto 0) := "000"; --   VIDEO

SYNC_VIDEO : out std_logic := '1'; --     .


--------------------------------------------------------------------------------
--                                             090803  --
--------------------------------------------------------------------------------
A17        : out std_logic; --     
A          : out std_logic_vector(16 downto 0); -- 

WE         : out std_logic := '1'; --       
OE         : buffer std_logic := '1'; --       
UB         : out std_logic := '1'; --      (D15..D8)
LB         : out std_logic := '1'; --       (D7..D0)


--------------------------------------------------------------------------------
--                                      090727  --
--------------------------------------------------------------------------------

D          : inout std_logic_vector(7 downto 0) := "ZZZZZZZZ" -- 

	);
    end VGA_PAL;
architecture RTL of VGA_PAL is

--------------------------------------------------------------------------------
--                                               090804  --
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--                                       090805  --
--------------------------------------------------------------------------------

signal R      : std_logic; --  RED
signal G      : std_logic; --  GREEN
signal B      : std_logic; --  BLUE
signal I      : std_logic; --  BRIGHT
signal RGBI_CLK : std_logic; --     

--signal KSI_IN : std_logic; --     1/4  3/4 
signal KSI    : std_logic; --  
signal SSI    : std_logic; --  

--------------------------------------------------------------------------------
--                                            090802  --
--------------------------------------------------------------------------------
signal R3     : std_logic; --  RED      --    
signal G3     : std_logic; --  GREEN
signal B3     : std_logic; --  BLUE
signal I3     : std_logic; --  BRIGHT


--------------------------------------------------------------------------------
--                                           090726  --
--------------------------------------------------------------------------------

signal KSI_2  : std_logic; --   
signal SSI_2  : std_logic; --   

--------------------------------------------------------------------------------
--                     VGA  VIDEO              100216  --
--------------------------------------------------------------------------------
signal VGA_H_MAX   : std_logic_vector(8 downto 0);
signal VGA_H       : std_logic_vector(8 downto 0); -- .     VGA
signal VGA_V       : std_logic_vector(9 downto 0); -- .      VGA

signal VIDEO_H_MAX : std_logic_vector(9 downto 0); -- . . . 
signal VIDEO_H     : std_logic_vector(9 downto 0); -- .    VIDEO
signal VIDEO_V     : std_logic_vector(8 downto 0); -- .     VIDEO

signal H_COUNT     : std_logic_vector(9 downto 0); --  

--------------------------------------------------------------------------------
--                       VGA  VIDEO                 091223  --
--------------------------------------------------------------------------------

signal VGA_KSI     : std_logic; --    VGA
signal VGA_SSI     : std_logic; --    VGA

signal VIDEO_KSI   : std_logic; --    VIDEO
signal VIDEO_SSI1  : std_logic; --     VIDEO
signal VIDEO_SSI2  : std_logic; --   -   VIDEO
signal VIDEO_SYNC  : std_logic; --   VIDEO

signal RESET_ZONE   : std_logic; --     
signal RESET_H      : std_logic; --  0,         
signal RESET_V      : std_logic; --  0,         

 
--------------------------------------------------------------------------------
--                       VGA  VIDEO                090726  --
--------------------------------------------------------------------------------

signal VGA_KGI     : std_logic; --     VGA
signal VGA_SGI     : std_logic; --     VGA
signal VGA_BLANK   : std_logic; --    VGA

signal VIDEO_KGI   : std_logic; --     VIDEO
signal VIDEO_SGI   : std_logic; --     VIDEO
signal VIDEO_BLANK : std_logic; --    VIDEO

--------------------------------------------------------------------------------
--                                      090726  --
--------------------------------------------------------------------------------

signal WR_REG     : std_logic_vector(7 downto 0); --  3-R, 2-G, 1-B, 0-I

--------------------------------------------------------------------------------
--                                      090726  --
--------------------------------------------------------------------------------

signal RD_REG     : std_logic_vector(7 downto 0); --  3-R, 2-G, 1-B, 0-I

begin

--------------------------------------------------------------------------------
--                                                            090813  --
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--                                         090813  --
--------------------------------------------------------------------------------

--   /    ON, 
--    ,   .
--    
--------------------------------------------------------------------------------
RGBI_CLK <= F14 xnor INVERSE_F14MHZ; --   
--------------------------------------------------------------------------------
process (RGBI_CLK)   
begin
  if (falling_edge(RGBI_CLK)) then --    
--------------------------------------------------------------------------------
      R   <=   R_IN xnor INVERSE_RGBI;  --   
      G   <=   G_IN xnor INVERSE_RGBI;
      B   <=   B_IN xnor INVERSE_RGBI;
      I   <=   I_IN xnor INVERSE_RGBI;
  end if;
end process;

--------------------------------------------------------------------------------
--                              100216  --
--------------------------------------------------------------------------------
process (F14, VIDEO_H(8),VIDEO_H(9))
begin

  if (rising_edge(F14)) then  --    ,   0  1
      SSI   <= SSI_IN xnor INVERSE_SSI;
      SSI_2 <= not SSI;       --     
  end if;

  --       1/4...1/2  VIDEO
  if (rising_edge(H_COUNT(8)) and H_COUNT(9)='0') then
      KSI   <= KSI_IN xnor INVERSE_KSI;
      KSI_2 <= not KSI;       --      
  end if;
end process;

RESET_H <= SSI or SSI_2;      --  0,         
RESET_V <= KSI or KSI_2;      --  0,     
--    , 0     -
RESET_ZONE <= (not VIDEO_V(7) or VIDEO_V(8)); 


--------------------------------------------------------------------------------
--                                   100216  --
--------------------------------------------------------------------------------
process (F14, SSI, SSI_2)
begin  
  if (falling_edge(SSI)) then --     ,
    if RESET_ZONE = '0'  then --     
      --       
      VIDEO_H_MAX <= H_COUNT;
--      VGA_H_MAX   <= (VIDEO_H(9 downto 1) );
    end if;
  end if;
--------------------------------------------------------------------------------
  VGA_H_MAX   <= (VIDEO_H_MAX(9 downto 1) ); --  .  VGA
--------------------------------------------------------------------------------
  if (falling_edge(F14)) then         --    :
--------------------------------------------------------------------------------
    if (RESET_H = '0')  then          --    ,
      H_COUNT <= (others => '0');     --    
    else 
      H_COUNT <= H_COUNT + 1;         --  -  
    end if;   
--------------------------------------------------------------------------------
    --           -:
    --      
    if (RESET_H or RESET_ZONE) = '0'  then
      VGA_H     <= (others => '0');   --    VGA
      VIDEO_H   <= (others => '0');   --    VIDEO
    else
    
      if (VGA_H = VGA_H_MAX) then     --      VGA,
        VGA_H   <= (others => '0');   --   VGA
      else
        VGA_H   <= VGA_H   + 1;       --  -    VGA
      end if;    

      if (VIDEO_H = VIDEO_H_MAX) then --    VIDEO,
        VIDEO_H <= (others => '0');   --   VIDEO
      else
        VIDEO_H <= VIDEO_H + 1;       --    VIDEO,
      end if;    
   end if;   
  end if;   
end process;


--------------------------------------------------------------------------------
--                                     100216  --
--------------------------------------------------------------------------------
--         VGA 60  
--  32     , 
--   64  VGA.


process (VGA_H(8), VIDEO_H(9))
begin
--   VGA:
  if (falling_edge(VGA_H(8))) then   --      

    --     48/50 
    if (SET_FK_OUT = '0') then
      if (RESET_V = '0')  then       --    :
        VGA_V <= (others => '0');    --    VGA
      else                           --  
        VGA_V <= VGA_V   + 1;        --    VGA
      end if;    
    else  

    -- ,     60 
      if VGA_V = 587 then            --      (523+64=587):
        VGA_V <= ("0001000000");     --    VGA:  44
      else                           --  
        VGA_V <= VGA_V   + 1;        --    VGA
      end if;    

    end if;    
  end if;    
--------------------------------------------------------------------------------
--   VIDEO:
  if (falling_edge(H_COUNT(9))) then --   .   
    if (RESET_V = '0') then          --    :
      VIDEO_V <= (others => '0');    --    VIDEO
    else    
      VIDEO_V <= VIDEO_V + 1;        --    VIDEO
    end if;    
  end if;    
-------------------------------------------------------------------------------
end process;


--------------------------------------------------------------------------------
--                                       090820  --
--------------------------------------------------------------------------------
--    VGA
VGA_SSI    <= '0' when VGA_H > 8 and VGA_H < 62 else '1';

--     VGA
VGA_SGI    <= '0' when VGA_H < 89 else '1';

--     VIDEO
VIDEO_SSI1 <= '0' when VIDEO_H > 20 and VIDEO_H < 87 else '1';

--   -   VIDEO
VIDEO_SSI2 <= '0' when VIDEO_H > 20 and VIDEO_H < 851 else '1';

--     VIDEO
VIDEO_SGI  <= '0' when VIDEO_H < 168 else '1';


--------------------------------------------------------------------------------
--                                       090820  --
--------------------------------------------------------------------------------
--         VGA 60  
--  32     , 
--   64  VGA.

--    VGA
--    60 : 
VGA_KSI  <= '0' when ((VGA_V = 74 or VGA_V = 75) and SET_FK_OUT = '1')
--    48/50 : 
                  or ((VGA_V = 10 or VGA_V = 11) and SET_FK_OUT = '0') else '1';

--     VGA
--    60 : 
VGA_KGI  <= '0' when (VGA_V < 109 and SET_FK_OUT = '1')
--    48/50 : 
                  or (VGA_V < 65 and SET_FK_OUT = '0') else '1';

--    VIDEO
VIDEO_KSI  <= '0' when VIDEO_V < 4 else '1';

--     VIDEO
VIDEO_KGI  <= '0' when VIDEO_V < 16 else '1';


--------------------------------------------------------------------------------
--                       VIDEO              090820  --
--------------------------------------------------------------------------------
VIDEO_SYNC <= VIDEO_SSI2 when VIDEO_KSI = '0' else VIDEO_SSI1;

--------------------------------------------------------------------------------
--                                   090820  --
--------------------------------------------------------------------------------

--    VGA
VGA_BLANK   <= VGA_KGI and VGA_SGI;

--    VIDEO
VIDEO_BLANK <= VIDEO_KGI and VIDEO_SGI;


--------------------------------------------------------------------------------
--                                       090812  --
--------------------------------------------------------------------------------

--        50/48 :
A <= "00000000" & VIDEO_V(0) & VIDEO_H(9 downto 2)
                                        when (VIDEO_H(0)='1' and SET_FK_OUT='0')

--        60 :
else VIDEO_V(8 downto 0) & VIDEO_H(9 downto 2) 
                                        when (VIDEO_H(0)='1' and SET_FK_OUT='1')

--        50/48 :
else "00000000" & (not VIDEO_V(0)) & VGA_H(8 downto 1) 
                                        when (VIDEO_H(0)='0' and SET_FK_OUT='0')

--        60 :
else VGA_V(9 downto 1) & VGA_H(8 downto 1);


--------------------------------------------------------------------------------
--                                              090817  --
--------------------------------------------------------------------------------
--      (    WE) 
D(7 downto 0) <= WR_REG when VIDEO_H(0) = '1' else (others => 'Z');

process (VIDEO_H(0))                   
begin
  if (rising_edge(VIDEO_H(0))) then --   
--------------------------------------------------------------------------------
      --     VIDEO      
      if VIDEO_H(1) = '0' then  
          WR_REG(3) <= R; --      
          WR_REG(2) <= G;
          WR_REG(1) <= B;
          WR_REG(0) <= I;
      else
          WR_REG(7) <= R; --      
          WR_REG(6) <= G;
          WR_REG(5) <= B;
          WR_REG(4) <= I;
      end if;
--------------------------------------------------------------------------------
  end if;

  if (rising_edge(F14) and VGA_H(0)='0') then --   OE
      --            VGA
      RD_REG <= D(7 downto 0);

--------------------------------------------------------------------------------
  end if;

end process;


--------------------------------------------------------------------------------
--                                   090812  --
--------------------------------------------------------------------------------

--       
WE <= F14 or (VIDEO_H(1) nand VIDEO_H(0));
--       
OE <= F14 or VIDEO_H(0);
UB <= '1'; --    (D15..D8)   
LB <= '0'; --      (D7..D0)


--------------------------------------------------------------------------------
--                 VGA         090812  --
--------------------------------------------------------------------------------
--      
R3  <= RD_REG(3) when VGA_H(0) = '0' else RD_REG(7);
G3  <= RD_REG(2) when VGA_H(0) = '0' else RD_REG(6);
B3  <= RD_REG(1) when VGA_H(0) = '0' else RD_REG(5);
I3  <= RD_REG(0) when VGA_H(0) = '0' else RD_REG(4);

--------------------------------------------------------------------------------
--                          VGA                  100216  --
--------------------------------------------------------------------------------
process (F14) 
begin
--if (rising_edge(F14)) then  --    ,   0  1
  if (falling_edge(F14)) then  --    ,   1  0

--    if VGA_SCART = '1' then      --     VGA: 

      R_VGA  <= VGA_BLANK and R3; --   VGA  
      G_VGA  <= VGA_BLANK and G3;
      B_VGA  <= VGA_BLANK and B3;

      if (I3 and VGA_BLANK) = '0'  then          --   :
          I_VGA <= "000";        --      0
      else
          I_VGA <= "ZZZ";        --  
      end if;

      VSYNC_VGA <= VGA_KSI;      --    VGA
      HSYNC_VGA <= VGA_SSI;      --    VGA
     
--    SCART --   
--    else                         -- ,    SCART
--    
--      R_VGA  <= VIDEO_BLANK and R; --   VIDEO  
--      G_VGA  <= VIDEO_BLANK and G;
--      B_VGA  <= VIDEO_BLANK and B;
--
--      if (I and VIDEO_BLANK) = '0'  then          --   :
--          I_VGA <= "000";        --      0
--      else
--          I_VGA <= "ZZZ";        --  
--      end if;
--
--      VSYNC_VGA <= VIDEO_SYNC;   --  VIDEO
--      HSYNC_VGA <= '1';          --  RGB  SCART
--    
--    end if;
  end if;
end process;

--------------------------------------------------------------------------------
--                         PAL-CODER                   090820  --
--------------------------------------------------------------------------------
process (F14) 
begin
if (rising_edge(F14)) then  --    ,   0  1
--if (falling_edge(F14)) then  --    ,   1  0
  
      R_VIDEO  <= VIDEO_BLANK and R; --    
      G_VIDEO  <= VIDEO_BLANK and G;
      B_VIDEO  <= VIDEO_BLANK and B;

      if (I and VIDEO_BLANK) = '0'  then          --   :
          I_VIDEO <= "000";      --      0
      else
          I_VIDEO <= "ZZZ";      --  
      end if;

      SYNC_VIDEO  <= VIDEO_SYNC; --   VIDEO

  end if;
end process;


--------------------------------------------------------------------------------

end RTL;

