/****************************************************/                        
/*      TEST MC1702                                 */
/*                              I.L.N. 30-1-89      */
/****************************************************/
#include <stdio.h>
#include <WIMP.H>
#include <cx.h>
#include <rdbdf.h>
#include <wdbdf.h>
#define ID		061
#define VMMAX	0x2000		/*VM volume(words)*/
#define	ORDY	0100
#define HLT		040
#define INDVM	04
		struct	MAINTBL {
		unsigned	slot_t;
		long		pass_t;
		int			error_t;
		long		ercnt_t;
		unsigned	memvl_t;
		char		mesg_t[80];
				};
				
static	int		buf[15] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static	int		vbuf[18] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static char		snam[] = "SUT";
		rad50	rsnam[2];
		int		$$narg=1; /// $$ -    "" ("") - not used? $$ looks like two "bombs" chars
static char		nam[] = "CTPAGE";
static char		par[] = "IO PAR";
static struct	rdb  REGION;
static struct	wdb  WINDOW;
	int			*slot,*adr0,*adr2,*adr4,*adr6,res12,res0;
static	int		eflag,tmg,tnt,er;
static	int		data,bdata,status,port,erprm,vmdata,vmcnt=0,bport;
static	char	msg[] = ""; /// WORKING
static	struct MAINTBL mt = { 0,0,0,0,0,"not"};

		int		position=0;
static	int		flp[4] = {0,0,0,0};
		int		flex;
main()
{
		char	*out, *pmsg;
		int		i,FUNC,PLEN,POS;
		int		WIMP();
		int 	P[96];
		int		*as1();
		int		vsda(),plen;
		int		*oput;
		char	*input;
		int		n;

input=&snam[0];
oput=&rsnam;
ascr50( 3, input, oput);

rcvd(oput,&buf);	 	/*    */	/// Recieve data from PCB (PC-Board)
/************************************************/
/*		FIND SLOT								*/
		FUNC=12;
		PLEN=96;
		POS=7;
WIMP(FUNC,&P,PLEN);
for( i=0 ; i<8 ; i++,POS=POS+2)
		{ if(P[POS]==ID) break;}
position=i;
/*************************************************/
reg(position);

		mt.slot_t=slot;
		mt.pass_t=0;
		mt.error_t=0;
		mt.ercnt_t=0;
		mt.memvl_t=0;
		out = &(mt.mesg_t); pmsg = &msg[0];
		strcpy(out,pmsg);
/**************************************************/
/* '  					  */ /// Declare an important event (like signal)
eflag=8;
tmg=5;
tnt=2;
mrkt(eflag,tmg,tnt,as1); 	/// give us 'tmg' seconds mrkt on EFN (event flag number) 'eflag' while as1()	*/
clef(7);	/// clean flag

/*     		*/	/// Testing
pass:
		mt.pass_t ++;
		work();
	
rdaf(&flp); /// get all event flags
flex=flp[0];
if((flex & 0100)!=0) { clef(6); exif(6); }

vbuf[0]=01;

if(mt.ercnt_t != 0)
		{
vbuf[0]=0177777;	vbuf[1]=0x3044;		vbuf[2]=0x3030;
vbuf[3]=0x3934;		vbuf[4]=0x4D2E;		vbuf[5]=0x4753;

vbuf[6]=0x4600;		vbuf[7]=0x5245;

vbuf[9]=0x3044;		vbuf[10]=0x3030;	vbuf[11]=0x3934;
vbuf[12]=0x4D2E;	vbuf[13]=0x4753;

vbuf[14]=0x4600;	vbuf[15]=0x4548;	
vbuf[17]=0;
		n=mt.error_t;
		n=(n & 0177577);
		switch(n)
				{
case	1		:
vbuf[16]=0x0031; vbuf[8]=0x0031; break;	/*    */ /// Status register error
case	2		:
vbuf[16]=0x0032; vbuf[8]=0x0032;	break;	/*    */	/// Data exchange error
case	3		:
vbuf[16]=0x0033; vbuf[8]=0x0033; break;	/*  */	/// CPU command error
case	4		:
vbuf[16]=0x0034; vbuf[8]=0x0034; break;	/*   */	/// ROM error
case	5		:
vbuf[16]=0x0035; vbuf[8]=0x0035; break;	/*   */	/// RAM error
case	6		:
vbuf[16]=0x0036; vbuf[8]=0x0036; break;	/*    */	/// Video RAM error

default			:
				break;
				}

		plen=18;
		oput=&rsnam;
		vsda(oput,&vbuf,plen,6);	/// Variable Send Data - directive to send the data buffer to the task.
									///	status = vsda(tsknam, msg, buflen, eflag);
									///	rad50 tsknam[2];	/* 2 word RAD50 task name */
									///	word buffer msg[];	/* up to 256 word buffer */
									///	word buflen;		/* buffer length */
									///	word eflag;		/* Local event flag number */
									///	word status;		/* Returned DSW */
		clef(6); exif(6);
		}
		
		plen=18;
		oput=&rsnam;
		vsda(oput,&vbuf,plen,6);

stop();
goto	pass;

}


/*****************************************************/
/*                               */	/// Region and Window creation

reg()
{

int		*output;
char	*input;

/*    RDB */	/// Initialize the elements of RDB block (Regions Descriptor Block) - rdbdf.h
input=&nam[0];
output=&(REGION.r_gnam);	/// r.gnam name of region
ascr50( 6, input, output);

input=&par[0];
output=&(REGION.r_gpar);	/// r.gpar partition name (0= our partition)
ascr50( 6, input, output);

REGION.r_gid=0;	/// r.gid returnded id to the created region
REGION.r_gsiz=0;	/// r.gsiz size of region to create in 32w blocks
REGION.r_gsts=RS_ATT + RS_WRT + RS_RED;	/// r.gsts status
REGION.r_gpro=0167000;	/// r.gpro protection
/**************************************/

atrg(&REGION);	/// attach region

/*    WDB */	/// Initialize the elements of WDB block (Window Descriptor Block) - wdbdf.h
WINDOW.w_napr=5;	/// W.NAPR APR (2)
WINDOW.w_nsiz=2;	/// w.nsiz desired size of window in 32w blocks
WINDOW.w_nrid=REGION.r_gid;	/// w.nrid task region id (from create region)
WINDOW.w_noff=96 + 2 * position;	/// w.noff offset to start map
WINDOW.w_nlen=2;	/// w.nlen length to be mapped in 32w blocks
WINDOW.w_nsts=WS_64B + WS_MAP + WS_WRT;	/// w.nsts status
/*************************************/

craw(&WINDOW);	/// create address window

slot = WINDOW.w_nbas;	/// Virtual base address
adr0 = slot+0;
slot = WINDOW.w_nbas;
adr2 = slot+1;
slot = WINDOW.w_nbas;
adr4 = slot+2;
slot = WINDOW.w_nbas;
adr6 = slot+3;
res12 = RS_WRT + RS_DEL;
res0 = 0;
slot = WINDOW.w_nbas;
}

as1()
{

		int	*as1();
		int	*oput;
		int	a;
astset();	/// AST entry (Asynchronous System Trap)
oput=&rsnam;
buf[0]=0;
buf[1]=0;
buf[2]=0;
buf[3]=0;

rcvd(oput,&buf);	 /*    */	/// Recieve data from PCB (PC-Board)
a=buf[3];
a=a & 020;
if(a != 0 ) { setf(7); goto ob; }

mrkt(eflag,tmg,tnt,as1);
ob:
astx(1);	/// Exit the AST
}

/**********************************************************/
work()
{
		int		a;


data=012;		*adr4 = data;
data=*adr2;		bdata=(data&0302);
if(bdata != 0300)
		{ mt.ercnt_t++; mt.error_t=01; }
data=0;			*adr4 = data;
										/*	START SELFTEST		*/
data=0x80;		if((a=toboard(040,0,100l)) !=0) return;
vmcnt=0;

										/* error 81h, 82h, 83h, 86h	*/
a=fromboard(041,0,50000l);

if(port != 0xaaaa)
		{
		if(port ==2) { mt.ercnt_t++; er=(data|0200);
				       if(er==0201 || er==0202) mt.error_t=03;
					   if(er==0203) mt.error_t=04;
					   if(er==0206) mt.error_t=02;
					   }
		mt.ercnt_t++;
		mt.error_t=02;
		}
if(data != 0x5555)
		{ mt.ercnt_t++; mt.error_t=02; }
a=toboard(042,0xaaaa,100l);

a=fromboard(043,0,100l);
if(port != 0x5556)
		{
		if(port ==2) { mt.ercnt_t++; er=(data|0200);
						if(er==0201 || er==0202) mt.error_t=03;
						if(er==0203) mt.error_t=04;
						if(er==0206) mt.error_t=02;
					 }
		mt.ercnt_t++;
		mt.error_t=02;
		}
if(data != 0xaaaa)
		{ mt.ercnt_t++; mt.error_t=02; }

a=toboard(044,0x5556,100l);
										/*error 84h, 85h 		*/
if(teststat(HLT,300000l) !=0)  { mt.ercnt_t++; mt.error_t=01;}

*adr0 = data;							/* NMI	*/

										/* error 87h			*/
if(teststat(HLT,100l) !=0)   { mt.ercnt_t++; mt.error_t=01; }

										/* error 88h			*/
if(vmcnt !=0)	{ mt.ercnt_t++; mt.error_t=01; }

data=04064;	*adr4 = data;				/* INT8	*/

										/* error 89h			*/
if(teststat(HLT,100000l) !=0)
		{ if(vmcnt ==0)	{ mt.ercnt_t++; mt.error_t=01; }
		mt.ercnt_t++;
		mt.error_t=01; }
		if(data ==0)							return;   /*okay*/
		mt.ercnt_t++;
		mt.error_t=01;
}
/**************************************************/
/*	  				  */	/// Coprocessor sends data

fromboard(ptr,e,timer)
		int		ptr,e;
		long int timer;
{
long int	j;
		
erprm=ptr;
for(j=0; j<timer; j++)
	  { status = *adr2;
		if((status&ORDY) !=0)	continue;
				if((status&INDVM) ==0)
						{
						vmdata= *adr6; vmcnt++;
						if(vmcnt > (VMMAX*2))
						{ mt.ercnt_t++; mt.error_t=06; }
						continue;
						}
		port = *adr4;	data = ~(*adr6);

		if(e ==0)				return(0);		/*  */  /// port does not compared
			if(port == e)		return(0);		/* */ /// port is correct
			bport=port;	port=e;
			mt.ercnt_t++;
			mt.error_t=02;	return(030);	/* */ /// port is incorrect
		  }
			mt.ercnt_t++;
			mt.error_t=01;	/*    */ /// coprocessor does not ready for sending
}
/************************************************/
/*   		 			*/	/// coprocessor reads data

toboard(ptr,e,timer)
		int		ptr,e;
		long int timer;
{
long int		j;
			
erprm=ptr;
for(j=0; j<timer; j++)
 {		status = *adr2;
		if((status&0200) !=0)	 continue;
		port = *adr4;
		*adr6 = ~data;
	
		if(e ==0)			return(0);	/*  */  /// port does not compared
		if(port == e)		return(0);	/* */ /// port is correct
	bport=port;		port=e;
	mt.ercnt_t++;
	mt.error_t=02;	return(040);	/* */ /// port is incorrect
 }
	mt.ercnt_t++;
	mt.error_t=01;	/*    */ /// coprocessor does not ready for reading
}

/************************************************/

teststat(mask,timer)
		int		mask;
		int		long	timer;
{
		int		long	j;
for(j=0; j<timer; j++)
		{ data = *adr2;
		  if((data&mask) ==0)	return(0);
		  if((data&ORDY) !=0)	continue;

		  fromboard(060,2,200000l);

		  if(data !=0) 
			 { er=(data|0200);  mt.ercnt_t++;
			   if(er==0205 || er==0207 || er==0210) mt.error_t=03;
			   if(er==0204) mt.error_t=05;
			   if(er==0211) mt.error_t=06;
				}
		  return(0);
		}
return(1);
}
