/*
 * RSX11M V4.0 System Definition Headers for C.
 *
 * Region Definition Block  ( RDBDF$ )
 *
 * Used with 'crrg', 'atrg', and 'dtrg' functions.
 *
 * INCLUDE CX.H PRIOR TO INCLUDING THIS FILE
 *
 * Bob Denny
 * 19-Oct-82
 *
 */

struct	rdb	{
		address r_gid;		/* Region ID */
		word	r_gsiz;		/* Size of region */
		rad50   r_gnam[2];	/* Name of region */
		rad50   r_gpar[2];	/* Region part. name */
		word	r_gsts;		/* Region status word */
		word	r_gpro;		/* Region prot. code */
		};

/* Region status word codes */

#define	RS_CRR	0100000		/* Reg. successfully created */
#define	RS_UNM	0040000		/* Windows unmapped on detach */
#define	RS_MDL	0000200		/* Mark delete on last detach */
#define	RS_NDL	0000100		/* Not marked for delete */
#define	RS_ATT	0000040		/* Attach to created region */
#define	RS_NEX	0000020		/* Region not extendable */
#define	RS_DEL	0000010		/* Delete access desired */
#define	RS_EXY	0000004		/* Extend   "      "     */
#define	RS_WRT	0000002		/* Write    "      "     */
#define	RS_RED	0000001		/* Read     "      "     */
