#basic definitions for tools
CXX := $(if $(CXX),$(CXX),g++)
LDD := $(if $(LDD),$(LDD),g++)
AR := $(if $(AR),$(AR),ar)
OBJCOPY := $(if $(OBJCOPY),$(OBJCOPY),objcopy)
STRIP := $(if $(STRIP),$(STRIP),strip)

#set options according to mode
ifeq ($(mode),release)
cxx_mode_flags := -O2 -DNDEBUG -fdata-sections -ffunction-sections 
ld_mode_flags := --gc-sections 
else ifeq ($(mode),debug)
cxx_mode_flags := -O0
else
$(error Invalid mode)
endif

#setup profiling
ifdef profile
cxx_mode_flags += -pg
ld_mode_flags += -pg
endif

#setup PIC code
ifdef pic
cxx_mode_flags += -fPIC
ld_mode_flags += -shared
endif

#setup code coverage
ifdef coverage
cxx_mode_flags += --coverage
ld_mode_flags += --coverage
endif

#setup flags
CXX_FLAGS := $(cxx_mode_flags) $(cxx_flags) -g3 \
	$(addprefix -D, $(definitions)) \
	-funroll-loops -funsigned-char -fno-strict-aliasing \
	-W -Wall -Wextra -ansi -pipe \
	$(addprefix -I, $(include_dirs) $($(platform)_include_dirs))

CPUS = $(shell cat /proc/cpuinfo | grep processor | wc -l)

#CXX_FLAGS += -floop-parallelize-all -ftree-parallelize-loops=$(CPUS)
CXX_FLAGS += -ftree-parallelize-loops=$(CPUS)

ifeq ($(architecture),ppc)

ALTIVEC := $(shell cat /proc/cpuinfo | grep cpu | uniq | cut -f 3 -d " " )
ifeq ($(ALTIVEC),altivec)
CXX_FLAGS += -mabi=altivec -maltivec
endif

CPU := $(shell cat /proc/cpuinfo | grep cpu | uniq | cut -f 2 -d " " | sed -e 's/,//g')
ifeq ($(CPU),PPC970MP)
CXX_FLAGS += -mtune=970 -mcpu=970
endif

endif

AR_FLAGS := cru
LD_FLAGS := $(ld_mode_flags) $(ld_flags)
LD_FLAGS += -fopenmp

#specify endpoint commands
build_obj_cmd = $(CXX) $(CXX_FLAGS) -c -MMD $< -o $@
build_lib_cmd = $(AR) $(AR_FLAGS) $@ $^
link_cmd = $(LDD) $(LD_FLAGS) -o $@ $(object_files) \
	$(if $(libraries),-L$(libs_dir) $(addprefix -l,$(libraries)),) \
	$(if $(dynamic_libs),-L$(output_dir) $(addprefix -l,$(dynamic_libs)),) \
	$(addprefix -L,$($(platform)_libraries_dirs)) $(addprefix -l,$($(platform)_libraries))

#specify postlink command- generate pdb file
postlink_cmd = $(OBJCOPY) --only-keep-debug $@ $@.pdb && \
	$(STRIP) $@ && \
	$(OBJCOPY) --add-gnu-debuglink=$@.pdb $@

#include generated dependensies
include $(wildcard $(objects_dir)/*.d)

.PHONY: analyze analyze_all

analyze:
	@echo "Analyzing $(target)" > coverage.log
	@for i in $(source_files);do gcov -lp -o $(objects_dir) $$i >> coverage.log; done
	@echo `pwd`
	@perl $(path_step)/make/compilers/gcc_coverage.pl

analyze_deps: $(depends)

analyze_all: analyze analyze_deps
