;--- FILE io routines (tr-dos)

#if 0

   open name | number -> handle
   close handle

#endif



blk_get:
	
; E=disk, C=fileno
get_sector:
	ld hl, sectbuf
	ld a, e
	cp (hl)
	jr nz, get_fcb0  ; read from disk
	ld a, c
	inc hl
	cp (hl)

	psect data   ; ???
sectbuf:
	db 0, 0, 0	; disk, sector, track.
	ds 256


	global trdos
 	psect text

 EXPORT global trd_read

; A = disk (0..3) 0 == A:
; DE=track/sector, 
; B=sectors count,
; HL=load address 
; -> CF=1 error
trd_read:
	ld c, 0x05
	jr trd_oper

 EXPEND
	
 EXPORT global trd_write

; A = disk (0..N) 0 == A:
; DE=track/sector, 
; B=sectors count,
; HL=load address 
; -> CF=1 error
trd_read:
	ld c, 0x06
	jr trd_oper

 EXPEND

 EXOIRT global trd_oper  ; TODO make it local for this module

;A=disk, DE=track/sector, B=count, C=oper_code, HL=addr -> CF=1 error
trd_oper:
	push hl
	push de
	push bc
	ld hl, 23798	; current drive
	cp (hl)
	jr z, trd_oper1	; same drive

	push af
	ld c, 1		; set drive
	call trdos
	jr nc, trd_seld0
	; some error occured
	pop hl  ; af
trd_oper_err:
	pop hl
	pop hl
	pop hl
	ret

trd_seld0:
	pop af		; drive
	ld hl, 23752	; drive type sys var.
	add a, l
	ld l, a
	adc a, h
	sub l
	ld h, a
	ld a, (hl)
	inc a
	jr nz, trd_oper1  ; already initialized

	ld c, 0x18	; initialize
	call trdos
	; CF=1 if some error occured
	jr c, trd_oper_err

trd_oper1:
	pop bc
	pop de
	pop hl
	call trdos
	; CF=1 if error occured
	ret
	
 EXPEND






     ifndef findfile
     ifused findfile
; hl=mask
; -> FCB (0x5cdd), CF=1 error
findfile:
        push ix 
        ld ix, -8
        add ix, sp 
        ld sp, ix 
        ld de, 0x5cdd
        call findfirst
        exa 
        ld hl, 8
        add hl, sp
        ld sp, hl
        exa 
        pop ix
        ret 
     endif
     endif

; findfirst & findnext ᨫ쭮 ମ
; 䥩  室 ﭭ
; 뢠 ⥪饣 ᥪ
; (  ,  ᪮
; 뤥   ॠ)


     ifndef findfirst
     ifused findfirst
; find first file
; hl=*mask, de=*FCB, IX=*data(8 bytes)
;! de=*mask, bc=*FCB, *sp=*data(8 bytes)
; -> FCB (DE), CF=1 not found/error
findfirst:
        ld a, (0x5d19) ; disk
        ld (ix+0), a 
        ld (ix+1), 0
        ld (ix+2), l 
        ld (ix+3), h 
        ld (ix+4), e 
        ld (ix+5), d 
        ; jp findnext


; de=*data[8]
; +0 disk
; +1 fnum
; +2,3 *mask
; +4,5 *fcb
; +6,7 none
findnext:
        ld a, (ix+1)
        rla 
        ret c 
        rra 
        rra 
        rra 
        rra 
        rra 
        and 0x07
        ld e, a 
        ld d, 0
        ld bc, 0x0105
        ld hl, -256-13 ; sect+fname+0
        add hl, sp 
        ld sp, hl 
        call trdos
          jr c, findnexterr
        ld a, (ix+1)
        and 0x0f
findnext0:
        rla 
        rla 
        rla 
        rla 
        and 0xf0
        ld e, a 
        ld d, 0
        ld hl, 0
        add hl, sp    ; sect
        add hl, de    ; hl=fcb
          ld a, (hl)
          cp 1
          jr c, findnexterr ;end of cat.
          jr z, findnext1 ; deleted file
        push hl 
        ex de, hl 
        ld hl, 256+2  ; fname
        add hl, sp 
        push hl 
        ex de, hl 
        call fcbtoname
        pop hl      ; fname
        ld e, (ix+2)
        ld d, (ix+3)
        call strglob
        pop hl        ; fcb
        jr nz, findnext1

        ld e, (ix+4)
        ld d, (ix+5)
        ld bc, 16
        ldir 
        ld hl, 256+13
        add hl, sp
        ld sp, hl
        inc (ix+1)
        xor a 
        ret 

findnexterr:
        ld hl, 256+13
        add hl, sp
        ld sp, hl
        scf
        ret 

findnext1:
        inc (ix+1)
        ld a, (ix+1)
        and 0x0f
        jr nz, findnext0
        ld hl, 256+13
        add hl, sp 
        ld sp, hl
        jr findnext
     endif
     endif 


