;
; pp p ZX-SPECTRUM.
;
; p祭 p/ -- CAPS SHIFT
;  CONTROL -- EXT MODE (CAPS  SYMBOL SHIFT p)
; CTRL-Z  p뢠 (ᯮ CTRL-0)
;

 EXPORT global _key_init    ; initialize keyboard driver
 EXPORT global _key_done    ; stop keyboard driver
 EXPORT global _key_timer   ; call 50 p  ᥪ㭤
 EXPORT global _key_getc    ; -> l=ascii code (0 ᫨ p )
 EXPORT	global _key_stat    ; -> l=ff p  , l=0 

DELAY1    equ 1  ; ⨤p p ⨨
DELAY2    equ 10 ; p ⮯p
DELAY3    equ 2  ; p ⮯p
RIPDEL    equ 3  ; p ᬥp  ( p p)
RUSTIME1  equ 50 ; ᨬ쭮 p 㤥p CAPS  RUS/LAT p⥫
RUSTIME2  equ 50-2  ; 쭮 p ^^^ (  ᨬ쭮!)

;  _H__    O 0.
;    HHH  .

;  1  襩 CAPS LOCK ! (  ᯮ짮  pp)

; KOI-7R coding:
;    @ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~[^]
;    H椥娩p㦢

; -8 ⠡:
;  A3  B3
;     
;
;  C0 C1 C2 C3 C4 C5 C6 C7 C8 C9 CA CB CC CD CE CF
;                                
;
;  D0 D1 D2 D3 D4 D5 D6 D7 D8 D9 DA DB DC DD DE DF
;      p                          
;
;  E0 E1 E2 E3 E4 E5 E6 E7 E8 E9 EA EB EC ED EE EF
;                              H  
;
;  F0 F1 F2 F3 F4 F5 F6 F7 F8 F9 FA FB FC FD FE FF
;                                
;

	psect text

keylat:  db " ",0,"MNB",0x0D,"LKJHPOIUY0987612345QWERTASDFG",0,"ZXCV"
key866:  db " ",0,"",0x0D,"0987612345",0,""
keykoi:  db " ",0,"",0x0D,"0987612345",0,""
symlat:  db 0x1B,0,".,*",0x0B,"=+-^",0x22,";",0x0C,"][_)('&!@#$%",1,0x0F,6,"<>~|\{}",0,":`?/"
sym866:  db 0x1B,0,".,*",0x0B,"=+-^",0x22,";",0x0C,"][_)('&!","","#$%",1,0x0F,6,"<>",0,":`?/"
symkoi:  db 0x1B,0,".,*",0x0B,"=+-^",0x22,";",0x0C,"][_)('&!","","#$%",1,0x0F,6,"<>",0,":`?/"

;            0   1   2   3   4   5   6   7   8   9
capsnum: db 0x7F,0x09,0x0FC,0x12,0x03,0x08,0x18,0x05,0x04,0x07
ctrlnum: db 0x1b,0x1a,0x1a,0x1a,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b

SS_     equ 1
CS_     equ 35  ; scan codes 4 caps & sybol shift

CL_KEY  equ 0x96         ; CAPS LOCK scan code          |
KOI_KEY equ 0x0d2        ; EXT-8 p祭  -8  | ᪠, H ASCII !
KEY_866 equ 0x0d1        ; EXT-9 p祭  866     |

CS_SPC  equ 0x1B         ; BREAK = ESCAPE
CS_ENT  equ 0x0A         ; LINE FEED

CTRL_ENT  equ 0x1a       ; CTRL-Z   p Z (Z  SPC  EXT  )


	psect data

keybuf:        db 0,0,0,0,0,0,0,0,0,0,0,0  ; 0=empty
keybuftop      equ $

ripcnt:        db 0

;----------------------------------------------------------------------

	psect text

_key_init:
_key_done:
                ret 

set_866:        ld de,key866
                ld hl,sym866
                jr set_codepage

set_koi:        ld de,keykoi
                ld hl,symkoi

set_codepage:   xor a 
                ld (keycnt),a   ; ⮯p p饭
                ld (keyrus),de 
                ld (symrus),hl 
                ld hl,(keytbl)
                ld de,keylat    ;  p ⠡
                sbc hl,de 
                jr z,tolat
                jr torus


ripkey:         bit 7,d 
                ld a,0
ruscnt          equ $-1
                jr z,riprus   ; CAPS 饭 ?
                or a 
                jr z,ripcont  ; 祭
                dec a 
                jr nz,ripcont    ; 㬥訫
                inc a 
                jr ripcont      ;  1 

riprus:         cp 2
                jr c,ripnorus     ; pp 1<time<max  CAPS
                cp RUSTIME2
                jr nc,ripnorus

                ld hl,(keytbl)  ; p祭 RUS / LAT
                ld de,keylat
                or a 
                sbc hl,de 
                jr z,torus

tolat:          ld hl,symlat
                jr ruslat

torus:          ld de,key866
keyrus          equ $-2
                ld hl,sym866
symrus          equ $-2

ruslat:         ld (keytbl),de 
                ld (symtbl),hl 

ripnorus:       ld a,RUSTIME1   ; pp/p CAPS
ripcont:        ld (ruscnt),a 

                ld hl,ripcnt
                dec (hl) 
                ret nz          ; p⢠  ? (⨤p ᪠)

                xor a 
                jr newkey       ; 㡨 ,   ⠫  諠


kscend:         xor a        ; too many keys  DEAD KEY
                ld (ruscnt),a  ; RUS/LAT p饭

newkey:         ld (lastkey),a  ; new key pressed
                ld a,1
                ld (repkeyflag),a 
                ld a,DELAY1
                ld (keycnt),a 
                ld a,RIPDEL
                ld (ripcnt),a 
                ret 

ksc_cs:         set 7,d 
                jr ksc3
ksc_ss:         set 6,d 
                jr ksc3

_key_timer:      ld de,0x0ff     ;  
                ld h,e 
                ld bc,0x7ffe

kscloop:        ld l,h 
                in a,(c) 
                cpl 
                and 0x1f
                jr z,kscnxt

ksc1:           inc l          ;    p  ?
                srl a 
                jr nc,ksc1

                ex af,af' 
                ld a,l 
                cp CS_
                jr z,ksc_cs  ; CAPS SHIFT ?
                cp SS_
                jr z,ksc_ss  ; SYMBOL SHIFT ?
                inc e 
                jr nz,kscend ;   

                ld e,a 
ksc3:           ex af,af' 
ksc2:           jr nz,ksc1    ;  p p᪠p ?

kscnxt:         ld a,h 
                add a,5
                ld h,a 
                rrc b 
                jr c,kscloop  ; ᫥騩 p  

                              ; E= , bits 6,7 = .
                              ; E=FF 祣  
                ld a,e 
                inc a 
                or d 
                ld e,a 
                and 0x3f
                jp z,ripkey    ; 㡨 饭 

                ld hl,ruscnt
                ld (hl),0  ; rus/lat LOCKED !

                ld a,e 
                cp 0
lastkey         equ $-1
                jr nz,newkey    ; p 

                ld a,0
keycnt          equ $-1
                or a 
                ret z           ;   -- p ⮯p.
                dec a 
                ld (keycnt),a 
                ret nz          ; ⨤p p ⨨  RET --  

  ;H H,  H

                ld a,e 
                cp KOI_KEY
                jp z,set_koi
                cp KEY_866
                jp z,set_866
                cp CL_KEY       ; pp CAPS LOCK ?
                jr nz,nosyskey

                ld a,(capsflag) ; p祭 CAPS LOCK 䫠
                and 1
                dec a 
                ld (capsflag),a 
                xor a 
                ld (keycnt),a   ; ⮯p p饭
                ret 

nosyskey:       and 0x3f         ; pp ᪠- -> ASCII
                ld b,0
                ld c,a 
                dec c    ; 0 --  ᯮ
                bit 6,e 
                jr nz,symbol    ;   SYMBOL SHIFT

                ld hl,keylat    ;   ⮫쪮 㪢, p
keytbl          equ $-2         ; p  p
                add hl,bc 
                ld a,(hl)       ;  ⮩   ⠡

                cp '9'+1
                jr nc,nodig     ; 㪢  ᨬ
                bit 7,e 
                jr z,nocaps      ; CAPS  

                cp 0x0d          ; pp CAPS SHIFT
                jr z,capsent    ;  0..9, SPACE  ENTER
               HI-TECH C USER'S MANUAL                              Page 69


       13. Linker Reference Manual


            HI-TECH  C  incorporates  a  relocating  assembler  and
       linker  to  permit  separate  compilation of C source files.
       This means that a program may be divided into several source
       files,  each  of  which may be kept to a manageable size for
       ease of editing and compilation, then each object file  com-
       piled  separately  and  finally  all the object files linked
       together into a single executable program.

            The assembler  is  described  in  the  machine-specific
       manual.   This  appendix describes the theory behind and the
       usage of the linker.

       13.1. Relocation and Psects

            The fundamental  task  of  the  linker  is  to  combine
       several  relocatable object files into one. The object files
       are said to be relocatable since the files  have  sufficient
       information  in  them  so  that any references to program or
       data addresses (e.g. the address of a function)  within  the
       file  may  be  adjusted according to where the file is ulti-
       mately located in memory after the linkage process. Thus the
       file  is  said  to  be  relocatable. Relocation may take two
       basic forms; relocation by  name,  i.e.  relocation  by  the
       ultimate  value  of a global symbol, or relocation by psect,
       i.e. relocation by the base address of a particular  section
       of  code,  for  example  the  section of code containing the
       actual excutable instructions.

       13.1.1. Program Sections

            Any object file may  contain  bytes  to  be  stored  in
       memory  in  one  or  more  program  sections,  which will be
       referred to as psects. These psects represent logical group-
       ings  of  certain  types  of code bytes in the program.  The
       section of the program containing executable instructions is
       normally  referred  to as the text psect. Other sections are
       the initialized data psect, called simply  the  data  psect,
       and the uninitialized data psect, called the bss psect.

            In fact the linker will handle any  number  of  psects,
       and  in  fact more may be used in special applications. How-
       ever the C compiler uses only the three mentioned,  and  the
       names  text,  data and bss are simply chosen for identifica-
       tion; the linker assigns no special significance to the name
       of a psect.

            The difference between the data and bss psects  may  be
       exemplified  by  considering  two external variables; one is
       initialized to the value 1, and the other  is  not  initial-
       ized.  The first will be placed into the data psect, and the
       second in the bss psect. The bss psect is always cleared  to
       zeros  on  startup  of the program, thus the second variable
       will be initialized at run time to zero. The first will how-
       ever occupy space in the program file, and will maintain its






   Page 70                              HI-TECH C USER'S MANUAL

   initialized value of 1 at startup. It is quite  possible  to
   modify the value of a variable in the data psect during exe-
   cution, however it is better practice not to  do  so,  since
   this  leads  to more consistent use of variables, and allows
   for restartable and romable programs.

        The text psect is the section into which all executable
   instructions are placed. On CP/M-80 the text psect will nor-
   mally start at the base of the TPA, which is where execution
   commences.  The  data  psect  will  normally follow the text
   psect, and the bss will be last. The  bss  does  not  occupy
   space  in  the  program (.COM) file. This ordering of psects
   may be overridden by an option to the linker. This is  espe-
   cially useful when producing code for special hardware.

        For MS-DOS and CP/M-86 the psects are  or