;
; p ⥪⮢ ᮫ 64x24 ᨬ  ZX-Spectrum.
; ᯮ  p p (  p ᨬ)  p
; 1/3 p 䠩. p 樠樨   p 
; p   ᮤp    ᨬ (  p).
; p     CP866 p.
;


scr5   equ 1    ; 뢮  p  p 0x4000  0xc000

        global  _font64          ; p  2048  (  p)
        global  _font_2          ;  p 㦥 ⮫쪮  font64,
                                 ; p pp p 樠樨
        global  _mapscrn         ; ⠡ pp 256 
        global  _port_fe	 ; ﭨ pp p pp.

 EXPORT global _tty_putc    ; E=㪢  p
 EXPORT global _tty_puts    ; 뢮 p (DE)  BC.
 EXPORT global _tty_done    ; ᢮ ppᮢ, ⪫祭
 EXPORT global _tty_init    ; 樠,  p p 易⥫쭮 !
 EXPORT global _tty_timer   ; 50 p  ᥪ㭤


	psect text
;
; 0D                            p p⪨
; 0A                            p p
; 09                            ⠡
; 08                            
; 18                            p
; 19                            p
; 1A                            
; 0B    <ESC>H                   0,0
; 0C                            ⪠ p
; 16    <ESC>K                  ⪠   p
; 15                            ⪠ p
; 01                            ᫥. ᨬ  pp
; 07                            
; 0F                             -8
; 0E                             -7 p.
;       <ESC>Y[line+32][col+32] ⠭ 樨
;       <ESC>[line+128][col]    ⠭ 樨
;       <ESC>P[color]           ⠭ 梥
;       <ESC>V[1=on,0=off]      ⠭ pᨨ
;       <ESC>J                  ⪠   p ()
;       <ESC>Q                   pp 
;       <ESC>R                  몫 pp 
;       <ESC>[                   866 p
;       <ESC>Z                   -8
;       <ESC>]                   -8
;       <ESC>\                   -7 .
;       <SC>@                   -7 p.
;

blink   equ 12

width   equ 64
hsize    equ 24

_tty_done:
        ret 

_tty_init:
        jp $+3
ttyinita equ $-2
        ld hl, _font64
        push ix 
        push hl 
        push hl 
        ld ix, _font_2  ; 㪢 p p.
        ld e,0x0f
        call fontmake
        pop hl 
        pop ix 
        ld e,0x0f0
        call fontmake
        pop ix 
        ld hl,ttyinitb
        ld (ttyinita), hl 
ttyinitb:
        ld hl, _mapscrn
xxloop: ld (hl),l       ; p ⠡ pp, 砫 866 codepage
        inc l 
        jr nz,xxloop
        call clspr
        ret 

fontmake:  ld bc,0x0800
fmloop:    ld a,(hl) 
           and e 
           ld (ix),a 
           inc hl 
           inc ix 
           dec bc 
           ld a,b 
           or c 
           jr nz,fmloop
           ret 

_tty_putc:
        ld a, e 
        ld hl,curlock
        ld (hl),1
        call curs_off  ; (hl, de)

tty_putc_int:
        jp prcod
fjump   equ $-2

_tty_puts:
        push de 
        push bc 
        ld hl,curlock
        ld (hl),1
        call curs_off  ; (hl, de)
tty_puts1:
        pop bc 
        pop hl 
        ld a, b 
        or c 
        ret z 
        ld a,(hl) 
        inc hl 
        dec bc 
        push hl 
        push bc 
        call tty_putc_int
        jr tty_puts1

prcod:  cp 0x20
        jp nc,prchr          ;  ᨬ ?
        ld hl,(coord)
        cp 0x1b
        jp z,esc
        cp 0x0d
        jp z,cr
        cp 0x0a
        jp z,lf
        cp 0x09
        jp z,tab
        cp 0x08
        jp z,left
        cp 0x18
        jp z,right
        cp 0x19
        jp z,up
        cp 0x1a
        jp z,down
        cp 0x0b
        jp z,home
        cp 0x0c
        jp z,clspr
        cp 0x16
        jp z,clrel
        cp 0x15
        jp z,clrln        ; ⪠ p
        cp 0x01
        jp z,grf          ;  ᫥饣 ᨬ  p⪨
        cp 0x07
        jp z,bell
        cp 0x0f
        jp z,mkkoi8       ; 祭 koi8
        cp 0x0e
        jp z,mkkoi7r      ; koi7-r 

prchr:  ld l,a 
        ld h, _mapscrn/256
tblhi   equ $-1                ; pp  ⠡
        ld l,(hl) 

         ld de,0
coord    equ $-2
         srl e 
         jr c,prright

         ld h, _font64/256
         ld c,0x0f
         jp prcalc

prright: ld h, _font_2/256
         ld c,0x0f0

prcalc:  ld a,c 
         cpl 
         and 0
inverse  equ $-1
         ld b,a 

         ld a,d 
         rrca 
         rrca 
         rrca 
         and 0x0e0
         or e 
         ld e,a 
         ld a,d 
         and 0x18
         IF scr5
         or 0x40
         ELSE 
         or 0x0c0
         ENDIF 
         ld d,a 

        ld a,(de)     ; 뢮 㪢
        and c 
        or (hl) 
        xor b 
        ld (de),a 
        inc d 
        inc h 
        ld a,(de) 
        and c 
        or (hl) 
        xor b 
        ld (de),a 
        inc d 
        inc h 
        ld a,(de) 
        and c 
        or (hl) 
        xor b 
        ld (de),a 
        inc d 
        inc h 
        ld a,(de) 
        and c 
        or (hl) 
        xor b 
        ld (de),a 
        inc d 
        inc h 
        ld a,(de) 
        and c 
        or (hl) 
        xor b 
        ld (de),a 
        inc d 
        inc h 
        ld a,(de) 
        and c 
        or (hl) 
        xor b 
        ld (de),a 
        inc d 
        inc h 
        ld a,(de) 
        and c 
        or (hl) 
        xor b 
        ld (de),a 
        inc d 
        inc h 
        ld a,(de) 
        and c 
        or (hl) 
        xor b 
        ld (de),a 
                      ; cf=0 d=110xx111  xx<>11
        ld a,d 
        rra 
        rra 
        rra 
        IF scr5
        and 0x07f
        or 0x018
        ELSE 
        ENDIF 
        ld d,a          ; cf=1 d=110110xx
        ld a,0x038
color   equ $-1
        ld (de),a       ; ⠭ 梥

        ld hl,curs_on
        ld (curs_jp),hl ; pp ᥣ  (p 㪢)

        ld hl,(coord)
right:  inc l           ;  ᫥. .
        ld a,l 
        cp width
        jr nc,nxtln     ; p室  p p p ?

ctaddr: ld (coord),hl     ; ⠭ p.
        xor a 
        ld (curlock),a 
        ret 


home:   ld hl,0         ; ⠭ p 0,0.
        jr ctaddr

nxtln:  ld l,0           ; p室  砫 ᫥. p
lf:     ld a,hsize-1      ; p室  ᫥ p
        inc h 
        cp h 
        jp nc,ctaddr
        dec h 
        jp scroll
lfovadr equ $-2

scroll: push hl         ; p p  p p
        IF scr5
        ld hl,0x04020
        ld de,0x04000
        ELSE 
        ld hl,0x0c020
        ld de,0x0c000
        ENDIF 
scroll0: ld a,d          ; p 梥⮢
         rrca 
         rrca 
         rrca 
         IF scr5
         or 0x58
         ELSE 
         or 0x0c0
         ENDIF 
         ld d,a 
         ld a,h 
         rrca 
         rrca 
         rrca 
         IF scr5
         or 0x58
         ELSE 
         or 0x0c0
         ENDIF 
         ld h,a 
         call ldi32
         sla d 
         sla d 
         sla d 
         IF scr5
         res 7,d 
         ENDIF 
         sla h 
         sla h 
         sla h 
         IF scr5
         res 7,h 
         ENDIF 
scroll1: call ldi32     ; p p
        inc h 
        inc d 
        ld a,h 
        and 7
        jp nz,scroll1   ; p (8 . ) p ?
        ld a,l 
        add a,0x20
        ld l,a          ;  ᫥. p
        ld a,h 
        jr z,scroll2    ; p襫  ᫥. 1/3 p
        sub 8
        ld h,a 
        jp scroll4

scroll2:
        IF scr5
        cp 0x51
        ELSE 
        cp 0x0d1
        ENDIF 
        jr c,scroll4
        IF scr5
        ld hl,0x050e0
        ELSE 
        ld hl,0x0d0e0
        ENDIF 
        ld e,l 
        ld c,1
        call clrl01      ; ⪠ ᫥ p
        pop hl 
        jp ctaddr

scroll4: ld a,e 
        add a,0x20       ;  ᫥. p (⥯p p)
        ld e,a 
        jp z,scroll0
        ld a,d 
        sub 8           ;  ᫥. 1/3 p
        ld d,a 
        jp scroll0

ldi32:   ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        ldi 
        dec hl 
        dec de 
        ld a,l 
        and 0x0e0
        ld l,a 
        ld a,e 
        and 0x0e0
        ld e,a 
        ret 


tab:    ld a,l          ; ⠡
        or 0x07
        ld l,a 
        jp right

cr:     ld l,0          ; p p⪨
        jp ctaddr

down:   inc h           ; 
        ld a,h 
        cp hsize
        jp c,ctaddr
        ld h,0
        jp ctaddr

left:   dec l           ; 
        ld a,l 
        inc a 
        jp nz,ctaddr
        ld l,width-1
up:     dec h           ; p
        ld a,h 
        inc a 
        jp nz,ctaddr
        ld h,hsize-1
        jp ctaddr

clrel:  push hl           ; clear to end of line
        ld hl,ctaddr
        ld (lfovadr),hl 
clrel1: ld a,0x20
        call prchr
        ld a,l 
        or a 
        jr nz,clrel1
        ld hl,scroll
        ld (lfovadr),hl 
        pop hl 
        jp ctaddr

esc:    ld hl,esc1       ; ESC ᫥⥫쭮
setfjp: ld (fjump),hl 
rcurs:  ld hl,curlock
        ld (hl),0
        ret 

esc1:   cp 0x80
        jr nc,posit       ; ⠭ 樨 ᥩ [+1 byte]
        cp 'Y'
        jr z,pposit       ; ⠭ 樨  ᫥. ᨬ [+2 bytes]
        cp 'P'
        jp z,setcol       ; ⠭ 梥⮢ [+1 byte]
        cp 'V'
        jp z,setinv       ; ⠭ pᨨ [+1 bytes]
        ld hl,prcod
        ld (fjump),hl     ; ᫥騩 ᨬ  㤥 p ESC .
        cp 'H'
        jp z,home         ; ⠭ 0,0.
        ld hl,(coord)
        cp 'K'
        jr z,clrel        ; ⪠   p
        cp 'J'
        jp z,clres        ; ⪠   p
        cp 'Q'
        jp z,cmode0       ; \
        cp 'R'            ;  |  / 몫 pp 
        jp z,cmode1       ; /
        cp '['
        jp z,mkalt        ; set 866 code page
        cp 'Z'
        jp z,mkkoi8       ; set koi8 code page
        cp ']'
        jp z,mkkoi8       ; set koi8
        cp 0x05c
        jp z,mkkoi7l      ; koi7 latin characters
        cp '@'
        jp z,mkkoi7r      ; koi7 with russian characters
        jp prchr

pposit: ld hl,pposit1     ; ⠭ 樨  ᫥. ᨬ [+2 bytes]
        jr setfjp
pposit1: sub 0x20           ; p p -- p
        ld (pcoord),a 
        ld hl,pposit2
        jr setfjp
pposit2: sub 0x20           ; 
        jr setpos

posit:  and 0x7f           ; ⠭ 樨 ᥩ [+1 byte]
        ld (pcoord),a     ; p p.
        ld hl,posit1
        jr setfjp
posit1: and 0x7f           ; 
setpos: ld hl,prcod
        ld (fjump),hl 
        cp width          ; pp ⠭ p
        jp nc,rcurs       ;  ᮮ⢥⢨ pp p
        ld l,a 
        ld a,hsize-1
        ld h,0
pcoord  equ $-1
        cp h 
        jp c,rcurs        ; CF p  p p
        jp ctaddr

grf:    ld hl,grf1        ;  ᫥饣 ᨬ  p⪨
        jp setfjp
grf1:   ld hl,prcod
        ld (fjump),hl 
        jp prchr

bell:   ld a, (_port_fe)     ; .
        ld c,120      ; parity  numbers only
bell1:  xor 0x10
        out (0x0fe),a       ; use beeper
        ld b,80
        djnz $
        dec c 
        jr nz,bell1
        jp rcurs

clspr:   ld hl,0              ; ⪠ p
        ld (coord),hl 
        IF scr5
        ld h,0x40
        ELSE 
        ld h,0x0c0
        ENDIF 
        ld c,hsize
        ld e,l 
        jr clrl01


clrln:  ld c,1          ; ⪠ p
        jr clrln1

clres:  ld a,hsize               ; ⪠   p
        sub h 
        ld c,a 
clrln1: ld hl,(coord)
           srl l 
           ld a,h 
           rrca 
           rrca 
           rrca 
           and 0x0e0
           or l 
           ld l,a 
           ld a,h 
           and 0x18
           IF scr5
           or 0x40
           ELSE 
           or 0x0c0
           ENDIF 
           ld h,a 
        ld a,l 
        and 0x0e0
clrl0:  ld e,a 
clrl01:    ld l,e               ; pp᪠ p
           ld a,h 
           rrca 
           rrca 
           rrca 
           IF scr5
           or 0x58
           ELSE 
           or 0x0c0
           ENDIF 
           ld h,a 
           ld a,(color)
           call fill32
           sla h 
           sla h 
           sla h 
           IF scr5
           res 7,h 
           ENDIF 
clrl1:  ld l,e                 ; ⪠ p
        xor a 
        call fill32
        inc l 
        inc h 
        ld a,h 
        and 7
        jp nz,clrl1
        dec c 
        jp z,rcurs
        ld a,l 
        or a 
        jr z,clrl0
        ld a,h 
        sub 8
        ld h,a 
        ld a,l 
        jp clrl0

fill32: ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        inc l 
        ld (hl),a 
        ret 

setcol: ld hl,setcol1       ; ⠭ 梥
        jp setfjp
setcol1: ld (color),a 
        and 0x38
        rrca 
        rrca 
        rrca 
        ld hl, _port_fe
        xor (hl)
        and 0xf8
        xor (hl) 
        ld (hl),a 
        out (0x0fe),a 
restfjp: ld hl,prcod
        ld (fjump),hl 
        jp rcurs

setinv: ld hl,setinv1      ; ⠭ pᨨ.
        jp setfjp
setinv1: and 1
        jr z,setinv2
        ld a,0x0ff
setinv2: ld (inverse),a 
        jr restfjp

cmode0: xor a               ;  / 몫 pp 
        jr cmodes
cmode1: ld a,1
cmodes: ld (curmode),a 
        jp rcurs

mkalt:  ld hl,rcurs          ; 866 code page
        push hl 
        ld bc,0x0c040
mkalt1: ld hl,(tblhi-1)
        ld l,0x40
mkalt2: ld (hl),c 
        inc c 
        inc l 
        djnz mkalt2
        ret 

mkkoi8: ld bc,0x4040          ; koi8
        call mkalt1
mkkoi8h: ld bc,0x20c0
        call mkalt2
        ld bc,0x10f0
        call mkalt2
        ld bc,0x10b0
        call mkalt2
        call koi7s
        ld (hl),0x0ea
        inc l 
        call koi7b
        ld (hl),0x9a
        jp rcurs

mkkoi7l: ld bc,0x2040
        call mkalt1
mkkoi7e: call koi7b
        ld (hl),l 
        inc l 
        jr mkkoi8h

mkkoi7r: ld hl,(tblhi-1)
         ld l,0x40
        call koi7s
        ld (hl),l 
        inc hl 
        jr mkkoi7e

koi7b:  ld de,tkoi1
        call koi7m
        ld bc,0x0888
        call mkalt2
        ld (hl),0x9f
        inc l 
        ld bc,0x0490
        call mkalt2
        ld de,tkoi2
koi7m:  ex de,hl 
        ld bc,9
        ldir 
        ex de,hl 
        ret 

koi7s:  ld de,tkoi1
        call koi7n
        ld bc,0x08a8
        call mkalt2
        ld (hl),0x0ef
        inc l 
        ld bc,0x04e0
        call mkalt2
        ld de,tkoi2
koi7n:  ld b,9
koi71:  ld a,(de) 
        inc de 
        bit 4,a 
        jr z,koi72
        and 0x0ef
        or 0x40
koi72:  or 0x20
        ld (hl),a 
        inc l 
        djnz koi71
        ret 


_tty_timer:
        ld a,0         ;   pp
curlock equ $-1        ; p 
        dec a 
        ret z 
        ld a,0
curmode equ $-1        ; pp 祭 ?
        dec a 
        ret z 
        ld hl,curcnt
        dec (hl)        ; p 諮 ?
        ret nz 
        ld (hl),blink   ;  
        jp curs_on
curs_jp equ $-2

curs_on: ld hl,(coord)    ; 祭 pp
           srl l 
           jr c,curight
           ld c,0x0f0
           jp cucalc
curight:   ld c,0x0f
cucalc:    ld a,h 
           rrca 
           rrca 
           rrca 
           and 0x0e0
           or l 
           ld l,a 
           ld a,h 
           and 0x18
           IF scr5
           or 0x47
           ELSE 
           or 0x0c7
           ENDIF 
           ld h,a 
        ld (curaddr),hl 
        ld a,(hl) 
        ld e,a 
        or c 
        ld (hl),a 
        dec h 
        ld a,(hl) 
        ld d,a 
        or c 
        ld (hl),a 
        ld (cursafe),de 
        ld hl,curs_off
        ld (curs_jp),hl 
        ld (hl),0x021    ; LD HL,NN
        ret 

curs_off: ld hl,0            ; 몫祭 pp
curaddr  equ $-2
         ld de,0
cursafe  equ $-2
         ld (hl),e 
         dec h 
         ld (hl),d 
         ld hl,curs_on
         ld (curs_jp),hl 
         ld hl,curcnt
         ld (hl),blink
         ld hl,curs_off
         ld (hl),0x0c9   ; RET 
         ret 

	psect data

curcnt: db blink             ; 稪  

	psect text

tkoi1:  db 0x9e,0x80,0x81,0x96,0x84,0x85,0x94,0x83,0x95
tkoi2:  db 0x086,0x082,0x09c,0x09b,0x087,0x098,0x09d,0x099,0x097


 