; vim: set syntax=z8a:

	global	small_model
	psect	text,class=CODE
	global	_heap_search_free
	signat	_heap_search_free,8250

; heap: magic:2, top:2, bottom:2, cur:2, free:2
; block: magic:2, size:2, data... -2=size:2

HEAP_BUSY equ 1
HEAP_MAGIC equ 0xdea0
HEAP_MINALLOC equ 6
FATAL:
	di
	halt
	jp FATAL

; BC: untouched
; hl=*block  -> hl=*block+2
block_valid:
	ld a, (hl)
	and .not. HEAP_BUSY
	xor HEAP_MAGIC .mod. 256
	jr nz, 1f
	inc hl
	ld a, (hl)
	xor HEAP_MAGIC / 256
	inc hl
	ret z			; CF=0
1:		ld de, 1
		call FATAL

; hl=block+2  BC: untouched
; -> de=block+2, hl=*next, CF=1 if next==bottom
block_next:
	ld e, (hl)
	inc hl
	ld d, (hl)
	dec hl
	ex de, hl
	add hl, de	; hl=next+2, de=cur+2
	dec hl
	dec hl
	ld a, l
	sub (ix+2)
	ld a, h
	sbc a, (ix+3)
	ccf
	ret z		; next==top, CF=1
	jr c, 1f	; next>top
	call block_valid
	dec hl
	dec hl
	ret
1:		ld de, 1
		call FATAL
	
	
	

	

; struct hblock *heap_search_free (struct heap *h, int size)
_heap_search_free:
	push ix
; DE = *h, BC = size
;	db 0xdd
;	ld l, e
;	db 0xdd
;	ld h, d	; ix = *h
	;db 0xdd
	;db 0

		push de
		pop ix
	ld l, (ix+6)
	ld h, (ix+7)  ; HL=h->cur

hsfree_loop: ; hl=cur, bc=size
	call block_valid
	call block_next	; de=cur+2, hl=next, CF=(next==top)
	push af		; CF=(n==top)
	push hl		; nextb=next
	jr nc, 1f
	ld l, (ix+4)
	ld h, (ix+5)
	ex (sp), hl	; nextb=h->bottom
1:
	dec de
	dec de
	ld a, (de)
	rra
	jp c, hsfree_next ; current busy

        ; if (BLOCK_DATA_SIZE(cur) >= size)
	push hl
	ex de, hl	; hl=cur, de=next
	inc hl
	inc hl
	ld e, (hl)
	inc hl		; hl=cur+3
	ld d, (hl)	; de=size
	ex de, hl
	ld a, l
	sub 6		; sizeof(struct hblock)
	ld l, a
	jr nc, 2f
	dec h
2:	or a
	sbc hl, bc
	jr nc, 3f
	; if-false
	pop hl		; hl=next, (de=cur+3)
	jp c, hsfree_next

3:	; if-true
	push hl		; block_size-size
	ld hl, 4
	add hl, sp
	ld a, (hl)	; h->cur=nextb
	ld (ix+6), a
	inc hl
	ld a, (hl)
	ld (ix+7), a
	
	dec de
	dec de
	dec de
	ld a, HEAP_MAGIC+1
	ld (de), a	; set BUSY current

	; if (tail_size > min_block_size)
	pop hl		; block_size-size
	ld a, h
	or a
	jr nz, 4f
	ld a, l
	cp HEAP_MINALLOC
	jr nc, 4f	; tail size >= min.
	; if-false
	pop hl		; hl=next
	ex de, hl  	; hl=cur
	jr hsfree_return

4:	;if-true -- cut tail
	; de=cur, (sp)=(n==top),nextb, next
	ld hl, 6	; sizeof(struct hblock)
	add hl, bc
	ex de, hl
	inc hl
	inc hl		; hl=cur+2, de=size
	ld (hl), e
	inc hl
	ld (hl), d	; SET_SIZE(cur)
	dec hl
	
	push hl		; cur+2
	dec hl
	dec hl
	add hl, de	; hl=*tail
	dec hl
	ld (hl), d
	dec hl
	ld (hl), e	; set prev_size 
	inc hl
	inc hl
	pop de
	ex de, hl
	ex (sp), hl	; de=tail, hl=next
			; sp= (n==top), nextb, cur+2
	push hl
	ld hl, 6
	add hl, sp
	bit 0, (hl)	; (next==top) -> !Z
	pop hl
	jr nz, 5f	; next==top

	ld a, (hl)
	rra
	jr c, 5f	; next busy

	push de
	inc hl
	inc hl
	call block_next	; hl=*nn, de=*n+2, CF
	jr c, 6f
	ld a, (hl)	; is_block_busy(nn)?
	rra
	jr c, 6f	; busy
		ld de, 1
		call FATAL
6:
	xor a
	dec de
	ld (de), a
	dec de
	ld (de), a	; n->magic=0
	pop de		; tail
	ld (ix+6), e
	ld (ix+7), d	; h->cur=tail

5:	; hl=next/top, de=tail
	; sp= (n==top), nextb, cur+2
	ex de, hl
	ld (hl), HEAP_MAGIC .mod. 256
	inc hl
	ld (hl), HEAP_MAGIC / 256
	dec hl
	ex de, hl	; de=tail
	push hl		; next/top
	or a
	sbc hl, de
	ex de, hl	; de=size
	inc hl
	inc hl
	ld (hl), e
	inc hl
	ld (hl), d	; set_size(tail)
	pop hl
	dec hl
	ld (hl), d
	dec hl
	ld (hl), e	; set_prev_size

	pop hl
	dec hl
	dec hl	; hl=cur
	
hsfree_return:
	pop de	; nextb
	pop de	; (n==top)
	pop ix
	ret	; hl=*block
	

hsfree_next:
	pop hl		; nextb
	pop de		; (n==top)
	ld a, l
	cp (ix+6)
	jp nz, hsfree_loop
	ld a, h
	cp (ix+7)
	jp nz, hsfree_loop

	pop ix
	ld hl, 0
	ret



	global	_heap_realloc
	signat	_heap_realloc,12346
;D:\HITECH\ZXLIB\HEAP\HEAP.C: 252: void *heap_realloc (struct heap *h, void *addr, int size)
;D:\HITECH\ZXLIB\HEAP\HEAP.C: 253: {
	line	253
_heap_realloc:
	push	ix
	push de
	pop ix		; *h

	ex de, hl	; hl=*heap
	ld a, (hl)
	cp HEAP_MAGIC .mod. 256
	jr nz, 1f
	inc hl
	ld a, (hl)
	cp HEAP_MAGIC / 256
	jr nz, 2f
1:		ld de, 1
		call FATAL
2:
	ld hl, 4
	add hl, sp
	push bc
	ld a, (hl)
	inc hl
	ld h, (hl)
	ld l, a
	ex (sp), hl	; hl=addr, (sp)=size
	ld de, -6	; sizeof(struct hblock)
	add hl, de	; hl=*block
	; heap: magic:2, top:2, bottom:2, cur:2, free:2
	ld e, (ix+4)
	ld d, (ix+5)	; h->bottom
	or a
	sbc hl, de
	jp c, 3f	; b < bottom!	; FIXME: jr, c ?
3:	add hl, de
	ld e, (ix+6)
	ld d, (ix+7)
	ex de, hl
	or a
	sbc hl, de




	
	IF 0

_heap_search_free_OLD:
	push	ix
	ld	ix,0
	add	ix,sp
	ld	hl,-14
	add	hl,sp
	ld	sp,hl
	push	iy
;_size stored from bc
	line	113
	ld	(ix+-2),c
	ld	(ix+-1),b
; _h loaded to iy
	push	de
	pop	iy
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 81: struct hblock *b, *nextb;
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 82: b=h->cur;
	line	82
	ld	l,(iy+6)
	ld	h,(iy+7)
	ld	(ix+-8),l
	ld	(ix+-7),h
;_h stored from iy
	push	iy
	pop	hl
	ld	(ix+-6),l
	ld	(ix+-5),h
	line	83
l10:
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 83: do {
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 84: struct hblock *n;
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 85: if (!(((b)->magic&~1) == 0xdea0)) fatal("f_unknown()", 85);
; _b loaded to iy
	line	85
	ld	l,(ix+-8)
	ld	h,(ix+-7)
	push	hl
	pop	iy
	ld	bc,-8544
	ld	l,(iy+0)
	ld	h,(iy+1)
	res	0,l
	or	a
	sbc	hl,bc
	jp	z,l11
	ld	bc,055h
	ld	de,u19
	call	_fatal
l11:
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 87: n=( (struct hblock*)((char*)(b) + (b)->size) );
; _n allocated to bc
	line	87
	push	iy
	pop	de
	ld	l,(iy+2)
	ld	h,(iy+3)
	add	hl,de
	push	hl
	pop	bc
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 88: if ((void*)n >= h->top) {
	line	88
	ld	l,(ix+-6)
	ld	h,(ix+-5)
	inc	hl
	inc	hl
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	ld	l,c
	ld	h,b
	or	a
	sbc	hl,de
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 89: if ((void*)n != h->top) fatal("f_unknown()", 89);
;_n stored from bc
	line	89
	ld	(ix+-10),c
	ld	(ix+-9),b
	jp	c,L1

	ld	l,(ix+-6)
	ld	h,(ix+-5)
	inc	hl
	inc	hl
	ld	a,(hl)
	inc	hl
	ld	h,(hl)
	ld	l,a
	or	a
	sbc	hl,bc
	jp	z,l13
	ld	bc,059h
	ld	de,u29
	call	_fatal
l13:
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 90: nextb = h->bottom;
	line	90
	ld	l,(ix+-6)
	ld	h,(ix+-5)
	inc	hl
	inc	hl
	inc	hl
	inc	hl
	ld	c,(hl)
	inc	hl
	ld	b,(hl)
	ld	(ix+-4),c
	ld	(ix+-3),b
; _n loaded to bc
	ld	c,(ix+-10)
	ld	b,(ix+-9)
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 91: } else {
	line	91
	jp	l14
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 92: if (!(((n)->magic&~1) == 0xdea0)) fatal("f_unknown()", 92);
;_n stored from bc
	line	92
L1:
	ld	de,-8544
	ld	l,c
	ld	h,b
	ld	a,(hl)
	inc	hl
	ld	h,(hl)
	ld	l,a
	res	0,l
	or	a
	sbc	hl,de
	jp	z,l15
	ld	bc,05Ch
	ld	de,u39
	call	_fatal
l15:
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 93: nextb = n;
; _n loaded to bc
	line	93
	ld	c,(ix+-10)
	ld	b,(ix+-9)
	ld	(ix+-4),c
	ld	(ix+-3),b
	line	94
l14:
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 94: }
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 96: if ((((b)->magic&1) == 0) && (((b)->size - sizeof(struct hblock)) >= size) ) {
	line	96
	bit	0,(iy+0)
	jp	nz,l16
	ld	de,06h
	ld	l,(iy+2)
	ld	h,(iy+3)
	or	a
	sbc	hl,de
	ld	e,(ix+-2)
	ld	d,(ix+-1)
	or	a
	sbc	hl,de
	jp	c,l16
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 98: h->cur = nextb;
	line	98
	ld	l,(ix+-6)
	ld	h,(ix+-5)
	ld	de,06h
	add	hl,de
	ld	e,(ix+-4)
	ld	d,(ix+-3)
	ld	(hl),e
	inc	hl
	ld	(hl),d
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 99: ((b)->magic=(0xdea0|1));
	line	99
	ld	(iy+0),0A1h
	ld	(iy+1),0DEh
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 105: if (((b)->size - sizeof(struct hblock)) - size >= sizeof(struct hblock)) {
	line	105
	ld	de,06h
	ld	l,(iy+2)
	ld	h,(iy+3)
	or	a
	sbc	hl,de
	ld	e,(ix+-2)
	ld	d,(ix+-1)
	or	a
	sbc	hl,de
	ld	de,06h
	or	a
	sbc	hl,de
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 106: struct hblock *t;
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 107: ( (b)->size = ((char*)(char*)b+size+sizeof(struct hblock)-(char*)b) );
	line	107
	push	iy
	jp	c,L2

	pop	de
	ld	l,(ix+-2)
	ld	h,(ix+-1)
	add	hl,de
	ld	de,06h
	add	hl,de
	push	iy
	pop	de
	or	a
	sbc	hl,de
	ld	(iy+2),l
	ld	(iy+3),h
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 108: t=( (struct hblock*)((char*)(b) + (b)->size) );
	line	108
	push	iy
	pop	de
	add	hl,de
	ld	(ix+-12),l
	ld	(ix+-11),h
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 109: (((int*)(t))[-1])=b->size;
	line	109
	ld	de,-2
	add	hl,de
	ld	e,(iy+2)
	ld	d,(iy+3)
	ld	(hl),e
	inc	hl
	ld	(hl),d
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 110: if (((void*)n != h->top) && ((((n)->magic&1) == 0))) {
	line	110
	ld	l,(ix+-6)
	ld	h,(ix+-5)
	inc	hl
	inc	hl
	ld	a,(hl)
	inc	hl
	ld	h,(hl)
	ld	l,a
	or	a
	sbc	hl,bc
	jp	z,l18
	ld	l,c
	ld	h,b
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	bit	0,e
	jp	nz,l18
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 113: struct hblock *nn;
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 114: nn=( (struct hblock*)((char*)(n) + (n)->size) );
	line	114
	ld	e,c
	ld	d,b
	ld	l,c
	ld	h,b
	inc	hl
	inc	hl
	ld	a,(hl)
	inc	hl
	ld	h,(hl)
	ld	l,a
	add	hl,de
	ld	(ix+-14),l
	ld	(ix+-13),h
;_n stored from bc
	ld	(ix+-10),c
	ld	(ix+-9),b
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 115: if ((void*)nn >= h->top) {
	line	115
	ld	l,(ix+-6)
	ld	h,(ix+-5)
	inc	hl
	inc	hl
	ld	c,(hl)
	inc	hl
	ld	b,(hl)
	ld	l,(ix+-14)
	ld	h,(ix+-13)
	or	a
	sbc	hl,bc
	jp	c,l19
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 116: if ((void*)nn != h->top) fatal("f_unknown()", 116);
	line	116
	ld	c,(ix+-14)
	ld	b,(ix+-13)
	ld	l,(ix+-6)
	ld	h,(ix+-5)
	inc	hl
	inc	hl
	ld	a,(hl)
	inc	hl
	ld	h,(hl)
	ld	l,a
	or	a
	sbc	hl,bc
	jp	z,l21
	ld	bc,074h
	ld	de,u49
	call	_fatal
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 117: } else {
	line	117
	jp	l21
	line	131
l16:
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 131: }
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 133: b=nextb;
	line	133
	ld	l,(ix+-4)
	ld	h,(ix+-3)
	ld	(ix+-8),l
	ld	(ix+-7),h
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 135: } while (b != h->cur);
	line	135
	ld	c,(ix+-8)
	ld	b,(ix+-7)
	ld	l,(ix+-6)
	ld	h,(ix+-5)
	ld	de,06h
	add	hl,de
	ld	a,(hl)
	inc	hl
	ld	h,(hl)
	ld	l,a
	or	a
	sbc	hl,bc
	jp	nz,l10
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 137: return ((void *)0);
	line	137
	ld	hl,0
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 138: }
	line	138
l7:
	pop	iy
	ld	sp,ix
	pop	ix
	ret	
l19:
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 118: if (!((nn)->magic == (0xdea0|1))) fatal("f_unknown()", 118);
	line	118
	ld	bc,-8543
	ld	l,(ix+-14)
	ld	h,(ix+-13)
	ld	a,(hl)
	inc	hl
	ld	h,(hl)
	ld	l,a
	or	a
	sbc	hl,bc
	jp	z,l21
	ld	bc,076h
	ld	de,u59
	call	_fatal
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 119: }
	line	119
l21:
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 120: n->magic = 0;
; _n loaded to bc
	line	120
	ld	c,(ix+-10)
	ld	b,(ix+-9)
	ld	l,c
	ld	h,b
	ld	(hl),0
	inc	hl
	ld	(hl),0
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 121: n = nn;
	line	121
	ld	c,(ix+-14)
	ld	b,(ix+-13)
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 122: h->cur = t;
	line	122
	ld	l,(ix+-6)
	ld	h,(ix+-5)
	ld	de,06h
	add	hl,de
	ld	e,(ix+-12)
	ld	d,(ix+-11)
	ld	(hl),e
	inc	hl
	ld	(hl),d
	line	123
l18:
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 123: }
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 125: ((t)->magic=0xdea0);
	line	125
	ld	l,(ix+-12)
	ld	h,(ix+-11)
	ld	(hl),0A0h
	inc	hl
	ld	(hl),0DEh
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 126: ( (t)->size = ((char*)n-(char*)t) );
	line	126
	ld	e,(ix+-12)
	ld	d,(ix+-11)
	ld	l,c
	ld	h,b
	or	a
	sbc	hl,de
	ex	de,hl
	inc	hl
	inc	hl
	ld	(hl),e
	inc	hl
	ld	(hl),d
	dec	hl
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 127: (((int*)(n))[-1]) = t->size;
	line	127
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	ld	hl,-2
	add	hl,bc
	ld	(hl),e
	inc	hl
	ld	(hl),d
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 128: }
;C:\HITECH\ZXLIB\HEAP\HEAP.C: 130: return b;
	line	130
	push	iy
L2:
	pop	hl
	jp	l7

	ENDC

	end
	
