;---- save basic program to disk -----
; compile and execute this file to save
; executable basic file of loader
;
;arguments:
; _name_
;       db "8 chars"  name of executable file (w/o ext.)
; _start_
;       start address of code block
; _end_
;       end address of code block
; start
;       execution entry point of code
; _clear_
;       CLEAR argument (optional)
;       (defalt is _start_-1)


        ORG 0xfe00
basic_end:
        ENT SAVE_BASIC
SAVE_BASIC:
        ld de, basic_end-1

 ; copy end of basic stub
        ld hl, basic_stub_end-1
        ld bc, basic_stub_end-basic_stub_space
        lddr

 ; move code block to end of workspace
        ld hl, _end_-1
        ld bc, _end_-_start_
        lddr 

 ; copy basic stub before code block
        ld hl, basic_stub_space-1
        ld bc, basic_stub_space-basic_stub_start
        lddr 

        inc de 
        push de   ; basic_start

     ; save name.C
        ld hl, _name_
        ld de, 0x5cdd
        ld bc, 8
        ldir 
        ld a, "C"
        ld (de), a 
        pop de    ; basic_start
        ld hl, basic_end
        xor a
        sbc hl, de
        ex de, hl 
        ld c, 0x0b
        call 0x3d13

     ; .C -> .B, save FCB, fileno
        ld a, "B"
        ld (0x5ce5), a 
        ld a, (0x5d1e)
        push af      ; fileno
        ld hl, -16
        add hl, sp
        ld sp, hl
        ex de, hl
        ld hl, 0x5cdd
        ld bc, 16
        ldir 

     ; delete name.B
        ld a, 9
        ld (0x5d06), a 
        ld c, 0x12
        call 0x3d13

     ; restore fileno, FCB, rename .C .B
        ld hl, 0
        add hl, sp
        ld de, 0x5cdd
        ld bc, 16
        ldir
        ld sp, hl
        pop af 
        ld hl, (0x5ce8)
        ld de, -4    ; minus autostart record length
        add hl, de 
        ld (0x5ce6), hl ; basic length
        ld (0x5ce8), hl ; basic+var length
        ld c, 0x09
        call 0x3d13
        ret 

;-----------------------------------
; this is short BASIC stub

BASNUM:  MACRO 
        db "0"
        db 0x0e
        dw 0
        dw =1
        db 0
        ENDM 

basic_stub_start:
        db 0x3d, 0x13
        dw bs_line_end-bs_line_start+_end_-_start_
bs_line_start:
 ; RAND USR (n+(PEEK 23635)+256*PEEK 23636) : REM code...
        db 0xf9, 0xc0, "("
        BASNUM bs_entry-basic_stub_start
        db "+", "(", 0xbe
        BASNUM 0x5c53: db ")"
        db "+": BASNUM 256: db "*"
        db 0xbe: BASNUM 0x5c54
        db ")", ":", 0xea

bs_entry:
   ; clear <end of code+n>
        ld bc, _end_+0x100  ; FIXME!
        call 0x1eb7

; move code block to its execution address
        ld hl, (0x5c53)
        ld de, basic_stub_space-basic_stub_start+_end_-_start_-1
        add hl, de 
        ld de, _end_-1
        ld bc, _end_-_start_
        lddr 

   ; CLEAR below <start of code>
        res 4, (iy+1)
        ld hl, (0x5c53)
        ld (0x5c4b), hl 
        ld (hl), 0x80
        inc hl 
        ld (0x5c59), hl 
        ld (hl), 0x0d
        inc hl
        ld (hl), 0x80
        inc hl
        ld (0x5c61), hl 
        ld (0x5c63), hl 
        ld (0x5c65), hl 
        ld hl, start   ; jump to code entry
        push hl 
        ld bc, _clear_
        jp 0x1eb7

basic_stub_space:

; basic end of REM line
        db 0x0d
bs_line_end:

        db 0x80
        db 0xaa    ; autostart record
        dw 0x3d13

basic_stub_end:

        if basic_stub_end&0xc000
        else 
        error
        endif 

        IFNDEF _clear_
_clear_ equ _start_-1
        ENDIF 

 
