#ifdef MAKE_DOC

<section><title id="math.ldiv">ldiv</title>
<simpara>
    (HL',HL) = (HL',HL) / (DE',DE)
</simpara><simpara>
    (DE',DE) = (HL',HL) % (DE',DE)
</simpara>
<para> 㭪   32-ࠧ來 ᫠. 
  ॣ HL'  HL ( HL' 訥 ࠧ).
⥫   ॣ DE'  DE ( DE' 訥 ࠧ).
  頥  ॣ HL'  HL
( HL' 訥 ࠧ). ⮪   頥 
ॣ DE'  DE ( DE' 訥 ࠧ).
</para>
</section>

#else

 EXPORT global ldiv  ; (HL'HL)=(HL'HL)/(DE'DE), (DE'DE)=(HL'HL) % (DE'DE)

;  32-ࠧ來 
; 㭪 ⮨   ⥩:
; 1. 32-ࠧ來   16-ࠧ來
;    ⥫.
; 2. 32-ࠧ來   32-ࠧ來
;    ⥫.
; hl'hl = hl'hl / de'de
; de'de = hl'hl % de'de
	psect text
ldiv:
        push hl 
        xor a 
        ld l, a
        ld h, a 
        sub e 
        ld e, a
        sbc a, d
        sub e
        ld d, a
        exx 
        pop bc 
        ld a, 0
        sbc a, e
        ld e, a
        sbc a, d  ; de'de=0-divisor
        sub e
        ld d, a 
        and e
        inc a     ; Z=short divisor
        push hl 
        ld hl, 0  ; hl'hl=reminder
        exx 
        pop bc 
        ld a, b   ; a,c,bc'=divident

        jr nz, ldiv_long


    ; divisor = -00de
        ld b, 8
        rla 
ldivs0:
        rl l 
        add hl, de 
        jr c, ldivs1
        sbc hl, de 
ldivs1:  rla 
        djnz ldivs0

           ld b, c
           ld c, a
           ld a, b 
           ld b, 8
        rla
ldivs2:
        adc hl, hl
        add hl, de
        jr c, ldivs3
        sbc hl, de
ldivs3:  rla
        djnz ldivs2
        jr ldiv_long1


   ; divisor=-de'de
ldiv_long:
        call ldiv_8
           ld b, c
           ld c, a
           ld a, b
        call ldiv_8
ldiv_long1:
           exx 
           ex af, af' 
           ld a, b
           ex af, af'
           ld b, a
           ex af, af'
           exx 
        call ldiv_8
           exx
           ex af, af'
           ld a, c
           ex af, af'
           ld c, a
           ex af, af'
           exx 
        call ldiv_8

  ; result=c,bc',a -> hl'hl 
  ; reminder=hl'hl -> de'de 

        ex de, hl 
        ld l, a 
        ld a, c 
        exx
        ex de, hl 
        ld h, a
        ld l, b
        ld a, c 
        exx 
        ld h, a
        ret 


; hl'hl=reminder
; de'de=divisor
; a=divident
ldiv_8:
        ld b, 8
        rla 
ldiv_8_0:
        adc hl, hl
        exx
        adc hl, hl 
        exx
        add hl, de 
        exx 
        adc hl, de 
        exx 
        jr c, ldiv_8_1
        sbc hl, de 
        exx
        sbc hl, de
        exx 
ldiv_8_1:
        rla 
        djnz ldiv_8_0
        ret 

#endif

