#ifdef MAKE_DOC

<section><title id="math.lmul">lmul</title>
<simpara>
    (DE',DE,HL',HL) = (HL'HL) * (DE',DE)
</simpara>
<para>㭪 ६  32-ࠧ來 ᫠  砥
64-ࠧ來 १.  ᮬ⥫   ॣ
HL'  HL ( HL' 訥 ࠧ). ன ᮬ⥫  
ॣ DE'  DE ( DE' 訥 ࠧ). 
頥  ॣ DE',DE,HL',HL ( DE' -- 訥 ࠧ,
 HL 訥).
</para>
</section>

#else

 EXPORT global lmul   ; long long (DE'DE,HL'HL) = (HL'HL)*(DE'DE)

;  㬭 32-ࠧ來
; ᥫ
; de'de,hl'hl=hl'hl*de'de 
	psect text
lmul:
        ld a, h
        ex af, af'
        ld a, l
        exx
        ld c, l
        ld b, h 
        ex af, af' 
        exx      ; bc'a'a=2-nd mult.

  ; hl'hl=production
  ; de'de=multiplicator
  ; a = 2-nd multiplicator

        call lmul_8
        push af 
        exx 
        push hl  ; hi
        ex af, af' 
        exx
        push hl  ; low
        call lmul_8
        push af 
        exx
        push hl
        ld a, c
        exx
        push hl
        call lmul_8
        push af 
        exx
        push hl
        ld a, b
        exx
        push hl
        call lmul_8

   ;  76543210
   ;= DEdeHLhl
   ;0 aHLhl     =
   ;1  BbcBC    pop +
   ;2   bBCbc   pop +
   ;3    bBCbc  pop +

       ;0
        exx
        ld d, a
        ld e, h
        ld a, l
        exx
        ld d, a
        ld e, h
        ld a, l 
         ld hl, 0
        exx
        ld h, a
        ld l, 0
        ;exx 
        ;ld hl, 0
       ;1
        ;exx 
        pop bc
        add hl, bc
        exx 
        pop bc 
        ex de, hl
        adc hl, bc 
        ex de, hl 
        exx 
        pop bc 
        ld a, b 
        adc a, e
        ld e, a
        adc a, d
        sub e
        ld d, a
        exx 
       ;2
        pop bc 
        ld a, c
        add a, h
        ld h, a
        ld a, b
        exx 
        pop bc 
        adc a, l
        ld l, a
        ld a, c 
        adc a, h
        ld h, a
        ld a, b
        exx
        adc a, e
        ld e, a 
        pop bc 
        ld a, b
        adc a, d
        ld d, a
        exx
        ld a, 0
        adc a, e
        ld e, a
        adc a, d
        sub e
        ld d, a
        exx 
       ;3
        pop bc
        add hl, bc
        exx
        pop bc
        adc hl, bc
        exx
        pop bc
        ld a, b
        adc a, e 
        ld e, a
        adc a, d
        sub e
        ld d, a
        exx
        ld a, 0
        adc a, e
        ld e, a
        adc a, d
        sub e
        ld d, a
        exx 
        ret 

; hl'hl=0
; de'de=multiplicator
; a=2-nd multiplicator
lmul_8:
        ld hl, 0
        exx
        ld hl, 0
        exx 
        ld b, 8
        add a, a 
        jr lmul_8_2
lmul_8_0:
        add hl, hl
        exx
        adc hl, hl
        exx
        rla
lmul_8_2:
        jr nc, lmul_8_1
          add hl, de
          exx
          adc hl, de
          exx
          adc a, 0
lmul_8_1:
        djnz lmul_8_0
        ret 

#endif

