#ifdef MAKE_DOC

<section><title id="math.randn">randn</title>
<variablelist><title>室:</title>
<varlistentry><term>DE</term>
<listitem>ᨬ쭮 祭 砩 ᫠</listitem></varlistentry>
</variablelist>
<variablelist><title>室:</title>
<varlistentry><term>HL</term>
<listitem>ᥢ砩 ᫮</listitem></varlistentry>
</variablelist>

<para>㭪 頥 ᥢ砩 ᫮   .
쭮 祭 頥 砩 ᫠ &ndash; 0.
ᨬ쭮 ᥣ  ᫠   ॣ DE.
 頥  ॣ HL.   ⠪ ᠭ
㭪樨 <link endterm="math.rand"/>.</para>
</section>


<section><title id="math.rand">rand</title>
<variablelist><title>室:</title>
<varlistentry><term>HL</term>
<listitem>0&hellip;65535</listitem></varlistentry>
</variablelist>
<para>
  㭪 頥  ᥢ砩 ᫮ 
ॣ HL. 頥 ᫮ 室   0&hellip;65535.
㭪 믮 ᪮쪮 ३ 㭪樨 randn. 믮
㭪樨 <link endterm="math.rand"/>  ६ ਬ୮ ࠢ 3-
맮 檨 <link endterm="math.mul"/>,   ६  ६
믮 㭪樨 <link endterm="math.randn"/> ᮯ⠢ 
4- 맮 㭪樨 <link endterm="math.mul"/>.
</para>
</section>


<section><title id="math.srand">srand</title>
<variablelist><title>室:</title>
<varlistentry><term>DE</term>
<listitem>0..65535</listitem></varlistentry>
</variablelist>
<para>
 㭪 ⠭  砩 ᥫ.  ⠭
  祭 㥬 ᫥⥫쭮
ᥢ砩 ᥫ 㤥 ᥣ . 㬥 㭪樨
।  ॣ DE.
</para>
</section>


#else

 EXPORT global randn   ; random(0..<DE) -> HL
 EXPORT global rand    ; random(0..65535) -> HL
 EXPORT global srand   ; set random seed from DE.

	global mul

;  砩 ᥫ,  ~3000 takts.
; p  㭪樨 㬭

RAND_MAX equ 0xffff

	psect data
randx:   dw 0, 0

 	psect text
; hl = random(0..<de)  ᫠  
randn:
        push de 
        call rand
        ex de, hl 
        pop bc 
        call mul
        ex de, hl 
        ret 

; 祭 砩 ᫠
; -> hl = 砩 ᫮ 0..65535  ~2300 takts.
rand:
        ; randx = randx*1103515245 + 12345)>>16) & 077777)
        ld de, (randx+2)
        ld bc, 0x4e6d
        call mul
        push hl 
        ld de, (randx)
        ld bc, 0x41c6
        call mul
        pop de 
        add hl, de 
        push hl 
        ld de, (randx)
        ld bc, 0x4e6d
        call mul
        ld bc, 0x3039
        add hl, bc 
        ld (randx), hl 
        pop hl 
        adc hl, de 
        ld (randx+2), hl 
        ret 

; ⠭  砩 ᥫ
; de = 樨饥 祭
srand:
        ld (randx), de 
        ret 

#endif

