#ifdef MAKE_DOC

<section><title='string.strsep'>strsep</title>

<variablelist><title>室:</title>
<varlistentry><term>HL</term>
<listitem>㪠⥫  ப ⥪</listitem></varlistentry>
<varlistentry><term>DE</term>
<listitem>㪠⥫  ப-ᨢ ࠧ⥫</listitem></varlistentry>
</variablelist>

<para>  㭪 ⢫   ப,  ॣ஬ HL,
᫮, ࠧ ᨬ 묨 ॣ஬ DE.  
 ᨬ   ࠧ⥫ﬨ. ᫥ ⮣,  
᫮, ᨬ ࠧ⥫, ᫥騩  ,  
ᨬ   0.  ॣ HL 頥 㪠⥫  砫
 ᫮,   ॣ DE 㪠⥫  ᨬ, ᫥騩
 騬 ᫮ ,    ᫥⥫
맮 檨 strsep   ப  ᫮. 室
ப  ⮬ 㤥 ࠧ襭.  砥, ᫨  ப
⥪ ⮨ ⮫쪮  ࠧ⥫ 䫠 Z 㤥 襭.</para>

<para>  㭪 ⢫ ᬮ ப  אַ ࠢ, 
砫  .  㭪 strrsep, 
ᬠਢ ப  ⭮ ࠢ,    砫
ப.</para>

<para>  ਬ ᯮ짮 㭪樨,  뢮  ᫮
ࠧ ஡  ᨬ 㭪樨:</para>

<programlisting><![CDATA[
	ld hl, string	; 室 ப ⥪
loop:	
	ld de, delimiters  ; ப ࠧ⥫
	call strsep
	jr nz, endloop	;  ᫮ 

	push de		; த ப
	call printhl	; 뢮 ᫮   HL
	call prnewln	; ॢ ப
	pop hl
	jr loop
endloop:
	ret

delimiters:
	db 0x09, " ,.;:?!", 0
string:
	db "᫮1,᫮2 ᫮3.᫮4?᫮5", 0
]]>
</programlisting>

</section>

#else

 EXPORT global strsep  ; HL=*string, DE=*separators -> Z=1 & HL=*token & DE=*next

; hl=str, de=array
;    -> Z=1 hl=token, de=next
;    -> Z=0 end
	psect text
	global strcbrk
	global strpbrk

strsep:
        push de 
        call strcbrk
        pop de 
        jr z, strsep0  ; end
            xor a
            inc a
            ret 
strsep0:
        push hl
        call strpbrk
        ex de, hl 
        pop hl 
        jr z, strsep1  ; last
             xor a  ; !hl from strpbrk
             ret 
strsep1:
        xor a 
        ld (de), a
        inc de
        ret 

  EXPORT end

#endif

