#define FIN_PARAM O_RDONLY
#define FOUT_PARAM O_CREAT | O_WRONLY | O_TRUNC | O_BINARY

#define ADDRESS	32768
#define CLEAR	24575
#define RUN	32768
#define MAX_LEN	65535
#define VERSION	"bin2tap v.1.0"
#define LOADERLEN 93

#include <sys/types.h>
#include <sys/stat.h>

#include <fcntl.h>

#include <stdio.h>
#include <stdlib.h>

#include <string.h>

int str2int (char *str, int *num) {
	int i=0;

	*num = 0;
	while (str[i] != 0) {
		if (str[i] <= '9' && str[i] >= '0') {
			*num *= 10;
			*num += str[i++] - '0';
		}
		else 
			return 1;
	}
	return 0;
}

void usage (void) {
	printf("Usage: bin2tap [options] file.bin\n\nOptions:\n\
  -o output_file     output TAP file\n\
  -a address         start address of binary file [32768]\n\
  -b                 include BASIC loader\n\
  -c clear_address   CLEAR address in BASIC loader [24575]\n\
  -r run_address     address where to start bin. file for BASIC loader [32768]\n\
  -cb border_colour  border colour set by loader [0]\n\
  -cp paper_colour   paper colour set by loader [0]\n\
  -ci ink_colour     ink colour set by loader [7]\n\
  -d80               create D80 syntax loader\n\
  -h | --help        usage information\n\
  -v | --version     version info\n\n");
}

void version (void) {
	printf(VERSION"\nCopyright (C) 2004 mike/zeroteam\n");
}

int main (int argc, char *argv[])
{
	int	inputlen;	/* finput - input (binary) file descriptor, inputlen - input file lenght*/
	struct	stat	inputstat;	/* inputstat - input file status structure*/
	FILE *finput;
	FILE	*foutput;		/* foutput - output file descriptor */
	int	foutname_i = 0;		/* foutname_i - index to name in argv field */
	char	foutname[255];		/* foutname - output file name */
	char	filenam[255];		/* foutname - output file name */
	int	finname_i = 0;		/* finname_i - index to name in argv field */

	int	checksum;		/* checksum - TAP checksum */
	int	i, in_name, no;		/* general purpose variables */

	int	address = ADDRESS;	/* address - start address of binary file */
	int	basic = 0;		/* basic - indicator of BASIC loader */
	int	clear = CLEAR;		/* clear - CLEAR value for BASIC loader */
	int	run = RUN;		/* run - address where to start binary file */
	int	cb = 0, cp = 0, ci = 7;	/* cb, cp, ci - colors for border, paper and ink*/
	int	d80 = 0;		/* d80 - indicate D80 loader */
	char	run_name[] = "run       "; /* run_name - alternative name of basic loader */

	char	loader[] = "\0\012\026\0\352loader by bin2tap1.0\015\
\0\024\034\0\347\260\"0\":\332\260\"0\":\331\260\"7\":\375\260\"24575\"\015\
\0\050\020\0\357\040\"\"\40\40\40\40\40\40\40\40\40\40\257\015\
\0\062\013\0\371\300\260\"32768\"\015";	/* loader - fiel for BASIC loader */

	for (i = 1; i<argc; i++) {
		if (!strcmp(argv[i], "-h") | !strcmp(argv[i], "--help")) {
			usage();
			return 0;
		}
		if (!strcmp(argv[i], "-v") | !strcmp(argv[i], "--version")) {
			version();
			return 0;
		}
		if (!strcmp(argv[i], "-o")) {
			foutname_i = ++i;
			continue;
		}
		if (!strcmp(argv[i], "-a")) {
			if (str2int(argv[++i], &address)) {
				fprintf(stderr, "After -a must follow decadic address !\n");
				return 1;
			}
			if (address > 65535) {
				fprintf(stderr, "Maximum number after -a is 65535!\n");
				return 1;
			}
			continue;
		}
		if (!strcmp(argv[i], "-b")) {
			basic = 1;
			continue;
		}
		if (!strcmp(argv[i], "-c")) {
			if (str2int(argv[++i], &clear)) {
				fprintf(stderr, "After -c must follow decadic address !\n");
				return 1;
			}
			if (clear > 65535) {
				fprintf(stderr, "Maximum number after -c is 65535!\n");
				return 1;
			}
			continue;
		}
		if (!strcmp(argv[i], "-r")) {
			if (str2int(argv[++i], &run)) {
				fprintf(stderr, "After -r must follow decadic address !\n");
				return 1;
			}
			if (run > 65535) {
				fprintf(stderr, "Maximum number after -r is 65535!\n");
				return 1;
			}
			continue;
		}
		if (!strcmp(argv[i], "-cb")) {
			if (str2int(argv[++i], &cb)) {
				fprintf(stderr, "After -cb must follow decadic address !\n");
				return 1;
			}
			if (cb > 7) {
				fprintf(stderr, "Maximum number after -cb is 7!\n");
				return 1;
			}
			continue;
		}
		if (!strcmp(argv[i], "-cp")) {
			if (str2int(argv[++i], &cp)) {
				fprintf(stderr, "After -cp must follow decadic address !\n");
				return 1;
			}
			if (cp > 65535) {
				fprintf(stderr, "Maximum number after -cp is 7!\n");
				return 1;
			}
			continue;
		}
		if (!strcmp(argv[i], "-ci")) {
			if (str2int(argv[++i], &ci)) {
				fprintf(stderr, "After -ci must follow decadic address !\n");
				return 1;
			}
			if (ci > 65535) {
				fprintf(stderr, "Maximum number after -ci is 7!\n");
				return 1;
			}
			continue;
		}
		if (!strcmp(argv[i], "-d80")) {
			d80 = 1;
			loader[63] = '*';
			continue;
		}
		if (!finname_i)
			finname_i = i;
		else {
			fprintf(stderr, "Input only one bin. file!\n");
			return 1;
		}
	}

	if (!foutname_i) {
		strncpy(foutname, argv[finname_i], 255-5);
		foutname[254-5] = '\0';
		i = strlen(foutname);
		no = 0;
		i--;
		while ((no < 4) | (i-no > 0)) {
			if (foutname[i-no] == '.') {
				foutname[i-no] = '\0';
				break;
			}
			++no;
		}
		strcat (foutname, ".tap");
	}
	else {
		strncpy(foutname, argv[foutname_i], 254);
		foutname[254] = '\0';
	}
	
	printf("File in name: %s\tFile in index: %d\n", argv[finname_i], finname_i);
	printf("File out name: %s\tFile out index: %d\n", argv[foutname_i], foutname_i);
	printf("File out name: %s\n", foutname);
	printf("Address = %d\n", address);
	printf("Clear = %d\n", clear);
	printf("Run = %d\n", run);
	printf("Basic loader: ");
	if (basic)
		printf("yes\n");
	else
		printf("no\n");
	fprintf(stderr, "Out of order!\n");
	return 1;
	
	strcpy(filenam,argv[finname_i]);

	finput = fopen (filenam, FIN_PARAM);
	if (finput == -1) {
		fprintf (stderr, "Unable to open %s file!\n", argv[finname_i]);
		return 1;
	}

	if (fstat(finput, &inputstat) == -1) {
		fprintf (stderr, "Can't stat %s file!\n", argv[finname_i]);
		if (fclose (finput) == -1)
			fprintf (stderr, "Unable to close %s file!\n", argv[finname_i]);
		return 1;
	}

	foutput = fopen (foutname, FOUT_PARAM);
	if (foutput == -1) {
		fprintf (stderr, "Unable to open %s file for writing!\n", foutname);
		return 1;
	}

	inputlen = inputstat.st_size;
	if (inputlen > MAX_LEN) {
		fprintf (stderr, "Input file too long.\n");
		return 1;
	}

	if (basic) {

		loader[33] = '0' + cb;
		loader[39] = '0' + cp;
		loader[45] = '0' + ci;
		i = 51;
		loader[i++] = '0' + clear/10000;
		clear -= 10000 * (clear/10000);
		loader[i++] = '0' + clear/1000;
		clear -= 1000 * (clear/1000);
		loader[i++] = '0' + clear/100;
		clear -= 100 * (clear/100);
		loader[i++] = '0' + clear/10;
		clear -= 10 * (clear/10);
		loader[i] = '0' + clear;
		i = 86;
		loader[i++] = '0' + run/10000;
		run -= 10000 * (run/10000);
		loader[i++] = '0' + run/1000;
		run -= 1000 * (run/1000);
		loader[i++] = '0' + run/100;
		run -= 100 * (run/100);
		loader[i++] = '0' + run/10;
		run -= 10 * (run/10);
		loader[i] = '0' + run;
		
		in_name = 1;
		for (i = 0; i < 10; ++i) {
			if (in_name && (foutname[i] == '.' || foutname[i] == '\0')) {
				in_name = 0;
				loader[65+i] = '\"';
			}
			if (in_name)
				loader[65+i] = foutname[i];
		}
		if (in_name)
			loader[75] = '\"';

		checksum = 0;
		no = 19;			/* header len */
		write (foutput, &no, 1);
		no = 0;
		write (foutput, &no, 1);
		checksum ^= no = 0;		/* header block */
		write (foutput, &no, 1);
		checksum ^= no = 0;		/* PROGRAM type */
		write (foutput, &no, 1);
		in_name = 1;

		if (d80) {
			write (foutput, &run_name, 10);
			checksum ^= 73;		/* checksum of "run       " */
		}
		else {
			for (i = 0; i < 10; ++i) {			/* filename  */
				if (in_name && (foutname[i] == '.' || foutname[i] == '\0'))
					in_name = 0;
				if (in_name)
					checksum ^= no = foutname[i];
				else
					checksum ^= no = ' ';
				write (foutput, &no, 1);
			}
		}
		checksum ^= no = LOADERLEN%256;		/* lenght */
		write (foutput, &no, 1);
		checksum ^= no = LOADERLEN/256;
		write (foutput, &no, 1);
		checksum ^= no = 10;			/* start line */
		write (foutput, &no, 1);
		checksum ^= no = 0;
		write (foutput, &no, 1);
		checksum ^= no = LOADERLEN%256;		/* param2 = 32768 */
		write (foutput, &no, 1);
		checksum ^= no = LOADERLEN/256;
		write (foutput, &no, 1);
		no = checksum;
		write (foutput, &no, 1);

		checksum = 0;
		i = (LOADERLEN + 2)%256;
		write (foutput, &i, 1);
		i = (LOADERLEN + 2)/256;
		write (foutput, &i, 1);
		checksum ^= i = 255;
		write (foutput, &i, 1);
		for (no = 0; no < LOADERLEN; no++) {
			checksum ^= i = loader[no];
			write (foutput, &i, 1);
		}
		i = checksum;
		write (foutput, &i, 1);
		
	}

	checksum = 0;

	no = 19;			/* header len */
	write (foutput, &no, 1);
	no = 0;
	write (foutput, &no, 1);
	checksum ^= no = 0;			/* type header */
	write (foutput, &no, 1);
	checksum ^= no = 3;
	write (foutput, &no, 1);

	in_name = 1;
	for (i = 4; i < 14; ++i) {			/* filename  */
		if (in_name && (foutname[i-4] == '.' || foutname[i-4] == '\0'))
			in_name = 0;
		if (in_name)
			checksum ^= no = foutname[i-4];
		else
			checksum ^= no = ' ';
		write (foutput, &no, 1);
	}
	checksum ^= no = inputlen%256;		/* lenght */
	write (foutput, &no, 1);
	checksum ^= no = inputlen/256;
	write (foutput, &no, 1);
	checksum ^= no = address%256;	/* start address */
	write (foutput, &no, 1);
	checksum ^= no = address/256;
	write (foutput, &no, 1);
	checksum ^= no = 0;			/* param2 = 32768 */
	write (foutput, &no, 1);
	checksum ^= no = 128;
	write (foutput, &no, 1);
	no = checksum;
	write (foutput, &no, 1);

	checksum = 0;
	i = (inputlen + 2)%256;
	write (foutput, &i, 1);
	i = (inputlen + 2)/256;
	write (foutput, &i, 1);
	checksum ^= i = 255;
	write (foutput, &i, 1);
	while (read (finput, &i, 1)) {
		checksum ^= i;
		write (foutput, &i, 1);
	}
	i = checksum;
	write (foutput, &i, 1);
	

	if (close (foutput) == -1) {
		fprintf(stderr, "Unable to close %s file!\n", foutname);
		return 1;
	}

	if (close (finput) == -1) {
		fprintf (stderr, "Unable to close %s file!\n", argv[finname_i]);
		return 1;
	}

	return 0;
}

