* Sega Genesis Boot loader
* Made by Joseph Norman
* http://devster.netfirms.com
	org	$000
	dc.l	$00FFFE00,$00000200,$00020008,$0002000C,$00020010,$00020014,$00020018,$0002001C
	dc.l	$00020020,$00020024,$00020028,$0002002C,$00020030,$00020034,$00020038,$0002003C
	dc.l	$00020040,$00020044,$00020048,$0002004C,$00020050,$00020054,$00020058,$0002005C
	dc.l	$00020060,$00020064,$00020068,$0002006C,$00020070,$00020074,$00020078,$0002007C
	dc.l	$00020080,$00020084,$00020088,$0002008C,$00020090,$00020094,$00020098,$0002009C
	dc.l	$000200A0,$000200A4,$000200A8,$000200AC,$000200B0,$000200B4,$000200B8,$000200BC
	dc.l	$000200C0,$000200C4,$000200C8,$000200CC,$000200D0,$000200D4,$000200D8,$000200DC
	dc.l	$000200E0,$000200E4,$000200E8,$000200EC,$000200F0,$000200F4,$000200F8,$000200FC
	dc.b	'SEGA GENESIS    '
	dc.b	'(C)SEGA 2000.DEC'
	dc.b	'                '
	dc.b	'                '
	dc.b	'                '
	dc.b	'                '
	dc.b	'                '
	dc.b	'                '
	dc.b	'GM MK-0000 -00'
	dc.w	$0000
	dc.b	'J               '
	dc.l	$00000000,$003FFFFF
	dc.l	$00E00000,$00FFFFFF
	dc.b	'                '
	dc.b	'                '
	dc.b	'                '
	dc.b	'                '
	dc.b	'JUE             '

	org	$200
__start:
* Disable interrupts
	move.w	#$2700,sr
* Do security check
	move.b	$A10001,d0
	andi.b	#$0F,d0
	beq.s	__bootbios_not_v1
	move.l	#'SEGA',$A14000
__bootbios_not_v1:
* Stop Z80 reset and get bus
	move.w	#$0100,$A11200
	move.w	#$0100,$A11100
__bootbios_get_bus:
	btst	#8,$A11100
	bne.s	__bootbios_get_bus

SERIAL_BASE	equ	$A1001B

start_bios:
	move.l	#$1000000,a7
	move.w	#$8006,($C00004)
	move.w	#$8154,($C00004)
	move.w	#$8B08,($C00004)
	move.w	#$8C81,($C00004)
	move.w	#$8230,($C00004)	; Scroll A Name Table
	move.w	#$8307,($C00004)	; Scroll B Name Table
	move.w	#$8407,($C00004)
	move.w	#$9011,($C00004)
	move.w	#$9100,($C00004)
	move.w	#$9200,($C00004)
	move.w	#$855E,($C00004)	; Sprites Name Table
	move.w	#$8D36,($C00004)

	move.w	#$8F01,($C00004)
	move.l	#$C0000000,($C00004)
	move.l	#$00E0,($C00000)
	move.l	#$0000,($C00000)
	move.l	#$048A,($C00000)
	move.l	#$0448,($C00000)
	move.l	#$0EA0,($C00000)
	move.l	#$0606,($C00000)
	move.l	#$0444,($C00000)
	move.l	#$0666,($C00000)
	move.l	#$0666,($C00000)
	move.l	#$0888,($C00000)
	move.l	#$0AAA,($C00000)
	move.l	#$0444,($C00000)
	move.l	#$00EE,($C00000)
	move.l	#$00AC,($C00000)
	move.l	#$0A0A,($C00000)
	move.l	#$0EEE,($C00000)

	move.w	#$8F02,($C00004)
	move.l	#$40000000,($C00004)
	lea	font(pc),a0
	move.w	#2880,d0
loadfont:
	move.w	(a0)+,$C00000
	dbra	d0,loadfont

	move.b	#$30,(SERIAL_BASE+4)

	clr.l	d1
	clr.l	d2
	lea	text1(PC),a0
	bsr	printz
	move.b	#1,d1
	lea	text2(PC),a0
	bsr	printz
	move.b	#2,d1
	lea	text3(PC),a0
	bsr	printz
	move.b	#3,d1
	lea	text4(PC),a0
	bsr	printz

loop:
	move.b	#$40,($A10009)
	move.b	#$40,($A10003)
	nop
	nop
	move.b	($A10003),d1
	andi.b	#$3f,d1
	move.b	#$00,($A10003)
	nop
	nop
	move.b	($A10003),d0
	andi.b	#$30,d0
	lsl.b	#2,d0
	or.b	d1,d0
	not.b	d0
	btst.b	#4,d0
	bne	buttonb
	btst.b	#6,d0
	beq	loop
	move.b	#5,d1
	lea	text5(PC),a0
	bsr	printz
serial_xmodem2:
	move.l	#$FF0000,a0
	bsr	wait4serial
	move.b	#$15,(SERIAL_BASE+0)
	move.l	#$FFFFF,d0
serial_xmodem2_init_wait:
	btst.b	#1,(SERIAL_BASE+4)
	bne	serial_xmodem2_init_ack
	dbra	d0,serial_xmodem2_init_wait
	bra	serial_xmodem2
serial_xmodem2_init_ack:
	move.b	(SERIAL_BASE+2),d0
	cmp.b	#$18,d0
	beq	serial_xmodem2_finish
	cmp.b	#$04,d0
	beq	serial_xmodem2_finish
	bsr	wait4serialin
	tst.b	(SERIAL_BASE+2)
	bsr	wait4serialin
	tst.b	(SERIAL_BASE+2)
	move.w	#127,d0
serial_xmodem2_recieve_data:
	bsr	wait4serialin
	move.b	(SERIAL_BASE+2),(a0)+
	dbra	d0,serial_xmodem2_recieve_data
	bsr	wait4serialin
	tst.b	($A1001D)
	bsr	wait4serial
	move.b	#$06,(SERIAL_BASE+0)
	bsr	wait4serialin
	bra	serial_xmodem2_init_ack
serial_xmodem2_finish:
	bsr     wait4serial
	move.b	#$06,(SERIAL_BASE+0)
buttonb:
	move.b	#6,d1
	lea	text6(PC),a0
	bsr	printz
	jmp	($FF0000)


text1:	dc.w	'SEGA GENESIS',0
text2:	dc.w	'DEVSTER RS232 BOOTLOADER',0
text3:	dc.w	'PRESS A TO LOAD A FILE VIA XMODEM',0
text4:	dc.w	'PRESS B TO JUMP TO LOCATION $FF0000',0
text5:	dc.w	'WAITING FOR FILE.....',0
text6:	dc.w	'RUNNING.....',0

printz:
	clr.l	d0
	move.b	d1,d0
	add.l	#1,d0
	lsl.w	#6,d0
	add.b	d2,d0
	add.l	#1,d0
	lsl.l	#3,d0
	lsr.w	#2,d0
	swap	d0
	add.l	#$60000003,d0
	move.w	#$8F02,($C00004)
	move.l	d0,($C00004)
	clr.w	d0
printzloop:
	move.b	(a0)+,d0
	sub.b	#32,d0
	move.w	d0,($C00000)
	tst.b	(a0)
	bne	printzloop
	rts

wait4serialin:
	btst.b	#1,(SERIAL_BASE+4)
	beq	wait4serialin
	rts

wait4serial:
	btst.b	#0,(SERIAL_BASE+4)
	bne	wait4serial
	rts

font:
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$11,$00,$00,$00,$11,$00,$00
        dc.b    $00,$11,$00,$00,$00,$11,$00,$00
        dc.b    $00,$11,$00,$00,$00,$00,$00,$00
        dc.b    $00,$11,$00,$00,$00,$11,$00,$00
        dc.b    $01,$10,$11,$00,$11,$01,$10,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$01,$00,$10,$00
        dc.b    $01,$00,$10,$00,$11,$11,$11,$00
        dc.b    $01,$00,$10,$00,$11,$11,$11,$00
        dc.b    $01,$00,$10,$00,$01,$00,$10,$00
        dc.b    $00,$10,$10,$00,$01,$11,$11,$00
        dc.b    $10,$10,$10,$00,$01,$11,$11,$00
        dc.b    $00,$10,$10,$10,$10,$10,$10,$10
        dc.b    $01,$11,$11,$00,$00,$10,$10,$00
        dc.b    $00,$00,$00,$10,$01,$10,$01,$10
        dc.b    $01,$10,$11,$10,$00,$01,$11,$00
        dc.b    $00,$11,$10,$00,$01,$11,$01,$10
        dc.b    $01,$10,$01,$10,$01,$00,$00,$00
        dc.b    $01,$11,$11,$00,$11,$00,$01,$10
        dc.b    $11,$00,$01,$10,$01,$11,$11,$00
        dc.b    $11,$10,$01,$10,$11,$10,$01,$10
        dc.b    $11,$10,$10,$10,$01,$11,$01,$00
        dc.b    $00,$01,$10,$00,$00,$11,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$11,$10,$00,$01,$10,$00,$00
        dc.b    $01,$10,$00,$00,$01,$10,$00,$00
        dc.b    $01,$10,$00,$00,$01,$10,$00,$00
        dc.b    $01,$10,$00,$00,$00,$11,$10,$00
        dc.b    $00,$11,$10,$00,$00,$00,$11,$00
        dc.b    $00,$00,$11,$00,$00,$00,$11,$00
        dc.b    $00,$00,$11,$00,$00,$00,$11,$00
        dc.b    $00,$00,$11,$00,$00,$11,$10,$00
        dc.b    $00,$01,$00,$00,$00,$01,$00,$00
        dc.b    $00,$11,$10,$00,$11,$11,$11,$10
        dc.b    $01,$11,$11,$00,$00,$11,$10,$00
        dc.b    $01,$10,$11,$00,$01,$00,$01,$00
        dc.b    $00,$00,$00,$00,$00,$01,$10,$00
        dc.b    $00,$01,$10,$00,$01,$11,$11,$10
        dc.b    $01,$11,$11,$10,$00,$01,$10,$00
        dc.b    $00,$01,$10,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$01,$10,$00,$00,$11,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$01,$11,$11,$00
        dc.b    $01,$11,$11,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$01,$10,$00,$00,$01,$10,$00
        dc.b    $00,$00,$00,$10,$00,$00,$01,$10
        dc.b    $00,$00,$11,$10,$00,$01,$11,$00
        dc.b    $00,$11,$10,$00,$01,$11,$00,$00
        dc.b    $01,$10,$00,$00,$01,$00,$00,$00
        dc.b    $01,$11,$11,$00,$11,$00,$01,$10
        dc.b    $11,$00,$11,$10,$11,$01,$11,$10
        dc.b    $11,$11,$11,$10,$11,$11,$01,$10
        dc.b    $11,$10,$01,$10,$01,$11,$11,$00
        dc.b    $00,$01,$10,$00,$00,$01,$10,$00
        dc.b    $00,$11,$10,$00,$00,$01,$10,$00
        dc.b    $00,$01,$10,$00,$00,$01,$10,$00
        dc.b    $00,$01,$10,$00,$11,$11,$11,$10
        dc.b    $11,$11,$11,$00,$00,$00,$01,$10
        dc.b    $00,$00,$01,$10,$01,$11,$11,$00
        dc.b    $11,$11,$00,$00,$11,$10,$00,$00
        dc.b    $11,$10,$00,$00,$11,$11,$11,$10
        dc.b    $11,$11,$11,$00,$00,$00,$01,$10
        dc.b    $00,$00,$01,$10,$00,$11,$11,$00
        dc.b    $00,$00,$01,$10,$00,$00,$01,$10
        dc.b    $00,$00,$01,$10,$11,$11,$11,$00
        dc.b    $11,$00,$01,$10,$11,$00,$01,$10
        dc.b    $11,$00,$01,$10,$11,$11,$11,$10
        dc.b    $00,$00,$01,$10,$00,$00,$01,$10
        dc.b    $00,$00,$01,$10,$00,$00,$01,$10
        dc.b    $11,$11,$11,$10,$11,$00,$00,$00
        dc.b    $11,$00,$00,$00,$11,$11,$11,$00
        dc.b    $00,$01,$11,$10,$00,$00,$11,$10
        dc.b    $00,$01,$11,$10,$11,$11,$11,$00
        dc.b    $01,$11,$11,$00,$11,$00,$01,$10
        dc.b    $11,$00,$00,$00,$11,$11,$11,$00
        dc.b    $11,$10,$01,$10,$11,$10,$01,$10
        dc.b    $11,$10,$01,$10,$01,$11,$11,$00
        dc.b    $11,$11,$11,$00,$00,$00,$11,$10
        dc.b    $00,$00,$01,$10,$00,$00,$01,$10
        dc.b    $00,$00,$01,$10,$00,$00,$01,$10
        dc.b    $00,$00,$01,$10,$00,$00,$01,$10
        dc.b    $01,$11,$11,$00,$11,$00,$01,$10
        dc.b    $11,$00,$01,$10,$01,$11,$11,$00
        dc.b    $11,$10,$01,$10,$11,$10,$01,$10
        dc.b    $11,$10,$01,$10,$01,$11,$11,$00
        dc.b    $01,$11,$11,$00,$11,$00,$01,$10
        dc.b    $11,$00,$01,$10,$01,$11,$11,$10
        dc.b    $00,$00,$01,$10,$00,$00,$01,$10
        dc.b    $00,$00,$01,$10,$11,$11,$11,$00
        dc.b    $00,$00,$00,$00,$00,$11,$00,$00
        dc.b    $00,$11,$00,$00,$00,$00,$00,$00
        dc.b    $00,$11,$00,$00,$00,$11,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$01,$10,$00
        dc.b    $00,$01,$10,$00,$00,$00,$00,$00
        dc.b    $00,$01,$10,$00,$00,$11,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $01,$11,$11,$00,$11,$00,$01,$10
        dc.b    $00,$00,$01,$10,$00,$01,$11,$00
        dc.b    $00,$11,$00,$00,$00,$00,$00,$00
        dc.b    $00,$11,$00,$00,$00,$11,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $00,$00,$00,$00,$00,$00,$00,$00
        dc.b    $01,$11,$11,$00,$11,$00,$01,$10
        dc.b    $11,$00,$01,$10,$11,$11,$11,$10
        dc.b    $11,$10,$01,$10,$11,$10,$01,$10
        dc.b    $11,$10,$01,$10,$11,$10,$01,$10
        dc.b    $11,$11,$11,$00,$11,$00,$01,$10
        dc.b    $11,$00,$01,$10,$11,$11,$11,$00
        dc.b    $11,$10,$01,$10,$11,$10,$01,$10
        dc.b    $11,$10,$01,$10,$11,$11,$11,$00
        dc.b    $01,$11,$11,$00,$11,$00,$01,$10
        dc.b    $11,$00,$00,$00,$11,$00,$00,$00
        dc.b    $11,$10,$00,$00,$11,$10,$01,$10
        dc.b    $11,$10,$01,$10,$01,$11,$11,$00
        dc.b    $11,$11,$11,$00,$11,$00,$11,$10
        dc.b    $11,$00,$01,$10,$11,$00,$01,$10
        dc.b    $11,$10,$01,$10,$11,$10,$01,$10
        dc.b    $11,$10,$11,$10,$11,$11,$11,$00
        dc.b    $11,$11,$11,$10,$11,$00,$00,$00
        dc.b    $11,$00,$00,$00,$11,$11,$11,$00
        dc.b    $11,$10,$00,$00,$11,$10,$00,$00
        dc.b    $11,$10,$00,$00,$11,$11,$11,$10
        dc.b    $11,$11,$11,$10,$11,$00,$00,$00
        dc.b    $11,$00,$00,$00,$11,$11,$11,$00
        dc.b    $11,$10,$00,$00,$11,$10,$00,$00
        dc.b    $11,$10,$00,$00,$11,$10,$00,$00
        dc.b    $01,$11,$11,$00,$11,$00,$01,$10
        dc.b    $11,$00,$00,$00,$11,$00,$11,$10
        dc.b    $11,$10,$01,$10,$11,$10,$01,$10
        dc.b    $11,$10,$01,$10,$01,$11,$11,$00
        dc.b    $11,$00,$01,$10,$11,$00,$01,$10
        dc.b    $11,$00,$01,$10,$11,$11,$11,$10
        dc.b    $11,$10,$01,$10,$11,$10,$01,$10
        dc.b    $11,$10,$01,$10,$11,$10,$01,$10
        dc.b    $11,$11,$11,$10,$00,$11,$00,$00
        dc.b    $00,$11,$00,$00,$00,$11,$00,$00
        dc.b    $00,$11,$10,$00,$00,$11,$10,$00
        dc.b    $00,$11,$10,$00,$11,$11,$11,$10
        dc.b    $00,$00,$01,$10,$00,$00,$01,$10
        dc.b    $00,$00,$01,$10,$00,$00,$01,$10
        dc.b    $00,$00,$11,$10,$11,$00,$11,$10
        dc.b    $11,$00,$11,$10,$01,$11,$11,$00
        dc.b    $11,$00,$01,$10,$11,$00,$11,$00
        dc.b    $11,$01,$10,$00,$11,$11,$00,$00
        dc.b    $11,$11,$10,$00,$11,$10,$11,$00
        dc.b    $11,$10,$11,$00,$11,$00,$01,$10
        dc.b    $11,$00,$00,$00,$11,$00,$00,$00
        dc.b    $11,$00,$00,$00,$11,$00,$00,$00
        dc.b    $11,$10,$00,$00,$11,$10,$00,$00
        dc.b    $11,$10,$00,$00,$11,$11,$11,$10
        dc.b    $11,$10,$11,$10,$11,$11,$11,$10
        dc.b    $11,$01,$01,$10,$11,$00,$01,$10
        dc.b    $11,$10,$01,$10,$11,$10,$01,$10
        dc.b    $11,$10,$01,$10,$11,$10,$01,$10
        dc.b    $11,$11,$11,$00,$11,$00,$11,$10
        dc.b    $11,$00,$01,$10,$11,$00,$01,$10
        dc.b    $11,$10,$01,$10,$11,$10,$01,$10
        dc.b    $11,$10,$01,$10,$11,$10,$01,$10
        dc.b    $01,$11,$11,$00,$11,$00,$01,$10
        dc.b    $11,$00,$01,$10,$11,$00,$01,$10
        dc.b    $11,$10,$01,$10,$11,$10,$01,$10
        dc.b    $11,$10,$01,$10,$01,$11,$11,$00
        dc.b    $11,$11,$11,$00,$11,$00,$01,$10
        dc.b    $11,$00,$01,$10,$11,$11,$11,$00
        dc.b    $11,$10,$00,$00,$11,$10,$00,$00
        dc.b    $11,$10,$00,$00,$11,$10,$00,$00
        dc.b    $01,$11,$11,$00,$11,$00,$01,$10
        dc.b    $11,$00,$01,$10,$11,$00,$01,$10
        dc.b    $11,$10,$01,$10,$11,$10,$01,$10
        dc.b    $11,$10,$11,$00,$01,$11,$11,$10
        dc.b    $11,$11,$11,$00,$11,$00,$01,$10
        dc.b    $11,$00,$01,$10,$11,$11,$11,$00
        dc.b    $11,$10,$11,$10,$11,$10,$01,$10
        dc.b    $11,$10,$01,$10,$11,$10,$01,$10
        dc.b    $01,$11,$11,$00,$11,$00,$00,$10
        dc.b    $11,$00,$00,$00,$01,$11,$11,$00
        dc.b    $00,$00,$11,$10,$00,$00,$01,$10
        dc.b    $10,$00,$11,$10,$01,$11,$11,$00
        dc.b    $11,$11,$11,$10,$00,$11,$00,$00
        dc.b    $00,$11,$00,$00,$00,$11,$00,$00
        dc.b    $00,$11,$10,$00,$00,$11,$10,$00
        dc.b    $00,$11,$10,$00,$00,$11,$10,$00
        dc.b    $11,$00,$01,$10,$11,$00,$01,$10
        dc.b    $11,$00,$01,$10,$11,$00,$01,$10
        dc.b    $11,$10,$01,$10,$11,$10,$01,$10
        dc.b    $11,$10,$01,$10,$01,$11,$11,$00
        dc.b    $11,$00,$01,$10,$11,$00,$01,$10
        dc.b    $11,$00,$01,$10,$11,$10,$11,$10
        dc.b    $01,$10,$11,$00,$01,$11,$11,$00
        dc.b    $00,$11,$10,$00,$00,$01,$00,$00
        dc.b    $11,$00,$01,$10,$11,$00,$01,$10
        dc.b    $11,$00,$01,$10,$11,$01,$01,$10
        dc.b    $11,$01,$01,$10,$11,$01,$01,$10
        dc.b    $11,$11,$11,$10,$01,$10,$11,$00
        dc.b    $11,$00,$01,$10,$11,$10,$11,$10
        dc.b    $01,$11,$11,$00,$00,$11,$10,$00
        dc.b    $00,$11,$10,$00,$01,$11,$11,$00
        dc.b    $11,$10,$11,$10,$11,$00,$01,$10
        dc.b    $11,$00,$01,$10,$11,$00,$01,$10
        dc.b    $11,$10,$11,$10,$01,$11,$11,$00
        dc.b    $00,$11,$10,$00,$00,$11,$10,$00
        dc.b    $00,$11,$10,$00,$00,$11,$10,$00
        dc.b    $11,$11,$11,$00,$00,$00,$01,$00
        dc.b    $00,$00,$11,$00,$01,$11,$11,$00
        dc.b    $11,$11,$00,$00,$11,$10,$00,$00
        dc.b    $11,$10,$00,$00,$11,$11,$11,$00

	END
