enum FixType {
    ftFastDisable,	/* -> 0x2c; bit $nnnn */

    ftOverlap,		/* overlap?(overlap-1):0 */
    ftOverlapLo,	/* (0x801 + (sizeof(headerUncrunch)-2+rleUsed-31)
			    + size - overlap) & 0xff; */
    ftOverlapHi,	/* (0x801 + (sizeof(headerUncrunch)-2+rleUsed-31)
			    + size - overlap) >> 8; */
    ftWrapCount,	/* (memend>>8) - ((endAddr + overlap - size) >> 8); */
    ftSizePages,	/* (size>>8) + 1 */
    ftSizeLo,		/* (0x801 + (sizeof(headerUncrunchNoWrap)-2+rleUsed-31)
			    + size - 0x100) & 0xff; */
    ftSizeHi,		/* (0x801+ (sizeof(headerUncrunchNoWrap)-2+rleUsed-31)
			    + size - 0x100) >> 8; */
    ftEndLo,		/* (endAddr - 0x100) & 0xff; */
    ftEndHi,		/* ((endAddr - 0x100) >> 8); */
    ftEscValue,		/* (escape>>(8-escBits)); */
    ftOutposLo,		/* (start & 0xff); */
    ftOutposHi,		/* (start >> 8); */
    ftEscBits,		/* escBits; */
    ftEsc8Bits,		/* 8-escBits; */
    ft1MaxGamma,	/* (1<<maxGamma); */
    ft8MaxGamma,	/* (8-maxGamma); */
    ft2MaxGamma,	/* (2<<maxGamma)-1; */
    ftExtraBits,	/* extraLZPosBits; */
    ftMemConfig,	/*header[0x8e1 -0x7ff] = memConfig; */
    ftCli,		/*header[0x8ef -0x7ff] = $58/$78 cli/sei; */
    ftExecLo,		/* (exec & 0xff); */
    ftExecHi,		/* (exec >> 8); */
    ftInposLo,		/* (endAddr - size) & 0xff; */
    ftInposHi,		/* ((endAddr - size) >> 8); */
    ftMaxGamma,		/* maxGamma + 1; */

    ftBEndLo,	/* basic end address */
    ftBEndHi,

    ftIBufferSize,	/* # of bytes in system input buffer $200- */
    ftStackSize,	/* # of bytes in zero page and stack $0f7- */
    ftDeCall,

    ftOp,		/* op for ADC-lz */

    ftReloc,
    ftEnd
};

struct FixEntry {
    enum FixType type;
    int offset;
};

#define FIXF_C64	1
#define FIXF_VIC20	2
#define FIXF_C16	4
#define FIXF_C128	8
#define FIXF_MACHMASK	0xff	/* Must be exactly correct */

#define FIXF_WRAP	256	/* If requested, must be present */
#define FIXF_DLZ	512

#define FIXF_FAST	1024
#define FIXF_SHORT	2048


struct FixStruct {
    unsigned char *code;
    int codeSize;
    struct FixEntry *fixes;
    const char *name;
    int flags;
};


static unsigned char headerC64SW[] = {
    0x01,0x08,0x0b,0x08,0xef,0x00,0x9e,0x32,
    0x30,0x36,0x31,0x00,0x00,0x00,0x78,0xa9,
    0x38,0x85,0x01,0xa9,0xaa,0x85,0x2d,0xa9,
    0xaa,0x85,0x2e,0xa2,0x00,0xbd,0xaa,0xaa,
    0x95,0x4b,0xca,0x10,0xf8,0xa2,0xf7,0xbd,
    0x46,0x08,0x9d,0xf6,0x00,0xca,0xd0,0xf7,
    0xa0,0xaa,0xca,0xbd,0xaa,0xaa,0x9d,0x00,
    0xff,0x8a,0xd0,0xf6,0xce,0x37,0x08,0xce,
    0x34,0x08,0x88,0xd0,0xed,0x4c,0x16,0x01,
    0x80,0x00,0x8d,0xaa,0xaa,0xe6,0xfa,0xd0,
    0x02,0xe6,0xfb,0xca,0x60,0xa4,0xf8,0xa2,
    0x02,0x20,0xca,0x01,0x85,0xf8,0x98,0xa2,
    0x06,0x20,0xca,0x01,0x20,0xf9,0x00,0xa0,
    0x00,0x98,0xa2,0x02,0x20,0xca,0x01,0xc5,
    0xf8,0xd0,0xec,0x20,0xb7,0x01,0x85,0x2f,
    0x4a,0xd0,0x3d,0x20,0x9b,0x01,0x90,0x46,
    0x20,0x9b,0x01,0x90,0xd0,0xc8,0x20,0xb7,
    0x01,0x85,0x2f,0xc9,0x40,0x90,0x0b,0xa2,
    0x02,0x20,0xc5,0x01,0x85,0x2f,0x20,0xb7,
    0x01,0xa8,0x20,0xb7,0x01,0xaa,0xbd,0xcd,
    0x01,0xe0,0x20,0x90,0x06,0x8a,0xa2,0x03,
    0x20,0xc5,0x01,0xa6,0x2f,0xe8,0x20,0xf9,
    0x00,0xd0,0xfb,0x88,0xd0,0xf8,0xf0,0xaf,
    0x20,0xb7,0x01,0xc9,0x7f,0xf0,0x25,0xe9,
    0x00,0xa2,0x00,0x20,0xca,0x01,0x85,0x30,
    0xa2,0x08,0x20,0xc5,0x01,0x65,0xfa,0xa6,
    0x2f,0x85,0x2f,0xa5,0xfb,0xe5,0x30,0x85,
    0x30,0xe8,0xb1,0x2f,0xc8,0x20,0xf9,0x00,
    0xd0,0xf8,0xf0,0xd2,0xa9,0x37,0x85,0x01,
    0x58,0x4c,0xaa,0xaa,0x06,0xf7,0xd0,0x17,
    0x48,0xad,0xaa,0xaa,0x2a,0x85,0xf7,0xee,
    0xa1,0x01,0xd0,0x0a,0xee,0xa2,0x01,0xd0,
    0x05,0xa9,0x4b,0x8d,0xa1,0x01,0x68,0x60,
    0xe8,0x8a,0x20,0x9b,0x01,0x90,0x0b,0xe8,
    0xe0,0x07,0xd0,0xf6,0xf0,0x04,0x20,0x9b,
    0x01,0x2a,0xca,0xd0,0xf9,0x18,0x60,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00
};

struct FixEntry fixTableC64SW[] = {
    {ftBEndHi, 0x0817 -0x07ff},
    {ftOverlap, 0x081b -0x07ff},
    {ftOverlapLo, 0x081d -0x07ff},
    {ftOverlapHi, 0x081e -0x07ff},
    {ftStackSize, 0x0825 -0x07ff},
    {ftReloc, 0x0828 -0x07ff},
    {ftSizePages, 0x0830 -0x07ff},
    {ftSizeLo, 0x0833 -0x07ff},
    {ftSizeHi, 0x0834 -0x07ff},
    {ftEndLo, 0x0836 -0x07ff},
    {ftEndHi, 0x0837 -0x07ff},
    {ftReloc, 0x083d -0x07ff},
    {ftReloc, 0x0840 -0x07ff},
    {ftDeCall, 0x0844 -0x07ff},
    {ftEscValue, 0x0848 -0x07ff},
    {ftOutposLo, 0x084a -0x07ff},
    {ftOutposHi, 0x084b -0x07ff},
    {ftEscBits, 0x0857 -0x07ff},
    {ftEsc8Bits, 0x085f -0x07ff},
    {ftEscBits, 0x086a -0x07ff},
    {ft1MaxGamma, 0x088b -0x07ff},
    {ft8MaxGamma, 0x088f -0x07ff},
    {ft2MaxGamma, 0x08bb -0x07ff},
    {ftExtraBits, 0x08c1 -0x07ff},
    {ftMemConfig, 0x08e4 -0x07ff},
    {ftCli, 0x08e7 -0x07ff},
    {ftExecLo, 0x08e9 -0x07ff},
    {ftExecHi, 0x08ea -0x07ff},
    {ftInposLo, 0x08f1 -0x07ff},
    {ftInposHi, 0x08f2 -0x07ff},
    {ftMaxGamma, 0x0910 -0x07ff},
    {ftEnd,0}
};

static unsigned char headerC64S[] = {
    0x01,0x08,0x0b,0x08,0xef,0x00,0x9e,0x32,
    0x30,0x36,0x31,0x00,0x00,0x00,0x78,0xa9,
    0x38,0x85,0x01,0xa9,0xaa,0x85,0x2d,0xa9,
    0xaa,0x85,0x2e,0xa2,0xf0,0xbd,0x3c,0x08,
    0x9d,0xf6,0x00,0xca,0xd0,0xf7,0xa0,0xaa,
    0xca,0xbd,0xaa,0xaa,0x9d,0x00,0xff,0x8a,
    0xd0,0xf6,0xce,0x2d,0x08,0xce,0x2a,0x08,
    0x88,0xd0,0xed,0x4c,0x16,0x01,0x80,0x00,
    0x8d,0xaa,0xaa,0xe6,0xfa,0xd0,0x02,0xe6,
    0xfb,0xca,0x60,0xa4,0xf8,0xa2,0x02,0x20,
    0xc3,0x01,0x85,0xf8,0x98,0xa2,0x06,0x20,
    0xc3,0x01,0x20,0xf9,0x00,0xa0,0x00,0x98,
    0xa2,0x02,0x20,0xc3,0x01,0xc5,0xf8,0xd0,
    0xec,0x20,0xb0,0x01,0x85,0x2f,0x4a,0xd0,
    0x3d,0x20,0x9b,0x01,0x90,0x46,0x20,0x9b,
    0x01,0x90,0xd0,0xc8,0x20,0xb0,0x01,0x85,
    0x2f,0xc9,0x40,0x90,0x0b,0xa2,0x02,0x20,
    0xbe,0x01,0x85,0x2f,0x20,0xb0,0x01,0xa8,
    0x20,0xb0,0x01,0xaa,0xbd,0xc6,0x01,0xe0,
    0x20,0x90,0x06,0x8a,0xa2,0x03,0x20,0xbe,
    0x01,0xa6,0x2f,0xe8,0x20,0xf9,0x00,0xd0,
    0xfb,0x88,0xd0,0xf8,0xf0,0xaf,0x20,0xb0,
    0x01,0xc9,0x7f,0xf0,0x25,0xe9,0x00,0xa2,
    0x00,0x20,0xc3,0x01,0x85,0x30,0xa2,0x08,
    0x20,0xbe,0x01,0x65,0xfa,0xa6,0x2f,0x85,
    0x2f,0xa5,0xfb,0xe5,0x30,0x85,0x30,0xe8,
    0xb1,0x2f,0xc8,0x20,0xf9,0x00,0xd0,0xf8,
    0xf0,0xd2,0xa9,0x37,0x85,0x01,0x58,0x4c,
    0xaa,0xaa,0x06,0xf7,0xd0,0x10,0x48,0xad,
    0xaa,0xaa,0x2a,0x85,0xf7,0xee,0xa1,0x01,
    0xd0,0x03,0xee,0xa2,0x01,0x68,0x60,0xe8,
    0x8a,0x20,0x9b,0x01,0x90,0x0b,0xe8,0xe0,
    0x07,0xd0,0xf6,0xf0,0x04,0x20,0x9b,0x01,
    0x2a,0xca,0xd0,0xf9,0x18,0x60,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00
};

struct FixEntry fixTableC64S[] = {
    {ftBEndHi, 0x0817 -0x07ff},
    {ftStackSize, 0x081b -0x07ff},
    {ftReloc, 0x081e -0x07ff},
    {ftSizePages, 0x0826 -0x07ff},
    {ftSizeLo, 0x0829 -0x07ff},
    {ftSizeHi, 0x082a -0x07ff},
    {ftEndLo, 0x082c -0x07ff},
    {ftEndHi, 0x082d -0x07ff},
    {ftReloc, 0x0833 -0x07ff},
    {ftReloc, 0x0836 -0x07ff},
    {ftDeCall, 0x083a -0x07ff},
    {ftEscValue, 0x083e -0x07ff},
    {ftOutposLo, 0x0840 -0x07ff},
    {ftOutposHi, 0x0841 -0x07ff},
    {ftEscBits, 0x084d -0x07ff},
    {ftEsc8Bits, 0x0855 -0x07ff},
    {ftEscBits, 0x0860 -0x07ff},
    {ft1MaxGamma, 0x0881 -0x07ff},
    {ft8MaxGamma, 0x0885 -0x07ff},
    {ft2MaxGamma, 0x08b1 -0x07ff},
    {ftExtraBits, 0x08b7 -0x07ff},
    {ftMemConfig, 0x08da -0x07ff},
    {ftCli, 0x08dd -0x07ff},
    {ftExecLo, 0x08df -0x07ff},
    {ftExecHi, 0x08e0 -0x07ff},
    {ftInposLo, 0x08e7 -0x07ff},
    {ftInposHi, 0x08e8 -0x07ff},
    {ftMaxGamma, 0x08ff -0x07ff},
    {ftEnd,0}
};

static unsigned char headerC64W[] = {
    0x01,0x08,0x0b,0x08,0xef,0x00,0x9e,0x32,
    0x30,0x36,0x31,0x00,0x00,0x00,0x78,0xee,
    0x30,0xd0,0xa9,0x38,0x85,0x01,0xa2,0x00,
    0xbd,0xaa,0xaa,0x95,0x4b,0xca,0x10,0xf8,
    0xa2,0x3b,0xbd,0x4c,0x08,0x9d,0xff,0x01,
    0xca,0xd0,0xf7,0xa2,0xcf,0xbd,0x86,0x08,
    0x9d,0xf6,0x00,0xca,0xd0,0xf7,0xa0,0xaa,
    0xca,0xbd,0xaa,0xaa,0x9d,0x00,0xff,0x8a,
    0xd0,0xf6,0xce,0x3d,0x08,0xce,0x3a,0x08,
    0x88,0xd0,0xed,0x4c,0x16,0x01,0x48,0xad,
    0xaa,0xaa,0x2a,0x85,0xf7,0xee,0x02,0x02,
    0xd0,0x0a,0xee,0x03,0x02,0xd0,0x05,0xa9,
    0x4b,0x8d,0x02,0x02,0x68,0x60,0xe8,0x8a,
    0x06,0xf7,0xd0,0x03,0x20,0x00,0x02,0x90,
    0x12,0xe8,0xe0,0x07,0xd0,0xf2,0xf0,0x0b,
    0xa2,0x07,0xe8,0x06,0xf7,0xd0,0x03,0x20,
    0x00,0x02,0x2a,0xca,0xd0,0xf5,0x18,0x60,
    0x80,0x00,0x8d,0xaa,0xaa,0xe6,0xfa,0xd0,
    0x02,0xe6,0xfb,0xca,0x60,0xa4,0xf8,0xa2,
    0x02,0x20,0x36,0x02,0x85,0xf8,0x98,0xa2,
    0x06,0x20,0x36,0x02,0x20,0xf9,0x00,0xa0,
    0x00,0x98,0xa2,0x02,0x20,0x36,0x02,0xc5,
    0xf8,0xd0,0xec,0x20,0x18,0x02,0x85,0x2d,
    0x4a,0xd0,0x3f,0x20,0x2c,0x02,0x4a,0x90,
    0x47,0x20,0x2c,0x02,0x4a,0x90,0xce,0xc8,
    0x20,0x18,0x02,0x85,0x2d,0xc9,0x40,0x90,
    0x0b,0xa2,0x02,0x20,0x2d,0x02,0x85,0x2d,
    0x20,0x18,0x02,0xa8,0x20,0x18,0x02,0xaa,
    0xbd,0xa5,0x01,0xe0,0x20,0x90,0x06,0x8a,
    0xa2,0x03,0x20,0x2d,0x02,0xa6,0x2d,0xe8,
    0x20,0xf9,0x00,0xd0,0xfb,0x88,0xd0,0xf8,
    0xf0,0xad,0x20,0x18,0x02,0xc9,0x7f,0xf0,
    0x23,0xe9,0x00,0xa2,0x00,0x20,0x36,0x02,
    0x85,0x2e,0x20,0x2a,0x02,0x65,0xfa,0xa6,
    0x2d,0x85,0x2d,0xa5,0xfb,0xe5,0x2e,0x85,
    0x2e,0xe8,0xb1,0x2d,0xc8,0x20,0xf9,0x00,
    0xd0,0xf8,0xf0,0xd4,0xa9,0x37,0x85,0x01,
    0xce,0x30,0xd0,0xa5,0xfa,0x85,0x2d,0xa5,
    0xfb,0x85,0x2e,0x58,0x4c,0xaa,0xaa,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00
};

struct FixEntry fixTableC64W[] = {
    {ftFastDisable, 0x080e -0x07ff},
    {ftOverlap, 0x0816 -0x07ff},
    {ftOverlapLo, 0x0818 -0x07ff},
    {ftOverlapHi, 0x0819 -0x07ff},
    {ftIBufferSize, 0x0820 -0x07ff},
    {ftReloc, 0x0823 -0x07ff},
    {ftStackSize, 0x082b -0x07ff},
    {ftReloc, 0x082e -0x07ff},
    {ftSizePages, 0x0836 -0x07ff},
    {ftSizeLo, 0x0839 -0x07ff},
    {ftSizeHi, 0x083a -0x07ff},
    {ftEndLo, 0x083c -0x07ff},
    {ftEndHi, 0x083d -0x07ff},
    {ftReloc, 0x0843 -0x07ff},
    {ftReloc, 0x0846 -0x07ff},
    {ftDeCall, 0x084a -0x07ff},
    {ftInposLo, 0x084f -0x07ff},
    {ftInposHi, 0x0850 -0x07ff},
    {ftMaxGamma, 0x0872 -0x07ff},
    {ftEscValue, 0x0888 -0x07ff},
    {ftOutposLo, 0x088a -0x07ff},
    {ftOutposHi, 0x088b -0x07ff},
    {ftEscBits, 0x0897 -0x07ff},
    {ftEsc8Bits, 0x089f -0x07ff},
    {ftEscBits, 0x08aa -0x07ff},
    {ft1MaxGamma, 0x08cd -0x07ff},
    {ft8MaxGamma, 0x08d1 -0x07ff},
    {ft2MaxGamma, 0x08fd -0x07ff},
    {ftExtraBits, 0x0903 -0x07ff},
    {ftMemConfig, 0x0924 -0x07ff},
    {ftFastDisable, 0x0927 -0x07ff},
    {ftCli, 0x0932 -0x07ff},
    {ftExecLo, 0x0934 -0x07ff},
    {ftExecHi, 0x0935 -0x07ff},
    {ftEnd,0}
};

static unsigned char headerC64[] = {
    0x01,0x08,0x0b,0x08,0xef,0x00,0x9e,0x32,
    0x30,0x36,0x31,0x00,0x00,0x00,0x78,0xee,
    0x30,0xd0,0xa9,0x38,0x85,0x01,0xa2,0x34,
    0xbd,0x42,0x08,0x9d,0xff,0x01,0xca,0xd0,
    0xf7,0xa2,0xcf,0xbd,0x75,0x08,0x9d,0xf6,
    0x00,0xca,0xd0,0xf7,0xa0,0xaa,0xca,0xbd,
    0xaa,0xaa,0x9d,0x00,0xff,0x8a,0xd0,0xf6,
    0xce,0x33,0x08,0xce,0x30,0x08,0x88,0xd0,
    0xed,0x4c,0x16,0x01,0x48,0xad,0xaa,0xaa,
    0x2a,0x85,0xf7,0xee,0x02,0x02,0xd0,0x03,
    0xee,0x03,0x02,0x68,0x60,0xe8,0x8a,0x06,
    0xf7,0xd0,0x03,0x20,0x00,0x02,0x90,0x12,
    0xe8,0xe0,0x07,0xd0,0xf2,0xf0,0x0b,0xa2,
    0x07,0xe8,0x06,0xf7,0xd0,0x03,0x20,0x00,
    0x02,0x2a,0xca,0xd0,0xf5,0x18,0x60,0x80,
    0x00,0x8d,0xaa,0xaa,0xe6,0xfa,0xd0,0x02,
    0xe6,0xfb,0xca,0x60,0xa4,0xf8,0xa2,0x02,
    0x20,0x2f,0x02,0x85,0xf8,0x98,0xa2,0x06,
    0x20,0x2f,0x02,0x20,0xf9,0x00,0xa0,0x00,
    0x98,0xa2,0x02,0x20,0x2f,0x02,0xc5,0xf8,
    0xd0,0xec,0x20,0x11,0x02,0x85,0x2d,0x4a,
    0xd0,0x3f,0x20,0x25,0x02,0x4a,0x90,0x47,
    0x20,0x25,0x02,0x4a,0x90,0xce,0xc8,0x20,
    0x11,0x02,0x85,0x2d,0xc9,0x40,0x90,0x0b,
    0xa2,0x02,0x20,0x26,0x02,0x85,0x2d,0x20,
    0x11,0x02,0xa8,0x20,0x11,0x02,0xaa,0xbd,
    0xa5,0x01,0xe0,0x20,0x90,0x06,0x8a,0xa2,
    0x03,0x20,0x26,0x02,0xa6,0x2d,0xe8,0x20,
    0xf9,0x00,0xd0,0xfb,0x88,0xd0,0xf8,0xf0,
    0xad,0x20,0x11,0x02,0xc9,0x7f,0xf0,0x23,
    0xe9,0x00,0xa2,0x00,0x20,0x2f,0x02,0x85,
    0x2e,0x20,0x23,0x02,0x65,0xfa,0xa6,0x2d,
    0x85,0x2d,0xa5,0xfb,0xe5,0x2e,0x85,0x2e,
    0xe8,0xb1,0x2d,0xc8,0x20,0xf9,0x00,0xd0,
    0xf8,0xf0,0xd4,0xa9,0x37,0x85,0x01,0xce,
    0x30,0xd0,0xa5,0xfa,0x85,0x2d,0xa5,0xfb,
    0x85,0x2e,0x58,0x4c,0xaa,0xaa,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00
};

struct FixEntry fixTableC64[] = {
    {ftFastDisable, 0x080e -0x07ff},
    {ftIBufferSize, 0x0816 -0x07ff},
    {ftReloc, 0x0819 -0x07ff},
    {ftStackSize, 0x0821 -0x07ff},
    {ftReloc, 0x0824 -0x07ff},
    {ftSizePages, 0x082c -0x07ff},
    {ftSizeLo, 0x082f -0x07ff},
    {ftSizeHi, 0x0830 -0x07ff},
    {ftEndLo, 0x0832 -0x07ff},
    {ftEndHi, 0x0833 -0x07ff},
    {ftReloc, 0x0839 -0x07ff},
    {ftReloc, 0x083c -0x07ff},
    {ftDeCall, 0x0840 -0x07ff},
    {ftInposLo, 0x0845 -0x07ff},
    {ftInposHi, 0x0846 -0x07ff},
    {ftMaxGamma, 0x0861 -0x07ff},
    {ftEscValue, 0x0877 -0x07ff},
    {ftOutposLo, 0x0879 -0x07ff},
    {ftOutposHi, 0x087a -0x07ff},
    {ftEscBits, 0x0886 -0x07ff},
    {ftEsc8Bits, 0x088e -0x07ff},
    {ftEscBits, 0x0899 -0x07ff},
    {ft1MaxGamma, 0x08bc -0x07ff},
    {ft8MaxGamma, 0x08c0 -0x07ff},
    {ft2MaxGamma, 0x08ec -0x07ff},
    {ftExtraBits, 0x08f2 -0x07ff},
    {ftMemConfig, 0x0913 -0x07ff},
    {ftFastDisable, 0x0916 -0x07ff},
    {ftCli, 0x0921 -0x07ff},
    {ftExecLo, 0x0923 -0x07ff},
    {ftExecHi, 0x0924 -0x07ff},
    {ftEnd,0}
};

static unsigned char headerC64WD[] = {
    0x01,0x08,0x0b,0x08,0xef,0x00,0x9e,0x32,
    0x30,0x36,0x31,0x00,0x00,0x00,0x78,0xee,
    0x30,0xd0,0xa9,0x38,0x85,0x01,0xa2,0x00,
    0xbd,0xaa,0xaa,0x95,0x4b,0xca,0x10,0xf8,
    0xa2,0x3b,0xbd,0x4c,0x08,0x9d,0xff,0x01,
    0xca,0xd0,0xf7,0xa2,0xe5,0xbd,0x86,0x08,
    0x9d,0xf6,0x00,0xca,0xd0,0xf7,0xa0,0xaa,
    0xca,0xbd,0xaa,0xaa,0x9d,0x00,0xff,0x8a,
    0xd0,0xf6,0xce,0x3d,0x08,0xce,0x3a,0x08,
    0x88,0xd0,0xed,0x4c,0x16,0x01,0x48,0xad,
    0xaa,0xaa,0x2a,0x85,0xf7,0xee,0x02,0x02,
    0xd0,0x0a,0xee,0x03,0x02,0xd0,0x05,0xa9,
    0x4b,0x8d,0x02,0x02,0x68,0x60,0xe8,0x8a,
    0x06,0xf7,0xd0,0x03,0x20,0x00,0x02,0x90,
    0x12,0xe8,0xe0,0x07,0xd0,0xf2,0xf0,0x0b,
    0xa2,0x07,0xe8,0x06,0xf7,0xd0,0x03,0x20,
    0x00,0x02,0x2a,0xca,0xd0,0xf5,0x18,0x60,
    0x80,0x00,0x8d,0xaa,0xaa,0xe6,0xfa,0xd0,
    0x02,0xe6,0xfb,0xca,0x60,0xa4,0xf8,0xa2,
    0x02,0x20,0x36,0x02,0x85,0xf8,0x98,0xa2,
    0x06,0x20,0x36,0x02,0x20,0xf9,0x00,0xa0,
    0x00,0x98,0xa2,0x02,0x20,0x36,0x02,0xc5,
    0xf8,0xd0,0xec,0x20,0x18,0x02,0x85,0x2d,
    0x4a,0xd0,0x3f,0x20,0x2c,0x02,0x4a,0x90,
    0x47,0x20,0x2c,0x02,0x4a,0x90,0xce,0xc8,
    0x20,0x18,0x02,0x85,0x2d,0xc9,0x40,0x90,
    0x0b,0xa2,0x02,0x20,0x2d,0x02,0x85,0x2d,
    0x20,0x18,0x02,0xa8,0x20,0x18,0x02,0xaa,
    0xbd,0xbb,0x01,0xe0,0x20,0x90,0x06,0x8a,
    0xa2,0x03,0x20,0x2d,0x02,0xa6,0x2d,0xe8,
    0x20,0xf9,0x00,0xd0,0xfb,0x88,0xd0,0xf8,
    0xf0,0xad,0x20,0x18,0x02,0xc9,0x7f,0xf0,
    0x2b,0xe9,0x00,0xa2,0x00,0x20,0x36,0x02,
    0x85,0x2e,0x8c,0x92,0x01,0xa0,0x00,0x20,
    0x2a,0x02,0x65,0xfa,0xa6,0x2d,0x85,0x2d,
    0xa5,0xfb,0xe5,0x2e,0x85,0x2e,0xe8,0xb1,
    0x2d,0x18,0x69,0x00,0xc8,0x20,0xf9,0x00,
    0xd0,0xf5,0xf0,0xcc,0xa5,0x2d,0xc9,0x02,
    0xf0,0x08,0x20,0x2a,0x02,0xa8,0xa9,0x00,
    0xf0,0xce,0xa9,0x37,0x85,0x01,0xce,0x30,
    0xd0,0xa5,0xfa,0x85,0x2d,0xa5,0xfb,0x85,
    0x2e,0x58,0x4c,0xaa,0xaa,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00
};

struct FixEntry fixTableC64WD[] = {
    {ftFastDisable, 0x080e -0x07ff},
    {ftOverlap, 0x0816 -0x07ff},
    {ftOverlapLo, 0x0818 -0x07ff},
    {ftOverlapHi, 0x0819 -0x07ff},
    {ftIBufferSize, 0x0820 -0x07ff},
    {ftReloc, 0x0823 -0x07ff},
    {ftStackSize, 0x082b -0x07ff},
    {ftReloc, 0x082e -0x07ff},
    {ftSizePages, 0x0836 -0x07ff},
    {ftSizeLo, 0x0839 -0x07ff},
    {ftSizeHi, 0x083a -0x07ff},
    {ftEndLo, 0x083c -0x07ff},
    {ftEndHi, 0x083d -0x07ff},
    {ftReloc, 0x0843 -0x07ff},
    {ftReloc, 0x0846 -0x07ff},
    {ftDeCall, 0x084a -0x07ff},
    {ftInposLo, 0x084f -0x07ff},
    {ftInposHi, 0x0850 -0x07ff},
    {ftMaxGamma, 0x0872 -0x07ff},
    {ftEscValue, 0x0888 -0x07ff},
    {ftOutposLo, 0x088a -0x07ff},
    {ftOutposHi, 0x088b -0x07ff},
    {ftEscBits, 0x0897 -0x07ff},
    {ftEsc8Bits, 0x089f -0x07ff},
    {ftEscBits, 0x08aa -0x07ff},
    {ft1MaxGamma, 0x08cd -0x07ff},
    {ft8MaxGamma, 0x08d1 -0x07ff},
    {ft2MaxGamma, 0x08fd -0x07ff},
    {ftExtraBits, 0x0903 -0x07ff},
    {ftOp, 0x0921 -0x07ff},
    {ftMemConfig, 0x093a -0x07ff},
    {ftFastDisable, 0x093d -0x07ff},
    {ftCli, 0x0948 -0x07ff},
    {ftExecLo, 0x094a -0x07ff},
    {ftExecHi, 0x094b -0x07ff},
    {ftEnd,0}
};

static unsigned char headerC64D[] = {
    0x01,0x08,0x0b,0x08,0xef,0x00,0x9e,0x32,
    0x30,0x36,0x31,0x00,0x00,0x00,0x78,0xee,
    0x30,0xd0,0xa9,0x38,0x85,0x01,0xa2,0x34,
    0xbd,0x42,0x08,0x9d,0xff,0x01,0xca,0xd0,
    0xf7,0xa2,0xe5,0xbd,0x75,0x08,0x9d,0xf6,
    0x00,0xca,0xd0,0xf7,0xa0,0xaa,0xca,0xbd,
    0xaa,0xaa,0x9d,0x00,0xff,0x8a,0xd0,0xf6,
    0xce,0x33,0x08,0xce,0x30,0x08,0x88,0xd0,
    0xed,0x4c,0x16,0x01,0x48,0xad,0xaa,0xaa,
    0x2a,0x85,0xf7,0xee,0x02,0x02,0xd0,0x03,
    0xee,0x03,0x02,0x68,0x60,0xe8,0x8a,0x06,
    0xf7,0xd0,0x03,0x20,0x00,0x02,0x90,0x12,
    0xe8,0xe0,0x07,0xd0,0xf2,0xf0,0x0b,0xa2,
    0x07,0xe8,0x06,0xf7,0xd0,0x03,0x20,0x00,
    0x02,0x2a,0xca,0xd0,0xf5,0x18,0x60,0x80,
    0x00,0x8d,0xaa,0xaa,0xe6,0xfa,0xd0,0x02,
    0xe6,0xfb,0xca,0x60,0xa4,0xf8,0xa2,0x02,
    0x20,0x2f,0x02,0x85,0xf8,0x98,0xa2,0x06,
    0x20,0x2f,0x02,0x20,0xf9,0x00,0xa0,0x00,
    0x98,0xa2,0x02,0x20,0x2f,0x02,0xc5,0xf8,
    0xd0,0xec,0x20,0x11,0x02,0x85,0x2d,0x4a,
    0xd0,0x3f,0x20,0x25,0x02,0x4a,0x90,0x47,
    0x20,0x25,0x02,0x4a,0x90,0xce,0xc8,0x20,
    0x11,0x02,0x85,0x2d,0xc9,0x40,0x90,0x0b,
    0xa2,0x02,0x20,0x26,0x02,0x85,0x2d,0x20,
    0x11,0x02,0xa8,0x20,0x11,0x02,0xaa,0xbd,
    0xbb,0x01,0xe0,0x20,0x90,0x06,0x8a,0xa2,
    0x03,0x20,0x26,0x02,0xa6,0x2d,0xe8,0x20,
    0xf9,0x00,0xd0,0xfb,0x88,0xd0,0xf8,0xf0,
    0xad,0x20,0x11,0x02,0xc9,0x7f,0xf0,0x2b,
    0xe9,0x00,0xa2,0x00,0x20,0x2f,0x02,0x85,
    0x2e,0x8c,0x92,0x01,0xa0,0x00,0x20,0x23,
    0x02,0x65,0xfa,0xa6,0x2d,0x85,0x2d,0xa5,
    0xfb,0xe5,0x2e,0x85,0x2e,0xe8,0xb1,0x2d,
    0x18,0x69,0x00,0xc8,0x20,0xf9,0x00,0xd0,
    0xf5,0xf0,0xcc,0xa5,0x2d,0xc9,0x02,0xf0,
    0x08,0x20,0x23,0x02,0xa8,0xa9,0x00,0xf0,
    0xce,0xa9,0x37,0x85,0x01,0xce,0x30,0xd0,
    0xa5,0xfa,0x85,0x2d,0xa5,0xfb,0x85,0x2e,
    0x58,0x4c,0xaa,0xaa,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00
};

struct FixEntry fixTableC64D[] = {
    {ftFastDisable, 0x080e -0x07ff},
    {ftIBufferSize, 0x0816 -0x07ff},
    {ftReloc, 0x0819 -0x07ff},
    {ftStackSize, 0x0821 -0x07ff},
    {ftReloc, 0x0824 -0x07ff},
    {ftSizePages, 0x082c -0x07ff},
    {ftSizeLo, 0x082f -0x07ff},
    {ftSizeHi, 0x0830 -0x07ff},
    {ftEndLo, 0x0832 -0x07ff},
    {ftEndHi, 0x0833 -0x07ff},
    {ftReloc, 0x0839 -0x07ff},
    {ftReloc, 0x083c -0x07ff},
    {ftDeCall, 0x0840 -0x07ff},
    {ftInposLo, 0x0845 -0x07ff},
    {ftInposHi, 0x0846 -0x07ff},
    {ftMaxGamma, 0x0861 -0x07ff},
    {ftEscValue, 0x0877 -0x07ff},
    {ftOutposLo, 0x0879 -0x07ff},
    {ftOutposHi, 0x087a -0x07ff},
    {ftEscBits, 0x0886 -0x07ff},
    {ftEsc8Bits, 0x088e -0x07ff},
    {ftEscBits, 0x0899 -0x07ff},
    {ft1MaxGamma, 0x08bc -0x07ff},
    {ft8MaxGamma, 0x08c0 -0x07ff},
    {ft2MaxGamma, 0x08ec -0x07ff},
    {ftExtraBits, 0x08f2 -0x07ff},
    {ftOp, 0x0910 -0x07ff},
    {ftMemConfig, 0x0929 -0x07ff},
    {ftFastDisable, 0x092c -0x07ff},
    {ftCli, 0x0937 -0x07ff},
    {ftExecLo, 0x0939 -0x07ff},
    {ftExecHi, 0x093a -0x07ff},
    {ftEnd,0}
};

static unsigned char headerC64WF[] = {
    0x01,0x08,0x0b,0x08,0xef,0x00,0x9e,0x32,
    0x30,0x36,0x31,0x00,0x00,0x00,0x78,0xee,
    0x30,0xd0,0xa9,0x38,0x85,0x01,0xa2,0x00,
    0xbd,0xaa,0xaa,0x95,0x4b,0xca,0x10,0xf8,
    0xa2,0x3b,0xbd,0x4c,0x08,0x9d,0xff,0x01,
    0xca,0xd0,0xf7,0xa2,0xe6,0xbd,0x86,0x08,
    0x9d,0xf6,0x00,0xca,0xd0,0xf7,0xa0,0xaa,
    0xca,0xbd,0xaa,0xaa,0x9d,0x00,0xff,0x8a,
    0xd0,0xf6,0xce,0x3d,0x08,0xce,0x3a,0x08,
    0x88,0xd0,0xed,0x4c,0x18,0x01,0x48,0xad,
    0xaa,0xaa,0x2a,0x85,0xf7,0xee,0x02,0x02,
    0xd0,0x0a,0xee,0x03,0x02,0xd0,0x05,0xa9,
    0x4b,0x8d,0x02,0x02,0x68,0x60,0xe8,0x8a,
    0x06,0xf7,0xd0,0x03,0x20,0x00,0x02,0x90,
    0x12,0xe8,0xe0,0x07,0xd0,0xf2,0xf0,0x0b,
    0xa2,0x07,0xe8,0x06,0xf7,0xd0,0x03,0x20,
    0x00,0x02,0x2a,0xca,0xd0,0xf5,0x18,0x60,
    0x80,0x00,0x8d,0xaa,0xaa,0xe6,0xfa,0xf0,
    0x02,0xca,0x60,0xe6,0xfb,0xca,0x60,0xa4,
    0xf8,0xa2,0x02,0x20,0x36,0x02,0x85,0xf8,
    0x98,0xa2,0x06,0x20,0x36,0x02,0x20,0xf9,
    0x00,0xa0,0x00,0x98,0xa2,0x02,0x20,0x36,
    0x02,0xc5,0xf8,0xd0,0xec,0x20,0x18,0x02,
    0x85,0x2d,0x4a,0xd0,0x45,0x06,0xf7,0xd0,
    0x03,0x20,0x00,0x02,0x90,0x4a,0x06,0xf7,
    0xd0,0x03,0x20,0x00,0x02,0x90,0xc8,0xc8,
    0x20,0x18,0x02,0x85,0x2d,0xc9,0x40,0x90,
    0x0b,0xa2,0x02,0x20,0x2d,0x02,0x85,0x2d,
    0x20,0x18,0x02,0xa8,0x20,0x18,0x02,0xaa,
    0xbd,0xbc,0x01,0xe0,0x20,0x90,0x06,0x8a,
    0xa2,0x03,0x20,0x2d,0x02,0xa6,0x2d,0xe8,
    0x20,0xf9,0x00,0xd0,0xfb,0x88,0xd0,0xf8,
    0xf0,0xa7,0x20,0x18,0x02,0xc9,0x7f,0xf0,
    0x32,0xe9,0x00,0xa2,0x00,0x20,0x36,0x02,
    0x85,0x2e,0x20,0x2a,0x02,0x65,0xfa,0xa6,
    0x2d,0x8d,0x94,0x01,0xa5,0xfb,0xe5,0x2e,
    0x8d,0x95,0x01,0xe8,0xb9,0xaa,0xaa,0x91,
    0xfa,0xc8,0xca,0xd0,0xf7,0x88,0x98,0x38,
    0x65,0xfa,0x85,0xfa,0x90,0x02,0xe6,0xfb,
    0x4c,0x18,0x01,0xa9,0x37,0x85,0x01,0xce,
    0x30,0xd0,0xa5,0xfa,0x85,0x2d,0xa5,0xfb,
    0x85,0x2e,0x58,0x4c,0xaa,0xaa,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00
};

struct FixEntry fixTableC64WF[] = {
    {ftFastDisable, 0x080e -0x07ff},
    {ftOverlap, 0x0816 -0x07ff},
    {ftOverlapLo, 0x0818 -0x07ff},
    {ftOverlapHi, 0x0819 -0x07ff},
    {ftIBufferSize, 0x0820 -0x07ff},
    {ftReloc, 0x0823 -0x07ff},
    {ftStackSize, 0x082b -0x07ff},
    {ftReloc, 0x082e -0x07ff},
    {ftSizePages, 0x0836 -0x07ff},
    {ftSizeLo, 0x0839 -0x07ff},
    {ftSizeHi, 0x083a -0x07ff},
    {ftEndLo, 0x083c -0x07ff},
    {ftEndHi, 0x083d -0x07ff},
    {ftReloc, 0x0843 -0x07ff},
    {ftReloc, 0x0846 -0x07ff},
    {ftDeCall, 0x084a -0x07ff},
    {ftInposLo, 0x084f -0x07ff},
    {ftInposHi, 0x0850 -0x07ff},
    {ftMaxGamma, 0x0872 -0x07ff},
    {ftEscValue, 0x0888 -0x07ff},
    {ftOutposLo, 0x088a -0x07ff},
    {ftOutposHi, 0x088b -0x07ff},
    {ftEscBits, 0x0899 -0x07ff},
    {ftEsc8Bits, 0x08a1 -0x07ff},
    {ftEscBits, 0x08ac -0x07ff},
    {ft1MaxGamma, 0x08d5 -0x07ff},
    {ft8MaxGamma, 0x08d9 -0x07ff},
    {ft2MaxGamma, 0x0905 -0x07ff},
    {ftExtraBits, 0x090b -0x07ff},
    {ftMemConfig, 0x093b -0x07ff},
    {ftFastDisable, 0x093e -0x07ff},
    {ftCli, 0x0949 -0x07ff},
    {ftExecLo, 0x094b -0x07ff},
    {ftExecHi, 0x094c -0x07ff},
    {ftEnd,0}
};

static unsigned char headerC64F[] = {
    0x01,0x08,0x0b,0x08,0xef,0x00,0x9e,0x32,
    0x30,0x36,0x31,0x00,0x00,0x00,0x78,0xee,
    0x30,0xd0,0xa9,0x38,0x85,0x01,0xa2,0x34,
    0xbd,0x42,0x08,0x9d,0xff,0x01,0xca,0xd0,
    0xf7,0xa2,0xe6,0xbd,0x75,0x08,0x9d,0xf6,
    0x00,0xca,0xd0,0xf7,0xa0,0xaa,0xca,0xbd,
    0xaa,0xaa,0x9d,0x00,0xff,0x8a,0xd0,0xf6,
    0xce,0x33,0x08,0xce,0x30,0x08,0x88,0xd0,
    0xed,0x4c,0x18,0x01,0x48,0xad,0xaa,0xaa,
    0x2a,0x85,0xf7,0xee,0x02,0x02,0xd0,0x03,
    0xee,0x03,0x02,0x68,0x60,0xe8,0x8a,0x06,
    0xf7,0xd0,0x03,0x20,0x00,0x02,0x90,0x12,
    0xe8,0xe0,0x07,0xd0,0xf2,0xf0,0x0b,0xa2,
    0x07,0xe8,0x06,0xf7,0xd0,0x03,0x20,0x00,
    0x02,0x2a,0xca,0xd0,0xf5,0x18,0x60,0x80,
    0x00,0x8d,0xaa,0xaa,0xe6,0xfa,0xf0,0x02,
    0xca,0x60,0xe6,0xfb,0xca,0x60,0xa4,0xf8,
    0xa2,0x02,0x20,0x2f,0x02,0x85,0xf8,0x98,
    0xa2,0x06,0x20,0x2f,0x02,0x20,0xf9,0x00,
    0xa0,0x00,0x98,0xa2,0x02,0x20,0x2f,0x02,
    0xc5,0xf8,0xd0,0xec,0x20,0x11,0x02,0x85,
    0x2d,0x4a,0xd0,0x45,0x06,0xf7,0xd0,0x03,
    0x20,0x00,0x02,0x90,0x4a,0x06,0xf7,0xd0,
    0x03,0x20,0x00,0x02,0x90,0xc8,0xc8,0x20,
    0x11,0x02,0x85,0x2d,0xc9,0x40,0x90,0x0b,
    0xa2,0x02,0x20,0x26,0x02,0x85,0x2d,0x20,
    0x11,0x02,0xa8,0x20,0x11,0x02,0xaa,0xbd,
    0xbc,0x01,0xe0,0x20,0x90,0x06,0x8a,0xa2,
    0x03,0x20,0x26,0x02,0xa6,0x2d,0xe8,0x20,
    0xf9,0x00,0xd0,0xfb,0x88,0xd0,0xf8,0xf0,
    0xa7,0x20,0x11,0x02,0xc9,0x7f,0xf0,0x32,
    0xe9,0x00,0xa2,0x00,0x20,0x2f,0x02,0x85,
    0x2e,0x20,0x23,0x02,0x65,0xfa,0xa6,0x2d,
    0x8d,0x94,0x01,0xa5,0xfb,0xe5,0x2e,0x8d,
    0x95,0x01,0xe8,0xb9,0xaa,0xaa,0x91,0xfa,
    0xc8,0xca,0xd0,0xf7,0x88,0x98,0x38,0x65,
    0xfa,0x85,0xfa,0x90,0x02,0xe6,0xfb,0x4c,
    0x18,0x01,0xa9,0x37,0x85,0x01,0xce,0x30,
    0xd0,0xa5,0xfa,0x85,0x2d,0xa5,0xfb,0x85,
    0x2e,0x58,0x4c,0xaa,0xaa,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00
};

struct FixEntry fixTableC64F[] = {
    {ftFastDisable, 0x080e -0x07ff},
    {ftIBufferSize, 0x0816 -0x07ff},
    {ftReloc, 0x0819 -0x07ff},
    {ftStackSize, 0x0821 -0x07ff},
    {ftReloc, 0x0824 -0x07ff},
    {ftSizePages, 0x082c -0x07ff},
    {ftSizeLo, 0x082f -0x07ff},
    {ftSizeHi, 0x0830 -0x07ff},
    {ftEndLo, 0x0832 -0x07ff},
    {ftEndHi, 0x0833 -0x07ff},
    {ftReloc, 0x0839 -0x07ff},
    {ftReloc, 0x083c -0x07ff},
    {ftDeCall, 0x0840 -0x07ff},
    {ftInposLo, 0x0845 -0x07ff},
    {ftInposHi, 0x0846 -0x07ff},
    {ftMaxGamma, 0x0861 -0x07ff},
    {ftEscValue, 0x0877 -0x07ff},
    {ftOutposLo, 0x0879 -0x07ff},
    {ftOutposHi, 0x087a -0x07ff},
    {ftEscBits, 0x0888 -0x07ff},
    {ftEsc8Bits, 0x0890 -0x07ff},
    {ftEscBits, 0x089b -0x07ff},
    {ft1MaxGamma, 0x08c4 -0x07ff},
    {ft8MaxGamma, 0x08c8 -0x07ff},
    {ft2MaxGamma, 0x08f4 -0x07ff},
    {ftExtraBits, 0x08fa -0x07ff},
    {ftMemConfig, 0x092a -0x07ff},
    {ftFastDisable, 0x092d -0x07ff},
    {ftCli, 0x0938 -0x07ff},
    {ftExecLo, 0x093a -0x07ff},
    {ftExecHi, 0x093b -0x07ff},
    {ftEnd,0}
};

static unsigned char headerVIC20[] = {
    0x01,0x12,0x0b,0x12,0xef,0x00,0x9e,0x34,
    0x36,0x32,0x31,0x00,0x00,0x00,0x78,0xa2,
    0x34,0xbd,0x3b,0x12,0x9d,0xff,0x01,0xca,
    0xd0,0xf7,0xa2,0xc8,0xbd,0x6e,0x12,0x9d,
    0xf6,0x00,0xca,0xd0,0xf7,0xa0,0xaa,0xca,
    0xbd,0xaa,0xaa,0x9d,0x00,0xff,0x8a,0xd0,
    0xf6,0xce,0x2c,0x12,0xce,0x29,0x12,0x88,
    0xd0,0xed,0x4c,0x16,0x01,0x48,0xad,0xaa,
    0xaa,0x2a,0x85,0xf7,0xee,0x02,0x02,0xd0,
    0x03,0xee,0x03,0x02,0x68,0x60,0xe8,0x8a,
    0x06,0xf7,0xd0,0x03,0x20,0x00,0x02,0x90,
    0x12,0xe8,0xe0,0x07,0xd0,0xf2,0xf0,0x0b,
    0xa2,0x07,0xe8,0x06,0xf7,0xd0,0x03,0x20,
    0x00,0x02,0x2a,0xca,0xd0,0xf5,0x18,0x60,
    0x80,0x00,0x8d,0xaa,0xaa,0xe6,0xfa,0xd0,
    0x02,0xe6,0xfb,0xca,0x60,0xa4,0xf8,0xa2,
    0x02,0x20,0x2f,0x02,0x85,0xf8,0x98,0xa2,
    0x06,0x20,0x2f,0x02,0x20,0xf9,0x00,0xa0,
    0x00,0x98,0xa2,0x02,0x20,0x2f,0x02,0xc5,
    0xf8,0xd0,0xec,0x20,0x11,0x02,0x85,0x2d,
    0x4a,0xd0,0x3f,0x20,0x25,0x02,0x4a,0x90,
    0x47,0x20,0x25,0x02,0x4a,0x90,0xce,0xc8,
    0x20,0x11,0x02,0x85,0x2d,0xc9,0x40,0x90,
    0x0b,0xa2,0x02,0x20,0x26,0x02,0x85,0x2d,
    0x20,0x11,0x02,0xa8,0x20,0x11,0x02,0xaa,
    0xbd,0x9e,0x01,0xe0,0x20,0x90,0x06,0x8a,
    0xa2,0x03,0x20,0x26,0x02,0xa6,0x2d,0xe8,
    0x20,0xf9,0x00,0xd0,0xfb,0x88,0xd0,0xf8,
    0xf0,0xad,0x20,0x11,0x02,0xc9,0x7f,0xf0,
    0x23,0xe9,0x00,0xa2,0x00,0x20,0x2f,0x02,
    0x85,0x2e,0x20,0x23,0x02,0x65,0xfa,0xa6,
    0x2d,0x85,0x2d,0xa5,0xfb,0xe5,0x2e,0x85,
    0x2e,0xe8,0xb1,0x2d,0xc8,0x20,0xf9,0x00,
    0xd0,0xf8,0xf0,0xd4,0xa5,0xfa,0x85,0x2d,
    0xa5,0xfb,0x85,0x2e,0x58,0x4c,0xaa,0xaa,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

struct FixEntry fixTableVIC20[] = {
    {ftIBufferSize, 0x120f -0x11ff},
    {ftReloc, 0x1212 -0x11ff},
    {ftStackSize, 0x121a -0x11ff},
    {ftReloc, 0x121d -0x11ff},
    {ftSizePages, 0x1225 -0x11ff},
    {ftSizeLo, 0x1228 -0x11ff},
    {ftSizeHi, 0x1229 -0x11ff},
    {ftEndLo, 0x122b -0x11ff},
    {ftEndHi, 0x122c -0x11ff},
    {ftReloc, 0x1232 -0x11ff},
    {ftReloc, 0x1235 -0x11ff},
    {ftDeCall, 0x1239 -0x11ff},
    {ftInposLo, 0x123e -0x11ff},
    {ftInposHi, 0x123f -0x11ff},
    {ftMaxGamma, 0x125a -0x11ff},
    {ftEscValue, 0x1270 -0x11ff},
    {ftOutposLo, 0x1272 -0x11ff},
    {ftOutposHi, 0x1273 -0x11ff},
    {ftEscBits, 0x127f -0x11ff},
    {ftEsc8Bits, 0x1287 -0x11ff},
    {ftEscBits, 0x1292 -0x11ff},
    {ft1MaxGamma, 0x12b5 -0x11ff},
    {ft8MaxGamma, 0x12b9 -0x11ff},
    {ft2MaxGamma, 0x12e5 -0x11ff},
    {ftExtraBits, 0x12eb -0x11ff},
    {ftCli, 0x1313 -0x11ff},
    {ftExecLo, 0x1315 -0x11ff},
    {ftExecHi, 0x1316 -0x11ff},
    {ftEnd,0}
};

static unsigned char headerVIC20W[] = {
    0x01,0x12,0x0b,0x12,0xef,0x00,0x9e,0x34,
    0x36,0x32,0x31,0x00,0x00,0x00,0x78,0xa2,
    0x00,0xbd,0xaa,0xaa,0x95,0x4b,0xca,0x10,
    0xf8,0xa2,0x42,0xbd,0x45,0x12,0x9d,0xff,
    0x01,0xca,0xd0,0xf7,0xa2,0xc9,0xbd,0x86,
    0x12,0x9d,0xf6,0x00,0xca,0xd0,0xf7,0xa0,
    0xaa,0xca,0xbd,0xaa,0xaa,0x9d,0x00,0xff,
    0x8a,0xd0,0xf6,0xce,0x36,0x12,0xce,0x33,
    0x12,0x88,0xd0,0xed,0x4c,0x17,0x01,0x48,
    0xad,0xaa,0xaa,0x2a,0x85,0xf7,0xee,0x02,
    0x02,0xd0,0x11,0xee,0x03,0x02,0xc6,0xf9,
    0xd0,0x0a,0xa9,0x4b,0x8d,0x02,0x02,0xa9,
    0x00,0x8d,0x03,0x02,0x68,0x60,0xe8,0x8a,
    0x06,0xf7,0xd0,0x03,0x20,0x00,0x02,0x90,
    0x12,0xe8,0xe0,0x07,0xd0,0xf2,0xf0,0x0b,
    0xa2,0x07,0xe8,0x06,0xf7,0xd0,0x03,0x20,
    0x00,0x02,0x2a,0xca,0xd0,0xf5,0x18,0x60,
    0x80,0x00,0xff,0x8d,0xaa,0xaa,0xe6,0xfb,
    0xd0,0x02,0xe6,0xfc,0xca,0x60,0xa4,0xf8,
    0xa2,0x02,0x20,0x3d,0x02,0x85,0xf8,0x98,
    0xa2,0x06,0x20,0x3d,0x02,0x20,0xfa,0x00,
    0xa0,0x00,0x98,0xa2,0x02,0x20,0x3d,0x02,
    0xc5,0xf8,0xd0,0xec,0x20,0x1f,0x02,0x85,
    0x2d,0x4a,0xd0,0x3f,0x20,0x33,0x02,0x4a,
    0x90,0x47,0x20,0x33,0x02,0x4a,0x90,0xce,
    0xc8,0x20,0x1f,0x02,0x85,0x2d,0xc9,0x40,
    0x90,0x0b,0xa2,0x02,0x20,0x34,0x02,0x85,
    0x2d,0x20,0x1f,0x02,0xa8,0x20,0x1f,0x02,
    0xaa,0xbd,0x9f,0x01,0xe0,0x20,0x90,0x06,
    0x8a,0xa2,0x03,0x20,0x34,0x02,0xa6,0x2d,
    0xe8,0x20,0xfa,0x00,0xd0,0xfb,0x88,0xd0,
    0xf8,0xf0,0xad,0x20,0x1f,0x02,0xc9,0x7f,
    0xf0,0x23,0xe9,0x00,0xa2,0x00,0x20,0x3d,
    0x02,0x85,0x2e,0x20,0x31,0x02,0x65,0xfb,
    0xa6,0x2d,0x85,0x2d,0xa5,0xfc,0xe5,0x2e,
    0x85,0x2e,0xe8,0xb1,0x2d,0xc8,0x20,0xfa,
    0x00,0xd0,0xf8,0xf0,0xd4,0xa5,0xfb,0x85,
    0x2d,0xa5,0xfc,0x85,0x2e,0x58,0x4c,0xaa,
    0xaa,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

struct FixEntry fixTableVIC20W[] = {
    {ftOverlap, 0x120f -0x11ff},
    {ftOverlapLo, 0x1211 -0x11ff},
    {ftOverlapHi, 0x1212 -0x11ff},
    {ftIBufferSize, 0x1219 -0x11ff},
    {ftReloc, 0x121c -0x11ff},
    {ftStackSize, 0x1224 -0x11ff},
    {ftReloc, 0x1227 -0x11ff},
    {ftSizePages, 0x122f -0x11ff},
    {ftSizeLo, 0x1232 -0x11ff},
    {ftSizeHi, 0x1233 -0x11ff},
    {ftEndLo, 0x1235 -0x11ff},
    {ftEndHi, 0x1236 -0x11ff},
    {ftReloc, 0x123c -0x11ff},
    {ftReloc, 0x123f -0x11ff},
    {ftDeCall, 0x1243 -0x11ff},
    {ftInposLo, 0x1248 -0x11ff},
    {ftInposHi, 0x1249 -0x11ff},
    {ftMaxGamma, 0x1272 -0x11ff},
    {ftEscValue, 0x1288 -0x11ff},
    {ftWrapCount, 0x1289 -0x11ff},
    {ftOutposLo, 0x128b -0x11ff},
    {ftOutposHi, 0x128c -0x11ff},
    {ftEscBits, 0x1298 -0x11ff},
    {ftEsc8Bits, 0x12a0 -0x11ff},
    {ftEscBits, 0x12ab -0x11ff},
    {ft1MaxGamma, 0x12ce -0x11ff},
    {ft8MaxGamma, 0x12d2 -0x11ff},
    {ft2MaxGamma, 0x12fe -0x11ff},
    {ftExtraBits, 0x1304 -0x11ff},
    {ftCli, 0x132c -0x11ff},
    {ftExecLo, 0x132e -0x11ff},
    {ftExecHi, 0x132f -0x11ff},
    {ftEnd,0}
};

static unsigned char headerVIC20S[] = {
    0x01,0x12,0x0b,0x12,0xef,0x00,0x9e,0x34,
    0x36,0x32,0x31,0x00,0x00,0x00,0xa9,0xaa,
    0x85,0x2d,0xa9,0xaa,0x85,0x2e,0xa2,0xeb,
    0xbd,0x37,0x12,0x9d,0xf6,0x00,0xca,0xd0,
    0xf7,0xa0,0xaa,0xca,0xbd,0xaa,0xaa,0x9d,
    0x00,0xff,0x8a,0xd0,0xf6,0xce,0x28,0x12,
    0xce,0x25,0x12,0x88,0xd0,0xed,0x4c,0x16,
    0x01,0x80,0x00,0x8d,0xaa,0xaa,0xe6,0xfa,
    0xd0,0x02,0xe6,0xfb,0xca,0x60,0xa4,0xf8,
    0xa2,0x02,0x20,0xbe,0x01,0x85,0xf8,0x98,
    0xa2,0x06,0x20,0xbe,0x01,0x20,0xf9,0x00,
    0xa0,0x00,0x98,0xa2,0x02,0x20,0xbe,0x01,
    0xc5,0xf8,0xd0,0xec,0x20,0xab,0x01,0x85,
    0x2f,0x4a,0xd0,0x3d,0x20,0x96,0x01,0x90,
    0x46,0x20,0x96,0x01,0x90,0xd0,0xc8,0x20,
    0xab,0x01,0x85,0x2f,0xc9,0x40,0x90,0x0b,
    0xa2,0x02,0x20,0xb9,0x01,0x85,0x2f,0x20,
    0xab,0x01,0xa8,0x20,0xab,0x01,0xaa,0xbd,
    0xc1,0x01,0xe0,0x20,0x90,0x06,0x8a,0xa2,
    0x03,0x20,0xb9,0x01,0xa6,0x2f,0xe8,0x20,
    0xf9,0x00,0xd0,0xfb,0x88,0xd0,0xf8,0xf0,
    0xaf,0x20,0xab,0x01,0xc9,0x7f,0xf0,0x25,
    0xe9,0x00,0xa2,0x00,0x20,0xbe,0x01,0x85,
    0x30,0xa2,0x08,0x20,0xb9,0x01,0x65,0xfa,
    0xa6,0x2f,0x85,0x2f,0xa5,0xfb,0xe5,0x30,
    0x85,0x30,0xe8,0xb1,0x2f,0xc8,0x20,0xf9,
    0x00,0xd0,0xf8,0xf0,0xd2,0x4c,0xaa,0xaa,
    0x06,0xf7,0xd0,0x10,0x48,0xad,0xaa,0xaa,
    0x2a,0x85,0xf7,0xee,0x9c,0x01,0xd0,0x03,
    0xee,0x9d,0x01,0x68,0x60,0xe8,0x8a,0x20,
    0x96,0x01,0x90,0x0b,0xe8,0xe0,0x07,0xd0,
    0xf6,0xf0,0x04,0x20,0x96,0x01,0x2a,0xca,
    0xd0,0xf9,0x18,0x60,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00
};

struct FixEntry fixTableVIC20S[] = {
    {ftBEndHi, 0x1212 -0x11ff},
    {ftStackSize, 0x1216 -0x11ff},
    {ftReloc, 0x1219 -0x11ff},
    {ftSizePages, 0x1221 -0x11ff},
    {ftSizeLo, 0x1224 -0x11ff},
    {ftSizeHi, 0x1225 -0x11ff},
    {ftEndLo, 0x1227 -0x11ff},
    {ftEndHi, 0x1228 -0x11ff},
    {ftReloc, 0x122e -0x11ff},
    {ftReloc, 0x1231 -0x11ff},
    {ftDeCall, 0x1235 -0x11ff},
    {ftEscValue, 0x1239 -0x11ff},
    {ftOutposLo, 0x123b -0x11ff},
    {ftOutposHi, 0x123c -0x11ff},
    {ftEscBits, 0x1248 -0x11ff},
    {ftEsc8Bits, 0x1250 -0x11ff},
    {ftEscBits, 0x125b -0x11ff},
    {ft1MaxGamma, 0x127c -0x11ff},
    {ft8MaxGamma, 0x1280 -0x11ff},
    {ft2MaxGamma, 0x12ac -0x11ff},
    {ftExtraBits, 0x12b2 -0x11ff},
    {ftExecLo, 0x12d5 -0x11ff},
    {ftExecHi, 0x12d6 -0x11ff},
    {ftInposLo, 0x12dd -0x11ff},
    {ftInposHi, 0x12de -0x11ff},
    {ftMaxGamma, 0x12f5 -0x11ff},
    {ftEnd,0}
};

static unsigned char headerVIC20SW[] = {
    0x01,0x12,0x0b,0x12,0xef,0x00,0x9e,0x34,
    0x36,0x32,0x31,0x00,0x00,0x00,0xa9,0xaa,
    0x85,0x2d,0xa9,0xaa,0x85,0x2e,0xa2,0x00,
    0xbd,0xaa,0xaa,0x95,0x4b,0xca,0x10,0xf8,
    0x9a,0xa2,0xfa,0xbd,0x42,0x12,0x9d,0xf6,
    0x00,0xca,0xd0,0xf7,0xa0,0xaa,0xca,0xbd,
    0xaa,0xaa,0x9d,0x00,0xff,0x8a,0xd0,0xf6,
    0xce,0x33,0x12,0xce,0x30,0x12,0x88,0xd0,
    0xed,0x4c,0x17,0x01,0x80,0x00,0xff,0x8d,
    0xaa,0xaa,0xe6,0xfb,0xd0,0x02,0xe6,0xfc,
    0xca,0x60,0xa4,0xf8,0xa2,0x02,0x20,0xcd,
    0x01,0x85,0xf8,0x98,0xa2,0x06,0x20,0xcd,
    0x01,0x20,0xfa,0x00,0xa0,0x00,0x98,0xa2,
    0x02,0x20,0xcd,0x01,0xc5,0xf8,0xd0,0xec,
    0x20,0xba,0x01,0x85,0x2f,0x4a,0xd0,0x3d,
    0x20,0x97,0x01,0x90,0x46,0x20,0x97,0x01,
    0x90,0xd0,0xc8,0x20,0xba,0x01,0x85,0x2f,
    0xc9,0x40,0x90,0x0b,0xa2,0x02,0x20,0xc8,
    0x01,0x85,0x2f,0x20,0xba,0x01,0xa8,0x20,
    0xba,0x01,0xaa,0xbd,0xd0,0x01,0xe0,0x20,
    0x90,0x06,0x8a,0xa2,0x03,0x20,0xc8,0x01,
    0xa6,0x2f,0xe8,0x20,0xfa,0x00,0xd0,0xfb,
    0x88,0xd0,0xf8,0xf0,0xaf,0x20,0xba,0x01,
    0xc9,0x7f,0xf0,0x25,0xe9,0x00,0xa2,0x00,
    0x20,0xcd,0x01,0x85,0x30,0xa2,0x08,0x20,
    0xc8,0x01,0x65,0xfb,0xa6,0x2f,0x85,0x2f,
    0xa5,0xfc,0xe5,0x30,0x85,0x30,0xe8,0xb1,
    0x2f,0xc8,0x20,0xfa,0x00,0xd0,0xf8,0xf0,
    0xd2,0x4c,0xaa,0xaa,0x06,0xf7,0xd0,0x1e,
    0x48,0xad,0xaa,0xaa,0x2a,0x85,0xf7,0xee,
    0x9d,0x01,0xd0,0x11,0xee,0x9e,0x01,0xc6,
    0xf9,0xd0,0x0a,0xa9,0x4b,0x8d,0x9d,0x01,
    0xa9,0x00,0x8d,0x9e,0x01,0x68,0x60,0xe8,
    0x8a,0x20,0x97,0x01,0x90,0x0b,0xe8,0xe0,
    0x07,0xd0,0xf6,0xf0,0x04,0x20,0x97,0x01,
    0x2a,0xca,0xd0,0xf9,0x18,0x60,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00
};

struct FixEntry fixTableVIC20SW[] = {
    {ftBEndHi, 0x1212 -0x11ff},
    {ftOverlap, 0x1216 -0x11ff},
    {ftOverlapLo, 0x1218 -0x11ff},
    {ftOverlapHi, 0x1219 -0x11ff},
    {ftStackSize, 0x1221 -0x11ff},
    {ftReloc, 0x1224 -0x11ff},
    {ftSizePages, 0x122c -0x11ff},
    {ftSizeLo, 0x122f -0x11ff},
    {ftSizeHi, 0x1230 -0x11ff},
    {ftEndLo, 0x1232 -0x11ff},
    {ftEndHi, 0x1233 -0x11ff},
    {ftReloc, 0x1239 -0x11ff},
    {ftReloc, 0x123c -0x11ff},
    {ftDeCall, 0x1240 -0x11ff},
    {ftEscValue, 0x1244 -0x11ff},
    {ftWrapCount, 0x1245 -0x11ff},
    {ftOutposLo, 0x1247 -0x11ff},
    {ftOutposHi, 0x1248 -0x11ff},
    {ftEscBits, 0x1254 -0x11ff},
    {ftEsc8Bits, 0x125c -0x11ff},
    {ftEscBits, 0x1267 -0x11ff},
    {ft1MaxGamma, 0x1288 -0x11ff},
    {ft8MaxGamma, 0x128c -0x11ff},
    {ft2MaxGamma, 0x12b8 -0x11ff},
    {ftExtraBits, 0x12be -0x11ff},
    {ftExecLo, 0x12e1 -0x11ff},
    {ftExecHi, 0x12e2 -0x11ff},
    {ftInposLo, 0x12e9 -0x11ff},
    {ftInposHi, 0x12ea -0x11ff},
    {ftMaxGamma, 0x130f -0x11ff},
    {ftEnd,0}
};

static unsigned char headerVIC20WD[] = {
    0x01,0x12,0x0b,0x12,0xef,0x00,0x9e,0x34,
    0x36,0x32,0x31,0x00,0x00,0x00,0x78,0xa2,
    0x00,0xbd,0xaa,0xaa,0x95,0x4b,0xca,0x10,
    0xf8,0xa2,0x42,0xbd,0x45,0x12,0x9d,0xff,
    0x01,0xca,0xd0,0xf7,0xa2,0xdf,0xbd,0x86,
    0x12,0x9d,0xf6,0x00,0xca,0xd0,0xf7,0xa0,
    0xaa,0xca,0xbd,0xaa,0xaa,0x9d,0x00,0xff,
    0x8a,0xd0,0xf6,0xce,0x36,0x12,0xce,0x33,
    0x12,0x88,0xd0,0xed,0x4c,0x17,0x01,0x48,
    0xad,0xaa,0xaa,0x2a,0x85,0xf7,0xee,0x02,
    0x02,0xd0,0x11,0xee,0x03,0x02,0xc6,0xf9,
    0xd0,0x0a,0xa9,0x4b,0x8d,0x02,0x02,0xa9,
    0x00,0x8d,0x03,0x02,0x68,0x60,0xe8,0x8a,
    0x06,0xf7,0xd0,0x03,0x20,0x00,0x02,0x90,
    0x12,0xe8,0xe0,0x07,0xd0,0xf2,0xf0,0x0b,
    0xa2,0x07,0xe8,0x06,0xf7,0xd0,0x03,0x20,
    0x00,0x02,0x2a,0xca,0xd0,0xf5,0x18,0x60,
    0x80,0x00,0xff,0x8d,0xaa,0xaa,0xe6,0xfb,
    0xd0,0x02,0xe6,0xfc,0xca,0x60,0xa4,0xf8,
    0xa2,0x02,0x20,0x3d,0x02,0x85,0xf8,0x98,
    0xa2,0x06,0x20,0x3d,0x02,0x20,0xfa,0x00,
    0xa0,0x00,0x98,0xa2,0x02,0x20,0x3d,0x02,
    0xc5,0xf8,0xd0,0xec,0x20,0x1f,0x02,0x85,
    0x2d,0x4a,0xd0,0x3f,0x20,0x33,0x02,0x4a,
    0x90,0x47,0x20,0x33,0x02,0x4a,0x90,0xce,
    0xc8,0x20,0x1f,0x02,0x85,0x2d,0xc9,0x40,
    0x90,0x0b,0xa2,0x02,0x20,0x34,0x02,0x85,
    0x2d,0x20,0x1f,0x02,0xa8,0x20,0x1f,0x02,
    0xaa,0xbd,0xb5,0x01,0xe0,0x20,0x90,0x06,
    0x8a,0xa2,0x03,0x20,0x34,0x02,0xa6,0x2d,
    0xe8,0x20,0xfa,0x00,0xd0,0xfb,0x88,0xd0,
    0xf8,0xf0,0xad,0x20,0x1f,0x02,0xc9,0x7f,
    0xf0,0x2b,0xe9,0x00,0xa2,0x00,0x20,0x3d,
    0x02,0x85,0x2e,0x8c,0x93,0x01,0xa0,0x00,
    0x20,0x31,0x02,0x65,0xfb,0xa6,0x2d,0x85,
    0x2d,0xa5,0xfc,0xe5,0x2e,0x85,0x2e,0xe8,
    0xb1,0x2d,0x18,0x69,0x00,0xc8,0x20,0xfa,
    0x00,0xd0,0xf5,0xf0,0xcc,0xa5,0x2d,0xc9,
    0x02,0xf0,0x08,0x20,0x31,0x02,0xa8,0xa9,
    0x00,0xf0,0xce,0xa5,0xfb,0x85,0x2d,0xa5,
    0xfc,0x85,0x2e,0x58,0x4c,0xaa,0xaa,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00
};

struct FixEntry fixTableVIC20WD[] = {
    {ftOverlap, 0x120f -0x11ff},
    {ftOverlapLo, 0x1211 -0x11ff},
    {ftOverlapHi, 0x1212 -0x11ff},
    {ftIBufferSize, 0x1219 -0x11ff},
    {ftReloc, 0x121c -0x11ff},
    {ftStackSize, 0x1224 -0x11ff},
    {ftReloc, 0x1227 -0x11ff},
    {ftSizePages, 0x122f -0x11ff},
    {ftSizeLo, 0x1232 -0x11ff},
    {ftSizeHi, 0x1233 -0x11ff},
    {ftEndLo, 0x1235 -0x11ff},
    {ftEndHi, 0x1236 -0x11ff},
    {ftReloc, 0x123c -0x11ff},
    {ftReloc, 0x123f -0x11ff},
    {ftDeCall, 0x1243 -0x11ff},
    {ftInposLo, 0x1248 -0x11ff},
    {ftInposHi, 0x1249 -0x11ff},
    {ftMaxGamma, 0x1272 -0x11ff},
    {ftEscValue, 0x1288 -0x11ff},
    {ftWrapCount, 0x1289 -0x11ff},
    {ftOutposLo, 0x128b -0x11ff},
    {ftOutposHi, 0x128c -0x11ff},
    {ftEscBits, 0x1298 -0x11ff},
    {ftEsc8Bits, 0x12a0 -0x11ff},
    {ftEscBits, 0x12ab -0x11ff},
    {ft1MaxGamma, 0x12ce -0x11ff},
    {ft8MaxGamma, 0x12d2 -0x11ff},
    {ft2MaxGamma, 0x12fe -0x11ff},
    {ftExtraBits, 0x1304 -0x11ff},
    {ftOp, 0x1322 -0x11ff},
    {ftCli, 0x1342 -0x11ff},
    {ftExecLo, 0x1344 -0x11ff},
    {ftExecHi, 0x1345 -0x11ff},
    {ftEnd,0}
};

static unsigned char headerC16[] = {
    0x01,0x10,0x0b,0x10,0xef,0x00,0x9e,0x34,
    0x31,0x30,0x39,0x00,0x00,0x00,0x78,0xad,
    0x06,0xff,0x29,0xef,0x8d,0x06,0xff,0x8d,
    0x3f,0xff,0xa2,0x34,0xbd,0x46,0x10,0x9d,
    0xff,0x01,0xca,0xd0,0xf7,0xa2,0xd7,0xbd,
    0x79,0x10,0x9d,0xf6,0x00,0xca,0xd0,0xf7,
    0xa0,0xaa,0xca,0xbd,0xaa,0xaa,0x9d,0x00,
    0xff,0x8a,0xd0,0xf6,0xce,0x37,0x10,0xce,
    0x34,0x10,0x88,0xd0,0xed,0x4c,0x16,0x01,
    0x48,0xad,0xaa,0xaa,0x2a,0x85,0xf7,0xee,
    0x02,0x02,0xd0,0x03,0xee,0x03,0x02,0x68,
    0x60,0xe8,0x8a,0x06,0xf7,0xd0,0x03,0x20,
    0x00,0x02,0x90,0x12,0xe8,0xe0,0x07,0xd0,
    0xf2,0xf0,0x0b,0xa2,0x07,0xe8,0x06,0xf7,
    0xd0,0x03,0x20,0x00,0x02,0x2a,0xca,0xd0,
    0xf5,0x18,0x60,0x80,0x00,0x8d,0xaa,0xaa,
    0xe6,0xfa,0xd0,0x02,0xe6,0xfb,0xca,0x60,
    0xa4,0xf8,0xa2,0x02,0x20,0x2f,0x02,0x85,
    0xf8,0x98,0xa2,0x06,0x20,0x2f,0x02,0x20,
    0xf9,0x00,0xa0,0x00,0x98,0xa2,0x02,0x20,
    0x2f,0x02,0xc5,0xf8,0xd0,0xec,0x20,0x11,
    0x02,0x85,0x2d,0x4a,0xd0,0x3f,0x20,0x25,
    0x02,0x4a,0x90,0x47,0x20,0x25,0x02,0x4a,
    0x90,0xce,0xc8,0x20,0x11,0x02,0x85,0x2d,
    0xc9,0x40,0x90,0x0b,0xa2,0x02,0x20,0x26,
    0x02,0x85,0x2d,0x20,0x11,0x02,0xa8,0x20,
    0x11,0x02,0xaa,0xbd,0xad,0x01,0xe0,0x20,
    0x90,0x06,0x8a,0xa2,0x03,0x20,0x26,0x02,
    0xa6,0x2d,0xe8,0x20,0xf9,0x00,0xd0,0xfb,
    0x88,0xd0,0xf8,0xf0,0xad,0x20,0x11,0x02,
    0xc9,0x7f,0xf0,0x23,0xe9,0x00,0xa2,0x00,
    0x20,0x2f,0x02,0x85,0x2e,0x20,0x23,0x02,
    0x65,0xfa,0xa6,0x2d,0x85,0x2d,0xa5,0xfb,
    0xe5,0x2e,0x85,0x2e,0xe8,0xb1,0x2d,0xc8,
    0x20,0xf9,0x00,0xd0,0xf8,0xf0,0xd4,0xa5,
    0xfa,0x85,0x2d,0xa5,0xfb,0x85,0x2e,0xad,
    0x06,0xff,0x09,0x10,0x8d,0x06,0xff,0x8d,
    0x3e,0xff,0xa9,0x00,0x85,0xf9,0x58,0x4c,
    0xaa,0xaa,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00
};

struct FixEntry fixTableC16[] = {
    {ftFastDisable, 0x1013 -0x0fff},
    {ftIBufferSize, 0x101a -0x0fff},
    {ftReloc, 0x101d -0x0fff},
    {ftStackSize, 0x1025 -0x0fff},
    {ftReloc, 0x1028 -0x0fff},
    {ftSizePages, 0x1030 -0x0fff},
    {ftSizeLo, 0x1033 -0x0fff},
    {ftSizeHi, 0x1034 -0x0fff},
    {ftEndLo, 0x1036 -0x0fff},
    {ftEndHi, 0x1037 -0x0fff},
    {ftReloc, 0x103d -0x0fff},
    {ftReloc, 0x1040 -0x0fff},
    {ftDeCall, 0x1044 -0x0fff},
    {ftInposLo, 0x1049 -0x0fff},
    {ftInposHi, 0x104a -0x0fff},
    {ftMaxGamma, 0x1065 -0x0fff},
    {ftEscValue, 0x107b -0x0fff},
    {ftOutposLo, 0x107d -0x0fff},
    {ftOutposHi, 0x107e -0x0fff},
    {ftEscBits, 0x108a -0x0fff},
    {ftEsc8Bits, 0x1092 -0x0fff},
    {ftEscBits, 0x109d -0x0fff},
    {ft1MaxGamma, 0x10c0 -0x0fff},
    {ft8MaxGamma, 0x10c4 -0x0fff},
    {ft2MaxGamma, 0x10f0 -0x0fff},
    {ftExtraBits, 0x10f6 -0x0fff},
    {ftFastDisable, 0x1123 -0x0fff},
    {ftCli, 0x112d -0x0fff},
    {ftExecLo, 0x112f -0x0fff},
    {ftExecHi, 0x1130 -0x0fff},
    {ftEnd,0}
};

static unsigned char headerC16W[] = {
    0x01,0x10,0x0b,0x10,0xef,0x00,0x9e,0x34,
    0x31,0x30,0x39,0x00,0x00,0x00,0x78,0xad,
    0x06,0xff,0x29,0xef,0x8d,0x06,0xff,0x8d,
    0x3f,0xff,0xa2,0x00,0xbd,0xaa,0xaa,0x95,
    0x4b,0xca,0x10,0xf8,0xa2,0x42,0xbd,0x50,
    0x10,0x9d,0xff,0x01,0xca,0xd0,0xf7,0xa2,
    0xd8,0xbd,0x91,0x10,0x9d,0xf6,0x00,0xca,
    0xd0,0xf7,0xa0,0xaa,0xca,0xbd,0xaa,0xaa,
    0x9d,0x00,0xff,0x8a,0xd0,0xf6,0xce,0x41,
    0x10,0xce,0x3e,0x10,0x88,0xd0,0xed,0x4c,
    0x17,0x01,0x48,0xad,0xaa,0xaa,0x2a,0x85,
    0xf7,0xee,0x02,0x02,0xd0,0x11,0xee,0x03,
    0x02,0xc6,0xf9,0xd0,0x0a,0xa9,0x4b,0x8d,
    0x02,0x02,0xa9,0x00,0x8d,0x03,0x02,0x68,
    0x60,0xe8,0x8a,0x06,0xf7,0xd0,0x03,0x20,
    0x00,0x02,0x90,0x12,0xe8,0xe0,0x07,0xd0,
    0xf2,0xf0,0x0b,0xa2,0x07,0xe8,0x06,0xf7,
    0xd0,0x03,0x20,0x00,0x02,0x2a,0xca,0xd0,
    0xf5,0x18,0x60,0x80,0x00,0xff,0x8d,0xaa,
    0xaa,0xe6,0xfb,0xd0,0x02,0xe6,0xfc,0xca,
    0x60,0xa4,0xf8,0xa2,0x02,0x20,0x3d,0x02,
    0x85,0xf8,0x98,0xa2,0x06,0x20,0x3d,0x02,
    0x20,0xfa,0x00,0xa0,0x00,0x98,0xa2,0x02,
    0x20,0x3d,0x02,0xc5,0xf8,0xd0,0xec,0x20,
    0x1f,0x02,0x85,0x2d,0x4a,0xd0,0x3f,0x20,
    0x33,0x02,0x4a,0x90,0x47,0x20,0x33,0x02,
    0x4a,0x90,0xce,0xc8,0x20,0x1f,0x02,0x85,
    0x2d,0xc9,0x40,0x90,0x0b,0xa2,0x02,0x20,
    0x34,0x02,0x85,0x2d,0x20,0x1f,0x02,0xa8,
    0x20,0x1f,0x02,0xaa,0xbd,0xae,0x01,0xe0,
    0x20,0x90,0x06,0x8a,0xa2,0x03,0x20,0x34,
    0x02,0xa6,0x2d,0xe8,0x20,0xfa,0x00,0xd0,
    0xfb,0x88,0xd0,0xf8,0xf0,0xad,0x20,0x1f,
    0x02,0xc9,0x7f,0xf0,0x23,0xe9,0x00,0xa2,
    0x00,0x20,0x3d,0x02,0x85,0x2e,0x20,0x31,
    0x02,0x65,0xfb,0xa6,0x2d,0x85,0x2d,0xa5,
    0xfc,0xe5,0x2e,0x85,0x2e,0xe8,0xb1,0x2d,
    0xc8,0x20,0xfa,0x00,0xd0,0xf8,0xf0,0xd4,
    0xa5,0xfb,0x85,0x2d,0xa5,0xfc,0x85,0x2e,
    0xad,0x06,0xff,0x09,0x10,0x8d,0x06,0xff,
    0x8d,0x3e,0xff,0xa9,0x00,0x85,0xf9,0x58,
    0x4c,0xaa,0xaa,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00
};

struct FixEntry fixTableC16W[] = {
    {ftFastDisable, 0x1013 -0x0fff},
    {ftOverlap, 0x101a -0x0fff},
    {ftOverlapLo, 0x101c -0x0fff},
    {ftOverlapHi, 0x101d -0x0fff},
    {ftIBufferSize, 0x1024 -0x0fff},
    {ftReloc, 0x1027 -0x0fff},
    {ftStackSize, 0x102f -0x0fff},
    {ftReloc, 0x1032 -0x0fff},
    {ftSizePages, 0x103a -0x0fff},
    {ftSizeLo, 0x103d -0x0fff},
    {ftSizeHi, 0x103e -0x0fff},
    {ftEndLo, 0x1040 -0x0fff},
    {ftEndHi, 0x1041 -0x0fff},
    {ftReloc, 0x1047 -0x0fff},
    {ftReloc, 0x104a -0x0fff},
    {ftDeCall, 0x104e -0x0fff},
    {ftInposLo, 0x1053 -0x0fff},
    {ftInposHi, 0x1054 -0x0fff},
    {ftMaxGamma, 0x107d -0x0fff},
    {ftEscValue, 0x1093 -0x0fff},
    {ftWrapCount, 0x1094 -0x0fff},
    {ftOutposLo, 0x1096 -0x0fff},
    {ftOutposHi, 0x1097 -0x0fff},
    {ftEscBits, 0x10a3 -0x0fff},
    {ftEsc8Bits, 0x10ab -0x0fff},
    {ftEscBits, 0x10b6 -0x0fff},
    {ft1MaxGamma, 0x10d9 -0x0fff},
    {ft8MaxGamma, 0x10dd -0x0fff},
    {ft2MaxGamma, 0x1109 -0x0fff},
    {ftExtraBits, 0x110f -0x0fff},
    {ftFastDisable, 0x113c -0x0fff},
    {ftCli, 0x1146 -0x0fff},
    {ftExecLo, 0x1148 -0x0fff},
    {ftExecHi, 0x1149 -0x0fff},
    {ftEnd,0}
};

static unsigned char headerC16WD[] = {
    0x01,0x10,0x0b,0x10,0xef,0x00,0x9e,0x34,
    0x31,0x30,0x39,0x00,0x00,0x00,0x78,0xad,
    0x06,0xff,0x29,0xef,0x8d,0x06,0xff,0x8d,
    0x3f,0xff,0xa2,0x00,0xbd,0xaa,0xaa,0x95,
    0x4b,0xca,0x10,0xf8,0xa2,0x42,0xbd,0x50,
    0x10,0x9d,0xff,0x01,0xca,0xd0,0xf7,0xa2,
    0xee,0xbd,0x91,0x10,0x9d,0xf6,0x00,0xca,
    0xd0,0xf7,0xa0,0xaa,0xca,0xbd,0xaa,0xaa,
    0x9d,0x00,0xff,0x8a,0xd0,0xf6,0xce,0x41,
    0x10,0xce,0x3e,0x10,0x88,0xd0,0xed,0x4c,
    0x17,0x01,0x48,0xad,0xaa,0xaa,0x2a,0x85,
    0xf7,0xee,0x02,0x02,0xd0,0x11,0xee,0x03,
    0x02,0xc6,0xf9,0xd0,0x0a,0xa9,0x4b,0x8d,
    0x02,0x02,0xa9,0x00,0x8d,0x03,0x02,0x68,
    0x60,0xe8,0x8a,0x06,0xf7,0xd0,0x03,0x20,
    0x00,0x02,0x90,0x12,0xe8,0xe0,0x07,0xd0,
    0xf2,0xf0,0x0b,0xa2,0x07,0xe8,0x06,0xf7,
    0xd0,0x03,0x20,0x00,0x02,0x2a,0xca,0xd0,
    0xf5,0x18,0x60,0x80,0x00,0xff,0x8d,0xaa,
    0xaa,0xe6,0xfb,0xd0,0x02,0xe6,0xfc,0xca,
    0x60,0xa4,0xf8,0xa2,0x02,0x20,0x3d,0x02,
    0x85,0xf8,0x98,0xa2,0x06,0x20,0x3d,0x02,
    0x20,0xfa,0x00,0xa0,0x00,0x98,0xa2,0x02,
    0x20,0x3d,0x02,0xc5,0xf8,0xd0,0xec,0x20,
    0x1f,0x02,0x85,0x2d,0x4a,0xd0,0x3f,0x20,
    0x33,0x02,0x4a,0x90,0x47,0x20,0x33,0x02,
    0x4a,0x90,0xce,0xc8,0x20,0x1f,0x02,0x85,
    0x2d,0xc9,0x40,0x90,0x0b,0xa2,0x02,0x20,
    0x34,0x02,0x85,0x2d,0x20,0x1f,0x02,0xa8,
    0x20,0x1f,0x02,0xaa,0xbd,0xc4,0x01,0xe0,
    0x20,0x90,0x06,0x8a,0xa2,0x03,0x20,0x34,
    0x02,0xa6,0x2d,0xe8,0x20,0xfa,0x00,0xd0,
    0xfb,0x88,0xd0,0xf8,0xf0,0xad,0x20,0x1f,
    0x02,0xc9,0x7f,0xf0,0x2b,0xe9,0x00,0xa2,
    0x00,0x20,0x3d,0x02,0x85,0x2e,0x8c,0x93,
    0x01,0xa0,0x00,0x20,0x31,0x02,0x65,0xfb,
    0xa6,0x2d,0x85,0x2d,0xa5,0xfc,0xe5,0x2e,
    0x85,0x2e,0xe8,0xb1,0x2d,0x18,0x69,0x00,
    0xc8,0x20,0xfa,0x00,0xd0,0xf5,0xf0,0xcc,
    0xa5,0x2d,0xc9,0x02,0xf0,0x08,0x20,0x31,
    0x02,0xa8,0xa9,0x00,0xf0,0xce,0xa5,0xfb,
    0x85,0x2d,0xa5,0xfc,0x85,0x2e,0xad,0x06,
    0xff,0x09,0x10,0x8d,0x06,0xff,0x8d,0x3e,
    0xff,0xa9,0x00,0x85,0xf9,0x58,0x4c,0xaa,
    0xaa,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

struct FixEntry fixTableC16WD[] = {
    {ftFastDisable, 0x1013 -0x0fff},
    {ftOverlap, 0x101a -0x0fff},
    {ftOverlapLo, 0x101c -0x0fff},
    {ftOverlapHi, 0x101d -0x0fff},
    {ftIBufferSize, 0x1024 -0x0fff},
    {ftReloc, 0x1027 -0x0fff},
    {ftStackSize, 0x102f -0x0fff},
    {ftReloc, 0x1032 -0x0fff},
    {ftSizePages, 0x103a -0x0fff},
    {ftSizeLo, 0x103d -0x0fff},
    {ftSizeHi, 0x103e -0x0fff},
    {ftEndLo, 0x1040 -0x0fff},
    {ftEndHi, 0x1041 -0x0fff},
    {ftReloc, 0x1047 -0x0fff},
    {ftReloc, 0x104a -0x0fff},
    {ftDeCall, 0x104e -0x0fff},
    {ftInposLo, 0x1053 -0x0fff},
    {ftInposHi, 0x1054 -0x0fff},
    {ftMaxGamma, 0x107d -0x0fff},
    {ftEscValue, 0x1093 -0x0fff},
    {ftWrapCount, 0x1094 -0x0fff},
    {ftOutposLo, 0x1096 -0x0fff},
    {ftOutposHi, 0x1097 -0x0fff},
    {ftEscBits, 0x10a3 -0x0fff},
    {ftEsc8Bits, 0x10ab -0x0fff},
    {ftEscBits, 0x10b6 -0x0fff},
    {ft1MaxGamma, 0x10d9 -0x0fff},
    {ft8MaxGamma, 0x10dd -0x0fff},
    {ft2MaxGamma, 0x1109 -0x0fff},
    {ftExtraBits, 0x110f -0x0fff},
    {ftOp, 0x112d -0x0fff},
    {ftFastDisable, 0x1152 -0x0fff},
    {ftCli, 0x115c -0x0fff},
    {ftExecLo, 0x115e -0x0fff},
    {ftExecHi, 0x115f -0x0fff},
    {ftEnd,0}
};

static unsigned char headerC128[] = {
    0x01,0x1c,0x0b,0x1c,0xef,0x00,0x9e,0x37,
    0x31,0x38,0x31,0x00,0x00,0x00,0x78,0xa9,
    0x3f,0x8d,0x00,0xff,0xa2,0x34,0xbd,0x40,
    0x1c,0x9d,0xff,0x01,0xca,0xd0,0xf7,0xa2,
    0xcf,0xbd,0x73,0x1c,0x9d,0xf6,0x00,0xca,
    0xd0,0xf7,0xa0,0xaa,0xca,0xbd,0xaa,0xaa,
    0x9d,0x00,0xff,0x8a,0xd0,0xf6,0xce,0x31,
    0x1c,0xce,0x2e,0x1c,0x88,0xd0,0xed,0x4c,
    0x16,0x01,0x48,0xad,0xaa,0xaa,0x2a,0x85,
    0xf7,0xee,0x02,0x02,0xd0,0x03,0xee,0x03,
    0x02,0x68,0x60,0xe8,0x8a,0x06,0xf7,0xd0,
    0x03,0x20,0x00,0x02,0x90,0x12,0xe8,0xe0,
    0x07,0xd0,0xf2,0xf0,0x0b,0xa2,0x07,0xe8,
    0x06,0xf7,0xd0,0x03,0x20,0x00,0x02,0x2a,
    0xca,0xd0,0xf5,0x18,0x60,0x80,0x00,0x8d,
    0xaa,0xaa,0xe6,0xfa,0xd0,0x02,0xe6,0xfb,
    0xca,0x60,0xa4,0xf8,0xa2,0x02,0x20,0x2f,
    0x02,0x85,0xf8,0x98,0xa2,0x06,0x20,0x2f,
    0x02,0x20,0xf9,0x00,0xa0,0x00,0x98,0xa2,
    0x02,0x20,0x2f,0x02,0xc5,0xf8,0xd0,0xec,
    0x20,0x11,0x02,0x85,0xa3,0x4a,0xd0,0x3f,
    0x20,0x25,0x02,0x4a,0x90,0x47,0x20,0x25,
    0x02,0x4a,0x90,0xce,0xc8,0x20,0x11,0x02,
    0x85,0xa3,0xc9,0x40,0x90,0x0b,0xa2,0x02,
    0x20,0x26,0x02,0x85,0xa3,0x20,0x11,0x02,
    0xa8,0x20,0x11,0x02,0xaa,0xbd,0xa5,0x01,
    0xe0,0x20,0x90,0x06,0x8a,0xa2,0x03,0x20,
    0x26,0x02,0xa6,0xa3,0xe8,0x20,0xf9,0x00,
    0xd0,0xfb,0x88,0xd0,0xf8,0xf0,0xad,0x20,
    0x11,0x02,0xc9,0x7f,0xf0,0x23,0xe9,0x00,
    0xa2,0x00,0x20,0x2f,0x02,0x85,0xa4,0x20,
    0x23,0x02,0x65,0xfa,0xa6,0xa3,0x85,0xa3,
    0xa5,0xfb,0xe5,0xa4,0x85,0xa4,0xe8,0xb1,
    0xa3,0xc8,0x20,0xf9,0x00,0xd0,0xf8,0xf0,
    0xd4,0xa9,0x00,0x8d,0x00,0xff,0xa5,0xfa,
    0x8d,0x10,0x12,0xa5,0xfb,0x8d,0x11,0x12,
    0x58,0x4c,0xaa,0xaa,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00
};

struct FixEntry fixTableC128[] = {
    {ftIBufferSize, 0x1c14 -0x1bff},
    {ftReloc, 0x1c17 -0x1bff},
    {ftStackSize, 0x1c1f -0x1bff},
    {ftReloc, 0x1c22 -0x1bff},
    {ftSizePages, 0x1c2a -0x1bff},
    {ftSizeLo, 0x1c2d -0x1bff},
    {ftSizeHi, 0x1c2e -0x1bff},
    {ftEndLo, 0x1c30 -0x1bff},
    {ftEndHi, 0x1c31 -0x1bff},
    {ftReloc, 0x1c37 -0x1bff},
    {ftReloc, 0x1c3a -0x1bff},
    {ftDeCall, 0x1c3e -0x1bff},
    {ftInposLo, 0x1c43 -0x1bff},
    {ftInposHi, 0x1c44 -0x1bff},
    {ftMaxGamma, 0x1c5f -0x1bff},
    {ftEscValue, 0x1c75 -0x1bff},
    {ftOutposLo, 0x1c77 -0x1bff},
    {ftOutposHi, 0x1c78 -0x1bff},
    {ftEscBits, 0x1c84 -0x1bff},
    {ftEsc8Bits, 0x1c8c -0x1bff},
    {ftEscBits, 0x1c97 -0x1bff},
    {ft1MaxGamma, 0x1cba -0x1bff},
    {ft8MaxGamma, 0x1cbe -0x1bff},
    {ft2MaxGamma, 0x1cea -0x1bff},
    {ftExtraBits, 0x1cf0 -0x1bff},
    {ftCli, 0x1d1f -0x1bff},
    {ftExecLo, 0x1d21 -0x1bff},
    {ftExecHi, 0x1d22 -0x1bff},
    {ftEnd,0}
};

static unsigned char headerC128W[] = {
    0x01,0x1c,0x0b,0x1c,0xef,0x00,0x9e,0x37,
    0x31,0x38,0x31,0x00,0x00,0x00,0x78,0xa9,
    0x3f,0x8d,0x00,0xff,0xa2,0x00,0xbd,0xaa,
    0xaa,0x95,0x4b,0xca,0x10,0xf8,0xa2,0x40,
    0xbd,0x4a,0x1c,0x9d,0xff,0x01,0xca,0xd0,
    0xf7,0xa2,0xcf,0xbd,0x89,0x1c,0x9d,0xf6,
    0x00,0xca,0xd0,0xf7,0xa0,0xaa,0xca,0xbd,
    0xaa,0xaa,0x9d,0x00,0xff,0x8a,0xd0,0xf6,
    0xce,0x3b,0x1c,0xce,0x38,0x1c,0x88,0xd0,
    0xed,0x4c,0x16,0x01,0x48,0xad,0xaa,0xaa,
    0x2a,0x85,0xf7,0xee,0x02,0x02,0xd0,0x0f,
    0xee,0x03,0x02,0xd0,0x0a,0xa9,0x4b,0x8d,
    0x02,0x02,0xa9,0x00,0x8d,0x03,0x02,0x68,
    0x60,0xe8,0x8a,0x06,0xf7,0xd0,0x03,0x20,
    0x00,0x02,0x90,0x12,0xe8,0xe0,0x07,0xd0,
    0xf2,0xf0,0x0b,0xa2,0x07,0xe8,0x06,0xf7,
    0xd0,0x03,0x20,0x00,0x02,0x2a,0xca,0xd0,
    0xf5,0x18,0x60,0x80,0x00,0x8d,0xaa,0xaa,
    0xe6,0xfa,0xd0,0x02,0xe6,0xfb,0xca,0x60,
    0xa4,0xf8,0xa2,0x02,0x20,0x3b,0x02,0x85,
    0xf8,0x98,0xa2,0x06,0x20,0x3b,0x02,0x20,
    0xf9,0x00,0xa0,0x00,0x98,0xa2,0x02,0x20,
    0x3b,0x02,0xc5,0xf8,0xd0,0xec,0x20,0x1d,
    0x02,0x85,0xa3,0x4a,0xd0,0x3f,0x20,0x31,
    0x02,0x4a,0x90,0x47,0x20,0x31,0x02,0x4a,
    0x90,0xce,0xc8,0x20,0x1d,0x02,0x85,0xa3,
    0xc9,0x40,0x90,0x0b,0xa2,0x02,0x20,0x32,
    0x02,0x85,0xa3,0x20,0x1d,0x02,0xa8,0x20,
    0x1d,0x02,0xaa,0xbd,0xa5,0x01,0xe0,0x20,
    0x90,0x06,0x8a,0xa2,0x03,0x20,0x32,0x02,
    0xa6,0xa3,0xe8,0x20,0xf9,0x00,0xd0,0xfb,
    0x88,0xd0,0xf8,0xf0,0xad,0x20,0x1d,0x02,
    0xc9,0x7f,0xf0,0x23,0xe9,0x00,0xa2,0x00,
    0x20,0x3b,0x02,0x85,0xa4,0x20,0x2f,0x02,
    0x65,0xfa,0xa6,0xa3,0x85,0xa3,0xa5,0xfb,
    0xe5,0xa4,0x85,0xa4,0xe8,0xb1,0xa3,0xc8,
    0x20,0xf9,0x00,0xd0,0xf8,0xf0,0xd4,0xa9,
    0x00,0x8d,0x00,0xff,0xa5,0xfa,0x8d,0x10,
    0x12,0xa5,0xfb,0x8d,0x11,0x12,0x58,0x4c,
    0xaa,0xaa,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00
};

struct FixEntry fixTableC128W[] = {
    {ftOverlap, 0x1c14 -0x1bff},
    {ftOverlapLo, 0x1c16 -0x1bff},
    {ftOverlapHi, 0x1c17 -0x1bff},
    {ftIBufferSize, 0x1c1e -0x1bff},
    {ftReloc, 0x1c21 -0x1bff},
    {ftStackSize, 0x1c29 -0x1bff},
    {ftReloc, 0x1c2c -0x1bff},
    {ftSizePages, 0x1c34 -0x1bff},
    {ftSizeLo, 0x1c37 -0x1bff},
    {ftSizeHi, 0x1c38 -0x1bff},
    {ftEndLo, 0x1c3a -0x1bff},
    {ftEndHi, 0x1c3b -0x1bff},
    {ftReloc, 0x1c41 -0x1bff},
    {ftReloc, 0x1c44 -0x1bff},
    {ftDeCall, 0x1c48 -0x1bff},
    {ftInposLo, 0x1c4d -0x1bff},
    {ftInposHi, 0x1c4e -0x1bff},
    {ftMaxGamma, 0x1c75 -0x1bff},
    {ftEscValue, 0x1c8b -0x1bff},
    {ftOutposLo, 0x1c8d -0x1bff},
    {ftOutposHi, 0x1c8e -0x1bff},
    {ftEscBits, 0x1c9a -0x1bff},
    {ftEsc8Bits, 0x1ca2 -0x1bff},
    {ftEscBits, 0x1cad -0x1bff},
    {ft1MaxGamma, 0x1cd0 -0x1bff},
    {ft8MaxGamma, 0x1cd4 -0x1bff},
    {ft2MaxGamma, 0x1d00 -0x1bff},
    {ftExtraBits, 0x1d06 -0x1bff},
    {ftCli, 0x1d35 -0x1bff},
    {ftExecLo, 0x1d37 -0x1bff},
    {ftExecHi, 0x1d38 -0x1bff},
    {ftEnd,0}
};

struct FixStruct fixStruct[] = {
    {headerC64S, sizeof(headerC64S), fixTableC64S, "C64 short", FIXF_C64|FIXF_SHORT},
    {headerC64, sizeof(headerC64), fixTableC64, "C64", FIXF_C64},
    {headerC64D, sizeof(headerC64D), fixTableC64D, "C64 delta", FIXF_C64|FIXF_DLZ},
    {headerC64F, sizeof(headerC64F), fixTableC64F, "C64 fast", FIXF_C64|FIXF_FAST},
    {headerC64SW, sizeof(headerC64SW), fixTableC64SW, "C64 short wrap", FIXF_C64|FIXF_SHORT|FIXF_WRAP},
    {headerC64W, sizeof(headerC64W), fixTableC64W, "C64 wrap", FIXF_C64|FIXF_WRAP},
    {headerC64WD, sizeof(headerC64WD), fixTableC64WD, "C64 wrap delta", FIXF_C64|FIXF_WRAP|FIXF_DLZ},
    {headerC64WF, sizeof(headerC64WF), fixTableC64WF, "C64 fast wrap", FIXF_C64|FIXF_WRAP|FIXF_FAST},
    {headerVIC20, sizeof(headerVIC20), fixTableVIC20, "VIC20", FIXF_VIC20},
    {headerVIC20W, sizeof(headerVIC20W), fixTableVIC20W, "VIC20 wrap", FIXF_VIC20|FIXF_WRAP},
    {headerVIC20S, sizeof(headerVIC20S), fixTableVIC20S, "VIC20 short", FIXF_VIC20|FIXF_SHORT},
    {headerVIC20SW, sizeof(headerVIC20SW), fixTableVIC20SW, "VIC20 short wrap", FIXF_VIC20|FIXF_SHORT|FIXF_WRAP},
    {headerVIC20WD, sizeof(headerVIC20WD), fixTableVIC20WD, "VIC20 wrap delta", FIXF_VIC20|FIXF_WRAP|FIXF_DLZ},
    {headerC16, sizeof(headerC16), fixTableC16, "C16/+4", FIXF_C16},
    {headerC16W, sizeof(headerC16W), fixTableC16W, "C16/+4 wrap", FIXF_C16|FIXF_WRAP},
    {headerC16WD, sizeof(headerC16WD), fixTableC16WD, "C16/+4 wrap delta", FIXF_C16|FIXF_WRAP|FIXF_DLZ},
    {headerC128, sizeof(headerC128), fixTableC128, "C128", FIXF_C128},
    {headerC128W, sizeof(headerC128W), fixTableC128W, "C128 wrap", FIXF_C128|FIXF_WRAP},
    {NULL, 0, NULL, NULL, 0}
};
