unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Math, Buttons, ExtCtrls;

type
  t_abs=record
    block_size:byte;
    player_size: word;
    tbl_size: word;
    trk_size: word;
    p_size: word;
    end;
  t_ay_dump = record
    a_tone_low: byte;
    a_tone_hi: byte;
    b_tone_low: byte;
    b_tone_hi: byte;
    c_tone_low: byte;
    c_tone_hi: byte;
    noise: byte;
    control: byte;
    a_volume: byte;
    b_volume: byte;
    c_volume: byte;
    env_per_low: byte;
    env_per_hi: byte;
    env_form: byte;
    end;
  t_tonevol_patt = record
    index: byte;
    volume: byte;
    end;
  t_index_patt = record
    index: byte;
    end;
  t_reg_dump_patt = record
    noise: byte;
    control: byte;
    end;
  t_tonevol = record
  	tone_low: byte;
  	tone_hi: byte;
   	volume: byte;
  	end;
  t_env = record
  	env_low: byte;
  	env_hi: byte;
    form: byte;
  	end;
  t_reg = record
  	noise: byte;
  	control: byte;
  	end;
  TForm1 = class(TForm)
    Button1: TButton;
    OpenDialog1: TOpenDialog;
    Edit_FileAYdump: TEdit;
    Memo1: TMemo;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    Edit_PlayerADR: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Edit_TrackADR: TEdit;
    Label4: TLabel;
    Combo_Compile: TComboBox;
    Label5: TLabel;
    Edit_TablesADR: TEdit;
    Edit_BlockSize: TEdit;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label_FileSize: TLabel;
    Label_FileDumpCount: TLabel;
    Label11: TLabel;
    Label_FileType: TLabel;
    Panel2: TPanel;
    Label12: TLabel;
    Button4: TButton;
    Button5: TButton;
    Label1: TLabel;
    Edit_PattADR: TEdit;
    Edit_PlayerEND: TEdit;
    Edit_TablesEND: TEdit;
    Edit_TrackEND: TEdit;
    Edit_PattEND: TEdit;
    Label7: TLabel;
    Label13: TLabel;
    Label6: TLabel;
    Label14: TLabel;
    Combo_BlockSize: TComboBox;
    Combo_ADRView: TComboBox;
    Label15: TLabel;
    Panel3: TPanel;
    Label16: TLabel;
    Panel1: TPanel;
    procedure Button1Click(Sender: TObject);
    procedure Combo_CompileChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Panel2Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Combo_BlockSizeChange(Sender: TObject);
    procedure Combo_ADRViewChange(Sender: TObject);
    procedure Edit_PlayerADRKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit_TablesADRKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit_TrackADRKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit_PattADRKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Panel3Click(Sender: TObject);
    procedure Panel1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

  AyFlyDLL : THandle;
  dechex_view: byte;
//ay_initsongindirect: procedure (unsigned char *module, unsigned long sr, AY_CHAR *type, unsigned long size, AbstractAudio *player = 0);
  ay_initsongindirect: function (module: Pointer; sr: dword; size:dword; player:Pointer): Pointer;stdcall;
//ay_sethwnd(void *info, HWND hWnd);
  ay_sethwnd: procedure (p: Pointer; xHWND:hWnd);stdcall;
//ay_resetsong(void *info);
  ay_resetsong: procedure (p: Pointer);stdcall;
//unsigned long ay_getsonglength(void *info);
//unsigned long ay_getelapsedtime(void *info);
//unsigned long ay_getsongloop(void *info);
  ay_getsonglength: function (p: Pointer):dword;stdcall;
  ay_getelapsedtime: function (p: Pointer):dword;stdcall;
//const unsigned char *ay_getregs(void *info, unsigned char chip_num = 0);
  ay_getregs: function(p: Pointer; chip:byte):Pointer;stdcall;
//void ay_seeksong(void *info, long new_position);
  ay_seeksong: procedure(p: Pointer; new_position:dword);stdcall;

  Song: array [0..65535] of byte;
  ay_dump: array [0..65535] of t_ay_dump;
  temp_patt_tonevol: array [0..255] of t_tonevol_patt;
  temp_patt_index: array [0..255] of t_index_patt;
  cha_patt: array [0..1023] of array [0..255] of t_tonevol_patt;
  chb_patt: array [0..1023] of array [0..255] of t_tonevol_patt;
  chc_patt: array [0..1023] of array [0..255] of t_tonevol_patt;
  env_patt: array [0..1023] of array [0..255] of t_index_patt;
  reg_patt: array [0..1023] of array [0..255] of t_index_patt;
  cha_patt_count: word;
  chb_patt_count: word;
  chc_patt_count: word;
  env_patt_count: word;
  reg_patt_count: word;
  max_block_size: byte;
  ay_dump_count: word;

  var_tonevol: array [0..16383] of T_ToneVol;
  var_tonevol_count: integer;
  var_env: array [0..16383] of T_Env;
  var_reg: array [0..16383] of T_Reg;  
  var_tonevol_a: array [0..16383] of T_ToneVol;
  var_tonevol_b: array [0..16383] of T_ToneVol;
  var_tonevol_c: array [0..16383] of T_ToneVol;
  var_env_count: word;
  var_reg_count: word;
  var_tonevol_a_count: word;
  var_tonevol_b_count: word;
  var_tonevol_c_count: word;
  var_tonevol_a_type: byte; //0-ToneVol 1-Tone
  var_tonevol_b_type: byte; //0-ToneVol 1-Tone
  var_tonevol_c_type: byte; //0-ToneVol 1-Tone
  channel_a_size: word;
  channel_b_size: word;
  channel_c_size: word;
  channel_e_size: word;
  channel_r_size: word;
  track_a: array [0..4095] of word;
  track_b: array [0..4095] of word;
  track_c: array [0..4095] of word;
  track_e: array [0..4095] of word;
  track_r: array [0..4095] of word;
  track_a_count: word;
  track_b_count: word;
  track_c_count: word;
  track_e_count: word;
  track_r_count: word;
  arr_block_size: array [0..7] of t_abs;
  abs_count: byte;
  FileName_aydump: string;
  ProgDir:string;

procedure Update_compile_adr;
implementation

{$R *.dfm}

//-------------------------------------------- OPEN AY DUMP
procedure TForm1.Button1Click(Sender: TObject);
var F: file of byte;
  fs: dword;
  file_ext: string;
  i: integer;
  MusicHandle: pointer;
  bf: Pointer;
  MusicLen:dword;
begin
if (Form1.OpenDialog1.Execute) then
  begin
  Form1.Edit_FileAYdump.Text:=Form1.OpenDialog1.FileName;
  FileName_aydump:=Form1.OpenDialog1.FileName;
  file_ext:= LowerCase(copy(FileName_aydump,Length(FileName_aydump)-2,3));
  Form1.Caption:=file_ext;
  //--- raw ay-registers dump
  if (file_ext='bin') or (file_ext='raw') then
    begin
    AssignFile (F,Form1.OpenDialog1.FileName);
    Reset (F);
    Label_Filetype.Caption:='raw ay dump';
    Label_FileSize.Caption:=IntToStr(FileSize(F));
    Label_FileDumpCount.Caption:=IntToStr(floor(FileSize(F)/14));
    ay_dump_count:=floor(FileSize(F)/14);
    for i:=0 to ay_dump_count-1 do
      begin
      Read (F,ay_dump[i].a_tone_low);	//0
      Read (F,ay_dump[i].a_tone_hi);	//1
      Read (F,ay_dump[i].b_tone_low);	//2
      Read (F,ay_dump[i].b_tone_hi);  	//3
      Read (F,ay_dump[i].c_tone_low);	//4
      Read (F,ay_dump[i].c_tone_hi);	//5
      Read (F,ay_dump[i].noise);	//6
      Read (F,ay_dump[i].control);	//7
      Read (F,ay_dump[i].a_volume);	//8
      Read (F,ay_dump[i].b_volume);	//9
      Read (F,ay_dump[i].c_volume);	//10
      Read (F,ay_dump[i].env_per_low);	//11
      Read (F,ay_dump[i].env_per_hi);	//12
      Read (F,ay_dump[i].env_form);	//13
      end;
    CloseFile (F);
    end
  else  //--- tracker module or other filetype supported by ayfly.dll
    begin
    AssignFile (F,Form1.OpenDialog1.FileName);
    Reset (F);
    fs:=FileSize(F);
    for i:=0 to fs-1 do Read (F,Song[i]);
    MusicHandle:=ay_initsongindirect(@Song, 44100, fs, 0);
    ay_sethwnd(MusicHandle,Form1.Handle);
    ay_resetsong(MusicHandle);
    MusicLen:=ay_getsonglength(MusicHandle);
    Label_Filetype.Caption:=file_ext;
    Label_FileSize.Caption:=IntToStr(FileSize(F));
    Label_FileDumpCount.Caption:=IntToStr(MusicLen);
    ay_dump_count:=MusicLen;
   for i:=0 to MusicLen-1 do
      begin
      ay_seeksong(MusicHandle,ay_getelapsedtime(MusicHandle)+1);
      bf:=ay_getregs(MusicHandle,0);
      CopyMemory(@ay_dump[i],bf,14); //14
      end;
    end;
  end;
end;

procedure TForm1.Combo_CompileChange(Sender: TObject);
begin
if Combo_Compile.ItemIndex=0 then
  begin
  Edit_TrackADR.Enabled:=false;
  Edit_TablesADR.Enabled:=false;
  Edit_PattADR.Enabled:=false;
  end
else
  begin
  Edit_TrackADR.Enabled:=true;
  Edit_TablesADR.Enabled:=true;
  Edit_PattADR.Enabled:=true;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
ProgDir:=GetCurrentDir;
AyFlyDLL:=LoadLibrary('ayfly.dll');
@ay_initsongindirect:=nil;
@ay_sethwnd:=nil;
@ay_resetsong:=nil;
@ay_getsonglength:=nil;
@ay_getelapsedtime:=nil;
@ay_getregs:=nil;
@ay_seeksong:=nil;
@ay_initsongindirect:=GetProcAddress(AyFlyDLL,'ay_initsongindirect');
@ay_sethwnd:=GetProcAddress(AyFlyDLL,'ay_sethwnd');
@ay_resetsong:=GetProcAddress(AyFlyDLL,'ay_resetsong');
@ay_getsonglength:=GetProcAddress(AyFlyDLL,'ay_getsonglength');
@ay_getelapsedtime:=GetProcAddress(AyFlyDLL,'ay_getelapsedtime');
@ay_getregs:=GetProcAddress(AyFlyDLL,'ay_getregs');
@ay_seeksong:=GetProcAddress(AyFlyDLL,'ay_seeksong');
//if (@ay_initsongindirect<>nil) then form1.Caption:='dll load ok';
end;

procedure TForm1.Panel2Click(Sender: TObject);
begin
ShowMessage ('       (2..256)'+#13#10+
              '(      )'+#13#10+#13#10+
              '        = 32,'+#13#10+
              ' = 4,     32*4 = 128,'+#13#10+
              '       = 16,'+#13#10+
              ' = 3,     16*3 = 48  ..'+#13#10+#13#10+
              '     , '+#13#10+
              '       , '+#13#10+
              '     :'+#13#10+
              '     2-3-2-3...,'+#13#10+
              '   64  32*2+32*3=160'+#13#10+#13#10+
              '     :'+#13#10+
              '   ,  ,   ..'+#13#10+
              '        ');
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
FreeLibrary (AyFlyDLL);
end;
//-----------------------------------------------------------
//---   
Procedure calc_var_tonevol_a;
var i,j:integer; flag: boolean;
begin
var_tonevol_a_count:=0;
var_tonevol_a_type:=0;
zeromemory (@var_tonevol_a,sizeof(var_tonevol_a));
for i:=0 to ay_dump_count-1 do
  begin
  j:=0; flag:=false;
  While ( (j<var_tonevol_a_count) and (flag=false) ) do
    begin
    if(
      (var_tonevol_a[j].tone_low=ay_dump[i].a_tone_low) and
      (var_tonevol_a[j].tone_hi=ay_dump[i].a_tone_hi) and
      (var_tonevol_a[j].volume=ay_dump[i].a_volume)
      ) then flag:=true;
    inc (j);
    end;
  if not(flag) then
    begin
    var_tonevol_a[var_tonevol_a_count].tone_low:=ay_dump[i].a_tone_low;
    var_tonevol_a[var_tonevol_a_count].tone_hi:=ay_dump[i].a_tone_hi;
    var_tonevol_a[var_tonevol_a_count].volume:=ay_dump[i].a_volume;
    inc (var_tonevol_a_count);
    end;
  end;
end;
//---------------------------
Procedure calc_var_tonevol_b;
var i,j:integer; flag: boolean;
begin
var_tonevol_b_count:=0;
var_tonevol_b_type:=0;
zeromemory (@var_tonevol_b,sizeof(var_tonevol_b));
for i:=0 to ay_dump_count-1 do
  begin
  j:=0; flag:=false;
  While ( (j<var_tonevol_b_count) and (flag=false) ) do
    begin
    if(
      (var_tonevol_b[j].tone_low=ay_dump[i].b_tone_low) and
      (var_tonevol_b[j].tone_hi=ay_dump[i].b_tone_hi) and
      (var_tonevol_b[j].volume=ay_dump[i].b_volume)
      ) then flag:=true;
    inc (j);
    end;
  if not(flag) then
    begin
    var_tonevol_b[var_tonevol_b_count].tone_low:=ay_dump[i].b_tone_low;
    var_tonevol_b[var_tonevol_b_count].tone_hi:=ay_dump[i].b_tone_hi;
    var_tonevol_b[var_tonevol_b_count].volume:=ay_dump[i].b_volume;
    inc (var_tonevol_b_count);
    end;
  end;
end;
//---------------------------
Procedure calc_var_tonevol_c;
var i,j:integer; flag: boolean;
begin
var_tonevol_c_count:=0;
var_tonevol_c_type:=0;
zeromemory (@var_tonevol_c,sizeof(var_tonevol_c));
for i:=0 to ay_dump_count-1 do
  begin
  j:=0; flag:=false;
  While ( (j<var_tonevol_c_count) and (flag=false) ) do
    begin
    if(
      (var_tonevol_c[j].tone_low=ay_dump[i].c_tone_low) and
      (var_tonevol_c[j].tone_hi=ay_dump[i].c_tone_hi) and
      (var_tonevol_c[j].volume=ay_dump[i].c_volume)
      ) then flag:=true;
    inc (j);
    end;
  if not(flag) then
    begin
    var_tonevol_c[var_tonevol_c_count].tone_low:=ay_dump[i].c_tone_low;
    var_tonevol_c[var_tonevol_c_count].tone_hi:=ay_dump[i].c_tone_hi;
    var_tonevol_c[var_tonevol_c_count].volume:=ay_dump[i].c_volume;
    inc (var_tonevol_c_count);
    end;
  end;
end;
//-----------------------------
Procedure calc_var_tone_a;
var i,j:integer; flag: boolean;
begin
var_tonevol_a_count:=0;
var_tonevol_a_type:=1;
zeromemory (@var_tonevol_a,sizeof(var_tonevol_a));
for i:=0 to ay_dump_count-1 do
  begin
  j:=0; flag:=false;
  While ( (j<var_tonevol_a_count) and (flag=false) ) do
    begin
    if(
      (var_tonevol_a[j].tone_low=ay_dump[i].a_tone_low) and
      (var_tonevol_a[j].tone_hi=ay_dump[i].a_tone_hi)
      ) then flag:=true;
    inc (j);
    end;
  if not(flag) then
    begin
    var_tonevol_a[var_tonevol_a_count].tone_low:=ay_dump[i].a_tone_low;
    var_tonevol_a[var_tonevol_a_count].tone_hi:=ay_dump[i].a_tone_hi;
    var_tonevol_a[var_tonevol_a_count].volume:=0;
    inc (var_tonevol_a_count);
    end;
  end;
end;
//---------------------------
Procedure calc_var_tone_b;
var i,j:integer; flag: boolean;
begin
var_tonevol_b_count:=0;
var_tonevol_b_type:=1;
zeromemory (@var_tonevol_b,sizeof(var_tonevol_b));
for i:=0 to ay_dump_count-1 do
  begin
  j:=0; flag:=false;
  While ( (j<var_tonevol_b_count) and (flag=false) ) do
    begin
    if(
      (var_tonevol_b[j].tone_low=ay_dump[i].b_tone_low) and
      (var_tonevol_b[j].tone_hi=ay_dump[i].b_tone_hi)
      ) then flag:=true;
    inc (j);
    end;
  if not(flag) then
    begin
    var_tonevol_b[var_tonevol_b_count].tone_low:=ay_dump[i].b_tone_low;
    var_tonevol_b[var_tonevol_b_count].tone_hi:=ay_dump[i].b_tone_hi;
    var_tonevol_b[var_tonevol_b_count].volume:=0;
    inc (var_tonevol_b_count);
    end;
  end;
end;
//---------------------------
Procedure calc_var_tone_c;
var i,j:integer; flag: boolean;
begin
var_tonevol_c_count:=0;
var_tonevol_c_type:=1;
zeromemory (@var_tonevol_c,sizeof(var_tonevol_c));
for i:=0 to ay_dump_count-1 do
  begin
  j:=0; flag:=false;
  While ( (j<var_tonevol_c_count) and (flag=false) ) do
    begin
    if(
      (var_tonevol_c[j].tone_low=ay_dump[i].c_tone_low) and
      (var_tonevol_c[j].tone_hi=ay_dump[i].c_tone_hi)
      ) then flag:=true;
    inc (j);
    end;
  if not(flag) then
    begin
    var_tonevol_c[var_tonevol_c_count].tone_low:=ay_dump[i].c_tone_low;
    var_tonevol_c[var_tonevol_c_count].tone_hi:=ay_dump[i].c_tone_hi;
    var_tonevol_c[var_tonevol_c_count].volume:=0;
    inc (var_tonevol_c_count);
    end;
  end;
end;
//------------------
Procedure calc_var_env;
var i,j:integer; flag: boolean;
begin
var_env_count:=0;
zeromemory (@var_env,sizeof(var_env));
for i:=0 to ay_dump_count-1 do
  begin
  j:=0; flag:=false;
  While ( (j<var_env_count) and (flag=false) ) do
    begin
    if(
      (var_env[j].env_low=ay_dump[i].env_per_low) and
      (var_env[j].env_hi=ay_dump[i].env_per_hi) and
      (var_env[j].form=ay_dump[i].env_form)
      ) then flag:=true;
    inc (j);
    end;
  if not(flag) then
    begin
    var_env[var_env_count].env_low:=ay_dump[i].env_per_low;
    var_env[var_env_count].env_hi:=ay_dump[i].env_per_hi;
    var_env[var_env_count].form:=ay_dump[i].env_form;
    inc (var_env_count);
    end;
  end;
end;
//------------------
Procedure calc_var_reg;
var i,j:integer; flag: boolean;
begin
var_reg_count:=0;
zeromemory (@var_reg,sizeof(var_reg));
for i:=0 to ay_dump_count-1 do
  begin
  j:=0; flag:=false;
  While ( (j<var_reg_count) and (flag=false) ) do
    begin
    if(
      (var_reg[j].noise=ay_dump[i].noise) and
      (var_reg[j].control=ay_dump[i].control)
      ) then flag:=true;
    inc (j);
    end;
  if not(flag) then
    begin
    var_reg[var_reg_count].noise:=ay_dump[i].noise;
    var_reg[var_reg_count].control:=ay_dump[i].control;
    inc (var_reg_count);
    end;
  end;
end;
//-------------------------
procedure create_temp_patt_a(n,pattsize:integer);
var i: integer;
  j,index: byte;
begin
for i:=0 to pattsize-1 do
  begin
  //---  
  index:=255;
  for j:=0 to var_tonevol_a_count-1 do
    begin
    if (var_tonevol_a_type=0) then
      begin
      if( // tonevol
        (var_tonevol_a[j].tone_low=ay_dump[pattsize*n+i].a_tone_low) and
        (var_tonevol_a[j].tone_hi=ay_dump[pattsize*n+i].a_tone_hi) and
        (var_tonevol_a[j].volume=ay_dump[pattsize*n+i].a_volume)
        ) then index:=j;
      end;
    if (var_tonevol_a_type=1) then
      begin
      if( // tone
        (var_tonevol_a[j].tone_low=ay_dump[pattsize*n+i].a_tone_low) and
        (var_tonevol_a[j].tone_hi=ay_dump[pattsize*n+i].a_tone_hi)
        ) then index:=j;
      end;
    end; // 
  //---  
  temp_patt_tonevol[i].index:=index;
  temp_patt_tonevol[i].volume:=ay_dump[pattsize*n+i].a_volume;
  end;
end;
//-------------------------------------
procedure create_temp_patt_b(n,pattsize:integer);
var i: integer;
  j,index: byte;
begin
for i:=0 to pattsize-1 do
  begin
  //---  
  index:=255;
  for j:=0 to var_tonevol_b_count-1 do
    begin
    if (var_tonevol_b_type=0) then
      begin
      if( // tonevol
        (var_tonevol_b[j].tone_low=ay_dump[pattsize*n+i].b_tone_low) and
        (var_tonevol_b[j].tone_hi=ay_dump[pattsize*n+i].b_tone_hi) and
        (var_tonevol_b[j].volume=ay_dump[pattsize*n+i].b_volume)
        ) then index:=j;
      end;
    if (var_tonevol_b_type=1) then
      begin
      if( // tone
        (var_tonevol_b[j].tone_low=ay_dump[pattsize*n+i].b_tone_low) and
        (var_tonevol_b[j].tone_hi=ay_dump[pattsize*n+i].b_tone_hi)
        ) then index:=j;
      end;
    end; // 
  //---  
  temp_patt_tonevol[i].index:=index;
  temp_patt_tonevol[i].volume:=ay_dump[pattsize*n+i].b_volume;
  end;
end;
//-------------------------------------
procedure create_temp_patt_c(n,pattsize:integer);
var i: integer;
  j,index: byte;
begin
for i:=0 to pattsize-1 do
  begin
  //---  
  index:=255;
  for j:=0 to var_tonevol_c_count-1 do
    begin
    if (var_tonevol_c_type=0) then
      begin
      if( // tonevol
        (var_tonevol_c[j].tone_low=ay_dump[pattsize*n+i].c_tone_low) and
        (var_tonevol_c[j].tone_hi=ay_dump[pattsize*n+i].c_tone_hi) and
        (var_tonevol_c[j].volume=ay_dump[pattsize*n+i].c_volume)
        ) then index:=j;
      end;
    if (var_tonevol_c_type=1) then
      begin
      if( // tone
        (var_tonevol_c[j].tone_low=ay_dump[pattsize*n+i].c_tone_low) and
        (var_tonevol_c[j].tone_hi=ay_dump[pattsize*n+i].c_tone_hi)
        ) then index:=j;
      end;
    end; // 
  //---  
  temp_patt_tonevol[i].index:=index;
  temp_patt_tonevol[i].volume:=ay_dump[pattsize*n+i].c_volume;
  end;
end;
//---------------------------------------
procedure create_temp_patt_env(n,pattsize:integer);
var i: integer; j,index: byte;
begin
for i:=0 to pattsize-1 do
  begin
  //---  
  index:=255;
  for j:=0 to var_env_count-1 do
    begin
    if( // env
      (var_env[j].env_low=ay_dump[pattsize*n+i].env_per_low) and
      (var_env[j].env_hi=ay_dump[pattsize*n+i].env_per_hi) and
      (var_env[j].form=ay_dump[pattsize*n+i].env_form)
      ) then index:=j;
    end; // 
  //---  
  temp_patt_index[i].index:=index;
  end;
end;
//---------------------------------------
procedure create_temp_patt_reg(n,pattsize:integer);
var i: integer;
  j,index: byte;
begin
for i:=0 to pattsize-1 do
  begin
  //---  
  index:=255;
  for j:=0 to var_reg_count-1 do
    begin
    if( // env
      (var_reg[j].noise=ay_dump[pattsize*n+i].noise) and
      (var_reg[j].control=ay_dump[pattsize*n+i].control)
      ) then index:=j;
    end; // 
  //---  
  temp_patt_index[i].index:=index;
  end;
end;
//---------------------------------------
Procedure calc_patterns_a(pattsize:byte);
var dump_patt_count: word;
  i,j,k: integer;
  flag: boolean;
begin
dump_patt_count:=floor(ay_dump_count/pattsize);
track_a_count:=0;
cha_patt_count:=0;
zeromemory (@cha_patt,sizeof(cha_patt));
for i:=0 to dump_patt_count-1 do
  begin
  //---   
  create_temp_patt_a(i,pattsize);
  //---      
  j:=0; flag:=false;
  while ((j<cha_patt_count) and (flag=false)) do
    begin
    flag:=true;
    for k:=0 to pattsize-1 do //    
      begin
      if (var_tonevol_a_type=0) then
        begin
        if(cha_patt[j][k].index<>temp_patt_tonevol[k].index) then flag:=false;
        end;
      if (var_tonevol_a_type=1) then
        begin
        if((cha_patt[j][k].index<>temp_patt_tonevol[k].index) or (cha_patt[j][k].volume<>temp_patt_tonevol[k].volume)) then flag:=false;
        end;
      end; //    
    inc(j);
    end;
  //---   
  if (flag) then
    begin // (j-1)= 
    end
  else
    begin //
    for k:=0 to pattsize-1 do
      begin
      cha_patt[cha_patt_count][k].index:=temp_patt_tonevol[k].index;
      cha_patt[cha_patt_count][k].volume:=temp_patt_tonevol[k].volume;
      end;
    inc (cha_patt_count); j:=cha_patt_count;
    end;
  // 
  if (var_tonevol_a_type=0) then track_a[track_a_count]:=(j-1)*pattsize
    else  track_a[track_a_count]:=2*(j-1)*pattsize;
  inc(track_a_count);
  end;
//  
channel_a_size:=cha_patt_count*pattsize;
if (var_tonevol_a_type=1) then channel_a_size:=channel_a_size*2;
end;
//---------------------------------------
Procedure calc_patterns_b(pattsize:byte);
var dump_patt_count: word;
  i,j,k: integer;
  flag: boolean;
begin
dump_patt_count:=floor(ay_dump_count/pattsize);
track_b_count:=0;
chb_patt_count:=0;
zeromemory (@chb_patt,sizeof(chb_patt));
for i:=0 to dump_patt_count-1 do
  begin
  //---   
  create_temp_patt_b(i,pattsize);
  //---      
  j:=0; flag:=false;
  while ((j<chb_patt_count) and (flag=false)) do
    begin
    flag:=true;
    for k:=0 to pattsize-1 do //    
      begin
      if (var_tonevol_b_type=0) then
        begin
        if(chb_patt[j][k].index<>temp_patt_tonevol[k].index) then flag:=false;
        end;
      if (var_tonevol_b_type=1) then
        begin
        if((chb_patt[j][k].index<>temp_patt_tonevol[k].index) or (chb_patt[j][k].volume<>temp_patt_tonevol[k].volume)) then flag:=false;
        end;
      end; //    
    inc(j);
    end;
  //---   
  if (flag) then
    begin // (j-1)= 
    end
  else
    begin //
    for k:=0 to pattsize-1 do
      begin
      chb_patt[chb_patt_count][k].index:=temp_patt_tonevol[k].index;
      chb_patt[chb_patt_count][k].volume:=temp_patt_tonevol[k].volume;
      end;
    inc (chb_patt_count); j:=chb_patt_count;
    end;
  // 
  if (var_tonevol_b_type=0) then track_b[track_b_count]:=(j-1)*pattsize
    else  track_b[track_b_count]:=2*(j-1)*pattsize;
  inc(track_b_count);
  end;
//  
channel_b_size:=chb_patt_count*pattsize;
if (var_tonevol_b_type=1) then channel_b_size:=channel_b_size*2;
end;
//---------------------------------------
Procedure calc_patterns_c(pattsize:byte);
var dump_patt_count: word;
  i,j,k: integer;
  flag: boolean;
begin
dump_patt_count:=floor(ay_dump_count/pattsize);
track_c_count:=0;
chc_patt_count:=0;
zeromemory (@chc_patt,sizeof(chc_patt));
for i:=0 to dump_patt_count-1 do
  begin
  //---   
  create_temp_patt_c(i,pattsize);
  //---      
  j:=0; flag:=false;
  while ((j<chc_patt_count) and (flag=false)) do
    begin
    flag:=true;
    for k:=0 to pattsize-1 do //    
      begin
      if (var_tonevol_c_type=0) then
        begin
        if(chc_patt[j][k].index<>temp_patt_tonevol[k].index) then flag:=false;
        end;
      if (var_tonevol_c_type=1) then
        begin
        if((chc_patt[j][k].index<>temp_patt_tonevol[k].index) or (chc_patt[j][k].volume<>temp_patt_tonevol[k].volume)) then flag:=false;
        end;
      end; //    
    inc(j);
    end;
  //---   
  if (flag) then
    begin // (j-1)= 
    end
  else
    begin //
    for k:=0 to pattsize-1 do
      begin
      chc_patt[chc_patt_count][k].index:=temp_patt_tonevol[k].index;
      chc_patt[chc_patt_count][k].volume:=temp_patt_tonevol[k].volume;
      end;
    inc (chc_patt_count); j:=chc_patt_count;
    end;
  // 
  if (var_tonevol_c_type=0) then track_c[track_c_count]:=(j-1)*pattsize
    else  track_c[track_c_count]:=2*(j-1)*pattsize;
  inc(track_c_count);
  end;
//  
channel_c_size:=chc_patt_count*pattsize;
if (var_tonevol_c_type=1) then channel_c_size:=channel_c_size*2;
end;
//---------------------------------------
Procedure calc_patterns_env(pattsize:byte);
var dump_patt_count: word;
  i,j,k: integer;
  flag: boolean;
begin
dump_patt_count:=floor(ay_dump_count/pattsize);
track_e_count:=0;
env_patt_count:=0;
zeromemory (@env_patt,sizeof(env_patt));
for i:=0 to dump_patt_count-1 do
  begin
  //---   
  create_temp_patt_env(i,pattsize);
  //---      
  j:=0; flag:=false;
  while ((j<env_patt_count) and (flag=false)) do
    begin
    flag:=true;
    for k:=0 to pattsize-1 do //    
      begin
        if(env_patt[j][k].index<>temp_patt_index[k].index) then flag:=false;
      end; //    
    inc(j);
    end;
  //---   
  if (flag) then
    begin // (j-1)= 
    end
  else
    begin //
    for k:=0 to pattsize-1 do env_patt[env_patt_count][k].index:=temp_patt_index[k].index;
    inc (env_patt_count); j:=env_patt_count;
    end;
  // 
  track_e[track_e_count]:=(j-1)*pattsize;
  inc(track_e_count);
  end;
//  
channel_e_size:=env_patt_count*pattsize;
end;
//---------------------------------------
Procedure calc_patterns_reg(pattsize:byte);
var dump_patt_count: word;
  i,j,k: integer;
  flag: boolean;
begin
dump_patt_count:=floor(ay_dump_count/pattsize);
track_r_count:=0;
reg_patt_count:=0;
zeromemory (@reg_patt,sizeof(reg_patt));
for i:=0 to dump_patt_count-1 do
  begin
  //---   
  create_temp_patt_reg(i,pattsize);
  //---      
  j:=0; flag:=false;
  while ((j<reg_patt_count) and (flag=false)) do
    begin
    flag:=true;
    for k:=0 to pattsize-1 do //    
      begin
        if(reg_patt[j][k].index<>temp_patt_index[k].index) then flag:=false;
      end; //    
    inc(j);
    end;
  //---   
  if (flag) then
    begin // (j-1)= 
    end
  else
    begin //
    for k:=0 to pattsize-1 do reg_patt[reg_patt_count][k].index:=temp_patt_index[k].index;
    inc (reg_patt_count); j:=reg_patt_count;
    end;
  // 
  track_r[track_r_count]:=(j-1)*pattsize;
  inc(track_r_count);
  end;
//  
channel_r_size:=reg_patt_count*pattsize;
end;

function HexToDec(s:string):integer;
const hexdata:string='0123456789ABCDEF';
var i,j:word; mult, val:integer;
begin
mult:=1; val:=0;
for i:=Length(s) downto 1 do
  begin
  j:=Pos(copy(s,i,1),hexdata);
  val:=val+mult*(j-1);
  mult:=mult*16;
  end;
HexToDec:=val;
end;
function GetDecimal(s:string): dword;
begin
if (Form1.Combo_ADRView.ItemIndex=0) then
  begin //decimal
  GetDecimal:=StrToInt(s);
  end
else
  begin //hex
  GetDecimal:=HexToDec(s);
  end;
end;

procedure TForm1.Button4Click(Sender: TObject);
var
  temp_block_size: integer;
  tbl_size,trk_size,p_size: word;
begin
//--------------------------------------------------
// 1. -      
//--------------------------------------------------
max_block_size:=StrToInt(Form1.Edit_BlockSize.Text);
Form1.Memo1.Lines.Add ('-------------------- Step 1. -------------------- Calc variants');
//--- Calc variants Channel_A
Form1.Memo1.Lines.Add (''); Form1.Memo1.Lines.Add('Calculating variants for Channel_A:');
calc_var_tonevol_a; Form1.Memo1.Lines.Add (' - count: '+IntToStr(var_tonevol_a_count));
if (var_tonevol_a_count>256) then
  begin
  calc_var_tone_a; Form1.Memo1.Lines.Add ('   - out of range. use tone table, variants count: '+IntToStr(var_tonevol_a_count));
  end
else Form1.Memo1.Lines.Add ('   use tonevol table');

//--- Calc variants Channel_B
Form1.Memo1.Lines.Add (''); Form1.Memo1.Lines.Add('Calculating variants for Channel_B:');
calc_var_tonevol_b; Form1.Memo1.Lines.Add (' - count: '+IntToStr(var_tonevol_b_count));
if (var_tonevol_b_count>256) then
  begin
  calc_var_tone_b; Form1.Memo1.Lines.Add ('   - out of range. use tone table, variants count: '+IntToStr(var_tonevol_b_count));
  end
else Form1.Memo1.Lines.Add ('   use tonevol table');

//--- Calc variants Channel_C
Form1.Memo1.Lines.Add (''); Form1.Memo1.Lines.Add('Calculating variants for Channel_C:');
calc_var_tonevol_c; Form1.Memo1.Lines.Add (' - count: '+IntToStr(var_tonevol_c_count));
if (var_tonevol_c_count>256) then
  begin
  calc_var_tone_c; Form1.Memo1.Lines.Add ('   - out of range. use tone table, variants count: '+IntToStr(var_tonevol_c_count));
  end
else Form1.Memo1.Lines.Add ('   use tonevol table');

//--- Calc variants Channel_Env
Form1.Memo1.Lines.Add (''); Form1.Memo1.Lines.Add('Calculating variants for Channel_Env:');
calc_var_env; Form1.Memo1.Lines.Add (' - count: '+IntToStr(var_env_count));

//--- Calc variants Channel_Reg
Form1.Memo1.Lines.Add (''); Form1.Memo1.Lines.Add('Calculating variants for Channel_Reg:');
calc_var_reg; Form1.Memo1.Lines.Add (' - count: '+IntToStr(var_reg_count));

//---  <=256

if(
  (var_tonevol_a_count>256) or
  (var_tonevol_b_count>256) or
  (var_tonevol_c_count>256) or
  (var_reg_count>256) or
  (var_env_count>256)
  ) then
    begin
    Form1.Memo1.Lines.Add(''); Form1.Memo1.Lines.Add('ERROR: variants overflow, compilation is not possible!');
    end
  else
    begin
//--------------------------------------------------
// 2. -      
//--------------------------------------------------
Form1.Memo1.Lines.Add(''); Form1.Memo1.Lines.Add ('-------------------- Step 2. -------------------- Calc patterns');
temp_block_size:=max_block_size*2;
abs_count:=0;
Combo_BlockSize.Items.Clear;
While (temp_block_size=2*floor(temp_block_size/2)) do
  begin
  temp_block_size:=floor(temp_block_size/2);
  Form1.Memo1.Lines.Add(''); Form1.Memo1.Lines.Add('Compile with block-size: '+IntToStr(temp_block_size)+', track_count: '+IntToStr(floor(ay_dump_count/temp_block_size)));
  calc_patterns_a(temp_block_size);
  Memo1.Lines.Add('   - patterns_A: '+IntToStr(cha_patt_count) +' of max '+IntToStr(floor(ay_dump_count/temp_block_size))+'  size: '+IntToStr(channel_a_size)+', track size: '+IntToStr(track_a_count*2)+ ', total byte size: '+IntToStr(channel_a_size+track_a_count*2));
  calc_patterns_b(temp_block_size);
  Memo1.Lines.Add('   - patterns_B: '+IntToStr(chb_patt_count) +' of max '+IntToStr(floor(ay_dump_count/temp_block_size))+'  size: '+IntToStr(channel_b_size)+', track size: '+IntToStr(track_b_count*2)+ ', total byte size: '+IntToStr(channel_b_size+track_b_count*2));
  calc_patterns_c(temp_block_size);
  Memo1.Lines.Add('   - patterns_C: '+IntToStr(chc_patt_count) +' of max '+IntToStr(floor(ay_dump_count/temp_block_size))+'  size: '+IntToStr(channel_c_size)+', track size: '+IntToStr(track_c_count*2)+ ', total byte size: '+IntToStr(channel_c_size+track_c_count*2));
  calc_patterns_env(temp_block_size);
  Memo1.Lines.Add('   - patterns_E: '+IntToStr(env_patt_count) +' of max '+IntToStr(floor(ay_dump_count/temp_block_size))+'  size: '+IntToStr(channel_e_size)+', track size: '+IntToStr(track_e_count*2)+ ', total byte size: '+IntToStr(channel_e_size+track_e_count*2));
  calc_patterns_reg(temp_block_size);
  Memo1.Lines.Add('   - patterns_R: '+IntToStr(reg_patt_count) +' of max '+IntToStr(floor(ay_dump_count/temp_block_size))+'  size: '+IntToStr(channel_r_size)+', track size: '+IntToStr(track_r_count*2)+ ', total byte size: '+IntToStr(channel_r_size+track_r_count*2));
  tbl_size:=768+512+768*3-(256*(var_tonevol_a_type+var_tonevol_b_type+var_tonevol_c_type));
  trk_size:=5*track_a_count*2;
  p_size:=channel_a_size+channel_b_size+channel_c_size+channel_e_size+channel_r_size;
  Memo1.Lines.Add('   - Total size track: '+IntToStr(trk_size)+', table:'+IntToStr(tbl_size)+', patterns: '+IntToStr(p_size));
  Memo1.Lines.Add('   ----- ALL SIZE: '+IntToStr(trk_size+p_size+tbl_size));
  Combo_BlockSize.Items.Add(IntToStr(temp_block_size));
  arr_block_size[abs_count].block_size:=temp_block_size;
  arr_block_size[abs_count].player_size:=512;
  arr_block_size[abs_count].tbl_size:=tbl_size;
  arr_block_size[abs_count].trk_size:=trk_size;
  arr_block_size[abs_count].p_size:=p_size;
  inc (abs_count);
  end;
Combo_BlockSize.ItemIndex:=0;
Update_compile_adr;
    end;
end;

procedure TForm1.Button5Click(Sender: TObject);
var ADR:word;
  F: file of byte; FT: textfile;
  xlow,xhi:byte;
  temp_block_size: byte;
  tbl_size,trk_size,p_size: word;
  i,j: integer;
  ADR_PLAYER,ADR_TBL,ADR_TRK,ADR_PATT: word;
  s: string;
begin
temp_block_size:=arr_block_size[Form1.Combo_BlockSize.ItemIndex].block_size;
calc_patterns_a(temp_block_size);
calc_patterns_b(temp_block_size);
calc_patterns_c(temp_block_size);
calc_patterns_env(temp_block_size);
calc_patterns_reg(temp_block_size);
Memo1.Lines.Add('');Memo1.Lines.Add('------ Selected block size: '+IntToStr(temp_block_size));
tbl_size:=768+512+768*3-(256*(var_tonevol_a_type+var_tonevol_b_type+var_tonevol_c_type));
trk_size:=5*track_a_count*2;
p_size:=channel_a_size+channel_b_size+channel_c_size+channel_e_size+channel_r_size;
Memo1.Lines.Add('   - Total size track: '+IntToStr(trk_size)+', table:'+IntToStr(tbl_size)+', patterns: '+IntToStr(p_size));
Memo1.Lines.Add('   ----- ALL SIZE (with player): '+IntToStr(trk_size+p_size+tbl_size));
//-------------------------
ADR_PLAYER:=GetDecimal(Form1.Edit_PlayerADR.Text);
ADR_TBL:=GetDecimal(Form1.Edit_TablesADR.Text);
ADR_TRK:=GetDecimal(Form1.Edit_TrackADR.Text);
ADR_PATT:=GetDecimal(Form1.Edit_PattADR.Text);
//-------------------------
Memo1.Lines.Add(' ');Memo1.Lines.Add('Saving tables...');
  AssignFile (F,ProgDir+'\TABLES.BIN');
  ReWrite (F);
  for i:=0 to 255 do Write (F,var_tonevol_a[i].tone_low);
  for i:=0 to 255 do Write (F,var_tonevol_a[i].tone_hi);
  if VAR_ToneVol_A_type=0 then for i:=0 to 255 do Write (F,var_tonevol_a[i].volume);
  for i:=0 to 255 do Write (F,var_tonevol_B[i].tone_low);
  for i:=0 to 255 do Write (F,var_tonevol_B[i].tone_hi);
  if VAR_ToneVol_B_type=0 then for i:=0 to 255 do Write (F,var_tonevol_b[i].volume);
  for i:=0 to 255 do Write (F,var_tonevol_C[i].tone_low);
  for i:=0 to 255 do Write (F,var_tonevol_C[i].tone_hi);
  if VAR_ToneVol_C_type=0 then for i:=0 to 255 do Write (F,var_tonevol_c[i].volume);
  for i:=0 to 255 do Write (F,var_env[i].env_low);
  for i:=0 to 255 do Write (F,var_env[i].env_hi);
  for i:=0 to 255 do Write (F,var_env[i].form);
  for i:=0 to 255 do Write (F,var_reg[i].noise);
  for i:=0 to 255 do Write (F,var_reg[i].control);
  CloseFile (F); Memo1.Lines.Add(' - TABLES.BIN'); Application.ProcessMessages;
//--------------  
Memo1.Lines.Add(' ');Memo1.Lines.Add('Saving track...');
  AssignFile (F,ProgDir+'\TRACK.BIN');
  ReWrite (F);  
  For i:=0 to Track_A_count-1 do
    begin
    ADR:=track_a[i] + ADR_PATT;
      xhi:=floor(ADR/256); xlow:=ADR-xhi*256; Write (F,xlow); Write (F,xhi);
    ADR:=track_b[i] + ADR_PATT + channel_A_size;
      xhi:=floor(ADR/256); xlow:=ADR-xhi*256; Write (F,xlow); Write (F,xhi);
    ADR:=track_c[i] + ADR_PATT + channel_A_size + channel_B_size;
      xhi:=floor(ADR/256); xlow:=ADR-xhi*256; Write (F,xlow); Write (F,xhi);
    ADR:=track_e[i] + ADR_PATT + channel_A_size + channel_B_size + channel_C_size;
      xhi:=floor(ADR/256); xlow:=ADR-xhi*256; Write (F,xlow); Write (F,xhi);
    ADR:=track_r[i] + ADR_PATT + channel_A_size + channel_B_size + channel_C_size + channel_e_size;
      xhi:=floor(ADR/256); xlow:=ADR-xhi*256; Write (F,xlow); Write (F,xhi);
    end;
  CloseFile (F); Memo1.Lines.Add(' - TRACK.BIN'); Application.ProcessMessages;
//--------------------------------------------------------
Memo1.Lines.Add(' ');Memo1.Lines.Add('Saving patterns...');
  AssignFile (F,ProgDir+'\PATTERNS.BIN');
  ReWrite (F);
  //-- ch_a
  for i:=0 to cha_patt_count-1 do
    for j:=0 to temp_block_size-1 do
      begin
      Write (F,cha_patt[i][j].index);
      if (var_tonevol_a_type=1) then Write (F,cha_patt[i][j].volume);
      end;
  //-- ch_b
  for i:=0 to chb_patt_count-1 do
    for j:=0 to temp_block_size-1 do
      begin
      Write (F,chb_patt[i][j].index);
      if (var_tonevol_b_type=1) then Write (F,chb_patt[i][j].volume);
      end;
  //-- ch_c
  for i:=0 to chc_patt_count-1 do
    for j:=0 to temp_block_size-1 do
      begin
      Write (F,chc_patt[i][j].index);
      if (var_tonevol_c_type=1) then Write (F,chc_patt[i][j].volume);
      end;
  //-- ch_env
  for i:=0 to env_patt_count-1 do
    for j:=0 to temp_block_size-1 do
      Write (F,env_patt[i][j].index);
  //-- ch_reg
  for i:=0 to reg_patt_count-1 do
    for j:=0 to temp_block_size-1 do
      Write (F,reg_patt[i][j].index);
  CloseFile (F); Memo1.Lines.Add(' - PATTERNS.BIN'); Application.ProcessMessages;
//--------------------------------------------------------
Memo1.Lines.Add(' ');Memo1.Lines.Add('Saving player...');
AssignFile (FT,ProgDir+'\PLAYER.ASM');
ReWrite (FT);
Writeln (FT,';============================================================');
Writeln (FT,'	DEVICE ZXSPECTRUM128');
Writeln (FT,';============================================================');
Writeln (FT,'ORG_PLAYER	EQU	#'+IntToHex(ADR_PLAYER,4));
Writeln (FT,'ORG_TBL		EQU	#'+IntToHex(ADR_TBL,4));
Writeln (FT,'ORG_TRACK	EQU	#'+IntToHex(ADR_TRK,4));
Writeln (FT,'ORG_PATT	EQU	#'+IntToHex(ADR_PATT,4));
Writeln (FT,';-------');
Writeln (FT,'PATTSIZE	EQU	'+IntToStr(temp_block_size));
Writeln (FT,'CHA_TYPE 	EQU	'+IntToStr(var_tonevol_a_type));
Writeln (FT,'CHB_TYPE 	EQU	'+IntToStr(var_tonevol_b_type));
Writeln (FT,'CHC_TYPE 	EQU	'+IntToStr(var_tonevol_c_type));
Writeln (FT,';-------');
Writeln (FT,'TBL_NV_A	EQU	#'+IntToHex(ADR_TBL,4));
Writeln (FT,'TBL_NV_B	EQU	#'+IntToHex(ADR_TBL+256*(3-var_tonevol_a_type),4));
Writeln (FT,'TBL_NV_C	EQU	#'+IntToHex(ADR_TBL+256*(3-var_tonevol_a_type)+256*(3-var_tonevol_b_type),4));
Writeln (FT,'TBL_ENV		EQU	#'+IntToHex(ADR_TBL+256*(3-var_tonevol_a_type)+256*(3-var_tonevol_b_type)+256*(3-var_tonevol_c_type),4));
Writeln (FT,'TBL_REG		EQU	#'+IntToHex(ADR_TBL+256*(3-var_tonevol_a_type)+256*(3-var_tonevol_b_type)+256*(3-var_tonevol_c_type)+768,4));
Writeln (FT,';----------------------------');
Writeln (FT,'	ORG	#'+IntToHex(ADR_PLAYER,4));
Writeln (FT,'; CALL PLAYER -  ( )');
Writeln (FT,'; CALL	PLAYER+3 - ');
Writeln (FT,'; ,    = 980..1067t,   = 1200..1287t');
Writeln (FT,'PLAYER	JP	INIT');
Writeln (FT,'PLAY	LD	BC,#BFFD	;10');
Writeln (FT,'	EXX			;4');
Writeln (FT,'	LD	BC,#FFFD	;10 //24');
Writeln (FT,'	//--- read data	-------------------------------	Channel_A');
Writeln (FT,'	LD	HL,(ADR_A)	;16');
Writeln (FT,'	LD	E,(HL)		;7');
Writeln (FT,'	INC	HL		;6');
Writeln (FT,'	LD	D,TBL_NV_A/256	;7 //36');
Writeln (FT,'	//--- out data');
Writeln (FT,'	XOR	A	;4	out_reg_0');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	LD	A,(DE)	;7');
Writeln (FT,'	EXX		;4');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	EXX		;4');
Writeln (FT,'	INC	D	;4');
Writeln (FT,'	LD	A,1	;7	out_reg_1');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	LD	A,(DE)	;7');
Writeln (FT,'	EXX		;4');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	EXX		;4 //93');
Writeln (FT,'	//---');
Writeln (FT,'	IF CHA_TYPE=0');
Writeln (FT,'	INC	D	;4	out_reg_8');
Writeln (FT,'	LD	A,8	;7');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	LD	A,(DE)	;7');
Writeln (FT,'	EXX		;4');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	EXX		;4 //50');
Writeln (FT,'	ENDIF');
Writeln (FT,'	//---');
Writeln (FT,'	IF CHA_TYPE=1');
Writeln (FT,'	LD	A,8	;7	out_reg_8');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	LD	A,(HL)	;7');
Writeln (FT,'	INC	HL	;6');
Writeln (FT,'	EXX		;4');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	EXX		;4 //52');
Writeln (FT,'	ENDIF');
Writeln (FT,'	//---');
Writeln (FT,'	LD	(ADR_A),HL ;16 ///195..197');
Writeln (FT,'	//--- read data	-------------------------------	Channel_B');
Writeln (FT,'	LD	HL,(ADR_B)	;16');
Writeln (FT,'	LD	E,(HL)		;7');
Writeln (FT,'	INC	HL		;6');
Writeln (FT,'	LD	D,TBL_NV_B/256	;7 //36');
Writeln (FT,'	//--- out data');
Writeln (FT,'	LD	A,2	;7	out_reg_2');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	LD	A,(DE)	;7');
Writeln (FT,'	EXX		;4');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	EXX		;4');
Writeln (FT,'	INC	D	;4');
Writeln (FT,'	LD	A,3	;7	out_reg_3');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	LD	A,(DE)	;7');
Writeln (FT,'	EXX		;4');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	EXX		;4 //96');
Writeln (FT,'	//---');
Writeln (FT,'	IF CHB_TYPE=0');
Writeln (FT,'	INC	D	;4	out_reg_9');
Writeln (FT,'	LD	A,9	;7');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	LD	A,(DE)	;7');
Writeln (FT,'	EXX		;4');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	EXX		;4 //50');
Writeln (FT,'	ENDIF');
Writeln (FT,'	//---');
Writeln (FT,'	IF CHB_TYPE=1');
Writeln (FT,'	LD	A,9	;7	out_reg_9');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	LD	A,(HL)	;7');
Writeln (FT,'	INC	HL	;6');
Writeln (FT,'	EXX		;4');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	EXX		;4 //52');
Writeln (FT,'	ENDIF');
Writeln (FT,'	//---');
Writeln (FT,'	LD	(ADR_B),HL ;16 ///198..200');
Writeln (FT,'	//--- read data	-------------------------------	Channel_C');
Writeln (FT,'	LD	HL,(ADR_C)	;16');
Writeln (FT,'	LD	E,(HL)		;7');
Writeln (FT,'	INC	HL		;6');
Writeln (FT,'	LD	D,TBL_NV_C/256	;7 //36');
Writeln (FT,'	//--- out data');
Writeln (FT,'	LD	A,4	;7	out_reg_4');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	LD	A,(DE)	;7');
Writeln (FT,'	EXX		;4');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	EXX		;4');
Writeln (FT,'	INC	D	;4');
Writeln (FT,'	LD	A,5	;7	out_reg_5');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	LD	A,(DE)	;7');
Writeln (FT,'	EXX		;4');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	EXX		;4 //96');
Writeln (FT,'	//---');
Writeln (FT,'	IF CHC_TYPE=0');
Writeln (FT,'	INC	D	;4	out_reg_10');
Writeln (FT,'	LD	A,10	;7');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	LD	A,(DE)	;7');
Writeln (FT,'	EXX		;4');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	EXX		;4 //50');
Writeln (FT,'	ENDIF');
Writeln (FT,'	//---');
Writeln (FT,'	IF CHC_TYPE=1');
Writeln (FT,'	LD	A,10	;7	out_reg_10');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	LD	A,(HL)	;7');
Writeln (FT,'	INC	HL	;6');
Writeln (FT,'	EXX		;4');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	EXX		;4 //52');
Writeln (FT,'	ENDIF');
Writeln (FT,'	//---');
Writeln (FT,'	LD	(ADR_C),HL ;16 ///198..200');
Writeln (FT,'	//--- read data	-------------------------------	Channel_Env');
Writeln (FT,'	LD	HL,(ADR_E)	;16');
Writeln (FT,'	LD	A,(HL)		;7');
Writeln (FT,'	INC	HL		;6');
Writeln (FT,'	LD	(ADR_E),HL	;16');
Writeln (FT,'	LD	H,TBL_ENV/256	;7');
Writeln (FT,'	LD	L,A		;4 //56');
Writeln (FT,'	//--- out data');
Writeln (FT,'	LD	A,11	;7	out_reg_11');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	IN	A,(C)	;12');
Writeln (FT,'	CP	(HL)	;7');
Writeln (FT,'	JP	Z,NO11	;10 /48');
Writeln (FT,'	//---');
Writeln (FT,'	LD	A,(HL)	;7');
Writeln (FT,'	EXX		;4');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	EXX		;4 /27 //48..75');
Writeln (FT,'	//---');
Writeln (FT,'NO11	INC	H	;4');
Writeln (FT,'	LD	A,12	;7	out_reg_12');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	IN	A,(C)	;12');
Writeln (FT,'	CP	(HL)	;7');
Writeln (FT,'	JP	Z,NO12	;10 /52');
Writeln (FT,'	//---');
Writeln (FT,'	LD	A,(HL)	;7');
Writeln (FT,'	EXX		;4');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	EXX		;4 /27 //52..79');
Writeln (FT,'	//---');
Writeln (FT,'NO12	INC	H	;4');
Writeln (FT,'	LD	A,13	;7	out_reg_13');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	IN	A,(C)	;12');
Writeln (FT,'	CP	(HL)	;7');
Writeln (FT,'	JP	Z,NO13	;10 /52');
Writeln (FT,'	//---');
Writeln (FT,'	LD	A,(HL)	;7');
Writeln (FT,'	EXX		;4');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	EXX		;4 /27 //52..79');
Writeln (FT,'NO13	//---				///56+48+52+52..56+75+79+79');
Writeln (FT,'					/// = 208..289');
Writeln (FT,'	//--- read data	-------------------------------	Channel_Reg');
Writeln (FT,'	LD	HL,(ADR_R)	;16');
Writeln (FT,'	LD	E,(HL)		;7');
Writeln (FT,'	INC	HL		;6');
Writeln (FT,'	LD	(ADR_R),HL	;16');
Writeln (FT,'	LD	D,TBL_REG/256	;7 //52');
Writeln (FT,'	//--- out data');
Writeln (FT,'	LD	A,6	;7	out_reg_6 (noise)');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	LD	A,(DE)	;7');
Writeln (FT,'	EXX		;4');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	EXX		;4');
Writeln (FT,'	INC	D	;4 //50');
Writeln (FT,'	//---');
Writeln (FT,'	LD	A,7	;7	out_reg_7 (control)');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	LD	A,(DE)	;7');
Writeln (FT,'	EXX		;4');
Writeln (FT,'	OUT	(C),A	;12');
Writeln (FT,'	EXX		;4 //46 ///148');
Writeln (FT,'	//---    ,   ');
Writeln (FT,'	LD	HL,CURRPOS		;10');
Writeln (FT,'	DEC	(HL)			;11');
Writeln (FT,'	RET	NZ			;5..11 //26..33');
Writeln (FT,'					;   ///(195..197)+2*(198..200)+(208..289)+148+33');
Writeln (FT,'					; t=980..1067');
Writeln (FT,'	//---    ');
Writeln (FT,'	LD	A,PATTSIZE	;7');
Writeln (FT,'	LD	(HL),A		;7');
Writeln (FT,'	LD	HL,(ADR_PATT)	;16');
Writeln (FT,'	LD	DE,ADR_A	;10');
Writeln (FT,'	DUP	10');
Writeln (FT,'	LDI			;16*10=160');
Writeln (FT,'	EDUP			;');
Writeln (FT,'	LD	(ADR_PATT),HL	;16');
Writeln (FT,'	RET			;10 //226 t=1200..1287');
Writeln (FT,'INIT	LD	A,7');
Writeln (FT,'	LD	BC,#FFFD');
Writeln (FT,'	OUT	(C),A');
Writeln (FT,'	LD	B,#BF');
Writeln (FT,'	LD	A,#FF');
Writeln (FT,'	OUT	(C),A');
Writeln (FT,'	LD	HL,BEGIN_TRACK');
Writeln (FT,'	LD	DE,ADR_A');
Writeln (FT,'	LD	BC,10');
Writeln (FT,'	LDIR');
Writeln (FT,'	LD	(ADR_PATT),HL');
Writeln (FT,'	LD	A,PATTSIZE');
Writeln (FT,'	LD	(CURRPOS),A');
Writeln (FT,'	RET');
Writeln (FT,'//---------------- variables');
Writeln (FT,'ADR_A	 DW	0');
Writeln (FT,'ADR_B	 DW	0');
Writeln (FT,'ADR_C	 DW	0');
Writeln (FT,'ADR_E	 DW	0');
Writeln (FT,'ADR_R	 DW	0');
Writeln (FT,'CURRPOS	 DB	PATTSIZE');
Writeln (FT,'ADR_PATT DW	0');
Writeln (FT,'PLAYER_END');
Writeln (FT,'//----------------- TABLES');
Writeln (FT,'		ORG	ORG_TBL');
Writeln (FT,'BEGIN_TBL	INCBIN	"TABLES.BIN"');
Writeln (FT,'END_TBL');
Writeln (FT,'		ORG	ORG_TRACK');
Writeln (FT,'BEGIN_TRACK	INCBIN	"TRACK.BIN"');
Writeln (FT,'END_TRACK');
Writeln (FT,'		ORG	ORG_PATT');
Writeln (FT,'BEGIN_PATT	INCBIN	"PATTERNS.BIN"');
Writeln (FT,'END_PATT');
Writeln (FT,'END_MODULE');
Writeln (FT,'//----------------- save to TRD');
Writeln (FT,'	EMPTYTRD "ay_zip_play.trd"');
if (Form1.Combo_Compile.ItemIndex=0) then
begin //save monoblock
Writeln (FT,'	SAVETRD "ay_zip_play.trd","MODULE.C",PLAYER,END_MODULE-PLAYER');
end
else
begin //save separately blocks
Writeln (FT,'	SAVETRD "ay_zip_play.trd","PLAYER.C",PLAYER,PLAYER_END-PLAYER');
Writeln (FT,'	SAVETRD "ay_zip_play.trd","TABLES.C",ORG_TBL,END_TBL-ORG_TBL');
Writeln (FT,'	SAVETRD "ay_zip_play.trd","TRACK.C",ORG_TRACK,END_TRACK-ORG_TRACK');
Writeln (FT,'	SAVETRD "ay_zip_play.trd","PATTERNS.C",ORG_PATT,END_PATT-ORG_PATT');
end;
Writeln (FT,'//-----------------   ');
Writeln (FT,'		ORG	#8000');
Writeln (FT,'		CALL	PLAYER');
Writeln (FT,'LOOP		EI');
Writeln (FT,'		HALT');
Writeln (FT,'		CALL	PLAYER+3');
Writeln (FT,'		JP	LOOP');
Writeln (FT,'END_PR');
Writeln (FT,'	SAVETRD "ay_zip_play.trd","CODE.C",#8000,END_PR-#8000');
Writeln (FT,'		ORG	#9000');
Writeln (FT,'BEGIN_BAS');
if (Form1.Combo_Compile.ItemIndex=0) then
//save monoblock loader
Writeln (FT,'	INCBIN	"loader_m.bas"')
else
//save separately loader
Writeln (FT,'	INCBIN	"loader_s.bas"');
Writeln (FT,'END_BAS');    
Writeln (FT,'	SAVETRD "ay_zip_play.trd","PLAYER.B",BEGIN_BAS,END_BAS-BEGIN_BAS');
CloseFile (FT);
Memo1.Lines.Add(' - PLAYER.ASM');
end;

procedure Update_compile_adr;
var adr_player,adr_tbl,adr_trk,adr_p: dword;
    end_player,end_tbl,end_trk,end_p: dword;
    player_size,tbl_size,trk_size,p_size: word;
begin
player_size:=arr_block_size[Form1.Combo_BlockSize.ItemIndex].player_size;
tbl_size:=arr_block_size[Form1.Combo_BlockSize.ItemIndex].tbl_size;
trk_size:=arr_block_size[Form1.Combo_BlockSize.ItemIndex].trk_size;
p_size:=arr_block_size[Form1.Combo_BlockSize.ItemIndex].p_size;
if (Form1.Combo_Compile.ItemIndex=0) then
  begin
  // 
  adr_player:=GetDecimal(Form1.Edit_PlayerADR.Text);
  adr_tbl:=adr_player+player_size;
  adr_trk:=adr_tbl+tbl_size;
  adr_p:=adr_trk+trk_size;
  if (Form1.Combo_ADRView.ItemIndex=0) then
    begin
    Form1.Edit_TablesADR.Text:=IntToStr(adr_tbl);
    Form1.Edit_TrackADR.Text:=IntToStr(adr_trk);
    Form1.Edit_PattADR.Text:=IntToStr(adr_p);
    end
  else
    begin
    Form1.Edit_TablesADR.Text:=IntToHex(adr_tbl,1);
    Form1.Edit_TrackADR.Text:=IntToHex(adr_trk,1);
    Form1.Edit_PattADR.Text:=IntToHex(adr_p,1);
    end;
  end;
//---
adr_player:=GetDecimal(Form1.Edit_PlayerADR.Text);
adr_tbl:=GetDecimal(Form1.Edit_TablesADR.Text);
adr_trk:=GetDecimal(Form1.Edit_TrackADR.Text);
adr_p:=GetDecimal(Form1.Edit_PattADR.Text);
end_player:=adr_player+player_size;
end_tbl:=adr_tbl+tbl_size;
end_trk:=adr_trk+trk_size;
end_p:=adr_p+p_size;
if (Form1.Combo_ADRView.ItemIndex=0) then
  begin
  Form1.Edit_PlayerEND.Text:=IntToStr(end_player);
  Form1.Edit_TablesEND.Text:=IntToStr(end_tbl);
  Form1.Edit_TrackEND.Text:=IntToStr(end_trk);
  Form1.Edit_PattEND.Text:=IntToStr(end_p);
  end
else
  begin
  Form1.Edit_PlayerEND.Text:=IntToHex(end_player,1);
  Form1.Edit_TablesEND.Text:=IntToHex(end_tbl,1);
  Form1.Edit_TrackEND.Text:=IntToHex(end_trk,1);
  Form1.Edit_PattEND.Text:=IntToHex(end_p,1);
  end;
end;

procedure TForm1.Combo_BlockSizeChange(Sender: TObject);
begin
Update_compile_adr;
end;

procedure TForm1.Combo_ADRViewChange(Sender: TObject);
begin
if (Combo_ADRView.ItemIndex=0) and (dechex_view=1) then
  begin // hex->dec
  dechex_view:=0;
  Form1.Edit_PlayerADR.Text:=IntToStr(HexToDec(Form1.Edit_PlayerADR.Text));
  Form1.Edit_TablesADR.Text:=IntToStr(HexToDec(Form1.Edit_TablesADR.Text));
  Form1.Edit_TrackADR.Text:=IntToStr(HexToDec(Form1.Edit_TrackADR.Text));
  Form1.Edit_PattADR.Text:=IntToStr(HexToDec(Form1.Edit_PattADR.Text));
  Form1.Edit_PlayerEND.Text:=IntToStr(HexToDec(Form1.Edit_PlayerEND.Text));
  Form1.Edit_TablesEND.Text:=IntToStr(HexToDec(Form1.Edit_TablesEND.Text));
  Form1.Edit_TrackEND.Text:=IntToStr(HexToDec(Form1.Edit_TrackEND.Text));
  Form1.Edit_PattEND.Text:=IntToStr(HexToDec(Form1.Edit_PattEND.Text));
  end;
if (Combo_ADRView.ItemIndex=1) and (dechex_view=0) then
  begin // dec->hex
  dechex_view:=1;
  Form1.Edit_PlayerADR.Text:=IntToHex(StrToInt(Form1.Edit_PlayerADR.Text),1);
  Form1.Edit_TablesADR.Text:=IntToHex(StrToInt(Form1.Edit_TablesADR.Text),1);
  Form1.Edit_TrackADR.Text:=IntToHex(StrToInt(Form1.Edit_TrackADR.Text),1);
  Form1.Edit_PattADR.Text:=IntToHex(StrToInt(Form1.Edit_PattADR.Text),1);
  Form1.Edit_PlayerEND.Text:=IntToHex(StrToInt(Form1.Edit_PlayerEND.Text),1);
  Form1.Edit_TablesEND.Text:=IntToHex(StrToInt(Form1.Edit_TablesEND.Text),1);
  Form1.Edit_TrackEND.Text:=IntToHex(StrToInt(Form1.Edit_TrackEND.Text),1);
  Form1.Edit_PattEND.Text:=IntToHex(StrToInt(Form1.Edit_PattEND.Text),1);
  Update_compile_adr;
  end;
end;

procedure TForm1.Edit_PlayerADRKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
Update_compile_adr;
end;

procedure TForm1.Edit_TablesADRKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
Update_compile_adr;
end;

procedure TForm1.Edit_TrackADRKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
Update_compile_adr;
end;

procedure TForm1.Edit_PattADRKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
Update_compile_adr;
end;

procedure TForm1.Panel3Click(Sender: TObject);
begin
ShowMessage ('Supported files:'+#13#10+
' *.raw, *.bin - raw ay dump'+#13#10+
' and all ayfly.dll supported files');
end;

procedure TForm1.Panel1Click(Sender: TObject);
begin
ShowMessage(
'Fast ZX AY-Dump Player (with PC Compiler)'+#13#10+
''+#13#10+
'codename: ay_zip_player'+#13#10+
'ver 1.0, build 9'+#13#10+
''+#13#10+
'thx to Robus for cool idea!'+#13#10+
'thx to ayfly.dlls authors for cool stuff!'+#13#10+
''+#13#10+
'()2010 TmK^[deMarche]'+#13#10);
end;

end.

