{
 BIN2SNA sources
 by Aprisobal (c) 2004-2006
 Belarus, Minsk
 aprisobal@tut.by
 You can use sources as you want.
}

program bin2sna;

{$APPTYPE CONSOLE}

uses
  Windows, SysUtils;

type
  TArray = array of string;

var

// Memory
gl7FFD: byte=0;

// Main Z80 registers
regAF: word;
regHL: word;
regBC: word;
regDE: word;

// Alternate registers
regAF_: word;
regHL_: word;
regBC_: word;
regDE_: word;

// Index registers  - ID used as temp for ix/iy
regIX: word=$573A;
regIY: word=$573A;

// Stack pointer and program counter
regSP: word=$6000;
regPC: word=$8000;

// Interrupt registers and flip-flops, and refresh registers
intI: byte=0;
intR: byte=0;
intIFF1: boolean=false;
intIM: byte=1;

// Misc
BorderColor: byte;

RAM: array of array [0..16383] of byte;

//save SNA 128 snapshot
procedure SaveSNA128Snap(var hFile : File);
var
  lBank : integer;
  bDummy: byte;
begin
  BlockWrite(hFile, intI, 1);
  BlockWrite(hFile, regHL_, 2);
  BlockWrite(hFile, regDE_, 2);
  BlockWrite(hFile, regBC_, 2);
  BlockWrite(hFile, regAF_, 2);

  BlockWrite(hFile, regHL, 2);
  BlockWrite(hFile, regDE, 2);
  BlockWrite(hFile, regBC, 2);
  BlockWrite(hFile, regIY, 2);
  BlockWrite(hFile, regIX, 2);

  //Interrupt flipflops
  {if intIFF1 = True then
    bdummy := 4
  else}
    bdummy := 0;
  BlockWrite(hFile, bdummy, 1);

  //R
  BlockWrite(hFile, intR, 1);

  // AF
  BlockWrite(hFile, regAF, 2);

  // SP
  BlockWrite(hFile, regSP, 2);

  // Interrupt Mode
  BlockWrite(hFile, intIM, 1);

  BlockWrite(hFile, BorderColor, 1);

  // Save the three currently-paged RAM banks
  {for lCounter := 0 To 16383 do
    BlockWrite(hFile, RAM[5,lCounter], 1);}
  BlockWrite(hFile, RAM[5], 16384);

  {for lCounter := 0 To 16383 do
    BlockWrite(hFile, RAM[2,lCounter], 1);}
  BlockWrite(hFile, RAM[2], 16384);

  {for lCounter := 0 To 16383 do
    BlockWrite(hFile, RAM[gl7FFD and 7,lCounter], 1);}
  BlockWrite(hFile, RAM[gl7FFD and 7], 16384);

  //PC
  BlockWrite(hFile, regPC, 2);

  //Last out to 0x7FFD
  BlockWrite(hFile, gl7FFD, 1);

  //Is TR-DOS paged? (0=not paged, 1=paged)
  bDummy := 0;
  BlockWrite(hFile, bDummy, 1);

  // Save the remaining RAM banks
  lBank := 0;
  while lBank < 8 do
  begin
    if (lBank <> 5) and (lBank <> 2) and (lBank <> gl7FFD and 7) then
    begin
      {for lCounter := 0 To 16383 do
        BlockWrite(hFile, RAM[lBank,lCounter], 1);}
      BlockWrite(hFile, RAM[lBank], 16384);
    end;
    lBank := lBank + 1;
  end;
end;

//save Z80 128 snapshot
procedure SaveZ80128Snap(var hFile : File);
var
  lBank : integer;
  bDummy: byte;
begin

  bDummy := regAF and 255;
  BlockWrite(hFile, bDummy, 1);
  bDummy := regAF shr 8;
  BlockWrite(hFile, bDummy, 1);
  BlockWrite(hFile, regBC, 2);
  BlockWrite(hFile, regHL, 2);
  bDummy := 0;
  BlockWrite(hFile, bDummy, 1);
  BlockWrite(hFile, bDummy, 1);
  BlockWrite(hFile, regSP, 2); // SP
  BlockWrite(hFile, intI, 1);
  bDummy := intR and 127;
  BlockWrite(hFile, bDummy, 1);
  bDummy := (intR and 128) or (BorderColor shr 1);  //ints and border color
  BlockWrite(hFile, bDummy, 1);
  BlockWrite(hFile, regDE, 2);
  BlockWrite(hFile, regBC_, 2);
  BlockWrite(hFile, regDE_, 2);
  BlockWrite(hFile, regHL_, 2);
  bDummy := regAF_ and 255;
  BlockWrite(hFile, bDummy, 1);
  bDummy := regAF_ shr 8;
  BlockWrite(hFile, bDummy, 1);
  BlockWrite(hFile, regIY, 2);
  BlockWrite(hFile, regIX, 2);
  bDummy := 0;
  BlockWrite(hFile, bDummy, 1); //di
  BlockWrite(hFile, bDummy, 1); //iff2 = 0
  bDummy := (intIM and 3) or 64; //int mode + kempston joystick
  BlockWrite(hFile, bDummy, 1);


  //Interrupt flipflops
  {if intIFF1 = True then
    bdummy := 4
  else}
    bdummy := 0;
  BlockWrite(hFile, bdummy, 1);


  // Save the three currently-paged RAM banks
  {for lCounter := 0 To 16383 do
    BlockWrite(hFile, RAM[5,lCounter], 1);}
  BlockWrite(hFile, RAM[5], 16384);

  {for lCounter := 0 To 16383 do
    BlockWrite(hFile, RAM[2,lCounter], 1);}
  BlockWrite(hFile, RAM[2], 16384);

  {for lCounter := 0 To 16383 do
    BlockWrite(hFile, RAM[gl7FFD and 7,lCounter], 1);}
  BlockWrite(hFile, RAM[gl7FFD and 7], 16384);

  //PC
  BlockWrite(hFile, regPC, 2);

  //Last out to 0x7FFD
  BlockWrite(hFile, gl7FFD, 1);

  //Is TR-DOS paged? (0=not paged, 1=paged)
  bDummy := 0;
  BlockWrite(hFile, bDummy, 1);

  // Save the remaining RAM banks
  lBank := 0;
  while lBank < 8 do
  begin
    if (lBank <> 5) and (lBank <> 2) and (lBank <> gl7FFD and 7) then
    begin
      {for lCounter := 0 To 16383 do
        BlockWrite(hFile, RAM[lBank,lCounter], 1);}
      BlockWrite(hFile, RAM[lBank], 16384);
    end;
    lBank := lBank + 1;
  end;
end;

function explode( char: char; str: string ): TArray;
var
  k, l: integer;
begin
  setlength(result, 0);
  l := 1;
  for k := 0 to length(str)-1 do begin
    if (str[k] = char) then begin
      setlength(result, length(result)+1);
      result[length(result)-1] := copy(str, l, k-l);
      l := k+1;
    end;
  end;
  setlength(result, length(result)+1);
  result[length(result)-1] := copy(str, l, k);
end;

function HEX2DEC(HEX: string): LONGINT;
  function Digt(Ch: CHAR): BYTE;
  const
    HEXDigts: string[16] = '0123456789ABCDEF';
  var
    I: BYTE;
    N: BYTE;
  begin
    N := 0;
    for I := 1 to Length(HEXDigts) do
      if Ch = HEXDigts[I] then
        N := I - 1;
    Digt := N;
  end;
const
  HEXSet: set of CHAR = ['0'..'9', 'A'..'F'];
var
  J: LONGINT;
  Error: BOOLEAN;
  DEC: LONGINT;
begin
  DEC := 0;
  Error := False;
  for J := 1 to Length(HEX) do
  begin
    if not (UpCase(HEX[J]) in HEXSet) then
      Error := True;
    DEC := DEC + Digt(UpCase(HEX[J])) shl ((Length(HEX) - J) * 4);
    { 16^N = 2^(N * 4) }
    { N SHL ((Length(HEX) - J) * 4) = N * 16^(Length(HEX) - J) }
  end;
  if Error then
    HEX2DEC := 0
  else
    HEX2DEC := DEC;
end;

function BIN2DEC(BIN: string): LONGINT;
var
  J: LONGINT;
  Error: BOOLEAN;
  DEC: LONGINT;
begin
  DEC := 0;
  Error := False;
  for J := 1 to Length(BIN) do
  begin
    if (BIN[J] <> '0') and (BIN[J] <> '1') then
      Error := True;
    if BIN[J] = '1' then
      DEC := DEC + (1 shl (Length(BIN) - J));
    { (1 SHL (Length(BIN) - J)) = 2^(Length(BIN)- J) }
  end;
  if Error then
    BIN2DEC := 0
  else
    BIN2DEC := DEC;
end;

function strtoint( num: string ):integer;
var
  str: string;
begin
  result := 0;
  if (num <> '') then begin
    if (num[1] = '$') OR (num[1] = '#') then begin
      str := copy(num, 2, length(num));
      result := HEX2DEC(str);
    end else if (num[1] = '0') AND (uppercase(num[2]) = 'X') then begin
      str := copy(num, 3, length(num));
      result := HEX2DEC(str);
    end else if (uppercase(num[length(num)]) = 'H') then begin
      str := copy(num, 1, length(num)-1);
      result := HEX2DEC(str);
    end else if (num[1] = '%') then begin
      str := copy(num, 2, length(num));
      result := BIN2DEC(str);
    end else begin
      try
        result := StrToIntDef(num, 0);
      except
        result := 0;
      end;
    end;
  end;
end;

var
  F: textfile;
  F2: file of byte;
  F3: file;
  str, fname: string;
  buf: array [0..16383] of byte;
  I, readed: integer;
  outfile, filename: string;
  regs: TArray;
  addr: word=$8000;
  fsize: integer;
  keyI: boolean=false;
  msecs_begin: integer;

begin
  msecs_begin := GetTickCount;
  writeln('BIN2SNA 1.02 by Aprisobal (c) 2004-2006. Usage: bin2sna <file-descriptor>');
  writeln;
  if (ParamCount > 0) then begin
    fname := ParamStr(ParamCount);
    if (FileExists(fname)) then begin
      AssignFile(F, fname);
      Reset(F);
      SetLength(RAM, 8);
      while (not Eof(F)) do begin
        readln(F, str);
        regs := explode(' ', str);
        regs[0] := uppercase(regs[0]);
        if (length(regs) > 1) AND (length(regs[1]) > 0) then
          if (regs[0] = 'FNAME') then begin
            if ((regs[1][1] = '"') AND (regs[1][length(regs[1])] = '"'))
              OR ((regs[1][1] = '''') AND (regs[1][length(regs[1])] = '''')) then
            begin
              regs[1] := copy(regs[1], 2, length(regs[1])-2);
            end;
            outfile := regs[1];
            writeln('Output to: "',outfile,'"');
          end else
          if (regs[0] = 'REGISTER') OR (regs[0] = 'REG') AND (length(regs) > 2) AND (length(regs[2]) > 0) then begin
            if (regs[1] = 'SP') then begin regSP := strtoint(regs[2]); writeln(' set REGISTER: SP = ',regSP); end else
            if (regs[1] = 'PC') then begin regPC := strtoint(regs[2]); writeln(' set REGISTER: PC = ',regPC); end else
            if (regs[1] = 'HL') then begin regHL := strtoint(regs[2]); writeln(' set REGISTER: HL = ',regHL); end else
            if (regs[1] = 'HL`') then begin regHL_ := strtoint(regs[2]); writeln(' set REGISTER: HL` = ',regHL_); end else
            if (regs[1] = 'DE') then begin regDE := strtoint(regs[2]); writeln(' set REGISTER: DE = ',regDE); end else
            if (regs[1] = 'DE`') then begin regDE_ := strtoint(regs[2]); writeln(' set REGISTER: DE` = ',regDE_); end else
            if (regs[1] = 'BC') then begin regBC := strtoint(regs[2]); writeln(' set REGISTER: BC = ',regBC); end else
            if (regs[1] = 'BC`') then begin regBC_ := strtoint(regs[2]); writeln(' set REGISTER: BC` = ',regBC_); end else
            if (regs[1] = 'IX') then begin regIX := strtoint(regs[2]); writeln(' set REGISTER: IX = ',regIX); end else
            if (regs[1] = 'IY') then begin regIY := strtoint(regs[2]); writeln(' set REGISTER: IY = ',regIY); end else
            if (regs[1] = 'AF') then begin regAF := strtoint(regs[2]); writeln(' set REGISTER: AF = ',regAF); end else
            if (regs[1] = 'AF`') then begin regAF_ := strtoint(regs[2]); writeln(' set REGISTER: AF` = ',regAF_); end else
            if (regs[1] = 'R') then begin intR := strtoint(regs[2]); writeln(' set REGISTER: R = ',intR); end else
            if (regs[1] = 'I') then begin intI := strtoint(regs[2]); writeln(' set REGISTER: I = ',intI); end else
            if (regs[1] = 'IM') then begin intIM := strtoint(regs[2]) and 3; writeln(' set INTERRUPT MODE: IM = ',intIM); end else
            writeln('WARNING: Unknown register: ', regs[1]);
          //end else
          end else
          if (regs[0] = 'IM') then begin
            intIM := strtoint(regs[1]) and 3;
            writeln(' set INTERRUPT MODE: IM = ',intIM);
          end else
          if (regs[0] = 'PAGE') then begin
            gl7FFD := (gl7FFD AND 248) OR (strtoint(regs[1]) AND 7);
            writeln(' set PAGE = ',gl7FFD AND 7);
          end else
          if (regs[0] = '7FFD') then begin
            gl7FFD := byte(strtoint(regs[1]));
            writeln(' set PORT: $7FFD = ',gl7FFD);
          end else
          if (regs[0] = 'FE') then begin
            BorderColor := byte(strtoint(regs[1]));
            writeln(' set PORT: $FE = ',BorderColor);
          end else
          if (regs[0] = 'ADDR') then begin
            if (strtoint(regs[1]) >= $4000) then begin
              addr := strtoint(regs[1]);
              writeln(' set ADDR = ',addr);
            end;
          end else
          if ((regs[0] = 'INCBIN') OR (regs[0] = 'HOBETA')) AND (length(regs[1]) > 0) then begin
            if ((regs[1][1] = '"') AND (regs[1][length(regs[1])] = '"'))
              OR ((regs[1][1] = '''') AND (regs[1][length(regs[1])] = '''')) then
            begin
              regs[1] := copy(regs[1], 2, length(regs[1])-2);
            end;

            if (fileexists(regs[1])) then begin
              filename := regs[1];
              AssignFile(F2, filename);
              Reset(F2);
              fsize := FileSize(F2);
              if (regs[0] = 'HOBETA') then begin
                BlockRead(F2, Buf, 17, Readed);
                if (Readed < 17) then begin
                  writeln('ERROR: File is not in HOBETA format!');
                  CloseFile(F2);
                  CloseFile(F);
                  exit;
                end;
              end;

              if (fsize + addr <= $10000) then begin
                while (not eof(F2)) do begin
                  if (addr < $8000) AND (addr >= $4000) then begin
                    BlockRead(F2, Buf, $8000 - addr, Readed);
                    for I := 0 to Readed-1 do begin
                      RAM[5, addr - $4000] := Buf[I];
                      inc(addr);
                    end;
                  end else
                  if (addr >= $8000) AND (addr < $C000) then begin
                    BlockRead(F2, Buf, $C000 - addr, Readed);
                    for I := 0 to Readed-1 do begin
                      RAM[2, addr - $8000] := Buf[I];
                      inc(addr);
                    end;
                  end else begin
                    BlockRead(F2, Buf, $10000 - addr, Readed);
                    for I := 0 to Readed-1 do begin
                      RAM[gl7FFD and 7, addr - $C000] := Buf[I];
                      inc(addr);
                    end;
                  end;
                end;
                writeln(' file ADDED: "', filename, '"; current ADDR = ', addr);

              end else begin
                writeln('ERROR: File excess limit of RAM!');
                CloseFile(F2);
                CloseFile(F);
                exit;
              end;
              CloseFile(F2);
            end else begin
              writeln('ERROR: File not found: ',regs[1]);
            end;
          end;
      end;
      CloseFile(F);
      if (length(outfile) > 0) then begin
        try
          AssignFile(F3, outfile);
          Rewrite(F3, 1);
          SaveSNA128Snap(F3);
          CloseFile(F3);
          writeln;
          writeln('Snapshot has been saved!');
          writeln('Elapsed time: ', floattostr((GetTickCount - msecs_begin) / 1000), ' seconds');
        except
          writeln('ERROR: Failed while try to create file ',outfile);
        end;
      end else begin
        writeln('ERROR: You must set output file(FNAME)!');
      end;
    end else begin
      writeln('ERROR: The file '+fname+' not found!');
    end;
  end else begin
    writeln('mailto: aprisobal@tut.by');
    writeln;
    writeln('Help:');
    writeln(' You must create a file with special commands. Available commands:');
    writeln(' FNAME <string> - destination snapshot file');
    writeln(' INCBIN <filename> - include binary file from current address (see ADDR)');
    writeln(' HOBETA <filename> - too most, but for Hobeta files');
    writeln(' PAGE <byte> - set current page of RAM (0x7FFD)');
    writeln(' ADDR <word> - set current address in RAM');
    writeln(' 7FFD <byte> - set value of port $7FFD');
    writeln(' FE <byte> - set value of port $FE');
    writeln(' REGISTER(or REG) [SP|PC|IM|HL|DE|BC|AF|HL`|DE`|BC`|AF`|IX|IY|I|R] <word> or <byte>');
    writeln('    - set value of registers');
    writeln(' IM <byte> - set IM mode(0-2)');
    writeln;
    writeln('Format of numbers:');
    writeln(' HEX: $0000,#0000,0x0000,0000h');
    writeln(' BIN: %00000000');
    writeln(' DEC: 65535');
  end;
end.
