unit re3_rt4_unit;
{$o-}  {   !!! }

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, DBCtrls, Gauges;

type
  Tre3_rt4 = class(TForm)
    Chip: TRadioGroup;
    ReadPROM: TButton;
    VerifyPROM: TButton;
    WritePROM: TButton;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    SaveB: TButton;
    LoadB: TButton;
    ListBoxBufer: TListBox;
    Label1: TLabel;
    procedure GameOverClick(Sender: TObject);
    procedure InitDevice(Sender: TObject);
    procedure ReadPROMClick(Sender: TObject);
    procedure VerifyPROMClick(Sender: TObject);
    procedure WritePROMClick(Sender: TObject);
    procedure SaveBClick(Sender: TObject);
    procedure LoadBClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

TheChip = record
    L: word; //     (  c 0)
    W: byte; //    () // FFh 8 , 0Fh 4 
    B: byte; //   () // 00h/FFh    0/1   
    T: byte; //    () // 5, 17, 16      18,19,21,22
             //      8..15     
end;

const _SelectIn = 8;     //    _SelectIn
       Init      =4;     //    Init
      CountutoLF    =2;     //    CountutoLF
      _Strobe    =1;     //    _Strobe

      SafeByte = _SelectIn +CountutoLF+_Strobe;
      {  LPT
        _SelectIn =0 =>  
        CountutoLF   =0 =>   (A0..A7) 
        _Strobe   =0 =     }

     _string ='0123456789ABCDEF';
     Max=2047;  //   
var

  re3_rt4: Tre3_rt4;
  Chips:TheChip;
{----------------------------}

base    : word = $378;      {   }
control : word = $378+2;    {  }
status  : word = $378+1;    {   }

ControlByte : byte;         {       }

Buffer  : array [0..Max] of byte;

Pulse   : byte;             {      }

MyFile  :file of byte;   {    }

count    :word;
err      :word;          {  }

CheckSum:dword;       //  
BlankSum:dword;       //    


implementation

{$R *.DFM}

{-------------------------------------------}
procedure Delay(ms : cardinal);
{  }
var TheTime : cardinal;
 begin
  TheTime := GetTickCount + ms;
   while GetTickCount < TheTime do
   Application.ProcessMessages;     {      }
 end;
{--------------------------------------------------}

function BinHex(input:byte):string; {    HEX }
 var _s:string;
begin
 _s:=_string;
 BinHex:=_s[(input shr 4)+1]+_s[(input and $0F)+1];
end;

{-------------------------------------------------}
Procedure SetSafe; //   
asm
 mov dx,base
 mov al,0
 out dx,al               {  0}

 mov dx,control
 mov al,SafeByte {  }
 out dx,al

 and al,not CountutoLF
 out dx,al              {    0  }
 or al,CountutoLF
 out dx,al              { }
 mov ControlByte,al     {     }
 mov eax,100
 call delay             {  100    }
end;

{------------------------------------------------}
Procedure LoadP;  //   
begin
case re3_rt4.Chip.ItemIndex of
 0: with Chips do    // 1553
    begin
     L:=31; w:=$0FF; b:=0; t:=0;
    end;

 1: With chips do    // 5564/11
    begin
     l:=255; w:=$0F; b:=0; t:=0;
    end;

 2: with Chips do    // 5565/17
    begin
     l:=511; w:=$FF;  b:=$FF;  t:=$1A;
    end;

 3: with Chips do    // 5566/7/18/181
    begin
     l:=2047; w:=$FF;  b:=$00;  t:=$18;
    end

  else
   begin //       
    MessageDlg('    LoadP !!!', mtError, [mbOk], 0);
    SetSafe;
    Halt;
   end;
  end;      // case
end;

{------------------------------------------------}
Function CompareP:boolean;  //      ( radiogroup)
begin
case re3_rt4.Chip.ItemIndex of
 0:  // 1553
   if (Chips.L=31) and (chips.w=$0FF) and (chips.b=0) then CompareP:=true;
 1: // 5564/11
   if (Chips.L=255) and (chips.w=$0F) and (chips.b=0) then CompareP:=true;
 2: // 5565/RT17
   if (Chips.L=511) and (chips.w=$0FF) and (chips.b=$0FF) then CompareP:=true;
 3: // 5566/RT7/18/181
   if (Chips.L=2047) and (chips.w=$0FF) and (chips.b=$0) then CompareP:=true;
  else CompareP:=false;
  end;
end;
{------------------------------------------------}

Procedure SetAdres(TheAdres:word);
asm
                   {  ax TheAdres}
 mov dx,Base
 out dx,al         //  A0..A7

 mov dx,control
 mov al,ControlByte

 or al, CountutoLF
 out dx,al             // CountutoLF  ___

 and al,not CountutoLF
 out dx,al         //   CountutoLF ___---

 xchg al,ah        // al = A8..A15     ah =  ControlByte
 or al, Chips.T    //    1  
 mov dx,Base
 out dx,al         //  A8..A15

 mov dx,Control
 xchg al,ah

 and al, not Init
 out dx,al
 or al,Init
 out dx,al         //  

 mov controlByte,al

end;
{--------------------------------------------------------}
function Readbyte(TheAdres:word):byte; {     }
asm
 call SetAdres {     }

 mov dx,control
 mov al,ControlByte

 and al, not _Strobe
 out dx,al                 {   ---___}
 mov ControlByte,al

 mov bx,0
 mov ecx,8      {  8    }

@@ReadByte00:
 mov al,cl
 dec al         {  }
 mov dx,Base
 out dx,al     {  }

 inc dx

 in al,dx
 in al,dx
 in al,dx       { }


 in al,dx      { }
 not al        {  }
 and al,20h    {   }
 jz @@ZeroBit
 add bl,1     {  1    =1}

@@ZeroBit:
 shl bx,1   {     }

  Loop @@ReadByte00   {   ?}

 shr bx,1

 mov dx,control
 mov al,ControlByte
 or al, _Strobe
 out dx,al           //  _CE
 mov controlByte,al

 mov al,bl       //  
 and al,Chips.w  // c    
end;

{------------------------------------------------------}
procedure WriteByte(Data:Cardinal);
{      8  4 ,
 1 -  , 0  
 DATA
 D31..D16  
 D15..D8   
 D7..D0        }

asm
 mov ebx,eax
 shr eax,16         {  }
 call SetAdres

 xchg bh,bl      //  BL   ,  BH     
 and bl,Chips.W  //    
 xor bl,Chips.B  //       FF   

 mov ecx,7            { 8 }

@@Cykle:
 shl bl,1             {    1}
 jnc @@NextBitRe3     {     0 =>  }

 mov al,cl
 mov dx,base
 out dx,al           {    }

 mov al,SafeByte
 and al,not _SelectIn
 mov dx,control
 out dx,al       {   }
 out dx,al
 out dx,al    //  pause

 and al, not _strobe
 out dx,al     //  

 pusha
  xor eax,eax
  mov al,bh       {    }
  mov cx,100d
  mul cx          {    }
  call delay
 popa

 or al, _strobe
 out dx,al       { }
 out dx,al
 out dx,al    //  pause

 or al, _SelectIn
 out dx,al        //  +12V,  }

 mov ControlByte,al

  pusha
   mov eax,2
   call delay     {     +12V   }
  popa

@@NextBitRe3:
 dec cl
 cmp cl,0ffh          {  ?}
 jne @@Cykle

 mov al,SafeByte
 out dx,al       {}
end;
{------------------------------------------------}
procedure WriteOneByte;
const MaxWidth=7; //       
begin
Pulse :=1;
err:=$80; {   }
while (pulse <=MaxWidth) and (err <>0) do {          700 }
begin

if readByte(Count)=buffer[Count] then err:=0{      }
 else WriteByte((Count shl 16)+(buffer[Count] shl 8 )+Pulse);
 inc(Pulse);     {   }
 if (time=MaxWidth) and (err<>0) then {  ,   }
  begin
   err:=MessageDlg('  : '+BinHex(Count shl 8)+BinHex(Count and $FF)+' : '+binhex(buffer[count])+
    ' : '+BinHex(readByte(Count))+ ', ? ', mtError, [mbOk,mbNo,mbCancel], 0);
    case error of
    1: pulse:=1;  //  
    2: err:=0;    //    
    end;{case}
  end;  {if }
 end;{ while}
end;
{------------------------------------------------}

procedure Progres(a:cardinal);    {     }
begin
 re3_rt4.label1.caption:=':  '+BinHex(a shr 8)+ BinHex(a and $FF)+' '; 
end;
{--------------------------------------------------}

Procedure DisplayBuffer;  {     HEX }
var s:word;    {   }
    i:word;    {   }
begin

for i:=0 to (Chips.L div 16) do re3_rt4.ListBoxBufer.items[i]:=''; //  

s:=0;
 for i:=0 to Chips.L do
  begin
    re3_rt4.ListBoxBufer.items[s]:=re3_rt4.ListBoxBufer.items[s]+binhex(buffer[i])+' ';
   if (i and $0F) = 0 then { }
    re3_rt4.ListBoxBufer.items[s]:= binhex(i shr 8)+binhex(i and $ff)+' '+re3_rt4.ListBoxBufer.items[s];
   if (i and $0F) = $0F then inc(s);{  }
   end;
end;
{-------------------------------------------------------}
Procedure Verify;
var s:string;
begin
if not CompareP then MessageDlg('      ',mterror, [mbOk], 0)
 else
 begin
  err:=0;
  for count:=0 to Chips.L do if readbyte(count)<>buffer[Count] then inc(err); {  }
  str(err,s); {      }
  if err=0 then MessageDlg('   .',mtInformation, [mbOk], 0)
           else MessageDlg('    '+ s + ' !',mtError, [mbOk], 0);
 end;
end;
{-------------------  -----------------------------}
procedure Tre3_rt4.GameOverClick(Sender: TObject);
begin
SetSafe;
Halt;  {  }
end;
{-------------------------------------------------------}
procedure Tre3_rt4.InitDevice(Sender: TObject);
//   
begin
 SetSafe;
 Chips.L:=0;          //  
  for count := 0 to max div 16 do
   re3_rt4.ListBoxBufer.Items.Add(''); //    
end;
{-------------------------------------------------------}
procedure Tre3_rt4.ReadPROMClick(Sender: TObject);
begin
LoadP; //  
SetSafe;
CheckSum:=0;     //
BlankSum:=0;

for count:=0 to Chips.L do             {   }
begin
 Buffer[count]:=ReadByte(count) and Chips.w; //  (556T4)   D4..D7
 CheckSum:=CheckSum+Buffer[count]; //  
 BlankSum:=BlankSum+(Buffer[count] xor (Chips.B and Chips.W));  //     0
end;
 CheckSum:=CheckSum and $FFFF; //      
 if BlankSum =0
  then MessageDlg(' ', mtInformation, [mbOk], 0)
  else MessageDlg(' : '+binhex(CheckSum shr 8)+binhex(CheckSum and $ff)+'h', mtInformation, [mbOk], 0);
SetSafe;
DisplayBuffer;
end;
{-------------------------------------------------}
procedure Tre3_rt4.VerifyPROMClick(Sender: TObject);
begin
Verify;  {          
              }
end;
{-------------------------------------------------}

procedure Tre3_rt4.WritePROMClick(Sender: TObject); {   }
var bbb:byte;
begin
if not compareP then  MessageDlg('     ',mterror, [mbOk], 0)
else
 begin

//     .
//         

Count:=0;
Err:=0;
while (count<=chips.L) and (err=0) do
 begin
 bbb:=readByte(Count); //    PROM
 if chips.b = $0  then
   begin
    if bbb and (not buffer[Count]) <> 0 then err:=$FF;
   end
  else
   begin
    if (not bbb) and buffer[Count] <>0 then err:=$FF;         //   
   end;

 if err<>0 then
  begin
   if chips.b = 0
    then MessageDlg('  "0"  "1". A: '+BinHex(count shr 8)+BinHex(count and $FF)+'  : '+binhex(buffer[count])+
         '  : '+BinHex(readByte(Count)) , mtError, [mbOk], 0)
         else MessageDlg('  "1"  "0". A: '+BinHex(count shr 8)+BinHex(count and $FF)+'  : '+binhex(buffer[count])+
          '  : '+BinHex(readByte(Count)), mtError, [mbOk], 0);
   err:=$ff;  // 
  end;

 inc(count);  //   
end; // while

if err <>0 then exit ; //    

count:=0;         // 
 while Count <=  Chips.L do
 begin
  Progres(Chips.L-count);
  WriteOneByte;
  inc(count);
 end;

verify; {   }
  end;
end;

{-------------------------------------------------------}
procedure Tre3_rt4.SaveBClick(Sender: TObject);
var i:word;
begin
if Chips.L = 0  then
 begin
  MessageDlg('  ', mtError, [mbOk], 0);
  exit;
 end;

Err:=$80;     {    }

if SaveDialog.Execute then       {    }
 begin

  AssignFile(MyFile, SaveDialog.FileName);
  try
   Reset(MyFile);  {      }
  except
   Err:=$0;     {  ,   }
   end;
  end
  else exit;

if err<> 0 then    {   ,   }
 begin
  if MessageDlg('   !!! ???', mtError, [mbOk,mbNo], 0)=1
  then err:=0;
end;

{        }

  try
   Rewrite(MyFile);  {   }
  except
   Err:=$80;  {   }
   MessageDlg('   ', mtError, [mbOk], 0);
   end;
if err<>0 then exit;

 for i:=0 to Chips.L do write(myfile,Buffer[i]);  {   }
  CloseFile(MyFile);
  MessageDlg(' ', mtInformation, [mbOk], 0);
end;
{----------------------------------------------------}
procedure Tre3_rt4.LoadBClick(Sender: TObject);
begin

LoadP;      //        

Err:=$0;     {    }

if OpenDialog.Execute then       {    }
 begin
  AssignFile(MyFile, OpenDialog.FileName);
   try
    Reset(MyFile);  {      }
   except
    Err:=$80;     {  }
    MessageDlg('  !!!', mtError, [mbOk], 0);
   end;
  end;

if error <> 0  then exit;

{   ,   }

if filesize(MyFile)<>Chips.L+1 then
 begin
  MessageDlg('     !!!', mtError, [mbOk], 0);
  CloseFile(MyFile);
  exit;
 end;

CheckSum:=0;
BlankSum:=0;

for count:=0 to Chips.L do
 begin
  read (MyFile,buffer[count]); { }
  buffer[count]:=buffer[count] and Chips.W; {   }
  CheckSum:=CheckSum+Buffer[count];         //  
  BlankSum:=BlankSum+(Buffer[count] xor (Chips.B and Chips.W));  //     0
end;
 CheckSum:=CheckSum and $FFFF; //      
 if BlankSum =0
  then MessageDlg(' ', mtInformation, [mbOk], 0)
  else MessageDlg(' : '+binhex(CheckSum shr 8)+binhex(CheckSum and $ff)+'h', mtInformation, [mbOk], 0);

CloseFile(MyFile);
DisplayBuffer;
end;
{--------------------------------------------}

end.
