#ifndef __MACROS_H__
#define __MACROS_H__

# include "config.h"

# define BOOL int

# define SB_ICON_WIDTH 14
# define SB_ICON_HEIGHT 8
# define ICON_SIZE 19
# define ICON_BUFFER_LEN 1024
# define SEPARATOR_WIDTH 3

# define THREAD_STACKSIZE 16384

# define errors -1
# define no_errors 0

# define on  1
# define off 0

# define m_48k 0
# define m_128k 1

# define ERR_XI_FAILURE        0xFF
# define ERR_XI_OK             0x00
# define ERR_XI_NOSHAREDMEMORY 0x01
# define ERR_XI_DISPLAY        0x02
# define ERR_XI_BADDEPTH       0x03
# define ERR_XI_WINDOW         0x04
# define ERR_XI_VIRTALLOC      0x05
# define ERR_XI_XIMAGE         0x06
# define ERR_XI_SHMALLOC       0x07
# define ERR_XI_SHMXIMAGE      0x08
# define ERR_XI_SHMSEGINFO     0x09
# define ERR_XI_SHMVIRTALLOC   0x0A
# define ERR_XI_SHMATTACH      0x0B


# define SOUND_ARRAY_LEN 1000

# define MAX_OUTPUT 0x7fff
# define STEP 800

# define AY_AFINE	    (0)
# define AY_ACOARSE   (1)
# define AY_BFINE	    (2)
# define AY_BCOARSE   (3)
# define AY_CFINE	    (4)
# define AY_CCOARSE	 (5)
# define AY_NOISEPER  (6)
# define AY_ENABLE	 (7)
# define AY_AVOL	    (8)
# define AY_BVOL	    (9)
# define AY_CVOL	    (10)
# define AY_EFINE	    (11)
# define AY_ECOARSE	 (12)
# define AY_ESHAPE	 (13)
# define AY_PORTA	    (14)

# define BEEPER 255


# define ini_file_version_string "ugluk configuration file v1.24"
# define TAPE_MAX_BLOCKS 1000

# define TIMER_CONST 19

# define SOUND_TICKS_PER_FRAME_CONST 882
# define SOUND_TICKS_PER_FRAME_2_CONST 441
# define SOUND_TICKS_PER_FRAME_4_CONST 220
# define SOUND_TICKS_PER_FRAME_MAX 10000


#define IFF1 pz80.iff1
#define IFF2 pz80.iff2
#define IM pz80.im
#define halted pz80.halted
#define interrupts pz80.iff1

#define A   pz80.af.b.h
#define F   pz80.af.b.l
#define AF  pz80.af.w.w

#define B   pz80.bc.b.h
#define C   pz80.bc.b.l
#define BC  pz80.bc.w.w

#define D   pz80.de.b.h
#define E   pz80.de.b.l
#define DE  pz80.de.w.w

#define H   pz80.hl.b.h
#define L   pz80.hl.b.l
#define HL  pz80.hl.w.w

#define A_  pz80.af_.b.h
#define A1  pz80.af_.b.h
#define F_  pz80.af_.b.l
#define F1  pz80.af_.b.l
#define AF_ pz80.af_.w.w

#define B_  pz80.bc_.b.h
#define B1  pz80.bc_.b.h
#define C_  pz80.bc_.b.l
#define C1  pz80.bc_.b.l
#define BC_ pz80.bc_.w.w

#define D_  pz80.de_.b.h.
#define D1  pz80.de_.b.h
#define E_  pz80.de_.b.l
#define E1  pz80.de_.b.l
#define DE_ pz80.de_.w.w

#define H_  pz80.hl_.b.h
#define H1  pz80.hl_.b.h
#define L_  pz80.hl_.b.l
#define L1  pz80.hl_.b.l
#define HL_ pz80.hl_.w.w

#define IXH pz80.ix.b.h
#define IXL pz80.ix.b.l
#define IXh pz80.ix.b.h
#define IXl pz80.ix.b.l
#define IX  pz80.ix.w.w

#define IYH pz80.iy.b.h
#define IYL pz80.iy.b.l
#define IYh pz80.iy.b.h
#define IYl pz80.iy.b.l
#define IY  pz80.iy.w.w

#define SPH pz80.sp.b.h
#define SPL pz80.sp.b.l
#define SP  pz80.sp.w.w

#define PCH pz80.pc.b.h
#define PCL pz80.pc.b.l
#define PC  pz80.pc.w.w

#define I  pz80.i
#define R  pz80.r
#define R7 pz80.r7


#endif
