#ifndef __TYPEDEFS_H_
#define __TYPEDEFS_H_

# include "config.h"

#if !defined BIGENDIAN
typedef union {
	struct { unsigned char l, h; } b;
	struct { unsigned short w; }w;
} regpair;
#endif

#if defined BIGENDIAN
typedef union {
	struct { unsigned char h,  l; } b;
	struct { unsigned short w; }w;
} regpair;
#endif

typedef struct                                                                                
{                                                                                             
	unsigned d0 : 1;                                                                      
	unsigned d1 : 1;                                                                      
	unsigned d2 : 1;                                                                      
	unsigned d3 : 1;                                                                      
	unsigned d4 : 1;                                                                      
	unsigned u1 : 1;                                                                      
	unsigned tape : 1;                                                                    
	unsigned u2 : 1;                                                                      

} KeybPortType;   

typedef struct                                                                                
{                                                                                             
	unsigned right  : 1;                                                                  
	unsigned left   : 1;                                                                  
	unsigned down   : 1;                                                                  
	unsigned up     : 1;                                                                  
	unsigned fire   : 1;                                                                  
	unsigned unused : 3;                                                                  
} KepmstonType;     

typedef void (*handler) (
	Widget w,
	XtPointer client_data,
	XmPushButtonCallbackStruct * cbs );

typedef struct 
{
	unsigned long tcounter;
	unsigned char r;
	unsigned char v;
	unsigned int pos;
} AY8910_STEPS;

typedef struct
{
	unsigned char  bank;
	unsigned short addr;
	unsigned short value;
	unsigned char  old;
	void * next;
	int position;
} POKE_type;

typedef struct 
{
	char name [30];
	POKE_type * POKEs;
	void * next;
	int position;
} trainer_struct;

typedef struct 
{
	char filename[255];
	unsigned char type; /*0 - trd; 1 -fdi*/
	unsigned char trk;
	unsigned char ro;
} discs_type;

typedef struct
{
	unsigned b0  : 1;                                                                  
	unsigned b1  : 1;
	unsigned b2  : 1;
	unsigned b3  : 1;
	unsigned b4  : 1;
	unsigned b5  : 1;
	unsigned b6  : 1;
	unsigned b7  : 1;
} rs_type;

typedef struct
{
	unsigned char line;
	unsigned int y;
	int a;
} screen_type;

typedef struct
{
	unsigned short b[8];
} attrib_type;

typedef struct
{
	unsigned char FullScreen;
	unsigned char size;
	Position x,y;
#if defined XF86VMODE
	XF86VidModeModeInfo oldmode;
#endif
	int vpx, vpy;
} FsW;

typedef struct 
{
	unsigned char id;
	unsigned int len;
	unsigned int ilen;
	void * info;
	unsigned char * data1;
	int position;
	void * next;
}tape_struct;

typedef struct 
{
	unsigned short pause;
	unsigned short len;
} ROM_bl_type;

typedef struct
{
	unsigned short pilotL;
	unsigned short syncFL;
	unsigned short syncSL;
	unsigned short zeroL;
	unsigned short oneL;
	unsigned short pilot_toneL_inPulses;
	unsigned char  used_bits;
	unsigned short pause;
	unsigned char  l1, l2, l3;
} turbo_block_type;

typedef struct
{
	unsigned short len, n;
} Pure_toneT;

typedef struct
{
	unsigned short z, o;
	unsigned char used;
	unsigned short pause;
	unsigned char l1,l2,l3;
} Pure_dataT;

typedef struct 
{
	unsigned char type, id, value;
} hardwareT;

typedef struct 
{
	unsigned short TS;
	unsigned short pause;
	unsigned char used;
	unsigned char l1,l2,l3;
} direct_recT;

typedef struct 
{
	unsigned char major;	
	unsigned char minor;	
}zxtapeT;

typedef struct 
{
	void * data;
	void * data1;
	void * data2;
} messageT;

typedef struct 
{
	regpair af,bc,de,hl;
	regpair af_,bc_,de_,hl_;
	regpair ix,iy;
	unsigned char i,r,r7; 
	regpair sp,pc;
	unsigned char iff1,iff2,im;
	int halted;
} processor;

#endif
