#include "wd1793.hpp"
#define _WD1793_UNREAL_SELF_INCLUDE
#include "unreal_wd1793.h"

static WD1793 wd;

extern "C" {

unsigned char wd1793_in(unsigned char port, unsigned long long time, int *err)
{
	return(wd.in(port,time,err));
}

void wd1793_out(unsigned char port, unsigned char val, unsigned long long time, int *err)
{
	wd.out(port,val,time,err);
}

int wd1793_load_dimage(char *filename, int drive)
{
	return(wd.load_dimage(filename,drive));
}

void wd1793_eject_dimage(int drive)
{
	wd.eject_dimage(drive);
}

unsigned char wd1793_get_status_reg()
{
	return(wd.get_status_reg());
}

void wd1793_set_appendboot(char *boot_name)
{
	wd.set_appendboot(boot_name);
}

void wd1793_set_trd_interleave(int iv)
{
	wd.set_trd_interleave(iv);
}

void wd1793_set_nodelay(int nodelay)
{
	wd.set_nodelay(nodelay);
}

int wd1793_is_disk_changed(int drive)
{
	return(wd.is_disk_changed(drive));
}

int wd1793_save_dimage(char *filename, int drive, enum DIMAGE_TYPE type)
{
	return(wd.save_dimage(filename, drive, type));
}

extern int wd1793_is_disk_loaded(int drive)
{
	return(wd.is_disk_loaded(drive));
}

void wd1793_set_disk_wprotected(int drive, int wp)
{
	wd.set_disk_wprotected(drive, wp);
}

int wd1793_is_disk_wprotected(int drive)
{
	return(wd.is_disk_wprotected(drive));
}

}
