#ifndef _WD93_FDD__
#define _WD93_FDD__

#include <stdio.h>
#include "wd93_defs.h"
#include "wd93_trkcache.hpp"
#include "wd93_crc_utils.hpp"
#define _WD1793_UNREAL_SELF_INCLUDE
#include "unreal_wd1793.h"

enum DISKSNAP
{
   snHOB, snSCL, snTRD, snFDI, snTD0, snUDI, snUNKNOWN, snTOOLARGE, snNOFILE
};

struct FDD
{
	
   // drive data

   __int64 motor;       // 0 - not spinning, >0 - time when it'll stop
   unsigned char track; // head position

   // disk data

   unsigned char *rawdata;              // used in VirtualAlloc/VirtualFree
   unsigned rawsize;
   unsigned cyls, sides;
   unsigned trklen[MAX_CYLS][2];
   unsigned char *trkd[MAX_CYLS][2];
   unsigned char *trki[MAX_CYLS][2];
   unsigned char optype; // bits: 0-not modified, 1-write sector, 2-format track
   unsigned char snaptype;
   unsigned long snapsize;
   int is_wp;
   int interleave;

   TRKCACHE t; // used in read/write image
   char name[0x200];
   char dsc[0x200];
   TRKCACHE *trkcache;
   char appendboot[256];

   char test();
   
   void format_trd();
   void emptydisk();
   void newdisk(unsigned cyls, unsigned sides);
   int addfile(unsigned char *hdr, unsigned char *data);
   void addboot();
   unsigned char what_is(char *filename);

   int read(unsigned char snType);

   int read_scl();
   int read_hob();
   int read_trd();
   int write_trd(FILE *ff);
   int read_fdi();
   int write_fdi(FILE *ff);
   int read_td0();
   int write_td0(FILE *ff);
   int read_udi();
   int write_udi(FILE *ff);

   void set_trkcache(TRKCACHE *tc){trkcache=tc;};
   void free();
   
   //
   
   int is_wprotected(){return is_wp;};
   void set_wprotected(int wp){is_wp=wp;};
   int load_dimage(char *filename); /*load disk image*/
   int save_dimage(char *filename, enum DIMAGE_TYPE type);   
   char is_changed(); /*whether disk in drive has been changed*/
   void set_appendboot(char *boot_name); /*name for file with boot, or NULL*/
   char *get_appendboot(void){return(appendboot[0]? appendboot: NULL);};
   void set_trd_interleave(int iv){interleave=iv;};
   int is_disk_loaded(){return(cyls);};
   void eject(){free();};

   FDD(){trkcache=NULL;rawdata=NULL;set_wprotected(0);*appendboot='\0';interleave=1;};
   ~FDD() { free(); }
};

#endif
