#ifndef _WD93_TRKCACHE__
#define _WD93_TRKCACHE__

#include "wd93_const.h"
#include "wd93_defs.h"

struct FDD;

struct TRKCACHE
{
	  	
   // cached track position
   FDD *drive;
   unsigned cyl, side;

   // generic track data
   unsigned trklen;
   unsigned char *trkd, *trki;       // pointer to data inside UDI
   unsigned ts_byte;                 // cpu.t per byte
   SEEK_MODE sf;                     // flag: is sectors filled
   unsigned s;                       // no. of sectors

   // sectors on track
   SECHDR hdr[MAX_SEC];

   void set_i(unsigned pos) { trki[pos/8] |= 1 << (pos&7); }
   void clr_i(unsigned pos) { trki[pos/8] &= ~(1 << (pos&7)); }
   unsigned char test_i(unsigned pos) { return trki[pos/8] & (1 << (pos&7)); }
   void write(unsigned pos, unsigned char byte, char index) { trkd[pos] = byte; if (index) set_i(pos); else clr_i(pos); }

   void seek(FDD *d, unsigned cyl, unsigned side, SEEK_MODE fs);
   void format(); // before use, call seek(d,c,s,JUST_SEEK), set s and hdr[]
   int write_sector(unsigned sec, unsigned char *data); // call seek(d,c,s,LOAD_SECTORS)
   SECHDR *get_sector(unsigned sec); // before use, call fill(d,c,s,LOAD_SECTORS)

   void dump();
   void clear() { drive = 0; trkd = 0; }
   TRKCACHE() { clear(); }
};

#endif
