/* 
 # define FUSE_engine
*/

/*
# define log
*/

/*
 # define pedantic
*/


/*#define WD_DEBUG*/

#include <ctype.h>
#include "config.h"

# include <Xm/Xm.h>
# include <Xm/DialogS.h>
# include <Xm/PanedW.h>
# include <Xm/Form.h>
# include <Xm/Label.h>
# include <Xm/List.h>
# include <Xm/Text.h>
# include <Xm/PushB.h>
# include <Xm/ToggleB.h>
# include <Xm/Scale.h>
# include <Xm/ToggleBG.h>
# include <Xm/RowColumn.h>
# include <Xm/DrawnB.h>
# include <Xm/DrawingA.h>
# include <Xm/Separator.h>
# include <Xm/FileSB.h>
# include <Xm/MessageB.h>
# include <Xm/ArrowB.h>
# include <Xm/Frame.h>

# include <Xlib.h>
# include <extensions/XShm.h>
# include <keysym.h>
# include <xpm.h>

#if defined XF86VMODE
# include <extensions/xf86vmode.h>
#endif

#if defined LINUXAUDIO
# include <sys/soundcard.h>
#endif

# include <sys/ipc.h>
# include <sys/shm.h>
# include <sys/stat.h>
# include <sys/ioctl.h>
# include <sys/timeb.h>

# include <fcntl.h>
# include <pwd.h>
# include <stdio.h>
# include <stdarg.h>
# include <stdlib.h>
# include <unistd.h>
# include <signal.h>

# include "Tab.h"

#include "typedefs.h"
#include "macros.h"

#include "debug.h"

#include "unreal_wd1793.h"

/****************** variables **********************/

int blocking_popup_trig=0; /*dirty trick for doing "blocking" popups in motif*/
int gui_running=0;

char trdos_appendboot[500];

Widget Dialog;
Widget FullScreenB;
Widget networkB;
Widget ToolBar;
Widget first_window;

XtWorkProcId wpid=0;

char DirectStack[16384];

pid_t DirectPid=0;

unsigned char lastPort1ffdScOut;

unsigned char ram8[16384];
unsigned char ram9[16384];
unsigned char ramA[16384];
unsigned char ramB[16384];
unsigned char ramC[16384];
unsigned char ramD[16384];
unsigned char ramE[16384];
unsigned char ramF[16384];

unsigned char * new_rom;
unsigned char * new_ram;

Widget two_Scorpion=NULL, two_Pentagon=NULL, two_128=NULL, two_48=NULL;

#define DIRECT_RECORDING_BUFFER_SIZE 882
unsigned char direct_recording_buffer[DIRECT_RECORDING_BUFFER_SIZE];
unsigned int direct_recording_buffer_pos=(DIRECT_RECORDING_BUFFER_SIZE-1);

unsigned int direct_recording=0;

Widget Direct_TB;

int audio3;

unsigned int z80_spd_new;

unsigned int server=0;

unsigned char p_ff_in;

unsigned short XColors8_2[16];
unsigned char * XColors8_2_help;

unsigned short XColors16i[]=
{  
	0, 5, 10240, 10245, 288, 293, 10528, 10533,
	0, 6, 12288, 12294, 384, 390, 12672, 12678	
};

unsigned int XColors32i[]=
{
	(0<<11)+(0<<5)+0, (0<<16)+(0<<8)+38, (38<<16)+(0<<8)+0,
	(38<<16)+(0<<8)+38, (0<<16)+(38<<8)+0, (0<<16)+(38<<8)+38,
	(38<<16)+(38<<8)+0, (38<<16)+(38<<8)+38,

	(0<<11)+(0<<5)+0, (0<<16)+(0<<8)+51, (51<<16)+(0<<8)+0,
	(51<<16)+(0<<8)+51, (0<<16)+(51<<8)+0, (0<<16)+(51<<8)+51, 
	(51<<16)+(51<<8)+0, (51<<16)+(51<<8)+51
};

unsigned int XColors32[]=
{
	0, 191, 12517376, 12517567, 48896, 49087,	12566272, 12566463,
	0, 255, 16711680,	16711935, 65280, 65535, 16776960, 16777215
};

unsigned int XColors32_help[]=
{
	0, 0, 191, 191, 12517376, 12517376, 12517567, 12517567,
	48896, 48896, 49087, 49087,12566272, 12566272, 12566463, 12566463,
	0, 0, 255, 255, 16711680, 16711680,	16711935, 16711935,
	65280, 65280, 65535, 65535, 16776960, 16776960, 16777215, 16777215 
};

unsigned long long * XColors32_2;

unsigned short XColors15[]=
{  
	(0<<10)+(0<<5)+0,	(0<<10)+(0<<5)+25, (25<<10)+(0<<5)+0,
	(25<<10)+(0<<5)+25, (0<<10)+(25<<5)+0,	(0<<10)+(25<<5)+25,
	(25<<10)+(25<<5)+0, (25<<10)+(25<<5)+25,

	(0<<11)+(0<<5)+0,	(0<<11)+(0<<5)+63, 
	(unsigned short)((63<<11)+(0<<5)+0), 
	(unsigned short)((63<<11)+(0<<5)+63), 
	(0<<11)+(63<<5)+0,	(0<<11)+(63<<5)+31, (31<<11)+(63<<5)+0, 
	(31<<11)+(63<<5)+31
};

unsigned int XColors15_2[]=
{  
	65537*((0<<10)+(0<<5)+0), 65537*((0<<10)+(0<<5)+25), 
	65537*((25<<10)+(0<<5)+0), 65537*((25<<10)+(0<<5)+25), 
	65537*((0<<10)+(25<<5)+0),	65537*((0<<10)+(25<<5)+25),
	65537*((25<<10)+(25<<5)+0), 65537*((25<<10)+(25<<5)+25),

	65537*((0<<11)+(0<<5)+0),	65537*((0<<11)+(0<<5)+63), 
	(unsigned int)(65537*((unsigned int)((63<<11)+(0<<5)+0))), 
	(unsigned int)(65537*((unsigned int)((63<<11)+(0<<5)+63))), 
	65537*((0<<11)+(63<<5)+0),	65537*((0<<11)+(63<<5)+31), 
	(unsigned int)(65537*((unsigned int)((31<<11)+(63<<5)+0))), 
	(unsigned int)(65537*((unsigned int)((31<<11)+(63<<5)+31)))
};

unsigned short XColors16[]=
{  
	0, 25,  51200,  51225, 1504, 1529, 52704, (25<<11)+(47<<5)+25,
	0, 63, (unsigned short)129024, (unsigned short)129087, 2016, 
	2047, 65504, 65535
};

unsigned int XColors16_2[]=
{  
	0, 65537*25,  (unsigned int)65537*51200,  
	(unsigned int)65537*51225, 65537*1504, 65537*1529, 
	(unsigned int)65537*52704, (unsigned int)65537*((25<<11)+(47<<5)+25),
	0, 65537*63, (unsigned int)65537*(unsigned short)129024, 
	(unsigned int)65537*(unsigned short)129087, 65537*2016, 
	65537*2047, (unsigned int)65537*65504, (unsigned int)65537*65535
};

unsigned int NT_T_INT_LEN;
unsigned int NT_T_UP; /*(16+40)*224*/
unsigned int NT_T_LP; /*32+20*/
unsigned int NT_T_RP; /*12*/
unsigned int NT_T_DP; /*48*224*/

Widget four1, four1_ena;

char DumpAudioFileName[256];

Widget DumpAudioButton;

int direct_mic=0;

unsigned int tapeMIC_pos_prev=0;

unsigned int z80_speed_calculated;
unsigned int z80_speed_saved=0;

unsigned int z80_max_spd=0;
unsigned int tape_loading_method=0;

Widget tapedrc;

int turbo_speedTL=0;

Widget tape_saveFB;

int tape_paused=0;

Boolean tape_readonly=False;
char * tape_type;

Widget tape_saveAs;
Widget tape_status;

signed short tape_rew_counter;
const short tape_rew_counter_const=3500000/44100;

unsigned char tape[10*1024*1024*2];
unsigned char tapeS[10*1024*1024*2];

# define tapeMIC_max 10*1024*1024
unsigned char tapeMIC[tapeMIC_max];
unsigned int tapeMIC_pos=0;

unsigned int tape_pos=0, tape_len=0; 

tape_struct * tape_next=NULL;

pid_t mainpid;

messageT message;

int ready=0;

Widget tape_delete, tape_view;

tape_struct * tapes=NULL;

char tape_filename[255]={0};

pid_t tape_sc_ROM_pid=0;

Widget tape_ezhe_sep;

Window tape_sc_lev_win;
Dimension tape_sc_lev_x, tape_sc_lev_y;

Widget tape_sc_lev;

Widget tape_s1, tape_rc_rc2;
Widget tape_rc1, tape_rc3;
Widget tape_eject;
Widget tape_sc_label, tape_sc_ROMb, tape_sc_rec;
Widget tape_em_rec;
Widget tape_separator;
Widget tape_q, tape_dev_label, tape_dev_button;
Widget tape_sep1, tape_sep2;
Widget tape_dev;
Widget tape_play, tape_pause, tape_stop;
Widget tape_lb;

int tape_traps=1;

Widget MC_RC;

Widget disk1ro, disk2ro, disk3ro, disk4ro;

int scan=off;

unsigned short vvs16[640*480];

int interpolyatsia=off;

char predefined_freqs[255];
int kempston_mouse;
int leds_global;

unsigned char avol_max=0, bvol_max=0, cvol_max=0;

unsigned char Atone;
unsigned char Anoice;

unsigned char Btone;
unsigned char Bnoice;

unsigned char Ctone;
unsigned char Cnoice;

Window ledsWindow;
int ledsY;

unsigned long long cmd_done=0;

FsW WindowedModeStorage;

unsigned char ParityTBL[256];

int showQTape=0;
int showFloppik=0;

int logit=2;

int SOUND_TICKS_PER_FRAME;
int SOUND_TICKS_PER_FRAME_2;
int SOUND_TICKS_PER_FRAME_4;

screen_type XLib_Help_Array_Screen [6144];
attrib_type XLib_Help_Array_Attrib [768];

int XLib=on;

Widget liteClue;

int towrite=0;
int towriteaddr;

int pointer;
int side;

unsigned char track[655360];
unsigned char * toread;
unsigned int toread_num=0;
unsigned int toread_position=0;
unsigned char six_bytes[6];

discs_type discs[4];

int TRDOS=off;

trainer_struct * trainers=NULL;

unsigned int beeper_volume=12;
unsigned short bpr=0; 

unsigned char up, holded;
unsigned char env_volume;
unsigned char cont,att,alt,hold;

unsigned short sound_buffer[SOUND_TICKS_PER_FRAME_MAX*2*2]; /* 2 kanala */
unsigned short sound_bufferD[SOUND_TICKS_PER_FRAME_MAX*2*2]; /* 2 kanala */

unsigned short soundA[SOUND_TICKS_PER_FRAME_MAX*2];
unsigned short soundB[SOUND_TICKS_PER_FRAME_MAX*2];
unsigned short soundC[SOUND_TICKS_PER_FRAME_MAX*2];

unsigned short beeper_buffer[SOUND_TICKS_PER_FRAME_MAX*2];

unsigned char channelA_enabled;
unsigned char channelB_enabled;
unsigned char channelC_enabled;

unsigned char noiseA_enabled;
unsigned char noiseB_enabled;
unsigned char noiseC_enabled;

unsigned int GeneratorA_period;
unsigned int GeneratorB_period;
unsigned int GeneratorC_period;

unsigned int GeneratorA_counter;
unsigned int GeneratorB_counter;
unsigned int GeneratorC_counter;

unsigned int NoiceA_counter;
unsigned int NoiceB_counter;
unsigned int NoiceC_counter;

long int rndA;
long int rndB;
long int rndC;

unsigned int PeriodN, periodE;
unsigned int Envelope_counter;

unsigned short * mixing_ch[10];

int sound_fil=-1;

int PSGcounter=0;
AY8910_STEPS PSGARRAY[SOUND_ARRAY_LEN];		

unsigned int UpdateStep;
int register_latch;
unsigned char Regs[16];
unsigned char Regs1[16];
unsigned short VolTable[16]=
{
	0x0000/2, 0x0344/2, 0x04BC/2, 0x06ED/2, 
	0x0A3B/2, 0x0F23/2, 0x1515/2, 0x2277/2, 
	0x2898/2, 0x4142/2, 0x5B2B/2, 0x726C/2, 
	0x9069/2, 0xB555/2, 0xD79B/2, 0xFFFF/2 
};

XmFontList fontlist1;
XmFontList fontlist2;

int PaletteMW[]= { 

	0x00,0x00,0x00,
	0x00,0x00,0xbf,
	0xbf,0x00,0x00,
	0xbf,0x00,0xbf,

	0x00,0xbf,0x00,
	0x00,0xbf,0xbf,
	0xbf,0xbf,0x00,
	0xbf,0xbf,0xbf,

	0x00,0x00,0x00,
	0x00,0x00,0xff,
	0xff,0x00,0x00,
	0xff,0x00,0xff,

	0x00,0xff,0x00,
	0x00,0xff,0xff,
	0xff,0xff,0x00,
	0xff,0xff,0xff,

	-1,-1,-1};


int Paletteleds[]= {128,0,128, 0,128,0, -1,-1,-1};

int Palettelev[]= {
	127,127,127, 
	000,  0,200, 
	000,  0,200,
	255,  0,  0,
	000,  0,  0,
	-01, -1, -1};

unsigned long * paletteMW;
unsigned long * paletteleds;
unsigned long * palettelev;

GC gcMW;
GC gcleds;
GC gclev;

unsigned char last_tape_out;
int vz80;

char audio_name[255];
int audio;

char sound_device_nameR[255];
int audio2;

char filenameT[255];
char tstring[300];

int depth;

int timeout=TIMER_CONST;
int timerid;
int not_draw_start;
int not_draw;
int joy_type; /* 0-kempston; 1-sinclair*/
int sound;

unsigned char colors[16];
XColor color[256];

char inifilepath[255];

unsigned int Sound_Freq;
unsigned char stereo_mode=0; /* 2=Mono 1=ABC 0=ACB*/
unsigned int emulator_speed=100;
char stereo_mode_string[32];
char start_directory[255];
char tape_directory[255];
char disk_directory[255];
char pok_directory[255];
char quick_snapshot_name[255];
int  refresh_fr;
char joystick_type[32];
char Mode[32];
int screen_size;

int ay_sound;

XtAppContext app_context;

Arg args [20];
int n;

Display * display;

Pixmap px_up,aaa;
Pixmap emu_go, emu_pause;
Pixmap p_48, p_128;
Pixmap p_tape, p_trd, p_dump_s;

Widget appshell;
Widget drawing_a=0;
Widget emu_go_pause_b;
Widget tounmanage=NULL; 
Widget tounmanage1=NULL;
Widget pane, form;
Widget scale=0, scale1=0, scale2;
Widget status_bar;
Widget show_mode;
Widget show_trd;
Widget show_dump_s;
Widget tdes, tdet; 
Widget new_trainer_name;
Widget cbb;
Widget p_bank, p_addr, p_value, p_old;
Widget p_bank_edt, p_addr_edt, p_value_edt, p_old_edt;
Widget poke_value_enetered;
Widget new_trainer_name_edt;
Widget show_tape;
Widget dan, dbn, dcn, ddn; 
Widget ss_slider, ss_dev;
Widget ww1,two1,three1;
Widget leds;

Widget main_window;

long KEY;
XEvent ev;

int emu_paused=off;
int tape_stopped=on;

int screen_created=0;

unsigned char last7ffdout;

unsigned char data_bus=255;

processor pz80;

unsigned char A2, B2, C2, D2, E2, F2, H2, L2;
unsigned short HL1_1;
unsigned short XX;

unsigned char border;

KeybPortType f7fe, fbfe, fdfe, fefe, effe, dffe, bffe, sffe;

union
{
	unsigned char byte;
	KepmstonType bit;
} kempston;

unsigned char CPU12[49152];

unsigned char RAM0[16384];
unsigned char RAM1[16384];
unsigned char RAM3[16384];
unsigned char RAM4[16384];
unsigned char RAM6[16384];
unsigned char RAM7[16384];

unsigned char ROM0[16384];
unsigned char ROM1[16384];
unsigned char ROMTRD[16384];
unsigned char ROMSCRP[16384];

unsigned char mode;


unsigned char * screen48;
unsigned char * attrib48;

unsigned char * RAM5;
unsigned char * RAM2;

/*Display * display;*/
Window w;

unsigned char * videomemory;
XShmSegmentInfo *shmseginfo;
Pixmap pixmap;

int rk=0;
int flashcounter=0;
int rb,rc;
int ri;
int rf,rt,rr;
short * vs16;

unsigned char * vs8;
int * vs32;
int vvs32[640*480];

unsigned int tcounter=0; /*amount of CPU tacts since start*/
unsigned long long tcounter_long=0; /*amount of CPU tacts since start (big)*/


/******** xzx ********/

unsigned short work16;
unsigned char work8;
unsigned int work32;
unsigned char val;
unsigned short reg;
int idx;

int sub_hcarry_tbl[] = { 0, 1, 1, 1, 0, 0, 0, 1 };
int sub_overflow_tbl[] = { 0, 0, 0, 1, 1, 0, 0, 0 };
int hcarry_tbl[] = { 0, 0, 1, 0, 1, 0, 1, 1 };
int overflow_tbl[] = { 0, 1, 0, 0, 0, 0, 1, 0 };
/***********************/

/******** fuse ***********/
unsigned char add;
unsigned char carry;
/*************************/

char * ERR_XI_STR[] =
{
	"X initialisation OK!",
	"No Shared Memory available", 
	"cannot open Display", 
	"bad color depth",
	"can't create Window", 
	"can't alloc memory for virtual screen",
	"cannot create XImage",
	"can't alloc memory for Shared memory segment info",
	"cannot create Shared Memory XImage",
	"Shared memory segment info error",
	"Shared memory virtual screen allocation failed",
	"cannot attach Shared Memory segment to display"
};

int XShmMajor,XShmMinor;
Bool XShmPixmaps;

unsigned char ferv;
unsigned char fer1;

void ExitWithError(unsigned char numerr, char * txt);
void timerfunc(void);
void SetIconOnButton(Pixmap icon, Widget button);
void MessageBoxEx(char * string);
void SaveZ80(char * path);
void Exiting(void * p);
void MessageBoxOkCan(XtCallbackProc okproc, XtPointer ok_cb_data, XtCallbackProc canproc, char * string);
void cancel_selected_in_message_box(Widget, XtPointer, XmPushButtonCallbackStruct *);
void Set_z80times_per_line(unsigned int);
void emu_go_pause_h(Widget, XtPointer, XmPushButtonCallbackStruct *);
void MessageBoxErr(char * string);
void MessageBoxInfo(char * string);
void MessageBoxOverwrite(XtCallbackProc o_func, void *);
void FixHeight(Widget w);
void key_pressed(Widget, XtPointer, XmDrawingAreaCallbackStruct *);
void gotfocus(Widget , XtPointer, XEvent *, Boolean *);
void lostfocus(Widget , XtPointer, XEvent *, Boolean *);
void FixWidth(Widget w);
void UpdateSoundBuffer(void);
void ApplySoundRegister(int r, int v);
void CloseDialog(Widget, XtPointer, XmPushButtonCallbackStruct *);

int FileExists(char * arg);
int CreateThread(int (*fn)(void *), void *data);
int SoundcardInit(int);
void ApplyPoke(POKE_type * p, char * trainer_name);
trainer_struct * FindTrainer(int num);
void clear_timer(void);
void PrintSpInfo();
void InitToolTips(void);
void init_timer(void);
void AddToolTip(Widget w, char * string);
void reDrawAllScreen(void);
void reDrawFlashed(void);
int  z80a(int);
unsigned long long GetCurrentTime(void);
unsigned char IsCDNReady(void);
//static XtArgVal GetPixel(char * colorstr);
void drawing_events_leds(Widget, XtPointer, XmDrawingAreaCallbackStruct *);
void drawing_events(Widget, XtPointer, XmDrawingAreaCallbackStruct *);
void tape_IsPlayable(tape_struct * t);
tape_struct * FindTapeByPosition(int p);
unsigned char b2bget(unsigned char * otkuda, unsigned int pos);
void DisableWidget(Widget w);
void EnableWidget(Widget w);
void AddTapeBlock(char * arg1, unsigned char id, unsigned int len, unsigned char * data, int ilen, void * info, int show);
void tape_pauseF (Widget, XtPointer, XmPushButtonCallbackStruct *);
void tape_SetActiveAndPause(tape_struct * arg);
char * tape_GAInfo1st(unsigned char * arg);
void Zamolchi(void);
tape_struct * TapeFindParent(tape_struct * arg);
void tape_IsPlayableV(tape_struct * t);
void setZ80spd_100(Widget, XtPointer, XmPushButtonCallbackStruct *);
void WorkWithBuffer(unsigned char * buffer,unsigned long filelen);
void RecoveryTape(int tape_RAM, unsigned char * tape_buffer);
void WorkWithBuffer2(unsigned char * buffer, unsigned long filelen);
void tape_stopF(Widget, XtPointer, XmPushButtonCallbackStruct *);
void NajatKnopku(Widget W, int Najat);
void lpf(unsigned char * b, int len);
void ScorpionSetPage(void);
void ReadTZX(char * filename);
void ReadTAP(char * filename);
void ReadWAV(char * filename);
Boolean video(XtPointer unused);
void byteswp(unsigned char * arg);
void save_disk_as(Widget w, int n, XmFileSelectionBoxCallbackStruct *cbs);
void disk_SaveAsDialog(Widget w, int n, XmPushButtonCallbackStruct *cbs);
int AskModal(Widget parent, char *question, char *first/*yes*/, char *second/*no*/);


char *get_file_ext(char *filename)
{
	char *ext;
	if(filename==NULL) return(NULL);
	
	for(ext = filename+strlen(filename);(ext > filename) && *ext!='.';ext--);
		
	if(*ext!='.') return(NULL);
	else return(ext+1);
}

/*convert integer to binary*/
char *int2bin(unsigned decimal)
{
        int  k = 0, n = 0;
        int  remain;
        char temp[80];
	static char binary[100];
	
        do
        {
                remain    = decimal % 2;
                decimal   = decimal / 2;   // whittle down decimal
                temp[k++] = remain + 0x30; // makes characters 0 or 1
        } while (decimal > 0);

        while (k >= 0)
        {
                binary[n++] = temp[--k];   // reverse spelling
        }
        binary[n-1] = 0;             // end with NULL
		
	return(binary);
}


/**************** Interesno, pochemu etogo prototipa net v LessTife ???  ********/
void XtMoveWidget(Widget w, Position x, Position y);
/********************************************************************************/


/*
__inline__ unsigned long long int rdtsc()
{
	unsigned long long int x;
	__asm__ volatile (".byte 0x0f, 0x31" : "=A" (x));
	return x;
}
*/

void SetSOUND_TICKS_PER_FRAME(void)
{
	double koef;


	koef=(double)timeout/(double)TIMER_CONST;

	SOUND_TICKS_PER_FRAME=(double)SOUND_TICKS_PER_FRAME_CONST*koef;
	SOUND_TICKS_PER_FRAME_2=(double)SOUND_TICKS_PER_FRAME_2_CONST*koef;
	SOUND_TICKS_PER_FRAME_4=(double)SOUND_TICKS_PER_FRAME_4_CONST*koef;

	if (SOUND_TICKS_PER_FRAME>SOUND_TICKS_PER_FRAME_MAX)
		SOUND_TICKS_PER_FRAME=SOUND_TICKS_PER_FRAME_MAX;
	if (SOUND_TICKS_PER_FRAME_2>SOUND_TICKS_PER_FRAME_MAX)
		SOUND_TICKS_PER_FRAME_2=SOUND_TICKS_PER_FRAME_MAX;
	if (SOUND_TICKS_PER_FRAME_4>SOUND_TICKS_PER_FRAME_MAX)
		SOUND_TICKS_PER_FRAME_4=SOUND_TICKS_PER_FRAME_MAX;
}

void AYWriteRegNV(int r, int v)
{
	if ((!sound)&&(sound_fil==-1)) return;

	if (PSGcounter==SOUND_ARRAY_LEN)
		return;

	PSGARRAY[PSGcounter].tcounter=tcounter;
	PSGARRAY[PSGcounter].r=r;
	PSGARRAY[PSGcounter].v=v;

	PSGcounter++;
}

void AYWriteReg(int r, int v)
{
	if (r > 15) return;

	Regs[r] = v;

	if ((!sound)&&(sound_fil==-1)) return;

	if (PSGcounter==SOUND_ARRAY_LEN)
		return;

	PSGARRAY[PSGcounter].tcounter=tcounter;
	PSGARRAY[PSGcounter].r=r;
	PSGARRAY[PSGcounter].v=v;

	PSGcounter++;
}

#define ex(h,l) (h*256+l) 

unsigned char ReadByte(unsigned short address)
{
	if ((address>=16384)&&(address<49152))
		return(CPU12[address]);

	if (address>=49152)
		return(new_ram[address-49152]);

	if (TRDOS) 
		return(ROMTRD[address]);

	return(new_rom[address]);
}


void PrintSpInfo(void)
{
#if defined log
	printf("PC%04X [PC]%02X%02X%02X%02X [HL]%02X%02X%02X [SP-2]%02X%02X%02X%02X%02X [IX-2]%02X%02X%02X%02X%02X [IY-2]%02X%02X%02X%02X%02X AF%04X BC%04X DE%04X HL%04X SP%04X IX%04X IY%04X [3C00]%02X%02X\n",
		PC,
		ReadByte(PC),   ReadByte(PC+1), ReadByte(PC+2), ReadByte(PC+3),
		ReadByte(HL),   ReadByte(HL+1), ReadByte(HL+2),
		ReadByte(SP-2), ReadByte(SP-1), ReadByte(SP),   ReadByte(SP+1), ReadByte(SP+2),
		ReadByte(IX-2), ReadByte(IX-1), ReadByte(IX),   ReadByte(IX+1), ReadByte(IX+2),
		ReadByte(IY-2), ReadByte(IY-1) ,ReadByte(IY),   ReadByte(IY+1), ReadByte(IY+2),
		AF, BC, DE, HL, SP, IX, IY,
		ReadByte(0x3C00),   ReadByte(0x3C01)
	);
#endif

#if !defined log	
	printf("PC:%4x RAM[PC]:%2x RAM[PC+1]:%2x RAM[PC+2]:%2x BC=%4x DE=%4x HL=%4x IX=%4x IY=%4x A=%2X R=%2X\n",PC,ReadByte(PC),ReadByte(PC+1),ReadByte(PC+2),BC,DE,HL,IX,IY,A,R);	
#endif	
}


XPoint points[32];
void DrawDoublePoints(int n, XPoint * p)
{
	int i;

	for (i=0; i<n ;i++)
	{	
		points[i*4+0].x=p[i].x*2;
		points[i*4+0].y=p[i].y*2;

		points[i*4+1].x=p[i].x*2+1;
		points[i*4+1].y=p[i].y*2;

		points[i*4+2].x=p[i].x*2;
		points[i*4+2].y=p[i].y*2+1;

		points[i*4+3].x=p[i].x*2+1;
		points[i*4+3].y=p[i].y*2+1;
	}

	XDrawPoints(display,w,gcMW,points,n*4,CoordModeOrigin);
}


int line;
unsigned char mask;

int npointsT;
int npointsF;

XPoint pointsT[8];
XPoint pointsF[8];

void Draw8Pix(unsigned short addr, unsigned char prevbyte,  unsigned char byte, int all_t_f)
{
	ri=XLib_Help_Array_Screen[addr].y;
	line=XLib_Help_Array_Screen[addr].line;
	mask=prevbyte^byte;
	rc=XLib_Help_Array_Screen[addr].a;

	npointsT=0; npointsF=0;

	if (attrib48[rc]&64)
	{
		rt=(attrib48[rc]&7)+8;
		rf=(attrib48[rc]&56)/8+8;
	}
	else
	{
		rt=attrib48[rc]&7;
		rf=(attrib48[rc]&56)/8;
	}

	if (attrib48[rc]&128)
	{
		if (flashcounter>15)
		{
			rr=rf;
			rf=rt;
			rt=rr;
		}
	}

	/************* zapolnyaem massivi tochek  ******************/
	if (mask&128)
	{
		if (byte&128)
		{
			pointsT[npointsT].x=ri;
			pointsT[npointsT].y=line;
			npointsT++;
		}
		else
		{
			pointsF[npointsF].x=ri;
			pointsF[npointsF].y=line;
			npointsF++;
		}
	}
	ri++;

	if (mask&64)
	{
		if (byte&64)
		{
			pointsT[npointsT].x=ri;
			pointsT[npointsT].y=line;
			npointsT++;
		}
		else
		{
			pointsF[npointsF].x=ri;
			pointsF[npointsF].y=line;
			npointsF++;
		}
	}
	ri++;

	if (mask&32)
	{
		if (byte&32)
		{
			pointsT[npointsT].x=ri;
			pointsT[npointsT].y=line;
			npointsT++;
		}
		else
		{
			pointsF[npointsF].x=ri;
			pointsF[npointsF].y=line;
			npointsF++;
		}
	}
	ri++;

	if (mask&16)
	{
		if (byte&16)
		{
			pointsT[npointsT].x=ri;
			pointsT[npointsT].y=line;
			npointsT++;
		}
		else
		{
			pointsF[npointsF].x=ri;
			pointsF[npointsF].y=line;
			npointsF++;
		}
	}
	ri++;

	if (mask&8)
	{
		if (byte&8)
		{
			pointsT[npointsT].x=ri;
			pointsT[npointsT].y=line;
			npointsT++;
		}
		else
		{
			pointsF[npointsF].x=ri;
			pointsF[npointsF].y=line;
			npointsF++;
		}
	}
	ri++;

	if (mask&4)
	{
		if (byte&4)
		{
			pointsT[npointsT].x=ri;
			pointsT[npointsT].y=line;
			npointsT++;
		}
		else
		{
			pointsF[npointsF].x=ri;
			pointsF[npointsF].y=line;
			npointsF++;
		}
	}
	ri++;

	if (mask&2)
	{
		if (byte&2)
		{
			pointsT[npointsT].x=ri;
			pointsT[npointsT].y=line;
			npointsT++;
		}
		else
		{
			pointsF[npointsF].x=ri;
			pointsF[npointsF].y=line;
			npointsF++;
		}
	}
	ri++;

	if (mask&1)
	{
		if (byte&1)
		{
			pointsT[npointsT].x=ri;
			pointsT[npointsT].y=line;
			npointsT++;
		}
		else
		{
			pointsF[npointsF].x=ri;
			pointsF[npointsF].y=line;
			npointsF++;
		}
	}


	/*****************  risuem tochki  ***************/
	if (npointsT&&((all_t_f==0)||(all_t_f==1)))	
	{
		XSetForeground(display,gcMW,paletteMW[rt]);

		if (screen_size==1)
			XDrawPoints(display,w,gcMW,pointsT,npointsT,CoordModeOrigin);
		else
			DrawDoublePoints(npointsT, pointsT);
	}

	if (npointsF&&((all_t_f==0)||(all_t_f==2)))	
	{
		XSetForeground(display,gcMW,paletteMW[rf]);

		if (screen_size==1)
			XDrawPoints(display,w,gcMW,pointsF,npointsF,CoordModeOrigin);
		else
			DrawDoublePoints(npointsF, pointsF);
	}	
}

void Draw64Pix(unsigned short addr, unsigned char prevbyte,  unsigned char byte)
{
	int i;


	if (prevbyte==byte) return;

	if (byte&&128) goto LPAC;
	if ((prevbyte&64)!=(byte&64)) goto LPAC;

	if ((prevbyte&7)!=(byte&7))
	{
		for (i=0; i<8; i++)
			Draw8Pix(XLib_Help_Array_Attrib[addr].b[i],~screen48[XLib_Help_Array_Attrib[addr].b[i]],screen48[XLib_Help_Array_Attrib[addr].b[i]],1);
	}

	if ((prevbyte&56)!=(byte&56))
	{
		for (i=0; i<8; i++)
			Draw8Pix(XLib_Help_Array_Attrib[addr].b[i],~screen48[XLib_Help_Array_Attrib[addr].b[i]],screen48[XLib_Help_Array_Attrib[addr].b[i]],2);
	}

	return;

LPAC:
	for (i=0; i<8; i++)
		Draw8Pix(XLib_Help_Array_Attrib[addr].b[i],~screen48[XLib_Help_Array_Attrib[addr].b[i]],screen48[XLib_Help_Array_Attrib[addr].b[i]],0);
}

unsigned char prevbyte;
void WriteByte(unsigned short address, unsigned char byte)
{
	if ((address>=16384)&&(address<49152))
	{
		if (XLib)
		{
			if(!(last7ffdout&8))
			{	
				if (address<23296)
				{
					prevbyte=CPU12[address];
					CPU12[address]=byte;

					if (address<22528)
						Draw8Pix(address-16384, prevbyte, byte, 0);
					else
						Draw64Pix(address-22528, prevbyte, byte);
				}
			}
		}	

		CPU12[address]=byte;

		return;
	}	

	if (address>=49152)
	{
		if (XLib)
		{
			if(last7ffdout&8)
			{	
				if (address<56064)
				{
					prevbyte=RAM7[address-49152];
					RAM7[address-49152]=byte;

					if (address<55296)
						Draw8Pix(address-49152, prevbyte, byte, 0);
					else
						Draw64Pix(address-55296, prevbyte, byte);
				}
			}
		}

		new_ram[address-49152]=byte;
	}

	if (new_rom==RAM0)
		RAM0[address]=byte;
}

void ExitWithError(unsigned char numerr, char * txt)
{
	clear_timer();


	printf("\n%s\nExiting.\n",txt);
	PrintSpInfo();

	exit(numerr);
}

unsigned char * GiveAddrW1(unsigned short address)
{
	if ((address>=16383)&&(address<49152))
		return(&CPU12[address]);

	if (address>=49152)
		return(&new_ram[address-49152]);


	printf("GiveAddrW : end of function. This is bug. Report it.\n");
	return(&CPU12[16384]);
}

void InitKempston(void)
{
	kempston.bit.left=0;
	kempston.bit.right=0;
	kempston.bit.up=0;
	kempston.bit.down=0;
	kempston.bit.fire=0;
	kempston.bit.unused=0;
}

#define MapROM0 new_rom=ROM0
#define MapROM1 new_rom=ROM1

void z80Reset(void)
{
	A=F=B=C=D=E=H=L=A1=F1=B1=C1=D1=E1=H1=L1=0;
	IX=IY=SP=PC=0;
	interrupts=off;
	IM=0;
	halted=off;
	I=0;

	TRDOS=off;
}

void Set48kMode()
{
	mode=m_48k;
	SetIconOnButton(p_48,show_mode);
}

void Set128kMode()
{
	mode=m_128k;
	SetIconOnButton(p_128,show_mode);
}

int Load128ROMs (void)
{
	int fil;

	fil=open(ROMPATH"/128.rom",O_RDONLY);

	if (fil==-1)
		return(errors);

	if (read(fil,ROM0,16384)!=16384)
	{
		close(fil);
		return(errors);
	}
	

	if (read(fil,ROM1,16384)!=16384)
	{
		close(fil);
		return(errors);
	}

	close(fil);

	return(no_errors);
}

int Load48ROMs(void)
{
	int fil;


	fil=open(ROMPATH"/48.rom",O_RDONLY);

	if (fil==-1)
	{
		printf("can't open 48.rom\n");
		return(errors);
	}

	if (read(fil,ROM0,16384)!=16384)
	{
		printf("read(fil,ROM0,16384)!=16384\n");

		close(fil);
		return(errors);
	}

	lseek(fil,0,SEEK_SET);

	if (read(fil,ROM1,16384)!=16384)
	{
		printf("read(fil,ROM1,16384)!=16384\n");

		close(fil);
		return(errors);
	}

	close(fil);

	return(no_errors);
}

int LoadPentagonROMs(void)
{
	int fil;

	fil=open(ROMPATH"/128p.rom",O_RDONLY);

	if (fil==-1)
		return(errors);

	if (read(fil,ROM0,16384)!=16384)
	{
		close(fil);
		return(errors);
	}

	if (read(fil,ROM1,16384)!=16384)
	{
		close(fil);
		return(errors);
	}

	close(fil);

	fil=open(ROMPATH"/trdos.rom",O_RDONLY);

	if (fil==-1)
		return(errors);

	if (read(fil,ROMTRD,16384)!=16384)
	{
		close(fil);
		return(errors);
	}

	close(fil);

	return(no_errors);
}

int LoadScorpionROMs(void)
{
	int fil;

	fil=open(ROMPATH"/scorpion.rom",O_RDONLY);

	if (fil==-1)
		return(errors);

	if (read(fil,ROM0,16384)!=16384)
	{
		close(fil);
		return(errors);
	}

	if (read(fil,ROM1,16384)!=16384)
	{
		close(fil);
		return(errors);
	}

	if (read(fil,ROMSCRP,16384)!=16384)
	{
		close(fil);
		return(errors);
	}

	if (read(fil,ROMTRD,16384)!=16384)
	{
		close(fil);
		return(errors);
	}


	close(fil);

	return(no_errors);
}

int Reset(void)
{
	Zamolchi();

	if (strcasecmp(Mode,"128")==0)
	{
		if (Load128ROMs()==errors)
		{
			printf("Can't load ROM Image.\n");
			return(errors);
		}
		Set128kMode();
	}

	if (strcasecmp(Mode,"48")==0)
	{
		if (Load48ROMs()==errors)
		{
			printf("Can't load ROM Image.\n");
			return(errors);
		}
		Set48kMode();
	}

	if (strcasecmp(Mode,"Pentagon")==0)
	{
		if (LoadPentagonROMs()==errors)
		{
			printf("Can't load ROM Image.\n");
			return(errors);
		}
		Set128kMode();
	}

	if (strcasecmp(Mode,"Scorpion")==0)
	{
		lastPort1ffdScOut=0;

		if (LoadScorpionROMs()==errors)
		{
			printf("Can't load ROM Image.\n");
			return(errors);
		}
		Set128kMode();
	}

	screen48=&CPU12[16384];
	attrib48=&CPU12[22528];

	z80Reset();
	MapROM0;

	border=7;
	data_bus=255;

	setZ80spd_100(NULL, (XtPointer)35, NULL);

	return(no_errors);
}

void ClearKeyPort(KeybPortType * p)
{
	p->d0=1;
	p->d1=1;
	p->d2=1;
	p->d3=1;
	p->d4=1;
	p->u1=1;
	p->u2=1;
	p->tape=1;
}

void ClearKeyboard(void)
{
	ClearKeyPort(&f7fe);
	ClearKeyPort(&fbfe);
	ClearKeyPort(&fdfe);
	ClearKeyPort(&fefe);
	ClearKeyPort(&effe);
	ClearKeyPort(&dffe);
	ClearKeyPort(&bffe);
	ClearKeyPort(&sffe);
}

void Set48Screen()
{
	screen48=&CPU12[16384];
	attrib48=&CPU12[22528];
}

int Spectrum_Init(void)
{
	screen48=&CPU12[16384];
	attrib48=&CPU12[22528];

	RAM5=&CPU12[16384];
	RAM2=&CPU12[32768];

	new_ram=RAM0;

	ClearKeyboard();
	InitKempston();

	/*
	if (LoadImageIntoZXRAM("resources/t2.scr")==errors)
	{
		printf("Can't load t2.scr. Exiting.\n");
		ExitWithError(-1,"");
	}
	*/

	if (Reset()==errors)
		return(errors);
	else
		return(no_errors);
}


struct timeb dbtt;
unsigned short dbms=0;

void DrawBorder(void)
{
# define BORDER_UPDATE_PERIOD_MS 50

	ftime(&dbtt);

	if (abs(dbms-dbtt.millitm)<BORDER_UPDATE_PERIOD_MS)
		return;

	XSetForeground(display,gcMW,paletteMW[border]);

	if (screen_size==1)
	{
		XFillRectangle(display,w,gcMW,0,0,320,24);
		XFillRectangle(display,w,gcMW,0,216,320,24);
		XFillRectangle(display,w,gcMW,0,24,32,192);
		XFillRectangle(display,w,gcMW,288,24,32,192);
	}
	else
	{
		XFillRectangle(display,w,gcMW,0,0,640,48);
		XFillRectangle(display,w,gcMW,0,432,640,48);
		XFillRectangle(display,w,gcMW,0,48,64,384);
		XFillRectangle(display,w,gcMW,576,48,64,384);
	}


	dbms=dbtt.millitm;
}

unsigned short what16=0;
unsigned short what08=0;
void PortFeOut(unsigned char what)
{
	border=what&7;
	if (XLib)	DrawBorder();

	if (what&0x8)
		last_tape_out=250;
	else
		last_tape_out=5;

	if ((tape_pos>=tape_len)||(tape_paused))
	{
		if ((what&16)!=what16)
			AYWriteRegNV(BEEPER, what&16);
		if (( what&8)!=what08)
			AYWriteRegNV(BEEPER, what&8);

		what16=what&16;
		what08= what&8;
	}
}

unsigned char Keybbitarray2Char (KeybPortType arg)
{
	unsigned char rv=0;

	if (arg.d0)   rv|= 1;
	if (arg.d1)   rv|= 2;
	if (arg.d2)   rv|= 4;
	if (arg.d3)   rv|= 8;
	if (arg.d4)   rv|= 16;
	if (arg.u1)   rv|= 32;
	if (arg.tape) rv|= 64;
	if (arg.u2)   rv|= 128;

	return (rv);    
}

unsigned char PortFeIn(unsigned char a8a15)
{
	a8a15=~a8a15;
	ferv=255;


#if !defined BIGENDIAN
	if (a8a15&1)
	{	
		memcpy(&fer1,&fefe,1);
		ferv&=fer1;	
	}

	if (a8a15&2)
	{	
		memcpy(&fer1,&fdfe,1);
		ferv&=fer1;	
	}

	if (a8a15&4)
	{	
		memcpy(&fer1,&fbfe,1);
		ferv&=fer1;	
	}

	if (a8a15&8)
	{	
		memcpy(&fer1,&f7fe,1);
		ferv&=fer1;	
	}

	if (a8a15&16)
	{	
		memcpy(&fer1,&effe,1);
		ferv&=fer1;	
	}

	if (a8a15&32)
	{	
		memcpy(&fer1,&dffe,1);
		ferv&=fer1;	
	}

	if (a8a15&64)
	{	
		memcpy(&fer1,&bffe,1);
		ferv&=fer1;	
	}

	if (a8a15&128)
	{	
		memcpy(&fer1,&sffe,1);
		ferv&=fer1;	
	}
#endif

#if defined BIGENDIAN
	if (a8a15&1)
	{	
		fer1=Keybbitarray2Char(fefe);
		ferv&=fer1;	
	}

	if (a8a15&2)
	{	
		fer1=Keybbitarray2Char(fdfe);
		ferv&=fer1;
	}

	if (a8a15&4)
	{	
		fer1=Keybbitarray2Char(fbfe);
		ferv&=fer1;	
	}

	if (a8a15&8)
	{	
		fer1=Keybbitarray2Char(f7fe);
		ferv&=fer1;	
	}

	if (a8a15&16)
	{	
		fer1=Keybbitarray2Char(effe);
		ferv&=fer1;	
	}

	if (a8a15&32)
	{	
		fer1=Keybbitarray2Char(dffe);
		ferv&=fer1;	
	}

	if (a8a15&64)
	{	
		fer1=Keybbitarray2Char(bffe);
		ferv&=fer1;	
	}

	if (a8a15&128)
	{	
		fer1=Keybbitarray2Char(sffe);
		ferv&=fer1;	
	}
#endif

	if (direct_recording)
	{
		if (direct_recording_buffer[direct_recording_buffer_pos]>127)
			ferv|=0x40;
		else
			ferv&=0xbf;	
	}
	else
	{
		if (b2bget(tape, tape_pos))
			ferv|=0x40;
		else
			ferv&=0xbf;
	}

	return(ferv);
}

void AlternateScreen(void)
{
	int i;
	unsigned char * alternate;

	if (screen48==&RAM7[0]) 
		alternate=&CPU12[16384];
	else  
		alternate=&RAM7[0];

	for (i=0; i<6144; i++)
		if (screen48[i]!=alternate[i]) Draw8Pix(i,alternate[i],screen48[i], 0);

	for (i=0; i<768; i++)
		if (attrib48[i]!=alternate[i+6144]) Draw64Pix(i,alternate[i+6144],attrib48[i]);
}

/*boo: map memory pages via 7ffd port*/
void Port7ffdOut(unsigned char what)
{
	if (mode==m_48k)
		return;

	if ( (what&8)!=(last7ffdout&8) ) 
	{
		if (what&8)
		{
			screen48=&RAM7[0];
			attrib48=&RAM7[22528-16384];
		}
		else
		{
			screen48=&CPU12[16384];
			attrib48=&CPU12[22528];	
		}	

		if (XLib) AlternateScreen();
	}

	last7ffdout=what;	

	if ((Mode[0]=='s')||(Mode[0]=='S'))
	{
		if (!(lastPort1ffdScOut&2))
		{
			if (what&16)	
				MapROM1;
			else
				MapROM0;
		}
	}
	else
	{
		if (what&16)	
			MapROM1;
		else
			MapROM0;
	}

	if (what&32)	
	{
		if (mode!=m_48k)
			Set48kMode();
	}

	if ((Mode[0]=='s')||(Mode[0]=='S'))
	{
		if (lastPort1ffdScOut&16) ScorpionSetPage(); 
		else
		{
			switch(what&7)
			{
				case 0: new_ram=RAM0; return;	
				case 1: new_ram=RAM1; return;	
				case 2: new_ram=RAM2; return;	
				case 3: new_ram=RAM3; return;	
				case 4: new_ram=RAM4; return;	
				case 5: new_ram=RAM5; return;	
				case 6: new_ram=RAM6; return;	
				case 7: new_ram=RAM7; return;	
			}
		}
	}
	else	
	{
		switch(what&7)
		{
			case 0: new_ram=RAM0; return;	
			case 1: new_ram=RAM1; return;	
			case 2: new_ram=RAM2; return;	
			case 3: new_ram=RAM3; return;	
			case 4: new_ram=RAM4; return;	
			case 5: new_ram=RAM5; return;	
			case 6: new_ram=RAM6; return;	
			case 7: new_ram=RAM7; return;	
		}
	}
}

void PortfffdOut(unsigned char what)
{
	register_latch=what&0x0f;
}

void PortbffdOut(unsigned char what)
{
	if ((tape_pos>=tape_len)||(tape_paused))
		AYWriteReg(register_latch,what);
}

unsigned char PortfffdIn()
{
	return(Regs[register_latch]);
}

unsigned char Kempston(void)
{
	return(kempston.byte);
}


unsigned char PodognatColor(XColor * c, unsigned short r, unsigned short g, unsigned short b)
{
	unsigned short i;
	int rr, rg, rb, raz ;
	int min=0xffff;
	unsigned char rez=0;

	for (i=0; i<256; i++)
	{
		rr=c[i].red-r;
		rr=abs(rr);

		rg=c[i].green-g;
		rg=abs(rg);

		rb=c[i].blue-b;
		rb=abs(rb);

		raz=rr+rg+rb;

		if (raz<min)
		{
			min=raz;
			rez=i;
		}
	}

	return(rez);
}

void InitScreenXLib(void)
{
	Colormap colormap;
	int colorcells;
	XColor color;
	XGCValues gcv;

	int i,j;


	gcv.foreground = BlackPixelOfScreen(XtScreen(drawing_a));
	gcv.background = WhitePixelOfScreen(XtScreen(drawing_a));
	gcMW = XCreateGC(display, RootWindowOfScreen(XtScreen(drawing_a)),
			GCForeground|GCBackground, &gcv);

	colormap=DefaultColormapOfScreen(XtScreen(drawing_a));
	colorcells=0;
	while(PaletteMW && PaletteMW[3*colorcells++]!=-1);

	paletteMW=(unsigned long*)malloc(colorcells*sizeof(unsigned long));

	for(i=j=0;i<colorcells;i++)
	{
		color.flags=DoRed|DoGreen|DoBlue;
		color.red=PaletteMW[i*3]<<8;
		color.green=PaletteMW[i*3+1]<<8;
		color.blue=PaletteMW[i*3+2]<<8;

		if(XAllocColor(display,colormap,&color))
			paletteMW[j++]=color.pixel;
	}

	XSetWindowColormap(display,RootWindowOfScreen(XtScreen(drawing_a)),colormap);
}

int TryInitSscreen()
{
	int bpp=2;
	int count;
	XPixmapFormatValues * pixmaps_supported;
	int i;
	Colormap colormap;


	if (XLib==on)
	{
		InitScreenXLib();
		return(ERR_XI_OK);
	}

	videomemory=NULL;

	depth=DefaultDepth(display,DefaultScreen(display));

	if ((depth!=16)&&(depth!=8)&&(depth!=24)&&(depth!=15))
	{
		printf("Support for screen color depth = %d not completed yet. Switch to another color depth.\n",depth);
		ExitWithError(-1,"");
	}

	switch (depth)
	{
		case 16: bpp=2; break;
		case 8:  bpp=1; break;
		case 24: bpp=4; break;
		case 15: bpp=2; break;
	}

	XShmQueryVersion(display,&XShmMajor,&XShmMinor,&XShmPixmaps);

	shmseginfo=(XShmSegmentInfo *)malloc(sizeof(XShmSegmentInfo));

	if(!shmseginfo)
		return (ERR_XI_SHMALLOC);

	bzero(shmseginfo,sizeof(XShmSegmentInfo));

	if (screen_size==1)
	{
		shmseginfo->shmid=shmget(IPC_PRIVATE,
				320*240*bpp,IPC_CREAT|0777); 
	}

	if (screen_size==2)
	{
		shmseginfo->shmid=shmget(IPC_PRIVATE,
				640*480*bpp,IPC_CREAT|0777); 
	}

	if(shmseginfo->shmid<0)
		return (ERR_XI_SHMSEGINFO);

	videomemory=(unsigned char *)(shmseginfo->shmaddr=
				shmat(shmseginfo->shmid,0,0));

	shmseginfo->readOnly=False;
	if(!XShmAttach(display,shmseginfo))
		return (ERR_XI_SHMATTACH);

	if (screen_size==1)
	{
		pixmap=XShmCreatePixmap(display,w,
				(char *)videomemory,shmseginfo,
				320,240,depth);      
	}

	if (screen_size==2)
	{
		pixmap=XShmCreatePixmap(display,w,
				(char *)videomemory,shmseginfo,
				640,480,depth);      
	}

	XSetWindowBackgroundPixmap(display,w,pixmap);

	pixmaps_supported=XListPixmapFormats(display,&count);

	for (i=0;i<count;i++)
	{
		if (pixmaps_supported[i].bits_per_pixel==24)
		{


			printf("24bpp mode not supported. Switch to 16 or 32 bpp.\n");
			ExitWithError(-1,"");
		}
	}

	if (depth==8)
	{
		colormap=DefaultColormap(display,DefaultScreen(display));

		for (i=0; i<256; i++)
			color[i].pixel=i;

		XQueryColors(display,colormap,&color[0],256);


		XColors8_2_help=(unsigned char *)XColors8_2;

		colors[0]=PodognatColor(&color[0],0,0,0);
		XColors8_2_help[0]=colors[0];
		XColors8_2_help[1]=colors[0];
		colors[1]=PodognatColor(&color[0],0,0,0xbfff);
		XColors8_2_help[2]=colors[1];
		XColors8_2_help[3]=colors[1];
		colors[2]=PodognatColor(&color[0],0xbfff,0,0);
		XColors8_2_help[4]=colors[2];
		XColors8_2_help[5]=colors[2];
		colors[3]=PodognatColor(&color[0],0xbfff,0,0xbfff);
		XColors8_2_help[6]=colors[3];
		XColors8_2_help[7]=colors[3];
		colors[4]=PodognatColor(&color[0],0,0xbfff,0);
		XColors8_2_help[8]=colors[4];
		XColors8_2_help[9]=colors[4];
		colors[5]=PodognatColor(&color[0],0,0xbfff,0xbfff);
		XColors8_2_help[10]=colors[5];
		XColors8_2_help[11]=colors[5];
		colors[6]=PodognatColor(&color[0],0xbfff,0xbfff,0);
		XColors8_2_help[12]=colors[6];
		XColors8_2_help[13]=colors[6];
		colors[7]=PodognatColor(&color[0],0xbfff,0xbfff,0xbfff);
		XColors8_2_help[14]=colors[7];
		XColors8_2_help[15]=colors[7];

		colors[8]= PodognatColor(&color[0],0,0,0);
		XColors8_2_help[16]=colors[8];
		XColors8_2_help[17]=colors[8];
		colors[9]= PodognatColor(&color[0],0,0,0xffff);
		XColors8_2_help[18]=colors[9];
		XColors8_2_help[19]=colors[9];
		colors[10]=PodognatColor(&color[0],0xffff,0,0);
		XColors8_2_help[20]=colors[10];
		XColors8_2_help[21]=colors[10];
		colors[11]=PodognatColor(&color[0],0xffff,0,0xffff);
		XColors8_2_help[22]=colors[11];
		XColors8_2_help[23]=colors[11];
		colors[12]=PodognatColor(&color[0],0,0xffff,0);
		XColors8_2_help[24]=colors[12];
		XColors8_2_help[25]=colors[12];
		colors[13]=PodognatColor(&color[0],0,0xffff,0xffff);
		XColors8_2_help[26]=colors[13];
		XColors8_2_help[27]=colors[13];
		colors[14]=PodognatColor(&color[0],0xffff,0xffff,0);
		XColors8_2_help[28]=colors[14];
		XColors8_2_help[29]=colors[14];
		colors[15]=PodognatColor(&color[0],0xffff,0xffff,0xffff);
		XColors8_2_help[30]=colors[15];
		XColors8_2_help[31]=colors[15];
	}


	return(ERR_XI_OK);
}

#if !defined BIGENDIAN
char * p2b;
void WriteToSpAddrVal(unsigned short sp_addr, unsigned short data)
{
	p2b=(char*)&data;

	WriteByte(sp_addr, p2b[0]);
	WriteByte(++sp_addr, p2b[1]);
}
#endif

#if defined BIGENDIAN
char * p2b;
void WriteToSpAddrVal(unsigned short sp_addr, unsigned short data)
{
	p2b=(char*)&data;

	WriteByte(sp_addr, p2b[1]);
	WriteByte(++sp_addr, p2b[0]);
}
#endif


#if !defined BIGENDIAN
void WriteToRamAddrSpAddr(char * kuda, unsigned short sp_addr_otkuda)
{
	*(char*)kuda = ReadByte(sp_addr_otkuda);
	*(char*)(kuda+1) = ReadByte(++sp_addr_otkuda);
}
#endif

#if defined BIGENDIAN
void WriteToRamAddrSpAddr(char * kuda, unsigned short sp_addr_otkuda)
{
	*(char*)kuda = ReadByte(sp_addr_otkuda+1);
	*(char*)(kuda+1) = ReadByte(sp_addr_otkuda);
}
#endif

void myFflagZ_s(char arg)
{
	if (arg) F|=64;
	else F&=~64;
}

void myFflagH_s(char arg)
{
	if (arg) F|=16;
	else F&=~16;
}

void myFflagC_s(char arg)
{
	if (arg) F|=1;
	else F&=~1;
}

unsigned char myFflagC_r(void)
{
	if (F&1) return 1;
	else return 0;
}

void myFflagN_s(char arg)
{
	if (arg) F|=2;
	else F&=~2;
}

void myFflagS_s(char arg)
{
	if (arg) F|=128;
	else F&=~128;
}

void myFflagPV_s(char arg)
{
	if (arg) F|=4;
	else F&=~4;
}

void zero (unsigned char ger)
{
	if (!ger) myFflagZ_s (1);
	else myFflagZ_s (0);
}

void znak (unsigned char ger)
{
	if (ger>=128) myFflagS_s(1);
	else myFflagS_s(0);
}

void parity (unsigned char ger)
{
	if (ParityTBL[ger])myFflagPV_s(1);
	else myFflagPV_s(0);
}

#define ZnakA   znak(A)
#define ZeroA   zero(A)
#define ParityA parity(A)

void push (unsigned short data)
{
	SP-=2;
	WriteToSpAddrVal(SP,data);
}

void pop (unsigned short * data)
{
	WriteToRamAddrSpAddr((unsigned char *)data, SP);
	SP+=2;
}

void bit(unsigned char reg, unsigned char bit) 
{
	myFflagZ_s  ((((reg) & (0x01 << (bit))) == 0)); 
	myFflagPV_s ((((reg) & (0x01 << (bit))) == 0));
	myFflagN_s  (0);               
	znak(reg); 
}

void ScorpionSetPage(void)
{
	switch(last7ffdout&7)
	{
		case 0: new_ram=ram8; return;	
		case 1: new_ram=ram9; return;	
		case 2: new_ram=ramA; return;	
		case 3: new_ram=ramB; return;	
		case 4: new_ram=ramC; return;	
		case 5: new_ram=ramD; return;	
		case 6: new_ram=ramE; return;	
		case 7: new_ram=ramF; return;	
	}
}

void Port1ffdScOut(unsigned char what)
{
	lastPort1ffdScOut=what;

	if (what&2) new_rom=ROMSCRP; 
	else 
	{
		if (last7ffdout&16)	
			MapROM1;
		else
			MapROM0;
	}

	
	if (what&16) ScorpionSetPage(); 
	else 
	{
		switch(last7ffdout&7)
		{
			case 0: new_ram=RAM0; break;	
			case 1: new_ram=RAM1; break;	
			case 2: new_ram=RAM2; break;	
			case 3: new_ram=RAM3; break;	
			case 4: new_ram=RAM4; break;	
			case 5: new_ram=RAM5; break;	
			case 6: new_ram=RAM6; break;	
			case 7: new_ram=RAM7; break;	
		}
	}

	if (what&1) new_rom=RAM0;
	else 
	{	if (what&2) new_rom=ROMSCRP; 
		else 
		{
			if (last7ffdout&16)	
				MapROM1;
			else
				MapROM0;
		}
	}
}

void OutPort(unsigned char A0A7, unsigned char A8A15, unsigned char what)
{
	int err;
	
	if ((Mode[0]=='S')||(Mode[0]=='s'))
	{
		if ((A0A7==0xfd)&&(A8A15==0x1f))
		{
			Port1ffdScOut(what);
			return;
		}
	}

	if ((TRDOS)&&((A0A7==0xff)||(A0A7==0x7f)||(A0A7==0x1f)||(A0A7==0x3f)||(A0A7==0x5f))) 
	{
		wd1793_out(A0A7,what,tcounter_long,&err);
		if(err){MessageBoxErr("Fatal Error in WD1793 emulation");exit(0);}
#ifdef WD_DEBUG		
		DBG_PR("WD OUT(0x%02x,0x%02x)    status = %08s",(unsigned int)A0A7,(unsigned int)what,int2bin(wd1793_get_status_reg()))
#endif
		return;
	}

	/*fd              //7f */
	if (((A0A7&3)<2)&&(A8A15<0x80))
	{
		Port7ffdOut(what);
		return;
	}	

	/*fd              //bf */
	if (((A0A7&3)<2)&&(A8A15<0xc0))
	{
		PortbffdOut(what);
		return;
	}	

	/*fd              //ff */
	if (((A0A7&3)<2)&&(A8A15>=0xc0))
	{
		PortfffdOut(what);
		return;
	}

	if (A0A7==0xfe)
	{
		PortFeOut(what);
		return;
	}

#if defined pedantic
	printf("OutPort : Unknown port %x. Exiting.\n",A8A15*256+A0A7);
	ExitWithError(-1,"");
	return;
#endif
}

unsigned long long GetCurrentTime(void)
{
	struct timeb ttt;


	ftime(&ttt);
	return(ttt.time*1000+ttt.millitm);
}

unsigned char kmGetX(void)
{
	Window root_return, child_return;
	int root_x_return, root_y_return;
	int win_x_return, win_y_return;
	unsigned int mask_return;
	int wy,wx;
	static int ox;

	XQueryPointer(display, XtWindow(drawing_a),
		&root_return, &child_return, 
		&root_x_return, &root_y_return,
		&win_x_return, &win_y_return, &mask_return);

	wy=win_y_return/screen_size;
	wx=win_x_return/screen_size;

	if(!WindowedModeStorage.FullScreen)
	{
		if ((wy<24)||(wy>24+192)||(wx<32)||(wx>32+256))
			return(ox);
	}
	
	ox=wx-32*screen_size;
	return((char)ox);
}

unsigned char kmGetY(void)
{
	Window root_return, child_return;
	int root_x_return, root_y_return;
	int win_x_return, win_y_return;
	unsigned int mask_return;
	int wy,wx;
	static int oy;


	XQueryPointer(display, XtWindow(drawing_a),
		&root_return, &child_return, 
		&root_x_return, &root_y_return,
		&win_x_return, &win_y_return, &mask_return);

	wy=win_y_return/screen_size;
	wx=win_x_return/screen_size;

	if(!WindowedModeStorage.FullScreen)
	{		
		if ((wx<32)||(wx>32+256)||(wy<24)||(wy>24+192))
			return(oy);
	}
	
	oy=216*screen_size-wy;
	return((char)oy);
}	

unsigned char kmGetKeys(void)
{
	Window root_return, child_return;
	int root_x_return, root_y_return;
	int win_x_return, win_y_return;
	unsigned int mask_return;
	int wy,wx;

	unsigned char retval=255;


	XQueryPointer(display, XtWindow(drawing_a),
		&root_return, &child_return, 
		&root_x_return, &root_y_return,
		&win_x_return, &win_y_return, &mask_return);
	
	wy=win_y_return/screen_size;
	wx=win_x_return/screen_size;

	if(!WindowedModeStorage.FullScreen)
	{			
		if ((wy<24)||(wy>24+192)||(wx<32)||(wx>32+256))
			return(255);
	}

	if (mask_return&256)retval&=0xfd;
	if (mask_return&512)retval&=0xfb;
	if (mask_return&1024)retval&=0xfe;

	return(retval);
}	

unsigned char InPort(unsigned char A0A7, unsigned char A8A15)
{
	unsigned char rv;
	int err;

	if ((TRDOS)&&((A0A7==0xff)||(A0A7==0x7f)||(A0A7==0x1f)||(A0A7==0x3f)||(A0A7==0x5f))) 
	{
		rv=wd1793_in(A0A7,tcounter_long,&err);
		if(err){MessageBoxErr("Fatal Error in WD1793 emulation");exit(0);}
#ifdef WD_DEBUG
		DBG_PR("WD IN(0x%02x)=0x%02x     status = %08s",(unsigned int)A0A7,(unsigned int)rv,int2bin(wd1793_get_status_reg()))		
#endif
		return (rv);
	}

	if (kempston_mouse)
	{
		switch (A8A15*256+A0A7)
		{
			case 0xfadf: return kmGetKeys();
			case 0xfbdf: return kmGetX();
			case 0xffdf: return kmGetY();
		}
	}

	switch(A0A7)
	{
		case 0xfe: 
			return(PortFeIn(A8A15));

		case 0x1f: 
			return(Kempston());
	}		

		/*fd              //7f */
	if (((A0A7&3)<2)&&(A8A15<0x80))
		return(last7ffdout);

		/*fd              //ff */
	if (((A0A7&3)<2)&&(A8A15>=0xc0))
		return(PortfffdIn());


#if defined pedantic
	printf("InPort : Unknown port %x. Exiting.\n",A0A7+A8A15*256);
	ExitWithError(-1,"");
#endif


	return(p_ff_in);
}

void RLC (unsigned char * reg)
{                                                                                                    
	myFflagC_s((*reg & 0x80) != 0);                                                
	znak(*reg);                                                
	zero(*reg);
	parity(*reg);
	myFflagH_s(0);
	myFflagN_s(0);
}                                 

int CB (void)
{
	switch(ReadByte(PC))
	{
        	/* komandi vklyuchenuia bitov */

		case 0xc7: 
			{
				A|=1;
				PC++;
				return(8);
			}

		case 0xc4: 
			{
				H|=1;
				PC++;
				return(8);
			}

		case 0xc5: 
			{
				L|=1;
				PC++;
				return(8);
			}

		case 0xc0: 
			{
				B|=1;
				PC++;
				return(8);
			}

		case 0xc1: 
			{
				C|=1;
				PC++;
				return(8);
			}

		case 0xc2: 
			{
				D|=1;
				PC++;
				return(8);
			}

		case 0xc3: 
			{
				E|=1;
				PC++;
				return(8);
			}

		case 0xc6: 
			{
				work8=ReadByte(HL);
				work8|=1;
				WriteByte(HL,work8);
				PC++;
				return(15);
			}


		case 0xcf: 
			{
				A|=2;
				PC++;
				return(8);
			}

		case 0xcc: 
			{
				H|=2;
				PC++;
				return(8);
			}

		case 0xcd: 
			{
				L|=2;
				PC++;
				return(8);
			}

		case 0xc8: 

			{
				B|=2;
				PC++;
				return(8);
			}

		case 0xc9: 
			{
				C|=2;
				PC++;
				return(8);
			}

		case 0xca: 
			{
				D|=2;
				PC++;
				return(8);
			}

		case 0xcb: 
			{
				E|=2;
				PC++;
				return(8);
			}

		case 0xce: 
			{
				work8=ReadByte(HL);
				work8|=2;
				WriteByte(HL,work8);

				PC++;
				return(15);
			}


		case 0xd7: 
			{
				A|=4;
				PC++;
				return(8);
			}

		case 0xd4: 
			{
				H|=4;
				PC++;
				return(8);
			}

		case 0xd5: 
			{
				L|=4;
				PC++;
				return(8);
			}

		case 0xd0: 
			{
				B|=4;
				PC++;
				return(8);
			}

		case 0xd1: 

			{
				C|=4;
				PC++;
				return(8);
			}

		case 0xd2: 
			{
				D|=4;
				PC++;
				return(8);
			}

		case 0xd3: 
			{
				E|=4;
				PC++;
				return(8);
			}

		case 0xd6: 
			{
				work8=ReadByte(HL);
				work8|=4;
				WriteByte(HL,work8);

				PC++;
				return(15);
			}


		case 0xdf: 
			{
				A|=8;
				PC++;
				return(8);
			}

		case 0xdc: 
			{
				H|=8;
				PC++;
				return(8);
			}

		case 0xdd: 
			{


				L|=8;
				PC++;
				return(8);
			}

		case 0xd8: 
			{
				B|=8;
				PC++;
				return(8);
			}

		case 0xd9: 
			{
				C|=8;
				PC++;
				return(8);
			}

		case 0xda: 
			{
				D|=8;
				PC++;
				return(8);
			}

		case 0xdb: 
			{
				E|=8;
				PC++;
				return(8);
			}

		case 0xde: 
			{
				work8=ReadByte(HL);
				work8|=8;
				WriteByte(HL,work8);	

				PC++;
				return(15);
			}


		case 0xe7: 
			{
				A|=16;
				PC++;
				return(8);
			}

		case 0xe4: 
			{
				H|=16;
				PC++;
				return(8);
			}

		case 0xe5: 
			{
				L|=16;
				PC++;
				return(8);
			}

		case 0xe0: 
			{
				B|=16;
				PC++;
				return(8);
			}

		case 0xe1: 
			{
				C|=16;
				PC++;
				return(8);
			}

		case 0xe2: 
			{
				D|=16;
				PC++;
				return(8);
			}

		case 0xe3: 
			{
				E|=16;
				PC++;
				return(8);
			}

		case 0xe6: 
			{
				work8=ReadByte(HL);
				work8|=16;
				WriteByte(HL,work8);

				PC++;
				return(15);
			}
			


		case 0xef: 
			{
				A|=32;
				PC++;
				return(8);
			}

		case 0xec: 
			{
				H|=32;
				PC++;
				return(8);
			}

		case 0xed: 
			{
				L|=32;
				PC++;
				return(8);
			}

		case 0xe8: 
			{
				B|=32;
				PC++;
				return(8);
			}

		case 0xe9: 
			{
				C|=32;
				PC++;
				return(8);
			}

		case 0xea: 
			{
				D|=32;
				PC++;
				return(8);
			}

		case 0xeb: 
			{
				E|=32;
				PC++;
				return(8);
			}

		case 0xee: 
			{
				work8=ReadByte(HL);
				work8|=32;
				WriteByte(HL,work8);

				PC++;
				return(15);
			}


		case 0xf7: 
			{
				A|=64;
				PC++;
				return(8);
			}

		case 0xf4: 
			{
				H|=64;
				PC++;
				return(8);
			}

		case 0xf5: 
			{
				L|=64;
				PC++;
				return(8);
			}

		case 0xf0: 
			{
				B|=64;
				PC++;
				return(8);
			}

		case 0xf1: 

			{
				C|=64;
				PC++;
				return(8);
			}

		case 0xf2: 
			{
				D|=64;
				PC++;
				return(8);
			}

		case 0xf3: 
			{
				E|=64;
				PC++;
				return(8);
			}

		case 0xf6: 
			{

				work8=ReadByte(HL);
				work8|=64;
				WriteByte(HL,work8);	

				PC++;
				return(15);
			}


		case 0xff: 
			{

				A|=128;
				PC++;
				return(8);
			}

		case 0xfc: 
			{
				H|=128;
				PC++;
				return(8);
			}

		case 0xfd: 
			{
				L|=128;
				PC++;
				return(8);
			}

		case 0xf8: 
			{
				B|=128;
				PC++;
				return(8);
			}

		case 0xf9: 
			{
				C|=128;
				PC++;
				return(8);
			}

		case 0xfa: 
			{
				D|=128;
				PC++;
				return(8);
			}

		case 0xfb: 
			{
				E|=128;
				PC++;
				return(8);
			}

		case 0xfe: 
			{
				work8=ReadByte(HL);
				work8|=128;
				WriteByte(HL,work8);

				PC++;
				return(15);
			}

		/* viklucheniye bitov */

		case 0x87: 
			{
				A&=0xfe;
				PC++;
				return(8);
			}

		case 0x84: 
			{
				H&=0xfe;
				PC++;
				return(8);
			}

		case 0x85: 
			{
				L&=0xfe;
				PC++;
				return(8);
			}

		case 0x80: 
			{
				B&=0xfe;
				PC++;
				return(8);
			}

		case 0x81: 
			{
				C&=0xfe;
				PC++;
				return(8);
			}

		case 0x82: 
			{
				D&=0xfe;
				PC++;
				return(8);
			}

		case 0x83: 
			{
				E&=0xfe;
				PC++;
				return(8);
			}

		case 0x86: 
			{
				work8=ReadByte(HL);
				work8&=0xfe;
				WriteByte(HL,work8);

				PC++;
				return(15);
			}


		case 0x8f: 
			{
				A&=0xfd;
				PC++;
				return(8);
			}

		case 0x8c: 
			{
				H&=0xfd;
				PC++;
				return(8);
			}

		case 0x8d: 
			{
				L&=0xfd;
				PC++;
				return(8);
			}

		case 0x88: 
			{
				B&=0xfd;
				PC++;
				return(8);
			}

		case 0x89: 
			{
				C&=0xfd;
				PC++;
				return(8);
			}

		case 0x8a: 
			{
				D&=0xfd;
				PC++;


				return(8);
			}

		case 0x8b: 
			{
				E&=0xfd;
				PC++;
				return(8);
			}

		case 0x8e: 
			{
				work8=ReadByte(HL);
				work8&=0xfd;
				WriteByte(HL,work8);

				PC++;
				return(15);
			}


		case 0x97: 
			{
				A&=0xfb;
				PC++;
				return(8);
			}


		case 0x94: 
			{
				H&=0xfb;
				PC++;
				return(8);

			}

		case 0x95: 
			{
				L&=0xfb;
				PC++;
				return(8);
			}

		case 0x90: 
			{
				B&=0xfb;
				PC++;

				return(8);
			}


		case 0x91: 
			{
				C&=0xfb;
				PC++;
				return(8);


			}

		case 0x92: 
			{


				D&=0xfb;
				PC++;
				return(8);
			}

		case 0x93: 
			{
				E&=0xfb;
				PC++;
				return(8);
			}

		case 0x96: 
			{
				work8=ReadByte(HL);
				work8&=0xfb;
				WriteByte(HL,work8);

				PC++;
				return(15);
			}


		case 0x9f: 
			{
				A&=0xf7;
				PC++;


				return(8);
			}


		case 0x9c: 
			{
				H&=0xf7;
				PC++;
				return(8);
			}

		case 0x9d: 
			{

				L&=0xf7;
				PC++;
				return(8);
			}

		case 0x98: 
			{
				B&=0xf7;
				PC++;
				return(8);
			}

		case 0x99: 
			{
				C&=0xf7;
				PC++;
				return(8);
			}

		case 0x9a: 
			{
				D&=0xf7;
				PC++;
				return(8);
			}

		case 0x9b: 
			{
				E&=0xf7;
				PC++;
				return(8);
			}

		case 0x9e: 
			{
				work8=ReadByte(HL);
				work8&=0xf7;
				WriteByte(HL,work8);

				PC++;
				return(15);
			}


		case 0xa7: 
			{
				A&=0xef;
				PC++;
				return(8);
			}

		case 0xa4: 
			{
				H&=0xef;
				PC++;
				return(8);
			}

		case 0xa5: 
			{
				L&=0xef;
				PC++;
				return(8);
			}

		case 0xa0: 
			{
				B&=0xef;
				PC++;
				return(8);
			}

		case 0xa1: 
			{
				C&=0xef;
				PC++;
				return(8);
			}



		case 0xa2: 
			{
				D&=0xef;
				PC++;
				return(8);
			}

		case 0xa3: 
			{
				E&=0xef;
				PC++;
				return(8);
			}

		case 0xa6: 
			{

				work8=ReadByte(HL);
				work8&=0xef;

				WriteByte(HL,work8);

				PC++;
				return(15);
			}

		case 0xaf: 
			{
				A&=0xdf;
				PC++;
				return(8);
			}


		case 0xac: 

			{
				H&=0xdf;
				PC++;
				return(8);
			}

		case 0xad: 
			{
				L&=0xdf;
				PC++;
				return(8);
			}

		case 0xa8: 
			{
				B&=0xdf;
				PC++;

				return(8);
			}

		case 0xa9: 
			{
				C&=0xdf;
				PC++;
				return(8);
			}

		case 0xaa: 
			{
				D&=0xdf;
				PC++;
				return(8);
			}

		case 0xab: 
			{
				E&=0xdf;
				PC++;
				return(8);
			}

		case 0xae: 
			{
				work8=ReadByte(HL);
				work8&=0xdf;
				WriteByte(HL,work8);

				PC++;
				return(15);
			}


		case 0xb7: 
			{
				A&=0xbf;
				PC++;
				return(8);
			}


		case 0xb4: 
			{
				H&=0xbf;
				PC++;
				return(8);
			}

		case 0xb5: 


			{
				L&=0xbf;
				PC++;
				return(8);
			}

		case 0xb0: 
			{
				B&=0xbf;
				PC++;
				return(8);
			}

		case 0xb1: 
			{
				C&=0xbf;

				PC++;
				return(8);
			}

		case 0xb2: 
			{

				D&=0xbf;
				PC++;
				return(8);
			}

		case 0xb3: 
			{
				E&=0xbf;
				PC++;
				return(8);
			}

		case 0xb6: 
			{

				work8=ReadByte(HL);
				work8&=0xbf;
				WriteByte(HL,work8);

				PC++;
				return(15);
			}

		case 0xbf: 
			{
				A&=0x7f;
				PC++;
				return(8);
			}

		case 0xbc: 
			{
				H&=0x7f;
				PC++;
				return(8);
			}

		case 0xbd: 
			{
				L&=0x7f;
				PC++;
				return(8);
			}

		case 0xb8: 
			{
				B&=0x7f;
				PC++;
				return(8);
			}

		case 0xb9: 
			{
				C&=0x7f;
				PC++;
				return(8);
			}

		case 0xba: 
			{
				D&=0x7f;
				PC++;
				return(8);
			}

		case 0xbb: 
			{
				E&=0x7f;
				PC++;
				return(8);
			}

		case 0xbe: 
			{
				work8=ReadByte(HL);
				work8&=0x7f;
				WriteByte(HL,work8);


				PC++;
				return(15);
			}

		/* proverka bitov */

		case 0x47: 
			{
				bit(A,0);
				PC++;
				return(8);
			}

		case 0x44: 
			{
				bit(H,0);
				PC++;
				return(8);
			}

		case 0x45: 
			{
				bit(L,0);
				PC++;
				return(8);
			}

		case 0x40: 
			{
				bit(B,0);
				PC++;
				return(8);
			}

		case 0x41: 
			{
				bit(C,0);
				PC++;
				return(8);
			}

		case 0x42: 
			{

				bit(D,0);
				PC++;
				return(8);
			}

		case 0x43: 
			{
				bit(E,0);
				PC++;
				return(8);
			}

		case 0x46: 
			{
				bit(ReadByte(HL),0);
				PC++;
				return(15);
			}

		case 0x4f: 


			{
				bit(A,1);
				PC++;
				return(8);
			}

		case 0x4c: 
			{
				bit(H,1);
				PC++;
				return(8);
			}

		case 0x4d: 
			{
				bit(L,1);
				PC++;
				return(8);
			}


		case 0x48: 
			{
				bit(B,1);
				PC++;
				return(8);
			}

		case 0x49: 
			{
				bit(C,1);
				PC++;
				return(8);
			}

		case 0x4a: 
			{
				bit(D,1);
				PC++;
				return(8);
			}

		case 0x4b: 
			{
				bit(E,1);
				PC++;
				return(8);
			}

		case 0x4e: 
			{
				bit(ReadByte(HL),1);
				PC++;
				return(15);
			}


		case 0x57: 
			{
				bit(A,2);
				PC++;
				return(8);
			}

		case 0x54: 
			{
				bit(H,2);
				PC++;
				return(8);
			}

		case 0x55: 
			{
				bit(L,2);
				PC++;
				return(8);
			}

		case 0x50: 
			{
				bit(B,2);
				PC++;
				return(8);
			}

		case 0x51: 
			{
				bit(C,2);
				PC++;
				return(8);
			}

		case 0x52: 
			{
				bit(D,2);
				PC++;
				return(8);

			}

		case 0x53: 
			{
				bit(E,2);
				PC++;
				return(8);
			}

		case 0x56: 
			{
				bit(ReadByte(HL),2);
				PC++;
				return(15);
			}


		case 0x5f: 
			{
				bit(A,3);
				PC++;
				return(8);
			}

		case 0x5c: 
			{
				bit(H,3);
				PC++;
				return(8);
			}

		case 0x5d: 
			{
				bit(L,3);
				PC++;
				return(8);
			}

		case 0x58: 
			{
				bit(B,3);
				PC++;
				return(8);
			}

		case 0x59: 
			{
				bit(C,3);
				PC++;
				return(8);
			}

		case 0x5a: 
			{
				bit(D,3);
				PC++;
				return(8);
			}

		case 0x5b: 
			{
				bit(E,3);
				PC++;
				return(8);
			}

		case 0x5e: 
			{
				bit(ReadByte(HL),3);
				PC++;
				return(15);
			}


		case 0x67: 
			{
				bit(A,4);
				PC++;
				return(8);
			}

		case 0x64: 
			{
				bit(H,4);
				PC++;
				return(8);
			}

		case 0x65: 
			{
				bit(L,4);
				PC++;
				return(8);
			}

		case 0x60: 
			{
				bit(B,4);
				PC++;
				return(8);
			}

		case 0x61: 
			{
				bit(C,4);
				PC++;
				return(8);
			}

		case 0x62: 
			{
				bit(D,4);
				PC++;
				return(8);
			}

		case 0x63: 
			{
				bit(E,4);
				PC++;
				return(8);
			}

		case 0x66: 
			{
				bit(ReadByte(HL),4);
				PC++;
				return(15);
			}


		case 0x6f: 
			{
				bit(A,5);
				PC++;
				return(8);
			}

		case 0x6c: 
			{
				bit(H,5);
				PC++;
				return(8);
			}

		case 0x6d: 
			{
				bit(L,5);
				PC++;
				return(8);
			}

		case 0x68: 
			{
				bit(B,5);
				PC++;
				return(8);
			}

		case 0x69: 
			{
				bit(C,5);
				PC++;
				return(8);
			}

		case 0x6a: 
			{
				bit(D,5);
				PC++;
				return(8);
			}

		case 0x6b: 
			{
				bit(E,5);
				PC++;
				return(8);
			}

		case 0x6e: 
			{
				bit(ReadByte(HL),5);
				PC++;
				return(15);
			}


		case 0x77: 
			{
				bit(A,6);
				PC++;
				return(8);
			}

		case 0x74: 
			{
				bit(H,6);
				PC++;
				return(8);
			}

		case 0x75: 
			{

				bit(L,6);
				PC++;
				return(8);
			}

		case 0x70: 
			{
				bit(B,6);
				PC++;
				return(8);
			}


		case 0x71: 
			{
				bit(C,6);
				PC++;
				return(8);
			}

		case 0x72: 
			{
				bit(D,6);
				PC++;
				return(8);
			}

		case 0x73: 
			{
				bit(E,6);
				PC++;
				return(8);
			}

		case 0x76: 
			{
				bit(ReadByte(HL),6);
				PC++;
				return(15);
			}



		case 0x7f: 
			{
				bit(A,7);
				PC++;
				return(8);
			}

		case 0x7c: 
			{
				bit(H,7);
				PC++;
				return(8);
			}

		case 0x7d: 
			{
				bit(L,7);
				PC++;
				return(8);
			}

		case 0x78: 
			{
				bit(B,7);
				PC++;
				return(8);
			}

		case 0x79: 
			{
				bit(C,7);
				PC++;
				return(8);
			}

		case 0x7a: 
			{
				bit(D,7);
				PC++;
				return(8);
			}

		case 0x7b: 
			{
				bit(E,7);
				PC++;
				return(8);
			}

		case 0x7e: 
			{
				bit(ReadByte(HL),7);
				PC++;
				return(15);
			}

		/* komandi sdviga i rottatsii bitov */

		/* komandi srl */
		case 0x3f:
			{
				myFflagC_s( A & 0x01);                                                                  
				A >>= 1;                                                                                   
				znak(A);                                                
				zero(A);
				parity(A);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x3c:
			{
				myFflagC_s( H & 0x01);                                                                  
				H >>= 1;                                                                                   
				znak(H);                                                
				zero(H);
				parity(H);

				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x3d:
			{
				myFflagC_s( L & 0x01);                                                                  
				L>>= 1;                                                                                   
				znak(L);                                                
				zero(L);
				parity(L);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x38:
			{
				myFflagC_s( B & 0x01);                                                                  
				B>>= 1;                                                                                   
				znak(B);                                                
				zero(B);
				parity(B);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x39:
			{
				myFflagC_s( C & 0x01);                                                                  
				C>>= 1;                                                                                   

				znak(C);                                                
				zero(C);
				parity(C);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x3a:
			{
				myFflagC_s( D & 0x01);                                                                  
				D>>= 1;                                                                                   
				znak(D);                                                
				zero(D);
				parity(D);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x3b:
			{
				myFflagC_s( E & 0x01);                                                                  
				E>>= 1;                                                                                   
				znak(E);                                                
				zero(E);
				parity(E);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}


		case 0x3e:
			{
				myFflagC_s( ReadByte(HL) & 0x01);

				work8=ReadByte(HL);
				work8>>=1;
				WriteByte(HL,work8);

				znak(ReadByte(HL));                                                
				zero(ReadByte(HL));
				parity(ReadByte(HL));
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(15);
			}

		/* komandi rlc */
		case 0x07:
			{
				myFflagC_s( ((A & 0x80) != 0));                                                 
				A= (A << 1) | myFflagC_r();
				znak(A);                                                
				zero(A);
				parity(A);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x04:
			{
				myFflagC_s( ((H & 0x80) != 0));                                                 
				H= (H << 1) | myFflagC_r();
				znak(H);                                                
				zero(H);

				parity(H);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x05:
			{
				myFflagC_s( ((L & 0x80) != 0));                                                 

				L= (L << 1) | myFflagC_r();
				znak(L);                                                
				zero(L);
				parity(L);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x00:
			{
				myFflagC_s( ((B & 0x80) != 0));                                                
				B= (B << 1) | myFflagC_r();

				znak(B);                                                
				zero(B);
				parity(B);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}



		case 0x01:
			{
				myFflagC_s( ((C & 0x80) != 0));                                                 
				C= (C << 1) | myFflagC_r();
				znak(C);                                                
				zero(C);
				parity(C);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x02:
			{
				myFflagC_s( ((D & 0x80) != 0));                                                 
				D= (D << 1) | myFflagC_r();

				znak(D);                                                
				zero(D);
				parity(D);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x03:
			{
				myFflagC_s( ((E & 0x80) != 0));                                                 
				E= (E << 1) | myFflagC_r();
				znak(E);                                                
				zero(E);
				parity(E);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x06:
			{
				myFflagC_s( ((ReadByte(HL) & 0x80) != 0));                                                 
				WriteByte(HL, ((ReadByte(HL) << 1) | myFflagC_r()));
				znak(ReadByte(HL));                                                
				zero(ReadByte(HL));
				parity(ReadByte(HL));
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(15);
			}

		/* komandi rl */

		case 0x17:
			{
				work8 = ((A & 0x80) != 0);                                                
				A= (A << 1) | myFflagC_r();                                                  
				myFflagC_s( work8);
				znak(A);                                                
				zero(A);
				parity(A);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x14:
			{
				work8 = ((H & 0x80) != 0);                                                
				H= (H << 1) | myFflagC_r();                                                  
				myFflagC_s( work8 );
				znak(H);                                                
				zero(H);
				parity(H);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x15:
			{
				work8 = ((L & 0x80) != 0);                                                
				L= (L << 1) | myFflagC_r();                                                  
				myFflagC_s( work8 );
				znak(L);                                                
				zero(L);
				parity(L);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x10:
			{
				work8 = ((B & 0x80) != 0);                                                
				B= (B << 1) | myFflagC_r();                                                  
				myFflagC_s( work8 );
				znak(B);                                                
				zero(B);
				parity(B);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x11:

			{
				work8 = ((C & 0x80) != 0);                                                
				C= (C << 1) | myFflagC_r();                                                  
				myFflagC_s( work8 );
				znak(C);                                                
				zero(C);
				parity(C);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x12:
			{
				work8 = ((D & 0x80) != 0);                                                
				D= (D << 1) | myFflagC_r();                                                  
				myFflagC_s(work8 );
				znak(D);                                                
				zero(D);
				parity(D);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x13:
			{
				work8 = ((E & 0x80) != 0);                                                
				E= (E << 1) | myFflagC_r();                                                  
				myFflagC_s( work8 );
				znak(E);                                                
				zero(E);
				parity(E);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x16:
			{
				work8 = ((ReadByte(HL) & 0x80) != 0);                                                
				WriteByte(HL, ((ReadByte(HL) << 1) | myFflagC_r()));                                                  
				myFflagC_s( work8 );
				znak(ReadByte(HL));                                                
				zero(ReadByte(HL));
				parity(ReadByte(HL));
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(15);
			}

		/* komandi rr */

		case 0x1f:
			{
				work8 = A & 0x01;                                                                 
				A= (A >> 1) | (myFflagC_r() * 128);                                   
				myFflagC_s( work8 );

				znak(A);                                                
				zero(A);
				parity(A);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x1c:
			{
				work8 = H & 0x01;                                                                 
				H= (H >> 1) | (myFflagC_r() * 128);                                   
				myFflagC_s( work8 );

				znak(H);                                                
				zero(H);
				parity(H);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x1d:
			{
				work8 = L & 0x01;                                                                 
				L= (L >> 1) | (myFflagC_r() * 128);                                   
				myFflagC_s( work8 );

				znak(L);                                                
				zero(L);
				parity(L);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x18:
			{
				work8 = B & 0x01;                                                                 
				B= (B >> 1) | (myFflagC_r() * 128);                                   
				myFflagC_s( work8 );

				znak(B);                                                
				zero(B);
				parity(B);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x19:
			{
				work8 = C & 0x01;                                                                 
				C= (C >> 1) | (myFflagC_r() * 128);                                   
				myFflagC_s( work8 );

				znak(C);                                                
				zero(C);
				parity(C);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x1a:
			{
				work8 = D & 0x01;                                                                 
				D= (D >> 1) | (myFflagC_r() * 128);                                   
				myFflagC_s( work8 );

				znak(D);                                                
				zero(D);
				parity(D);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x1b:
			{
				work8 = E & 0x01;                                                                 
				E= (E >> 1) | (myFflagC_r() * 128);                                   
				myFflagC_s( work8 );

				znak(E);                                                
				zero(E);
				parity(E);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x1e:
			{
				work8 = ReadByte(HL) & 0x01;                                                                 
				WriteByte(HL, ((ReadByte(HL) >> 1) | (myFflagC_r() * 128)));                                   
				myFflagC_s( work8 );

				znak(ReadByte(HL));                                                
				zero(ReadByte(HL));
				parity(ReadByte(HL));
				myFflagH_s(0);
				myFflagN_s(0);


				PC++;

				return(15);
			}

		/* komandi sla */

		case 0x27:
			{  
				myFflagC_s( ((A & 0x80) != 0) );                                                 
				A<<= 1;                                                                                    


				znak(A);                                                
				zero(A);
				parity(A);
				myFflagH_s(0);
				myFflagN_s(0);


				PC++;
				return(8);
			}

		case 0x24:
			{  
				myFflagC_s( ((H & 0x80) != 0) );                                                 
				H<<= 1;                                                                               

				znak(H);                                                
				zero(H);

				parity(H);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x25:
			{  
				myFflagC_s( ((L & 0x80) != 0) );                                                 
				L<<= 1;                                                                                    

				znak(L);                                                
				zero(L);
				parity(L);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;

				return(8);
			}

		case 0x20:
			{  
				myFflagC_s( ((B & 0x80) != 0) );                                                 
				B<<= 1;                                                                                    

				znak(B);                                                
				zero(B);
				parity(B);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x21:
			{  
				myFflagC_s( ((C & 0x80) != 0));                                                 

				C<<= 1;                                                                                    


				znak(C);                                                
				zero(C);
				parity(C);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x22:
			{  
				myFflagC_s( ((D & 0x80) != 0));                                                 
				D<<= 1;                                                                                    

				znak(D);                                                
				zero(D);
				parity(D);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x23:
			{  
				myFflagC_s( ((E & 0x80) != 0) );                                                 
				E <<= 1;                                                                                    

				znak(E);                                                
				zero(E);
				parity(E);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x26:

			{  
				myFflagC_s( ((ReadByte(HL) & 0x80) != 0));                                                 


				work8=ReadByte(HL);
				work8<<=1;
				WriteByte(HL,work8);

				znak(ReadByte(HL));                                                
				zero(ReadByte(HL));
				parity(ReadByte(HL));

				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(15);
			}


		/* komandi rrc */

		case 0x0f:
			{
				myFflagC_s( A & 0x01 );                                                                  
				A= (A >> 1) | (myFflagC_r() * 128);                                   

				znak(A);                                                
				zero(A);
				parity(A);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);	
			}

		case 0x0c:
			{
				myFflagC_s( H & 0x01 );                                                                  
				H= (H >> 1) | (myFflagC_r() * 128);                                   

				znak(H);                                                
				zero(H);
				parity(H);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);	
			}

		case 0x0d:
			{
				myFflagC_s( L & 0x01);                                                                  
				L= (L >> 1) | (myFflagC_r() * 128);                                   

				znak(L);                                                
				zero(L);
				parity(L);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);	
			}

		case 0x08:
			{
				myFflagC_s( B & 0x01);                                                                  
				B= (B >> 1) | (myFflagC_r() * 128);                                   

				znak(B);                                                
				zero(B);
				parity(B);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);	
			}

		case 0x09:

			{
				myFflagC_s( C & 0x01);                                                                  
				C= (C >> 1) | (myFflagC_r() * 128);                                   

				znak(C);                                                
				zero(C);
				parity(C);
				myFflagH_s(0);
				myFflagN_s(0);


				PC++;
				return(8);	
			}

		case 0x0a:
			{
				myFflagC_s( D & 0x01 );                                                                  
				D= (D >> 1) | (myFflagC_r() * 128);                                   

				znak(D);                                                
				zero(D);
				parity(D);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);	
			}

		case 0x0b:
			{
				myFflagC_s( E & 0x01 );                                                                  
				E= (E >> 1) | (myFflagC_r() * 128);                                   

				znak(E);                                                
				zero(E);
				parity(E);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);	
			}

		case 0x0e:
			{
				myFflagC_s( ReadByte(HL) & 0x01);                                                                  
				WriteByte(HL, ((ReadByte(HL) >> 1) | (myFflagC_r() * 128)));                                   

				znak(ReadByte(HL));                                                
				zero(ReadByte(HL));
				parity(ReadByte(HL));
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(15);	
			}

			/* komandi sra */

		case 0x2f:
			{
				myFflagC_s( A & 0x01);                                                                  
				work8 = A & 0x80;                                                                 
				A= (A >> 1) | work8;                                                 

				znak(A);                                                
				zero(A);
				parity(A);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x2c:
			{
				myFflagC_s( H & 0x01);                                                                  
				work8 = H & 0x80;                                                                 
				H= (H >> 1) | work8;                                                 

				znak(H);                                                
				zero(H);
				parity(H);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x2d:
			{
				myFflagC_s( L & 0x01 );                                                                  
				work8 = L & 0x80;                                                                 
				L= (L >> 1) | work8;                                                 

				znak(L);                                                
				zero(L);
				parity(L);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x28:
			{
				myFflagC_s( B & 0x01);                                                                  
				work8 = B & 0x80;                                                                 
				B= (B >> 1) | work8;                                                 

				znak(B);                                                
				zero(B);
				parity(B);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x29:
			{
				myFflagC_s( C & 0x01 );                                                                  
				work8 = C & 0x80;                                                                 
				C= (C >> 1) | work8;                                                 

				znak(C);                                                
				zero(C);
				parity(C);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x2a:
			{
				myFflagC_s( D & 0x01 );                                                                  
				work8 = D & 0x80;                                                                 
				D= (D >> 1) | work8;                                                 

				znak(D);                                                
				zero(D);
				parity(D);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x2b:
			{
				myFflagC_s( E & 0x01 );                                                                  
				work8 = E & 0x80;                                                                 
				E= (E >> 1) | work8;                                                 

				znak(E);                                                
				zero(E);
				parity(E);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x2e:
			{
				myFflagC_s( ReadByte(HL) & 0x01 );                                                                  
				work8 = ReadByte(HL) & 0x80;                                                                 
				WriteByte(HL, ((ReadByte(HL) >> 1) | work8));                                                 

				znak(ReadByte(HL));                                                
				zero(ReadByte(HL));
				parity(ReadByte(HL));
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		/* komandi sli */

		case 0x30:
			{
				myFflagC_s( ((B & 0x80) != 0));
				B= (B << 1) | 0x01;

				znak(B);
				zero(B);
				parity(B);

				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x31:
			{
				myFflagC_s( ((C & 0x80) != 0));
				C= (C << 1) | 0x01;

				znak(C);
				zero(C);
				parity(C);

				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x32:
			{
				myFflagC_s( ((D & 0x80) != 0));
				D= (D << 1) | 0x01;

				znak(D);
				zero(D);
				parity(D);

				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}

		case 0x33:
			{
				myFflagC_s( ((E & 0x80) != 0));
				E= (E << 1) | 0x01;

				znak(E);
				zero(E);
				parity(E);

				myFflagH_s(0);
				myFflagN_s(0);



				PC++;
				return(8);
			}	
		case 0x34:
			{
				myFflagC_s( ((H & 0x80) != 0));
				H= (H << 1) | 0x01;

				znak(H);
				zero(H);
				parity(H);

				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}	

		case 0x35:
			{

				myFflagC_s( ((L & 0x80) != 0));
				L= (L << 1) | 0x01;

				znak(L);
				zero(L);
				parity(L);

				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}	

		case 0x36:
			{
				work8 = ReadByte(HL);

				myFflagC_s( ((work8 & 0x80) != 0));
				work8= (work8 << 1) | 0x01;
				

				znak(work8);
				zero(work8);
				parity(work8);

				myFflagH_s(0);
				myFflagN_s(0);

				WriteByte(HL, work8);

				PC++;
				return(15);
			}	

		case 0x37:
			{
				myFflagC_s( ((A & 0x80) != 0));
				A= (A << 1) | 0x01;

				znak(A);
				zero(A);
				parity(A);

				myFflagH_s(0);
				myFflagN_s(0);	

				PC++;
				return(8);
			}
	}

	printf("\nZ80 : Unknown instruction cb%x at address %x.\n",ReadByte(PC),PC-1);
	ExitWithError(-1,"");

	return(0); /* eto chtob ne kvakalo */
}

int FD (void)
{
	switch(ReadByte(PC))
	{
		case 0x21: /* ld iy, nn */
			{
				WriteToRamAddrSpAddr((unsigned char *)&IY, PC+1);
				PC+=3;
				return(14);
			}

		case 0xf9: /* ld sp, iy */
			{
				SP=IY;
				PC++;
				return(10);
			}

		case 0x2a: /* ld iy, (nn) */
			{
				WriteToRamAddrSpAddr((unsigned char *)&IY, ex(ReadByte(PC+2), ReadByte(PC+1)));

				PC+=3;
				return(20);
			}

		case 0x22: /* ld (nn), iy */
			{
				WriteToSpAddrVal(ex(ReadByte(PC+2), ReadByte(PC+1)), IY);

				PC+=3;
				return(20);
			}

		/* zagruzka registrov iz pamyati indexnoy adresatsiei */

		case 0x7e: 
			{

				A=ReadByte(IY+(signed char)ReadByte(PC+1));
				PC+=2;
				return(19);
			}

		case 0x66: 

			{
				H=ReadByte(IY+(signed char)ReadByte(PC+1));
				PC+=2;
				return(19);
			}

		case 0x6e: 
			{
				L=ReadByte(IY+(signed char)ReadByte(PC+1));
				PC+=2;
				return(19);
			}

		case 0x46: 
			{
				B=ReadByte(IY+(signed char)ReadByte(PC+1));
				PC+=2;
				return(19);
			}

		case 0x4e: 
			{
				C=ReadByte(IY+(signed char)ReadByte(PC+1));
				PC+=2;
				return(19);
			}

		case 0x56: 
			{
				D=ReadByte(IY+(signed char)ReadByte(PC+1));
				PC+=2;
				return(19);
			}

		case 0x5e: 
			{
				E=ReadByte(IY+(signed char)ReadByte(PC+1));
				PC+=2;
				return(19);
			}

		/* zapis' v pamyat' indexnoy adresatsiei */

		case 0x77: 
			{
				WriteByte(IY+(signed char)ReadByte(PC+1),A);
				PC+=2;
				return(19);
			}
			

		case 0x74: 
			{
				WriteByte(IY+(signed char)ReadByte(PC+1),H);
				PC+=2;
				return(19);
			}

		case 0x75: 
			{
				WriteByte(IY+(signed char)ReadByte(PC+1),L);
				PC+=2;
				return(19);
			}

		case 0x70: 
			{
				WriteByte(IY+(signed char)ReadByte(PC+1),B);
				PC+=2;
				return(19);
			}

		case 0x71: 
			{
				WriteByte(IY+(signed char)ReadByte(PC+1),C);
				PC+=2;
				return(19);
			}

		case 0x72: 
			{
				WriteByte(IY+(signed char)ReadByte(PC+1),D);
				PC+=2;
				return(19);
			}

		case 0x73: 
			{
				WriteByte(IY+(signed char)ReadByte(PC+1),E);
				PC+=2;
				return(19);
			}

		case 0x36: 
			{
				WriteByte(IY+(signed char)ReadByte(PC+1),ReadByte(PC+2));
				PC+=3;
				return(19);
			}

		case 0xa6: /* and (iy+s) */
			{
				A=A&(ReadByte(IY+(signed char)ReadByte(PC+1)));

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC+=2;
				return(19);
			}	

		case 0xb6: /* or (iy+s) */
			{
				A=A|(ReadByte(IY+(signed char)ReadByte(PC+1)));

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC+=2;
				return(19);
			}	

		case 0xae: /* xor (iy+s) */
			{
				A=A^(ReadByte(IY+(signed char)ReadByte(PC+1)));

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC+=2;
				return(19);
			}	

		case 0xe9: /* jp (iy) */
			{
				PC=IY;
				return(8);
			}

		case 0x35: /* dec (iy+s) */
			{
				work8=ReadByte(IY+(signed char)ReadByte(PC+1));
				work8--;
				WriteByte(IY+(signed char)ReadByte(PC+1),work8);

				znak(ReadByte(IY+(signed char)ReadByte(PC+1)));
				zero(ReadByte(IY+(signed char)ReadByte(PC+1)));
				myFflagPV_s((ReadByte(IY+(signed char)ReadByte(PC+1))==0x7f));
				myFflagN_s(1);
				myFflagH_s(((ReadByte(IY+(signed char)ReadByte(PC+1))&0x0f)==0x0f));

				PC+=2;
				return(23);
			}

		case 0x2b: /* dec iy */
			{
				IY--;
				PC++;
				return(10);
			}
			

		case 0xbe: /* cp (iy+s) */
			{	
				val=ReadByte(IY+(signed char)ReadByte(PC+1));

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				myFflagS_s(   ((work16 & 0x80) != 0));                                                
				myFflagZ_s(   ((work16 & 0xff) == 0));                                                

				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC+=2;
				return(19);
			}

		case 0x9e: /* sbc a, (iy+s) */
			{
				val=ReadByte(IY+(signed char)ReadByte(PC+1));

				work16 = A - (val) - myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;                                                                              
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC+=2;
				return(19);
			}

		case 0x86: /* add a, (iy+s) */
			{
				val=ReadByte(IY+(signed char)ReadByte(PC+1));

				work16 = A + (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                              
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s(   overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC+=2;
				return(19);
			}

		/* komandi prostogo slojeniya */

		case 0x29:
			{
				reg=IY;
				XX=IY;

				work32 = XX + (reg);                                            
				idx = ((XX & 0x0800) >> 9) |                                    
					(((reg) & 0x0800) >> 10) |                            
					((work32 & 0x0800) >> 11);                            
				XX = work32 & 0xffff;                                           
				myFflagH_s(   hcarry_tbl[idx]);                                     
				myFflagN_s(0);                                                    
				myFflagC_s( ((work32 & 0x10000) != 0));  
				IY=XX;

				PC++;
				return(15);
			}

		case 0x09:
			{
				reg=BC;
				XX=IY;

				work32 = XX + (reg);                                            
				idx = ((XX & 0x0800) >> 9) |                                    
					(((reg) & 0x0800) >> 10) |                            
					((work32 & 0x0800) >> 11);                            
				XX = work32 & 0xffff;                                           
				myFflagH_s(   hcarry_tbl[idx]);                                     
				myFflagN_s(0);                                                    
				myFflagC_s( ((work32 & 0x10000) != 0));  
				IY=XX;

				PC++;
				return(15);
			}

		case 0x19:
			{
				reg=DE;
				XX=IY;

				work32 = XX + (reg);                                            
				idx = ((XX & 0x0800) >> 9) |                                    
					(((reg) & 0x0800) >> 10) |                            
					((work32 & 0x0800) >> 11);                            
				XX = work32 & 0xffff;                                           
				myFflagH_s(   hcarry_tbl[idx]);                                     
				myFflagN_s(0);                                                    
				myFflagC_s( ((work32 & 0x10000) != 0));  
				IY=XX;

				PC++;
				return(15);
			}

		case 0x39:
			{
				reg=SP;
				XX=IY;

				work32 = XX + (reg);                                            
				idx = ((XX & 0x0800) >> 9) |                                    
					(((reg) & 0x0800) >> 10) |                            
					((work32 & 0x0800) >> 11);                            
				XX = work32 & 0xffff;                                           
				myFflagH_s(   hcarry_tbl[idx]);                                     
				myFflagN_s(0);                                                    
				myFflagC_s( ((work32 & 0x10000) != 0));  
				IY=XX;

				PC++;
				return(15);
			}

		case 0x34 : /* inc (iy+s) */
			{
				reg=ReadByte(IY+(signed char)ReadByte(PC+1));

				reg++;                                                                                                
				znak(reg);                                                 
				zero(reg);                                                                  
				myFflagH_s(   (((reg) & 0x0f) == 0));                                                 
				myFflagPV_s(   ((reg) == 0x80));                                                               
				myFflagN_s(0);
				WriteByte(IY+(signed char)ReadByte(PC+1),reg);

				PC+=2;
				return(23);
			}

		case 0x23 : /* inc iy */
			{
				IY++;

				PC++;
				return(10);
			}

		case 0xcb :  
			{
				switch(ReadByte(PC+2))
				{
					/* vklyuchenie bitov */
					case 0xc6: 

						{
							work8=ReadByte(IY+(signed char)ReadByte(PC+1));
							work8|=1;
							WriteByte(IY+(signed char)ReadByte(PC+1),work8);

							break;
						}
					case 0xce: 
						{
							work8=ReadByte(IY+(signed char)ReadByte(PC+1));
							work8|=2;
							WriteByte(IY+(signed char)ReadByte(PC+1),work8);

							break;
						}

					case 0xd6: 

						{
							work8=ReadByte(IY+(signed char)ReadByte(PC+1));

							work8|=4;
							WriteByte(IY+(signed char)ReadByte(PC+1),work8);

							break;
						}
					case 0xde: 
						{
							work8=ReadByte(IY+(signed char)ReadByte(PC+1));
							work8|=8;
							WriteByte(IY+(signed char)ReadByte(PC+1),work8);

							break;
						}
					case 0xe6: 
						{
							work8=ReadByte(IY+(signed char)ReadByte(PC+1));
							work8|=16;
							WriteByte(IY+(signed char)ReadByte(PC+1),work8);

							break;
						}
					case 0xee: 
						{
							work8=ReadByte(IY+(signed char)ReadByte(PC+1));
							work8|=32;
							WriteByte(IY+(signed char)ReadByte(PC+1),work8);

							break;
						}
					case 0xf6: 
						{
							work8=ReadByte(IY+(signed char)ReadByte(PC+1));
							work8|=64;
							WriteByte(IY+(signed char)ReadByte(PC+1),work8);

							break;
						}
					case 0xfe: 
						{
							work8=ReadByte(IY+(signed char)ReadByte(PC+1));
							work8|=128;
							WriteByte(IY+(signed char)ReadByte(PC+1),work8);

							break;
						}

					/* viklyuchenie bitov */
					case 0x86: 
						{
							work8=ReadByte(IY+(signed char)ReadByte(PC+1));
							work8&=0xfe;
							WriteByte(IY+(signed char)ReadByte(PC+1),work8);

							break;
						}
					case 0x8e: 
						{
							work8=ReadByte(IY+(signed char)ReadByte(PC+1));
							work8&=0xfd;
							WriteByte(IY+(signed char)ReadByte(PC+1),work8);

							break;
						}
					case 0x96: 
						{
							work8=ReadByte(IY+(signed char)ReadByte(PC+1));

							work8&=0xfb;
							WriteByte(IY+(signed char)ReadByte(PC+1),work8);

							break;
						}
					case 0x9e:
						{
							work8=ReadByte(IY+(signed char)ReadByte(PC+1));
							work8&=0xf7;
							WriteByte(IY+(signed char)ReadByte(PC+1),work8);
							

							break;
						}
					case 0xa6: 
						{
							work8=ReadByte(IY+(signed char)ReadByte(PC+1));
							work8&=0xef;
							WriteByte(IY+(signed char)ReadByte(PC+1),work8);

							break;
						}
					case 0xae: 
						{
							work8=ReadByte(IY+(signed char)ReadByte(PC+1));
							work8&=0xdf;
							WriteByte(IY+(signed char)ReadByte(PC+1),work8);

							break;
						}
					case 0xb6: 
						{
							work8=ReadByte(IY+(signed char)ReadByte(PC+1));
							work8&=0xbf;
							WriteByte(IY+(signed char)ReadByte(PC+1),work8);

							break;
						}
					case 0xbe: 
						{
							work8=ReadByte(IY+(signed char)ReadByte(PC+1));
							work8&=0x7f;
							WriteByte(IY+(signed char)ReadByte(PC+1),work8);


							break;
						}

					/* poriverka bitov */
					case 0x40:
					case 0x41:
					case 0x42:
					case 0x43:
					case 0x44:
					case 0x45:
					case 0x47:	
					case 0x46: 
						{
							bit(ReadByte(IY+(signed char)ReadByte(PC+1)),0);							
							break;
						}
					case 0x48:
					case 0x49:
					case 0x4a:
					case 0x4b:
					case 0x4c:
					case 0x4d:
					case 0x4e:	
					case 0x4f: 
						{
							bit(ReadByte(IY+(signed char)ReadByte(PC+1)),1);							
							break;
						}
					case 0x56: 
						{
							bit(ReadByte(IY+(signed char)ReadByte(PC+1)),2);							
							break;
						}
					case 0x5e: 
						{
							bit(ReadByte(IY+(signed char)ReadByte(PC+1)),3);							
							break;
						}
					case 0x66: 
						{
							bit(ReadByte(IY+(signed char)ReadByte(PC+1)),4);							
							break;
						}
					case 0x6e: 
						{
							bit(ReadByte(IY+(signed char)ReadByte(PC+1)),5);							
							break;
						}

					case 0x76: 
						{
							bit(ReadByte(IY+(signed char)ReadByte(PC+1)),6);							
							break;
						}
					case 0x7e: 
						{
							bit(ReadByte(IY+(signed char)ReadByte(PC+1)),7);							
							break;
						}

					case 0x3e: /* srl (iy+s) */


						{
							myFflagC_s( ReadByte(IY+(signed char)ReadByte(PC+1)) & 0x01);                                                                  

							work8=ReadByte(IY+(signed char)ReadByte(PC+1));
							work8>>=1;
							WriteByte(IY+(signed char)ReadByte(PC+1),work8);

							znak(ReadByte(IY+(signed char)ReadByte(PC+1)));                                                
							zero(ReadByte(IY+(signed char)ReadByte(PC+1)));
							parity(ReadByte(IY+(signed char)ReadByte(PC+1)));
							myFflagH_s(0);
							myFflagN_s(0);

							break;
						}

					case 0x0e: /* rrc (iy+s) */
						{
							myFflagC_s( ReadByte(IY+(signed char)ReadByte(PC+1)) & 0x01);                                                                  

							WriteByte(IY+(signed char)ReadByte(PC+1), (ReadByte(IY+(signed char)ReadByte(PC+1)) >> 1) | (myFflagC_r() * 128));                                   

							znak(ReadByte(IY+(signed char)ReadByte(PC+1)));                                                
							zero(ReadByte(IY+(signed char)ReadByte(PC+1)));
							parity(ReadByte(IY+(signed char)ReadByte(PC+1)));
							myFflagH_s(0);
							myFflagN_s(0);

							break;
						}

					case 0x26: /* sla (iy+s) */
						{  
							myFflagC_s( ((ReadByte(IY+(signed char)ReadByte(PC+1)) & 0x80) != 0));                                                 

							work8=ReadByte(IY+(signed char)ReadByte(PC+1));
							work8<<=1;
							WriteByte(IY+(signed char)ReadByte(PC+1),work8);


							znak(ReadByte(IY+(signed char)ReadByte(PC+1)));                                                
							zero(ReadByte(IY+(signed char)ReadByte(PC+1)));
							parity(ReadByte(IY+(signed char)ReadByte(PC+1)));
							myFflagH_s(0);
							myFflagN_s(0);

							break;
						}

					case 0x1e: /* rr (iy+s) */
						{
							work8 = ReadByte(IY+(signed char)ReadByte(PC+1)) & 0x01;                                                                 
							WriteByte(IY+(signed char)ReadByte(PC+1),(ReadByte(IY+(signed char)ReadByte(PC+1)) >> 1) | (myFflagC_r() * 128));                                   
							myFflagC_s( work8);

							znak(ReadByte(IY+(signed char)ReadByte(PC+1)));                                                
							zero(ReadByte(IY+(signed char)ReadByte(PC+1)));
							parity(ReadByte(IY+(signed char)ReadByte(PC+1)));
							myFflagH_s(0);
							myFflagN_s(0);

							break;
						}

					case 0x06: /* rlc (iy+s) */
						{
							myFflagC_s( ((ReadByte(IY+(signed char)ReadByte(PC+1)) & 0x80) != 0));                                                 
							WriteByte(IY+(signed char)ReadByte(PC+1),(ReadByte(IY+(signed char)ReadByte(PC+1)) << 1) | myFflagC_r());

							znak(ReadByte(IY+(signed char)ReadByte(PC+1)));                                                
							zero(ReadByte(IY+(signed char)ReadByte(PC+1)));
							parity(ReadByte(IY+(signed char)ReadByte(PC+1)));
							myFflagH_s(0);
							myFflagN_s(0);

							break;
						}

					case 0x16: /* rl (iy+s) */
						{
							work8 = ((ReadByte(IY+(signed char)ReadByte(PC+1)) & 0x80) != 0);                                                
							WriteByte(IY+(signed char)ReadByte(PC+1), ((ReadByte(IY+(signed char)ReadByte(PC+1)) << 1) | myFflagC_r()));                                                  
							myFflagC_s( work8);
							znak(ReadByte(IY+(signed char)ReadByte(PC+1)));                                                
							zero(ReadByte(IY+(signed char)ReadByte(PC+1)));
							parity(ReadByte(IY+(signed char)ReadByte(PC+1)));
							myFflagH_s(0);
							myFflagN_s(0);

							break;
						}

					case 0x2e: /* sra (iy+s) */
						{
							myFflagC_s( ReadByte(IY+(signed char)ReadByte(PC+1)) & 0x01);                                                                  
							work8 = ReadByte(IY+(signed char)ReadByte(PC+1)) & 0x80;                                                                 
							WriteByte(IY+(signed char)ReadByte(PC+1), ((ReadByte(IY+(signed char)ReadByte(PC+1)) >> 1) | work8));                                                 

							znak(ReadByte(IY+(signed char)ReadByte(PC+1)));                                                
							zero(ReadByte(IY+(signed char)ReadByte(PC+1)));
							parity(ReadByte(IY+(signed char)ReadByte(PC+1)));
							myFflagH_s(0);
							myFflagN_s(0);

							break;
						}

					case 0x0f:
						{
							A = ReadByte(IY+(signed char)ReadByte(PC+1));                                                        

							myFflagC_s( A & 0x01);                                                                  
							A= (A >> 1) | (myFflagC_r() * 128);                                   

							znak(A);                                                
							zero(A);
							parity(A);
							myFflagH_s(0);
							myFflagN_s(0);

							WriteByte(IY+(signed char)ReadByte(PC+1), A); 

							break; 
						}	

					case 0x00:
						{
							B = ReadByte(ReadByte(IY+(signed char)ReadByte(PC+1)));                                                                                   
							RLC(&B);                                                                                               
							WriteByte(ReadByte(IY+(signed char)ReadByte(PC+1)), B);                                                                                    
							break;  
						}



					case 0x01:
						{
							C = ReadByte(ReadByte(IY+(signed char)ReadByte(PC+1)));                                                                                   
							RLC(&C);                                                                                               
							WriteByte(ReadByte(IY+(signed char)ReadByte(PC+1)), C);                                                                                    
							break;  
						}

					case 0x02:
						{
							D = ReadByte(ReadByte(IY+(signed char)ReadByte(PC+1)));                                                                                   
							RLC(&D);                                                                                               
							WriteByte(ReadByte(IY+(signed char)ReadByte(PC+1)), D);                                                                                    
							break;  
						}

					case 0x03:

						{
							E = ReadByte(ReadByte(IY+(signed char)ReadByte(PC+1)));                                                                                   

							RLC(&E);                                                                                               
							WriteByte(ReadByte(IY+(signed char)ReadByte(PC+1)), E);                                                                                    
							break;  
						}

					case 0x04:
						{
							H = ReadByte(ReadByte(IY+(signed char)ReadByte(PC+1)));                                                                                   
							RLC(&H);                                                                                               
							WriteByte(ReadByte(IY+(signed char)ReadByte(PC+1)), H);                                                                                    

							break;  
						}

					case 0x05:
						{
							L = ReadByte(ReadByte(IY+(signed char)ReadByte(PC+1)));                                                                                   
							RLC(&L);                                                                                               
							WriteByte(ReadByte(IY+(signed char)ReadByte(PC+1)), L);                                                                                    
							break;  
						}

					default :
						printf("Z80 :  fd cb S %2x. Unknown. PC=%4x.\n",ReadByte(PC+2),PC-1);
						ExitWithError(-1,"");
				}

				PC+=3;
				return(23);
			}

		case 0xe5 : /* push iy */
			{
				push(IY);

				PC++;
				return(15);
			}

		case 0x96 : /* sub (iy+s) */
			{
				val=ReadByte(IY+(signed char)ReadByte(PC+1));	

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              

				ZnakA;                                                             
				ZeroA;                                                                             
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s( sub_overflow_tbl[idx >> 4] );                                    

				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC+=2;
				return(19);
			}

		case 0xe1 : /* pop iy */
			{
				pop(&IY);

				PC++;
				return(14);
			}

		case 0x8e: /* adc a,(iy+s) */
			{
				val=ReadByte(IY+(signed char)ReadByte(PC+1));

				work16 = A + (val) + myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;

				ZeroA;
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s( overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC+=2;
				return(19);
			}

		case 0xe3 : /* ex (sp),iy */

			{
				pop(&XX);
				push(IY);
				IY=XX;

				PC++;
				return(23);
			}


		/* operatsii s polovinkami IY start */

		case 0x24: /* inc IYh   */
			{
				IYh++;

				znak(IYh);                                                 
				zero(IYh);                                                                  
				myFflagH_s(   (((IYh) & 0x0f) == 0));                                                 
				myFflagPV_s(   ((IYh) == 0x80));                                                               


				myFflagN_s(0);

				PC++;
				return(8);                                                              
			}	


		case 0x25:   /* dec IYh */
			{
				IYh--;


				znak(IYh);
				zero(IYh);
				myFflagPV_s((IYh==0x7f));
				myFflagN_s(1);
				myFflagH_s(    ((IYh&0x0f)==0x0f));

				PC++;
				return(8); 
			}

		case 0x26: 
			{
				IYh=ReadByte(PC+1);

				PC+=2;
				return(11);
			}

		case 0x2c: /* inc IYl   */
			{
				IYl++;

				znak(IYl);                                                 
				zero(IYl);                                                                  
				myFflagH_s(   (((IYl) & 0x0f) == 0));                                                 
				myFflagPV_s(   ((IYl) == 0x80));                                                               
				myFflagN_s(0);

				PC++;
				return(8);                                                              
			}	

		case 0x2d:   /* dec IYl */
			{
				IYl--;

				znak(IYl);
				zero(IYl);
				myFflagPV_s((IYl==0x7f));
				myFflagN_s(1);
				myFflagH_s(    ((IYl&0x0f)==0x0f));

				PC++;
				return(8); 
			}

		case 0x2e: 
			{
				IYl=ReadByte(PC+1);

				PC+=2;
				return(11);
			}

		case 0x44:    
			{
				B=IYh;

				PC++;
				return(8);
			}

		case 0x45:    
			{
				B=IYl;

				PC++;
				return(8);
			}	

		case 0x4c:    
			{
				C=IYh;

				PC++;
				return(8);
			}

		case 0x4d:    
			{
				C=IYl;

				PC++;
				return(8);
			}	

		case 0x54:    
			{
				D=IYh;

				PC++;
				return(8);
			}

		case 0x55:    
			{
				D=IYl;

				PC++;
				return(8);
			}	

		case 0x5c:    
			{
				E=IYh;

				PC++;
				return(8);
			}

		case 0x5d:    
			{
				E=IYl;

				PC++;
				return(8);
			}	

		case 0x60:    
			{
				IYh=B;

				PC++;
				return(8);
			}	

		case 0x61:    
			{
				IYh=C;

				PC++;
				return(8);
			}	

		case 0x62:    
			{
				IYh=D;

				PC++;
				return(8);
			}	

		case 0x63:    
			{
				IYh=E;

				PC++;
				return(8);
			}	

		case 0x64:    
			{
				IYh=IYh;

				PC++;
				return(8);
			}	

		case 0x65:    
			{
				IYh=IYl;

				PC++;
				return(8);
			}	


		case 0x67:    
			{
				IYh=A;

				PC++;
				return(8);
			}	


		case 0x68:    
			{
				IYl=B;

				PC++;
				return(8);
			}	

		case 0x69:    
			{
				IYl=C;

				PC++;
				return(8);
			}	

		case 0x6a:    
			{
				IYl=D;

				PC++;
				return(8);
			}	

		case 0x6b:    
			{
				IYl=E;

				PC++;
				return(8);
			}	

		case 0x6c:    
			{
				IYl=IYh;

				PC++;
				return(8);
			}	

		case 0x6d:    
			{
				IYl=IYl;

				PC++;
				return(8);
			}	

		case 0x6f:    
			{
				IYl=A;

				PC++;
				return(8);
			}

		case 0x7c:    

			{
				A=IYh;

				PC++;
				return(8);
			}


		case 0x7d:    
			{
				A=IYl;

				PC++;
				return(8);
			}

		case 0x84:
			{
				val=IYh;

				work16 = A + (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                              
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s(   overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(8);	
			}

		case 0x85:
			{
				val=IYl;

				work16 = A + (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                              
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 

				myFflagPV_s(   overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(8);	
			}

		case 0x8c:
			{
				val=IYh;

				work16 = A + (val) + myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s( overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(8);
			}

		case 0x8d:
			{
				val=IYl;

				work16 = A + (val) + myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s( overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(8);
			}

		case 0x94 :
			{
				val=IYh;	

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                             
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s( sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(8);
			}

		case 0x95 :
			{
				val=IYl;	

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                             
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s( sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(8);
			}

		case 0x9c:
			{
				val=IYh;

				work16 = A - (val) - myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;                                                                              
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(8);
			}

		case 0x9d:
			{
				val=IYl;

				work16 = A - (val) - myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;                                                                              
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);
				myFflagC_s( ((work16 & 0x0100) != 0));


				PC++;
				return(8);
			}

		case 0xa4:


			{
				A=A&IYh;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}	

		case 0xa5:
			{
				A=A&IYl;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}	

		case 0xac:

			{
				A=A^IYh;


				ParityA;




				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}	

		case 0xad:
			{
				A=A^IYl;

				ParityA;

				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}	

		case 0xb4:
			{
				A=A|IYh;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}	

		case 0xb5:
			{
				A=A|IYl;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}	

		case 0xbc:
			{	
				val=IYh;



				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				myFflagS_s(   ((work16 & 0x80) != 0));                                                
				myFflagZ_s(   ((work16 & 0xff) == 0));                                                
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(8);
			}

		case 0xbd:
			{	
				val=IYl;

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				myFflagS_s(   ((work16 & 0x80) != 0));                                                
				myFflagZ_s(   ((work16 & 0xff) == 0));                                                
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0) );

				PC++;
				return(8);
			}

		case 0x3b: /* dec SP */
			{
				SP--;

				PC++;
				return(10);
			}

		case 0xbf: /* NOP */
			{	

				PC++;
				return(8);
			}

		case 0xaf: /* NOP */
			{

				PC++;
				return(8);
			}	

		default :
			return(z80a(0)+4);
	}

	printf("\nZ80 : Unknown instruction fd%x at address %x.\n",ReadByte(PC),PC-1);
	ExitWithError(-1,"");
}


int DD (void)
{
	switch(ReadByte(PC))
	{

		case 0x21: /*ld ix, nn*/
			{
				WriteToRamAddrSpAddr((unsigned char *)&IX,PC+1);
				PC+=3;
				return(14);
			}

		case 0xf9: /*ld sp, ix*/
			{
				SP=IX;
				PC++;
				return(10);
			}

		case 0x5b: /* ld de, (nn) */
			{
				E=ReadByte(ex(ReadByte(PC+2),ReadByte(PC+1)));
				D=ReadByte(ex(ReadByte(PC+2),ReadByte(PC+1))+1);
				PC+=3;
				return(20);
			}

		case 0x2a: /* ld ix, (nn) */
			{
				WriteToRamAddrSpAddr((unsigned char *)&IX, ex(ReadByte(PC+2),ReadByte(PC+1)));
				PC+=3;
				return(20);
			}

		case 0x22: /* ld (nn), ix */
			{
				WriteToSpAddrVal(ex(ReadByte(PC+2),ReadByte(PC+1)),IX);
				PC+=3;
				return(20);
			}

		/* zagruzka registrov iz pamyati indexnoy adresatsiei */

		case 0x7e: 
			{
				A=ReadByte(IX+(signed char)ReadByte(PC+1));
				PC+=2;
				return(19);
			}

		case 0x66: 
			{
				H=ReadByte(IX+(signed char)ReadByte(PC+1));
				PC+=2;
				return(19);
			}

		case 0x6e: 
			{
				L=ReadByte(IX+(signed char)ReadByte(PC+1));
				PC+=2;
				return(19);
			}

		case 0x46: 
			{

				B=ReadByte(IX+(signed char)ReadByte(PC+1));

				PC+=2;
				return(19);
			}

		case 0x4e: 
			{

				C=ReadByte(IX+(signed char)ReadByte(PC+1));
				PC+=2;
				return(19);
			}

		case 0x56: 
			{
				D=ReadByte(IX+(signed char)ReadByte(PC+1));
				PC+=2;
				return(19);
			}

		case 0x5e: 
			{
				E=ReadByte(IX+(signed char)ReadByte(PC+1));
				PC+=2;
				return(19);
			}

		/* zapis' v pamyat' indexnoy adresatsiei */

		case 0x77: 
			{
				WriteByte(IX+(signed char)ReadByte(PC+1),A);
				PC+=2;
				return(19);
			}

		case 0x74: 

			{
				WriteByte(IX+(signed char)ReadByte(PC+1),H);
				PC+=2;
				return(19);
			}

		case 0x75: 
			{
				WriteByte(IX+(signed char)ReadByte(PC+1),L);
				PC+=2;
				return(19);
			}

		case 0x70: 
			{
				WriteByte(IX+(signed char)ReadByte(PC+1),B);
				PC+=2;
				return(19);
			}

		case 0x71: 
			{
				WriteByte(IX+(signed char)ReadByte(PC+1),C);
				PC+=2;
				return(19);

			}

		case 0x72: 
			{
				WriteByte(IX+(signed char)ReadByte(PC+1),D);
				PC+=2;
				return(19);
			}

		case 0x73: 
			{
				WriteByte(IX+(signed char)ReadByte(PC+1),E);
				PC+=2;
				return(19);
			}

		case 0x36: 
			{
				WriteByte(IX+(signed char)ReadByte(PC+1),ReadByte(PC+2));

				PC+=3;
				return(19);
			}

		case 0xa6: /* and (ix+s) */
			{
				A=A&(ReadByte(IX+(signed char)ReadByte(PC+1)));

				ParityA;

				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC+=2;
				return(19);
			}	


		case 0xb6: /* or (ix+s) */
			{
				A=A|(ReadByte(IX+(signed char)ReadByte(PC+1)));

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC+=2;
				return(19);

			}	

		case 0xae: /* xor (ix+s) */
			{
				A=A^(ReadByte(IX+(signed char)ReadByte(PC+1)));

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC+=2;
				return(19);
			}	

		case 0xe9: /* jp (ix) */
			{
				PC=IX;
				return(8);
			}

		case 0x35: /* dec (ix+s) */
			{
				work8=ReadByte(IX+(signed char)ReadByte(PC+1));
				work8--;
				WriteByte(IX+(signed char)ReadByte(PC+1),work8);

				znak(ReadByte(IX+(signed char)ReadByte(PC+1)));
				zero(ReadByte(IX+(signed char)ReadByte(PC+1)));
				myFflagPV_s((ReadByte(IX+(signed char)ReadByte(PC+1))==0x7f));
				myFflagN_s(1);

/* !!! */ 				
/* myF.flagH=((ReadByte(IX+(signed char)ReadByte(PC+1))&0x0f)==0x0f); */

				PC+=2;
				return(23);
			}

		case 0x2b: /* dec ix */
			{
				IX--;
				PC++;
				return(10);
			}

		case 0xbe: /* cp (ix+s) */
			{	
				val=ReadByte(IX+(signed char)ReadByte(PC+1));

				work16 = A - (val);                                                                             

				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				myFflagS_s(   ((work16 & 0x80) != 0));                                                
				myFflagZ_s(   ((work16 & 0xff) == 0));                                                
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    

				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0) );

				PC+=2;
				return(19);
			}

		case 0x9e: /*sbc a, (ix+s) */
			{
				val=ReadByte(IX+(signed char)ReadByte(PC+1));

				work16 = A - (val) - myFflagC_r();                                                    

				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;                                                                              
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC+=2;


				return(19);
			}

		case 0x86: /* add a, (ix+s) */
			{
				val=ReadByte(IX+(signed char)ReadByte(PC+1));

				work16 = A + (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               

					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;       

/* !!!! Why ? */
/* myFflagH_s(   hcarry_tbl[idx & 0x7]);                                         */        

				myFflagPV_s(   overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC+=2;
				return(19);
			}


		/* komandi prostogo slojeniya */


		case 0x29:
			{
				reg=IX;
				XX=IX;

				work32 = XX + (reg);                                            
				idx = ((XX & 0x0800) >> 9) |                                    
					(((reg) & 0x0800) >> 10) |                            
					((work32 & 0x0800) >> 11);                            
				XX = work32 & 0xffff;                                           
				myFflagH_s(   hcarry_tbl[idx]);                                     
				myFflagN_s(0);                                                    
				myFflagC_s( ((work32 & 0x10000) != 0));  
				IX=XX;

				PC++;
				return(15);
			}

		case 0x09:
			{
				reg=BC;
				XX=IX;


				work32 = XX + (reg);                                            
				idx = ((XX & 0x0800) >> 9) |                                    
					(((reg) & 0x0800) >> 10) |                            
					((work32 & 0x0800) >> 11);                            
				XX = work32 & 0xffff;                                           
				myFflagH_s(   hcarry_tbl[idx]);                                     
				myFflagN_s(0);                                                    
				myFflagC_s( ((work32 & 0x10000) != 0));  
				IX=XX;

				PC++;
				return(15);
			}

		case 0x19:
			{
				reg=DE;
				XX=IX;

				work32 = XX + (reg);                                            
				idx = ((XX & 0x0800) >> 9) |                                    
					(((reg) & 0x0800) >> 10) |                            
					((work32 & 0x0800) >> 11);                            
				XX = work32 & 0xffff;                                           
				myFflagH_s(   hcarry_tbl[idx]);                                     
				myFflagN_s(0);                                                    
				myFflagC_s( ((work32 & 0x10000) != 0));  
				IX=XX;

				PC++;
				return(15);
			}

		case 0x39:
			{
				reg=SP;
				XX=IX;

				work32 = XX + (reg);                                            
				idx = ((XX & 0x0800) >> 9) |                                    
					(((reg) & 0x0800) >> 10) |                            
					((work32 & 0x0800) >> 11);                            
				XX = work32 & 0xffff;                                           
				myFflagH_s(   hcarry_tbl[idx]);                                     
				myFflagN_s(0);                                                    
				myFflagC_s( ((work32 & 0x10000) != 0));  
				IX=XX;

				PC++;
				return(15);
			}

		case 0x34 : /* inc (ix+s) */
			{
				reg=ReadByte(IX+(signed char)ReadByte(PC+1));

				reg++;                                                                                                
				znak(reg);                                                 
				zero(reg);                                                                  
				myFflagH_s(   (((reg) & 0x0f) == 0));                                                 
				myFflagPV_s(   ((reg) == 0x80));                                                               
				myFflagN_s(0);
				WriteByte(IX+(signed char)ReadByte(PC+1),reg);

				PC+=2;
				return(23);
			}

		case 0x23 : /* inc ix */
			{

				IX++;

				PC++;
				return(10);
			}

		case 0xcb :  
			{
				/* R+=2; */

				switch(ReadByte(PC+2))
				{    
					/* vklyuchenie bitov **/
					case 0xc6: 
						{
							work8=ReadByte(IX+(signed char)ReadByte(PC+1));
							work8|=1;

							WriteByte(IX+(signed char)ReadByte(PC+1),work8);

							break;
						}
					case 0xce: 
						{
							work8=ReadByte(IX+(signed char)ReadByte(PC+1));
							work8|=2;
							WriteByte(IX+(signed char)ReadByte(PC+1),work8);

							break;
						}
					case 0xd6: 
						{
							work8=ReadByte(IX+(signed char)ReadByte(PC+1));
							work8|=4;
							WriteByte(IX+(signed char)ReadByte(PC+1),work8);


							break;
						}
					case 0xde: 
						{
							work8=ReadByte(IX+(signed char)ReadByte(PC+1));
							work8|=8;
							WriteByte(IX+(signed char)ReadByte(PC+1),work8);

							break;
						}
					case 0xe6: 
						{
							work8=ReadByte(IX+(signed char)ReadByte(PC+1));
							work8|=16;
							WriteByte(IX+(signed char)ReadByte(PC+1),work8);

							break;
						}
					case 0xee: 
						{
							work8=ReadByte(IX+(signed char)ReadByte(PC+1));
							work8|=32;
							WriteByte(IX+(signed char)ReadByte(PC+1),work8);

							break;
						}
					case 0xf6: 
						{
							work8=ReadByte(IX+(signed char)ReadByte(PC+1));
							work8|=64;
							WriteByte(IX+(signed char)ReadByte(PC+1),work8);

							break;
						}
					case 0xfe: 
						{

							work8=ReadByte(IX+(signed char)ReadByte(PC+1));
							work8|=128;
							WriteByte(IX+(signed char)ReadByte(PC+1),work8);

							break;
						}

					/* viklyuchenie bitov */
					case 0x86: 
						{
							work8=ReadByte(IX+(signed char)ReadByte(PC+1));
							work8&=0xfe;
							WriteByte(IX+(signed char)ReadByte(PC+1),work8);

							break;
						}
					case 0x8e: 
						{
							work8=ReadByte(IX+(signed char)ReadByte(PC+1));
							work8&=0xfd;
							WriteByte(IX+(signed char)ReadByte(PC+1),work8);

							break;
						}
					case 0x96: 
						{
							work8=ReadByte(IX+(signed char)ReadByte(PC+1));
							work8&=0xfb;
							WriteByte(IX+(signed char)ReadByte(PC+1),work8);

							break;
						}
					case 0x9e: 
						{
							work8=ReadByte(IX+(signed char)ReadByte(PC+1));
							work8&=0xf7;
							WriteByte(IX+(signed char)ReadByte(PC+1),work8);


							break;
						}
					case 0xa6: 
						{
							work8=ReadByte(IX+(signed char)ReadByte(PC+1));
							work8&=0xef;
							WriteByte(IX+(signed char)ReadByte(PC+1),work8);

							break;
						}
					case 0xae: 
						{
							work8=ReadByte(IX+(signed char)ReadByte(PC+1));
							work8&=0xdf;
							WriteByte(IX+(signed char)ReadByte(PC+1),work8);

							break;
						}

					case 0xb6: 
						{

							work8=ReadByte(IX+(signed char)ReadByte(PC+1));
							work8&=0xbf;
							WriteByte(IX+(signed char)ReadByte(PC+1),work8);

							break;
						}
					case 0xbe: 
						{
							work8=ReadByte(IX+(signed char)ReadByte(PC+1));
							work8&=0x7f;
							WriteByte(IX+(signed char)ReadByte(PC+1),work8);

							break;
						}

					/* proverka bitov */
					case 0x40:
					case 0x41:
					case 0x42:
					case 0x43:
					case 0x44:
					case 0x45:
					case 0x47:
					case 0x46:
						{
							bit(ReadByte(IX+(signed char)ReadByte(PC+1)),0);							
							break;
						}
					case 0x48:
					case 0x49:
					case 0x4a:
					case 0x4b:
					case 0x4c:
					case 0x4d:
					case 0x4e:	
					case 0x4f: 
						{
							bit(ReadByte(IX+(signed char)ReadByte(PC+1)),1);							
							break;
						}
					case 0x56: 
						{
							bit(ReadByte(IX+(signed char)ReadByte(PC+1)),2);							
							break;
						}
					case 0x5e: 
						{
							bit(ReadByte(IX+(signed char)ReadByte(PC+1)),3);							
							break;
						}
					case 0x66: 
						{
							bit(ReadByte(IX+(signed char)ReadByte(PC+1)),4);							
							break;
						}
					case 0x6e: 
						{
							bit(ReadByte(IX+(signed char)ReadByte(PC+1)),5);							
							break;

						}
					case 0x76: 
						{
							bit(ReadByte(IX+(signed char)ReadByte(PC+1)),6);							
							break;
						}
					case 0x7e: 
						{
							bit(ReadByte(IX+(signed char)ReadByte(PC+1)),7);							
							break;
						}

					case 0x3e: /* srl (ix+s) */
						{
							myFflagC_s( ReadByte(IX+(signed char)ReadByte(PC+1)) & 0x01);                                                                  

							work8=ReadByte(IX+(signed char)ReadByte(PC+1));
							work8>>=1;
							WriteByte(IX+(signed char)ReadByte(PC+1),work8);

							znak(ReadByte(IX+(signed char)ReadByte(PC+1)));                                                
							zero(ReadByte(IX+(signed char)ReadByte(PC+1)));
							parity(ReadByte(IX+(signed char)ReadByte(PC+1)));
							myFflagH_s(0);
							myFflagN_s(0);

							break;
						}

					case 0x0e: /* rrc (ix+s) */
						{
							myFflagC_s( ReadByte(IX+(signed char)ReadByte(PC+1)) & 0x01);                                                                  
							WriteByte(IX+(signed char)ReadByte(PC+1),((ReadByte(IX+(signed char)ReadByte(PC+1)) >> 1) | (myFflagC_r() * 128)));                                   

							znak(ReadByte(IX+(signed char)ReadByte(PC+1)));                                                
							zero(ReadByte(IX+(signed char)ReadByte(PC+1)));
							parity(ReadByte(IX+(signed char)ReadByte(PC+1)));
							myFflagH_s(0);
							myFflagN_s(0);

							break;
						}

					case 0x26: /*sla (ix+s)*/
						{  
							myFflagC_s( ((ReadByte(IX+(signed char)ReadByte(PC+1)) & 0x80) != 0));                                                 

							work8=ReadByte(IX+(signed char)ReadByte(PC+1));
							work8<<=1;
							WriteByte(IX+(signed char)ReadByte(PC+1),work8);

							znak(ReadByte(IX+(signed char)ReadByte(PC+1)));                                                
							zero(ReadByte(IX+(signed char)ReadByte(PC+1)));
							parity(ReadByte(IX+(signed char)ReadByte(PC+1)));
							myFflagH_s(0);
							myFflagN_s(0);

							break;
						}

					case 0x1e: /*rr (ix+s) */
						{
							work8 = ReadByte(IX+(signed char)ReadByte(PC+1)) & 0x01;                                                                 
							WriteByte(IX+(signed char)ReadByte(PC+1), ((ReadByte(IX+(signed char)ReadByte(PC+1)) >> 1) | (myFflagC_r() * 128)));                                   
							myFflagC_s( work8 );

							znak(ReadByte(IX+(signed char)ReadByte(PC+1)));                                                
							zero(ReadByte(IX+(signed char)ReadByte(PC+1)));
							parity(ReadByte(IX+(signed char)ReadByte(PC+1)));
							myFflagH_s(0);
							myFflagN_s(0);

							break;

						}

					case 0x06: /*rlc (ix+s)*/
						{
							myFflagC_s( ((ReadByte(IX+(signed char)ReadByte(PC+1)) & 0x80) != 0) );                                                 
							WriteByte(IX+(signed char)ReadByte(PC+1), ((ReadByte(IX+(signed char)ReadByte(PC+1)) << 1) | myFflagC_r()));

							znak(ReadByte(IX+(signed char)ReadByte(PC+1)));                                                
							zero(ReadByte(IX+(signed char)ReadByte(PC+1)));
							parity(ReadByte(IX+(signed char)ReadByte(PC+1)));
							myFflagH_s(0);
							myFflagN_s(0);

							break;
						}

					case 0x16: /* rl (ix+s) */
						{
							work8 = ((ReadByte(IX+(signed char)ReadByte(PC+1)) & 0x80) != 0);                                                
							WriteByte(IX+(signed char)ReadByte(PC+1), ((ReadByte(IX+(signed char)ReadByte(PC+1)) << 1) | myFflagC_r()));                                                  
							myFflagC_s( work8);
							znak(ReadByte(IX+(signed char)ReadByte(PC+1)));                                                
							zero(ReadByte(IX+(signed char)ReadByte(PC+1)));
							parity(ReadByte(IX+(signed char)ReadByte(PC+1)));
							myFflagH_s(0);
							myFflagN_s(0);

							break;
						}

					case 0x2e: /* sra (ix+s) */
						{
							myFflagC_s( ReadByte(IX+(signed char)ReadByte(PC+1)) & 0x01);                                                                  
							work8 = ReadByte(IX+(signed char)ReadByte(PC+1)) & 0x80;                                                                 
							WriteByte(IX+(signed char)ReadByte(PC+1), ((ReadByte(IX+(signed char)ReadByte(PC+1)) >> 1) | work8));                                                 

							znak(ReadByte(IX+(signed char)ReadByte(PC+1)));                                                
							zero(ReadByte(IX+(signed char)ReadByte(PC+1)));
							parity(ReadByte(IX+(signed char)ReadByte(PC+1)));
							myFflagH_s(0);
							myFflagN_s(0);

							break;
						}

					case 0x0f:
						{
							A = ReadByte(IX+(signed char)ReadByte(PC+1));                                                        

							myFflagC_s( A & 0x01 );                                                                  
							A= (A >> 1) | (myFflagC_r() * 128);                                   

							znak(A);                                                
							zero(A);
							parity(A);
							myFflagH_s(0);
							myFflagN_s(0);

							WriteByte(IX+(signed char)ReadByte(PC+1), A); 

							break; 
						}	

					default :
						printf("Z80 :  dd cb S %2x. Unknown. PC=%4x.\n",ReadByte(PC+2),PC-1);
						ExitWithError(-1,"");
				}

				PC+=3;
				return(23);
			}

		case 0xe5 : /* push ix */
			{
				push(IX);
				PC++;
				return(15);
			}

		case 0x96 : /* sub (ix+s) */
			{
				val=ReadByte(IX+(signed char)ReadByte(PC+1));	

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                             
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s( sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC+=2;
				return(19);
			}

		case 0xe1 : /* pop ix */
			{
				pop(&IX);

				PC++;
				return(14);
			}

		case 0x8e: /*adc a,(ix+s) */
			{
				val=ReadByte(IX+(signed char)ReadByte(PC+1));

				work16 = A + (val) + myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s( overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0) );

				PC+=2;
				return(19);
			}

		case 0xe3 : /* ex (sp),ix */
			{
				pop(&XX);
				push(IX);

				IX=XX;

				PC++;
				return(23);
			}


		/* operatsii s polovinkami IX start */

		case 0x24: /*  inc IXh   */
			{
				IXh++;

				znak(IXh);                                                 
				zero(IXh);                                                                  
				myFflagH_s(   (((IXh) & 0x0f) == 0));                                                 
				myFflagPV_s(   ((IXh) == 0x80));                                                               
				myFflagN_s(0);

				PC++;
				return(8);                                                              
			}	

		case 0x25:   /* dec IXh */
			{
				IXh--;

				znak(IXh);
				zero(IXh);
				myFflagPV_s((IXh==0x7f));
				myFflagN_s(1);
				myFflagH_s(    ((IXh&0x0f)==0x0f));

				PC++;
				return(8); 
			}


		case 0x26: 
			{
				IXh=ReadByte(PC+1);

				PC+=2;
				return(11);
			}

		case 0x2c: /* inc IXl   */
			{
				IXl++;


				znak(IXl);                                                 
				zero(IXl);                                                                  
				myFflagH_s(   (((IXl) & 0x0f) == 0));                                                 
				myFflagPV_s(   ((IXl) == 0x80));                                                               
				myFflagN_s(0);

				PC++;
				return(8);                                                              
			}	

		case 0x2d:   /* dec IXl */
			{
				IXl--;

				znak(IXl);
				zero(IXl);
				myFflagPV_s((IXl==0x7f));
				myFflagN_s(1);
				myFflagH_s(    ((IXl&0x0f)==0x0f));

				PC++;
				return(8); 
			}

		case 0x2e: 
			{
				IXl=ReadByte(PC+1);

				PC+=2;
				return(11);
			}

		case 0x44:    
			{
				B=IXh;

				PC++;
				return(8);
			}

		case 0x45:    

			{
				B=IXl;

				PC++;
				return(8);
			}	

		case 0x4c:    
			{
				C=IXh;

				PC++;
				return(8);

			}

		case 0x4d:    
			{
				C=IXl;

				PC++;
				return(8);
			}	

		case 0x54:    
			{
				D=IXh;

				PC++;
				return(8);
			}

		case 0x55:    
			{
				D=IXl;

				PC++;
				return(8);
			}	

		case 0x5c:    
			{
				E=IXh;

				PC++;
				return(8);
			}

		case 0x5d:    
			{
				E=IXl;

				PC++;
				return(8);
			}	

		case 0x60:    
			{
				IXh=B;
				

				PC++;
				return(8);
			}	

		case 0x61:    
			{
				IXh=C;

				PC++;
				return(8);
			}	

		case 0x62:    
			{
				IXh=D;

				PC++;
				return(8);
			}	

		case 0x63:    
			{
				IXh=E;

				PC++;
				return(8);
			}	

		case 0x64:    
			{
				IXh=IXh;

				PC++;
				return(8);
			}	


		case 0x65:    
			{
				IXh=IXl;

				PC++;
				return(8);
			}	

		case 0x67:    
			{
				IXh=A;

				PC++;
				return(8);
			}	


		case 0x68:    
			{
				IXl=B;

				PC++;
				return(8);

			}	


		case 0x69:    
			{
				IXl=C;

				PC++;
				return(8);
			}	

		case 0x6a:    
			{
				IXl=D;

				PC++;
				return(8);
			}	

		case 0x6b:    
			{
				IXl=E;

				PC++;
				return(8);
			}	

		case 0x6c:    
			{
				IXl=IXh;


				PC++;
				return(8);
			}	

		case 0x6d:    
			{
				IXl=IXl;

				PC++;

				return(8);
			}	

		case 0x6f:    
			{
				IXl=A;

				PC++;
				return(8);
			}

		case 0x7c:    
			{
				A=IXh;

				PC++;
				return(8);
			}

		case 0x7d:    
			{
				A=IXl;


				PC++;
				return(8);

			}

		case 0x84:
			{
				val=IXh;

				work16 = A + (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                              
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s(   overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0) );

				PC++;
				return(8);	
			}

		case 0x85:
			{

				val=IXl;

				work16 = A + (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                              
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s(   overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0) );

				PC++;
				return(8);	
			}

		case 0x8c:
			{
				val=IXh;

				work16 = A + (val) + myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s( overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0) );

				PC++;
				return(8);
			}

		case 0x8d:
			{
				val=IXl;

				work16 = A + (val) + myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s( overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0) );

				PC++;
				return(8);
			}

		case 0x94 :
			{
				val=IXh;	

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       

				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                             
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s( sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(8);
			}

		case 0x95 :

			{
				val=IXl;	

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                             
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s( sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(8);
			}

		case 0x9c:
			{
				val=IXh;

				work16 = A - (val) - myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;                                                                              
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(8);
			}

		case 0x9d:
			{
				val=IXl;

				work16 = A - (val) - myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;                                                                              
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(8);
			}

		case 0xa4:
			{

				A=A&IXh;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);
				

				PC++;
				return(8);
			}	

		case 0xa5:
			{
				A=A&IXl;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}	

		case 0xac:
			{
				A=A^IXh;

				ParityA;
				ZnakA;
				ZeroA;

				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}	

		case 0xad:
			{
				A=A^IXl;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}	

		case 0xb4:
			{
				A=A|IXh;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}	

		case 0xb5:
			{
				A=A|IXl;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);


				PC++;
				return(8);
			}	

		case 0xbc:
			{	
				val=IXh;

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				myFflagS_s(   ((work16 & 0x80) != 0));                                                
				myFflagZ_s(   ((work16 & 0xff) == 0));                                                
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(8);

			}

		case 0xbd:
			{	
				val=IXl;

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				myFflagS_s(   ((work16 & 0x80) != 0));                                                
				myFflagZ_s(   ((work16 & 0xff) == 0));                                                
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(8);
			}

		case 0xbf:
			{	
				val=A;

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				myFflagS_s(   ((work16 & 0x80) != 0));                                                
				myFflagZ_s(   ((work16 & 0xff) == 0));                                                
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(8);
			}

		case 0xaf:
			{
				A=A^A;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(8);
			}	

		default :
			return(z80a(0)+4);
	}

	printf("\nZ80 : Unknown instruction dd%x at address %x.\n",ReadByte(PC),PC-1);
	ExitWithError(-1,"");
}

int ED (void)
{
	switch(ReadByte(PC))
	{
		case 0x6b: /* ld hl, (nn) */
			{
				L=ReadByte(ex(ReadByte(PC+2),ReadByte(PC+1)));
				H=ReadByte(ex(ReadByte(PC+2),ReadByte(PC+1))+1);
				PC+=3;
				return(20);
			}

		case 0x7b: /* ld sp, (nn) */
			{
				WriteToRamAddrSpAddr((unsigned char *)&SP, ex(ReadByte(PC+2),ReadByte(PC+1)));
				PC+=3;
				return(20);
			}

		case 0x4b: /* ld bc, (nn) */
			{
				C=ReadByte(ex(ReadByte(PC+2),ReadByte(PC+1)));
				B=ReadByte(ex(ReadByte(PC+2),ReadByte(PC+1))+1);
				PC+=3;
				return(20);
			}

		case 0x5b: /* ld de, (nn) */
			{
				E=ReadByte(ex(ReadByte(PC+2),ReadByte(PC+1)));
				D=ReadByte(ex(ReadByte(PC+2),ReadByte(PC+1))+1);
				PC+=3;
				return(20);
			}

		case 0x63: /* ld (nn), hl */
			{
				WriteByte(ex(ReadByte(PC+2),ReadByte(PC+1)),L);
				WriteByte(ex(ReadByte(PC+2),ReadByte(PC+1))+1,H);
				PC+=3;
				return(20);
			}

		case 0x73: /* ld (nn), sp */
			{
				WriteToSpAddrVal(ex(ReadByte(PC+2),ReadByte(PC+1)),SP);
				PC+=3;
				return(20);
			}

		case 0x43: /* ld (nn),bc */
			{
				WriteByte(ex(ReadByte(PC+2),ReadByte(PC+1)),C);
				WriteByte(ex(ReadByte(PC+2),ReadByte(PC+1))+1,B);
				PC+=3;
				return(20);
			}

		case 0x53: /* ld (nn),de */
			{
				WriteByte(ex(ReadByte(PC+2),ReadByte(PC+1)),E);
				WriteByte(ex(ReadByte(PC+2),ReadByte(PC+1))+1,D);
				PC+=3;
				return(20);
			}

		case 0x47:
			{
				I=A; /* ld i,a */
				PC++;
				return(9);
			}

		/* komandi vichitania s uchetom perenosa */

		case 0x62:
			{
				reg=HL;

				work32 = HL - (reg) - myFflagC_r();                                                   
				idx = ((HL & 0x8800) >> 9) |                                                    
					(((reg) & 0x8800) >> 10) |                                            
					((work32 & 0x8800) >> 11);                                            
				HL1_1 = work32 & 0xffff;                                                                   
				myFflagS_s(   ((HL1_1 & 0x8000) != 0));                                                  
				myFflagZ_s(   (HL1_1 == 0));                                                                             
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);
				myFflagC_s( ((work32 & 0x10000) != 0));
				HL=HL1_1;

				PC++;
				return(15);
			}

		case 0x42:
			{
				reg=BC;

				work32 = HL - (reg) - myFflagC_r();                                                   
				idx = ((HL & 0x8800) >> 9) |                                                    
					(((reg) & 0x8800) >> 10) |                                            
					((work32 & 0x8800) >> 11);                                            
				HL1_1 = work32 & 0xffff;                                                                   
				myFflagS_s(   ((HL1_1 & 0x8000) != 0));                                                  
				myFflagZ_s(   (HL1_1 == 0));                                                                             
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);
				myFflagC_s( ((work32 & 0x10000) != 0));
				HL=HL1_1;

				PC++;
				return(15);
			}

		case 0x52:
			{
				reg=DE;

				work32 = HL - (reg) - myFflagC_r();                                                   
				idx = ((HL & 0x8800) >> 9) |                                                    
					(((reg) & 0x8800) >> 10) |                                            
					((work32 & 0x8800) >> 11);                                            
				HL1_1 = work32 & 0xffff;                                                                   
				myFflagS_s(   ((HL1_1 & 0x8000) != 0));                                                  
				myFflagZ_s(   (HL1_1 == 0));                                                                             
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);
				myFflagC_s( ((work32 & 0x10000) != 0));
				HL=HL1_1;

				PC++;
				return(15);
			}

		case 0x72:
			{
				reg=SP;

				work32 = HL - (reg) - myFflagC_r();                                                   
				idx = ((HL & 0x8800) >> 9) |                                                    
					(((reg) & 0x8800) >> 10) |                                            
					((work32 & 0x8800) >> 11);                                            
				HL1_1 = work32 & 0xffff;                                                                   
				myFflagS_s(   ((HL1_1 & 0x8000) != 0));                                                  
				myFflagZ_s(   (HL1_1 == 0));                                                                             
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);
				myFflagC_s( ((work32 & 0x10000) != 0));
				HL=HL1_1;

				PC++;
				return(15);
			}

		case 0xb8: /* lddr */
			{
				WriteByte(DE,ReadByte(HL));
				BC--;

				HL--; DE--;

				if (!BC)
				{
					myFflagPV_s(0);
					myFflagH_s(0);
					myFflagN_s(0);
					PC++;
					return(16);
				}
				else
				{
					myFflagPV_s(1);
					myFflagH_s(0);
					myFflagN_s(0);
					PC--;
					return(21);
				}
			}

		case 0xa8: /* ldd */
			{
				WriteByte(DE,ReadByte(HL));
				BC--;

				HL--; DE--;

				if (!BC)
					myFflagPV_s(0);
				else
					myFflagPV_s(1);

				myFflagH_s(0);
				myFflagN_s(0);
				PC++;
				return(16);
			}

		case 0xb0: /* ldir */
			{
				WriteByte(DE,ReadByte(HL));
				BC--;

				HL++; DE++;

				if (!BC)
				{
					myFflagPV_s(0);
					myFflagH_s(0);
					myFflagN_s(0);
					PC++;
					return(16);
				}
				else
				{
					myFflagPV_s(1);
					myFflagH_s(0);
					myFflagN_s(0);			
					PC--;
					return(21);
				}
			}

		case 0xa0: /* ldi */
			{
				WriteByte(DE,ReadByte(HL));
				BC--;

				HL++; DE++;

				if (!BC)
					myFflagPV_s(0);
				else
					myFflagPV_s(1);

				myFflagH_s(0);
				myFflagN_s(0);
				PC++;
				return(16);
			}

		case 0x56: /* im1 */
			{
				IM=1;

				PC++;
				return(8);
			}


		/* komandi vivoda na vneshnie ustroistva */

		case 0x79:
			{
				OutPort(C,B,A);
				PC+=1;
				return(12);
			}

		case 0x61:
			{
				OutPort(C,B,H);
				PC+=1;
				return(12);
			}

		case 0x69:
			{
				OutPort(C,B,L);
				PC+=1;
				return(12);
			}

		case 0x41:
			{
				OutPort(C,B,B);
				PC+=1;
				return(12);
			}

		case 0x49:
			{
				OutPort(C,B,C);
				PC+=1;
				return(12);
			}

		case 0x51:
			{
				OutPort(C,B,D);
				PC+=1;
				return(12);

			}

		case 0x59:
			{
				OutPort(C,B,E);
				PC+=1;
				return(12);
			}

		/* komandi vvoda ot vneshnih ystroistv */

		case 0x78: 
			{
				A=InPort(C,B);
				myFflagN_s(0);
				myFflagH_s(0);
				parity(A);
				zero(A);
				znak(A);

				PC+=1;
				return(12);
			}

		case 0x60: 
			{
				H=InPort(C,B);
				myFflagN_s(0);
				myFflagH_s(0);
				parity(H);
				zero(H);
				znak(H);

				PC+=1;
				return(12);
			}

		case 0x68: 
			{
				L=InPort(C,B);
				myFflagN_s(0);
				myFflagH_s(0);
				parity(L);
				zero(L);
				znak(L);

				PC+=1;
				return(12);
			}

		case 0x40: 
			{
				B=InPort(C,B);
				myFflagN_s(0);
				myFflagH_s(0);
				parity(B);
				zero(B);
				znak(B);


				PC+=1;
				return(12);
			}

		case 0x48: 
			{
				C=InPort(C,B);
				myFflagN_s(0);
				myFflagH_s(0);
				parity(C);
				zero(C);
				znak(C);

				PC+=1;
				return(12);
			}

		case 0x50: 
			{
				D=InPort(C,B);
				myFflagN_s(0);
				myFflagH_s(0);
				parity(D);
				zero(D);
				znak(D);

				PC+=1;

				return(12);
			}

		case 0x58: 
			{
				E=InPort(C,B);
				myFflagN_s(0);
				myFflagH_s(0);
				parity(E);
				zero(E);
				znak(E);

				PC+=1;
				return(12);
			}
			



		case 0x70: 
			{
				F=InPort(C,B);
				myFflagN_s(0);
				myFflagH_s(0);
				parity(F);
				zero(F);
				znak(F);

				PC+=1;
				return(12);
			}

		/* komandi slojeniya s uchetom prenosa */

		case 0x6a:
			{
				reg=HL;
				HL1_1=HL;

				work32 = HL1_1 + reg + myFflagC_r();							
				idx = ((HL1_1 & 0x8800) >> 9) |							
					((reg & 0x8800) >> 10) |						
					((work32 & 0x8800) >> 11);						
				HL1_1 = work32 & 0xffff;									
				myFflagS_s(   ((HL1_1 & 0x8000) != 0));							
				myFflagZ_s( (HL1_1 == 0) );										
				myFflagH_s(   hcarry_tbl[idx & 0x7]);							
				myFflagPV_s( overflow_tbl[idx >> 4]);						
				myFflagN_s(0);											
				myFflagC_s( ((work32 & 0x10000) != 0) );		
				HL=HL1_1;

				PC++;
				return(15);
			}

		case 0x4a:
			{
				reg=BC;
				HL1_1=HL;

				work32 = HL1_1 + reg + myFflagC_r();							
				idx = ((HL1_1 & 0x8800) >> 9) |							
					((reg & 0x8800) >> 10) |						
					((work32 & 0x8800) >> 11);						
				HL1_1 = work32 & 0xffff;									
				myFflagS_s(   ((HL1_1 & 0x8000) != 0));
				myFflagZ_s( (HL1_1 == 0) );										
				myFflagH_s(   hcarry_tbl[idx & 0x7]);							
				myFflagPV_s( overflow_tbl[idx >> 4]);						
				myFflagN_s(0);											
				myFflagC_s( ((work32 & 0x10000) != 0) );		
				HL=HL1_1;

				PC++;
				return(15);
			}

		case 0x5a:
			{
				reg=DE;
				HL1_1=HL;

				work32 = HL1_1 + reg + myFflagC_r();							
				idx = ((HL1_1 & 0x8800) >> 9) |							
					((reg & 0x8800) >> 10) |						
					((work32 & 0x8800) >> 11);						
				HL1_1 = work32 & 0xffff;									
				myFflagS_s(   ((HL1_1 & 0x8000) != 0));							
				myFflagZ_s( (HL1_1 == 0) );										
				myFflagH_s(   hcarry_tbl[idx & 0x7]);							
				myFflagPV_s( overflow_tbl[idx >> 4] );						

				myFflagN_s(0);											

				myFflagC_s( ((work32 & 0x10000) != 0) );		
				HL=HL1_1;

				PC++;
				return(15);
			}

		case 0x7a:
			{

				reg=SP;
				HL1_1=HL;

				work32 = HL1_1 + reg + myFflagC_r();							
				idx = ((HL1_1 & 0x8800) >> 9) |							
					((reg & 0x8800) >> 10) |
					((work32 & 0x8800) >> 11);						
				HL1_1 = work32 & 0xffff;									
				myFflagS_s(   ((HL1_1 & 0x8000) != 0));							
				myFflagZ_s( (HL1_1 == 0) );										
				myFflagH_s(   hcarry_tbl[idx & 0x7]);							
				myFflagPV_s( overflow_tbl[idx >> 4] );						
				myFflagN_s(0);											
				myFflagC_s( ((work32 & 0x10000) != 0) );		
				HL=HL1_1;


				PC++;
				return(11);
			}

		case 0x5f: /* ld a,r */
			{
				A=(R&0x7f) | (R7&0x80);

				myFflagPV_s(interrupts);

				ZnakA;
				ZeroA;

				myFflagN_s(0);
				myFflagH_s(0);

				PC++;
				return(9);
			}


		case 0x4d: /* reti */
		case 0x5d:
		case 0x6d:
		case 0x7d:
			{
				pop(&PC);
				/* interrupts=on; */
				return(14);
			}

		case 0x75:
		case 0x55:
		case 0x65:
		case 0x45: /* retn */
			{
				pop(&PC);
				/* interrupts=on; */
				return(14);
			}

		case 0xb9: /* cpdr */
			{
				val = ReadByte(HL);

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				myFflagS_s(   ((work16 & 0x80) != 0));                                               
				myFflagZ_s(   ((work16 & 0xff) == 0));                                                
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s( sub_overflow_tbl[idx >> 4] );                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				HL--; BC--;

				myFflagPV_s(   (BC != 0));

				if ((F&4) && (!(F&64)))
				{
					PC --;
					return(21);
				}

				PC++;

				return(16);
			}

		case 0xb1: /* cpir */
			{
				val = ReadByte(HL);

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				myFflagS_s(   ((work16 & 0x80) != 0));                                               
				myFflagZ_s(   ((work16 & 0xff) == 0));                                                
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s( sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				HL++; BC--;

				myFflagPV_s (BC != 0);

				if ((F&4) && (!(F&64)))
				{
					PC --;
					return(21);
				}

				PC++;
				return(16);
			}

		case 0x44 : /* neg */

		case 0x4c:     /* undocummented (from xzx)*/
		case 0x54:     /* undocummented (from xzx) */
		case 0x5c:     /* undocummented (from xzx) */
		case 0x64:     /* undocummented (from xzx) */
		case 0x6c:     /* undocummented (from xzx)*/
		case 0x74:     /* undocummented (from xzx)*/
		case 0x7c:     /* undocummented (from xzx) */
			{
				work8 = A;
				A = 0;
				val=work8;

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       

				A = work16 & 0xff;                                                                              
				myFflagS_s(   ((A & 0x80) != 0));                                                             
				myFflagZ_s(   (A == 0));                                                                              
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                   
				myFflagC_s( ((work16 & 0x0100) != 0) );

				PC++;
				return(8);
			}

		case 0x5e : /* im2 */
		case 0x7e :
			{
				IM=2;

				PC++;
				return(8);
			}

		case 0x6f: /* rld */
			{
				work8 = ReadByte(HL);
				WriteByte(HL,((work8 << 4) | (A & 0x0f)));
				A = (A & 0xf0) | (work8 >> 4);
				myFflagS_s( ((A & 0x80) != 0) );
				ZeroA;
				myFflagH_s(0);
				ParityA;
				myFflagN_s(0);

				PC++;
				return(18);
			}	

		case 0x57 : /* ld a,i */
			{
				A=I;
				ZnakA;
				ZeroA;
				myFflagH_s(0);
				myFflagPV_s(interrupts); /* !!! */
				myFflagN_s(0);

				PC++;
				return(9);
			}


		case 0xab:
			{
				B--;  
				OutPort(C,B,ReadByte(HL));

				HL--;

				myFflagZ_s(   (B == 0));                                                       
				myFflagN_s(0);                                                             

				PC++;
				return(16);
			}	

		case 0x4f:
			{
				R7=R=A;

				PC++;
				return(9); 
			}
			

			

		case 0xa9: /* cpd */        
			{
				work8 = ReadByte(HL);                                                                      

				/* !cmp! */
				val=work8;

				work16 = A - val;                                                               
				idx = ((A & 0x88) >> 1) |                                                         
					(((val) & 0x88) >> 2) |                                                 
					((work16 & 0x88) >> 3);                                                 
				myFflagS_s( ((work16 & 0x80) != 0) );                                                
				myFflagZ_s( ((work16 & 0xff) == 0) );                                                 
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                            
				myFflagPV_s( sub_overflow_tbl[idx >> 4]);                                            
				myFflagN_s(1);                                                                      
				myFflagC_s( ((work16 & 0x0100) != 0) ); 
				/* !cmp! */                                                                               

				HL--; BC--;

				myFflagPV_s(   (BC != 0));                                                                       


				PC++;
				return(16);
			}	

		case 0x67:  /* rrd */
			{
				work8 = ReadByte(HL);                                                                      
				WriteByte(HL, ((work8 >> 4) | (A << 4)));                                                     
				A = (A & 0xf0) | (work8 & 0x0f);                                                          
				ZnakA;
				ZeroA;                                                                        
				ParityA;                                                                       
				myFflagH_s(0);  
				myFflagN_s(0);                                                                              

				PC++;
				return(18);
			}	

		case 0xa1:   /* cpi */
			{
				work8 = ReadByte(HL);                                                                      

				/* !cmp! */
				val=work8;

				work16 = A - val;                                                               
				idx = ((A & 0x88) >> 1) |                                                         
					(((val) & 0x88) >> 2) |                                                 
					((work16 & 0x88) >> 3);                                                 
				myFflagS_s( ((work16 & 0x80) != 0) );                                                
				myFflagZ_s( ((work16 & 0xff) == 0) );                                                 
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                            
				myFflagPV_s( sub_overflow_tbl[idx >> 4]);                                            
				myFflagN_s(1);                                                                      
				myFflagC_s( ((work16 & 0x0100) != 0) ); 
				/* !cmp! */
				

				HL++; BC--;

				myFflagPV_s(   (BC != 0));                                                                       

				PC++;
				return(16);
			}

		case 0xa3:

			{
				B--;                                                                    
				OutPort(C,B,ReadByte(HL));
				HL++;                                                                   
				myFflagZ_s( (B == 0) );                                                      
				myFflagN_s(1);                                                            

				PC++;
				return(16);
			}

		case 0xa2:
			{
				WriteByte(HL, InPort(C,B));

				B--; 
				HL++; 
				myFflagZ_s(   (B == 0));
				myFflagN_s(1);

				PC++;
				return(16);
			}

		case 0x46:
		case 0x4e:
		case 0x66:
		case 0x6e:
			{
				IM=0;

				PC++;
				return(8);
			}

		case 0x71:
			{
				OutPort(C,B,0);

				PC++;
				return(12);
			}

		case 0x00:
		case 0x01:
		case 0x02:
		case 0x03:
		case 0x04:
		case 0x05:
		case 0x06:
		case 0x07:
		case 0x08:
		case 0x09:
		case 0x0A:
		case 0x0B:
		case 0x0C:
		case 0x0D:
		case 0x0E:
		case 0x0F:

		case 0x10:
		case 0x11:
		case 0x12:
		case 0x13:
		case 0x14:
		case 0x15:
		case 0x16:
		case 0x17:
		case 0x18:
		case 0x19:
		case 0x1A:
		case 0x1B:
		case 0x1C:
		case 0x1D:
		case 0x1E:
		case 0x1F:

		case 0x20:
		case 0x21:
		case 0x22:
		case 0x23:
		case 0x24:
		case 0x25:
		case 0x26:
		case 0x27:
		case 0x28:
		case 0x29:
		case 0x2A:
		case 0x2B:
		case 0x2C:
		case 0x2D:
		case 0x2E:
		case 0x2F:

		case 0x30:
		case 0x31:
		case 0x32:
		case 0x33:
		case 0x34:
		case 0x35:
		case 0x36:
		case 0x37:
		case 0x38:
		case 0x39:
		case 0x3A:
		case 0x3B:
		case 0x3C:
		case 0x3D:
		case 0x3E:
		case 0x3F:

		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF:

		case 0xC0:
		case 0xC1:
		case 0xC2:
		case 0xC3:
		case 0xC4:
		case 0xC5:
		case 0xC6:
		case 0xC7:
		case 0xC8:
		case 0xC9:
		case 0xCA:
		case 0xCB:
		case 0xCC:
		case 0xCD:
		case 0xCE:
		case 0xCF:

		case 0xD0:
		case 0xD1:
		case 0xD2:
		case 0xD3:
		case 0xD4:
		case 0xD5:
		case 0xD6:
		case 0xD7:
		case 0xD8:
		case 0xD9:
		case 0xDA:
		case 0xDB:
		case 0xDC:
		case 0xDD:
		case 0xDE:
		case 0xDF:

		case 0xE0:
		case 0xE1:
		case 0xE2:
		case 0xE3:
		case 0xE4:
		case 0xE5:
		case 0xE6:
		case 0xE7:
		case 0xE8:
		case 0xE9:
		case 0xEA:
		case 0xEB:
		case 0xEC:
		case 0xED:
		case 0xEE:
		case 0xEF:


		case 0xB4:
		case 0xB5:
		case 0xB6:
		case 0xB7:

		case 0xAC:
		case 0xAD:
		case 0xAE:
		case 0xAF:

		case 0xA4:
		case 0xA5:
		case 0xA6:
		case 0xA7:

		case 0x7F:

		case 0x80:
		case 0x81:
		case 0x82:
		case 0x83:
		case 0x84:
		case 0x85:
		case 0x86:
		case 0x87:
		case 0x88:
		case 0x89:
		case 0x8A:
		case 0x8B:
		case 0x8C:
		case 0x8D:
		case 0x8E:
		case 0x8F:

		case 0x90:
		case 0x91:
		case 0x92:
		case 0x93:
		case 0x94:
		case 0x95:
		case 0x96:
		case 0x97:
		case 0x98:
		case 0x99:
		case 0x9A:
		case 0x9B:
		case 0x9C:
		case 0x9D:
		case 0x9E:
		case 0x9F:

/*		
		case 0x00 ... 0x3f:
		case 0xbc ... 0xff:
		case 0xb4 ... 0xb7:
		case 0xac ... 0xaf:
		case 0xa4 ... 0xa7:
		case 0x7f ... 0x9f:
*/
			{ /* NOP */

				PC++;
				return(8);
			}	
	}

	printf("\nZ80 : Unknown instruction ed%x at address %x.\n",ReadByte(PC),PC-1);
	ExitWithError(-1,"");

	return(0); /* eto chtob ne kvakalo */
}

int NadoPropustitEtotTapeBlock(tape_struct * t)
{
	if (t==NULL) return(0);

	if ((t->id==0x30)||(t->id==0x32)||(t->id==0x33)||(t->id==0x35)||(t->id=='Z')) return (1);

	return(0);
}

void EnsureVisibleAndSelect(int position)
{
	int NvisibleItemCount; /*skolko vidimih*/
	int top; /*first visible*/


	XtVaGetValues(tape_lb, XmNvisibleItemCount, &NvisibleItemCount, XmNtopItemPosition, &top, NULL);

	if (position<top) XmListSetPos(tape_lb, position);
	if (position>=(top+NvisibleItemCount)) XmListSetPos(tape_lb, position-NvisibleItemCount+1);
	

	XmListSelectPos(tape_lb, position, False);
}

int TapeNextNext(void)
{
	tape_struct * next;
	int first=0;


	if (tapes==NULL)
	{
		tape_next=NULL;
		return(1);
	}

	next=tape_next->next;

LR:
	if (next==tape_next)
		return(1);

	if (next==NULL)
	{
		next=FindTapeByPosition(1);
		first=1;	
	}

	if ((NadoPropustitEtotTapeBlock(next))||(next->position==0))
	{
		next=next->next;
		goto LR;
	}

	EnsureVisibleAndSelect(next->position);

	tape_next=next;

	return(first);
}

int ABlockStandartniyP(tape_struct * t)
{
	unsigned char * data;

	if (!t) return(0);


	if (!tape_traps) return(0);
	if (t->id!=0x10) return(0);

	data=t->data1;

	if ((data[0]!=0)&&(data[0]!=255)) return(0);

	return(1);
}

int AMojnoliTrapit(void)
{
	if (TRDOS) return(0);
	if (tape_next==NULL) return(0);

	if (NadoPropustitEtotTapeBlock(tape_next))
		TapeNextNext();

	if (ABlockStandartniyP(tape_next)) return(1);
	return(0);
}

unsigned char b2bget(unsigned char * otkuda, unsigned int pos)
{
	unsigned int bc;
	unsigned char bn;
	unsigned char byte;
	unsigned char mn;

	bc=pos/8;
	bn=pos-bc*8;

	byte=otkuda[bc];

	switch (bn)
	{
		case 0 : mn=128; break;
		case 1 : mn=64;  break;
		case 2 : mn=32;  break;
		case 3 : mn=16;  break;

		case 4 : mn=8; break;
		case 5 : mn=4; break;
		case 6 : mn=2; break;
		case 7 : mn=1; break;

		default :
			mn=0;
			printf("b2bget : bn==%d. This is bug. report it.\n",bn);
	}


	if (byte&mn) return(1);
	return(0);
}

void b2bset(unsigned char * kuda, unsigned int pos, unsigned char bit)
{
	unsigned int bc;
	unsigned char bn;
	unsigned char mn;

	bc=pos/8;
	bn=pos-bc*8;

	switch (bn)
	{
		case 0 : mn=128; break;
		case 1 : mn=64;  break;
		case 2 : mn=32;  break;
		case 3 : mn=16;  break;

		case 4 : mn=8; break;
		case 5 : mn=4; break;
		case 6 : mn=2; break;
		case 7 : mn=1; break;

		default :
			mn=0;
			printf("b2bset : bn==%d. This is bug. report it.\n",bn);
	}

	if (!bit)
		kuda[bc]&=~mn;
	else
		kuda[bc]|=mn;
}

unsigned char kkk;
int Fill(unsigned char * tape, unsigned int * tape_len, tape_struct * next)
{
	turbo_block_type * t1;
	unsigned int i,j,l;
	unsigned char byte;
	ROM_bl_type * rom;
	unsigned short len16;
	Pure_toneT * ptone;
	unsigned short * pulses;
	Pure_dataT * pdata;
	int len;
	direct_recT * direct;


	/* printf("%d\n", next->id);*/


	if (next->id==0x11)
	{
		t1=next->info;

		for (i=0; i<t1->pilot_toneL_inPulses; i++)
		{
			for (j=0; j<(44100/(3500000/t1->pilotL)); j++)
				b2bset(tape, (*tape_len)++,kkk);
			kkk=1-kkk;

			for (j=0; j<(44100/(3500000/t1->pilotL)); j++)
				b2bset(tape, (*tape_len)++,kkk);
			kkk=1-kkk;
		}

		for (j=0; j<(44100/(3500000/t1->syncFL)-2); j++)
			b2bset(tape, (*tape_len)++,kkk);
		kkk=1-kkk;

		for (j=0; j<(44100/(3500000/t1->syncSL)-2); j++)
			b2bset(tape, (*tape_len)++,kkk);
		kkk=1-kkk;

		for (i=0; i<(t1->l1+t1->l2*256+t1->l3*65536-1); i++)
		{
			byte=next->data1[i];
			for (l=0; l<8; l++)
			{
				if (b2bget(&byte,l))
				{
					for (j=0; j<(44100/(3500000/t1->oneL)); j++)
						b2bset(tape, (*tape_len)++,kkk);
					kkk=1-kkk;

					for (j=0; j<(44100/(3500000/t1->oneL)); j++)
						b2bset(tape, (*tape_len)++,kkk);
					kkk=1-kkk;
				}
				else
				{
					for (j=0; j<(44100/(3500000/t1->zeroL)-1); j++)
						b2bset(tape, (*tape_len)++,kkk);
					kkk=1-kkk;

					for (j=0; j<(44100/(3500000/t1->zeroL)-1); j++)
						b2bset(tape, (*tape_len)++,kkk);
					kkk=1-kkk;
				}	
			}
		}

		byte=next->data1[i];
		for (l=0; l<t1->used_bits; l++)
		{
			if (b2bget(&byte,l))
			{
				for (j=0; j<(44100/(3500000/t1->oneL)); j++)
					b2bset(tape, (*tape_len)++,kkk);
				kkk=1-kkk;

				for (j=0; j<(44100/(3500000/t1->oneL)); j++)
					b2bset(tape, (*tape_len)++,kkk);
				kkk=1-kkk;
			}
			else
			{
				for (j=0; j<(44100/(3500000/t1->zeroL)-1); j++)
					b2bset(tape, (*tape_len)++,kkk);
				kkk=1-kkk;

				for (j=0; j<(44100/(3500000/t1->zeroL)-1); j++)
					b2bset(tape, (*tape_len)++,kkk);
				kkk=1-kkk;
			}	
		}			

		for (j=0; j<((double)44100*(double)t1->pause/(double)1000); j++)
			b2bset(tape, (*tape_len)++,kkk);
		if (t1->pause)
			kkk=1-kkk;

		return(no_errors);
	}

	if (next->id==0x10)
	{
		rom=next->info;

		for (i=0; i<8064; i++)
		{
			for (j=0; j<((double)44100/((double)3500000/(double)2168)); j++)
				b2bset(tape, (*tape_len)++,kkk);
			kkk=1-kkk;

			for (j=0; j<((double)44100/((double)3500000/(double)2168)); j++)
				b2bset(tape, (*tape_len)++,kkk);
			kkk=1-kkk;
		}

		for (j=0; j<((double)44100/((double)3500000/(double)667)); j++)
			b2bset(tape, (*tape_len)++,kkk);
		kkk=1-kkk;

		for (j=0; j<((double)44100/((double)3500000/(double)735)); j++)
			b2bset(tape, (*tape_len)++,kkk);
		kkk=1-kkk;

		for (i=0; i<(rom->len); i++)
		{
			byte=next->data1[i];
			for (l=0; l<8; l++)
			{
				if (b2bget(&byte,l))
				{
					for (j=0; j<((double)44100/((double)3500000/(double)1710)); j++)
						b2bset(tape, (*tape_len)++,kkk);
					kkk=1-kkk;

					for (j=0; j<((double)44100/((double)3500000/(double)1710)); j++)
						b2bset(tape, (*tape_len)++,kkk);
					kkk=1-kkk;
				}
				else
				{
					for (j=0; j<((double)44100/((double)3500000/(double)855)); j++)
						b2bset(tape, (*tape_len)++,kkk);
					kkk=1-kkk;

					for (j=0; j<((double)44100/((double)3500000/(double)855)); j++)
						b2bset(tape, (*tape_len)++,kkk);
					kkk=1-kkk;
				}	
			}
		}

		for (j=0; j<((double)44100*(double)rom->pause/(double)1000); j++)

			b2bset(tape, (*tape_len)++,kkk);
		if (rom->pause)
			kkk=1-kkk;

		return(no_errors);
	}

	if (next->id==0x20)
	{
		memcpy(&len16, next->info, 2);

		if (!len16)
			return(errors);

		kkk=0;
		for (j=0; j<((double)44100*(double)len16/(double)1000); j++)
			b2bset(tape, (*tape_len)++,kkk);
		kkk=1-kkk;

		return(no_errors);
	}

	if (next->id==0x12)
	{
		ptone=next->info;

		for (i=0; i<ptone->n; i++)
		{
			for (j=0; j<((double)44100/((double)3500000/(double)ptone->len)); j++)
				b2bset(tape, (*tape_len)++,kkk);
			kkk=1-kkk;

			/*
			for (j=0; j<((double)44100/((double)3500000/(double)ptone->len)); j++)
				b2bset(tape, (*tape_len)++,kkk);
			kkk=1-kkk;
			*/
		}

		return(no_errors);
	}

	if (next->id==0x13)
	{
		len=next->len/2;
		pulses=(unsigned short *)next->data1;

		for (i=0; i<len; i++)
		{
			/*printf("%d\n", pulses[i]);*/

			for (j=0; j<((double)44100/((double)3500000/(double)pulses[i])); j++)
				b2bset(tape, (*tape_len)++,kkk);
			kkk=1-kkk;
		}

		return(no_errors);
	}

	if (next->id==0x14)
	{
		pdata=next->info;

		for (i=0; i<(pdata->l1+pdata->l2*256+pdata->l3*65536-1); i++)
		{
			byte=next->data1[i];
			for (l=0; l<8; l++)
			{
				if (b2bget(&byte,l))
				{
					for (j=0; j<((double)44100/((double)3500000/(double)pdata->o)); j++)
						b2bset(tape, (*tape_len)++,kkk);
					kkk=1-kkk;

					for (j=0; j<((double)44100/((double)3500000/(double)pdata->o)); j++)
						b2bset(tape, (*tape_len)++,kkk);
					kkk=1-kkk;
				}
				else
				{
					for (j=0; j<((double)44100/((double)3500000/(double)pdata->z)-(((pdata->z)<700)?2:3)); j++)
						b2bset(tape, (*tape_len)++,kkk);
					kkk=1-kkk;

					for (j=0; j<((double)44100/((double)3500000/(double)pdata->z)-(((pdata->z)<700)?2:3)); j++)
						b2bset(tape, (*tape_len)++,kkk);
					kkk=1-kkk;
				}	
			}
		}

		byte=next->data1[i];
		for (l=0; l<pdata->used; l++)
		{
			if (b2bget(&byte,l))
			{
				for (j=0; j<((double)44100/((double)3500000/(double)pdata->o)); j++)
					b2bset(tape, (*tape_len)++,kkk);
				kkk=1-kkk;

				for (j=0; j<((double)44100/((double)3500000/(double)pdata->o)); j++)
					b2bset(tape, (*tape_len)++,kkk);
				kkk=1-kkk;
			}
			else
			{
				for (j=0; j<((double)44100/((double)3500000/(double)pdata->z)-(((pdata->z)<700)?2:3)); j++)
					b2bset(tape, (*tape_len)++,kkk);
				kkk=1-kkk;

				for (j=0; j<((double)44100/((double)3500000/(double)pdata->z)-(((pdata->z)<700)?2:3)); j++)
					b2bset(tape, (*tape_len)++,kkk);
				kkk=1-kkk;
			}	
		}			

		for (j=0; j<((double)44100*(double)pdata->pause/(double)1000); j++)
			b2bset(tape, (*tape_len)++,kkk);
		if (pdata->pause)
			kkk=1-kkk;

		return(no_errors);
	}

	if (next->id==0x15)
	{
		direct=next->info;

		if (direct->TS==79)
		{
			for (i=0; i<(next->len*8-1); i++)
				b2bset(tape, (*tape_len)++, b2bget(next->data1, i));

			for (l=0; l<direct->used; l++)
				b2bset(tape, (*tape_len)++, b2bget(next->data1, i+l));
		}
		else
		{
			for (i=0; i<(next->len*8-1); i++)
			{
				b2bset(tape, (*tape_len)++, b2bget(next->data1, i));
				b2bset(tape, (*tape_len)++, b2bget(next->data1, i));
			}

			for (l=0; l<direct->used; l++)
			{
				b2bset(tape, (*tape_len)++, b2bget(next->data1, i+l));
				b2bset(tape, (*tape_len)++, b2bget(next->data1, i+l));
			}
		}

		for (j=0; j<((double)44100*(double)direct->pause/(double)1000); j++)
			b2bset(tape, (*tape_len)++,kkk);
		if (direct->pause)
			kkk=1-kkk;

		return(no_errors);
	}

	if (next->id==0x22)
	{
		for (j=0; j<((double)44100/((double)3500000/(double)4000)); j++)
			b2bset(tape, (*tape_len)++,kkk);
		kkk=1-kkk;

		return(errors);
	}

	return(errors);
}

void MaxSpeenND_Stop(void)
{
	if (tape_loading_method==2)
		turbo_speedTL=0;
	if (tape_loading_method==1)
	{
		if (z80_speed_saved)
			setZ80spd_100(NULL, (XtPointer)z80_speed_saved, NULL);
	}
}

void MaxSpeenND_Start(void)
{
	if (tape_loading_method==1)
	{
		if (!z80_max_spd)
		{
			if (z80_speed_calculated)
				setZ80spd_100(NULL, (XtPointer)z80_speed_calculated, NULL);
		}
		else
			setZ80spd_100(NULL, (XtPointer)z80_max_spd, NULL);			
	}

	if (tape_loading_method==2)
		turbo_speedTL=1;
}

unsigned short neproigrannaya_pausa=0;

void tapeFill_tape(int Force)
{
	int group=0;
	tape_struct * next;
	unsigned int j;

	ROM_bl_type * rom;
	unsigned short len16;

	unsigned short rep=0;
	int i;
	signed short * jump;

	

	if (!tape_next) return;

	tape_len=tape_pos=0;

	if (NadoPropustitEtotTapeBlock(tape_next))
		TapeNextNext();

	tape_IsPlayable(tape_next);

	if ((ABlockStandartniyP(tape_next))&&(!Force))
	{
		showQTape=1;
		EnableWidget(tape_lb);

		DisableWidget(tape_stop);
		DisableWidget(tape_pause);

		rom=tape_next->info;
		neproigrannaya_pausa=rom->pause;


		tape_IsPlayable(tape_next);

		MaxSpeenND_Stop();

		return;
	}

	Zamolchi();

	kkk=0;
	for (j=0; j<(44100*neproigrannaya_pausa/1000); j++)
		b2bset(tape,tape_len++,kkk);
	neproigrannaya_pausa=0;

	kkk=0;
	next=tape_next;
	while (TRUE)
	{
		if (next->id==0x20)
		{
			memcpy(&len16, next->info, 2);

			if (!len16)
			{
				tape_pauseF(NULL, NULL, NULL);
				return;
			}
			else
				Fill(tape, &tape_len, next);
		}

		if (Fill(tape, &tape_len, next)==no_errors)
			goto LE;

		if (next->id==0x21)
		{
			group=1;
			goto LE;
		}

		if (next->id==0x22)
		{
			group=0;
			goto LE;
		}

		if (next->id==0x24) 
		{
			memcpy(&rep, next->info, 2);
			goto LE;
		}

		if (next->id==0x25) 
		{
			if (rep) rep--;

			if (rep)
			{
			LP:
				next=TapeFindParent(next);
				if (next->id==0x24)
				{
					next=next->next;
					continue;
				}
				goto LP;
			}

			goto LE;
		}

		if (next->id==0x23) 
		{
			jump=next->info;

			i=0;
			if (*jump>0)
			{
			LP1:
				next=next->next;
				i++;

				if (i<*jump) goto LP1;
			}
			else
			{
			LO:
				next=TapeFindParent(next);
				i--;

				if (i>*jump) goto LO;
			}

			EnsureVisibleAndSelect(next->position);
			tape_next=next;

			tapeFill_tape(0);
			return;
		}

		printf("*** tapeFill_tape : UNKNOWN BLOCK ID=0x%x ! This is bug. Report it. ***\n", next->id);

	LE:
		if ((!group)&&(!rep)) 
		{
			tape_rew_counter=tape_rew_counter_const;

			DisableWidget(tape_play);
			EnableWidget(tape_stop);
			EnableWidget(tape_pause);

			showQTape=2;
			/*DisableWidget(tape_lb);*/

			DisableWidget(tape_delete);
			tape_IsPlayableV(tape_next);

			MaxSpeenND_Start();

			return;
		}

		next=next->next;
	}
}

void TapeTrapLoad(void)
{
	int i;
	unsigned char * data;


	data=(unsigned char *)(tape_next->data1+1);

	for (i=IX; i<(IX+DE); i++)
		WriteByte(i,data[i-IX]);

	showQTape=1;

	TapeNextNext();
	tapeFill_tape(0);
}

void TapeTrapSave(void)
{
	unsigned char data [65536];
	int i;
	unsigned char a;
	int len;
	ROM_bl_type rom;


	len=DE+2;
	data[0]=A;

	for (i=IX; i<(IX+DE); i++)
		data[i-IX+1]=ReadByte(i);

	a=data[0];
	for (i=1;i<(DE+1);i++)
		a^=data[i];

	data[len-1]=a;

	rom.pause=1000;
	rom.len=len;

	AddTapeBlock("", 0x10, len, data, sizeof(rom), &rom, 1);

	showQTape=1;
}

/*execute z80 command at PC and increase PC
returns number of z80 tacts wasted*/
int z80a(int interrupt)
{
#if defined log
	PrintSpInfo();
	interrupt=0;	
#endif

	R++;

	if (interrupt)
	{
		if (interrupts)
		{
			interrupts=off;
			halted=off;

			switch(IM)
			{
				case 1: 
					{
						push(PC);
						PC=0x0038;

						return(13);
					}

				case 2: 
					{
						push(PC);
						WriteToRamAddrSpAddr((unsigned char *)&PC, I*256+data_bus);

						return(19);
					}

				case 0:
					{
						if (data_bus==255)
						{
							push(PC);
							PC=0x0038;

							return(12);
						}
						else
						{
							printf("data_bus == %d. This is not supported.",data_bus);
							ExitWithError(-1,"");
						}
					/* !!! a vot tuta ne dodelano*/
					}

				default:
					{
						printf("Unknown interrupts type %d.\n",IM);
						ExitWithError(-1,"");
					}
			}
		}
	}

	if (halted)
		return(4);

	if (PC>=16384)
		TRDOS=off;
	else
	{
		if (((PC&0xff00)==0x3d00))
		{
			if (new_rom!=ROM0) 
			{
				if ((Mode[0]=='P')||(Mode[0]=='p')||(Mode[0]=='S')||(Mode[0]=='s'))
					TRDOS=on;
			}
		}

		if ((PC==1218)&&(!TRDOS)) 
		{
			TapeTrapSave();
			pop(&PC);
			return(4);
		}

		if (PC==1366)
		{
			if (!direct_recording)
			{
				if ((tape_pos<tape_len)&&(tape_next->id!=0x15)&&(tape_traps)) tape_stopF(NULL, NULL, NULL);

				if (AMojnoliTrapit())
				{
					TapeTrapLoad();
					pop(&PC);
					return(4);
				}
				else
				if (tape_pos>=tape_len) tapeFill_tape(1);
			}
		}
	}

	switch(ReadByte(PC))
	{
		/* interrupts*/

		case 0xf3: /* di */
			{
				interrupts=off; 
				PC++;
				return(4);
			}


		case 0xfb: /* ei */
			{
				/* #if !defined log */
				interrupts=on;
				/* #endif*/
				PC++;
				return(4);
			}

		/* zagruzka chisla v registr */

		case 0x3e:
			{
				A=ReadByte(PC+1);
				PC+=2;
				return(7);
			}

		case 0x06:
			{
				B=ReadByte(PC+1);
				PC+=2;
				return(7);
			}

		case 0x0e:
			{
				C=ReadByte(PC+1);
				PC+=2;
				return(7);
			}

		case 0x16:
			{
				D=ReadByte(PC+1);
				PC+=2;
				return(7);
			}

		case 0x1e:
			{
				E=ReadByte(PC+1);
				PC+=2;
				return(7);
			}

		case 0x26:
			{
				H=ReadByte(PC+1);
				PC+=2;
				return(7);
			}

		case 0x2e:
			{
				L=ReadByte(PC+1);
				PC+=2;
				return(7);
			}

		/* zagruzka chisla v registrovuu paru */

		case 0x21:
			{
				L=ReadByte(PC+1);

				H=ReadByte(PC+2);
				PC+=3;
				return(10);
			}

		case 0x11:
			{
				E=ReadByte(PC+1);
				D=ReadByte(PC+2);
				PC+=3;
				return(10);
			}

		case 0x01:
			{
				C=ReadByte(PC+1);
				B=ReadByte(PC+2);
				PC+=3;
				return(10);
			}

		case 0x31:
			{
				WriteToRamAddrSpAddr((unsigned char *)&SP, PC+1);
				PC+=3;
				return(10);
			}

		/* Kopirovanie soderjimogo odinochnih registrov */

		case 0x7f:
			{
				A=A;
				PC++;
				return(4);
			}

		case 0x7c:
			{
				A=H;
				PC++;
				return(4);
			}

		case 0x7d:
			{
				A=L;
				PC++;
				return(4);
			}

		case 0x78:
			{
				A=B;
				PC++;
				return(4);
			}

		case 0x79:
			{
				A=C;
				PC++;
				return(4);

			}

		case 0x7a:
			{
				A=D;
				PC++;
				return(4);
			}

		case 0x7b:

			{
				A=E;
				PC++;
				return(4);
			}

		case 0x67:
			{
				H=A;
				PC++;
				return(4);
			}

		case 0x64:
			{
				H=H;
				PC++;
				return(4);
			}

		case 0x65:
			{
				H=L;
				PC++;
				return(4);
			}

		case 0x60:
			{
				H=B;
				PC++;
				return(4);
			}

		case 0x61:
			{
				H=C;
				PC++;

				return(4);
			}

		case 0x62:

			{
				H=D;
				PC++;
				return(4);
			}

		case 0x63:
			{
				H=E;
				PC++;
				return(4);
			}

		case 0x6f:
			{
				L=A;
				PC++;
				return(4);

			}

		case 0x6c:
			{
				L=H;

				PC++;
				return(4);
			}

		case 0x6d:
			{
				L=L;
				PC++;
				return(4);
			}

		case 0x68:
			{
				L=B;
				PC++;

				return(4);
			}


		case 0x69:
			{
				L=C;
				PC++;
				return(4);
			}

		case 0x6a:
			{
				L=D;
				PC++;
				return(4);
			}

		case 0x6b:
			{
				L=E;
				PC++;
				return(4);
			}

		case 0x47:

			{
				B=A;
				PC++;
				return(4);
			}

		case 0x44:
			{
				B=H;
				PC++;
				return(4);
			}

		case 0x45:
			{
				B=L;
				PC++;
				return(4);
			}

		case 0x40:
			{
				B=B;
				PC++;
				return(4);
			}

		case 0x41:
			{
				B=C;
				PC++;
				return(4);
			}



		case 0x42:

			{
				B=D;
				PC++;
				return(4);
			}

		case 0x43:
			{
				B=E;
				PC++;
				return(4);
			}

		case 0x4f:
			{
				C=A;
				PC++;
				return(4);
			}

		case 0x4c:
			{
				C=H;
				PC++;
				return(4);
			}

		case 0x4d:
			{
				C=L;
				PC++;
				return(4);
			}

		case 0x48:
			{
				C=B;
				PC++;
				return(4);
			}

		case 0x49:
			{
				C=C;
				PC++;
				return(4);
			}


		case 0x4a:
			{
				C=D;
				PC++;
				return(4);
			}

		case 0x4b:
			{
				C=E;
				PC++;
				return(4);
			}

		case 0x57:
			{
				D=A;
				PC++;
				return(4);
			}

		case 0x54:
			{
				D=H;
				PC++;
				return(4);
			}

		case 0x55:
			{
				D=L;
				PC++;
				return(4);
			}

		case 0x50:
			{
				D=B;
				PC++;
				return(4);
			}

		case 0x51:
			{
				D=C;
				PC++;
				return(4);
			}

		case 0x52:
			{
				D=D;
				PC++;
				return(4);
			}

		case 0x53:
			{
				D=E;
				PC++;
				return(4);
			}

		case 0x5f:
			{
				E=A;
				PC++;
				return(4);
			}

		case 0x5c:
			{
				E=H;
				PC++;
				return(4);
			}

		case 0x5d:
			{
				E=L;
				PC++;
				return(4);
			}

		case 0x58:
			{
				E=B;
				PC++;
				return(4);
			}

		case 0x59:
			{
				E=C;
				PC++;
				return(4);
			}

		case 0x5a:
			{
				E=D;
				PC++;
				return(4);
			}

		case 0x5b:
			{
				E=E;
				PC++;
				return(4);
			}

		/* kopirovanie soderjimogo registrovih par */

		case 0xf9:
			{
				SP=HL;
				PC++;
				return(6);
			}

		/* zagruzka registrov iz pamyati pryamoy adresitsiei */

		case 0x3a:
			{
				A=ReadByte(ex(ReadByte(PC+2), ReadByte(PC+1)));
				PC+=3;
				return(13);
			}

		case 0x2a:
			{
				L=ReadByte(ex(ReadByte(PC+2), ReadByte(PC+1)));
				H=ReadByte(ex(ReadByte(PC+2), ReadByte(PC+1))+1);

				PC+=3;
				return(16);
			}

		/* zagruzka registrov iz pamyati kosvennoy adresatsiei */

		case 0x7e:

			{
				A=ReadByte(HL);
				PC++;
				return(7);
			}

		case 0x0a:
			{
				A=ReadByte(BC);
				PC++;
				return(7);
			}

		case 0x1a:
			{

				A=ReadByte(DE);
				PC++;
				return(7);
			}

		case 0x66:

			{

				H=ReadByte(HL);
				PC++;
				return(7);
			}

		case 0x6e:
			{
				L=ReadByte(HL);
				PC++;
				return(7);
			}

		case 0x46:
			{
				B=ReadByte(HL);
				PC++;
				return(7);
			}

		case 0x4e:
			{
				C=ReadByte(HL);
				PC++;
				return(7);
			}

		case 0x56:
			{
				D=ReadByte(HL);
				PC++;
				return(7);
			}

		case 0x5e:
			{
				E=ReadByte(HL);
				PC++;
				return(7);
			}

		/* 	komandi obmena */

		case 0xeb:
			{
				D2=D; E2=E;
				D=H; E=L;
				H=D2; L=E2;
				PC++;
				return(4);
			}	

		case 0xd9:
			{
				B2=B; C2=C; D2=D; E2=E; H2=H; L2=L;
				B=B1; C=C1; D=D1; E=E1; H=H1; L=L1;
				B1=B2; C1=C2; D1=D2; E1=E2; H1=H2; L1=L2;

				PC++;
				return(4);
			}	
			

		case 0x08:
			{
				A2=A; F2=F; 

				A=A1; F=F1; 
				A1=A2; F1=F2; 

				PC++;
				return(4);
			}	

		/* zapis' v pamyat' pryamoi adresatsiei */

		case 0x32:
			{
				WriteByte(ex(ReadByte(PC+2),ReadByte(PC+1)),A);
				PC+=3;
				return(13);
			}

		case 0x22:
			{
				WriteByte(ex(ReadByte(PC+2),ReadByte(PC+1)),L);
				WriteByte(ex(ReadByte(PC+2),ReadByte(PC+1))+1,H);

				PC+=3;
				return(16);
			}	

		/* Zapis' v pamyat' s kosvennoi adresatsiei */

		case 0x77:
			{
				WriteByte(HL,A);
				PC++;
				return(7);
			}


		case 0x02:
			{
				WriteByte(BC,A);
				PC++;
				return(7);
			}

		case 0x12:
			{
				WriteByte(DE,A);
				PC++;
				return(7);
			}

		case 0x74:
			{

				WriteByte(HL,H);
				PC++;
				return(7);
			}

		case 0x75:
			{
				WriteByte(HL,L);
				PC++;
				return(7);
			}

		case 0x70:
			{
				WriteByte(HL,B);
				PC++;
				return(7);
			}

		case 0x71:
			{
				WriteByte(HL,C);
				PC++;
				return(7);
			}


		case 0x72:
			{
				WriteByte(HL,D);
				PC++;
				return(7);
			}

		case 0x73:
			{
				WriteByte(HL,E);
				PC++;
				return(7);
			}

		case 0x36:
			{
				WriteByte(HL,ReadByte(PC+1));

				PC+=2;
				return(10);
			}	


		/* komandi logiki */

		/*  AND	*/
		case 0xe6:
			{
				A=A&ReadByte(PC+1);

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC+=2;
				return(7);
			}	

		case 0xa7:
			{
				A=A&A;

				

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(4);
			}	

		case 0xa4:
			{
				A=A&H;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(4);
			}	

		case 0xa5:
			{
				A=A&L;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(4);
			}	

		case 0xa0:
			{
				A=A&B;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(4);
			}	

		case 0xa1:
			{
				A=A&C;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(4);
			}	

		case 0xa2:
			{
				A=A&D;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(4);
			}	


		case 0xa3:
			{
				A=A&E;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(4);
			}	

		case 0xa6:
			{
				A=A&(ReadByte(HL));

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(7);
			}	

		/* OR */
		case 0xf6:
			{
				A=A|ReadByte(PC+1);

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC+=2;
				return(7);
			}	

		case 0xb7:
			{
				A=A|A;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(4);
			}	

		case 0xb4:
			{
				A=A|H;





				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(4);
			}	

		case 0xb5:
			{
				A=A|L;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(4);
			}	

		case 0xb0:
			{
				A=A|B;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(4);
			}	

		case 0xb1:
			{
				A=A|C;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;

				return(4);
			}	

		case 0xb2:
			{
				A=A|D;

				ParityA;
				ZnakA;

				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(4);
			}	

		case 0xb3:
			{
				A=A|E;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(4);
			}	

		case 0xb6:
			{
				A=A|(ReadByte(HL));

				ParityA;

				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);

				myFflagN_s(0);

				PC++;
				return(7);
			}

		/* XOR */
		case 0xee:

			{
				A=A^ReadByte(PC+1);


				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC+=2;
				return(7);
			}	

		case 0xaf:

			{
				A=A^A;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(4);
			}	

		case 0xac:
			{
				A=A^H;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(4);
			}	

		case 0xad:
			{
				A=A^L;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);

				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(4);
			}	

		case 0xa8:

			{
				A=A^B;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);

				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(4);
			}	

		case 0xa9:
			{
				A=A^C;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(4);
			}	

		case 0xaa:
			{
				A=A^D;

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);
				


				PC++;
				return(4);

			}	

		case 0xab:
			{
				A=A^E;


				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(4);
			}	

		case 0xae:
			{
				A=A^(ReadByte(HL));

				ParityA;
				ZnakA;
				ZeroA;
				myFflagC_s(0);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(7);
			}


		/* komandi perehoda */

		case 0xc3:
			{
				WriteToRamAddrSpAddr((unsigned char *)&PC, PC+1);
				return(10);
			}

		case 0xe9:
			{
				PC=HL;
				return(4);
			}

		case 0xda:
			{
				if (myFflagC_r())
					WriteToRamAddrSpAddr((unsigned char *)&PC, PC+1);
				else
					PC+=3;

				return(10);
			}

		case 0xd2:
			{
				if (!myFflagC_r())
					WriteToRamAddrSpAddr((unsigned char *)&PC, PC+1);
				else
					PC+=3;

				return(10);
			}

		case 0xca:
			{
				if (F&64)
					WriteToRamAddrSpAddr((unsigned char *)&PC, PC+1);
				else
					PC+=3;

				return(10);
			}

		case 0xc2:
			{
				if (!(F&64))
					WriteToRamAddrSpAddr((unsigned char *)&PC, PC+1);
				else
					PC+=3;

				return(10);
			}

		case 0xf2:
			{
				if (!(F&128))
					WriteToRamAddrSpAddr((unsigned char *)&PC, PC+1);
				else
					PC+=3;

				return(10);
			}

		case 0xfa:
			{
				if (F&128)
					WriteToRamAddrSpAddr((unsigned char *)&PC, PC+1);
				else
					PC+=3;

				return(10);
			}

		case 0xea:
			{
				if (F&4)
					WriteToRamAddrSpAddr((unsigned char *)&PC, PC+1);
				else
					PC+=3;

				return(10);

			}

		case 0xe2:
			{
				if (!(F&4))
					WriteToRamAddrSpAddr((unsigned char *)&PC, PC+1);
				else
					PC+=3;

				return(10);
			}

		case 0x18:
			{
				PC+=(signed char)ReadByte(PC+1);
				PC+=2;

				return(12); 
			}

		case 0x38:
			{
				if (myFflagC_r())
				{
					PC+=(signed char)ReadByte(PC+1);
					PC+=2;
					return(12); 
				}
				else
				{
					PC+=2;
					return(7); 
				}
			}

		case 0x30:
			{
				if (!myFflagC_r())


				{
					PC+=(signed char)ReadByte(PC+1);
					PC+=2;
					return(12); 
				}
				else
				{
					PC+=2;
					return(7); 
				}
			}	

		case 0x28:
			{
				if (F&64)
				{
					PC+=(signed char)ReadByte(PC+1);
					PC+=2;
					return(12); 
				}
				else
				{
					PC+=2;
					return(7); 
				}
			}

		case 0x20:
			{
				if (!(F&64))
				{
					PC+=(signed char)ReadByte(PC+1);
					PC+=2;
					return(12); 
				}
				else
				{
					PC+=2;
					return(7); 
				}
			}

		case 0x10: /* djnz */
			{
				B--;
				if (B!=0)
				{
					PC+=(signed char)ReadByte(PC+1);
					PC+=2;
					return(13);
				}
				else
				{
					PC+=2;
					return(8); 
				}
			}

		/* Decrement */

		case 0x0d:
			{
				C--;

				znak(C);
				zero(C);
				myFflagPV_s((C==0x7f));
				myFflagN_s(1);
				myFflagH_s(    ((C&0x0f)==0x0f));

				PC++;
				return(4);
			}	

		case 0x3d:
			{
				A--;

				znak(A);
				zero(A);
				myFflagPV_s((A==0x7f));
				myFflagN_s(1);
				myFflagH_s(    ((A&0x0f)==0x0f));

				PC++;
				return(4);
			}

		case 0x25:
			{
				H--;

				znak(H);
				zero(H);
				myFflagPV_s((H==0x7f));
				myFflagN_s(1);
				myFflagH_s(    ((H&0x0f)==0x0f));

				PC++;
				return(4);
			}

		case 0x2d:
			{
				L--;

				znak(L);
				zero(L);
				myFflagPV_s((L==0x7f));
				myFflagN_s(1);
				myFflagH_s(    ((L&0x0f)==0x0f));

				PC++;
				return(4);
			}

		case 0x05:
			{
				B--;

				znak(B);
				zero(B);
				myFflagPV_s((B==0x7f));
				myFflagN_s(1);
				myFflagH_s(    ((B&0x0f)==0x0f));

				PC++;
				return(4);
			}

		case 0x1d:
			{
				E--;
				

				znak(E);
				zero(E);
				myFflagPV_s((E==0x7f));
				myFflagN_s(1);
				myFflagH_s(    ((E&0x0f)==0x0f));

				PC++;
				return(7);
			}

		case 0x15:
			{
				D--;

				znak(D);
				zero(D);
				myFflagPV_s((D==0x7f));
				myFflagN_s(1);
				myFflagH_s(    ((D&0x0f)==0x0f));

				PC++;
				return(7);

			}

		case 0x35:
			{
				work8=ReadByte(HL);
				work8--;
				WriteByte(HL,work8);

				znak(ReadByte(HL));
				zero(ReadByte(HL));
				myFflagPV_s((ReadByte(HL)==0x7f));
				myFflagN_s(1);
				myFflagH_s(    ((ReadByte(HL)&0x0f)==0x0f));

				PC++;
				return(11);
			}

		case 0x2b:
			{	
				HL--;

				PC++;
				return(6);
			}

		case 0x0b:
			{	
				BC--;

				PC++;
				return(6);

			}

		case 0x1b:
			{	
				DE--;

				PC++;
				return(6);
			}

		case 0x3b:
			{	
				SP--;
				PC++;
				return(6);
			}

		/* komandi sravnenia	*/
			

		case 0xbf:
			{	
				val=A;

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				myFflagS_s(   ((work16 & 0x80) != 0));                                                
				myFflagZ_s(   ((work16 & 0xff) == 0));                                                
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(4);
			}

		case 0xbc:
			{	
				val=H;

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				myFflagS_s(   ((work16 & 0x80) != 0));                                                
				myFflagZ_s(   ((work16 & 0xff) == 0));                                                
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(4);
			}

		case 0xbd:
			{	
				val=L;

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				myFflagS_s(   ((work16 & 0x80) != 0));                                                
				myFflagZ_s(   ((work16 & 0xff) == 0));                                                
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(4);
			}

		case 0xb8:
			{	
				val=B;

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				myFflagS_s(   ((work16 & 0x80) != 0));                                                
				myFflagZ_s(   ((work16 & 0xff) == 0));                                                
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(4);
			}

		case 0xb9:
			{	
				val=C;

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				myFflagS_s(   ((work16 & 0x80) != 0));                                                
				myFflagZ_s(   ((work16 & 0xff) == 0));                                                
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    

				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(4);
			}

		case 0xba:
			{	
				val=D;

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				myFflagS_s(   ((work16 & 0x80) != 0));                                                
				myFflagZ_s(   ((work16 & 0xff) == 0));                                                
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));


				PC++;
				return(4);
			}

		case 0xbb:
			{	
				val=E;

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				myFflagS_s(   ((work16 & 0x80) != 0));                                                
				myFflagZ_s(   ((work16 & 0xff) == 0));                                                
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(4);

			}

		case 0xfe:
			{	
				val=ReadByte(PC+1);

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       

					((work16 & 0x88) >> 3);                                                       
				myFflagS_s(   ((work16 & 0x80) != 0));                                                

				myFflagZ_s(   ((work16 & 0xff) == 0));                                                
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC+=2;
				return(7);
			}

		case 0xbe:
			{	
				val=ReadByte(HL);

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               

					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				myFflagS_s(   ((work16 & 0x80) != 0));                                                
				myFflagZ_s(   ((work16 & 0xff) == 0));                                                
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(7);
			}

		/* vichitanie s uchetom perenosa */

		case 0xde:
			{
				val=ReadByte(PC+1);

				work16 = A - (val) - myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;                                                                              
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC+=2;

				return(7);
			}

		case 0x9f:

			{
				val=A;

				work16 = A - (val) - myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;                                                                              
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(4);
			}

		case 0x9c:
			{

				val=H;

				work16 = A - (val) - myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;                                                                              
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(4);
			}

		case 0x9d:
			{
				val=L;

				work16 = A - (val) - myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;                                                                              
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(4);
			}

		case 0x98:
			{
				val=B;

				work16 = A - (val) - myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;                                                                              
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(4);
			}

		case 0x99:
			{
				val=C;

				work16 = A - (val) - myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;                                                                              
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(4);
			}
			

		case 0x9a:
			{
				val=D;

				work16 = A - (val) - myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;                                                                              
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(4);
			}

		case 0x9b:
			{
				val=E;

				work16 = A - (val) - myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;                                                                              
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(4);
			}

		case 0x9e:
			{
				val=ReadByte(HL);

				work16 = A - (val) - myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;                                                                              
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s(   sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);
				myFflagC_s( ((work16 & 0x0100) != 0));


				PC++;
				return(7);
			}

		/* komandi prostogo slojeniya	*/

		case 0x87:
			{
				val=A;

				work16 = A + (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                              
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s(   overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));



				PC++;
				return(4);
			}

		case 0x84:
			{
				val=H;

				work16 = A + (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                              
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s(   overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0) );

				PC++;
				return(4);
			}

		case 0x85:
			{
				val=L;

				work16 = A + (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                              
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s(   overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0) );

				PC++;
				return(4);
			}

		case 0x80:
			{
				val=B;

				work16 = A + (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                              
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s(   overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0) );
				

				PC++;
				return(4);
			}

		case 0x81:
			{
				val=C;

				work16 = A + (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                              
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s(   overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0) );

				PC++;
				return(4);
			}

		case 0x82:
			{
				val=D;

				work16 = A + (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              

				ZnakA;                                                             
				ZeroA;                                                                              
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s(   overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0) );

				PC++;
				return(4);
			}

		case 0x83:
			{
				val=E;

				work16 = A + (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                              
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s(   overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0) );

				PC++;
				return(4);
			}


		case 0xc6:
			{
				val=ReadByte(PC+1);

				work16 = A + (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                              
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s(   overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0) );

				PC+=2;
				return(7);
			}

		case 0x86:
			{
				val=ReadByte(HL);

				work16 = A + (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                              
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s(   overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(7);
			}

		case 0x29:
			{
				reg=HL;

				work32 = HL + reg;                                                                    
				idx = ((HL & 0x8800) >> 9) |                                                    
					(((reg) & 0x8800) >> 10) |                                            
					((work32 & 0x8800) >> 11);                                            
				HL1_1 = work32 & 0xffff;                                                                   
				myFflagH_s(   hcarry_tbl[idx]);                                                               

				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work32 & 0x10000) != 0));
				HL=HL1_1;


				PC++;
				return(11);
			}

		case 0x09:
			{
				reg=BC;

				work32 = HL + reg;                                                                    
				idx = ((HL & 0x8800) >> 9) |                                                    
					(((reg) & 0x8800) >> 10) |                                            
					((work32 & 0x8800) >> 11);                                            
				HL1_1 = work32 & 0xffff;                                                                   
				myFflagH_s(   hcarry_tbl[idx]);                                                               
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work32 & 0x10000) != 0) );
				HL=HL1_1;

				PC++;
				return(11);
			}

		case 0x19:
			{
				reg=DE;

				work32 = HL + reg;                                                                    
				idx = ((HL & 0x8800) >> 9) |                                                    
					(((reg) & 0x8800) >> 10) |                                            
					((work32 & 0x8800) >> 11);                                            
				HL1_1 = work32 & 0xffff;                                                                   
				myFflagH_s(   hcarry_tbl[idx]);                                                               
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work32 & 0x10000) != 0) );

				HL=HL1_1;

				PC++;
				return(11);
			}

		case 0x39:
			{
				reg=SP;

				work32 = HL + reg;                                                                    
				idx = ((HL & 0x8800) >> 9) |                                                    
					(((reg) & 0x8800) >> 10) |                                            
					((work32 & 0x8800) >> 11);                                            
				HL1_1 = work32 & 0xffff;                                                                   
				myFflagH_s(   hcarry_tbl[idx]);                                                               
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work32 & 0x10000) != 0) );
				HL=HL1_1;

				PC++;
				return(11);
			}



		/* increment */

		case 0x3c :
			{
				reg=A;


				reg++;                                                                                                
				znak(reg);                                                 
				zero(reg);                                                                  
				myFflagH_s(   (((reg) & 0x0f) == 0));                                                 
				myFflagPV_s(   ((reg) == 0x80));                                                               
				myFflagN_s(0);
				A=reg;

				PC++;
				return(4);
			}

		case 0x24 :
			{
				reg=H;

				reg++;                                                                                                
				znak(reg);                                                 
				zero(reg);                                                                  
				myFflagH_s(   (((reg) & 0x0f) == 0));                                                 
				myFflagPV_s(   ((reg) == 0x80));                                                               
				myFflagN_s(0);
				H=reg;

				PC++;
				return(4);
			}

		case 0x2c :
			{
				reg=L;

				reg++;                                                                                                
				znak(reg);                                                 
				zero(reg);                                                                  
				myFflagH_s(   (((reg) & 0x0f) == 0));                                                 
				myFflagPV_s(   ((reg) == 0x80));                                                               

				myFflagN_s(0);
				L=reg;

				PC++;
				return(4);
			}

		case 0x04 :
			{
				reg=B;
				

				reg++;                                                                                                
				znak(reg);                                                 
				zero(reg);                                                                  
				myFflagH_s(   (((reg) & 0x0f) == 0));                                                 
				myFflagPV_s(   ((reg) == 0x80));                                                               
				myFflagN_s(0);
				B=reg;

				PC++;
				return(4);
			}

		case 0x0c :
			{
				reg=C;

				reg++;                                                                                                
				znak(reg);                                                 
				zero(reg);                                                                  
				myFflagH_s(   (((reg) & 0x0f) == 0));                                                 
				myFflagPV_s(   ((reg) == 0x80));                                                               
				myFflagN_s(0);
				C=reg;

				PC++;
				return(4);
			}

		case 0x14 :
			{
				reg=D;

				reg++;                                                                                                
				znak(reg);                                                 
				zero(reg);                                                                  
				myFflagH_s(   (((reg) & 0x0f) == 0));                                                 
				myFflagPV_s(   ((reg) == 0x80));                                                               
				myFflagN_s(0);
				D=reg;

				PC++;
				return(4);
			}

		case 0x1c :
			{
				reg=E;

				reg++;                                                                                                
				znak(reg);                                                 
				zero(reg);                                                                  
				myFflagH_s(   (((reg) & 0x0f) == 0));                                                 
				myFflagPV_s(   ((reg) == 0x80));                                                               
				myFflagN_s(0);
				E=reg;

				PC++;
				return(4);
			}

		case 0x34 :
			{
				reg=ReadByte(HL);

				reg++;                                                                                                
				znak(reg);                                                 
				zero(reg);                                                                  
				myFflagH_s(   (((reg) & 0x0f) == 0));                                                 
				myFflagPV_s(   ((reg) == 0x80));                                                               
				myFflagN_s(0);
				WriteByte(HL,reg);

				PC++;
				return(11);
			}

		case 0x23 :
			{
				HL++;

				PC++;
				return(6);
			}

		case 0x03 :
			{
				BC++;

				PC++;
				return(6);
			}

		case 0x13 :
			{
				DE++;

				PC++;
				return(6);
			}

		case 0x33 :
			{
				SP++;

				PC++;
				return(6);
			}

		/* komandi push */

		case 0xf5 :
			{
				push(AF);
				PC++;
				return(11);
			}

		case 0xc5 :
			{
				push(BC);
				PC++;
				return(11);
			}

		case 0xd5 :
			{
				push(DE);
				PC++;
				return(11);
			}

		case 0xe5 :
			{
				push(HL);
				PC++;
				return(11);
			}

		/*	komandi prostogo vichitania */

		case 0x97 :
			{
				val=A;	

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                             
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s( sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(4);
			}

		case 0x94 :
			{
				val=H;	

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                             
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             

				myFflagPV_s( sub_overflow_tbl[idx >> 4] );                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(4);
			}

		case 0x95 :
			{
				val=L;	


				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                             
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s( sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(4);
			}

		case 0x90 :
			{
				val=B;	

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                             
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s( sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(4);
			}

		case 0x91 :
			{
				val=C;	

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                             
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s( sub_overflow_tbl[idx >> 4]);
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(4);
			}

		case 0x92 :
			{
				val=D;	


				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                             
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s( sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(4);
			}

		case 0x93 :
			{
				val=E;	

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                             
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s( sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(4);
			}

		case 0xd6 :
			{
				val=ReadByte(PC+1);	

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       

					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                             
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s( sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC+=2;
				return(7);
			}

		case 0x96 :
			{
				val=ReadByte(HL);	

				work16 = A - (val);                                                                             
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;                                                             
				ZeroA;                                                                             
				myFflagH_s(   sub_hcarry_tbl[idx & 0x7]);                                             
				myFflagPV_s( sub_overflow_tbl[idx >> 4]);                                    
				myFflagN_s(1);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(7);
			}

		/* komandi pop */

		case 0xf1 :
			{
				pop(&work16);
				A=work16/256;
				F=work16-A*256;
				

				PC++;
				return(10);
			}

		case 0xc1 :
			{
				pop(&work16);
				B=work16/256;
				C=work16-B*256;

				PC++;
				return(10);
			}

		case 0xd1 :
			{
				pop(&work16);
				D=work16/256;
				E=work16-D*256;

				PC++;
				return(10);
			}

		case 0xe1 :
			{
				pop(&work16);
				H=work16/256;
				L=work16-H*256;

				PC++;
				return(10);
			}
/*
/// POP END
*/
		/* komandi obrazheniya k pzu (rst) */

		case 0xc7 :
			{
				push(PC+1);
				PC=0x0000;
				return(11);
			}

		case 0xcf :
			{
				push(PC+1);
				PC=0x0008;
				return(11);
			}

		case 0xd7 :
			{
				push(PC+1);
				PC=0x0010;
				return(11);
			}

		case 0xdf :
			{
				push(PC+1);
				PC=0x0018;
				return(11);
			}

		case 0xe7 :
			{
				push(PC+1);
				PC=0x0020;
				return(11);
			}

		case 0xef :
			{
				push(PC+1);
				PC=0x0028;
				return(11);
			}

		case 0xf7 :
			{
				push(PC+1);
				PC=0x0030;
				return(11);
			}

		case 0xff :
			{
				push(PC+1);
				PC=0x0038;
				return(11);
			}


		/* komandi rotatsii bitov */


		case 0x0f: /* rrca */
			{
				myFflagC_s( A & 1);
				A = (A >> 1) | (128 * myFflagC_r());
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(4);
			}

		case 0x1f: /* rra */
			{
				work8 = myFflagC_r();
				myFflagC_s( A & 0x01);
				A = (A >> 1) | (work8 * 128);
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(4);
			}

		case 0x07 : /* rlca */
			{
				myFflagC_s( ((A & 0x80) != 0));
				A = (A << 1) | myFflagC_r();
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(4);
			}

		case 0x17 : /* rla */
			{ 
				work8 = myFflagC_r();
				myFflagC_s( ((A & 0x80) != 0) );
				A = (A << 1) | work8;
				myFflagH_s(0);
				myFflagN_s(0);

				PC++;
				return(4);
			}

		/* komandi vizova podprogramm */

		case 0xcd :
			{
				push(PC+3);
				WriteToRamAddrSpAddr((unsigned char *)&PC, PC+1);
				return(17);
			}

		case 0xdc :
			{
				if (myFflagC_r())
				{
					push(PC+3);
					WriteToRamAddrSpAddr((unsigned char *)&PC, PC+1);
					return(17);
				}
				PC+=3;
				return(11);
			}

		case 0xd4 :
			{
				if (!myFflagC_r())
				{
					push(PC+3);
					WriteToRamAddrSpAddr((unsigned char *)&PC, PC+1);
					return(17);
				}
				PC+=3;
				return(11);
			}

		case 0xcc :

			{
				if (F&64)
				{
					push(PC+3);
					WriteToRamAddrSpAddr((unsigned char *)&PC, PC+1);
					return(17);
				}
				PC+=3;
				return(11);
			}

		case 0xc4 :
			{
				if (!(F&64))
				{
					push(PC+3);
					WriteToRamAddrSpAddr((unsigned char *)&PC, PC+1);
					return(17);
				}
				PC+=3;
				return(11);
			}

		case 0xfc :
			{
				if (F&128)
				{
					push(PC+3);
					WriteToRamAddrSpAddr((unsigned char *)&PC, PC+1);
					return(17);
				}
				PC+=3;
				return(11);
			}

		case 0xf4 :
			{
				if (!(F&128))
				{
					push(PC+3);
					WriteToRamAddrSpAddr((unsigned char *)&PC, PC+1);
					return(17);
				}
				PC+=3;
				return(11);
			}

		case 0xec :
			{
				if (F&4)
				{
					push(PC+3);
					WriteToRamAddrSpAddr((unsigned char *)&PC, PC+1);
					return(17);
				}
				PC+=3;
				return(11);
			}

		case 0xe4 :
			{
				if (!(F&4))

				{
					push(PC+3);
					WriteToRamAddrSpAddr((unsigned char *)&PC, PC+1);
					return(17);
				}
				PC+=3;
				return(11);
			}

		/* komandi vozvrata iz podprogramm */

		case 0xc9 :
			{
				pop(&PC);
				return(10);
			}

		case 0xd8 :
			{
				if (myFflagC_r())

				{
					pop(&PC);
					return(11);
				}
				PC++;
				return(5);
			}

		case 0xd0 :

			{
				if (!myFflagC_r())
				{
					pop(&PC);
					return(11);
				}
				PC++;
				return(5);
			}

		case 0xc8 :
			{
				if (F&64)
				{
					pop(&PC);
					return(11);
				}
				PC++;
				

				return(5);
			}

		case 0xc0 :
			{
				if (!(F&64))
				{
					pop(&PC);
					return(11);
				}
				PC++;
				return(5);
			}


		case 0xf8 :
			{

				if (F&128)
				{
					pop(&PC);
					return(11);
				}
				PC++;
				return(5);
			}

		case 0xf0 :
			{
				if (!(F&128))
				{
					pop(&PC);
					return(11);
				}
				PC++;
				return(5);
			}

		case 0xe8 :

			{
				if (F&4)
				{
					pop(&PC);
					return(11);
				}
				PC++;
				return(5);
			}

		case 0xe0 :
			{
				if (!(F&4))
				{
					pop(&PC);
					return(11);
				}
				PC++;
				return(5);
			}

		case 0xd3: /* out (n),a */
			{
				OutPort(ReadByte(PC+1),A,A);
				PC+=2;
				return(11);
			}

		case 0xdb: /* in a, (n) */
			{
				A=InPort(ReadByte(PC+1),A);
				PC+=2;
				return(11);
			}

		/* komandi slojeniya s uchetom perenosa */

		case 0x8f:
			{
				val=A;

				work16 = A + (val) + myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s( overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0) );

				PC++;
				return(4);
			}

		case 0x8c:
			{
				val=H;

				work16 = A + (val) + myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s( overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0) );

				PC++;
				return(4);
			}

		case 0x8d:
			{
				val=L;

				work16 = A + (val) + myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s( overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0) );


				PC++;
				return(4);
			}


		case 0x88:

			{
				val=B;

				work16 = A + (val) + myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s( overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(4);
			}

		case 0x89:

			{
				val=C;

				work16 = A + (val) + myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;



				ZeroA;
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s( overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(4);
			}

		case 0x8a:
			{
				val=D;

				work16 = A + (val) + myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               


					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s( overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(4);
			}

		case 0x8b:
			{
				val=E;

				work16 = A + (val) + myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       

				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s( overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(4);
			}

		case 0xce:
			{
				val=ReadByte(PC+1);

				work16 = A + (val) + myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s( overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC+=2;
				return(7);
			}

		case 0x8e:
			{
				val=ReadByte(HL);

				work16 = A + (val) + myFflagC_r();                                                    
				idx = ((A & 0x88) >> 1) |                                                               
					(((val) & 0x88) >> 2) |                                                       
					((work16 & 0x88) >> 3);                                                       
				A = work16 & 0xff;                                                                              
				ZnakA;
				ZeroA;
				myFflagH_s(   hcarry_tbl[idx & 0x7]);                                                 
				myFflagPV_s( overflow_tbl[idx >> 4]);                                                
				myFflagN_s(0);                                                                                    
				myFflagC_s( ((work16 & 0x0100) != 0));

				PC++;
				return(7);
			}


		case 0x00: /* nop */
			{
				PC++;
				return(4);
			}

		case 0x2f: /* cpl */
			{
				A^=0xff;

				myFflagH_s(1);
				myFflagN_s(1);

				PC++;
				return(4);
			}

		case 0x37: /* scf */
			{
				myFflagC_s(1);
				myFflagN_s(0); 
				myFflagH_s(0);

				PC++;
				return(4);
			}

		case 0x3f: /* ccf */
			{
				myFflagH_s(    myFflagC_r()); 
				myFflagN_s(0); 

				if (myFflagC_r())
					myFflagC_s(0);
				else
					myFflagC_s(1);

				PC++;
				return(4);

			}

		case 0xe3: /* ex (sp),hl */
			{
				pop(&XX);
				push(HL);
				HL=XX;

				PC++;
				return(19);
			}

		case 0x76: /* halt */
			{
				halted=on;

				PC++;

				return(4);
			}



		case 0x27: /* daa */
			{
				add = 0, carry = myFflagC_r();

				if( ( F&16 ) || ( (A & 0x0f)>9 ) ) add=6;
				if( carry || (A > 0x9f ) ) add|=0x60;
				if( A > 0x99 ) carry=1;

				if ( F&2 /* Flag N */ ) A-=add;
				else 
				{
					if( (A>0x90) && ( (A & 0x0f)>9) ) add|=0x60;
					A+=add;
				}

				if (carry==1)
					myFflagC_s(1);
				else
					myFflagC_s(0);

				ZeroA;

				ZnakA;
				ParityA;

				PC++;
				return(4);
			}

		/* S prefiksom */

		case 0xDD:
			{
				R++;
				PC++;
				return(DD());
			}

		case 0xFD:
			{
				R++;
				PC++;
				return(FD());
			}

		case 0xED:
			{
				R++;
				PC++;
				return(ED());
			}

		case 0xCB:
			{
				R++;
				PC++;
				return(CB());
			}
	}

	printf("\nZ80 : Unknown instruction %x at address %x.\n",ReadByte(PC),PC);
	ExitWithError(-1,"");

	return(0); /* eto chtob ne kvakalo */
}

# define direct_mic_max_len 9000000
unsigned int direct_mic_pos=0;
unsigned char direct_mic_buf[direct_mic_max_len];

void DirectMicDrop(void)
{
	direct_recT direct;
	unsigned int len;


	len=direct_mic_pos/8;

	direct.TS=79;
	direct.pause=0;

	direct.used=direct_mic_pos-len*8+1;

	len++;

	direct.l3=(len&0xFF0000)/65536;
	direct.l2=(len&0x00FF00)/256;
	direct.l1= len&0x0000FF;

	AddTapeBlock("", 0x15, len, direct_mic_buf, sizeof(direct), &direct, 1);

	direct_mic_pos=0;
}

int v44100_22050=0;
void tapeF (int arg)
{

	tape_rew_counter-=arg;

	if (tape_rew_counter<(-2))
	{
		tape_rew_counter=tape_rew_counter_const;

		if (!direct_mic)
		{
			if (v44100_22050)
			{
				tapeMIC[tapeMIC_pos++]=last_tape_out;

				if (tapeMIC_pos>=tapeMIC_max)
				{
					WorkWithBuffer2(tapeMIC, tapeMIC_pos);
					tapeMIC_pos=0;
					tapeMIC_pos_prev=0;
				}	
			}

			v44100_22050=1-v44100_22050;
		}
		else
		{
			b2bset(direct_mic_buf, direct_mic_pos, (last_tape_out<128)?0:1);
			direct_mic_pos++;
			if (direct_mic_pos>=(direct_mic_max_len*8))
			{
				direct_mic_pos--;
				DirectMicDrop();
			}
		}

		if (direct_recording)
		{
			if (direct_recording_buffer_pos==(DIRECT_RECORDING_BUFFER_SIZE-1))
			{
				read(audio3, direct_recording_buffer, DIRECT_RECORDING_BUFFER_SIZE);
				direct_recording_buffer_pos=0;


				return;
			}

			direct_recording_buffer_pos++;

			return;
		}

		if ((tape_pos>=tape_len)||(tape_paused)) return;

		tape_pos++;
		AYWriteRegNV(BEEPER,b2bget(tape, tape_pos));

		if (tape_pos==tape_len)
		{
			if (!TapeNextNext())
				tapeFill_tape(0);
			else
			{
				tape_SetActiveAndPause(tapes);
				MaxSpeenND_Stop();
			}
		}
	}
}


#if defined FUSE_engine

#include "z80.c"

int z80b_vz80; 
int Z80NTtodo=0;
void z80NT (int todo, int interrupt)
{
	todo+=Z80NTtodo;

	if (interrupt)
	{
		if (Z80NTtodo>0) 
		{
			z80b_vz80=Z80_Execute();
			tapeF(z80b_vz80);
			tcounter+=z80b_vz80;
			tcounter_long+=z80b_vz80;
			todo-=z80b_vz80;
		}
		z80b_vz80=z80_interrupt();
		tapeF(z80b_vz80);
		tcounter+=z80b_vz80;
		tcounter_long+=z80b_vz80;
		todo-=z80b_vz80;
	}	

	while (TRUE)
	{
		if (todo<4) 
		{
			Z80NTtodo=todo;
			break;
		}
		z80b_vz80=Z80_Execute();
		tapeF(z80b_vz80);
		tcounter+=z80b_vz80;
		tcounter_long+=z80b_vz80;
		todo-=z80b_vz80;
	}
}
#endif 
#if !defined FUSE_engine
int z80b_vz80; 
int Z80NTtodo=0;
void z80NT (int todo, int interrupt)
{
	todo+=Z80NTtodo;

	if (interrupt)
	{
		if (Z80NTtodo>0) 
		{
			z80b_vz80=z80a(0);
			tapeF(z80b_vz80);
			tcounter+=z80b_vz80;
			tcounter_long+=z80b_vz80;
			todo-=z80b_vz80;
		}
		z80b_vz80=z80a(1);
		tapeF(z80b_vz80);
		tcounter+=z80b_vz80;
		tcounter_long+=z80b_vz80;
		todo-=z80b_vz80;
	}	

	while (TRUE)
	{
		if (todo<4) 
		{
			Z80NTtodo=todo;
			break;
		}
		z80b_vz80=z80a(0);
		tapeF(z80b_vz80);
		tcounter+=z80b_vz80;
		tcounter_long+=z80b_vz80;
		todo-=z80b_vz80;
	}
}
#endif

void Server_AddPoint(int num, unsigned char point)
{

}


#define GetAddrInZXScreen48ByLine  ((line&192)*32+(line&7)*0x100+(line&56)*4)

# define ScreenNT_Single_source_razm_1 unsigned short
# define ScreenNT_Single_source_razm_2 unsigned int
void ScreenNT_Single16(ScreenNT_Single_source_razm_1 * vs, ScreenNT_Single_source_razm_1 * XColors16, ScreenNT_Single_source_razm_2 * XColors16_2)
{
	unsigned int i, line;
	int counter=-2;


	p_ff_in=255;
	z80NT(NT_T_UP, 1); 

	/*verhnii border do 16384*/
	line=24;
	while (line--)	
	{
		z80NT(NT_T_LP, 0);

		i=160;
		while (i--) 
		{
			z80NT(1,0); 
			*(ScreenNT_Single_source_razm_2*)&vs[counter+=2]=*(ScreenNT_Single_source_razm_2*)&XColors16_2[border];
			if (server) Server_AddPoint(2, border);
		}	

		

		z80NT(NT_T_RP, 0); 
	}	

	/*ekran*/
	for (line=0; line<192; line++)
	{
		z80NT(NT_T_LP, 0);

		i=16;
		while (i--) 
		{
			z80NT(1,0); 
			*(ScreenNT_Single_source_razm_2*)&vs[counter+=2]=*(ScreenNT_Single_source_razm_2*)&XColors16_2[border];
			if (server) Server_AddPoint(2, border);
		}

		rb=GetAddrInZXScreen48ByLine;
		for (ri=0; ri<32; ri++) /*linia ekrana*/
		{
			rc=ri+32*(line/8); /* bait attributov ot nachala attributov_48 */
			p_ff_in=attrib48[rc];

			if (attrib48[rc]&64)
			{
				rt=(attrib48[rc]&7)+8;
				rf=((attrib48[rc]&56)/8)+8;
			}
			else
			{
				rt=attrib48[rc]&7;
				rf=(attrib48[rc]&56)/8;
			}

			if (attrib48[rc]&128)
			{
				if (flashcounter>15)
				{
					rr=rf;
					rf=rt;
					rt=rr;

				}
			}

			z80NT(1,0); 
			counter++;

			if (screen48[rb]&128)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (server) Server_AddPoint(1, rf);
			}

			if (screen48[rb]&64)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (server) Server_AddPoint(1, rf);
			}


			z80NT(1,0); 

			if (screen48[rb]&32)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (server) Server_AddPoint(1, rf);
			}

			if (screen48[rb]&16)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (server) Server_AddPoint(1, rf);
			}


			z80NT(1,0); 

			if (screen48[rb]&8)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (server) Server_AddPoint(1, rf);
			}

			if (screen48[rb]&4)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (server) Server_AddPoint(1, rf);
			}


			z80NT(1,0); 

			if (screen48[rb]&2)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (server) Server_AddPoint(1, rf);
			}

			if (screen48[rb]&1)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (server) Server_AddPoint(1, rf);
			}

			counter--;
			rb++;
		}

		i=16;
		while (i--) 
		{
			z80NT(1,0); 
			*(ScreenNT_Single_source_razm_2*)&vs[counter+=2]=*(ScreenNT_Single_source_razm_2*)&XColors16_2[border];
			if (server) Server_AddPoint(2, border);
		}

		z80NT(NT_T_RP, 0); 
	}	

	/*nijnii border*/
	line=24;
	while (line--)	
	{
		z80NT(NT_T_LP, 0);

		i=160;
		while (i--) 
		{
			z80NT(1,0); 
			*(ScreenNT_Single_source_razm_2*)&vs[counter+=2]=*(ScreenNT_Single_source_razm_2*)&XColors16_2[border];
			if (server) Server_AddPoint(2, border);
		}	

		z80NT(NT_T_RP, 0); 
	}	

	z80NT(NT_T_DP, 0);
}

# define Sizeof sizeof(ScreenNT_Single_source_razm_1)
void ScreenNT_Double16(ScreenNT_Single_source_razm_1 * vs, ScreenNT_Single_source_razm_1 * XColors16)
{
	unsigned int i, line;
	int counter=0, counter1;


	p_ff_in=255;
	z80NT(NT_T_UP, 1); 

	/*verhnii border do 16384*/
	line=24;
	while (line--)	
	{
		counter=(23-line)*640*Sizeof;

		z80NT(NT_T_LP, 0);

		i=160;
		while (i--) 
		{
			z80NT(1,0); 

			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];

			if (!scan)
			{
				counter1=counter+(320*Sizeof-4);

				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			}

			if (server) Server_AddPoint(2, border);
		}	

		z80NT(NT_T_RP, 0); 
	}	


	/*ekran*/
	for (line=0; line<192; line++)
	{
		counter=(line+24)*640*Sizeof;

		z80NT(NT_T_LP, 0);

		i=16;
		while (i--) 
		{
			z80NT(1,0); 

			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];

			if (!scan)
			{
				counter1=counter+(320*Sizeof-4);

				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			}

			if (server) Server_AddPoint(2, border);
		}

		rb=GetAddrInZXScreen48ByLine;
		for (ri=0; ri<32; ri++) /*linia ekrana*/
		{
			rc=ri+32*(line/8); /* bait attributov ot nachala attributov_48 */
			p_ff_in=attrib48[rc];

			if (attrib48[rc]&64)
			{
				rt=(attrib48[rc]&7)+8;
				rf=((attrib48[rc]&56)/8)+8;
			}
			else
			{
				rt=attrib48[rc]&7;
				rf=(attrib48[rc]&56)/8;
			}

			if (attrib48[rc]&128)
			{
				if (flashcounter>15)
				{
					rr=rf;
					rf=rt;
					rt=rr;
				}
			}

			z80NT(1,0); 

			if (screen48[rb]&128)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				}
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				}
				if (server) Server_AddPoint(1, rf);
			}

			if (screen48[rb]&64)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				}
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				}
				if (server) Server_AddPoint(1, rf);
			}


			z80NT(1,0); 

			if (screen48[rb]&32)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				}
				if (server) Server_AddPoint(1, rt);
			}
			else

			{

				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				}
				if (server) Server_AddPoint(1, rf);
			}			

			if (screen48[rb]&16)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				}
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				}
				if (server) Server_AddPoint(1, rf);
			}		


			z80NT(1,0); 

			if (screen48[rb]&8)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				}
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				}
				if (server) Server_AddPoint(1, rf);
			}			

			if (screen48[rb]&4)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				}
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				}
				if (server) Server_AddPoint(1, rf);
			}			


			z80NT(1,0); 

			if (screen48[rb]&2)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				}
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				}
				if (server) Server_AddPoint(1, rf);
			}			

			if (screen48[rb]&1)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				}
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				}
				if (server) Server_AddPoint(1, rf);
			}

			rb++;
		}

		i=16;
		while (i--) 
		{
			z80NT(1,0); 

			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];

			if (!scan)
			{
				counter1=counter+(320*Sizeof-4);

				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			}

			if (server) Server_AddPoint(2, border);
		}

		z80NT(NT_T_RP, 0); 
	}	

	/*nijniy border*/
	line=24;
	while (line--)	
	{
		counter=((23-line)+216)*640*Sizeof;

		z80NT(NT_T_LP, 0);

		i=160;
		while (i--) 
		{
			z80NT(1,0); 

			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];

			if (!scan)
			{
				counter1=counter+(320*Sizeof-4);

				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			}

			if (server) Server_AddPoint(2, border);
		}	

		z80NT(NT_T_RP, 0); 
	}	

	z80NT(NT_T_DP, 0);
}

# undef ScreenNT_Single_source_razm_1
# undef ScreenNT_Single_source_razm_2
# define ScreenNT_Single_source_razm_1 unsigned char
# define ScreenNT_Single_source_razm_2 unsigned short
void ScreenNT_Single8(ScreenNT_Single_source_razm_1 * vs, ScreenNT_Single_source_razm_1 * XColors16, ScreenNT_Single_source_razm_2 * XColors16_2)
{
	unsigned int i, line;
	int counter=-2;


	p_ff_in=255;
	z80NT(NT_T_UP, 1); 

	/*verhnii border do 16384*/
	line=24;
	while (line--)	
	{
		z80NT(NT_T_LP, 0);

		i=160;
		while (i--) 
		{
			z80NT(1,0); 
			*(ScreenNT_Single_source_razm_2*)&vs[counter+=2]=*(ScreenNT_Single_source_razm_2*)&XColors16_2[border];
			if (server) Server_AddPoint(2, border);
		}	

		z80NT(NT_T_RP, 0); 
	}	

	/*ekran*/
	for (line=0; line<192; line++)
	{
		z80NT(NT_T_LP, 0);

		i=16;
		while (i--) 
		{
			z80NT(1,0); 
			*(ScreenNT_Single_source_razm_2*)&vs[counter+=2]=*(ScreenNT_Single_source_razm_2*)&XColors16_2[border];
			if (server) Server_AddPoint(2, border);
		}

		rb=GetAddrInZXScreen48ByLine;
		for (ri=0; ri<32; ri++) /*linia ekrana*/
		{
			rc=ri+32*(line/8); /* bait attributov ot nachala attributov_48 */
			p_ff_in=attrib48[rc];

			if (attrib48[rc]&64)
			{
				rt=(attrib48[rc]&7)+8;
				rf=((attrib48[rc]&56)/8)+8;
			}
			else
			{
				rt=attrib48[rc]&7;
				rf=(attrib48[rc]&56)/8;
			}

			if (attrib48[rc]&128)
			{
				if (flashcounter>15)
				{
					rr=rf;
					rf=rt;
					rt=rr;
				}
			}

			z80NT(1,0); 
			counter++;

			if (screen48[rb]&128)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (server) Server_AddPoint(1, rt);
			}
			else

			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (server) Server_AddPoint(1, rf);
			}

			if (screen48[rb]&64)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (server) Server_AddPoint(1, rf);
			}


			z80NT(1,0); 

			if (screen48[rb]&32)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (server) Server_AddPoint(1, rf);
			}

			if (screen48[rb]&16)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (server) Server_AddPoint(1, rf);
			}


			z80NT(1,0); 

			if (screen48[rb]&8)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (server) Server_AddPoint(1, rf);
			}

			if (screen48[rb]&4)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (server) Server_AddPoint(1, rf);
			}


			z80NT(1,0); 

			if (screen48[rb]&2)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (server) Server_AddPoint(1, rf);
			}

			if (screen48[rb]&1)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (server) Server_AddPoint(1, rf);
			}

			counter--;
			rb++;
		}

		i=16;
		while (i--) 
		{
			z80NT(1,0); 
			*(ScreenNT_Single_source_razm_2*)&vs[counter+=2]=*(ScreenNT_Single_source_razm_2*)&XColors16_2[border];
			if (server) Server_AddPoint(2, border);
		}

		z80NT(NT_T_RP, 0); 
	}	

	/*nijnii border*/
	line=24;
	while (line--)	
	{
		z80NT(NT_T_LP, 0);

		i=160;
		while (i--) 
		{
			z80NT(1,0); 
			*(ScreenNT_Single_source_razm_2*)&vs[counter+=2]=*(ScreenNT_Single_source_razm_2*)&XColors16_2[border];
			if (server) Server_AddPoint(2, border);
		}	

		z80NT(NT_T_RP, 0); 
	}	

	z80NT(NT_T_DP, 0);
}

# undef Sizeof
# define Sizeof 2
void ScreenNT_Double8(ScreenNT_Single_source_razm_1 * vs, ScreenNT_Single_source_razm_1 * XColors16)
{
	unsigned int i, line;
	int counter=0, counter1;


	p_ff_in=255;
	z80NT(NT_T_UP, 1); 

	/*verhnii border do 16384*/
	line=24;
	while (line--)	
	{
		counter=(23-line)*640*Sizeof;

		z80NT(NT_T_LP, 0);

		i=160;
		while (i--) 
		{
			z80NT(1,0); 

			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];

			if (!scan)
			{
				counter1=counter+(320*Sizeof-4);

				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			}

			if (server) Server_AddPoint(2, border);
		}	

		z80NT(NT_T_RP, 0); 
	}	

	/*ekran*/
	for (line=0; line<192; line++)
	{
		counter=(line+24)*640*Sizeof;

		z80NT(NT_T_LP, 0);

		i=16;
		while (i--) 
		{
			z80NT(1,0); 

			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];

			if (!scan)
			{
				counter1=counter+(320*Sizeof-4);

				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			}

			if (server) Server_AddPoint(2, border);
		}

		rb=GetAddrInZXScreen48ByLine;
		for (ri=0; ri<32; ri++) /*linia ekrana*/
		{
			rc=ri+32*(line/8); /* bait attributov ot nachala attributov_48 */
			p_ff_in=attrib48[rc];

			if (attrib48[rc]&64)
			{
				rt=(attrib48[rc]&7)+8;
				rf=((attrib48[rc]&56)/8)+8;
			}
			else
			{
				rt=attrib48[rc]&7;
				rf=(attrib48[rc]&56)/8;
			}

			if (attrib48[rc]&128)
			{
				if (flashcounter>15)
				{
					rr=rf;
					rf=rt;
					rt=rr;
				}
			}

			z80NT(1,0); 

			if (screen48[rb]&128)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				}
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				}
				if (server) Server_AddPoint(1, rf);
			}

			if (screen48[rb]&64)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				}
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				}
				if (server) Server_AddPoint(1, rf);
			}


			z80NT(1,0); 

			if (screen48[rb]&32)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				}
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				}
				if (server) Server_AddPoint(1, rf);
			}			

			if (screen48[rb]&16)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				}
				if (server) Server_AddPoint(1, rt);
			}
			else

			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				}
				if (server) Server_AddPoint(1, rf);
			}		


			z80NT(1,0); 

			if (screen48[rb]&8)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				}
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				}
				if (server) Server_AddPoint(1, rf);
			}			

			if (screen48[rb]&4)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				}
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				}
				if (server) Server_AddPoint(1, rf);
			}			


			z80NT(1,0); 

			if (screen48[rb]&2)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				}
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				}
				if (server) Server_AddPoint(1, rf);
			}			

			if (screen48[rb]&1)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				}
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				}
				if (server) Server_AddPoint(1, rf);
			}

			rb++;
		}

		i=16;
		while (i--) 
		{
			z80NT(1,0); 

			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];

			if (!scan)
			{
				counter1=counter+(320*Sizeof-4);

				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			}

			if (server) Server_AddPoint(2, border);

		}

		z80NT(NT_T_RP, 0); 
	}	

	/*nijniy border*/
	line=24;
	while (line--)	
	{
		counter=((23-line)+216)*640*Sizeof;

		z80NT(NT_T_LP, 0);

		i=160;
		while (i--) 
		{
			z80NT(1,0); 

			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];

			if (!scan)
			{
				counter1=counter+(320*Sizeof-4);

				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			}

			if (server) Server_AddPoint(2, border);
		}	

		z80NT(NT_T_RP, 0); 
	}	

	z80NT(NT_T_DP, 0);
}

# undef ScreenNT_Single_source_razm_1
# undef ScreenNT_Single_source_razm_2
# define ScreenNT_Single_source_razm_1 unsigned int
# define ScreenNT_Single_source_razm_2 unsigned long long
void ScreenNT_Single32(ScreenNT_Single_source_razm_1 * vs, ScreenNT_Single_source_razm_1 * XColors16, ScreenNT_Single_source_razm_2 * XColors16_2)
{
	unsigned int i, line;
	int counter=-2;


	p_ff_in=255;
	z80NT(NT_T_UP, 1); 

	/*verhnii border do 16384*/
	line=24;
	while (line--)	
	{
		z80NT(NT_T_LP, 0);

		i=160;
		while (i--) 
		{
			z80NT(1,0); 
			*(ScreenNT_Single_source_razm_2*)&vs[counter+=2]=*(ScreenNT_Single_source_razm_2*)&XColors16_2[border];
			if (server) Server_AddPoint(2, border);
		}	

		z80NT(NT_T_RP, 0); 
	}	

	/*ekran*/
	for (line=0; line<192; line++)
	{
		z80NT(NT_T_LP, 0);

		i=16;
		while (i--) 
		{
			z80NT(1,0); 
			*(ScreenNT_Single_source_razm_2*)&vs[counter+=2]=*(ScreenNT_Single_source_razm_2*)&XColors16_2[border];
			if (server) Server_AddPoint(2, border);
		}

		rb=GetAddrInZXScreen48ByLine;
		for (ri=0; ri<32; ri++) /*linia ekrana*/
		{
			rc=ri+32*(line/8); /* bait attributov ot nachala attributov_48*/
			p_ff_in=attrib48[rc];

			if (attrib48[rc]&64)
			{
				rt=(attrib48[rc]&7)+8;
				rf=((attrib48[rc]&56)/8)+8;
			}
			else
			{
				rt=attrib48[rc]&7;
				rf=(attrib48[rc]&56)/8;
			}

			if (attrib48[rc]&128)
			{
				if (flashcounter>15)
				{
					rr=rf;
					rf=rt;
					rt=rr;
				}
			}

			z80NT(1,0); 
			counter++;

			if (screen48[rb]&128)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (server) Server_AddPoint(1, rf);
			}

			if (screen48[rb]&64)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (server) Server_AddPoint(1, rf);
			}


			z80NT(1,0); 

			if (screen48[rb]&32)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (server) Server_AddPoint(1, rf);
			}

			if (screen48[rb]&16)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (server) Server_AddPoint(1, rf);
			}


			z80NT(1,0); 

			if (screen48[rb]&8)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (server) Server_AddPoint(1, rf);
			}

			if (screen48[rb]&4)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (server) Server_AddPoint(1, rf);
			}


			z80NT(1,0); 

			if (screen48[rb]&2)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (server) Server_AddPoint(1, rf);
			}

			if (screen48[rb]&1)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[++counter]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (server) Server_AddPoint(1, rf);
			}

			counter--;
			rb++;
		}

		i=16;
		while (i--) 
		{
			z80NT(1,0); 
			*(ScreenNT_Single_source_razm_2*)&vs[counter+=2]=*(ScreenNT_Single_source_razm_2*)&XColors16_2[border];
			if (server) Server_AddPoint(2, border);
		}

		z80NT(NT_T_RP, 0); 
	}	

	/*nijnii border*/
	line=24;
	while (line--)	
	{
		z80NT(NT_T_LP, 0);

		i=160;
		while (i--) 
		{
			z80NT(1,0); 
			*(ScreenNT_Single_source_razm_2*)&vs[counter+=2]=*(ScreenNT_Single_source_razm_2*)&XColors16_2[border];
			if (server) Server_AddPoint(2, border);
		}	

		z80NT(NT_T_RP, 0); 
	}	

	z80NT(NT_T_DP, 0);
}

# undef Sizeof
# define Sizeof 2
void ScreenNT_Double32(ScreenNT_Single_source_razm_1 * vs, ScreenNT_Single_source_razm_1 * XColors16)
{
	unsigned int i, line;
	int counter=0, counter1;


	p_ff_in=255;
	z80NT(NT_T_UP, 1); 

	/*verhnii border do 16384*/
	line=24;
	while (line--)	
	{
		counter=(23-line)*640*Sizeof;

		z80NT(NT_T_LP, 0);

		i=160;
		while (i--) 
		{
			z80NT(1,0); 

			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];

			if (!scan)
			{
				counter1=counter+(320*Sizeof-4);

				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			}

			if (server) Server_AddPoint(2, border);
		}	

		z80NT(NT_T_RP, 0); 
	}	

	/*ekran*/
	for (line=0; line<192; line++)
	{
		counter=(line+24)*640*Sizeof;

		z80NT(NT_T_LP, 0);

		i=16;
		while (i--) 
		{
			z80NT(1,0); 

			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];

			if (!scan)
			{
				counter1=counter+(320*Sizeof-4);

				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			}

			if (server) Server_AddPoint(2, border);
		}

		rb=GetAddrInZXScreen48ByLine;
		for (ri=0; ri<32; ri++) /*linia ekrana*/
		{
			rc=ri+32*(line/8); /* bait attributov ot nachala attributov_48 */
			p_ff_in=attrib48[rc];

			if (attrib48[rc]&64)
			{
				rt=(attrib48[rc]&7)+8;
				rf=((attrib48[rc]&56)/8)+8;
			}
			else
			{
				rt=attrib48[rc]&7;
				rf=(attrib48[rc]&56)/8;
			}

			if (attrib48[rc]&128)
			{
				if (flashcounter>15)
				{
					rr=rf;
					rf=rt;
					rt=rr;
				}
			}

			z80NT(1,0); 

			if (screen48[rb]&128)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				}
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				}
				if (server) Server_AddPoint(1, rf);
			}

			if (screen48[rb]&64)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				}
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				}
				if (server) Server_AddPoint(1, rf);
			}


			z80NT(1,0); 

			if (screen48[rb]&32)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				}
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				}
				if (server) Server_AddPoint(1, rf);
			}			

			if (screen48[rb]&16)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				}
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				}
				if (server) Server_AddPoint(1, rf);
			}		


			z80NT(1,0); 

			if (screen48[rb]&8)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				}
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				}
				if (server) Server_AddPoint(1, rf);
			}			

			if (screen48[rb]&4)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				}
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				}
				if (server) Server_AddPoint(1, rf);
			}			


			z80NT(1,0); 

			if (screen48[rb]&2)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				}
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				}
				if (server) Server_AddPoint(1, rf);
			}			

			if (screen48[rb]&1)
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rt];
				}
				if (server) Server_AddPoint(1, rt);
			}
			else
			{
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				if (!scan)
				{
					counter1=counter+(320*Sizeof-2);
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
					*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[rf];
				}
				if (server) Server_AddPoint(1, rf);
			}

			rb++;
		}

		i=16;
		while (i--) 
		{
			z80NT(1,0); 

			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];

			if (!scan)
			{
				counter1=counter+(320*Sizeof-4);

				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			}

			if (server) Server_AddPoint(2, border);
		}

		z80NT(NT_T_RP, 0); 
	}	

	/*nijniy border*/
	line=24;
	while (line--)	
	{
		counter=((23-line)+216)*640*Sizeof;

		z80NT(NT_T_LP, 0);

		i=160;
		while (i--) 
		{
			z80NT(1,0); 

			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			*(ScreenNT_Single_source_razm_1*)&vs[counter++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];

			if (!scan)
			{
				counter1=counter+(320*Sizeof-4);

				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
				*(ScreenNT_Single_source_razm_1*)&vs[counter1++]=*(ScreenNT_Single_source_razm_1*)&XColors16[border];
			}

			if (server) Server_AddPoint(2, border);
		}	

		z80NT(NT_T_RP, 0); 
	}	

	z80NT(NT_T_DP, 0);
}

void init_timer(void)
{
	ready=1;

	SetIconOnButton(emu_pause,emu_go_pause_b);

	emu_paused=off;

	if (!wpid) wpid=XtAppAddWorkProc(app_context, video, NULL);
}

int UL_colorA, UL_colorB, UL_colorC;
int UL_AVol, UL_BVol, UL_CVol;
int UL_skip=0;
unsigned int UL_AVol_max, UL_BVol_max, UL_CVol_max;

void UpdateLeds(void)
{
# define ledsWidth 3	


	if (!leds_global)
		return;

	avol_max&=15;
	bvol_max&=15;
	cvol_max&=15;

	if (((Atone | channelA_enabled) & (Anoice | noiseA_enabled)) | !GeneratorA_period)
	{
		if (Regs1[AY_AVOL]&0x10)
		{
			UL_AVol=15;
			UL_colorA=0;
		}
		else
		{
			UL_colorA=1;
			UL_AVol=avol_max;
		}
	}
	else
		UL_AVol=0;

	if (((Btone | channelB_enabled) & (Bnoice | noiseB_enabled)) | !GeneratorB_period)
	{
		if (Regs1[AY_BVOL]&0x10)
		{
			UL_BVol=15;
			UL_colorB=0;
		}
		else
		{
			UL_colorB=1;
			UL_BVol=bvol_max;
		}
	}
	else
		UL_BVol=0;

	if (((Ctone | channelC_enabled) & (Cnoice | noiseC_enabled)) | !GeneratorC_period)
	{
		if (Regs1[AY_CVOL]&0x10)
		{
			UL_CVol=15;
			UL_colorC=0;
		}
		else
		{
			UL_colorC=1;
			UL_CVol=cvol_max;
		}
	}		
	else
		UL_CVol=0;

	if (UL_AVol_max<UL_AVol)UL_AVol_max=UL_AVol;
	if (UL_BVol_max<UL_BVol)UL_BVol_max=UL_BVol;
	if (UL_CVol_max<UL_CVol)UL_CVol_max=UL_CVol;

	avol_max=bvol_max=cvol_max=0;

	if (UL_skip)
	{
		UL_skip--;
		return;
	}
	else
	{
		if (!sound)
		{
			XClearWindow(display, ledsWindow);
			return;	
		}

		XClearWindow(display, ledsWindow);

		XSetForeground(display,gcleds,paletteleds[UL_colorA]);
		XFillRectangle(display,ledsWindow,gcleds,0,ledsY,UL_AVol_max,ledsWidth);

		XSetForeground(display,gcleds,paletteleds[UL_colorB]);
		XFillRectangle(display,ledsWindow,gcleds,0,ledsY+3,UL_BVol_max,ledsWidth);

		XSetForeground(display,gcleds,paletteleds[UL_colorC]);
		XFillRectangle(display,ledsWindow,gcleds,0,ledsY+6,UL_CVol_max,ledsWidth);

		if (UL_AVol_max)	UL_AVol_max--;
		if (UL_BVol_max)	UL_BVol_max--;
		if (UL_CVol_max)	UL_CVol_max--;

		if (UL_AVol_max)	UL_AVol_max--;
		if (UL_BVol_max)	UL_BVol_max--;
		if (UL_CVol_max)	UL_CVol_max--;


		UL_skip=2;
	}
}

void Interpolyatsia16(void)
{
	unsigned int i;
	short value;
	short * p;


	i=305916; /* 640*480-641-1-641-1 */
	p=&vs16[305916+642];

	while(i--)
	{
		p--;
		value=vvs16[i+642];

		if (value)
		{
			*p+=value;
			p[-1]+=value;
			p[1]+=value;
			p[-640]=value;
			p[640]+=value;
		}
		else
			p[-640]=0;
	}

	i=1282;
	while(i--)
	{
		vs16[i]=vvs16[i]*5;
		vs16[i+305918]=vvs16[i+305918]*5;
	}	

	/*
	unsigned int i;
	unsigned int pos;
	short value;

	i=305916; //640*480-641-1-641-1
	while(i--)
	{
		pos=i+642;

		value=vvs16[pos];

		if (value)
		{
			vs16[pos]+=value;

			vs16[--pos]+=value;

			pos++; pos++;
			vs16[pos]+=value;

			pos-=641;
			vs16[pos]=value;

			pos+=1280;
			vs16[pos]+=value;
		}
		else
			vs16[pos-640]=0;
	}

	i=1282;
	while(i--)
	{
		vs16[i]=vvs16[i]*5;
		vs16[i+305918]=vvs16[i+305918]*5;
	} 
	*/
}

void Interpolyatsia32(void)
{
	unsigned int i;
	int value;
	int * p;


	i=305916; /* 640*480-641-1-641-1 */
	p=&vs32[305916+642];

	while(i--)
	{
		p--;
		value=vvs32[i+642];

		if (value)
		{
			*p+=value;
			p[-1]+=value;
			p[1]+=value;
			p[-640]=value;
			p[640]+=value;
		}
		else
			p[-640]=0;
	}

	i=1282;
	while(i--)
	{
		vs32[i]=vvs32[i]*5;
		vs32[i+305918]=vvs32[i+305918]*5;
	}	
}

void tape_show_rec_vol(unsigned char arg)
{
	int color=0;


	if (arg<=79)
		color=0;
	else
	if ((arg>=80)&&(arg<=127))
		color=1;
	else
	if ((arg>=128)&&(arg<=199))
		color=2;
	else
	if ((arg>=200)&&(arg<=239))
		color=1;
	else
	if ((arg>=240)&&(arg<=255))
		color=3;

	XClearWindow(display, tape_sc_lev_win);

	XSetForeground(display,gclev,palettelev[color]);
	XFillRectangle(display,tape_sc_lev_win,gclev,0,tape_sc_lev_y/6,tape_sc_lev_x*arg/255,tape_sc_lev_y*2/3);

	XSetForeground(display,gclev,palettelev[4]);
	XDrawRectangle(display,tape_sc_lev_win,gclev,0,tape_sc_lev_y/6,tape_sc_lev_x-1,tape_sc_lev_y*2/3);
}

int tssNclr=1;
void TapeSetString(char * string)
{
	XmString str;


	if (!strlen(string))
	{
		if (tssNclr)
			tssNclr=0;
		else
			return;
	}
	else
		tssNclr=1;

	str = XmStringCreateSimple(string);

	n=0;
	XtSetArg(args[n], XmNlabelString, str); n++;
	XtSetValues(tape_status, args, n);

	XmStringFree(str);
}

int Pischit(char * arg, unsigned int from, unsigned int to)
{
	unsigned int i;


	from++;
	for (i=from; i<to; i++)
	{
		if (arg[i-1]!=arg[i])
			return 1;
	}

	return 0;
}

void timerfunc(void)
{
	if (turbo_speedTL) return;

	if (!direct_mic)
	{
		if (!Pischit(tapeMIC, tapeMIC_pos_prev, tapeMIC_pos))
		{
			if (tapeMIC_pos_prev)
				WorkWithBuffer2(tapeMIC, tapeMIC_pos);

			tapeMIC_pos_prev=0;
			tapeMIC_pos=0;
		}
		else
			tapeMIC_pos_prev=tapeMIC_pos;
	}	

	not_draw--;

	UpdateSoundBuffer();
	UpdateLeds();

	if (not_draw||XLib)
		z80NT(NT_T_INT_LEN, 1);

	if (not_draw==0)
	{
		if (!XLib)
		{
			if (screen_size==1)
			{
				switch (depth)
				{
					case 8:
						ScreenNT_Single8(vs8, colors, XColors8_2);
						break;
					case 15:
						ScreenNT_Single16(vs16, XColors15, XColors15_2);
						break;	
					case 16:
						ScreenNT_Single16(vs16, XColors16, XColors16_2);
						break;	
					case 24:
						ScreenNT_Single32(vs32, XColors32, XColors32_2);
						break;
				}
			}

			if (screen_size==2)
			{
				switch (depth)
				{
					case 8:
						ScreenNT_Double8(vs8, colors);
						break;	
					case 15:
						ScreenNT_Double16(vs16, XColors15);
						break;
					case 16:
						if (interpolyatsia!=0)
						{
							ScreenNT_Double16(vvs16, XColors16i);
							Interpolyatsia16();
						}
						else
							ScreenNT_Double16(vs16, XColors16);
						break;
					case 24:
						if (interpolyatsia)
						{
							ScreenNT_Double32(vvs32, XColors32i);
							Interpolyatsia32();
						}
						else
							ScreenNT_Double32(vs32, XColors32);
						break;
				}
			}

			XClearWindow(display,w);
		}

		not_draw=not_draw_start;
	}

	flashcounter++;

	if (XLib)
		if ((flashcounter==1)||(flashcounter==16)) 
			reDrawFlashed();

	if (flashcounter>32)
	{
		flashcounter=0;

		if (!tape_paused)
		{
			if (showQTape)
			{
				XtManageChild(show_tape);
				if (showQTape==1)	showQTape=0;

				if (showQTape==2)
				{
					if (tape_len)
						sprintf(tstring,"Playing block - %d%c done...", tape_pos*100/tape_len,'%');
					else
						sprintf(tstring,"Playing block - tape_len==0 !!");

					TapeSetString(tstring);	
				}
			}
			else
			{
				XtUnmanageChild(show_tape);
				TapeSetString("");
			}
		}

		if (showFloppik)
		{
			XtManageChild(show_trd);
			showFloppik=0;
		}
		else
			XtUnmanageChild(show_trd);
	}
}	

void clear_timer(void)
{
	ready=0;

	SetIconOnButton(emu_go,emu_go_pause_b);

	emu_paused=on;

	if (wpid) 
	{
		XtRemoveWorkProc(wpid);
		wpid=0;
	}
}

void Zamolchi(void)
{
	PSGcounter=0;
	Regs1[AY_AVOL]=Regs1[AY_BVOL]=Regs1[AY_CVOL]=0;
}

int Load48snap(char * filename)
{
	int fil;
	unsigned char buffer[27];

#if !defined log	
	clear_timer();
#endif

	MapROM1;
	Set48Screen();
	Zamolchi();

	fil=open(filename,O_RDONLY);	

	if (fil==-1)
	{
		sprintf(tstring,"Unable to open %s", filename);
		MessageBoxErr(tstring);
		init_timer();
		return(errors);
	}

#if !defined log	
	printf(".sna 48k\n");
#endif

	read(fil,buffer,27);

	I=buffer[0];
	L1=buffer[ 1];      H1=buffer[ 2];
	E1=buffer[ 3];      D1=buffer[ 4];
	C1=buffer[ 5];      B1=buffer[ 6];
	F1=buffer[ 7];      A1=buffer[ 8];
	L =buffer[ 9];      H =buffer[10];
	E =buffer[11];      D =buffer[12];
	C =buffer[13];      B =buffer[14];
	
	memcpy(&IY,&buffer[15],2);
	memcpy(&IX,&buffer[17],2);
	
#if defined BIGENDIAN
	byteswp (&IX); 
	byteswp (&IY);
#endif	
	
	F =buffer[21];    A  =buffer[22];
	
	memcpy(&SP,&buffer[23],2);
	
#if defined BIGENDIAN
	byteswp (&SP); 
#endif	
	
	border=buffer[26];
	interrupts=(buffer[19]&0x04)>>2;
	IM=buffer[25];

	read(fil,GiveAddrW1(16384),32768);
	read(fil,GiveAddrW1(49152),16384);

	pop(&PC);

	Set48kMode();
	Load48ROMs();

	close(fil);

#if !defined log	
	init_timer();
#endif

	if (XLib)reDrawAllScreen();

	strcpy(Mode,"48");
	Set_z80times_per_line(35);

	return(no_errors);
}

void DecompressPage(unsigned char * s, unsigned short len, unsigned char *d)
{
	int is=0;
	int id=0;
	unsigned char n;
	unsigned char x;

	if (len==65535)

	{
		memcpy(d,s,16384);
		return;
	}

LB:
	if (s[is]!=0xed)
	{
		d[id]=s[is];
		is++;
		id++;
		goto LCE;
	}

	if ((s[is]==0xed)&&(s[is+1]!=0xed))
	{
		d[id]=s[is];
		is++;
		id++;
		goto LCE;
	}

	if ((s[is]==0xed)&&(s[is+1]==0xed))
	{
		n=s[is+2];
		x=s[is+3];
		memset(&d[id],x,n);
		is+=4;
		id+=n;
	}

LCE:
	if(is<len)goto LB;

	if(id!=16384)
	{
		sprintf(tstring,"DecompressPage failed !");
		MessageBoxErr(tstring);
	}
}


void Decompress48k(unsigned char * s, unsigned char *d)
{
	int is=0;
	int id=0;
	unsigned char n;
	unsigned char x;

LB:
	if ((s[is]==0x00) && (s[is+1]==0xed) && (s[is+2]==0xed) && (s[is+3]==0x00))
		goto LQ;

	if (s[is]!=0xed)
	{
		d[id]=s[is];
		is++;
		id++;
		goto LCE;
	}

	if ((s[is]==0xed)&&(s[is+1]!=0xed))
	{
		d[id]=s[is];
		is++;
		id++;
		goto LCE;
	}

	if ((s[is]==0xed)&&(s[is+1]==0xed))
	{
		n=s[is+2];
		x=s[is+3];
		memset(&d[id],x,n);
		is+=4;
		id+=n;
	}

LCE:
	goto LB;

LQ:
	if(id!=49152)
	{
		sprintf(tstring,"DecompressPage failed !");
		MessageBoxErr(tstring);
	}
}

void byteswp(unsigned char * arg)
{
	unsigned char tmp;


	tmp=arg[0];
	arg[0]=arg[1];
	arg[1]=tmp; 
}

int Loadz80(char * filename)
{
	int fil;
	unsigned char buffer[200000];
	int len;

	int start=0;
	unsigned short b_len;
	unsigned char n;
	unsigned char v=0;

	unsigned char page[16384];
	unsigned char _48k[49152];
	int j;

#if !defined log
	clear_timer();
#endif

	fil=open(filename,O_RDONLY);

	if (fil==-1)
	{
		sprintf(tstring,"Unable to open %s", filename);
		MessageBoxErr(tstring);

		init_timer();

		return(errors);
	}

	len=read(fil,buffer,sizeof(buffer));

	A=buffer[0];
	F=buffer[1];
	C=buffer[2];
	B=buffer[3];
	L=buffer[4];
	H=buffer[5];

	*(short*)&PC=*(short*)&buffer[6];
	*(short*)&SP=*(short*)&buffer[8];

#if defined BIGENDIAN
	byteswp((unsigned char *)&PC);
	byteswp((unsigned char *)&SP);	
#endif

	I=buffer[10];
	if (buffer[12]==255)buffer[12]=1;
	border=(buffer[12]&0xe)>>1;
	E=buffer[13];
	D=buffer[14];
	C1=buffer[15];
	B1=buffer[16];
	E1=buffer[17];
	D1=buffer[18];
	L1=buffer[19];
	H1=buffer[20];
	A1=buffer[21];
	F1=buffer[22];

	*(short*)&IX=*(short*)&buffer[25];
	*(short*)&IY=*(short*)&buffer[23];

#if defined BIGENDIAN
	byteswp((unsigned char *)&IX);
	byteswp((unsigned char *)&IY);
#endif

	if (buffer[27]==0)interrupts=off; else interrupts=on;
	IM=buffer[29]&3;

	if (PC!=0)
	{
#if !defined log
		printf(".z80 v1\n");
#endif

		MapROM1;
		Set48Screen();
		Set48kMode();
		Load48ROMs();
		Zamolchi();


		if ((buffer[12]&32)!=0)
			Decompress48k(&buffer[30],_48k);
		else

			memcpy(_48k,&buffer[30],49152);

		memcpy(&CPU12[16384],_48k,32768);
		memcpy(GiveAddrW1(49152),&_48k[32768],16384);

		goto LE;
	}
	else
	{
		if (buffer[30]==23)
		{
			v=2;
			goto LPCL;
		}

		if (buffer[30]==54)
		{
			v=3;
			goto LPCL;
		}

		if (buffer[30]==55)
		{
			v=4;
			goto LPCL;
		}


		sprintf(tstring,"Loadz80 : Unknown file format : buffer[30] value unknown.");
		MessageBoxErr(tstring);
		goto LE;


	LPCL:

		*(short*)&PC=*(short*)&buffer[32];

#if defined BIGENDIAN
		byteswp((unsigned char *)&PC);
#endif

		register_latch=buffer[38];
		for (j=0; j<15; j++)
			AYWriteRegNV(0,buffer[39+j]);


		if (v==2)
		{
			if (buffer[34]==2)buffer[34]=3;	
			if (buffer[34]>=3)buffer[34]=4;
		}

		switch (buffer[34])
		{
			case 0:
			case 1:
			case 2:
				{
					if (v==2)
					{
#if !defined log
						printf(".z80 v2 48k\n");
#endif
						start=55;
					}

					if (v==3)
					{
#if !defined log
						printf(".z80 v3 48k\n");
#endif
						start=86;
					}

					if (v==4)
					{
#if !defined log
						printf(".z80 v3.X 48k\n");
#endif
						start=87;
					}

					MapROM1;
					Set48Screen();
					Set48kMode();
					Load48ROMs();
					Zamolchi();


				LD48:
					*(short*)&b_len=*(short*)&buffer[start];

#if defined BIGENDIAN
					byteswp((unsigned char *) &b_len);
#endif					

					n=buffer[start+2];
					DecompressPage(&buffer[start+3], b_len, page);

					switch(n)
					{
						case 4 : memcpy(GiveAddrW1(32768),page,16384); break;
						case 5 : memcpy(GiveAddrW1(49152),page,16384);  break;

						case 8 : memcpy(GiveAddrW1(16384),page,16384); break;

						default:
							{
								sprintf(tstring,"Loadz80 : Unknown file format : page number %d unknown",n);
								MessageBoxErr(tstring);
							}
					}

					if (b_len==65535) b_len=16384;
					if((start+b_len+3)<len)
					{
						start+=(b_len+3);
						goto LD48;
					}

					break;
				}

			case 4:
			case 5:
			case 6:
				{
					Set128kMode();	
					Load128ROMs();

					Port7ffdOut(buffer[35]);
					PortbffdOut(buffer[38]);
					memcpy(Regs,&buffer[39],16);

					Zamolchi();


					if (v==2)
					{
#if !defined log
						printf(".z80 v2 128k\n");
#endif
						start=55;
					}

					if (v==3)
					{
#if !defined log
						printf(".z80 v3 128k\n");
#endif
						start=86;
					}

					if (v==4)
					{
#if !defined log
						printf(".z80 v3.X 128k\n");
#endif
						start=87;
					}

				LD:
					*(short*)&b_len=*(short*)&buffer[start];

#if defined BIGENDIAN
					byteswp((unsigned char *) &b_len);
#endif					

					n=buffer[start+2];
					DecompressPage(&buffer[start+3],b_len,page);

					switch(n)
					{
						case 3 : memcpy(RAM0,page,16384); break;
						case 4 : memcpy(RAM1,page,16384); break;
						case 5 : memcpy(RAM2,page,16384); break;
						case 6 : memcpy(RAM3,page,16384); break;
						case 7 : memcpy(RAM4,page,16384); break;
						case 8 : memcpy(RAM5,page,16384); break;
						case 9 : memcpy(RAM6,page,16384); break;
						case 10: memcpy(RAM7,page,16384); break;

						default:
							{
								sprintf(tstring,"Loadz80 : Unknown file format : page number %d unknown",n);
								MessageBoxErr(tstring);
							}	
					}

					if (b_len==65535) b_len=16384;
					if((start+b_len+3)<len)
					{
						start+=(b_len+3);

						goto LD;
					}

					break;
				}

			case 3 :
				{
					sprintf(tstring,"SamRam not supported.");
					MessageBoxErr(tstring);
					goto LE;
				}

			default :
				{
					sprintf(tstring,"Loadz80 : Unknown file format : unknown machine type %d",buffer[34]);
					MessageBoxErr(tstring);
					goto LE;
				}
		}

		goto LE;	
	}

LE:

	close(fil);
	if (XLib)reDrawAllScreen();

#if !defined log
	init_timer();
#endif

	if (mode==m_128k)
		strcpy(Mode,"128");
	else
		strcpy(Mode,"48");
	Set_z80times_per_line(35);

	return(no_errors);
}

int InitScreen(Display * dpy, Window win)
{
	int err;

	display=dpy;
	w=win;


	err=TryInitSscreen();

	if(err)
	{
		printf("\nX initialisation error: %s\n",ERR_XI_STR[err]);
		return (errors);
	}

	vs16=(short *)videomemory;
	vs8=(unsigned char *)videomemory;
	vs32=(int *)videomemory;

	return(no_errors);
}


Widget last_popup=NULL;
XtIntervalId TTtimer=0;
XtIntervalId TTPOtimer=0;

void TTPOProc(XtPointer unused, XtIntervalId * unusedtoo)
{
	if (last_popup)
		XtPopup ((Widget)last_popup, XtGrabNone);
	TTPOtimer=0;
}

void TTCreate(char * tip, Widget w, int x, int y, int force)
{
# define TTPO_INTERVAL 1000

	Widget help_popup;


	help_popup = XtVaCreatePopupShell ("shell", 
			overrideShellWidgetClass, main_window, 
			XmNx, x, XmNy, y, NULL);

	XtVaCreateManagedWidget (tip, 
		xmLabelWidgetClass, help_popup, 
		XtVaTypedArg, XmNforeground, XtRString, "black", strlen("black")+1,      
		XtVaTypedArg, XmNbackground, XtRString, "LightGoldenrod", strlen("LightGoldenrod")+1, 
		NULL);

	last_popup=help_popup;

	if (force)
		XtPopup ((Widget)last_popup, XtGrabNone);
	else
	{
		if (TTPOtimer) return;
		TTPOtimer=XtAppAddTimeOut(app_context, TTPO_INTERVAL, TTPOProc, NULL);
	}
}

void TTProc(XtPointer unused, XtIntervalId * unusedtoo)
{
	if (last_popup)
	{
		XtDestroyWidget (last_popup);
		last_popup=NULL;
		TTtimer=0;
	}
}

void ToolbarEventCB (Widget w, XtPointer client_data,
	XEvent *event, Boolean *continue_to_dispatch)
{
# define TT_INTERVAL 5000

	int x, y;
	int unused;
	Window unused1;


	XQueryPointer(display, XtWindow(w),
		&unused1, &unused1, 
		&x, &y,
		&unused, &unused, &unused);

	x+=15; y+=25;

	if (event->type == MotionNotify)
	{
		if (last_popup)
		{
			n=0;
			XtSetArg(args[n], XmNx, x); n++;
			XtSetArg(args[n], XmNy, y); n++;
			XtSetValues(last_popup, args, n);
		}
		else
			TTCreate((char *)client_data, w, x, y, 1);

		if (TTtimer) XtRemoveTimeOut(TTtimer);
		TTtimer=XtAppAddTimeOut(app_context, TT_INTERVAL, TTProc, NULL);
	}

	if (event->type == EnterNotify)
	{
		if (last_popup)
		{
			XtDestroyWidget (last_popup);
			last_popup=NULL;
			if (TTtimer) XtRemoveTimeOut(TTtimer);
			TTtimer=0;
		}

		TTCreate((char *)client_data, w, x, y, 0);

		if (TTtimer) XtRemoveTimeOut(TTtimer);
		TTtimer=XtAppAddTimeOut(app_context, TT_INTERVAL, TTProc, NULL);
	}

	else if (event->type == LeaveNotify)
	{
		if (last_popup)
		{
			XtDestroyWidget (last_popup);
			last_popup=NULL;
			if (TTtimer) XtRemoveTimeOut(TTtimer);
			TTtimer=0;
			if (TTPOtimer) XtRemoveTimeOut(TTPOtimer);
			TTPOtimer=0;
		}
	}
}

void AddTip(Widget w, char * tip)
{
	if (!strcmp(tip,"")) return;

	XtAddEventHandler (w, EnterWindowMask | LeaveWindowMask | PointerMotionMask, 
		False, ToolbarEventCB, (XtPointer)tip);
}

Widget AddButton(Widget rowcol, char * filename, handler func, char * tip, int width, int h, Widget * w, int offset, Widget att, int ST)
{
	Widget dbutton1;

	XpmReadFileToPixmap(display, 
		DefaultRootWindow(display),
		filename,
		&px_up,&aaa,NULL);

	if (!w)
	{
		dbutton1=XtVaCreateManagedWidget("Button", 
				xmDrawnButtonWidgetClass, rowcol,
				XmNleftAttachment, att ? XmATTACH_WIDGET : XmATTACH_FORM ,
				XmNleftWidget, att ? att : NULL ,
				XmNleftOffset, offset,
				XmNtopAttachment, XmATTACH_FORM,
				XmNwidth, width,
				XmNheight, h,
				XmNlabelType, XmPIXMAP,
				XmNpushButtonEnabled, True,
				XmNshadowThickness, ST,
				XmNhighlightThickness,0,
				NULL);

		n=0;
		XtSetArg(args[n], XmNbackgroundPixmap, px_up); n++;
		XtSetValues(dbutton1, args, n); 

		if (func)
			XtAddCallback(dbutton1, XmNactivateCallback, (XtCallbackProc) func, NULL);

		AddTip(dbutton1, tip);

		return(dbutton1);
	}
	else
	{
		*w=XtVaCreateManagedWidget("Button", 
				xmDrawnButtonWidgetClass, rowcol,
				XmNleftAttachment, att ? XmATTACH_WIDGET : XmATTACH_FORM ,
				XmNleftWidget, att ? att : NULL ,
				XmNleftOffset, offset,
				XmNtopAttachment, XmATTACH_FORM,
				XmNwidth, width,
				XmNheight, h,
				XmNlabelType, XmPIXMAP,
				XmNpushButtonEnabled, True,
				XmNshadowThickness, ST,
				XmNhighlightThickness,0,
				NULL);

		n=0;
		XtSetArg(args[n], XmNbackgroundPixmap, px_up); n++;
		XtSetValues(*w, args, n); 

		if (func)
			XtAddCallback(*w, XmNactivateCallback, (XtCallbackProc) func, NULL);

		AddTip(*w, tip);

		return(NULL);
	}
}

Widget AddButtonT(Widget rowcol, char * filename, handler func, char * tip, int width, int h, int offset, Widget att)
{
	Widget dbutton1;

	XpmReadFileToPixmap(display, 
		DefaultRootWindow(display),
		filename,
		&px_up,&aaa,NULL);

	dbutton1=XtVaCreateManagedWidget("Button", 
			xmToggleButtonWidgetClass, rowcol,

			XmNleftAttachment, att ? XmATTACH_WIDGET : XmATTACH_FORM ,
			XmNleftWidget, att ? att : NULL ,
			XmNleftOffset, offset,
			XmNtopAttachment, XmATTACH_FORM,
			XmNwidth, width,
			XmNheight, h,
			XmNlabelType, XmPIXMAP,

			XmNrecomputeSize, False, 
			XmNhighlightThickness,0, 
			XmNindicatorOn, False,
			XmNshadowThickness, 1, 
			XmNfillOnSelect, True,
			XmNbackgroundPixmap, px_up,

			NULL);

	XtAddCallback(dbutton1, XmNvalueChangedCallback, (XtCallbackProc) func, NULL);

	AddTip(dbutton1, tip);

	return(dbutton1);
}

void demiss_setZ80spd_dialog(scale_w, rgb, cbs)
	Widget scale_w;
	int rgb;
	XmScaleCallbackStruct *cbs;
{
	XtUnmanageChild(form);
	XtUnmanageChild(pane);

	XmProcessTraversal(drawing_a, XmTRAVERSE_CURRENT);
}

void setZ80spd_ps(scale_w, rgb, cbs)
	Widget scale_w;
	int rgb;
	XmScaleCallbackStruct *cbs;
{
	n=0;
	XtSetArg(args[n], XmNvalue,cbs->value*35/100/10); n++;
	XtSetValues(scale, args, n); 	

	Set_z80times_per_line(cbs->value*35/100/10);
}


void setZ80spd(scale_w, rgb, cbs)
	Widget scale_w;
	int rgb;
	XmScaleCallbackStruct *cbs;
{
	n=0;
	XtSetArg(args[n], XmNvalue,cbs->value*100*10/35); n++;
	XtSetValues(scale1, args, n); 	

	Set_z80times_per_line(cbs->value);
}

void set_emulator_spd(scale_w, rgb, cbs)
	Widget scale_w;
	int rgb;
	XmScaleCallbackStruct *cbs;
{
	emulator_speed=cbs->value;
	timeout=TIMER_CONST*100/cbs->value;
	SetSOUND_TICKS_PER_FRAME();
}

void setZ80spd_100(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	int spd;


	spd=(int)client_data;

	n=0;
	XtSetArg(args[n], XmNvalue,spd); n++;
	if (scale)
		XtSetValues(scale, args, n); 	

	n=0;
	XtSetArg(args[n], XmNvalue,spd*1000/35); n++;
	if (scale1)
		XtSetValues(scale1, args, n); 

	Set_z80times_per_line(spd);
}

void TrashXWindow(void)
{
	if (!XLib)
	{
		XShmDetach(display,shmseginfo);
		XFreePixmap(display,pixmap);
		if(shmseginfo->shmaddr)
			shmdt(shmseginfo->shmaddr);
		if(shmseginfo->shmid>=0)
			shmctl(shmseginfo->shmid,IPC_RMID,NULL);
		free(shmseginfo);
	}
}

void SetStatusBar(void)
{
	Colormap colormap;
	int colorcells;
	XColor color;
	XGCValues gcv;
	int i,j;


	leds=XtVaCreateManagedWidget("", 
			xmDrawingAreaWidgetClass, main_window, 
			XmNtopWidget, drawing_a,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNrightAttachment, XmATTACH_FORM,
			XmNwidth, 15+3, XmNheight, 9,
			XmNbottomAttachment, XmATTACH_FORM,
			NULL);

	XtAddCallback(leds,  XmNexposeCallback, (XtCallbackProc) drawing_events_leds, NULL);

	n = 0;
	XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
	XtSetArg(args[n], XmNspacing,2);n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNrightWidget, leds); n++;
	XtSetArg(args[n], XmNtopWidget, drawing_a); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;

	XtSetArg(args[n], XmNheight, 8); n++;	
	XtSetArg(args[n], XmNmarginHeight, 4); n++;
	XtSetArg(args[n], XmNrecomputeSize,0); n++;

	status_bar = XmCreateRowColumn(main_window, "status_bar", args, n);
	XtManageChild(status_bar);


	gcv.foreground = BlackPixelOfScreen(XtScreen(leds));
	gcv.background = WhitePixelOfScreen(XtScreen(leds));
	gcleds = XCreateGC(display, RootWindowOfScreen(XtScreen(leds)),
			GCForeground|GCBackground, &gcv);

	colormap=DefaultColormapOfScreen(XtScreen(leds));
	colorcells=0;
	while(Paletteleds && Paletteleds[3*colorcells++]!=-1);

	paletteleds=(unsigned long*)malloc((colorcells+1)*sizeof(unsigned long));

	for(i=j=0;i<colorcells;i++)
	{
		color.flags=DoRed|DoGreen|DoBlue;
		color.red=Paletteleds[i*3]<<8;
		color.green=Paletteleds[i*3+1]<<8;
		color.blue=Paletteleds[i*3+2]<<8;

		if(XAllocColor(display,colormap,&color))
			paletteleds[j++]=color.pixel;
	}

	XParseColor(display, colormap, "LightGrey", &color);
	color.flags=DoRed|DoGreen|DoBlue;
	if(XAllocColor(display,colormap,&color))
		paletteleds[j++]=color.pixel;

	XSetWindowColormap(display,RootWindowOfScreen(XtScreen(leds)),colormap);

	AddButton(status_bar, ICONPATH"/128.xpm", NULL, "", 14,8, &show_mode,0,NULL,0);
	AddButton(status_bar, ICONPATH"/mini-disk.xpm", NULL, "", 14,8, &show_trd,0,show_mode,0);
	AddButton(status_bar, ICONPATH"/tape-mini.xpm", NULL, "", 14,8, &show_tape,0,show_trd,0);	
	AddButton(status_bar, ICONPATH"/dump_s_mini.xpm", NULL, "", 14,8, &show_dump_s,0,show_tape,0);

	XtUnmanageChild(show_dump_s);
	XtUnmanageChild(show_trd);
	XtUnmanageChild(show_tape);

	tape_status=XtVaCreateManagedWidget("add_label", xmLabelWidgetClass, status_bar,
			XmNlabelString, XmStringCreate ("",XmFONTLIST_DEFAULT_TAG),
			XmNfontList, fontlist2, 
			XmNmarginHeight, 0,
			XmNwidth,120,
			XmNrecomputeSize,0,
			NULL);

	if (mode==m_128k) Set128kMode();
	else 		   		Set48kMode();

	if (sound_fil!=-1)
		XtManageChild(show_dump_s);

	if (tape_paused) 
	{
		XtManageChild(show_tape);
		TapeSetString("TAPE PAUSED");
	}
}

void toggled_sz(widget, which, state)
	Widget widget;
	int which;
	XmToggleButtonCallbackStruct *state;
{
	int nw=320; int nh=240;

	static int first_time=0;
	static Dimension border_width, border_height;

	Dimension d1, d2;


	if (state) 
	{
		if (!state->set) return;
	}

	if (widget)
	{
		if (screen_size==which) return;
	}

	screen_size=which;

	clear_timer();

	if (drawing_a)
	{
		TrashXWindow();

		XtUnmanageChild(drawing_a);
		XtUnmanageChild(status_bar);
		XtUnmanageChild(leds);
	}

	n = 0;
	if (screen_size==1)
	{
		XtSetArg(args[n], XmNwidth, 320); n++;
		XtSetArg(args[n], XmNheight, 240); n++;

		nw=320;
		nh=240;
	}

	if (screen_size==2)
	{
		XtSetArg(args[n], XmNwidth, 640); n++;
		XtSetArg(args[n], XmNheight, 480); n++;

		nw=640;
		nh=480;
	}

	XtSetArg(args[n], XmNtopWidget,  ToolBar); n++;
	XtSetArg(args[n], XmNtopAttachment,  XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopOffset, 3); n++;	

	drawing_a = XmCreateDrawingArea(main_window, "screen", args, n);
	XtManageChild(drawing_a);

	XtAddCallback(drawing_a, XmNinputCallback, (XtCallbackProc) key_pressed, NULL);
	XtAddCallback(drawing_a,  XmNexposeCallback, (XtCallbackProc) drawing_events, NULL);

	XtAddEventHandler(drawing_a, EnterWindowMask, 0, (XtEventHandler)gotfocus, NULL);
	XtAddEventHandler(drawing_a, LeaveWindowMask, 0, (XtEventHandler)lostfocus, NULL);

	if (!first_time)
	{
		first_time=1;
		XtVaGetValues(ToolBar, XmNwidth, &d1, NULL);
		XtVaGetValues(Dialog, XmNwidth, &d2, NULL);

		border_width=d2-d1;

		XtVaGetValues(ToolBar, XmNheight, &d1, NULL);
		XtVaGetValues(Dialog, XmNheight, &d2, NULL);

		border_height=d2-d1;
	}

	SetStatusBar();

	XtVaGetValues(ToolBar, XmNheight, &d1, NULL);
	XtVaGetValues(status_bar, XmNheight, &d2, NULL);

	n=0;
	XtSetArg(args[n], XmNwidth, nw+border_width); n++;
	XtSetArg(args[n], XmNheight, nh+d1+16+border_height); n++;

	XtSetArg(args[n], XmNminHeight, 0); n++;
	XtSetArg(args[n], XmNmaxHeight, 800); n++; 
	XtSetArg(args[n], XmNminWidth, 0); n++;
	XtSetArg(args[n], XmNmaxWidth, 800); n++; 

	XtSetValues(Dialog, args, n); 

	FixHeight(Dialog);
	FixWidth(Dialog);

	screen_created=0;
}

void toggled(widget, which, state)
	Widget widget;
	int which;
	XmToggleButtonCallbackStruct *state;
{
	int nadoInitDelat=0;	


	if (!state->set)
		return;

	if ( ((XLib==on)&&(which>=1)&&(which<=4)) || ((XLib==off)&&(which==5)) )
	{
		clear_timer();
		TrashXWindow();
		nadoInitDelat=1;
	}

	if (which==5)
		XLib=on;
	else
		XLib=off;

	if (which==1)
		refresh_fr=50;
	if (which==2)
		refresh_fr=25;
	if (which==3)
		refresh_fr=16;
	if (which==4)
		refresh_fr=8;

	if (nadoInitDelat)
	{
		XtUnmanageChild(drawing_a);
		XtUnmanageChild(status_bar);
		XtUnmanageChild(leds);

		n=0;

		if (screen_size==1)
		{
			XtSetArg(args[n], XmNwidth, 320); n++;
			XtSetArg(args[n], XmNheight, 240); n++;
		}

		if (screen_size==2)
		{
			XtSetArg(args[n], XmNwidth, 640); n++;
			XtSetArg(args[n], XmNheight, 480); n++;
		}

		XtSetArg(args[n], XmNtopWidget,  ToolBar); n++;
		XtSetArg(args[n], XmNtopAttachment,  XmATTACH_WIDGET); n++;

		drawing_a = XmCreateDrawingArea(main_window, "screen", args, n);
		XtManageChild(drawing_a);

		XtAddCallback(drawing_a, XmNinputCallback, (XtCallbackProc) key_pressed, NULL);
		XtAddCallback(drawing_a,  XmNexposeCallback, (XtCallbackProc) drawing_events, NULL);

		XtAddEventHandler(drawing_a, EnterWindowMask, 0, (XtEventHandler)gotfocus, NULL);
		XtAddEventHandler(drawing_a, LeaveWindowMask, 0, (XtEventHandler)lostfocus, NULL);

		SetStatusBar();

		screen_created=0;	
	}

	if (!XLib)
	{
		not_draw_start=50/refresh_fr;
		not_draw=not_draw_start;	
	}
}


char up_bits[200]={0};
char nuli200sht[200]={0};
XColor nu_a_eto_color;

#if defined XF86VMODE
XF86VidModeModeInfo foundmode;

void FSProc1(XtPointer unused, XtIntervalId * unusedtoo)
{
	Position x,y;


	XF86VidModeSwitchToMode(display, DefaultScreen(display),
		&foundmode);

	XtTranslateCoords(drawing_a, 0, 0, &x, &y);

	XRaiseWindow(display,XtWindow(XtParent(main_window)));

	XSetInputFocus(display, XtWindow(XtParent(main_window)), 
		RevertToNone, CurrentTime);

	XmProcessTraversal(drawing_a, XmTRAVERSE_CURRENT);

	XGrabPointer(display, XtWindow(drawing_a), 
		True, 0, GrabModeAsync,
		GrabModeAsync, XtWindow(drawing_a), None, CurrentTime);

	XWarpPointer(display, None, RootWindow(display,DefaultScreen(display)), 0, 0, 0, 0, 0, 0);

	XF86VidModeSetViewPort(display, DefaultScreen(display), x, y);

	XWarpPointer(display, None, RootWindow(display,DefaultScreen(display)), 0, 0, 0, 0, 1, 1);

	XParseColor(display,  
		DefaultColormap(display,  DefaultScreen(display)), 
		"white", &nu_a_eto_color );

	XDefineCursor(display, XtWindow(drawing_a),
		XCreatePixmapCursor(display, 
			XCreatePixmapFromBitmapData(display, XtWindow(main_window),
				up_bits, 2, 2, 1, 0, 1),
			XCreatePixmapFromBitmapData(display, XtWindow(main_window),
				nuli200sht, 2, 2, 1, 0, 1),
			&nu_a_eto_color, &nu_a_eto_color, 0, 0));

	NajatKnopku(FullScreenB, True);
}

void FSProc(XtPointer unused, XtIntervalId * unusedtoo)
{
	Position x,y;


	XtTranslateCoords(drawing_a, 0, 0, &x, &y);
	XMoveWindow(display, XtWindow(Dialog), -x, -y);
	XtAppAddTimeOut(app_context, 250, FSProc1, NULL);
}

void FullScreen(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	int modecount_return;
	XF86VidModeModeInfo ** modesinfo;
	int i;
	int found=0;
	int new_size;
	Position x,y;
	Dimension rc_height;
	int dotclock_return;


	NajatKnopku(FullScreenB, False);

	XF86VidModeGetAllModeLines(display,DefaultScreen(display),
		&modecount_return, &modesinfo);

	new_size=screen_size;

	if ((!scan)&&(!interpolyatsia))
	{
		for (i=0; i<modecount_return; i++)
		{ 
			if ((modesinfo[i]->hdisplay==320)&&(modesinfo[i]->vdisplay==240))
			{
				found=1;
				memcpy(&foundmode,modesinfo[i],sizeof(XF86VidModeModeInfo));
				i=modecount_return;
				new_size=1;
			}
		}

		if (!found)
		{
			for (i=0; i<modecount_return; i++)
			{ 
				if ((modesinfo[i]->hdisplay==640)&&(modesinfo[i]->vdisplay==480))
				{
					found=1;
					memcpy(&foundmode,modesinfo[i],sizeof(XF86VidModeModeInfo));
					i=modecount_return;
					new_size=2;
				}
			}
		}
	}
	else
	{
		for (i=0; i<modecount_return; i++)
		{ 
			if ((modesinfo[i]->hdisplay==640)&&(modesinfo[i]->vdisplay==480))
			{
				found=1;
				memcpy(&foundmode,modesinfo[i],sizeof(XF86VidModeModeInfo));
				i=modecount_return;
				new_size=2;
			}
		}

		if (!found)
		{
			printf("Effects requires 640x480 resolution !\n");

			for (i=0; i<modecount_return; i++)
			{ 
				if ((modesinfo[i]->hdisplay==320)&&(modesinfo[i]->vdisplay==240))

				{
					found=1;
					memcpy(&foundmode,modesinfo[i],sizeof(XF86VidModeModeInfo));
					i=modecount_return;
					new_size=1;
				}
			}
		}
	}

	if (!found)
		MessageBoxErr("Video mode not found. Please define modeline for resolution 320x240 or 640x480 in XF86Config.");
	else
	{
		WindowedModeStorage.FullScreen=1;
		WindowedModeStorage.size=screen_size;
		XtVaGetValues(Dialog, XmNx, &rc_height, NULL);
		WindowedModeStorage.x=rc_height;
		XtVaGetValues(Dialog, XmNy, &rc_height, NULL);
		WindowedModeStorage.y=rc_height;

		/* printf("%d %d\n",WindowedModeStorage.x,WindowedModeStorage.y); */

		XF86VidModeGetModeLine(
			display, DefaultScreen(display),
			&dotclock_return,
			(void*)(&WindowedModeStorage.oldmode.hdisplay));

		WindowedModeStorage.oldmode.dotclock=dotclock_return;

		XF86VidModeGetViewPort(
			display, DefaultScreen(display),
			&WindowedModeStorage.vpx, 
			&WindowedModeStorage.vpy);

		toggled_sz(1, new_size, NULL);

		XtTranslateCoords(Dialog, 
			0, 0, &x, &y);

		XtMoveWidget(Dialog, 0, 0);
		XtAppAddTimeOut(app_context, 250, FSProc, NULL);
		
		
	}
}

#endif

void ClearWindow640x480MITSHM(void)
{
	if (screen_size==1) return;

	if (!interpolyatsia)
	{
		if ((depth==16)||(depth==15))
			bzero(vs16,640*480*2);
		if (depth==24)
			bzero(vs32,640*480*4);
	}

	if (interpolyatsia)
	{
		if ((depth==16)||(depth==15))
			bzero(vvs16,640*480*2);
		if (depth==24)
			bzero(vvs32,640*480*4);
	}

	if (depth==8) bzero(vs8,640*480);
}

void toggled_interpolation(widget, which, state)
	Widget widget;
	int which;
	XmToggleButtonCallbackStruct *state;
{
	if (state->set)
		interpolyatsia=1;
	else
		interpolyatsia=0;

	ClearWindow640x480MITSHM();
}

void toggled_scan(widget, which, state)
	Widget widget;
	int which;
	XmToggleButtonCallbackStruct *state;
{
	if (state->set)
		scan=1;
	else
		scan=0;

	ClearWindow640x480MITSHM();
}

void AddZ80FButton(Widget rc, int freq)
{
	char string[20];
	Widget b1;


	if (freq<=0) return;

	sprintf(string,"%1.1f Mhz",((double)freq)/10.0);

	n = 0;
	XtSetArg(args[n], XmNlabelString,  XmStringCreate (string,XmFONTLIST_DEFAULT_TAG)); n++;
	XtSetArg(args[n], XmNshadowThickness, 1); n++; 
	XtSetArg(args[n], XmNhighlightThickness,0); n++; 

	b1=XmCreatePushButton(rc, "pb", args, n);
	XtManageChild(b1);
	XtAddCallback(b1, XmNactivateCallback, (XtCallbackProc) setZ80spd_100, (XtPointer)freq);
}

void reset_h(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	clear_timer();
	Reset();
	if (XLib)reDrawAllScreen();
	tape_SetActiveAndPause(tapes);	
	MaxSpeenND_Stop();
	init_timer();
	XmProcessTraversal(drawing_a, XmTRAVERSE_CURRENT);
}

void cancel_open_file(w, client_data, cbs)
	Widget w;
	XtPointer client_data;

	XmFileSelectionBoxCallbackStruct *cbs;
{
	blocking_popup_trig=1;
	XtUnmanageChild(w);
	XmProcessTraversal(drawing_a, XmTRAVERSE_CURRENT);	
}	

int Load128_131103_snap(char * filename)
{
	int fil;
	unsigned char buffer[27];

	clear_timer();

	fil=open(filename,O_RDONLY);	

	if (fil==-1)
	{
		sprintf(tstring,"Unable to open %s", filename);
		MessageBoxErr(tstring);
		init_timer();
		return(errors);
	}
	

	printf(".sna 128k\n");

	lseek(fil,49179,SEEK_SET);
	read(fil,buffer,4);


	Set128kMode();
	Load128ROMs();	

	Port7ffdOut(buffer[2]);

	memcpy(&PC,buffer,2);
#if defined BIGENDIAN
	byteswp (&PC); 
#endif	

	Zamolchi();


	lseek(fil,0,SEEK_SET);
	read(fil,buffer,27);

	I=buffer[0];
	L1=buffer[ 1];      H1=buffer[ 2];
	E1=buffer[ 3];      D1=buffer[ 4];
	C1=buffer[ 5];      B1=buffer[ 6];
	F1=buffer[ 7];      A1=buffer[ 8];
	L =buffer[ 9];      H =buffer[10];
	E =buffer[11];      D =buffer[12];
	C =buffer[13];      B =buffer[14];

	memcpy(&IY,&buffer[15],2);
	memcpy(&IX,&buffer[17],2);

#if defined BIGENDIAN
	byteswp (&IX); 
	byteswp (&IY);
#endif	

	F =buffer[21];    A  =buffer[22];

	memcpy(&SP,&buffer[23],2);

#if defined BIGENDIAN
	byteswp (&SP); 
#endif	
	border=buffer[26];
	interrupts=(buffer[19]&0x04)>>2;
	IM=buffer[25];

	read(fil,GiveAddrW1(16384),32768);
	read(fil,GiveAddrW1(49152),16384);

	lseek(fil,49183,SEEK_SET);

	if (new_ram!=RAM0)
		read(fil,RAM0,16384);

	if (new_ram!=RAM1)
		read(fil,RAM1,16384);

	if (new_ram!=RAM3)
		read(fil,RAM3,16384);

	if (new_ram!=RAM4)
		read(fil,RAM4,16384);

	if (new_ram!=RAM6)
		read(fil,RAM6,16384);

	if (new_ram!=RAM7)
		read(fil,RAM7,16384);

	close(fil);
	if (XLib)reDrawAllScreen();
	init_timer();
	return(no_errors);
}

int open_snapshot(char *filename)
{
	char ext[4];
	char extention[5]={0};
	struct stat sbuf;	
	
	strncpy(extention,&filename[strlen(filename)-4],4);

	if (extention[3]=='/')
	{
		ERR_PR("Directory selected !");
		return (0);
	}

	if (strlen(filename)<5)
	{
		ERR_PR("Unknown file type !");
		return (0);
	}

	sprintf(ext,"%s",&filename[strlen(filename)-3]);
	stat(filename,&sbuf); 

	if (strcasecmp(ext,"sna")==0)
	{
		if (sbuf.st_size==49179)
		{
			new_ram=RAM0;
			z80Reset();

			Load48snap(filename);
			goto LQ;
		}

		if (sbuf.st_size==131103)
		{
			new_ram=RAM0;
			z80Reset();

			Load128_131103_snap(filename);
			goto LQ;
		}

		if (sbuf.st_size==147487)
		{
			new_ram=RAM0;
			z80Reset();

			Load128_131103_snap(filename);
			goto LQ;
		}

		ERR_PR("Unknown .sna format !");
		return(0);
	}

	if (strcasecmp(ext,"z80")==0)
	{
		new_ram=RAM0;
		z80Reset();

		Loadz80(filename);
		goto LQ;
	}
	
	ERR_PR("Unknown file type !");
	return (0);
LQ:
	return(1);
}

void open_file(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmFileSelectionBoxCallbackStruct *cbs;
{
	char * filename;
	char * directory;

	XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &filename);
	XmStringGetLtoR(cbs->dir, XmSTRING_DEFAULT_CHARSET, &directory);

	sprintf(start_directory,directory);
	
	if(!open_snapshot(filename))
	{
		tounmanage=w;
		MessageBoxEx("Error loading snapshot!");
		return;
	}
	
	XtUnmanageChild(w);
	XmProcessTraversal(drawing_a, XmTRAVERSE_CURRENT);
}

void open_sn_h(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	Widget dialog;

	dialog = XmCreateFileSelectionDialog(first_window, "Open snapshot", NULL, 0);

	XtVaSetValues(dialog,
		XmNdirectory,XmStringCreate (start_directory,XmFONTLIST_DEFAULT_TAG),
		NULL);

	XtAddCallback(dialog, XmNcancelCallback, (XtCallbackProc)cancel_open_file, NULL);
	XtAddCallback(dialog, XmNokCallback, (XtCallbackProc)open_file, NULL);

	XtManageChild(dialog);
}


void gotfocus(Widget w, XtPointer client, XEvent *xev, Boolean *cont)
{
	if (xev->xcrossing.detail != NotifyInferior)
		XAutoRepeatOff(display);
}

void lostfocus(Widget w, XtPointer client, XEvent *xev, Boolean *cont)
{
	if (xev->xcrossing.detail != NotifyInferior)
		XAutoRepeatOn(display);
}

void change_focus(Widget w, XtPointer client, XEvent *xev, Boolean *cont)
{
	if (xev->type==FocusIn)
		XmProcessTraversal(drawing_a, XmTRAVERSE_CURRENT);	
}

void reDrawFlashed(void)
{
	int i;


	for (i=0; i<768; i++)

		if (attrib48[i]&128) Draw64Pix(i,~attrib48[i],attrib48[i]);

}

void reDrawAllScreen(void)
{
	int i;


	DrawBorder();

	for (i=0; i<768; i++)
		Draw64Pix(i,~attrib48[i],attrib48[i]);
}

void drawing_events(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmDrawingAreaCallbackStruct *cbs;
{
	if (screen_created==0)
	{
		if (
			InitScreen(XtDisplay(drawing_a),XtWindow(drawing_a))
			== errors) ExitWithError(-1,"");

		XmProcessTraversal(drawing_a, XmTRAVERSE_CURRENT);

#if defined log
		Loadz80("snap.z80");
#endif

		init_timer();
		screen_created=1;
	}	

	if (XLib) reDrawAllScreen();
}

void drawing_events_leds(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmDrawingAreaCallbackStruct *cbs;
{
	int dest_x_return;
	Window child_return;
	Dimension x, y;                                                    


	XtVaGetValues(leds, XmNwidth, &x, XmNheight, &y, NULL);

	XTranslateCoordinates(display,
		XtWindow(show_mode),
		XtWindow(status_bar),
		0, 0, &dest_x_return,
		&ledsY, &child_return);

	ledsWindow=cbs->window;

	XClearWindow(display, ledsWindow);
}

void drawing_events_sc_vol(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmDrawingAreaCallbackStruct *cbs;
{
	XtVaGetValues(tape_sc_lev, XmNwidth, &tape_sc_lev_x, XmNheight, &tape_sc_lev_y, NULL);
	tape_sc_lev_win=cbs->window;
}

#if defined XF86VMODE
void BackToWindowedMode(void)
{
	if (!WindowedModeStorage.FullScreen) 
	{
		FullScreen(NULL,NULL,NULL);
		return;
	}

	WindowedModeStorage.FullScreen=0;

	XF86VidModeSwitchToMode(display, DefaultScreen(display),
		&WindowedModeStorage.oldmode);

	toggled_sz(1, WindowedModeStorage.size, NULL);

	XUndefineCursor(display, XtWindow(drawing_a));

	XUngrabPointer(display, CurrentTime);
	XWarpPointer(display, XtWindow(drawing_a), XtWindow(drawing_a), 0, 0, 0, 0,WindowedModeStorage.vpx,WindowedModeStorage.vpy);

	XtMoveWidget(Dialog, WindowedModeStorage.x, WindowedModeStorage.y);
	XRaiseWindow(display,XtWindow(XtParent(main_window)));

	XF86VidModeSetViewPort(display, DefaultScreen(display),WindowedModeStorage.vpx,WindowedModeStorage.vpy);

	XSetInputFocus(display, XtWindow(XtParent(main_window)), 
		RevertToNone, CurrentTime);

	XmProcessTraversal(drawing_a, XmTRAVERSE_CURRENT);

	NajatKnopku(FullScreenB, False);
}
#endif

void ShowHideLeds(void)
{
	leds_global=1-leds_global;

	XClearWindow(display, ledsWindow);
}

enum DIMAGE_TYPE get_img_type(char *ext)
{
	enum DIMAGE_TYPE dt;
	
	if(!strcasecmp(ext,"trd"))dt=imgTRD;
	else if (!strcasecmp(ext,"td0"))dt=imgTD0;
	else if (!strcasecmp(ext,"fdi"))dt=imgFDI;
	else if (!strcasecmp(ext,"udi"))dt=imgUDI;
	else dt=imgUnknown;
	
	return(dt);
}

void SaveDiskImage(Widget w, int i, XmDrawingAreaCallbackStruct *cbs)
{
	char *filename, *ext;
	enum DIMAGE_TYPE dt;
	
	filename=discs[i].filename;
	if(!strcmp(filename,"none")) return;
	if((ext=get_file_ext(filename))==NULL) return;
		
	if(strcasecmp(ext,"trd") && strcasecmp(ext,"fdi") && strcasecmp(ext,"td0") && strcasecmp(ext,"udi"))
	{
		DBG_PR("Saving disk image in another format");
		disk_SaveAsDialog(main_window, i, NULL);
	}
	else
	{
		dt=get_img_type(ext);
		if(dt!=imgUnknown)
		{
			DBG_PR("Saving disk image %s", filename);
			if(!wd1793_save_dimage(filename,i,dt))
			{
				sprintf(tstring,"Cannot save to %s", filename);
				MessageBoxErr(tstring);
			}
		}
		else
		{
			MessageBoxErr("Unknown file type");
		}
	}	
}

void eject_disk(int drive)
{
	DBG_PR("ejecting disk %c (name=%s)",'A'+drive,discs[drive].filename);
	if(!wd1793_is_disk_loaded(drive) || !strcmp(discs[drive].filename,"none"))
		return;
	
	if(wd1793_is_disk_changed(drive))
	{
		sprintf(tstring,"Disk in drive %c has been changed. Save?",'A'+drive);
		if(AskModal(main_window, tstring, "Yes", "No") == 1)
		{
			SaveDiskImage(main_window,drive,NULL);
		}
	}

	wd1793_eject_dimage(drive);
	strcpy(discs[drive].filename,"none");
	
	if(gui_running)
	{
		XmTextSetString(dan,discs[0].filename);
		XmTextSetString(dbn,discs[1].filename);
		XmTextSetString(dcn,discs[2].filename);
		XmTextSetString(ddn,discs[3].filename);
	}		
}

void exitPoF10(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmDrawingAreaCallbackStruct *cbs;
{
	int i;
	
	for(i=0;i<4;++i)
	{
		eject_disk(i);
	}	

	exit(0);
}

void key_pressed(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmDrawingAreaCallbackStruct *cbs;
{
	memcpy(&ev,cbs->event,sizeof(XEvent));

	switch(ev.type)
	{
		case KeyRelease:

			KEY=XLookupKeysym((XKeyEvent *)&ev,0);

			switch (KEY)
			{
				case XK_1:
					f7fe.d0=1;
					break;

				case XK_2:
					f7fe.d1=1;
					break;

				case XK_3:
					f7fe.d2=1;
					break;

				case XK_4:
					f7fe.d3=1;
					break;

				case XK_5:
					f7fe.d4=1;
					break;


				case XK_q:
				case XK_Q:
					fbfe.d0=1;
					break;


				case XK_w:
				case XK_W:
					fbfe.d1=1;
					break;

				case XK_e:
				case XK_E:
					fbfe.d2=1;
					break;

				case XK_r:
				case XK_R:
					fbfe.d3=1;
					break;

				case XK_t:
				case XK_T:
					fbfe.d4=1;
					break;


				case XK_a:
				case XK_A:
					fdfe.d0=1;
					break;

				case XK_s:
				case XK_S:
					fdfe.d1=1;
					break;

				case XK_d:
				case XK_D:
					fdfe.d2=1;
					break;

				case XK_f:
				case XK_F:
					fdfe.d3=1;
					break;

				case XK_g:
				case XK_G:
					fdfe.d4=1;
					break;


				case XK_Shift_L:
				case XK_Shift_R:
					fefe.d0=1;
					break;

				case XK_z:



				case XK_Z:
					fefe.d1=1;
					break;

				case XK_x:
				case XK_X:
					fefe.d2=1;
					break;

				case XK_c:
				case XK_C:
					fefe.d3=1;
					break;

				case XK_v:
				case XK_V:
					fefe.d4=1;
					break;


				case XK_6:
					effe.d4=1;
					break;

				case XK_7:
					effe.d3=1;
					break;

				case XK_8:
					effe.d2=1;
					break;

				case XK_9:
					effe.d1=1;
					break;

				case XK_0:
					effe.d0=1;
					break;


				case XK_y:
				case XK_Y:
					dffe.d4=1;
					break;

				case XK_u:
				case XK_U:
					dffe.d3=1;
					break;

				case XK_i:
				case XK_I:
					dffe.d2=1;
					break;

				case XK_o:
				case XK_O:
					dffe.d1=1;
					break;

				case XK_p:
				case XK_P:
					dffe.d0=1;
					break;


				case XK_h:
				case XK_H:
					bffe.d4=1;
					break;

				case XK_j:
				case XK_J:
					bffe.d3=1;
					break;

				case XK_k:
				case XK_K:
					bffe.d2=1;
					break;

				case XK_l:
				case XK_L:
					bffe.d1=1;
					break;

				case XK_Return:
					bffe.d0=1;
					break;


				case XK_b:
				case XK_B:
					sffe.d4=1;
					break;

				case XK_n:
				case XK_N:
					sffe.d3=1;
					break;

				case XK_m:
				case XK_M:
					sffe.d2=1;
					break;

				case XK_Alt_L:
				case XK_Alt_R:
					sffe.d1=1;
					break;

				case XK_space:
					sffe.d0=1;
					break;	

				case XK_BackSpace:
					fefe.d0=1;
					effe.d0=1;
					break;	

				case XK_Control_L:
				case XK_Control_R:
					if (joy_type==0)
						kempston.bit.fire=0;
					if (joy_type==1)
						effe.d0=1;
					if (joy_type==2)
					{
						effe.d0=1;
					}
					break;

				case XK_Left:
					if (joy_type==0)
						kempston.bit.left=0;
					if (joy_type==1)
						effe.d4=1;
					if (joy_type==2)
					{
						f7fe.d4=1;
						fefe.d0=1;
					}
					break;

				case XK_Right:
					if (joy_type==0)
						kempston.bit.right=0;
					if (joy_type==1)
						effe.d3=1;
					if (joy_type==2)
					{
						effe.d2=1;	
						fefe.d0=1;
					}
					break;

				case XK_Up:
					if (joy_type==0)
						kempston.bit.up=0;
					if (joy_type==1)
						effe.d1=1;
					if (joy_type==2)
					{
						effe.d3=1;	
						fefe.d0=1;
					}
					break;

				case XK_Down:
					if (joy_type==0)
						kempston.bit.down=0;
					if (joy_type==1)
						effe.d2=1;
					if (joy_type==2)
					{
						effe.d4=1;
						fefe.d0=1;
					}
					break;

				case XK_Tab:
					{
						sffe.d1=1;	/* alt */
						fefe.d0=1;
					}	
					break;

				case XK_apostrophe:
					{
						sffe.d1=1;	/* alt */
						dffe.d0=1;
					}
					break;

				case XK_comma:
					{
						sffe.d1=1;	/* alt */
						sffe.d3=1;
					}
					break;

				case  XK_semicolon:
					{
						sffe.d1=1;	/* alt */
						dffe.d1=1;
					}
					break;

				case  XK_equal:
					{
						sffe.d1=1;	/* alt */
						bffe.d2=1;	
					}
					break;

				case  XK_minus:
					{
						sffe.d1=1;	/* alt */
						bffe.d3=1;	
					}
					break;

				case  XK_period:
					{
						sffe.d1=1;	/* alt */
						sffe.d2=1;
					}
					break;

				case  XK_KP_Multiply:
					{
						sffe.d1=1;	/* alt */
						sffe.d4=1;	
					}
					break;

				case  XK_grave:
					{
						fefe.d0=1;  /* shift */
						f7fe.d0=1;	
					}
					break;

				case  XK_Escape:
					{
						fefe.d0=1;  /* shift */
						sffe.d0=1;
					}
					break;
			}

			break;


		case KeyPress:
			KEY=XLookupKeysym((XKeyEvent *)&ev,0);
			switch(KEY)
			{
				case XK_F4:
					emu_go_pause_h(NULL, NULL, NULL);
					break;	

				case XK_F2:
					SaveZ80(quick_snapshot_name);
					break;

				case XK_F3:
					Loadz80(quick_snapshot_name);
					break;

#if defined XF86VMODE
				case XK_F5:
					BackToWindowedMode();
					break;
#endif

				case XK_F6:
					ShowHideLeds();
					break;

					/*
				case XK_F7:
					new_rom=ROM1;
					PC=15616;
					break;
					*/

				case XK_F11:
					PrintSpInfo();
					break;

				case XK_F12:
					reset_h(NULL, NULL, NULL);
					break;

				case XK_F10:
					MessageBoxOkCan((XtCallbackProc)exitPoF10, NULL, NULL, "Really Quit ?");					
					break;

				case XK_1:
					f7fe.d0=0;
					break;

				case XK_2:
					f7fe.d1=0;
					break;
					


				case XK_3:
					f7fe.d2=0;
					break;

				case XK_4:
					f7fe.d3=0;
					break;

				case XK_5:
					f7fe.d4=0;
					break;


				case XK_q:
				case XK_Q:
					fbfe.d0=0;
					break;

				case XK_w:
				case XK_W:
					fbfe.d1=0;
					break;

				case XK_e:
				case XK_E:
					fbfe.d2=0;
					break;

				case XK_r:
				case XK_R:
					fbfe.d3=0;
					break;


				case XK_t:
				case XK_T:
					fbfe.d4=0;
					break;


				case XK_a:
				case XK_A:
					fdfe.d0=0;
					break;

				case XK_s:
				case XK_S:
					fdfe.d1=0;
					break;

				case XK_d:
				case XK_D:
					fdfe.d2=0;
					break;

				case XK_f:
				case XK_F:
					fdfe.d3=0;
					break;

				case XK_g:
				case XK_G:
					fdfe.d4=0;
					break;


				case XK_Shift_L:
				case XK_Shift_R:
					fefe.d0=0;

					break;

				case XK_z:
				case XK_Z:
					fefe.d1=0;
					break;

				case XK_x:
				case XK_X:
					fefe.d2=0;
					break;

				case XK_c:
				case XK_C:
					fefe.d3=0;
					break;

				case XK_v:

				case XK_V:
					fefe.d4=0;
					break;


				case XK_6:
					effe.d4=0;
					break;

				case XK_7:
					effe.d3=0;
					break;

				case XK_8:
					effe.d2=0;
					break;

				case XK_9:
					effe.d1=0;
					break;

				case XK_0:
					effe.d0=0;
					break;


				case XK_y:
				case XK_Y:
					dffe.d4=0;
					break;

				case XK_u:
				case XK_U:
					dffe.d3=0;
					break;

				case XK_i:
				case XK_I:
					dffe.d2=0;
					break;

				case XK_o:
				case XK_O:
					dffe.d1=0;
					break;

				case XK_p:
				case XK_P:
					dffe.d0=0;
					break;


				case XK_h:
				case XK_H:
					bffe.d4=0;
					break;

				case XK_j:
				case XK_J:
					bffe.d3=0;
					break;

				case XK_k:
				case XK_K:
					bffe.d2=0;
					break;

				case XK_l:
				case XK_L:
					bffe.d1=0;
					break;

				case XK_Return:
					bffe.d0=0;
					break;


				case XK_b:
				case XK_B:
					sffe.d4=0;
					break;

				case XK_n:
				case XK_N:
					sffe.d3=0;
					break;

				case XK_m:
				case XK_M:
					sffe.d2=0;

					break;

				case XK_Alt_L:
				case XK_Alt_R:
					sffe.d1=0;
					break;

				case XK_space:
					sffe.d0=0;
					break;	

				case XK_BackSpace:
					fefe.d0=0;
					effe.d0=0;
					break;

				case XK_Control_L:
				case XK_Control_R:
					if (joy_type==0)
						kempston.bit.fire=1;
					if (joy_type==1)
						effe.d0=0;
					if (joy_type==2)
					{
						effe.d0=0;
					}
					break;

				case XK_Left:
					if (joy_type==0)
						kempston.bit.left=1;
					if (joy_type==1)
						effe.d4=0;

					if (joy_type==2)
					{
						f7fe.d4=0;
						fefe.d0=0;
					}
					break;

				case XK_Right:
					if (joy_type==0)
						kempston.bit.right=1;
					if (joy_type==1)
						effe.d3=0;
					if (joy_type==2)
					{
						effe.d2=0;	
						fefe.d0=0;
					}
					break;

				case XK_Up:
					if (joy_type==0)
						kempston.bit.up=1;
					if (joy_type==1)
						effe.d1=0;
					if (joy_type==2)
					{
						effe.d3=0;	
						fefe.d0=0;
					}
					break;

				case XK_Down:
					if (joy_type==0)
						kempston.bit.down=1;
					if (joy_type==1)
						effe.d2=0;
					if (joy_type==2)
					{
						effe.d4=0;
						fefe.d0=0;
					}
					break;

				case XK_Tab:
					{
						sffe.d1=0;	/* alt */
						fefe.d0=0;
					}	
					break;

				case XK_apostrophe:
					{
						sffe.d1=0;	/* alt */
						dffe.d0=0;
					}
					break;
					

				case XK_comma:
					{
						sffe.d1=0;	/* alt */
						sffe.d3=0;
					}
					break;

				case  XK_semicolon:
					{
						sffe.d1=0;	/* alt */
						dffe.d1=0;
					}
					break;

				case  XK_equal:
					{
						sffe.d1=0;	/* alt */
						bffe.d2=0;	
					}
					break;

				case  XK_minus:
					{
						sffe.d1=0;	/* alt */
						bffe.d3=0;	
					}
					break;

				case  XK_period:
					{
						sffe.d1=0;	/* alt */
						sffe.d2=0;
					}
					break;

				case  XK_KP_Multiply:
					{
						sffe.d1=0;	/* alt */
						sffe.d4=0;	
					}
					break;

				case  XK_grave:
					{
						fefe.d0=0;  /* shift */
						f7fe.d0=0;	
					}
					break;

				case  XK_Escape:
					{
						fefe.d0=0;  /* shift */
						sffe.d0=0;
					}
					break;

					/*
				default:
					{
						printf("0x%x\n",KEY);
					}
					*/
			}
			break;
	}
}

void FixPaneH(Widget w)
{
	Dimension  height;                                                    


	if (!w)return;

	XtVaGetValues(w, XmNheight, &height, NULL);

	n=0;
	XtSetArg(args[n], XmNpaneMaximum, height); n++;
	XtSetArg(args[n], XmNpaneMinimum, height); n++;

	XtSetValues(w, args, n); 
}

void FixHeight(Widget w)
{
	Dimension width, height;                                                    

	XtVaGetValues(w, XmNwidth, &width, XmNheight, &height, NULL);

	n=0;
	XtSetArg(args[n], XmNminHeight, height); n++;
	XtSetArg(args[n], XmNmaxHeight, height); n++;

	XtSetValues(w, args, n); 
}

void FixWidth(Widget w)
{
	Dimension width, height;                                                    

	XtVaGetValues(w, XmNwidth, &width, XmNheight, &height, NULL);

	n=0;
	XtSetArg(args[n], XmNminWidth, width); n++;
	XtSetArg(args[n], XmNmaxWidth, width); n++;

	XtSetValues(w, args, n); 
}

void DisableWidget(Widget w)
{
	n=0;
	XtSetArg(args[n],  XmNsensitive, False); n++;
	XtSetValues(w, args, n); 	
}

void EnableWidget(Widget w)
{
	n=0;
	XtSetArg(args[n],  XmNsensitive, True); n++;
	XtSetValues(w, args, n); 	
}

void toggled_mode(widget, which, state)
	Widget widget;
	int which;
	XmToggleButtonCallbackStruct *state;
{
	if (which==0)
		sprintf(Mode,"48");
	if (which==1)
		sprintf(Mode,"128");
	if (which==2)
		sprintf(Mode,"Pentagon");
	if (which==3)
		sprintf(Mode,"Scorpion");

	Reset();
}

void toggled_km(widget, which, state)
	Widget widget;
	int which;
	XmToggleButtonCallbackStruct *state;
{
	kempston_mouse=which;
}

void toggled_joy(widget, which, state)
	Widget widget;
	int which;
	XmToggleButtonCallbackStruct *state;
{
	joy_type=which;
}

void ShowSSKakNado(void)
{
	if (!sound)
	{
		DisableWidget(ss_slider);

		n=0;
		XtSetArg(args[n], XmNset, False); n++;
		XtSetValues(four1_ena, args, n); 

		n=0;
		XtSetArg(args[n], XmNset, True); n++;
		XtSetValues(four1, args, n); 
	}
	else
	{
		EnableWidget(ss_slider);

		n=0;
		XtSetArg(args[n], XmNset, True); n++;
		XtSetValues(four1_ena, args, n); 

		n=0;
		XtSetArg(args[n], XmNset, False); n++;
		XtSetValues(four1, args, n); 
	}
}

void toggled_sound_freq(widget, which, state)
	Widget widget;
	int which;
	XmToggleButtonCallbackStruct *state;
{
	int copysound;


	copysound=sound;
	sound=off;
	if (copysound)close(audio);

	switch(which)
	{
		case 1:
			Sound_Freq=44100;
			break;
		case 2:
			Sound_Freq=22050;
			break;
		case 3:
			Sound_Freq=11025;
			break;
	}

	if (copysound)
	{
		if (SoundcardInit(direct_recording)==errors)
		{
			sound=off;
			MessageBoxErr("SoundcardInit() failed. No sound.");
		}
		else
			sound=on;
	}

	ShowSSKakNado();
}

void toggled_sound_ena(widget, which, state)
	Widget widget;
	int which;
	XmToggleButtonCallbackStruct *state;
{
	if (!which)
	{
		if (sound)
			close(audio);

		sound=off;

		ShowSSKakNado();

		return;
	}

	if (!sound)
	{
		if (SoundcardInit(direct_recording)==errors)
		{
			MessageBoxErr("Sound card initialization failed. No sound.");
			sound=off;
		}
		else
		{
			sound=on;
			UpdateStep = ((double)STEP * 44100 * 8) / 1773400 * 2;		
		}
	}

	ShowSSKakNado();
}

void toggled_sound(widget, which, state)
	Widget widget;
	int which;
	XmToggleButtonCallbackStruct *state;
{
	stereo_mode=which-1;
	ShowSSKakNado();
}

void setBeeper_Volume(scale_w, rgb, cbs)
	Widget scale_w;
	int rgb;
	XmScaleCallbackStruct *cbs;
{
	beeper_volume=cbs->value;
}	

void setSNDDev (w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	int copysound;


	strcpy(audio_name,XmTextGetString(ss_dev));

	copysound=sound;
	sound=off;

	if (copysound)
	{	
		close(audio);
		if (SoundcardInit(direct_recording)==errors)
		{
			MessageBoxErr("SoundcardInit() failed. No sound.");
			sound=off;
		}
		else
			sound=on;
	}

	ShowSSKakNado();
}

void setRecDev (w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	strcpy(sound_device_nameR,XmTextGetString(tape_dev));
}

int SelectDiskImage(int num, char * arg, int messagebox)
{
	Widget *dw;
	
	if(gui_running)
	switch(num)
	{
		case 0: dw=&dan; break;
		case 1: dw=&dbn; break;
		case 2: dw=&dcn; break;
		case 3: dw=&ddn; break;			
	}
	
	if (strcmp(arg,"none")==0)
	{
		strcpy(discs[num].filename,arg);
		return(1);
	}

	eject_disk(num);
	
	if(!wd1793_load_dimage(arg,num))
	{
		sprintf(tstring,"Cannot load disk image %s.", arg);
		MessageBoxErr(tstring);
		strcpy(discs[num].filename,"none");
		if(gui_running) XmTextSetString(*dw,discs[num].filename);
		discs[num].type=0;
		return(0);
	}
	else
	{
		strcpy(discs[num].filename,arg);
		if(gui_running) XmTextSetString(*dw,arg);
		DBG_PR("file %s loaded in drive %c",arg,'A'+num);
	}
	
	return(1);
}

char filenameNEW[255];

void disk1_some_selected(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmFileSelectionBoxCallbackStruct * cbs;
{
	char * filename;
	char * directory;

	XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &filename);
	XmStringGetLtoR(cbs->dir, XmSTRING_DEFAULT_CHARSET, &directory);

	sprintf(disk_directory,directory);

	if(!SelectDiskImage(0, filename, 1))
	{
		tounmanage=w;
		MessageBoxEx("Cannot load disk image!");
		return;
	}

	XtUnmanageChild(w);
	XmProcessTraversal(drawing_a, XmTRAVERSE_CURRENT);
	return;
}

void disk1_create_selectFNdialog(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	Widget dialog;

	dialog = XmCreateFileSelectionDialog(first_window, "Image for disk A selection", NULL, 0);

	XtVaSetValues(dialog,
		XmNdirectory,XmStringCreate (disk_directory,XmFONTLIST_DEFAULT_TAG),
		NULL);
	

	XtAddCallback(dialog, XmNcancelCallback, (XtCallbackProc)cancel_open_file, NULL);
	XtAddCallback(dialog, XmNokCallback, (XtCallbackProc)disk1_some_selected, NULL);

	XtManageChild(dialog);
}

void disk2_some_selected(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmFileSelectionBoxCallbackStruct * cbs;
{
	char * filename;
	char * directory;
	
	XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &filename);
	XmStringGetLtoR(cbs->dir, XmSTRING_DEFAULT_CHARSET, &directory);

	sprintf(disk_directory,directory);
	
	if(!SelectDiskImage(1, filename, 1))
	{
		tounmanage=w;
		MessageBoxEx("Cannot load disk image!");
		return;
	}

	XtUnmanageChild(w);
	XmProcessTraversal(drawing_a, XmTRAVERSE_CURRENT);
	return;
}

void disk_setReadOnly(w, n, state)
	Widget w;
	int n;
	XmToggleButtonCallbackStruct * state;
{
	FILE * fil;


	if (!strcmp(discs[n].filename,"none"))
		return;

	if (!FileExists(discs[n].filename))
		return;

	if (state->set)
	{
		discs[n].ro=1;
		wd1793_set_disk_wprotected(n, 1);
		return;
	}

	fil=fopen(discs[n].filename,"a");
	if (fil==NULL)
	{
		MessageBoxErr("Write protection.");
		XtVaSetValues(w,XmNset,1,NULL);
		return;
	}

	fclose(fil);
	discs[n].ro=0;
	wd1793_set_disk_wprotected(n, 0);
}

void disk2_create_selectFNdialog(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	Widget dialog;

	dialog = XmCreateFileSelectionDialog(first_window, "Image for disk B selection", NULL, 0);

	XtVaSetValues(dialog,
		XmNdirectory,XmStringCreate (disk_directory,XmFONTLIST_DEFAULT_TAG),
		NULL);

	XtAddCallback(dialog, XmNcancelCallback, (XtCallbackProc)cancel_open_file, NULL);
	XtAddCallback(dialog, XmNokCallback, (XtCallbackProc)disk2_some_selected, NULL);

	XtManageChild(dialog);
}

void disk3_some_selected(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmFileSelectionBoxCallbackStruct * cbs;
{
	char * filename;
	char * directory;

	XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &filename);
	XmStringGetLtoR(cbs->dir, XmSTRING_DEFAULT_CHARSET, &directory);

	sprintf(disk_directory,directory);

	if(!SelectDiskImage(2, filename, 1))
	{
		tounmanage=w;
		MessageBoxEx("Cannot load disk image!");
		return;
	}

	XtUnmanageChild(w);
	XmProcessTraversal(drawing_a, XmTRAVERSE_CURRENT);
	return;
}

void disk3_create_selectFNdialog(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	Widget dialog;

	dialog = XmCreateFileSelectionDialog(first_window, "Image for disk C selection", NULL, 0);

	XtVaSetValues(dialog,
		XmNdirectory,XmStringCreate (disk_directory,XmFONTLIST_DEFAULT_TAG),
		NULL);

	XtAddCallback(dialog, XmNcancelCallback, (XtCallbackProc)cancel_open_file, NULL);
	XtAddCallback(dialog, XmNokCallback, (XtCallbackProc)disk3_some_selected, NULL);

	XtManageChild(dialog);
}


void disk4_some_selected(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmFileSelectionBoxCallbackStruct * cbs;

{
	char * filename;
	char * directory;

	XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &filename);
	XmStringGetLtoR(cbs->dir, XmSTRING_DEFAULT_CHARSET, &directory);

	sprintf(disk_directory,directory);

	if(!SelectDiskImage(3, filename, 1))
	{
		tounmanage=w;
		MessageBoxEx("Cannot load disk image!");
		return;
	}

	XtUnmanageChild(w);
	XmProcessTraversal(drawing_a, XmTRAVERSE_CURRENT);
	return;
}

void disk4_create_selectFNdialog(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	Widget dialog;

	dialog = XmCreateFileSelectionDialog(first_window, "Image for disk D selection", NULL, 0);

	XtVaSetValues(dialog,
		XmNdirectory,XmStringCreate (disk_directory,XmFONTLIST_DEFAULT_TAG),
		NULL);

	XtAddCallback(dialog, XmNcancelCallback, (XtCallbackProc)cancel_open_file, NULL);
	XtAddCallback(dialog, XmNokCallback, (XtCallbackProc)disk4_some_selected, NULL);

	XtManageChild(dialog);
}

void disk_SaveAsDialog(Widget w, int n, XmPushButtonCallbackStruct *cbs)
{
	Widget dialog;
	char fname[500];
	char dir[500];
	char *ext;
	int i;

	strcpy(fname,discs[n].filename);
	
	/*extract directory*/
	strcpy(dir,discs[n].filename);
	for(i=strlen(dir)-1;i && dir[i]!='/';i--) dir[i]='\0';
	dir[i]='\0';
	
	ext=get_file_ext(fname);
	if(strlen(ext)==3)
	if(strcasecmp(ext,"trd") && strcasecmp(ext,"fdi") && strcasecmp(ext,"td0") && strcasecmp(ext,"udi"))
	{
		strcpy(ext,"trd");
	}

	if(!wd1793_is_disk_loaded(n)) return;

	dialog = XmCreateFileSelectionDialog(first_window, "Save disk image", NULL, 0);

	XtVaSetValues(dialog,
		XmNdirectory,XmStringCreate (dir,XmFONTLIST_DEFAULT_TAG),
		NULL);
	XtVaSetValues(dialog,
		XmNdirSpec,XmStringCreate (fname,XmFONTLIST_DEFAULT_TAG),
		NULL);

	XtAddCallback(dialog, XmNcancelCallback, (XtCallbackProc)cancel_open_file, NULL);
	XtAddCallback(dialog, XmNokCallback, (XtCallbackProc)save_disk_as, (XtPointer) n);

	XtManageChild(dialog);	
	blocking_popup_trig=0;
	while (!blocking_popup_trig || XtAppPending(app_context)) XtAppProcessEvent(app_context, XtIMAll);	
}

void disk_Eject(w, n, cbs)
	Widget w;
	int n ;
	XmPushButtonCallbackStruct *cbs;
{
	eject_disk(n);
}

void disc_settings_h(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	static Widget dialog;
	static Widget pane;

	static Widget form; 

	Widget label,button,rc;
	Widget rc1;


	if (!dialog)
	{
		dialog = XtVaCreatePopupShell("Quick Tape",
				xmDialogShellWidgetClass, first_window,
				XmNtitle,  "Disk image selection",
				NULL);

		pane = XtVaCreateWidget("pane", xmPanedWindowWidgetClass, dialog,
				XmNsashWidth,  1, /* try to "hide" resizing sash.  PanedWindow */
				XmNsashHeight, 1, /* won't let us set to 0, so 1 will have to do */
				NULL);

		form = XtVaCreateWidget("form", xmFormWidgetClass, pane, NULL);

		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
		XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;

		rc = XmCreateRowColumn(form, "rowcol", args, n);

		label=XtVaCreateManagedWidget("add_label", xmLabelWidgetClass, rc,
				XmNlabelString, XmStringCreate ("Disk A image :",XmFONTLIST_DEFAULT_TAG),
				NULL);

		dan=XtVaCreateManagedWidget("", xmTextWidgetClass, rc,
				XmNwidth,300,
				XmNeditable, False,
				NULL);

		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		rc1 = XmCreateRowColumn(rc, "rowcol", args, n);

		disk1ro=XtVaCreateManagedWidget("Read only",
				xmToggleButtonGadgetClass, rc1, 
				XmNhighlightThickness,0, 
				NULL);

		XtAddCallback(disk1ro, XmNvalueChangedCallback, (XtCallbackProc)disk_setReadOnly, (XtPointer) 0);

		button= XtVaCreateManagedWidget("Select", 
				xmPushButtonWidgetClass, rc1, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1,
				NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) disk1_create_selectFNdialog, NULL);

		button= XtVaCreateManagedWidget("Eject", 
				xmPushButtonWidgetClass, rc1, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1,
				NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) disk_Eject, (XtPointer) 0);

		button= XtVaCreateManagedWidget("Save As", 
				xmPushButtonWidgetClass, rc1, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1,
				NULL);
				
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) disk_SaveAsDialog, (XtPointer) 0);

		XtManageChild(rc1);

		XtManageChild(rc);


		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
		XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
		XtSetArg(args[n], XmNtopWidget, rc); n++;
		XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;


		rc = XmCreateRowColumn(form, "rowcol", args, n);

		label=XtVaCreateManagedWidget("add_label", xmLabelWidgetClass, rc,
				XmNlabelString, XmStringCreate ("Disk B image :",XmFONTLIST_DEFAULT_TAG),
				NULL);

		dbn=XtVaCreateManagedWidget("", xmTextWidgetClass, rc,
				XmNwidth,300,
				XmNeditable, False,
				NULL);

		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		rc1 = XmCreateRowColumn(rc, "rowcol", args, n);

		disk2ro=XtVaCreateManagedWidget("Read only",
				xmToggleButtonGadgetClass, rc1, 
				XmNhighlightThickness,0, 
				NULL);

		XtAddCallback(disk2ro, XmNvalueChangedCallback, (XtCallbackProc)disk_setReadOnly, (XtPointer) 1);

		button= XtVaCreateManagedWidget("Select", 
				xmPushButtonWidgetClass, rc1, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1,
				NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) disk2_create_selectFNdialog, NULL);

		button= XtVaCreateManagedWidget("Eject", 
				xmPushButtonWidgetClass, rc1, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1,
				NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) disk_Eject, (XtPointer) 1);

		button= XtVaCreateManagedWidget("Save As", 
				xmPushButtonWidgetClass, rc1, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1,
				NULL);

		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) disk_SaveAsDialog, (XtPointer) 1);

		XtManageChild(rc1);	
		XtManageChild(rc);


		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
		XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
		XtSetArg(args[n], XmNtopWidget, rc); n++;
		XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;


		rc = XmCreateRowColumn(form, "rowcol", args, n);

		label=XtVaCreateManagedWidget("add_label", xmLabelWidgetClass, rc,
				XmNlabelString, XmStringCreate ("Disk C image :",XmFONTLIST_DEFAULT_TAG),
				NULL);

		dcn=XtVaCreateManagedWidget("", xmTextWidgetClass, rc,
				XmNwidth,300,
				XmNeditable, False,
				NULL);

		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		rc1 = XmCreateRowColumn(rc, "rowcol", args, n);

		disk3ro=XtVaCreateManagedWidget("Read only",
				xmToggleButtonGadgetClass, rc1, 
				XmNhighlightThickness,0, 
				NULL);

		XtAddCallback(disk3ro, XmNvalueChangedCallback, (XtCallbackProc)disk_setReadOnly, (XtPointer) 2);

		button= XtVaCreateManagedWidget("Select", 
				xmPushButtonWidgetClass, rc1, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1,
				NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) disk3_create_selectFNdialog, NULL);

		button= XtVaCreateManagedWidget("Eject", 
				xmPushButtonWidgetClass, rc1, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1,
				NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) disk_Eject, (XtPointer) 2);

		button= XtVaCreateManagedWidget("Save As", 
				xmPushButtonWidgetClass, rc1, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1,
				NULL);

		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) disk_SaveAsDialog, (XtPointer) 2);

		XtManageChild(rc1);	
		XtManageChild(rc);



		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
		XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
		XtSetArg(args[n], XmNtopWidget, rc); n++;
		XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;


		rc = XmCreateRowColumn(form, "rowcol", args, n);

		label=XtVaCreateManagedWidget("add_label", xmLabelWidgetClass, rc,
				XmNlabelString, XmStringCreate ("Disk D image :",XmFONTLIST_DEFAULT_TAG),
				NULL);

		ddn=XtVaCreateManagedWidget("", xmTextWidgetClass, rc,
				XmNwidth,300,
				XmNeditable, False,
				NULL);

		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		rc1 = XmCreateRowColumn(rc, "rowcol", args, n);

		disk4ro=XtVaCreateManagedWidget("Read only",
				xmToggleButtonGadgetClass, rc1, 
				XmNhighlightThickness,0, 
				NULL);

		XtAddCallback(disk4ro, XmNvalueChangedCallback, (XtCallbackProc)disk_setReadOnly, (XtPointer) 3);

		button= XtVaCreateManagedWidget("Select", 
				xmPushButtonWidgetClass, rc1, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1,
				NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) disk4_create_selectFNdialog, NULL);

		button= XtVaCreateManagedWidget("Eject", 
				xmPushButtonWidgetClass, rc1, 
				XmNhighlightThickness, 1, 

				XmNshadowThickness, 1,
				NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) disk_Eject, (XtPointer) 3);

		button= XtVaCreateManagedWidget("Save As", 
				xmPushButtonWidgetClass, rc1, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1,
				NULL);
				
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) disk_SaveAsDialog, (XtPointer) 3);

		XtManageChild(rc1);		

		XmTextSetString(dan,discs[0].filename);
		XmTextSetString(dbn,discs[1].filename);
		XmTextSetString(dcn,discs[2].filename);
		XmTextSetString(ddn,discs[3].filename);

		XtManageChild(rc);

		button = XtVaCreateManagedWidget("  Close  ", xmPushButtonWidgetClass, form, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1,
				XmNtopWidget,rc,
				XmNtopAttachment,  XmATTACH_WIDGET,
				XmNrightAttachment,  XmATTACH_FORM,
				NULL);

		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) CloseDialog, NULL);
/*
		SelectDiskImage(0, discs[0].filename, 1);
		SelectDiskImage(1, discs[1].filename, 1);
		SelectDiskImage(2, discs[2].filename, 1);
		SelectDiskImage(3, discs[3].filename, 1);*/
	}

	if(!client_data)
	{
		XtManageChild(form);
		XtManageChild(pane);
		XtPopup(dialog, XtGrabNone);
		XRaiseWindow(display,XtWindow(dialog));
	}
}

void CloseDialog(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	XtPopdown(XtParent(XtParent(XtParent(w))));
}

void CloseDialog2pm(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	XtPopdown(XtParent(XtParent(XtParent(XtParent(XtParent(w))))));
}

void CloseDialog1pm(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	XtPopdown(XtParent(XtParent(XtParent(XtParent(w)))));
}

void cancel_selected_in_message_box(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	if (tounmanage!=NULL)
	{
		XtUnmanageChild(tounmanage);
		tounmanage=NULL;
	}

	if (tounmanage1!=NULL)
	{
		XtUnmanageChild(tounmanage1);
		tounmanage1=NULL;
	}

	XmProcessTraversal(drawing_a, XmTRAVERSE_CURRENT);
}

void saveIt(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	SaveZ80(filenameT);

	XtUnmanageChild(tounmanage);
	XmProcessTraversal(drawing_a, XmTRAVERSE_CURRENT);
}

void MessageBoxInfo(char * string)
{
	Widget dialog;

	tounmanage=NULL;

	n = 0;
	XtSetArg(args[n], XmNmessageString, XmStringCreate (string,XmFONTLIST_DEFAULT_TAG)); n++;

	dialog=XmCreateInformationDialog(first_window,"Information",args,n);
	XtAddCallback(dialog, XmNcancelCallback, (XtCallbackProc)cancel_selected_in_message_box, NULL);
	XtAddCallback(dialog, XmNokCallback, (XtCallbackProc)cancel_selected_in_message_box, NULL);

	XtUnmanageChild(
		XmMessageBoxGetChild(dialog, XmDIALOG_CANCEL_BUTTON));
	XtUnmanageChild(
		XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));

	XtManageChild(dialog);
}

void MessageBoxErr(char * string)
{
	Widget dialog;

	tounmanage=NULL;

	n = 0;
	XtSetArg(args[n], XmNmessageString, XmStringCreate (string,XmFONTLIST_DEFAULT_TAG)); n++;

	dialog=XmCreateErrorDialog(first_window,"Error",args,n);
	XtAddCallback(dialog, XmNcancelCallback, (XtCallbackProc)cancel_selected_in_message_box, NULL);

	XtAddCallback(dialog, XmNokCallback, (XtCallbackProc)cancel_selected_in_message_box, NULL);

	XtUnmanageChild(
		XmMessageBoxGetChild(dialog, XmDIALOG_CANCEL_BUTTON));
	XtUnmanageChild(
		XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));

	XtManageChild(dialog);
}

void MessageBoxEx(char * string)
{
	Widget dialog;

	n = 0;

	XtSetArg(args[n], XmNmessageString, XmStringCreate (string,XmFONTLIST_DEFAULT_TAG)); n++;
	XtSetArg(args[n], XmNokLabelString, XmStringCreate ("Retry",XmFONTLIST_DEFAULT_TAG)); n++;

	dialog=XmCreateMessageDialog(first_window,"Warning",args,n);
	XtAddCallback(dialog, XmNcancelCallback, (XtCallbackProc)cancel_selected_in_message_box, NULL);

	XtUnmanageChild(
		XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));


	XtManageChild(dialog);
}

void MessageBoxOkCan(XtCallbackProc okproc, XtPointer ok_cb_data, XtCallbackProc canproc, char * string)
{
	Widget dialog;

	n = 0;
	XtSetArg(args[n], XmNmessageString, XmStringCreate (string,XmFONTLIST_DEFAULT_TAG)); n++;
	XtSetArg(args[n], XmNokLabelString, XmStringCreate (" Yes ",XmFONTLIST_DEFAULT_TAG)); n++;
	XtSetArg(args[n], XmNcancelLabelString, XmStringCreate (" No ",XmFONTLIST_DEFAULT_TAG)); n++;
	/*XtSetArg(args[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;*/

	dialog=XmCreateQuestionDialog(first_window,"Question",args,n);

	if (okproc!=NULL)
		XtAddCallback(dialog, XmNokCallback, (XtCallbackProc)okproc, ok_cb_data);
	if (canproc!=NULL)
		XtAddCallback(dialog, XmNcancelCallback, (XtCallbackProc)canproc, NULL);

	XtUnmanageChild(
		XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));

	XtManageChild(dialog);
}


/* response() --The user made some sort of response to the
* question posed in AskUser().  Set the answer (client_data)
* accordingly and destroy the dialog.
*/
void response(Widget w, int *answer, XmAnyCallbackStruct *reason)
{
	switch (reason->reason) {
		case XmCR_OK:
		*answer = 1;
		break;
		case XmCR_CANCEL:
		*answer = 2;
		break;
		default:
		*answer = 0;
		return;
	}
}

/*popups modal dialog with two buttons and text. returns 1 or 2 (first or second button pressed)*/
int AskModal(Widget parent, char *question, char *first/*yes*/, char *second/*no*/)
{
	static Widget dialog;
	XmString text, yes, no;
	static int answer;
	extern void response();

	answer = 0;
	if (!dialog) {
	dialog = XmCreateQuestionDialog(parent, "dialog", NULL, 0);
	yes = XmStringCreateLocalized(first);
	no = XmStringCreateLocalized(second);
	XtVaSetValues(dialog,
	XmNdialogStyle,        XmDIALOG_APPLICATION_MODAL,
	XmNokLabelString,      yes,
	XmNcancelLabelString,  no,
	NULL);
		
	XtSetSensitive(
		XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON), False);
	XtAddCallback(dialog, XmNokCallback, response, &answer);
	XtAddCallback(dialog, XmNcancelCallback, response, &answer);
	/* if the user interacts via the system menu: */
	/* SEE CORRECTION ABOVE */
	XtAddCallback(dialog, XmNpopdownCallback, response, &answer);
	}
	
	text = XmStringCreateLocalized(question);
	XtVaSetValues(dialog, XmNmessageString, text, NULL);
	XmStringFree(text);
	XtManageChild(dialog);
	XtPopup(XtParent(dialog), XtGrabNone);

	/* while the user hasn't provided an answer, simulate XtMainLoop.
	* The answer changes as soon as the user selects one of the
	* buttons and the callback routine changes its value.  Don't
	* break loop until XtPending() also returns False to assure
	* widget destruction.
	*/
	while (answer == 0 || XtAppPending(app_context)) XtAppProcessEvent(app_context, XtIMAll);	
	return answer;
}

void MessageBoxOverwrite(XtCallbackProc o_func, void * client_data)
{
	Widget dialog;

	n = 0;
	XtSetArg(args[n], XmNmessageString, XmStringCreate ("Overwrite this file ?",XmFONTLIST_DEFAULT_TAG)); n++;

	XtSetArg(args[n], XmNokLabelString, XmStringCreate ("Choose another",XmFONTLIST_DEFAULT_TAG)); n++;
	XtSetArg(args[n], XmNcancelLabelString, XmStringCreate ("Overwrite",XmFONTLIST_DEFAULT_TAG)); n++;
	XtSetArg(args[n], XmNhelpLabelString, XmStringCreate ("Cancel",XmFONTLIST_DEFAULT_TAG)); n++;

	dialog=XmCreateQuestionDialog(first_window,"Warning",args,n);

	XtAddCallback(dialog, XmNhelpCallback, (XtCallbackProc)cancel_selected_in_message_box, NULL);
	XtAddCallback(dialog, XmNcancelCallback, (XtCallbackProc)o_func, (XtPointer)client_data);

	tounmanage1=dialog;
	XtManageChild(dialog);
}

void SaveZ80(char * path)
{
	int fil;	
	char message[400];
	int start;
	unsigned short b_len=65535;

	unsigned char buffer[200000]={0};

	fil=creat(path,00644);

	if (fil==-1)
	{
		sprintf(message,"Error creating %s", path);
		MessageBoxErr(message);
		return;
	}

	buffer[0]=A;
	buffer[1]=F;
	buffer[2]=C;
	buffer[3]=B;
	buffer[4]=L;

	buffer[5]=H;
	memset(&buffer[6],0,2);
	memcpy(&buffer[8],&SP,2);

	#if defined BIGENDIAN
	byteswp (&buffer[8]);
	#endif

	buffer[10]=I;

	buffer[13]=E;
	buffer[14]=D;
	buffer[15]=C1;
	buffer[16]=B1;
	buffer[17]=E1;
	buffer[18]=D1;
	buffer[19]=L1;
	buffer[20]=H1;
	buffer[21]=A1;
	buffer[22]=F1;

	memcpy(&buffer[25],&IX,2);
	memcpy(&buffer[23],&IY,2);


	#if defined BIGENDIAN
	byteswp (&buffer[23]);
	byteswp (&buffer[25]);
	#endif

	buffer[27]=interrupts;
	buffer[29]=IM;
	buffer[12]=border*2;

	buffer[30]=54;
	memcpy(&buffer[32], &PC, 2);

	#if defined BIGENDIAN
	byteswp (&buffer[32]);
	#endif

	buffer[38]=register_latch;
	memcpy(&buffer[39],Regs,15);

	start=86;

	if ((!strcasecmp(Mode,"128"))||(!strcasecmp(Mode,"Pentagon")))
	{	
		buffer[34]=4;
		buffer[35]=last7ffdout;

		memcpy(&buffer[start],&b_len,2);
		buffer[start+2]=3;
		memcpy(&buffer[start+3],RAM0,16384);
		start+=16387;

		memcpy(&buffer[start],&b_len,2);
		buffer[start+2]=4;
		memcpy(&buffer[start+3],RAM1,16384);
		start+=16387;

		memcpy(&buffer[start],&b_len,2);
		buffer[start+2]=5;
		memcpy(&buffer[start+3],RAM2,16384);
		start+=16387;

		memcpy(&buffer[start],&b_len,2);

		buffer[start+2]=6;
		memcpy(&buffer[start+3],RAM3,16384);
		start+=16387;


		memcpy(&buffer[start],&b_len,2);
		buffer[start+2]=7;

		memcpy(&buffer[start+3],RAM4,16384);
		start+=16387;

		memcpy(&buffer[start],&b_len,2);
		buffer[start+2]=8;
		memcpy(&buffer[start+3],RAM5,16384);
		start+=16387;

		memcpy(&buffer[start],&b_len,2);
		buffer[start+2]=9;
		memcpy(&buffer[start+3],RAM6,16384);
		start+=16387;

		memcpy(&buffer[start],&b_len,2);
		buffer[start+2]=10;
		memcpy(&buffer[start+3],RAM7,16384);
		start+=16387;
	}

	if (!strcasecmp(Mode,"48"))
	{	
		memcpy(&buffer[start],&b_len,2);
		buffer[start+2]=4;
		memcpy(&buffer[start+3],&CPU12[32768],16384);
		start+=16387;

		memcpy(&buffer[start],&b_len,2);
		buffer[start+2]=5;
		memcpy(&buffer[start+3],GiveAddrW1(49152),16384);
		start+=16387;

		memcpy(&buffer[start],&b_len,2);
		buffer[start+2]=8;
		memcpy(&buffer[start+3],&CPU12[16384],16384);
		start+=16387;
	}

	write(fil, buffer, start);
	close(fil);
}

int FileExists(char * arg)

{
	struct stat buf;

	if (stat(arg,&buf)==-1)
		return(0);
	else
		return(1);
}

void save_disk_as(Widget w,  int n, XmFileSelectionBoxCallbackStruct *cbs)
{
	char * filename;
	char *ext;
	enum DIMAGE_TYPE tp;
	
	XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &filename);
	
	if((ext=get_file_ext(filename))==NULL) return;
	tp=get_img_type(ext);
	if(tp==imgUnknown)
	{
		MessageBoxErr("Unknown file type! Use trd, fdi, udi or td0.");
		return;
	}
	
	if(!wd1793_save_dimage(filename,n,tp))
	{
		MessageBoxErr("Cannot save disk image!");
		return;
	}
	else
	{
		SelectDiskImage(n, filename, 1);
	}
	
	XtUnmanageChild(w);
	XmProcessTraversal(drawing_a, XmTRAVERSE_CURRENT);	
	
	blocking_popup_trig=1;
	return;
}

void save_file(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmFileSelectionBoxCallbackStruct *cbs;
{
	char * filename;
	char * directory;
	char extention[5]={0};

	XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &filename);
	XmStringGetLtoR(cbs->dir, XmSTRING_DEFAULT_CHARSET, &directory);

	sprintf(start_directory,directory);

	strncpy(extention,&filename[strlen(filename)-4],4);

	if (extention[3]=='/')
	{
		tounmanage=w;
		MessageBoxEx("Directory selected !");
		return;
	}

	if (strcasecmp(extention,".z80")==0)
		sprintf(filenameT,"%s",filename);
	else
		sprintf(filenameT,"%s.z80",filename);

	if (FileExists(filenameT))
	{
		tounmanage=w;
		MessageBoxOverwrite((XtCallbackProc)saveIt, NULL);
	}
	else
	{
		SaveZ80(filenameT);

		XtUnmanageChild(w);
		XmProcessTraversal(drawing_a, XmTRAVERSE_CURRENT);
	}
}


void save_sn_h(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	Widget dialog;

	dialog = XmCreateFileSelectionDialog(first_window, "Save snapshot", NULL, 0);

	XtVaSetValues(dialog,
		XmNdirectory,XmStringCreate (start_directory,XmFONTLIST_DEFAULT_TAG),
		NULL);

	XtAddCallback(dialog, XmNcancelCallback, (XtCallbackProc)cancel_open_file, NULL);
	XtAddCallback(dialog, XmNokCallback, (XtCallbackProc)save_file, NULL);

	XtManageChild(dialog);	
}

void SetIconOnButton(Pixmap icon, Widget button)
{
	if (button==0)
		return;

	n=0;
	XtSetArg(args[n], XmNbackgroundPixmap, icon); n++;
	XtSetValues(button, args, n); 
}

void emu_go_pause_h(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	emu_paused=1-emu_paused;

	if (emu_paused==on)
	{
		clear_timer();
	}
	else
	{
		init_timer();	
	}

	XmProcessTraversal(drawing_a, XmTRAVERSE_CURRENT);
}

void LoadDefaults(void)
{
	int i;
	
	sprintf(start_directory,".");
	sprintf(tape_directory,".");
	sprintf(disk_directory,".");
	sprintf(pok_directory,".");
	sprintf(Mode,"128");
	sprintf(trdos_appendboot,RESOURCE_PREFIX"/boot.$b");
	refresh_fr=50;
	sprintf(joystick_type,"kempston");
	
	for(i=0;i<4;++i) strcpy(discs[i].filename, "none");
	
	screen_size=1;
	ay_sound=on;
	beeper_volume=12;
	sprintf(audio_name,"/dev/dsp");
	sprintf(sound_device_nameR,"/dev/dsp");
	sprintf(quick_snapshot_name,"snap.z80");
	emulator_speed=100;
	sprintf(stereo_mode_string,"ACB");
	Sound_Freq=44100;
	sprintf(predefined_freqs,"35 37 40 70");
	kempston_mouse=on;
	leds_global=on;
	interpolyatsia=off;
	scan=off;
	tape_traps=on;
	z80_max_spd=0;
	tape_loading_method=0;
}

void PixmapsAllocAndFill(void)
{
	emu_go=(Pixmap)malloc(ICON_BUFFER_LEN);
	emu_pause=(Pixmap)malloc(ICON_BUFFER_LEN);
	p_48=(Pixmap)malloc(ICON_BUFFER_LEN);
	p_128=(Pixmap)malloc(ICON_BUFFER_LEN);


	XpmReadFileToPixmap(display, 
		DefaultRootWindow(display),
		ICONPATH"/play.xpm",
		&emu_go,&aaa,NULL);

	XpmReadFileToPixmap(display, 
		DefaultRootWindow(display),
		ICONPATH"/pause.xpm",
		&emu_pause,&aaa,NULL);

	XpmReadFileToPixmap(display, 
		DefaultRootWindow(display),
		ICONPATH"/48.xpm",
		&p_48,&aaa,NULL);

	XpmReadFileToPixmap(display, 
		DefaultRootWindow(display),
		ICONPATH"/128.xpm",
		&p_128,&aaa,NULL);
}

void SaveIniFile(void)
{
	char string[300];
	int fil;

	fil=creat(inifilepath,00400|00200);

	if (fil==-1)
	{
		printf("Error creating configuration file\n");
		return;
	}

	/*********** Zagolovok   ***********/
	sprintf(string,"%s\n\n",ini_file_version_string);
	write(fil,string,strlen(string));

	sprintf(string,"%s\n\n","; Do not modify first and last strings !\n; Parameters Disk1_FileName - Disk4_FileName, Tape_FileName, Quick_Snapshot_Name requires FULL path\n; You can use word 'none' if no file needed\n");
	write(fil,string,strlen(string));


	/************** Puti *********/
	sprintf(string,"#Paths\n");
	write(fil,string,strlen(string));

	sprintf(string,"Snapshots_path %s\n",start_directory);
	write(fil,string,strlen(string));

	sprintf(string,"Tapes_path %s\n",tape_directory);
	write(fil,string,strlen(string));

	sprintf(string,"Disks_path %s\n",disk_directory);
	write(fil,string,strlen(string));

	sprintf(string,"POKEs_path %s\n",pok_directory);
	write(fil,string,strlen(string));

	sprintf(string,"\n");
	write(fil,string,strlen(string));


	/**************** Faili ******************/
	sprintf(string,"#Files\n");
	write(fil,string,strlen(string));

	sprintf(string,"Quick_Snapshot_Name %s\n",quick_snapshot_name);
	write(fil,string,strlen(string));

	sprintf(string,"Disk1_FileName %s\n",discs[0].filename);
	write(fil,string,strlen(string));

	sprintf(string,"Disk2_FileName %s\n",discs[1].filename);
	write(fil,string,strlen(string));

	sprintf(string,"Disk3_FileName %s\n",discs[2].filename);
	write(fil,string,strlen(string));

	sprintf(string,"Disk4_FileName %s\n",discs[3].filename);
	write(fil,string,strlen(string));
	
	sprintf(string,"AppendBoot %s\n",trdos_appendboot);
	write(fil,string,strlen(string));	

	sprintf(string,"\n");
	write(fil,string,strlen(string));


	/********************* HW  ************************/
	sprintf(string,"#Hardware\n");
	write(fil,string,strlen(string));

	sprintf(string,"Mode %s //48, 128, Pentagon, Scorpion \n",Mode);
	write(fil,string,strlen(string));

	sprintf(string,"Joystick_Type %s // sinclair, kempston, cursor \n",joystick_type);
	write(fil,string,strlen(string));

	sprintf(string,"Kempston_Mouse %d // 1=on, 0=off \n",kempston_mouse);
	write(fil,string,strlen(string));

	sprintf(string,"\n");
	write(fil,string,strlen(string));


	/********************** Video  ****************************/
	sprintf(string,"#Screen\n");
	write(fil,string,strlen(string));

	sprintf(string,"Screen_Refresh_Rate %d // 50,25,16,8,0-XLib \n",refresh_fr);
	write(fil,string,strlen(string));

	sprintf(string,"Screen_Size %d // 1,2  \n",screen_size);
	write(fil,string,strlen(string));

	sprintf(string,"Filtering %d // 1=on, 0=off \n",interpolyatsia);
	write(fil,string,strlen(string));

	sprintf(string,"Scan %d // 1=on, 0=off \n",scan);
	write(fil,string,strlen(string));

	sprintf(string,"\n");
	write(fil,string,strlen(string));


	/************************ Sound  **************************/
	sprintf(string,"#Sound\n");
	write(fil,string,strlen(string));

	sprintf(string,"Sound %d // 1=on, 0=off \n",ay_sound);
	write(fil,string,strlen(string));

	sprintf(string,"Stereo_Mode %s // ACB, ABC, MONO \n", stereo_mode_string);
	write(fil,string,strlen(string));

	sprintf(string,"Sound_Freq  %d // 11025, 22050, 44100\n", Sound_Freq);
	write(fil,string,strlen(string));

	sprintf(string,"Beeper_Volume %d // 0-15 \n",beeper_volume);
	write(fil,string,strlen(string));

	sprintf(string,"Sound_Device %s\n",audio_name);
	write(fil,string,strlen(string));

	sprintf(string,"Sound_Device_RealTape_Rec %s\n",sound_device_nameR);
	write(fil,string,strlen(string));

	sprintf(string,"\n");
	write(fil,string,strlen(string));


	/********************* kucha *********************/
	sprintf(string,"#Emulation\n");
	write(fil,string,strlen(string));

	sprintf(string,"Emulator_Speed %d // Emulator Speed in persents \n",emulator_speed);
	write(fil,string,strlen(string));

	sprintf(string,"Tape_traps %d // 1=on, 0=off \n", tape_traps);
	write(fil,string,strlen(string));

	sprintf(string,"TapeLoadingMethod %d \n", tape_loading_method);
	write(fil,string,strlen(string));

	sprintf(string," ; 0 - Slow loading\n");
	write(fil,string,strlen(string));
	sprintf(string," ; 1 - Fast loading\n");
	write(fil,string,strlen(string));

	sprintf(string,"Z80_Max_Spd %d // Z80 Speed*10 for Fast loading, 0-audetect\n", z80_max_spd);
	write(fil,string,strlen(string));

	sprintf(string,"\n");
	write(fil,string,strlen(string));


	/******************* Interface *******************************/
	sprintf(string,"#Interface\n");
	write(fil,string,strlen(string));

	sprintf(string,"Leds %d // 1=on, 0=off \n",leds_global);
	write(fil,string,strlen(string));

	sprintf(string,"Predefined_Z80_Speeds %s\n",predefined_freqs);
	write(fil,string,strlen(string));


	sprintf(string,"\n");
	write(fil,string,strlen(string));


	/***************** End  *****************/
	sprintf(string,"\nEnd of .ugluk file\n");
	write(fil,string,strlen(string));

	close(fil);
}

int CheckIniFile(void)
{
	FILE * fil;
	char record[300];

	fil=(FILE *)fopen(inifilepath,"r");
	fgets(record,300,fil);
	fclose(fil);

	record[strlen(record)-1]=0;

	if (strcmp(record,ini_file_version_string)==0)
		return(no_errors);
	else	
		return(errors);
}

int NeedIgnore(char * arg)
{
	if ( (arg[0]=='#')||(arg[0]==';')||(arg[0]=='/')||(arg[0]=='.')||(arg[0]==' ')||(arg[0]=='\n') )
		return(1);

	if (strlen(arg)==0)
		return(1);

	return(0);
}

void ReadLine(char * parameter, FILE * fil)
{
	char value[300];

	int sp0;
	int sp1;

	while (TRUE)
	{
		sp0=fgetc(fil);
		sp1=fgetc(fil);

		if ((sp0==EOF)||(sp1==EOF))return;

		fseek(fil, -1, SEEK_CUR);
		

		if ((sp1!=' ')&&(sp1!='\t'))break;
	}		

	if (strcasecmp(parameter,"ugluk")==0)
	{
		fgets(value,300,fil);
		return;
	}

	if (strcasecmp(parameter,"Snapshots_path")==0)
	{
		fgets(value,300,fil);
		value[strlen(value)-1]=0;
		strcpy(start_directory,value);
		return;
	}

	if (strcasecmp(parameter,"Tapes_path")==0)
	{
		fgets(value,300,fil);
		value[strlen(value)-1]=0;
		strcpy(tape_directory,value);
		return;
	}

	if (strcasecmp(parameter,"Predefined_Z80_Speeds")==0)
	{
		fgets(value,300,fil);
		value[strlen(value)-1]=0;
		strcpy(predefined_freqs,value);
		return;
	}

	if (strcasecmp(parameter,"Sound_Device_RealTape_Rec")==0)
	{
		fgets(value,300,fil);
		value[strlen(value)-1]=0;
		strcpy(sound_device_nameR,value);
		return;
	}

	if (strcasecmp(parameter,"Disks_path")==0)
	{
		fgets(value,300,fil);
		value[strlen(value)-1]=0;
		strcpy(disk_directory,value);
		return;
	}

	if (strcasecmp(parameter,"POKEs_path")==0)
	{
		fgets(value,300,fil);
		value[strlen(value)-1]=0;
		strcpy(pok_directory,value);
		return;
	}

	if (strcasecmp(parameter,"Disk1_FileName")==0)
	{
		fgets(value,300,fil);
		value[strlen(value)-1]=0;
		
		if(!strcmp(discs[0].filename,"none"))
		{	
			strcpy(discs[0].filename,value);
			
			DBG_PR("using %s as disk #1",discs[0].filename);
		}

		return;
	}

	if (strcasecmp(parameter,"Disk2_FileName")==0)
	{
		fgets(value,300,fil);
		value[strlen(value)-1]=0;
		
		if(!strcmp(discs[1].filename,"none"))
		{	
			strcpy(discs[1].filename,value);
			
			DBG_PR("using %s as disk #2",discs[1].filename);
		}

		return;
	}

	if (strcasecmp(parameter,"Disk3_FileName")==0)
	{
		fgets(value,300,fil);
		value[strlen(value)-1]=0;
		
		if(!strcmp(discs[2].filename,"none"))
		{	
			strcpy(discs[2].filename,value);
			
			DBG_PR("using %s as disk #3",discs[2].filename);
		}

		return;
	}

	if (strcasecmp(parameter,"Disk4_FileName")==0)
	{
		fgets(value,300,fil);
		value[strlen(value)-1]=0;
		
		if(!strcmp(discs[3].filename,"none"))
		{	
			strcpy(discs[3].filename,value);
			
			DBG_PR("using %s as disk #4",discs[3].filename);
		}

		return;
	}
	
	if (strcasecmp(parameter,"AppendBoot")==0)
	{
		fgets(value,300,fil);
		value[strlen(value)-1]=0;
		strcpy(trdos_appendboot,value);
		wd1793_set_appendboot(trdos_appendboot);
		return;
	}

	if (strcasecmp(parameter,"Quick_Snapshot_Name")==0)
	{
		fgets(value,300,fil);
		value[strlen(value)-1]=0;
		strcpy(quick_snapshot_name,value);
		return;
	}

	if (strcasecmp(parameter,"Sound_Device")==0)
	{
		fgets(value,300,fil);
		value[strlen(value)-1]=0;
		strcpy(audio_name,value);

		return;
	}

	if (strcasecmp(parameter,"Screen_Refresh_Rate")==0)
	{
		fscanf(fil,"%d",&refresh_fr);
		return;
	}

	if (strcasecmp(parameter,"Kempston_Mouse")==0)
	{
		fscanf(fil,"%d",&kempston_mouse);
		return;
	}

	if (strcasecmp(parameter,"TapeLoadingMethod")==0)
	{
		fscanf(fil,"%d",&tape_loading_method);
		return;
	}

	if (strcasecmp(parameter,"Z80_Max_Spd")==0)
	{
		fscanf(fil,"%d",&z80_max_spd);
		return;
	}

	if (strcasecmp(parameter,"Tape_traps")==0)
	{
		fscanf(fil,"%d",&tape_traps);
		return;
	}

	if (strcasecmp(parameter,"Leds")==0)
	{
		fscanf(fil,"%d",&leds_global);
		return;
	}

	if (strcasecmp(parameter,"Filtering")==0)
	{
		fscanf(fil,"%d",&interpolyatsia);
		return;
	}

	if (strcasecmp(parameter,"Scan")==0)
	{
		fscanf(fil,"%d",&scan);
		return;
	}

	if (strcasecmp(parameter,"Beeper_Volume")==0)
	{
		fscanf(fil,"%d",&beeper_volume);
		return;
	}

	if (strcasecmp(parameter,"Emulator_Speed")==0)
	{
		fscanf(fil,"%d",&emulator_speed);
		return;
	}

	if (strcasecmp(parameter,"Screen_Size")==0)
	{
		fscanf(fil,"%d",&screen_size);
		return;
	}

	if (strcasecmp(parameter,"Sound")==0)
	{
		fscanf(fil,"%d",&ay_sound);
		return;
	}

	if (strcasecmp(parameter,"Stereo_Mode")==0)
	{
		fscanf(fil,"%s",stereo_mode_string);
		fgets(value,300,fil);
		return;
	}

	if (strcasecmp(parameter,"Joystick_Type")==0)
	{
		fscanf(fil,"%s",joystick_type);
		fgets(value,300,fil);
		return;
	}

	if (strcasecmp(parameter,"Mode")==0)
	{
		fscanf(fil,"%s",Mode);
		fgets(value,300,fil);
		return;
	}

	if (strcasecmp(parameter,"Sound_Freq")==0)
	{
		fscanf(fil,"%d",&Sound_Freq);
		return;
	}

	if (strcmp(parameter,"End")==0)
	{
		fgets(value,300,fil);	
		return;
	}


	fgets(value,300,fil);
	printf("Unknown parameter %s in configuration file. Ignoring it.\n",parameter);
}

void ReadSettingsFromConfiguratonFile(void)
{
	FILE * fil;
	char record[300];
	
	DBG_PR("parsing configuration file...");

	fil=(FILE *)fopen(inifilepath,"r");

LB:
	if (feof(fil)!=0)goto LE;

	fscanf(fil, "%s", record);

	if (NeedIgnore(record)==1)
	{
		fgets(record,300,fil);
		goto LB;
	}

	ReadLine(record,fil);
	goto LB;

LE :
	fclose(fil);
}


void LookForIniFileEx (void)
{
	struct passwd * userinfo;
	FILE * fil;

	userinfo=getpwuid(getuid());
	

	sprintf(inifilepath,"%s",userinfo->pw_dir);
	strcat(inifilepath,"/.ugluk");

	fil=(FILE *)fopen(inifilepath,"r");

	if (fil!=NULL)
	{
		fclose(fil);

		if (CheckIniFile()==errors)
		{
			printf("Emulator's configuration file is old or invalid. Emulator will now try to convert it.\nIf this fails, delete emulator's configuration file and restart the emulator.\n");
			ReadSettingsFromConfiguratonFile();
			SaveIniFile();
		}
		else
			ReadSettingsFromConfiguratonFile();
	}
	else
	{
		printf("No configuration file. So creating it.\n");
		SaveIniFile();
	}
}

int SoundcardInit(int NONBLK)
{
#define BASE_SOUND_FRAG_PWR	6

	int tmp;

	int samplesize = 16;
	int dsp_speed = Sound_Freq; 
	int dsp_stereo = 1;

	int frag;


	audio = open (audio_name, O_WRONLY|O_NONBLOCK, 0);                                                       

	if (audio == -1)                                                                                
	{                                                                                             
		printf("Unable open %s for writing. SoundcardInit failed.\n",audio_name);
		perror (audio_name);
		return(errors);
	}  

	if (!NONBLK)
	{
		close(audio);

		audio = open (audio_name, O_WRONLY/*|O_NONBLOCK*/, 0);                                                       

		if (audio == -1)                                                                                
		{                                                                                             
			printf("Unable open %s for writing. SoundcardInit failed.\n",audio_name);
			perror (audio_name);
			return(errors);
		}  
	}

#if defined LINUXAUDIO
	tmp=AFMT_S16_LE;
	if((ioctl(audio,SNDCTL_DSP_SETFMT,&tmp))==-1)
	{
		perror("SNDCTL_DSP_SETFMT");
		close(audio);

		return(errors);
	}

	tmp = samplesize;                                                                               
	ioctl(audio, SNDCTL_DSP_SAMPLESIZE, &samplesize);                                               
	if (tmp != samplesize)                                                                          
	{                                                                                               
		printf("Unable set samplesize = %d. SoundcardInit failed.\n", tmp);
		perror("SNDCTL_DSP_SAMPLESIZE");                                                                    
		close(audio);
		return(errors);                                                                                  
	}                                                                                               

	if (ioctl (audio, SNDCTL_DSP_STEREO, &dsp_stereo)==-1)                                          
	{                                                                                               
		printf ("Unable to set stereo. SoundcardInit failed.\n");                               
		perror (audio_name);                                                                        
		close(audio);
		return(errors);                                                                                      
	}                                                                                               

	if (ioctl (audio, SNDCTL_DSP_SPEED, &dsp_speed) == -1)                                          
	{                                                                                             
		printf ("Unable to set audio speed = %d. SoundcardInit failed.\n",dsp_speed);                               
		perror (audio_name);                                                                        
		close(audio);
		return(errors);                                                                                  
	}        


	frag=(0x80000|BASE_SOUND_FRAG_PWR);

	if(dsp_speed>8000) frag++;
	if(dsp_speed>16000) frag++;
	if(dsp_speed>32000) frag++;
	if(samplesize>8) frag++;
	if(dsp_stereo>0) frag++;

	if(ioctl(audio,SNDCTL_DSP_SETFRAGMENT,&frag)<0)
	{
		perror ("SNDCTL_DSP_SETFRAGMENT");
		close(audio);
		return(errors);
	}

	return(no_errors);

#endif
}

# if defined LINUXAUDIO

# include <linux/unistd.h>
int CreateThread(int (*fn)(void *), void *data)
{
/*
	   Linux Threads Frequently Asked Questions (FAQ)

           by Sean Walton, KB7rfa
              walton@oclc.org
           (Last revised 21 Jan 1997)
   */	

	long retval;
	void **newstack;


	     /*
         * allocate new stack for subthread
         */
	newstack = (void **) malloc(THREAD_STACKSIZE);
	if (!newstack)
		return -1;

        /*
         * Set up the stack for child function, put the (void *)
         * argument on the stack.
         */
	newstack = (void **) (THREAD_STACKSIZE + (char *) newstack);
	*--newstack = data;

        /*
         * Do clone() system call. We need to do the low-level stuff
         * entirely in assembly as we're returning with a different
         * stack in the child process and we couldn't otherwise guarantee
         * that the program doesn't use the old stack incorrectly.
         *
         * Parameters to clone() system call:
         *      %eax - __NR_clone, clone system call number
         *      %ebx - clone_flags, bitmap of cloned data

         *      %ecx - new stack pointer for cloned child
         *        *
         * In this example %ebx is CLONE_VM | CLONE_FS | CLONE_FILES |
         * CLONE_SIGHAND which shares as much as possible between parent
         * and child. (We or in the signal to be sent on child termination
         * into clone_flags: SIGCHLD makes the cloned process work like
         * a "normal" unix child process)
         *
         * The clone() system call returns (in %eax) the pid of the newly
         * cloned process to the parent, and 0 to the cloned process. If
         * an error occurs, the return value will be the negative errno.
         *
         * In the child process, we will do a "jsr" to the requested function
         * and then do a "exit()" system call which will terminate the child.
         */

	__asm__ __volatile__(
		"int $0x80\n\t"         /* Linux/i386 system call */
		"testl %0,%0\n\t"       /* check return value */
		"jne 1f\n\t"            /* jump if parent */
		"call *%3\n\t"          /* start subthread function */
		"movl %2,%0\n\t"

		"int $0x80\n"           /* exit system call: exit subthread */
		"1:\t"
		:"=a" (retval)
		:"0" (__NR_clone),"i" (__NR_exit),
		"r" (fn),
		"b" (0x00000100 | 0x00000200 | 0x00000400 /*| CLONE_SIGHAND | SIGCHLD*/),
		"c" (newstack));

	if (retval < 0) {
	/*	errno = -retval; RH 9 !! */
		retval = -1;
	}
	return retval;
}
#endif

# if !defined LINUXAUDIO
int CreateThread(int (*fn)(void *), void *data)
{
	return -1;
}
#endif

void Set_z80times_per_line(unsigned int arg)
{
	NajatKnopku(two_Scorpion, False);
	NajatKnopku(two_Pentagon, False);
	NajatKnopku(two_128, False);
	NajatKnopku(two_48, False);


	if (strcasecmp(Mode,"128")==0)
	{
		NT_T_UP=(39*228)*arg/35;
		NT_T_LP=(8)*arg/35;
		NT_T_RP=(60)*arg/35;
		NT_T_DP=(32*228)*arg/35;
		NT_T_INT_LEN=70908*arg/35;

		NajatKnopku(two_128, True);
	}

	if (strcasecmp(Mode,"48")==0)
	{
		NT_T_UP=(40*224)*arg/35;
		NT_T_LP=(8)*arg/35;
		NT_T_RP=(56)*arg/35;
		NT_T_DP=(32*224)*arg/35;
		NT_T_INT_LEN=69888*arg/35;

		NajatKnopku(two_48, True);
	}

	if (strcasecmp(Mode,"Pentagon")==0)
	{
		NT_T_UP=((16+40)*224)*arg/35;
		NT_T_LP=(32+20)*arg/35;
		NT_T_RP=(12)*arg/35;
		NT_T_DP=(24*224)*arg/35;
		NT_T_INT_LEN=71680*arg/35;

		NajatKnopku(two_Pentagon, True);
	}

	if (strcasecmp(Mode,"Scorpion")==0)
	{
		NT_T_UP=(40*224)*arg/35;
		NT_T_LP=(40+8)*arg/35;
		NT_T_RP=(16)*arg/35;
		NT_T_DP=(32*224)*arg/35;
		NT_T_INT_LEN=69888*arg/35;

		NajatKnopku(two_Scorpion, True);
	}

	z80_spd_new=arg;	
}

void CalculateMaxZ80Spd(char * arg)
{
	int fil;
	char bogomips[20]={0};
	int readed;
	double bm;


	fil=open(arg ,O_RDONLY);
	if (fil==-1) 
	{
		printf("CalculateMaxZ80Spd : cant't open %s for reading.\n", arg);
		z80_speed_calculated=0; 
		return;
	}

	while (TRUE)
	{
		readed=read(fil, bogomips, 8);

		if (readed!=8)
		{
			printf("CalculateMaxZ80Spd : 'bogomips' is not found.\n");
			z80_speed_calculated=0; 
			return;
		}

		if (!strcasecmp(bogomips,"bogomips"))
			break;

		lseek(fil, -7, SEEK_CUR);
	}

	while (TRUE)
	{
		readed=read(fil, bogomips, 1);

		if (readed!=1)
		{
			printf("CalculateMaxZ80Spd : ':' is not found.\n");
			z80_speed_calculated=0; 
			return;
		}

		if (bogomips[0]==':')
			break;
	}

	read(fil, bogomips, sizeof(bogomips));
	bm=atof(bogomips);

	z80_speed_calculated=(unsigned int)(bm/4.0);

	close(fil);
}

int ApplyParameters()
{
	Set_z80times_per_line(35);

	if ((refresh_fr!=50)&&(refresh_fr!=25)&&(refresh_fr!=16)&&(refresh_fr!=8)&&(refresh_fr!=0))
	{
		printf("Invalid value of parameter ScreenRefreshRate=%d. Setting it to 50.\n",refresh_fr);
		refresh_fr=50;
	}

	if (refresh_fr==0)
		XLib=on;
	else
	{
		not_draw_start=50/refresh_fr;
		not_draw=not_draw_start;
		XLib=off;
	}

	if ( (strcasecmp(joystick_type,"kempston")==0) || (strcasecmp(joystick_type,"sinclair")==0) || (strcasecmp(joystick_type,"cursor")==0) )
	{
		if (strcasecmp(joystick_type,"kempston")==0) joy_type=0;
		if (strcasecmp(joystick_type,"sinclair")==0) joy_type=1;
		if (strcasecmp(joystick_type,"cursor")==0) joy_type=2;
	}
	else
	{
		printf("Unknown joystick type %s ! Setting joystick type to kempston.\n",joystick_type);
		joy_type=0;
	}

	if ((screen_size!=1)&&(screen_size!=2))
	{
		printf("Invalid parameter Screen_Size %d ! Setting it to 1.\n",screen_size);

		screen_size=1;
	}

	if (ay_sound==on)
	{
		if (SoundcardInit(direct_recording)!=errors)
		{
			sound=on;
			UpdateStep = ((double)STEP * 44100 * 8) / 1773400 * 2;
		}
		else
		{
			printf("Sound initialization failed. If you wannt see this message, set 'Sound 0' in configuration file.\n");
			sound=off;
		}
	}
	else
		sound=off;

	if ( (strcasecmp(stereo_mode_string,"ACB")!=0) && (strcasecmp(stereo_mode_string,"ABC")!=0) && (strcasecmp(stereo_mode_string,"MONO")!=0) )
	{
		printf("Invalid value of parameter Stereo_Mode = %s. Setting it to ACB.\n", stereo_mode_string);
		stereo_mode=0;
	}
	else
	{
		if (strcasecmp(stereo_mode_string,"ACB")==0)	
			stereo_mode=0;

		if (strcasecmp(stereo_mode_string,"ABC")==0)	
			stereo_mode=1;

		if (strcasecmp(stereo_mode_string,"MONO")==0)	
			stereo_mode=2;
	}

	if ((emulator_speed<=0)||(emulator_speed>200))
	{
		printf("Wrong value = %d of parameter Emulator_Speed. Setting it to 100.\n", emulator_speed);
		emulator_speed=100;
	}

	timeout=TIMER_CONST*100/emulator_speed;	
	SetSOUND_TICKS_PER_FRAME();

	if (beeper_volume>15)
	{
		printf("Invalid value of Beeper_Volume=%d. Setting it to 12.\n",beeper_volume);
		beeper_volume=12;
	}

	SelectDiskImage(0,discs[0].filename,0);
	SelectDiskImage(1,discs[1].filename,0);
	SelectDiskImage(2,discs[2].filename,0);
	SelectDiskImage(3,discs[3].filename,0);

	if ((strcasecmp(Mode,"128")!=0)&&(strcasecmp(Mode,"48")!=0)&&(strcasecmp(Mode,"Pentagon")!=0)&&(strcasecmp(Mode,"Scorpion")!=0))
	{
		printf("Invalid value of Mode=%s. Setting it to '128'.\n",Mode);
		sprintf(Mode,"128");
	}

	if ((Sound_Freq!=44100)&&(Sound_Freq!=22050)&&(Sound_Freq!=11025))
	{		
		printf("Invalid value of Sound_Freq=%d. Setting it to 44100. Valid values are : 11025,22050,44100.\n",Sound_Freq);
		Sound_Freq=44100;
	}

	if (tape_loading_method>1)
	{		
		printf("Invalid value of TapeLoadingMethod=%d. Setting it to 0. Valid values are : 0,1.\n", tape_loading_method);
		tape_loading_method=0;
	}

	if (!z80_max_spd)
		CalculateMaxZ80Spd("/proc/cpuinfo");
	else
		z80_speed_calculated=0;	

	z80_speed_saved=z80_spd_new;


	/*** v kontse nado ! */
	return(Spectrum_Init());
}

void Exiting1(void)
{
	Exiting(NULL);
}

void Exiting(void * p2)
{
	printf("Exiting...\n");
	
	XAutoRepeatOn(display);

	TrashXWindow();

	if (tape_sc_ROM_pid) kill(tape_sc_ROM_pid, 9);
	if (DirectPid) kill(DirectPid, 9);

	if (sound_fil!=-1)
		close(sound_fil);
}

void IncrementTrainersPositionValues(void)
{
	trainer_struct * t;


	t=trainers;

	if (t==NULL)
	{
		printf("IncrementTrainersPositionValues : trainers==NULL. This is bug. Report it.\n");
		return;
	}

	while (TRUE)
	{
		t->position++;

		t=t->next;

		if (t==NULL) break;
	}
}

void AddTrainer(char * name)
{
	XmString str;
	trainer_struct * new_trainer;


	str = XmStringCreateSimple(name);

	XmListAddItemUnselected(tdes, str, 1);
	XmStringFree(str);


	new_trainer=malloc(sizeof(trainer_struct));
	strcpy(new_trainer->name,name);
	new_trainer->POKEs=NULL;
	new_trainer->position=0;
	new_trainer->next=trainers;

	trainers=new_trainer;

	IncrementTrainersPositionValues();
}

void p_add_trainer_edt(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;

{

	int * selected[20];
	int num;

	char * newname;

	XmString xms;


	XmListGetSelectedPos(tdes,selected,&num);

	if (num!=1)
	{
		MessageBoxErr("No trainer(s) selected. Please select trainer for editing.");
		return;
	}

	if (strlen(XmTextGetString(new_trainer_name_edt))==0)
		newname="Untitled";
	else
		newname=XmTextGetString(new_trainer_name_edt);


	strcpy(FindTrainer(*selected[0])->name,newname);

	xms=XmStringCreateSimple(newname);
	XmListReplaceItemsPos(tdes,&xms,1,*selected[0]);

	CloseDialog(w, NULL, NULL);
}


void p_add_trainer(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;

{
	if (strlen(XmTextGetString(new_trainer_name))==0)
		AddTrainer("Untitled");
	else
		AddTrainer(XmTextGetString(new_trainer_name));

	CloseDialog(w, NULL, NULL);
}

void p_new_trainer(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	static Widget dialog;
	static Widget pane;
	static Widget form; 

	Widget label1, button, separator;


	if (!dialog)
	{
		dialog = XtVaCreatePopupShell("Pokes",
				xmDialogShellWidgetClass, first_window,
				XmNtitle,  "Add trainer",
				NULL);

		pane = XtVaCreateWidget("pane", xmPanedWindowWidgetClass, dialog,
				XmNsashWidth,  1, /* try to "hide" resizing sash.  PanedWindow */
				XmNsashHeight, 1, /* won't let us set to 0, so 1 will have to do */
				NULL);

		form = XtVaCreateWidget("form", xmFormWidgetClass, pane, NULL);

		label1=XtVaCreateManagedWidget("Trainer description :", xmLabelWidgetClass, form,
				XmNlabelString, XmStringCreate ("Trainer description : ",XmFONTLIST_DEFAULT_TAG) ,
				NULL);

		new_trainer_name=XtVaCreateManagedWidget("", 
				xmTextWidgetClass, form,
				XmNwidth, 200,
				XmNtopWidget, label1,
				XmNtopAttachment,  XmATTACH_WIDGET,
				XmNmaxLength,30,
				NULL);


		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		XtSetArg(args[n], XmNtopWidget,  new_trainer_name); n++;
		XtSetArg(args[n], XmNtopAttachment,  XmATTACH_WIDGET); n++;
		XtSetArg(args[n], XmNleftAttachment,  XmATTACH_FORM); n++;
		XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
		XtSetArg(args[n], XmNheight,6);n++;

		separator=XmCreateSeparator(form, "", args, n);
		XtManageChild(separator);

		button = XtVaCreateManagedWidget("Add trainer", 
				xmPushButtonWidgetClass, form, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1, 
				XmNtopWidget, separator,
				XmNtopAttachment,  XmATTACH_WIDGET,
				NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) p_add_trainer, NULL);

		button = XtVaCreateManagedWidget("Cancel", 
				xmPushButtonWidgetClass, form, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1, 
				XmNleftWidget, button,
				XmNrightAttachment,  XmATTACH_FORM,

				XmNtopWidget, separator,

				XmNtopAttachment,  XmATTACH_WIDGET,
				NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) CloseDialog, NULL);
	}

	XtManageChild(form);
	XtManageChild(pane);
	XtPopup(dialog, XtGrabNone);
	XRaiseWindow(display,XtWindow(dialog));
}

void p_new_trainer_edt(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	static Widget dialog;
	static Widget pane;
	static Widget form; 

	Widget label1, button, separator;

	int * selected[20];
	int num;


	XmListGetSelectedPos(tdes,selected,&num);

	if (num!=1)
	{
		MessageBoxErr("No trainer(s) selected. Please select trainer for editing.");
		return;
	}

	

	if (!dialog)
	{
		dialog = XtVaCreatePopupShell("Pokes",
				xmDialogShellWidgetClass, first_window,
				XmNtitle,  "Edit trainer",
				NULL);

		pane = XtVaCreateWidget("pane", xmPanedWindowWidgetClass, dialog,
				XmNsashWidth,  1, /* try to "hide" resizing sash.  PanedWindow */
				XmNsashHeight, 1, /* won't let us set to 0, so 1 will have to do */
				NULL);

		form = XtVaCreateWidget("form", xmFormWidgetClass, pane, NULL);

		label1=XtVaCreateManagedWidget("Trainer description :", xmLabelWidgetClass, form,
				XmNlabelString, XmStringCreate ("Trainer description : ",XmFONTLIST_DEFAULT_TAG) ,
				NULL);

		new_trainer_name_edt=XtVaCreateManagedWidget("", 
				xmTextWidgetClass, form,
				XmNwidth, 200,
				XmNtopWidget, label1,
				XmNtopAttachment,  XmATTACH_WIDGET,
				XmNmaxLength,30,
				NULL);


		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		XtSetArg(args[n], XmNtopWidget,  new_trainer_name_edt); n++;
		XtSetArg(args[n], XmNtopAttachment,  XmATTACH_WIDGET); n++;
		XtSetArg(args[n], XmNleftAttachment,  XmATTACH_FORM); n++;
		XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
		XtSetArg(args[n], XmNheight,6);n++;

		separator=XmCreateSeparator(form, "", args, n);
		XtManageChild(separator);

		button = XtVaCreateManagedWidget("  OK  ", 
				xmPushButtonWidgetClass, form, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1, 
				XmNtopWidget, separator,
				XmNtopAttachment,  XmATTACH_WIDGET,
				NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) p_add_trainer_edt, NULL);

		button = XtVaCreateManagedWidget("Cancel", 
				xmPushButtonWidgetClass, form, 
				XmNhighlightThickness, 1, 

				XmNshadowThickness, 1, 
				XmNleftWidget, button,
				XmNrightAttachment,  XmATTACH_FORM,
				XmNtopWidget, separator,
				XmNtopAttachment,  XmATTACH_WIDGET,
				NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) CloseDialog, NULL);
	}

	XtManageChild(form);
	XtManageChild(pane);
	XtPopup(dialog, XtGrabNone);
	XRaiseWindow(display,XtWindow(dialog));

	XmTextSetString(new_trainer_name_edt,FindTrainer(*selected[0])->name);
}

char * CheckBankAddrValueOld(int bank, int addr, int value, int old)
{
	if (bank<0)
		return("Invalid value of memory bank. Must be 0-8.");

	if ((addr<16384)||(addr>65535))
		return("Invalid value of address. Must be 16384-65535.");

	if ((value<0)||(value>256))
		return("Invalid poke value. Must be 0-256.");

	if ((old<0)||(old>255))
		return("Invalid poke original value. Must be 0-255.");

	switch (bank)
	{
		case 0:
		case 1:
		case 3:
		case 4:
		case 6:
		case 7:
			if (addr<49152)
				return("Improper using of memory bank and address. While bank==0,1,3,4,6,7 address must be >= 49152.");
			break;

		case 2:
			if (addr<32768)
				return("Improper using of memory bank and address. While bank==2 address must be >= 32768.");
			break;

		case 5:
			if ((addr>=32768)&&(addr<49152))
				return("Improper using of memory bank and address. While bank==5 address must be < 32768 or >= 49152.");
	}

	return(NULL);
}

void IncrementPOKEsPositionValues(POKE_type * first)
{
	POKE_type * p;

	p=first;

	if (p==NULL)
	{
		printf("NULL pointer passed to IncrementPOKEsPositionValues. This is bug. Report it.\n");
		return;
	}

	while (TRUE)
	{
		p->position++;


		p=p->next;

		if (p==NULL) break;
	}
}

void AddPOKE(trainer_struct * trainer, int bank, int addr, int value, int old, int add)
{
	char string[255];
	XmString str;

	POKE_type * new_poke;



	sprintf(string,"%2d %5d %3d %3d", bank&0xf, addr, value, old);

	if (add)
	{
		str = XmStringCreateSimple(string);
		XmListAddItemUnselected(tdet, str, 1);
		XmStringFree(str);
	}	

	new_poke=malloc(sizeof(POKE_type));

	new_poke->bank=bank;
	new_poke->addr=addr;
	new_poke->value=value;
	new_poke->old=old;
	new_poke->position=0;
	new_poke->next=trainer->POKEs;

	trainer->POKEs=new_poke;

	IncrementPOKEsPositionValues(trainer->POKEs);
}

POKE_type * FindPoke(POKE_type * start, int num)
{
	POKE_type * p;


	p=start;

	while (TRUE)
	{
		if (p==NULL)
		{
			printf("FindPoke failed. This is bug. Report it.\n");
			return(NULL);
		}

		if (p->position==num)
			return(p);

		p=p->next;
	}	
}

trainer_struct * FindTrainer(int num)
{
	trainer_struct * t;


	t=trainers;

	while (TRUE)
	{
		if (t==NULL)
		{
			printf("FindTrainer failed. This is bug. Report it.\n");
			return(NULL);
		}

		if (t->position==num)
			return(t);

		t=t->next;
	}
}

void p_get(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	int bank, addr;
	unsigned char old;
	char st[10];


	bank=strtol(XmTextGetString(p_bank),NULL,0);
	addr=strtol(XmTextGetString(p_addr),NULL,0);

	if (CheckBankAddrValueOld(bank, addr, 0, 0)!=NULL)
	{
		MessageBoxErr(CheckBankAddrValueOld(bank, addr, 0, 0));
		return;
	}

	switch (bank)
	{
		case 0:
			old=RAM0[addr-49152];
			break;
		case 1:
			old=RAM1[addr-49152];
			break;
		case 3:
			old=RAM3[addr-49152];

			break;
		case 4:
			old=RAM4[addr-49152];
			break;
		case 6:
			old=RAM6[addr-49152];
			break;
		case 7:
			old=RAM7[addr-49152];
			break;

		case 2:
			if (addr<49152)
				old=CPU12[addr];
			else 
				old=CPU12[addr-16384];
			break;

		case 5:
			if (addr<49152)
				old=CPU12[addr];
			else 
				old=CPU12[addr-32768];
			break;

		default:
			old=ReadByte(addr);
	}

	sprintf(st,"%d",old);
	XmTextSetString(p_old,st);
}	

void p_add_poke(w, client_data, cbs)

	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	int * selected[20];
	int num;

	int bank, addr, value, old;


	bank=strtol(XmTextGetString(p_bank),NULL,0);
	addr=strtol(XmTextGetString(p_addr),NULL,0);
	value=strtol(XmTextGetString(p_value),NULL,0);
	old=strtol(XmTextGetString(p_old),NULL,0);

	if (CheckBankAddrValueOld(bank, addr, value, old)!=NULL)
	{
		MessageBoxErr(CheckBankAddrValueOld(bank, addr, value, old));
		return;
	}

	XmListGetSelectedPos(tdes,(int **)selected,&num);

	if (num!=1)
	{
		MessageBoxErr("Can't add POKE. Please select trainer for POKE.");
		return;
	}

	AddPOKE(FindTrainer (*selected[0]), bank, addr, value, old, 1);

	CloseDialog(w, NULL, NULL);
}

void p_add_poke_apply(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{

	int * selected[20];
	int num;

	int bank, addr, value, old;


	bank=strtol(XmTextGetString(p_bank),NULL,0);
	addr=strtol(XmTextGetString(p_addr),NULL,0);
	value=strtol(XmTextGetString(p_value),NULL,0);
	old=strtol(XmTextGetString(p_old),NULL,0);

	if (CheckBankAddrValueOld(bank, addr, value, old)!=NULL)
	{
		MessageBoxErr(CheckBankAddrValueOld(bank, addr, value, old));
		return;
	}

	XmListGetSelectedPos(tdes,(int **)selected,&num);

	if (num!=1)
	{
		MessageBoxErr("Can't apply POKE. Please select trainer for POKE.");
		return;
	}

	AddPOKE(FindTrainer (*selected[0]), bank, addr, value, old, 1);
	ApplyPoke(FindTrainer (*selected[0])->POKEs, FindTrainer (*selected[0])->name);

	CloseDialog(w, NULL, NULL);
}

void p_new_poke(w, client_data, cbs)
	Widget w;
	XtPointer client_data;

	XmPushButtonCallbackStruct *cbs;
{
	int * selected[20];
	int num;

	static Widget dialog;
	static Widget pane;
	static Widget form; 

	Widget label1,rc, button;


	XmListGetSelectedPos(tdes,selected,&num);

	if (num!=1)
	{
		MessageBoxErr("Can't add POKE. Please select trainer for POKE.");
		return;
	}

	if (!dialog)
	{
		dialog = XtVaCreatePopupShell("Pokes",
				xmDialogShellWidgetClass, first_window,
				XmNtitle,  "Adding POKE",
				NULL);

		pane = XtVaCreateWidget("pane", xmPanedWindowWidgetClass, dialog,
				XmNsashWidth,  1, /* try to "hide" resizing sash.  PanedWindow */
				XmNsashHeight, 1, /* won't let us set to 0, so 1 will have to do */
				NULL);

		form = XtVaCreateWidget("form", xmFormWidgetClass, pane, NULL);

		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		XtSetArg(args[n], XmNrightAttachment,  XmATTACH_FORM); n++;



		rc = XmCreateRowColumn(form, "rowcol", args, n);

		XtManageChild(rc);

		label1=XtVaCreateManagedWidget("Memory bank (8 - ignore bank) :", xmLabelWidgetClass, rc,
				XmNlabelString, XmStringCreate ("Memory bank (8 - ignore bank) :",XmFONTLIST_DEFAULT_TAG),
				NULL);

		p_bank=XtVaCreateManagedWidget("", 
				xmTextWidgetClass, rc,
				XmNmaxLength,3,
				XmNwidth, 35,
				NULL);

		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		XtSetArg(args[n], XmNtopWidget, rc); n++;
		XtSetArg(args[n], XmNtopAttachment,  XmATTACH_WIDGET); n++;
		XtSetArg(args[n], XmNrightAttachment,  XmATTACH_FORM); n++;
		


		rc = XmCreateRowColumn(form, "rowcol", args, n);
		XtManageChild(rc);

		label1=XtVaCreateManagedWidget("Address (16384-65535) :", xmLabelWidgetClass, rc,
				XmNlabelString, XmStringCreate ("Address (16384-65535) :",XmFONTLIST_DEFAULT_TAG),

				NULL);

		p_addr=XtVaCreateManagedWidget("", 
				xmTextWidgetClass, rc,
				XmNwidth, 60,
				XmNmaxLength,7,
				NULL);

		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		XtSetArg(args[n], XmNtopWidget, rc); n++;
		XtSetArg(args[n], XmNtopAttachment,  XmATTACH_WIDGET); n++;
		XtSetArg(args[n], XmNrightAttachment,  XmATTACH_FORM); n++;


		rc = XmCreateRowColumn(form, "rowcol", args, n);
		XtManageChild(rc);

		label1=XtVaCreateManagedWidget("Value (0-255, 256 - prompt) :", xmLabelWidgetClass, rc,
				XmNlabelString, XmStringCreate ("Value (0-255, 256 - prompt) :",XmFONTLIST_DEFAULT_TAG),
				NULL);

		p_value=XtVaCreateManagedWidget("", 
				xmTextWidgetClass, rc,
				XmNmaxLength,5,
				XmNwidth, 45,
				NULL);

		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		XtSetArg(args[n], XmNtopWidget, rc); n++;
		XtSetArg(args[n], XmNtopAttachment,  XmATTACH_WIDGET); n++;
		XtSetArg(args[n], XmNrightAttachment,  XmATTACH_FORM); n++;
		


		rc = XmCreateRowColumn(form, "rowcol", args, n);
		XtManageChild(rc);

		label1=XtVaCreateManagedWidget("Original value (0-255) :", xmLabelWidgetClass, rc,
				XmNlabelString, XmStringCreate ("Original value (0-255) :",XmFONTLIST_DEFAULT_TAG),
				NULL);

		p_old=XtVaCreateManagedWidget("", 
				xmTextWidgetClass, rc,
				XmNmaxLength,5,
				XmNwidth, 45,
				NULL);

		button = XtVaCreateManagedWidget("Get", xmPushButtonWidgetClass, rc, XmNhighlightThickness, 1, XmNshadowThickness, 1, NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) p_get, NULL);

		button = XtVaCreateManagedWidget("Cancel", 
				xmPushButtonWidgetClass, form, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1, 
				XmNtopWidget, rc,
				XmNtopAttachment,  XmATTACH_WIDGET,
				XmNrightAttachment,  XmATTACH_FORM,
				NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) CloseDialog, NULL);

		button = XtVaCreateManagedWidget(" Add ", 
				xmPushButtonWidgetClass, form, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1, 
				XmNtopWidget, rc,
				XmNtopAttachment,  XmATTACH_WIDGET,
				XmNleftAttachment,  XmATTACH_FORM,

				NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) p_add_poke, NULL);

		button = XtVaCreateManagedWidget(" Apply ", 
				xmPushButtonWidgetClass, form, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1, 

				XmNtopWidget, rc,
				XmNtopAttachment,  XmATTACH_WIDGET,
				XmNleftWidget, button,
				XmNleftAttachment,  XmATTACH_WIDGET,
				NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) p_add_poke_apply, NULL);
	}

	XtManageChild(form);
	XtManageChild(pane);
	XtPopup(dialog, XtGrabNone);	
	XRaiseWindow(display,XtWindow(dialog));
}

void p_get_edt(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	int bank, addr;
	unsigned char old;
	char st[10];

	

	bank=strtol(XmTextGetString(p_bank_edt),NULL,0);
	addr=strtol(XmTextGetString(p_addr_edt),NULL,0);

	if (CheckBankAddrValueOld(bank, addr, 0, 0)!=NULL)
	{
		MessageBoxErr(CheckBankAddrValueOld(bank, addr, 0, 0));
		return;
	}

	switch (bank)
	{
		case 0:
			old=RAM0[addr-49152];
			break;
		case 1:
			old=RAM1[addr-49152];
			break;
		case 3:
			old=RAM3[addr-49152];
			break;
		case 4:
			old=RAM4[addr-49152];
			break;
		case 6:
			old=RAM6[addr-49152];
			break;

		case 7:
			old=RAM7[addr-49152];
			break;
			

		case 2:
			if (addr<49152)
				old=CPU12[addr];
			else 
				old=CPU12[addr-16384];
			break;

		case 5:
			if (addr<49152)
				old=CPU12[addr];
			else 
				old=CPU12[addr-32768];
			break;

		default:
			old=ReadByte(addr);
	}

	sprintf(st,"%d",old);
	XmTextSetString(p_old_edt,st);
}	

void p_add_poke_edt(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	int * selected[20];
	int num;

	int bank, addr, value, old;

	int tnum;

	char string[255];

	XmString xms;


	bank=strtol(XmTextGetString(p_bank_edt),NULL,0);
	addr=strtol(XmTextGetString(p_addr_edt),NULL,0);
	value=strtol(XmTextGetString(p_value_edt),NULL,0);

	old=strtol(XmTextGetString(p_old_edt),NULL,0);

	if (CheckBankAddrValueOld(bank, addr, value, old)!=NULL)
	{
		MessageBoxErr(CheckBankAddrValueOld(bank, addr, value, old));
		return;
	}

	XmListGetSelectedPos(tdes,(int **)selected,&num);

	if (num!=1)
	{

		MessageBoxErr("Unable to change POKE values. Please select trainer for POKE.");
		return;
	}

	tnum=*selected[0];

	XmListGetSelectedPos(tdet,(int **)selected,&num);

	if (num!=1)
	{
		MessageBoxErr("Unable to change POKE values. Please select POKE for editing.");
		return;
	}

	FindPoke(FindTrainer(tnum)->POKEs,*selected[0])->value=value;
	FindPoke(FindTrainer(tnum)->POKEs,*selected[0])->addr=addr;

	FindPoke(FindTrainer(tnum)->POKEs,*selected[0])->bank=bank;
	FindPoke(FindTrainer(tnum)->POKEs,*selected[0])->old=old;


	sprintf(string,"%2d %5d %3d %3d", bank&0xf, addr, value, old);

	xms=XmStringCreateSimple(string);
	XmListReplaceItemsPos(tdet,&xms,1,*selected[0]);

	if (client_data==(XtPointer)1)
		ApplyPoke(FindPoke(FindTrainer(tnum)->POKEs,*selected[0]),FindTrainer(tnum)->name);	

	CloseDialog(w, NULL, NULL);
}

void p_edit_poke(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	int * selected[20];
	int num;

	static Widget dialog;
	static Widget pane;
	static Widget form; 

	Widget label1,rc, button;

	int pokenum;
	POKE_type * poke;
	char st[10];


	XmListGetSelectedPos(tdet,selected,&num);

	if (num!=1)
	{
		MessageBoxErr("Nothing to edit. Please select POKE for editing.");
		return;
	}

	pokenum=*selected[0];

	XmListGetSelectedPos(tdes,selected,&num);

	if (num!=1)
	{
		MessageBoxErr("Please select valid trainer.");
		return;
	}

	if (!dialog)
	{
		dialog = XtVaCreatePopupShell("Pokes",
				xmDialogShellWidgetClass, first_window,
				XmNtitle,  "Edit POKE",
				NULL);

		pane = XtVaCreateWidget("pane", xmPanedWindowWidgetClass, dialog,
				XmNsashWidth,  1, /* try to "hide" resizing sash.  PanedWindow */
				XmNsashHeight, 1, /* won't let us set to 0, so 1 will have to do */
				NULL);

		form = XtVaCreateWidget("form", xmFormWidgetClass, pane, NULL);

		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		XtSetArg(args[n], XmNrightAttachment,  XmATTACH_FORM); n++;


		rc = XmCreateRowColumn(form, "rowcol", args, n);
		XtManageChild(rc);

		label1=XtVaCreateManagedWidget("Memory bank (8 - ignore bank) :", xmLabelWidgetClass, rc,
				XmNlabelString, XmStringCreate ("Memory bank (8 - ignore bank) :",XmFONTLIST_DEFAULT_TAG),
				NULL);

		p_bank_edt=XtVaCreateManagedWidget("", 
				xmTextWidgetClass, rc,
				XmNmaxLength,3,
				XmNwidth, 35,
				NULL);

		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;

		XtSetArg(args[n], XmNtopWidget, rc); n++;
		XtSetArg(args[n], XmNtopAttachment,  XmATTACH_WIDGET); n++;
		XtSetArg(args[n], XmNrightAttachment,  XmATTACH_FORM); n++;


		rc = XmCreateRowColumn(form, "rowcol", args, n);
		XtManageChild(rc);

		label1=XtVaCreateManagedWidget("Address (16384-65535) :", xmLabelWidgetClass, rc,
				XmNlabelString, XmStringCreate ("Address (16384-65535) :",XmFONTLIST_DEFAULT_TAG),
				NULL);

		p_addr_edt=XtVaCreateManagedWidget("", 
				xmTextWidgetClass, rc,
				XmNwidth, 60,
				XmNmaxLength,7,
				NULL);

		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		XtSetArg(args[n], XmNtopWidget, rc); n++;
		XtSetArg(args[n], XmNtopAttachment,  XmATTACH_WIDGET); n++;
		XtSetArg(args[n], XmNrightAttachment,  XmATTACH_FORM); n++;
		



		rc = XmCreateRowColumn(form, "rowcol", args, n);
		XtManageChild(rc);

		label1=XtVaCreateManagedWidget("Value (0-255, 256 - prompt) :", xmLabelWidgetClass, rc,

				XmNlabelString, XmStringCreate ("Value (0-255, 256 - prompt) :",XmFONTLIST_DEFAULT_TAG),
				NULL);

		p_value_edt=XtVaCreateManagedWidget("", 
				xmTextWidgetClass, rc,
				XmNmaxLength,5,
				XmNwidth, 45,
				NULL);
		

		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		XtSetArg(args[n], XmNtopWidget, rc); n++;
		XtSetArg(args[n], XmNtopAttachment,  XmATTACH_WIDGET); n++;
		XtSetArg(args[n], XmNrightAttachment,  XmATTACH_FORM); n++;


		rc = XmCreateRowColumn(form, "rowcol", args, n);
		XtManageChild(rc);

		label1=XtVaCreateManagedWidget("Original value (0-255) :", xmLabelWidgetClass, rc,
				XmNlabelString, XmStringCreate ("Original value (0-255) :",XmFONTLIST_DEFAULT_TAG),
				NULL);

		p_old_edt=XtVaCreateManagedWidget("", 
				xmTextWidgetClass, rc,
				XmNmaxLength,5,
				XmNwidth, 45,
				NULL);

		button = XtVaCreateManagedWidget("Get", xmPushButtonWidgetClass, rc, XmNhighlightThickness, 1, XmNshadowThickness, 1, NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) p_get_edt, NULL);

		button = XtVaCreateManagedWidget("Cancel", 
				xmPushButtonWidgetClass, form, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1, 
				XmNtopWidget, rc,
				XmNtopAttachment,  XmATTACH_WIDGET,
				XmNrightAttachment,  XmATTACH_FORM,
				NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) CloseDialog, NULL);

		button = XtVaCreateManagedWidget("  OK  ", 
				xmPushButtonWidgetClass, form, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1, 
				XmNtopWidget, rc,
				XmNtopAttachment,  XmATTACH_WIDGET,
				XmNleftAttachment,  XmATTACH_FORM,
				NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) p_add_poke_edt, (XtPointer) 0);

		button = XtVaCreateManagedWidget(" Apply ", 
				xmPushButtonWidgetClass, form, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1, 
				XmNtopWidget, rc,
				XmNtopAttachment,  XmATTACH_WIDGET,
				XmNleftWidget, button,
				XmNleftAttachment,  XmATTACH_WIDGET,
				NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) p_add_poke_edt, (XtPointer) 1);
	}

	XtManageChild(form);
	XtManageChild(pane);
	XtPopup(dialog, XtGrabNone);
	XRaiseWindow(display,XtWindow(dialog));	

	poke=FindPoke(FindTrainer(*selected[0])->POKEs,pokenum);

	sprintf(st,"%d",poke->bank);
	XmTextSetString(p_bank_edt,st);

	sprintf(st,"%d",poke->addr);
	XmTextSetString(p_addr_edt,st);

	sprintf(st,"%d",poke->value);
	XmTextSetString(p_value_edt,st);

	sprintf(st,"%d",poke->old);
	XmTextSetString(p_old_edt,st);
}

void DecrementTrainersPosition(trainer_struct * first)
{
	trainer_struct * t;


	t=first;

	if (t==NULL) return;

	while (TRUE)
	{
		t->position--;

		t=t->next;

		if (t==NULL) break;
	}
}

void p_delete_trainer(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	int * selected[20];
	int num;
	int i;

	POKE_type * p;
	trainer_struct * pt;
	trainer_struct * t;


	XmListGetSelectedPos(tdes,selected,&num);

	if (num==0)
	{
		MessageBoxErr("No trainers seleceted. Nothing to delete.");
		return;
	}

	for (i=0; i<num; i++)
	{
		XmListDeletePos(tdes, *selected[i]);

		t=FindTrainer(*selected[i]);
		p=t->POKEs;

		while (TRUE)

		{
			if (p==NULL)break;
			free(p);
			p=p->next;
		}


		if (trainers==t)
		{
			trainers=trainers->next;
			DecrementTrainersPosition(trainers);
		}
		else
		{
			pt=trainers;

			while(TRUE)
			{
				if (pt->next==t)break;
				pt=pt->next;
				if (pt==NULL)
				{
					MessageBoxErr("p_delete_trainer : pt==NULL. This is bug. Report it.");
					return;
				}
			}
			pt->next=t->next;
			DecrementTrainersPosition(pt->next);
		}

		free(t);
	}	


	XmListDeleteAllItems(tdet);
}

void ShowPokes(trainer_struct * trainer)
{
	char string [255];
	POKE_type * p;


	if (trainer==NULL)
	{
		printf("NULL pointer passed to ShowPokes. This is bug. Report it.\n");
		return;
	}

	XmListDeleteAllItems(tdet);

	p=trainer->POKEs;

	while (TRUE)
	{
		if (p==NULL) break;

		sprintf(string,"%2d %5d %3d %3d", p->bank&0xf, p->addr, p->value, p->old);

		XmListAddItemUnselected(tdet, XmStringCreateSimple(string), 0);

		p=p->next;
	}	

}

void my_proc(list_w, client_data, cbs)
	Widget list_w;
	XtPointer client_data;
	XmListCallbackStruct *cbs; 
{
	int * selected[20];
	int num;


	XmListGetSelectedPos(tdes, selected, &num);

	if (num!=1)
		XmListDeleteAllItems(tdet);
	else
		ShowPokes(FindTrainer(cbs->item_position));
}

void ClearAllTrainers()
{
	trainer_struct *t, *tt;
	POKE_type *p, *pp;


	t=trainers;

	if (t==NULL)
		return;
	

	while (TRUE) /* prosmatrivaem traineri */
	{
		if (t->POKEs==NULL)
			goto LNT;

		p=t->POKEs;

		while (TRUE) /* prosmatrivaem poki */
		{
			pp=p;

			p=p->next;
			free(pp);
			if (p==NULL) break;
		}


	LNT:
		tt=t;
		t=t->next;
		free(tt);
		if (t==NULL) break;
	}

	trainers=NULL;

	XmListDeleteAllItems(tdet);
	XmListDeleteAllItems(tdes);
}


void LoadPok(char * filename)
{
	FILE * fil;

	char tname[255];
	int type;
	int bank, addr, value, old;
	int i,j,tlen;


	fil=fopen(filename,"r");

	if (fil==NULL)
	{
		sprintf(tstring,"LoadPok : can't open %s for read.",filename);
		MessageBoxErr(tstring);
	}

	while (TRUE)
	{
		type=fgetc(fil);

		if ((type=='Y')||(type=='y')||(type==EOF))
		{
			fclose(fil);
			return;
		}

		if ((type=='N')||(type=='n'))
		{
			bzero(tname, sizeof(tname));
			fgets(tname,200,fil);

			for (i=0; i<sizeof(tname); i++)
				if ((tname[i]==0xa)||(tname[i]==0xd))
					tname[i]=0;

			if (strlen(tname)>30)
			{
				sprintf(tstring,"LoadPok :  Unknown file format : strlen(TRAINER_NAME)=%d. Must be <= 30", strlen(tname));
				MessageBoxErr(tstring);
				fclose(fil);
				return;
			}

			tlen=strlen(tname);
			tlen--;

			for (j=tlen; j>=0; j--)
			{
				if (tname[j]==' ')
					tname[j]=0;
				else

					break;
			}

			AddTrainer(tname);

			continue;
		}

		if ((type=='M')||(type=='m')||(type=='Z')||(type=='z'))
		{
			fscanf(fil,"%d %d %d %d\n", &bank, &addr, &value, &old);

			if (CheckBankAddrValueOld(bank, addr, value, old)!=NULL)
			{
				sprintf(tstring,"LoadPok :  Unknown file format : %s",CheckBankAddrValueOld(bank, addr, value, old));
				MessageBoxErr(tstring);
				fclose(fil);
				return;

			}

			AddPOKE(trainers, bank, addr, value, old, 0);

			continue;
		}

		MessageBoxErr("LoadPok :  Unknown file format : Content of the line unknown.");
		break;
	}	

	fclose(fil);
}

void open_pok(w, client_data, cbs)
	Widget w;

	XtPointer client_data;
	XmFileSelectionBoxCallbackStruct * cbs;
{
	char * filename;
	char * directory;
	char ext[4];
	char extention[5]={0};


	XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &filename);
	XmStringGetLtoR(cbs->dir, XmSTRING_DEFAULT_CHARSET, &directory);

	sprintf(pok_directory,directory);

	strncpy(extention,&filename[strlen(filename)-4],4);

	if (extention[3]=='/')
	{
		tounmanage=w;
		MessageBoxEx("Directory selected !");
		return;
	}

	if (strlen(filename)<5)
	{
		tounmanage=w;
		MessageBoxEx("Unknown file type !");

		return;
	}

	sprintf(ext,"%s",&filename[strlen(filename)-3]);

	if (strcasecmp(ext,"pok")==0)
	{
		ClearAllTrainers();
		LoadPok(filename);
		XmListDeleteAllItems(tdet);

		XtUnmanageChild(w);
		XmProcessTraversal(drawing_a, XmTRAVERSE_CURRENT);
		return;
	}

	tounmanage=w;
	MessageBoxEx("Unknown file type !");
}

void open_pok_file(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct * cbs;
{
	Widget dialog;

	dialog = XmCreateFileSelectionDialog(first_window, "Open snapshot", NULL, 0);

	XtVaSetValues(dialog,
		XmNdirectory,XmStringCreate (pok_directory,XmFONTLIST_DEFAULT_TAG),
		NULL);

	XtAddCallback(dialog, XmNcancelCallback, (XtCallbackProc)cancel_open_file, NULL);

	XtAddCallback(dialog, XmNokCallback, (XtCallbackProc)open_pok, NULL);

	XtManageChild(dialog);
}

void ApplyPoke1(POKE_type * p)
{
	switch (p->bank)
	{
		case 0:
			RAM0[p->addr-49152]=p->value;
			break;
		case 1:
			RAM1[p->addr-49152]=p->value;
			break;
		case 3:
			RAM3[p->addr-49152]=p->value;
			break;
		case 4:
			RAM4[p->addr-49152]=p->value;
			break;
		case 6:
			RAM6[p->addr-49152]=p->value;
			break;
		case 7:
			RAM7[p->addr-49152]=p->value;
			break;

		case 2:
			if (p->addr<49152)
				CPU12[p->addr]=p->value;
			else 
				CPU12[p->addr-16384]=p->value;
			break;

		case 5:
			if (p->addr<49152)
				CPU12[p->addr]=p->value;
			else 
				CPU12[p->addr-32768]=p->value;
			break;

		default:
			WriteByte(p->addr,p->value);
	}
}

void RemovePoke(POKE_type * p)
{
	switch (p->bank)
	{
		case 0:
			RAM0[p->addr-49152]=p->old;
			break;
		case 1:
			RAM1[p->addr-49152]=p->old;
			break;
		case 3:
			RAM3[p->addr-49152]=p->old;
			break;
		case 4:
			RAM4[p->addr-49152]=p->old;
			break;
		case 6:
			RAM6[p->addr-49152]=p->old;
			break;
		case 7:
			RAM7[p->addr-49152]=p->old;
			break;

		case 2:
			if (p->addr<49152)
				CPU12[p->addr]=p->old;
			else 
				CPU12[p->addr-16384]=p->old;
			break;

		case 5:
			if (p->addr<49152)
				CPU12[p->addr]=p->old;
			else 
				CPU12[p->addr-32768]=p->old;
			break;

		default:
			WriteByte(p->addr,p->old);
	}
}

void p_apply_poke1(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct * cbs;
{
	int value;
	POKE_type * p;

	value=strtol(XmTextGetString(poke_value_enetered),NULL,0);

	if ((value<0)||(value>255))
	{
		MessageBoxErr("Invalid value entered. Must be >=0 and <=255.");
		return;
	}


	p=(POKE_type *)client_data;

	p->value=value;

	ApplyPoke1(p);


	free(p);

	CloseDialog(w,NULL,NULL);
}

void ApplyPoke(POKE_type * p, char * trainer_name)
{
	POKE_type * poke;

	Widget dialog, pane, form, label, rc, button; 
	


	char st[255];



	if (p->value==256)
	{
		poke=malloc(sizeof(POKE_type));
		memcpy(poke,p,sizeof(POKE_type));


		dialog = XtVaCreatePopupShell("Pokes",
				xmDialogShellWidgetClass, first_window,
				XmNtitle,  "Value for POKE",
				NULL);

		pane = XtVaCreateWidget("pane", xmPanedWindowWidgetClass, dialog,
				XmNsashWidth,  1, /* try to "hide" resizing sash.  PanedWindow */
				XmNsashHeight, 1, /* won't let us set to 0, so 1 will have to do */
				NULL);

		form = XtVaCreateWidget("form", xmFormWidgetClass, pane, NULL);

		sprintf(st,"%s :", trainer_name);

		label=XtVaCreateManagedWidget("", xmLabelWidgetClass, form,
				XmNlabelString, XmStringCreate (st,XmFONTLIST_DEFAULT_TAG),

				NULL);


		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
		XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
		XtSetArg(args[n], XmNtopWidget, label); n++;

		rc = XmCreateRowColumn(form, "rowcol", args, n);

		sprintf(st,"POKE %d,",p->addr);

		label=XtVaCreateManagedWidget("", xmLabelWidgetClass, rc,
				XmNlabelString, XmStringCreate (st,XmFONTLIST_DEFAULT_TAG),
				NULL);

		poke_value_enetered=XtVaCreateManagedWidget("", 
				xmTextWidgetClass, rc,
				XmNmaxLength,5,
				XmNwidth, 45,
				NULL);

		XtManageChild(rc);

		button = XtVaCreateManagedWidget("Cancel", 

				xmPushButtonWidgetClass, form, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1, 
				XmNtopWidget, rc,
				XmNtopAttachment,  XmATTACH_WIDGET,
				XmNrightAttachment,  XmATTACH_FORM,
				NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) CloseDialog, NULL);

		button = XtVaCreateManagedWidget("  Ok  ", 
				xmPushButtonWidgetClass, form, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1, 
				XmNtopWidget, rc,
				XmNtopAttachment,  XmATTACH_WIDGET,
				XmNleftAttachment,  XmATTACH_FORM,
				NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) p_apply_poke1, (XtPointer) poke);

		XtManageChild(form);
		XtManageChild(pane);
		XtPopup(dialog, XtGrabNone);
		XRaiseWindow(display,XtWindow(dialog));
	}
	else
		ApplyPoke1(p);
}

void p_apply_poke(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct * cbs;
{
	int * selected[20];
	int num;
	int pokenum;


	XmListGetSelectedPos(tdet, selected, &num);

	if (num!=1)
		MessageBoxErr("Can't apply POKE. Please select POKE from POKEs list.");
	else
	{
		pokenum=*selected[0];


		XmListGetSelectedPos(tdes, selected, &num);

		if (num!=1)
			MessageBoxErr("Can't apply POKE. Please select trainer from trainers list.");

		else
			ApplyPoke(FindPoke(FindTrainer(*selected[0])->POKEs, pokenum), FindTrainer(*selected[0])->name);
	}
}

void p_remove_poke(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct * cbs;
{
	int * selected[20];
	int num;
	int pokenum;


	XmListGetSelectedPos(tdet, selected, &num);

	if (num!=1)
		MessageBoxErr("Nothing to remove. Please select POKE from POKEs list.");
	else
	{
		pokenum=*selected[0];


		XmListGetSelectedPos(tdes, selected, &num);

		if (num!=1)
			MessageBoxErr("Can't remove POKE. Please select trainer from trainers list.");
		else
			RemovePoke(FindPoke(FindTrainer(*selected[0])->POKEs, pokenum));
	}
}

void SavePok(char * filename)
{
	FILE * fil;

	trainer_struct * t;
	POKE_type * p;

	

	fil=fopen(filename,"w");

	if (fil==NULL)
	{
		sprintf(tstring,"Can't open %s for writing.", filename);
		MessageBoxErr(tstring);
		return;
	}

	t=trainers;

	if (t==NULL)
	{
		printf("SavePok : trainers==NULL. This is bug. Report it.");
		return;
	}

	while (TRUE) /* prosmatrivaem traineri */
	{
		if (t->POKEs==NULL)
		{
			printf("Because trainer %s contains no POKEs it can't be saved.\n",t->name);			
			goto LNT;
		}
		

		fprintf(fil,"N%-30s\r\n",t->name);

		p=t->POKEs;

		while (TRUE) /* prosmatrivaem poki */
		{
			if (p->next==NULL)
			{
				fprintf(fil,"Z%3d %5d %3d %3d\r\n",p->bank,p->addr,p->value,p->old);
				break;
			}

			fprintf(fil,"M%3d %5d %3d %3d\r\n",p->bank,p->addr,p->value,p->old);
			p=p->next;
		}


	LNT:
		t=t->next;
		if (t==NULL) 
		{
			fprintf(fil,"Y");
			break;
		}
	}

	fclose(fil);
}

void p_saveIt(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	SavePok(filenameT);

	XtUnmanageChild(tounmanage);
	XmProcessTraversal(drawing_a, XmTRAVERSE_CURRENT);
}

void p_save_file(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmFileSelectionBoxCallbackStruct *cbs;
{

	char * filename;
	char * directory;
	char extention[5]={0};

	XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &filename);
	XmStringGetLtoR(cbs->dir, XmSTRING_DEFAULT_CHARSET, &directory);

	sprintf(pok_directory,directory);

	strncpy(extention,&filename[strlen(filename)-4],4);

	if (extention[3]=='/')
	{
		tounmanage=w;

		MessageBoxEx("Directory selected !");
		return;
	}
	

	if (strcasecmp(extention,".pok")==0)
		sprintf(filenameT,"%s",filename);
	else
		sprintf(filenameT,"%s.pok",filename);

	if (FileExists(filenameT))
	{

		tounmanage=w;
		MessageBoxOverwrite((XtCallbackProc)p_saveIt, NULL);
	}
	else
	{
		SavePok(filenameT);

		XtUnmanageChild(w);
		XmProcessTraversal(drawing_a, XmTRAVERSE_CURRENT);
	}
}

void p_save_pokes(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	Widget dialog;

	int n;


	XtVaGetValues(tdes, XmNitemCount, &n, NULL);

	if (n>0)
	{
		dialog = XmCreateFileSelectionDialog(first_window, "Save pokes", NULL, 0);

		XtVaSetValues(dialog,
			XmNdirectory,XmStringCreate (pok_directory,XmFONTLIST_DEFAULT_TAG),
			NULL);

		XtAddCallback(dialog, XmNcancelCallback, (XtCallbackProc)cancel_open_file, NULL);
		XtAddCallback(dialog, XmNokCallback, (XtCallbackProc)p_save_file, NULL);

		XtManageChild(dialog);	
	}
	else
		MessageBoxErr("No trainers - nothing to save.");
}

void p_apply_trainer(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	int * selected[20];
	int num;

	trainer_struct * t;
	POKE_type * p;


	XmListGetSelectedPos(tdes,selected,&num);

	if (num!=1)
	{
		MessageBoxErr("Nothing to apply. No trainer(s) selected.");
		return;
	}

	t=FindTrainer(*selected[0]);
	p=t->POKEs;

	if (p==NULL)
	{
		MessageBoxErr("No POKEs in selected trainer. Nothing to apply.");
		return;	
	}

	while (TRUE)
	{
		ApplyPoke(p, t->name);

		p=p->next;
		if (p==NULL) break;
	}
}

void p_remove_trainer(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	int * selected[20];
	int num;

	trainer_struct * t;
	POKE_type * p;


	XmListGetSelectedPos(tdes,selected,&num);

	if (num!=1)
	{
		MessageBoxErr("Nothing to remove. No trainer(s) selected.");
		return;
	}

	t=FindTrainer(*selected[0]);
	p=t->POKEs;

	if (p==NULL)
	{
		MessageBoxErr("No POKEs in selected trainer. Nothing to remove.");
		return;	
	}

	while (TRUE)
	{
		RemovePoke(p);

		p=p->next;
		if (p==NULL) break;
	}
}

void p_apply_all_trainers(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	int n;

	trainer_struct * t;
	POKE_type * p;


	XtVaGetValues(tdes, XmNitemCount, &n, NULL);

	if (n<=0)
	{
		MessageBoxErr("No trainer(s).");
		return;
	}


	t=trainers;

	if (t==NULL)
	{
		printf("p_apply_all_trainers : trainers==NULL. This is bug. Report it.");
		return;
	}

	while (TRUE) /* prosmatrivaem traineri */
	{
		if (t->POKEs==NULL)
		{
			printf("Because trainer %s contains no POKEs it can't be applyed.\n",t->name);			
			goto LNT;
		}

		p=t->POKEs;

		while (TRUE) /* prosmatrivaem poki */
		{
			ApplyPoke(p, t->name);

			p=p->next;
			if (p==NULL)break;
		}


	LNT:
		t=t->next;
		if (t==NULL) 
			break;
	}
}

void p_remove_all_trainers(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	int n;

	trainer_struct * t;
	POKE_type * p;


	XtVaGetValues(tdes, XmNitemCount, &n, NULL);

	if (n<=0)
	{
		MessageBoxErr("No trainer(s).");
		return;
	}


	t=trainers;

	if (t==NULL)
	{
		printf("p_remove_all_trainers : trainers==NULL. This is bug. Report it.");
		return;

	}

	while (TRUE) /* prosmatrivaem traineri */
	{
		if (t->POKEs==NULL)
		{
			printf("Because trainer %s contains no POKEs it can't be removed.\n",t->name);			
			goto LNT;
		}

		p=t->POKEs;

		while (TRUE) /* prosmatrivaem poki */
		{
			RemovePoke(p);

			p=p->next;
			if (p==NULL) break;
		}


	LNT:
		t=t->next;
		if (t==NULL) break;
	}
}

POKE_type * DeletePokeFromRAM(trainer_struct * t, POKE_type * p)
{
	POKE_type * pp;
	POKE_type * rv;

	if (t->POKEs!=p) 
	{
		pp=t->POKEs;

		while (TRUE)
		{
			if (pp->next==p) break;
			pp=pp->next;

			if (pp==NULL)
			{
				MessageBoxErr("DeletePokeFromRAM : pp==NULL. This is bug. Report it.");
				return(NULL);
			}
		}

		pp->next=p->next;
		rv=p->next;
	}
	else
	{
		t->POKEs=p->next;
		rv=p->next;
	}

	free(p);
	return(rv);
}

void DecrementPokesPosition(POKE_type * first)
{
	POKE_type * p;


	p=first;

	if (p==NULL) return;

	while (TRUE)
	{
		p->position--;

		p=p->next;

		if (p==NULL) break;
	}
}

void p_delete_poke(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	int * selected[20];
	int num;

	int pnum;


	XmListGetSelectedPos(tdet,selected,&num);

	if (num!=1)
	{
		MessageBoxErr("Nothing to delete. Please select POKE for deleting.");
		return;
	}

	pnum=*selected[0];



	XmListGetSelectedPos(tdes,selected,&num);

	if (num!=1)
	{
		MessageBoxErr("Please select trainer.");
		return;
	}

	DecrementPokesPosition(DeletePokeFromRAM(FindTrainer(*selected[0]),FindPoke(FindTrainer(*selected[0])->POKEs,pnum)));
	XmListDeletePos(tdet,pnum);
}

void p_delete_trainers(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;

{
	XtVaGetValues(tdes, XmNitemCount, &n, NULL);

	if (n<=0)
	{
		MessageBoxErr("No trainer(s).");
		return;
	}

	MessageBoxOkCan((XtCallbackProc)ClearAllTrainers,NULL,NULL,"This will clear all trainers. Are you sure ?");	
}

void p_get_orginal_values(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	trainer_struct *t;
	POKE_type *p;

	int bank, addr;
	unsigned char old;



	XtVaGetValues(tdes, XmNitemCount, &n, NULL);

	if (n<=0)
	{
		MessageBoxErr("No trainer(s).");
		return;
	}


	t=trainers;

	if (t==NULL)
	{
		MessageBoxErr("p_get_orginal_values : t==NULL. This is bug. Report it.");
		return;
	}

	while (TRUE) /* prosmatrivaem traineri */
	{
		if (t->POKEs==NULL)
			goto LNT;

		p=t->POKEs;

		while (TRUE) /* prosmatrivaem poki */
		{
			bank=p->bank;
			addr=p->addr;

			if (CheckBankAddrValueOld(bank, addr, 0, 0)!=NULL)
			{
				MessageBoxErr(CheckBankAddrValueOld(bank, addr, 0, 0));
				return;
			}

			switch (bank)
			{
				case 0:
					old=RAM0[addr-49152];
					break;
				case 1:
					old=RAM1[addr-49152];
					break;
				case 3:
					old=RAM3[addr-49152];
					break;
				case 4:
					old=RAM4[addr-49152];
					break;
				case 6:

					old=RAM6[addr-49152];
					break;
				case 7:
					old=RAM7[addr-49152];
					break;

				case 2:
					if (addr<49152)
						old=CPU12[addr];
					else 
						old=CPU12[addr-16384];
					break;

				case 5:
					if (addr<49152)

						old=CPU12[addr];
					else 
						old=CPU12[addr-32768];
					break;

				default:
					old=ReadByte(addr);
			}

			if(p->old!=old)
				printf("%s : POKE %d,%d : Old value chaged.\n",t->name,p->addr,p->value);

			p->old=old;


			p=p->next;
			if (p==NULL) break;
		}


	LNT:
		t=t->next;
		if (t==NULL) break;
	}

	SavePok("temp.pok");
	ClearAllTrainers();
	LoadPok("temp.pok");
	XmListDeleteAllItems(tdet);
	unlink("temp.pok");
}

void p_check_orginal_values(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	trainer_struct *t;
	POKE_type *p;

	int bank, addr;
	unsigned char old;



	XtVaGetValues(tdes, XmNitemCount, &n, NULL);

	if (n<=0)
	{
		MessageBoxErr("No trainer(s).");

		return;
	}


	t=trainers;

	if (t==NULL)
	{
		MessageBoxErr("p_check_orginal_values : t==NULL. This is bug. Report it.");
		return;
	}

	while (TRUE) /* prosmatrivaem traineri */
	{
		if (t->POKEs==NULL)
			goto LNT;

		p=t->POKEs;

		while (TRUE) /* prosmatrivaem poki */
		{

			bank=p->bank;
			addr=p->addr;

			if (CheckBankAddrValueOld(bank, addr, 0, 0)!=NULL)
			{
				MessageBoxErr(CheckBankAddrValueOld(bank, addr, 0, 0));

				return;
			}

			switch (bank)
			{
				case 0:
					old=RAM0[addr-49152];
					break;
				case 1:
					old=RAM1[addr-49152];
					break;
				case 3:
					old=RAM3[addr-49152];
					break;
				case 4:
					old=RAM4[addr-49152];
					break;
				case 6:
					old=RAM6[addr-49152];
					break;
				case 7:
					old=RAM7[addr-49152];
					break;

				case 2:
					if (addr<49152)
						old=CPU12[addr];
					else 
						old=CPU12[addr-16384];
					break;

				case 5:
					if (addr<49152)
						old=CPU12[addr];
					else 
						old=CPU12[addr-32768];
					break;

				default:
					old=ReadByte(addr);
			}

			if((p->old!=old)&&(p->old!=0)) /* !!! */
			{
				sprintf(tstring,"%s : POKE %d,%d - comparing failed.",t->name,p->addr,p->value);
				MessageBoxInfo(tstring);
				return;
			}


			p=p->next;
			if (p==NULL) break;
		}


	LNT:
		t=t->next;
		if (t==NULL) break;
	}

	MessageBoxInfo("No problems found.");
}

void poke_h(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	static Widget dialog;
	static Widget pane;
	static Widget form; 

	Widget label1, label2, pane1, button;
	Widget rc1=NULL;
	Widget rc2=NULL;
	Widget rc3,rc4,rc5,rc6,rc7,rc9;

	Widget separator, label3, label4;

	Dimension width;

	int not_dialog=0;


	if (!dialog)
	{
		not_dialog=1;	

		dialog = XtVaCreatePopupShell("Pokes",
				xmDialogShellWidgetClass, first_window,
				XmNtitle,  "POKEs",
				NULL);

		pane = XtVaCreateWidget("pane", xmPanedWindowWidgetClass, dialog,
				XmNsashWidth,  1, /* try to "hide" resizing sash.  PanedWindow */
				XmNsashHeight, 1, /* won't let us set to 0, so 1 will have to do */
				NULL);

		form = XtVaCreateWidget("form", xmFormWidgetClass, pane, NULL);

		pane1 = XtVaCreateWidget("pane",
				xmPanedWindowWidgetClass, form,
				XmNorientation, XmHORIZONTAL,
				XmNleftAttachment, XmATTACH_FORM,
				XmNrightAttachment, XmATTACH_FORM,
				XmNtopAttachment, XmATTACH_FORM,
				NULL);

		n = 0;
		XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;

		rc1 = XmCreateRowColumn(pane1, "rowcol", args, n);

		label1=XtVaCreateManagedWidget("Trainer description :", xmLabelWidgetClass, rc1,
				XmNlabelString, XmStringCreate ("Trainer description :",XmFONTLIST_DEFAULT_TAG) ,
				NULL);

		n=0;
		XtSetArg(args[n], XmNvisibleItemCount, 7); n++;
		XtSetArg(args[n], XmNwidth, 200); n++;
		XtSetArg(args[n], XmNselectionPolicy,  XmSINGLE_SELECT); n++;

		tdes = XmCreateScrolledList(rc1, "trainers_list", args, n);
		XtManageChild(tdes);

		XtAddCallback(tdes, XmNsingleSelectionCallback, (XtCallbackProc) my_proc, NULL);

		XtAddCallback(tdes, XmNdefaultActionCallback, (XtCallbackProc) my_proc, NULL);

		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;

		rc3 = XmCreateRowColumn(rc1, "rowcol", args, n);

		button = XtVaCreateManagedWidget("Add trainer", xmPushButtonWidgetClass, rc3, XmNhighlightThickness, 1, XmNshadowThickness, 1, NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) p_new_trainer, NULL);

		button = XtVaCreateManagedWidget("Edit trainer", xmPushButtonWidgetClass, rc3, XmNhighlightThickness, 1, XmNshadowThickness, 1, NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) p_new_trainer_edt, NULL);

		button = XtVaCreateManagedWidget("Delete trainer", xmPushButtonWidgetClass, rc3, XmNhighlightThickness, 1, XmNshadowThickness, 1, NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) p_delete_trainer, NULL);


		XtManageChild(rc3);

		rc9 = XmCreateRowColumn(rc1, "rowcol", args, n);

		button = XtVaCreateManagedWidget("Apply trainer", xmPushButtonWidgetClass, rc9, XmNhighlightThickness, 1, XmNshadowThickness, 1, NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) p_apply_trainer, NULL);

		button = XtVaCreateManagedWidget("Remove trainer", xmPushButtonWidgetClass, rc9, XmNhighlightThickness, 1, XmNshadowThickness, 1, NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) p_remove_trainer, NULL);

		XtManageChild(rc9);

		rc5 = XmCreateRowColumn(rc1, "rowcol", args, n);

		button = XtVaCreateManagedWidget("Apply all trainers", xmPushButtonWidgetClass, rc5, XmNhighlightThickness, 1, XmNshadowThickness, 1, NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) p_apply_all_trainers, NULL);

		button = XtVaCreateManagedWidget("Remove all trainers", xmPushButtonWidgetClass, rc5, XmNhighlightThickness, 1, XmNshadowThickness, 1, NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) p_remove_all_trainers, NULL);

		XtManageChild(rc5);


		XtManageChild(rc1);


		n = 0;
		XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;

		rc2 = XmCreateRowColumn(pane1, "rowcol", args, n);

		label2=XtVaCreateManagedWidget("Poke :", xmLabelWidgetClass, rc2,
				XmNlabelString, XmStringCreate ("Trainer POKEs :",XmFONTLIST_DEFAULT_TAG) ,
				NULL);

		n=0;
		XtSetArg(args[n], XmNvisibleItemCount, 7); n++;
		XtSetArg(args[n], XmNwidth, 150); n++;
		XtSetArg(args[n], XmNfontList, fontlist1); n++; 

		XtSetArg(args[n], XmNselectionPolicy,  XmSINGLE_SELECT); n++;


		tdet = XmCreateScrolledList(rc2, "poke_list", args, n);
		XtManageChild(tdet);


		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;

		rc4 = XmCreateRowColumn(rc2, "rowcol", args, n);

		button = XtVaCreateManagedWidget("Add POKE", xmPushButtonWidgetClass, rc4, XmNhighlightThickness, 1, XmNshadowThickness, 1, NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) p_new_poke, NULL);

		button = XtVaCreateManagedWidget("Edit POKE", xmPushButtonWidgetClass, rc4, XmNhighlightThickness, 1, XmNshadowThickness, 1, NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) p_edit_poke, NULL);

		button = XtVaCreateManagedWidget("Delete POKE", xmPushButtonWidgetClass, rc4, XmNhighlightThickness, 1, XmNshadowThickness, 1, NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) p_delete_poke, NULL);

		XtManageChild(rc4);

		rc6 = XmCreateRowColumn(rc2, "rowcol", args, n);

		button = XtVaCreateManagedWidget("Apply POKE", xmPushButtonWidgetClass, rc6, XmNhighlightThickness, 1, XmNshadowThickness, 1, NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) p_apply_poke, NULL);

		button = XtVaCreateManagedWidget("Remove POKE", xmPushButtonWidgetClass, rc6, XmNhighlightThickness, 1, XmNshadowThickness, 1, NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) p_remove_poke, NULL);

		XtManageChild(rc6);


		XtManageChild(rc2);

		XtManageChild(pane1);


		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		XtSetArg(args[n], XmNtopWidget,  pane1); n++;
		XtSetArg(args[n], XmNtopAttachment,  XmATTACH_WIDGET); n++;
		XtSetArg(args[n], XmNleftAttachment,  XmATTACH_FORM); n++;
		XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
		XtSetArg(args[n], XmNheight,10);n++;

		separator=XmCreateSeparator(form, "", args, n);
		XtManageChild(separator);

		label4=XtVaCreateManagedWidget("Trainers :", xmLabelWidgetClass, form,
				XmNlabelString, XmStringCreate (" ",XmFONTLIST_DEFAULT_TAG) ,
				XmNtopWidget,  pane1,
				XmNtopAttachment, XmATTACH_WIDGET,
				NULL);

		label3=XtVaCreateManagedWidget("Trainers :", xmLabelWidgetClass, form,
				XmNlabelString, XmStringCreate (" Trainers :",XmFONTLIST_DEFAULT_TAG) ,
				XmNtopWidget,  label4,
				XmNtopAttachment, XmATTACH_WIDGET,
				NULL);

		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;

		XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
		XtSetArg(args[n], XmNtopWidget, label3); n++;

		rc7 = XmCreateRowColumn(form, "rowcol", args, n);

		button = XtVaCreateManagedWidget(" Load ", xmPushButtonWidgetClass, rc7, XmNhighlightThickness, 1, XmNshadowThickness, 1, NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) open_pok_file, NULL);

		button = XtVaCreateManagedWidget(" Save ", xmPushButtonWidgetClass, rc7, XmNhighlightThickness, 1, XmNshadowThickness, 1, NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) p_save_pokes, NULL);

		button = XtVaCreateManagedWidget(" Delete ", xmPushButtonWidgetClass, rc7, XmNhighlightThickness, 1, XmNshadowThickness, 1, NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) p_delete_trainers, NULL);

		button = XtVaCreateManagedWidget(" Check original values ", xmPushButtonWidgetClass, rc7, XmNhighlightThickness, 1, XmNshadowThickness, 1, NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) p_check_orginal_values, NULL);

		button = XtVaCreateManagedWidget(" Get original values ", xmPushButtonWidgetClass, rc7, XmNhighlightThickness, 1, XmNshadowThickness, 1, NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) p_get_orginal_values, NULL);

		XtManageChild(rc7);	


		button = XtVaCreateManagedWidget("Close", xmPushButtonWidgetClass, form, XmNhighlightThickness, 1, XmNshadowThickness, 1, XmNrightAttachment, XmATTACH_FORM, XmNleftWidget, rc7, XmNtopWidget, label3, XmNtopAttachment, XmATTACH_WIDGET, XmNbottomAttachment, XmATTACH_FORM, NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) CloseDialog, NULL);
	}


	XtManageChild(form);
	XtManageChild(pane);
	XtPopup(dialog, XtGrabNone);
	XRaiseWindow(display,XtWindow(dialog));

	FixHeight(dialog);

	if (not_dialog)
	{
	/************* set min pane ******************/
		XtVaGetValues(rc1, XmNwidth, &width, NULL);

		n=0;
		XtSetArg(args[n], XmNpaneMinimum, width); n++;

		XtSetValues(rc1, args, n); 
		XtVaGetValues(rc2, XmNwidth, &width, NULL);

		n=0;
		XtSetArg(args[n], XmNpaneMinimum, width); n++;

		XtSetValues(rc2, args, n); 
	}
}

void FillXLib_Help_Array(void)
{
	int i,j,line,k;

	for (i=0; i<6144; i+=32)
	{
		for (line=0; line<192; line++)
		{
			if (GetAddrInZXScreen48ByLine==i)
				break;
		}

		for (j=0;j<32;j++)
		{
			XLib_Help_Array_Screen[i+j].line=line+24;	
			XLib_Help_Array_Screen[i+j].y=j*8+32;
			XLib_Help_Array_Screen[i+j].a=(line/8)*32+j;

			/* printf("%d %d %d\n",i+j,line,j); */
		}
	}

	for(i=0;i<768;i++)
	{
		k=0;

		for (j=0;j<6144;j++)
		{
			if (XLib_Help_Array_Screen[j].a==i)
			{
				XLib_Help_Array_Attrib[i].b[k]=j;
				k++;
				if (k>8)
					ExitWithError(-1,"FillXLib_Help_Array : k>8. This is bug. Report it.");
			}
		}

		if (k!=8)
			ExitWithError(-1,"FillXLib_Help_Array : k!=8. This is bug. Report it.");
	}
}

void FillParityTBL(void)
{
	unsigned char rp;
	unsigned char a=0;


	while(1)
	{
		rp=0;

		if (a&1) rp++;
		if (a&2) rp++;
		if (a&4) rp++;
		if (a&8) rp++;
		if (a&16) rp++;
		if (a&32) rp++;
		if (a&64) rp++;
		if (a&128) rp++;

		switch(rp)
		{
			case 0:
				ParityTBL[a]=1;
				break;
			case 1:
				ParityTBL[a]=0;
				break;
			case 2:
				ParityTBL[a]=1;
				break;
			case 3:
				ParityTBL[a]=0;
				break;
			case 4:
				ParityTBL[a]=1;
				break;
			case 5:
				ParityTBL[a]=0;
				break;
			case 6:
				ParityTBL[a]=1;
				break;
			case 7:
				ParityTBL[a]=0;
				break;
			case 8:
				ParityTBL[a]=1;
				break;
		}

/* printf("%d \n", ParityTBL[a]); */

		if (a!=255)a++; 
		else break;
	}
}

void DumpAudioBegin(void)
{
	unsigned int temp=0;
	unsigned short temp16=0;


	sound_fil=creat(filenameT, 00644);

	if (sound_fil==-1)
	{
		sprintf(tstring, "DumpAudioBegin : can't create %s", filenameT);
		MessageBoxErr(tstring);
		return;
	}

	write(sound_fil,"RIFF",4);
	write(sound_fil,&temp,4);
	write(sound_fil,"WAVEfmt ",8);
	temp=0x10;
	write(sound_fil,&temp,4);
	temp16=2;
	write(sound_fil,&temp16,2);
	write(sound_fil,&temp16,2);
	temp=44100;
	write(sound_fil,&temp,4);
	write(sound_fil,&temp,4);
	write(sound_fil,&temp16,2);
	temp16=16;
	write(sound_fil,&temp16,2);
	write(sound_fil,"data",4);
	write(sound_fil,&temp,4);

	strcpy(DumpAudioFileName, filenameT);
	XtManageChild(show_dump_s);
	NajatKnopku(DumpAudioButton, True);
}

void DumpIt(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	DumpAudioBegin();

	XtUnmanageChild(tounmanage);
	XmProcessTraversal(drawing_a, XmTRAVERSE_CURRENT);
}

void DumpAudioSelected(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmFileSelectionBoxCallbackStruct *cbs;
{
	char * filename;
	char * directory;
	char extention[5]={0};


	XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &filename);
	XmStringGetLtoR(cbs->dir, XmSTRING_DEFAULT_CHARSET, &directory);

	strncpy(extention,&filename[strlen(filename)-4],4);

	if (extention[3]=='/')
	{
		tounmanage=w;
		MessageBoxEx("Directory selected !");
		return;
	}

	if (strcasecmp(&extention[1],"wav")==0)
		sprintf(filenameT,"%s",filename);
	else
		sprintf(filenameT,"%s.wav",filename);

	if (FileExists(filenameT))
	{
		tounmanage=w;
		MessageBoxOverwrite((XtCallbackProc)DumpIt, NULL);
	}
	else
	{
		DumpAudioBegin();

		XtUnmanageChild(w);
		XmProcessTraversal(drawing_a, XmTRAVERSE_CURRENT);
	}
}

void Dump_Audio_dialog_create(w, client_data, state)
	Widget w;
	XtPointer client_data;
	XmToggleButtonCallbackStruct * state;
{
	static Widget dialog;

	unsigned int temp=0;
	unsigned short temp16=0;
	unsigned char Data=0;

	int fil;
	struct stat st;


	NajatKnopku(DumpAudioButton, False);

	if (state->set)
	{
		if (!dialog)
		{
			dialog = XmCreateFileSelectionDialog(first_window, "", NULL, 0);

			XtAddCallback(dialog, XmNcancelCallback, (XtCallbackProc)cancel_open_file, NULL);
			XtAddCallback(dialog, XmNokCallback, (XtCallbackProc)DumpAudioSelected, NULL);
		}

		XtManageChild(dialog);	
		return;
	}

	XtUnmanageChild(show_dump_s);
	close(sound_fil);
	sound_fil=-1;

	stat(DumpAudioFileName, &st);

	fil=open(DumpAudioFileName, O_WRONLY);
	lseek(fil, 0, SEEK_SET);

	write(fil, "RIFF",4);
	temp=st.st_size-8;
	write(fil, &temp,4);
	write(fil, "WAVEfmt ",8);
	temp=0x10;
	write(fil, &temp,4);
	temp16=1;
	write(fil, &temp16,2);
	temp16=2;
	write(fil, &temp16,2);
	temp=44100;
	write(fil, &temp,4);
	temp=44100*4;
	write(fil, &temp,4);
	temp16=4;
	write(fil, &temp16,2);
	temp16=16;
	write(fil, &temp16,2);
	write(fil, "data",4);
	temp=st.st_size-44;
	write(fil, &temp,4);
	write(fil, &Data,1);

	close(fil);
}

int RecordingInit3(void)
{
#define BASE_SOUND_FRAG_PWR_R	7


	int tmp;
	int frag;

	int samplesize = 8;
	int dsp_speed = 44100; 
	int dsp_stereo = 0;


	audio3 = open(sound_device_nameR, O_RDONLY|O_NONBLOCK, 0);                                                            

	if (audio3 == -1)                                                                                
	{                                                                                             
		sprintf(tstring,"Unable open %s for reading. RecordingInit3 failed.", sound_device_nameR);
		perror (sound_device_nameR);
		MessageBoxErr(tstring);
		return(errors);
	}  

	close(audio3);

	audio3 = open(sound_device_nameR, O_RDONLY/*|O_NONBLOCK*/, 0);                                                            

	if (audio3 == -1)                                                                                
	{                                                                                             
		sprintf(tstring,"Unable open %s for reading. RecordingInit3 failed.", sound_device_nameR);
		perror (sound_device_nameR);
		MessageBoxErr(tstring);
		return(errors);
	}  


#if defined LINUXAUDIO

	tmp = samplesize;                                                                               
	ioctl(audio3, SNDCTL_DSP_SAMPLESIZE, &samplesize);                                               
	if (tmp != samplesize)                                                                          
	{                                                                                               
		printf("Unable set samplesize = %d. RecordingInit3 failed.\n", tmp);
		perror("SNDCTL_DSP_SAMPLESIZE");                                                                    
		close(audio3);		
		return(errors);                                                                                  
	}                                                                                               

	if (ioctl(audio3, SNDCTL_DSP_STEREO, &dsp_stereo)==-1)                                          
	{                                                                                               
		printf("Unable to set stereo. RecordingInit3 failed.\n");                               
		perror(sound_device_nameR);                                                                        
		close(audio3);		
		return(errors);                                                                                      
	}                                                                                               

	if (ioctl(audio3, SNDCTL_DSP_SPEED, &dsp_speed) == -1)                                          
	{                                                                                             
		printf("Unable to set audio speed = %d. RecordingInit3 failed.\n",dsp_speed);                               
		perror(sound_device_nameR);                                                                        
		close(audio3);
		return(errors);                                                                                  
	}        


	frag=(0x80000|BASE_SOUND_FRAG_PWR_R);

	if(dsp_speed>8000) frag++;
	if(dsp_speed>16000) frag++;
	if(dsp_speed>32000) frag++;
	if(samplesize>8) frag++;
	if(dsp_stereo>0) frag++;

	if(ioctl(audio3,SNDCTL_DSP_SETFRAGMENT,&frag)<0)
	{
		perror ("SNDCTL_DSP_SETFRAGMENT");
		close(audio3);
		return(errors);
	}


	return(no_errors);

/* LINUXAUDIO */
#endif
}

void direct_tape_start(w, client_data, state)
	Widget w;
	XtPointer client_data;
	XmToggleButtonCallbackStruct * state;
{
	NajatKnopku(Direct_TB, False);


	if (state->set)
	{
		if (RecordingInit3()==no_errors)
		{
			if (sound)
			{
				close (audio);
				SoundcardInit(1);
			}
			direct_recording=1;
			NajatKnopku(Direct_TB, True);
		}
	}	
	else
	{
		if (sound)
		{
			close (audio);
			SoundcardInit(0);
		}
		close(audio3);
		direct_recording=0;
	}

	XmProcessTraversal(drawing_a, XmTRAVERSE_CURRENT);
}

void toggled_tape(widget, which, state)
	Widget widget;
	int which;
	XmToggleButtonCallbackStruct *state;
{
	if (state->set)
		tape_traps=1;
	else
		tape_traps=0;
}

int RecordingInit(void)
{
	int tmp;

	int samplesize = 16;
	int dsp_speed = 22050; 
	int dsp_stereo = 1;
#if defined LINUXAUDIO
	int format=AFMT_U16_LE;
#endif


	audio2 = open (sound_device_nameR, O_RDONLY|O_NONBLOCK, 0);                                                            

	if (audio2 == -1)                                                                                
	{                                                                                             
		sprintf(tstring,"Unable open %s for reading. RecordingInit failed.", sound_device_nameR);
		perror (sound_device_nameR);
		MessageBoxErr(tstring);
		return(errors);
	}  

	close(audio2);

	audio2 = open (sound_device_nameR, O_RDONLY/*|O_NONBLOCK*/, 0);                                                            

	if (audio2 == -1)                                                                                
	{                                                                                             
		sprintf(tstring,"Unable open %s for reading. RecordingInit failed.", sound_device_nameR);
		perror (sound_device_nameR);
		MessageBoxErr(tstring);
		return(errors);
	}  

#if defined LINUXAUDIO
	tmp = samplesize;                                                                               
	ioctl(audio2, SNDCTL_DSP_SAMPLESIZE, &samplesize);                                               
	if (tmp != samplesize)                                                                          
	{                                                                                               
		printf("Unable set samplesize = %d. RecordingInit failed.\n", tmp);
		perror("SNDCTL_DSP_SAMPLESIZE");                                                                    
		close(audio2);		
		return(errors);                                                                                  
	}                                                                                               

	if (ioctl(audio2, SNDCTL_DSP_STEREO, &dsp_stereo)==-1)                                          
	{                                                                                               
		printf("Unable to set stereo. RecordingInit failed.\n");                               
		perror(sound_device_nameR);                                                                        
		close(audio2);		
		return(errors);                                                                                      
	}                                                                                               

	if (ioctl(audio2, SNDCTL_DSP_SPEED, &dsp_speed) == -1)                                          
	{                                                                                             
		printf("Unable to set audio speed = %d. RecordingInit failed.\n",dsp_speed);                               
		perror(sound_device_nameR);                                                                        
		close(audio2);
		return(errors);                                                                                  
	}        
	

	if (ioctl (audio2, SNDCTL_DSP_SETFMT, &format) == -1)                                          
	{                                                                                             
		printf("Unable to set audio format. RecordingInit failed.\n");                               
		perror("SNDCTL_DSP_SETFMT");                                                                        
		close(audio2);
		return(errors);                                                                                  
	} 

	return(no_errors);

/* LINUXAUDIO */
#endif

}

int RecordingInit4(void)
{
	int tmp;

	int samplesize = 8;
	int dsp_speed = 44100; 
	int dsp_stereo = 0;


	audio2 = open (sound_device_nameR, O_RDONLY|O_NONBLOCK, 0);                                                            

	if (audio2 == -1)                                                                                
	{                                                                                             
		sprintf(tstring,"Unable open %s for reading. RecordingInit4 failed.", sound_device_nameR);
		perror (sound_device_nameR);
		MessageBoxErr(tstring);
		return(errors);
	}  

	close(audio2);

	audio2 = open (sound_device_nameR, O_RDONLY/*|O_NONBLOCK*/, 0);                                                            

	if (audio2 == -1)                                                                                
	{                                                                                             
		sprintf(tstring,"Unable open %s for reading. RecordingInit4 failed.", sound_device_nameR);
		perror (sound_device_nameR);
		MessageBoxErr(tstring);
		return(errors);
	}  

#if defined LINUXAUDIO
	tmp = samplesize;                                                                               
	ioctl(audio2, SNDCTL_DSP_SAMPLESIZE, &samplesize);                                               
	if (tmp != samplesize)                                                                          
	{                                                                                               
		printf("Unable set samplesize = %d. RecordingInit4 failed.\n", tmp);
		perror("SNDCTL_DSP_SAMPLESIZE");                                                                    
		close(audio2);		
		return(errors);                                                                                  
	}                                                                                               

	if (ioctl(audio2, SNDCTL_DSP_STEREO, &dsp_stereo)==-1)                                          
	{                                                                                               
		printf("Unable to set stereo. RecordingInit4 failed.\n");                               
		perror(sound_device_nameR);                                                                        
		close(audio2);		
		return(errors);                                                                                      
	}                                                                                               

	if (ioctl(audio2, SNDCTL_DSP_SPEED, &dsp_speed) == -1)                                          
	{                                                                                             
		printf("Unable to set audio speed = %d. RecordingInit4 failed.\n",dsp_speed);                               
		perror(sound_device_nameR);                                                                        
		close(audio2);
		return(errors);                                                                                  
	}        


	return(no_errors);

/* LINUXAUDIO */
#endif

}


int tape_NarisuiGromkostIEsliSlishkomTihoVerniErrors(unsigned char * array, int len)
{
# define kogda_vernut_errors 30

	unsigned char min=255;
	unsigned char max=0;
	int i;


	for (i=0; i<len; i+=5)
	{
		if (min>array[i])min=array[i];
		if (max<array[i])max=array[i];
	}

	message.data1=(void*)(int)(max-min);
	kill(mainpid, SIGUSR2);

	if ((max-min)<kogda_vernut_errors)
		return(errors);

	return(no_errors);
}

void lpf(unsigned char * b, int len)
{
	int i;
	unsigned char la,lb,lc;


	la=b[0];
	lb=b[1];

	for(i=2;i<len;i++)
	{
		lc=b[i];
		b[i]=(unsigned char)((lb*2+la+lc)/4);
		la=lb;
		lb=lc;
	}
}

void inv (unsigned char * b, int len)
{
	int i;

	for(i=0;i<len;i++)
		b[i]=255-b[i];
}


/*  tapeTool */

# define one  1
# define c_zero 0
# define syn  2
# define head 3
# define none 4

# define crc_ok        0

# define crc_failed    1


unsigned char mark;
int g,b;
BOOL test;
int howmuch;
unsigned int new_len=0;
unsigned int new_nsyn=0;
unsigned char bitcounter;
unsigned char bait;
unsigned int bytecounter;
unsigned char prevbit;
unsigned int blockcounter=0;
unsigned char tmpblock[65540];
unsigned char crc;
int good=0;
int bad=0;
BOOL enablebits;
char infobuffer[255];
char msg[100];

unsigned char c_min_len_syn=6;
unsigned char c_max_len_syn=9;
unsigned char c_min_len_zero=10;
unsigned char c_max_len_zero=16;
unsigned char c_min_len_one=17;
unsigned char c_max_len_one=25;
unsigned char c_min_len_header=26;
unsigned char c_max_len_header=33;
unsigned char c_filter=5;

/* ~tapeTool */


char * Crc_Info(void)
{
	unsigned int i;
	unsigned char a;
	char * result="Crc_Info failed. This is bug. Report it.";


	a=tmpblock[2];
	for (i=3;i<=(bytecounter);i++)
		a^=tmpblock[i];

	if(a==tmpblock[bytecounter+1])
	{
		crc=crc_ok;
		if (mark==6)
			result="";
		if (mark==5)
			result="";
		if (mark==4)
			result="Inverted";
		if (mark==1)
			result="Good block";
		if (mark==2)

			result="Good block";
		if (mark==3)
		{
			if ((howmuch&1)>0)
				sprintf(msg,"%d passes",(howmuch+1)/2);
			else
				sprintf(msg,"%d passes, inverted",howmuch/2);
			result=msg;
		}
		g++;
	}
	else
	{
		crc=crc_failed;
		b++;
		if (mark!=6)
			result="Bad block";
		else
			result="Bad CRC !";
	}
	return(result);
}

char * Info(void)
{
	char type='?';
	unsigned int start,leng;
	unsigned char i;
	char name[11]={0};


	if ((tmpblock[2]!=0)&&(tmpblock[2]!=255))
		sprintf(infobuffer,"%s %5d %s",
			"Non-standart block",bytecounter-2,Crc_Info());
	if (tmpblock[2]==0)
	{
		if((tmpblock[3]<=3)&&((bytecounter==19)||(bytecounter==20)||(bytecounter==22)||(bytecounter==21)))
		{
			if(tmpblock[3]==0)type='B';
			if((tmpblock[3]==1)||(tmpblock[3]==2))type='D';
			if(tmpblock[3]==3)type='C';
			for(i=4;i<=13;i++)
			{
				if((tmpblock[i]>=32)&&(tmpblock[i]<=126))
					name[i-4]=tmpblock[i];
				else
					name[i-4]=63;

			}
			leng=tmpblock[14]+256*tmpblock[15];
			start=tmpblock[16]+256*tmpblock[17];
			sprintf(infobuffer,"%s %c %5d %5d %s",
				name,type,start,leng,Crc_Info());
		}
		else
		{
			sprintf(infobuffer,"%s %5d %s",
				"Non-standart block",bytecounter-2,Crc_Info());
		}
	}

	if (tmpblock[2]==255)
	{
		sprintf(infobuffer,"%s %5d %s","..................",
			bytecounter-2,Crc_Info());
	}

	return((char *)infobuffer);
}

void AddBlock(void)
{
	unsigned char llen,hlen;
	ROM_bl_type * newB;


	new_nsyn=0;
	if (bytecounter>=4)
	{
		bytecounter--;
		bytecounter--;
		hlen=(unsigned char)((bytecounter)/256);
		llen=(unsigned char)(bytecounter-(hlen*256));
		tmpblock[0]=llen;
		tmpblock[1]=hlen;

		Info();

		if (test==FALSE)
		{
			if (crc==crc_ok)good++;
			else bad++;


			newB=malloc(sizeof(ROM_bl_type));

			newB->pause=1000;
			newB->len=bytecounter;

			message.data=newB;
			message.data2=malloc(bytecounter);
			memcpy(message.data2, &tmpblock[2], bytecounter);

			kill(mainpid, SIGUSR1);
		}
		else	if (crc==crc_ok)new_len+=bytecounter;
	}
	bytecounter=2;
}

void AddBait(void)
{
	if(bitcounter==128)
	{
		tmpblock[bytecounter]=bait;
		bytecounter++;
	}
	else
	{
		bitcounter=128;
	}
	bait=0;
}

void AddBit(unsigned char data)
{
	/* printf("%d\n", data); */

	if (data==one)
	{
		if(prevbit==head)
		{
			prevbit=head;
			goto LL;
		}
		else
		{
			bait=(unsigned char)(bait+bitcounter);
			if (bitcounter>1)
			{
				bitcounter=(unsigned char)(bitcounter/2);
			}
			else
			{
				bitcounter=128;
				AddBait();
			}
		}
	}
	if ((data==c_zero)||(data==syn))
	{
		if(enablebits==FALSE)
		{
			goto LE;
		}
		else
		{
			if (prevbit==head)
				goto LE;
			if (bitcounter>1)
			{
				bitcounter=(unsigned char)(bitcounter/2);
			}
			else
			{
				bitcounter=128;
				AddBait();
			}
		}
	}
	if (data==head)
	{
		new_nsyn++;
		enablebits=TRUE;
		bitcounter=128;
		bait=0;
		if(prevbit!=head)
		{
			if (new_nsyn>50)
			{
				AddBlock();
				new_nsyn=0;
			}
		}
		bytecounter=2;
	}
	if (data==none)
	{
		enablebits=FALSE;
		bitcounter=128;
		bait=0;
		if (new_nsyn>50)
			AddBlock();
		new_nsyn=0;
		bytecounter=2;
	}
	LE: prevbit=data;
	LL: ;
}

void WorkWithBuffer(unsigned char * buffer,unsigned long filelen)
{
	unsigned long i,prevmax,max;
	unsigned char * farray;
	unsigned char tek1,tek2,tek3,tek4,tek5,bit;


	blockcounter=0;
	good=0; bad=0;

	enablebits=FALSE;
	bitcounter=128;
	bait=0;
	bytecounter=2;
	prevbit=0;
	farray=buffer;
	tek1=farray[0];
	tek2=farray[1];
	tek3=farray[2];
	tek4=farray[3];
	prevmax=0;
	for(i=4;i<filelen;i++){
		tek5=farray[i];
		if((tek2>=tek1)&&(tek3>tek1)&&(tek3>tek2)&&(tek3>=tek4)&&(tek3>=tek5)&&(tek4>=tek5))
		{
			max=i-2;

			if ((max-prevmax)<=c_filter)goto M1;
			if (((max-prevmax)<=c_max_len_header)&&((max-prevmax)>=c_min_len_header))
			{
				bit=head;
			}
			else
			if (((max-prevmax)<=c_max_len_one)&&((max-prevmax)>=c_min_len_one))
			{
				bit=one;
			}
			else
			if (((max-prevmax)<=c_max_len_zero)&&((max-prevmax)>=c_min_len_zero))
			{
				bit=c_zero;
			}
			else
			if (((max-prevmax)<=c_max_len_syn)&&((max-prevmax)>=c_min_len_syn))
			{
				bit=syn;
			}
			else bit=none;

			AddBit(bit);
			prevmax=max;
			M1:  ;
		}
		tek1=tek2;
		tek2=tek3;
		tek3=tek4;
		tek4=tek5;
	}
	AddBit(none);
}

void WorkWithBuffer2(unsigned char * buffer, unsigned long filelen)
{
	unsigned long i,prevmax,max;

	unsigned char * farray;
	unsigned char tek1,tek2,tek3,tek4,tek5,bit;


	mark=6;
	test=FALSE; 
	

	blockcounter=0;
	good=0; bad=0;

	enablebits=FALSE;
	bitcounter=128;
	bait=0;
	bytecounter=2;

	prevbit=0;
	farray=buffer;
	tek1=farray[0];
	tek2=farray[1];
	tek3=farray[2];
	tek4=farray[3];
	prevmax=0;
	for(i=4;i<filelen;i++){
		tek5=farray[i];
		if((tek2>=tek1)&&(tek3>tek1)&&(tek3>tek2)&&(tek3>=tek4)&&(tek3>=tek5)&&(tek4>=tek5))
		{
			max=i-2;

			if ((max-prevmax)<=c_filter)goto M1;
			if (((max-prevmax)<=(c_max_len_header-2))&&((max-prevmax)>=(c_min_len_header-2)))
			{
				bit=head;
			}
			else
			if (((max-prevmax)<=(c_max_len_one-2))&&((max-prevmax)>=(c_min_len_one-2)))
			{
				bit=one;
			}
			else
			if (((max-prevmax)<=c_max_len_zero)&&((max-prevmax)>=c_min_len_zero))
			{
				bit=c_zero;
			}
			else
			if (((max-prevmax)<=c_max_len_syn)&&((max-prevmax)>=c_min_len_syn))
			{
				bit=syn;
			}
			else bit=none;

			AddBit(bit);
			prevmax=max;
			M1:  ;
		}
		tek1=tek2;
		tek2=tek3;
		tek3=tek4;
		tek4=tek5;
	}
	AddBit(none);
}

void WorkWithBuffer1(unsigned char * buffer, unsigned long filelen)
{
	int l1=0,l2=0;
	unsigned char * my_buffer;


	my_buffer=(unsigned char *)malloc(filelen);
	memcpy(my_buffer,buffer,filelen); 	

	new_len=0;
	WorkWithBuffer(my_buffer,filelen);
	l1=new_len;

	new_len=0;

	lpf(my_buffer,filelen);
	WorkWithBuffer(my_buffer,filelen);
	l2=new_len;


	if (l1!=l2){b=1;g=0;}

	free(my_buffer);
}

void RecoveryTape(int tape_RAM, unsigned char * tape_buffer)
{
	int i;
	int fpasses=2; 
	int passes=7;

	unsigned char * buffer_normal;
	unsigned char * buffer_inverted;


	buffer_normal=(unsigned char *)malloc(tape_RAM);
	buffer_inverted=(unsigned char *)malloc(tape_RAM);

	memcpy(buffer_normal,tape_buffer,tape_RAM); 	
	memcpy(buffer_inverted,tape_buffer,tape_RAM); 	
	inv(buffer_inverted,tape_RAM);
	

	for (i=1;i<=fpasses;i++)
	{
		lpf(buffer_normal,tape_RAM);
		lpf(buffer_inverted,tape_RAM);
	}

	mark=5;
	g=0;b=0;
	test=TRUE; 
	WorkWithBuffer1(buffer_normal,tape_RAM);
	if((g>0)&&(b==0))
	{
		test=FALSE;

		WorkWithBuffer(buffer_normal,tape_RAM);
		goto LQ;
	}

	mark=4;
	g=0;b=0;
	test=TRUE; 
	WorkWithBuffer1(buffer_inverted,tape_RAM);
	if((g>0)&&(b==0))
	{
		test=FALSE;
		WorkWithBuffer(buffer_inverted,tape_RAM);
		goto LQ;
	}

	mark=3;
	for (i=1;i<=passes*2;i++)
	{
		lpf(buffer_normal,tape_RAM);
		lpf(buffer_inverted,tape_RAM);
		

		g=0;b=0;
		test=TRUE;
		WorkWithBuffer1(buffer_normal,tape_RAM);

		if((g>0)&&(b==0))
		{
			howmuch=i; 
			test=FALSE;
			WorkWithBuffer(buffer_normal,tape_RAM);
			goto LQ;
		}

		i++;

		g=0;b=0;
		test=TRUE;
		WorkWithBuffer1(buffer_inverted,tape_RAM);

		if((g>0)&&(b==0))
		{
			howmuch=i; 
			test=FALSE;
			WorkWithBuffer(buffer_inverted,tape_RAM);
			goto LQ;
		}
	}

	mark=1;
	lpf(buffer_normal,tape_RAM);
	test=FALSE;
	WorkWithBuffer(buffer_normal,tape_RAM);

LQ:
	/* CreateTapFileFromBlocksArray("temp.tap"); */


	free(buffer_normal);
	free(buffer_inverted);
}

# define size_bf (8*1024*1024)
char buffer[size_bf];
int pos=0;
int readed;

int rec_SC_thread_func(void * arg)
{
# define size_SC_base 4000
# define size_SC 1000

	unsigned short rec_buf[size_SC_base];
	int i;


	while (TRUE)
	{
		if ((pos+size_SC+2/*dlya garantii*/)>size_bf)
		{
			printf("rec_SC_thread_func : Too large block !\n");			
			/* RecoveryTape(pos+readed, buffer); */
			pos=0;
		}

		readed=read(audio2, rec_buf, size_SC_base);

		readed/=2;

		for (i=0; i<readed; i+=2)
			buffer[pos+i/2]=(unsigned char)((rec_buf[i]/256+rec_buf[i+1]/256)/2);

		readed/=2;

		if (tape_NarisuiGromkostIEsliSlishkomTihoVerniErrors(&buffer[pos],readed)==errors)
		{
			RecoveryTape(pos+readed, buffer);
			pos=0;
		}
		else
			pos+=readed;
	}	
}

void tape_DirectMIC(w, client_data, state)
	Widget w;
	XtPointer client_data;
	XmToggleButtonCallbackStruct * state;
{
	if (!state->set)
	{
		direct_mic=0;
		DirectMicDrop();
	}
	else
	{
		direct_mic=1;
		direct_mic_pos=0;
	}
}

void NajatKnopku(Widget W, int Najat)
{
	if (!W) return;

	n=0;
	XtSetArg(args[n], XmNset, Najat); n++;
	XtSetValues(W, args, n); 
}

char rec_SC_stack[16384];
void tape_sc_ROM_begin(w, client_data, state)
	Widget w;
	XtPointer client_data;
	XmToggleButtonCallbackStruct * state;
{
	if (!state->set)
	{
		kill(tape_sc_ROM_pid, SIGSTOP);
		RecoveryTape(pos+readed, buffer);
		pos=0;

		close(audio2);

		EnableWidget(tape_sc_rec);

		XClearWindow(display, tape_sc_lev_win);

		return;
	}

	if (RecordingInit()==no_errors)
	{
		if (!tape_sc_ROM_pid)
			tape_sc_ROM_pid=CreateThread(rec_SC_thread_func, rec_SC_stack);
		else
			kill(tape_sc_ROM_pid, SIGCONT);

		DisableWidget(tape_sc_rec);
	}
	else
		NajatKnopku(tape_sc_ROMb, False);
}


#define DirectFragLen 8820
#define DirectBufLen (65536*256)

unsigned char DirectFragBuffer[DirectFragLen];
unsigned char DirectBuffer[DirectBufLen/8];
unsigned int DirectPos=0;

int DirectThreadFunc(void * arg)
{
	unsigned int i;


	while (TRUE)
	{
		read(audio2, DirectFragBuffer, DirectFragLen);

		if ((DirectPos+DirectFragLen)>=DirectBufLen)
		{
			printf("DirectBuffer overflow !!!\n");
			DirectPos=0;
		}

		for (i=0; i<DirectFragLen; i++)
			b2bset(DirectBuffer, DirectPos+i, (DirectFragBuffer[i]<128)?0:1);

		tape_NarisuiGromkostIEsliSlishkomTihoVerniErrors(DirectFragBuffer,DirectFragLen);

		DirectPos+=DirectFragLen;
	}
}

void Direct(w, client_data, state)
	Widget w;
	XtPointer client_data;
	XmToggleButtonCallbackStruct * state;
{
	direct_recT direct;
	unsigned int len, used;


	if (state->set)
	{
		if (RecordingInit4()==no_errors)
		{
			if (!DirectPid)
				DirectPid=CreateThread(DirectThreadFunc, DirectStack);
			else
				kill(DirectPid, SIGCONT);

			DirectPos=0;
			DisableWidget(tape_sc_ROMb);
		}
		else
			NajatKnopku(tape_sc_ROMb, False);
	}
	else
	{
		kill(DirectPid, SIGSTOP);
		close(audio2);

		len=DirectPos/8;
		used=DirectPos-len*8;
		len++;

		direct.TS=79l;
		direct.pause=0;
		direct.used=used;
		direct.l3=(len&0xFF0000)/65536;
		direct.l2=(len&0x00FF00)/256;
		direct.l1= len&0x0000FF;

		AddTapeBlock("", 0x15, len, DirectBuffer, sizeof(direct), &direct, 1);
		DirectPos=0;

		EnableWidget(tape_sc_ROMb);

		XClearWindow(display, tape_sc_lev_win);
	}
}

char DescriptionUnknown [255];
char * Description(unsigned char id)
{
	switch (id)
	{
		case 0x10: return("ROM block");
		case 0x11: return("Turbo block");
		case 0x12: return("Pure tone");
		case 0x13: return("Pulses");
		case 0x14: return("Pure data");
		case 0x15: return("Direct rec");
		case 0x20: return("Pause");
		case 0x21: return("Group");
		case 0x22: return("Group End");
		case 0x23: return("Jump");
		case 0x24: return("Loop Start");
		case 0x25: return("Loop End");
		case 0x26: return("Call Seq");
		case 0x27: return("Ret from Seq");
		case 0x30: return("Description");
		case 0x31: return("Message");
		case 0x32: return("Archive Info");
		case 0x33: return("Hardware");
		case 0x35: return("Custom Info");
		case 'Z' : return("Version");
	}

	sprintf(DescriptionUnknown,"UNKNOWN=0x%X",id);
	return (DescriptionUnknown);
}

char DetailsS[255];
char * Details(unsigned char id, unsigned int ilen, void * info, unsigned int len, unsigned char * data)
{
	ROM_bl_type * ROM;
	Pure_toneT * tone;
	Pure_dataT * pd;
	turbo_block_type * turbo;
	zxtapeT * zxtape;
	char * info1;
	unsigned short * len16;
	direct_recT * direct;
	signed short * Signed;

	char string0x12[0x12];


	bzero(DetailsS, sizeof(DetailsS));

	switch (id)
	{
		case 0x10: 
			ROM=info;

			mark=6;
			bytecounter=ROM->len;
			memcpy(&tmpblock[2], data, ROM->len);
			Info();

			sprintf(tstring, " Pa=%d", ROM->pause);
			sprintf(DetailsS, "%s%s", infobuffer, tstring);

			break;
		case 0x11: 
			turbo=info;

			sprintf(DetailsS,"P=%d SF=%d SS=%d Z=%d O=%d PT=%d U=%d Pa=%d", 
				turbo->pilotL,	
				turbo->syncFL,
				turbo->syncSL,
				turbo->zeroL,

				turbo->oneL,
				turbo->pilot_toneL_inPulses,
				turbo->used_bits,
				turbo->pause
			);

			break;
		case 0x12: 
			tone=info;
			sprintf(DetailsS, "Length of pulse=%d Number of pulses=%d", tone->len, tone->n);
			break;
		case 0x13:
			sprintf(DetailsS, "Number of pulses=%d", len/2);
			break;
		case 0x14: 
			pd=info;
			sprintf(DetailsS,"ZERO=%d ONE=%d Used=%d Pause=%d", 
				pd->z, pd->o, pd->used,	pd->pause);
			break;
		case 0x15: 
			direct=info;		
			sprintf(DetailsS, "T_states_per_sample=%d Pause=%d Used=%d", direct->TS, direct->pause, direct->used);
			break;
		case 0x20:
			len16=info;
			sprintf(DetailsS,"Value = %d", *len16);
			break;
		case 0x21:
			memcpy(DetailsS, data, len);
			break;
		case 0x22:
			return("<MUST BE HIDDEN>");
		case 0x23: 
			Signed=info;
			sprintf(DetailsS,"Value = %d", *Signed);
			break;
		case 0x24: 
			len16=info;
			sprintf(DetailsS,"Number of repetitions = %d", *len16);
			break;
		case 0x25:
			return("");
			/* case 0x26: */
			/* case 0x27: */
		case 0x30: 
			memcpy(DetailsS, data, len);
			break;
			/* case 0x31: */
		case 0x32: 
			info1=tape_GAInfo1st(data);
			strcpy(DetailsS, info1);
			free(info1);
			break;
		case 0x33: 
			return("Hardware Type");
		case 0x35:
			bzero(string0x12, sizeof(string0x12));
			memcpy(string0x12, info, 0x10);
			sprintf(DetailsS,"%s -   <IGNORED>", string0x12);
			break;
		case 'Z' :
			zxtape=info;
			sprintf (DetailsS, ".TZX version %d.%d", zxtape->major, zxtape->minor);
			break;

		default :
			sprintf(DetailsS,"UNKNOWN=0x%X",id);
	}

	return (DetailsS);
}

void AddTapeBlock(char * arg1, unsigned char id, unsigned int len, unsigned char * data, int ilen, void * info, int show)

{
# define des_len 12
# define det_len 55

	tape_struct * temp;
	XmString str;

	char des[des_len+1]={0};
	char det[det_len+1]={0};
	char string[255];

	int n, vn;

	tape_struct * last;


	temp=malloc(sizeof(tape_struct));
	temp->id=id;
	temp->len=len;
	temp->data1=malloc(len);
	memcpy(temp->data1, data, len);
	temp->next=NULL;
	temp->ilen=ilen;
	temp->info=malloc(ilen);
	memcpy(temp->info, info, ilen);

	strncpy(des, Description(id), des_len);

	if (!strlen(arg1))
		strncpy(det, Details(id, ilen, info, len, data), det_len);
	else
		strncpy(det, arg1, det_len);

	sprintf(string,"%-12s %8d %-55s",des,len,det);

	if (show)
	{
		str = XmStringCreateSimple(string);
		XmListAddItemUnselected(tape_lb, str, 0);
		XmStringFree(str);

		XtVaGetValues(tape_lb, XmNitemCount, &n, XmNvisibleItemCount, &vn, NULL);
		temp->position=n;

		if (vn<n)
			XmListSetPos(tape_lb, n-vn+1);
	}
	else
		temp->position=0;

	if (tapes==NULL)
		tapes=temp;
	else
	{
		last=tapes;
		while (TRUE)
		{
			if (last->next==NULL)
			{
				last->next=temp;
				return;
			}

			last=last->next;

			if (last==NULL)
				ExitWithError(-1,"AddTapeBlock : last==NULL. This bug. Report it.");
		}
	}
}

char * tape_GAInfo(unsigned char * arg)
{
	char * rv;
	int l=1;

	char tt[255];
	char * id2s;
	unsigned char id, lt;
	unsigned char n;
	char tts[100];


	rv=malloc(0xffff);
	bzero(rv, 0xffff);

	n=arg[0];


	while (n--)
	{
		id=arg[l];
		lt=arg[++l]; 

		bzero(tt,sizeof(tt));
		strncpy(tt, &arg[++l], lt);
		strcat(tt, "\n");
		l+=lt;

		switch(id)
		{
			case 0:   id2s="Full Title : "; break;
			case 1:   id2s="Software House / Publisher : "; break;
			case 2:   id2s="Author(s) : "; break;
			case 3:   id2s="Year of Publication : "; break;
			case 4:   id2s="Language : "; break;
			case 5:   id2s="Game/Utility Type : "; break;
			case 6:   id2s="Price : "; break;
			case 7:   id2s="Protection Scheme / Loader : "; break;
			case 8:   id2s="Origin : "; break;
			case 255: id2s="Comment(s) : "; break;

			default:  
				sprintf(tts, "<UNKNOWN (%x)> : ",id); 
				id2s=tts; 
				break;
		}

		strcat(rv, id2s);
		strcat(rv, tt);
	}	

	rv[strlen(rv)-1]=0;

	return(rv);
}

char * tape_GAInfo1st(unsigned char * arg)
{
	char * rv;
	int l=1;
	char tt[255];
	char * id2s;
	unsigned char id, lt;
	unsigned char n;
	char tts[100];


	rv=malloc(300);
	bzero(rv, 300);

	n=arg[0];

	id=arg[l];
	lt=arg[++l]; 
	

	bzero(tt,sizeof(tt));
	strncpy(tt, &arg[++l], lt);

	switch(id)
	{
		case 0:   id2s="Full Title : "; break;
		case 1:   id2s="Software House / Publisher : "; break;
		case 2:   id2s="Author(s) : "; break;
		case 3:   id2s="Year of Publication : "; break;
		case 4:   id2s="Language : "; break;
		case 5:   id2s="Game/Utility Type : "; break;
		case 6:   id2s="Price : "; break;
		case 7:   id2s="Protection Scheme / Loader : "; break;
		case 8:   id2s="Origin : "; break;
		case 255: id2s="Comment(s) : "; break;

		default:  
			sprintf(tts, "<UNKNOWN (%x)> : ",id); 
			id2s=tts; 
			break;
	}

	strcat(rv, id2s);
	strcat(rv, tt);

	if (n>1) strcat(rv, " ...");


	return(rv);
}

void FreeTape(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	tape_struct * last;
	tape_struct * f;


	if (tapes==NULL) return;

	tape_pos=tape_len=0; 
	showQTape=0;
	EnableWidget(tape_lb);

	last=tapes;

	while (TRUE)
	{
		if (last->len) free(last->data1);
		if (last->ilen) free(last->info);

		if (last->next==NULL)
		{
			free(last);
			tapes=NULL;
			XmListDeleteAllItems(tape_lb);

			DisableWidget(tape_play);
			DisableWidget(tape_stop);
			DisableWidget(tape_pause);
			DisableWidget(tape_delete);
			DisableWidget(tape_view);

			tape_paused=0;

			return;
		}

		f=last;
		last=f->next;
		free(f);
	}
}

int GetTapePos(tape_struct * arg)
{
	tape_struct * tape;

	tape=tapes;

	while (TRUE)
	{
		if (tape==arg) return(tape->position);
		tape=tape->next;

		if (tape==NULL)
		{
			MessageBoxErr("GetTapePos failed. This is bug. Report it.");
			return(-1);
		}
	}
}

void tape_SetActiveAndPause(tape_struct * arg)
{
	int pos;


	if (!arg) return;

	pos=GetTapePos(arg);

	EnsureVisibleAndSelect(pos);

	tape_next=arg;

	tape_IsPlayable(arg);

	DisableWidget(tape_pause);
	DisableWidget(tape_stop);

	tape_pos=tape_len=0;
	showQTape=0;
}

char hinfo[65536*2];
char * tape_hinfo(unsigned char len, hardwareT * h)
{
	unsigned short value;
	unsigned char i=0;
	char * hardware;
	char Uhardware[255];
	char string[512];
	char * vdecode;
	char Uvdecode[255];


	bzero(hinfo, sizeof(hinfo));

	while (TRUE)
	{
		if (len==0) return(hinfo);

		value=h[i].type*256+h[i].id;

		switch (value)
		{
			case 0x0000: hardware="ZX Spectrum 16k"; break;
			case 0x0001: hardware="ZX Spectrum 48k, Plus"; break;
			case 0x0002: hardware="ZX Spectrum 48k ISSUE 1";  break;	
			case 0x0003: hardware="ZX Spectrum 128k (Sinclair)"; break;
			case 0x0004: hardware="ZX Spectrum 128k +2 (Grey case)"; break;
			case 0x0005: hardware="ZX Spectrum 128k +2A, +3"; break;
			case 0x0006: hardware="Timex Sinclair TC-2048"; break;
			case 0x0007: hardware="Timex Sinclair TS-2068"; break;
			case 0x0008: hardware="Pentagon 128"; break;
			case 0x0009: hardware="Sam Coupe"; break;
			case 0x000a: hardware="Didaktik M"; break;
			case 0x000b: hardware="Didaktik Gama"; break;
			case 0x000c: hardware="ZX-81 or TS-1000 with  1k RAM"; break;
			case 0x000d: hardware="ZX-81 or TS-1000 with 16k RAM or more"; break;
			case 0x000e: hardware="ZX Spectrum 128k, Spanish version"; break;
			case 0x000f: hardware="ZX Spectrum, Arabic version"; break;
			case 0x0010: hardware="TK 90-X"; break;

			case 0x0011: hardware="TK 95"; break;
			case 0x0012: hardware="Byte"; break;
			case 0x0013: hardware="Elwro"; break;
			case 0x0014: hardware="ZS Scorpion"; break;
			case 0x0015: hardware="Amstrad CPC 464"; break;
			case 0x0016: hardware="Amstrad CPC 664"; break;
			case 0x0017: hardware="Amstrad CPC 6128"; break;
			case 0x0018: hardware="Amstrad CPC 464+"; break;
			case 0x0019: hardware="Amstrad CPC 6128+"; break;
			case 0x001a: hardware="Jupiter ACE"; break;
			case 0x001b: hardware="Enterprise"; break;
			case 0x001c: hardware="Commodore 64"; break;
			case 0x001d: hardware="Commodore 12"; break;

			case 0x0100: hardware="Microdrive"; break;
			case 0x0101: hardware="Opus Discovery"; break;
			case 0x0102: hardware="Disciple"; break;
			case 0x0103: hardware="Plus-D"; break;
			case 0x0104: hardware="Rotronics Wafadrive"; break;
			case 0x0105: hardware="TR-DOS (BetaDisk)"; break;
			case 0x0106: hardware="Byte Drive"; break;
			case 0x0107: hardware="Watsford"; break;
			case 0x0108: hardware="FIZ"; break;
			case 0x0109: hardware="Radofin"; break;
			case 0x010a: hardware="Didaktik disk drive"; break;
			case 0x010b: hardware="BS-DOS (MB-02)"; break;
			case 0x010c: hardware="ZX Spectrum +3 disk drive"; break;
			case 0x010d: hardware="JLO (Oliger) disk interface break;";
			case 0x010e: hardware="FDD3000"; break;
			case 0x010f: hardware="Zebra disk drive"; break;
			case 0x0110: hardware="Ramex Millenia"; break;
			case 0x0111: hardware="Larken"; break;

			case 0x0200: hardware="Sam Ram"; break;
			case 0x0201: hardware="Multiface"; break;
			case 0x0202: hardware="Multiface 128k"; break;
			case 0x0203: hardware="Multiface +3"; break;
			case 0x0204: hardware="MultiPrint"; break;
			case 0x0205: hardware="MB-02 ROM/RAM expansion"; break;

			case 0x0300: hardware="Classic AY hardware (compatible with 128k ZXs)"; break;
			case 0x0301: hardware="Fuller Box AY sound hardware"; break;
			case 0x0302: hardware="Currah microSpeech"; break;
			case 0x0303: hardware="SpecDrum"; break;
			case 0x0304: hardware="AY ACB stereo (A+C=left, B+C=right); Melodik"; break;
			case 0x0305: hardware="AY ABC stereo (A+B=left, B+C=right)"; break;

			case 0x0400: hardware="Kempston Joystick"; break;
			case 0x0401: hardware="Cursor, Protek, AGF Joysticks"; break;
			case 0x0402: hardware="Sinclair 2 Left  (keys 12345) Joystick"; break;
			case 0x0403: hardware="Sinclair 1 Right (keys 67890) Joystick"; break;
			case 0x0404: hardware="Fuller Joystick"; break;
				

			case 0x0500: hardware="AMX mouse"; break;
			case 0x0501: hardware="Kempston mouse"; break;

			case 0x0600: hardware="Trickstick"; break;
			case 0x0601: hardware="ZX Light Gun"; break;
			case 0x0602: hardware="Zebra Graphics Tablet"; break;

			case 0x0700: hardware="ZX Interface 1 Serial Port"; break;
			case 0x0701: hardware="ZX Spectrum 128k Serial Port"; break;

			case 0x0800: hardware="Kempston S Parallel Port"; break;
			case 0x0801: hardware="Kempston E Parallel Port"; break;
			case 0x0802: hardware="ZX Spectrum 128k +2A, +3 Parallel Port"; break;
			case 0x0803: hardware="Tasman Parallel Port"; break;
			case 0x0804: hardware="DK'Tronics Parallel Port"; break;
			case 0x0805: hardware="Hilderbay Parallel Port"; break;
			case 0x0806: hardware="INES Printerface Parallel Port"; break;
			case 0x0807: hardware="ZX LPrint Interface 3 Parallel Port"; break;
			case 0x0808: hardware="MultiPrint Parallel Port"; break;
			case 0x0809: hardware="Opus Discovery Parallel Port"; break;
			case 0x080a: hardware="Standard 8255 chip with ports 31,63,95 Parallel Port"; break;

			case 0x0900: hardware="ZX Printer, Alphacom 32 & compatibles"; break;
			case 0x0901: hardware="Generic Printer"; break;
			case 0x0902: hardware="EPSON Compatible Printer"; break;

			case 0x0a00: hardware="VTX 5000 modem"; break;
			case 0x0a01: hardware="T/S 2050 or Westridge 2050 modem"; break;

			case 0x0b00: hardware="RD Digital Tracer"; break;
			case 0x0b01: hardware="DK'Tronics Light Pen"; break;
			case 0x0b02: hardware="British MicroGraph Pad"; break;

			case 0x0c00: hardware="ZX Interface 1 Network adapter"; break;

			case 0x0d00: hardware="Keypad for ZX Spectrum 128k"; break;

			case 0x0e00: hardware="Harley Systems ADC 8.2 "; break;
			case 0x0e01: hardware="Blackboard Electronics AD/DA converter"; break;

			case 0x0f00: hardware="Orme Electronics EPROM Programmer"; break;


			default :
				sprintf (Uhardware, "UNKNOWN HARDWARE : Hardware Type =%d Hardware ID =%d", h[i].type, h[i].id);
				hardware = Uhardware;
		}

		switch (h[i].value)
		{
			case 0: vdecode = "00 - The tape RUNS on this machine or with this hardware,but may or\nmay not use the hardware or special features of the machine."; break ;
			case 1: vdecode = "01 - The tape USES the hardware or special features of the machine,\nsuch as extra memory or a sound chip."; break;
			case 2: vdecode = "02 - The tape RUNS but it DOESN'T use the hardware or special\nfeatures of the machine."; break;
			case 3: vdecode = "03 - The tape DOESN'T RUN on this machine or with this hardware."; break;

			default :
				sprintf (Uvdecode, "UNKNOWN VALUE = %d", h[i].value);
				vdecode = Uvdecode;
		}

		if (len!=1)
			sprintf(string, "%s :\n%s\n-----\n", hardware, vdecode);
		else
			sprintf(string, "%s :\n%s", hardware, vdecode);

		strcat(hinfo, string);

		len--; i++;
	}
}

hardwareT hardware [255];
void ReadTZX(char * filename)
{
	int fil;
	unsigned char id;
	int readed;

	char message[255];
	unsigned char len8;
	unsigned short len16;

	ROM_bl_type ROMb;
	unsigned char * ainfo;
	char * ainfop;

	int show=1;

	char temp[256];

	Pure_toneT pure_tone;
	Pure_dataT pd;
	turbo_block_type turbo;
	zxtapeT zxtape;
	direct_recT direct;

	int len;

	unsigned char * data;
	signed short jv;

	unsigned int len32;
	void * ignored;


	FreeTape(NULL, NULL, NULL);

	fil=open(filename, O_RDONLY);

	if (fil==-1)
	{
		sprintf(tstring,"ReadTZX : %s - can't open file", filename);
		MessageBoxErr(tstring);
		return;

	}

	while (TRUE)
	{
		readed=read(fil, &id, 1);
		if (readed==0) 
		{
			close(fil);
			tape_type="tzx";
			sprintf(tape_filename,filename);
			tape_SetActiveAndPause(tapes);
			return;
		}

		switch (id) 
		{
			case 0x30:
				read(fil, &len8, 1);
				bzero(message, sizeof(message));
				read(fil,message, len8);
				printf("%s\n", message);
				AddTapeBlock("", id, len8, message, 0, NULL, show);
				break;

			case 0x10:
				read(fil, &ROMb.pause, 2);
				read(fil, &ROMb.len, 2);

				data=malloc(ROMb.len);
				read(fil, data, ROMb.len);

				AddTapeBlock("", id, ROMb.len, data, sizeof(ROMb), &ROMb, show);
				break;

			case 0x11:
				read(fil, &turbo.pilotL, 2);
				read(fil, &turbo.syncFL, 2);
				read(fil, &turbo.syncSL, 2);
				read(fil, &turbo.zeroL, 2);
				read(fil, &turbo.oneL, 2);
				read(fil, &turbo.pilot_toneL_inPulses, 2);
				read(fil, &turbo.used_bits, 1);
				read(fil, &turbo.pause, 2);
				read(fil, &turbo.l1, 1);
				read(fil, &turbo.l2, 1);
				read(fil, &turbo.l3, 1);

				len=turbo.l1+turbo.l2*256+turbo.l3*65536;

				data=malloc(len);
				read(fil, data, len);

				AddTapeBlock("", id, len, data, sizeof(turbo), &turbo, show);
				break;

			case 0x32:
				read(fil,&len16,2);
				ainfo=malloc(len16);
				read(fil,ainfo,len16);

				ainfop=tape_GAInfo(ainfo);
				printf("%s\n\n",ainfop);

				AddTapeBlock("", id, len16, ainfo, 0, NULL, show);

				free (ainfop);
				break;

			case 0x21:
				read(fil,&len8,1);

				bzero(temp, sizeof(temp));
				read(fil,&temp,len8);

				AddTapeBlock("", id, len8, temp, 0, NULL, show);

				show=0;
				break;

			case 0x22:
				AddTapeBlock("", id, 0, NULL, 0, NULL, show);

				show=1;
				break;

			case 0x12:
				read(fil, &pure_tone, sizeof(pure_tone));

				AddTapeBlock("", id, 0, NULL, sizeof(pure_tone), &pure_tone,  show);
				break;

			case 0x13:
				read(fil,&len8,1);

				data=malloc((unsigned short)(len8*2));
				read(fil, data, (unsigned short)(len8*2));

				AddTapeBlock("", id, (unsigned short)(len8*2), data, 0, NULL, show);

				break;

			case 0x14:
				read(fil, &pd.z, 2);
				read(fil, &pd.o, 2);
				read(fil, &pd.used, 1);
				read(fil, &pd.pause, 2);
				read(fil, &pd.l1, 1);
				read(fil, &pd.l2, 1);
				read(fil, &pd.l3, 1);

				len=pd.l1+pd.l2*256+pd.l3*65536;

				data=malloc(len); 
				read(fil, data, len);

				AddTapeBlock("", id, len, data, sizeof(pd), &pd, show);
				break;

			case 0x24:
				read(fil, &len16, 2);

				AddTapeBlock("", id, 0, NULL, 2, &len16, show);
				break;

			case 0x25:
				AddTapeBlock("", id, 0, NULL, 0, NULL, show);
				break;

			case 0x20:
				read(fil, &len16, 2);

				AddTapeBlock("", id, 0, NULL, 2, &len16, show);
				break;

			case 0x23:
				read(fil, &jv, 2);

				AddTapeBlock("", id, 0, NULL, 2, &jv, show);
				break;

			case 0x35:
				bzero(temp, sizeof(temp));
				read(fil, temp, 0x10);
				read(fil, &len32,  4);

				ignored=malloc(len32);
				read(fil, ignored, len32);

				AddTapeBlock("", id, len32, ignored, 0x10, temp,  show);
				break;

			case 0x33:
				read(fil, &len8, 1);
				read(fil, hardware, len8*3);

				ainfo=tape_hinfo(len8, hardware);
				printf("%s\n\n",ainfo);

				AddTapeBlock("", id, len8*3, (void *)hardware, 0, NULL, show);
				break;

			case 'Z':
				lseek(fil,7,SEEK_CUR);
				read(fil, &zxtape, 2);

				sprintf (tstring, ".TZX version %d.%d", zxtape.major, zxtape.minor);
				printf("%s\n", tstring);

				AddTapeBlock("", id, 0, NULL, 2, &zxtape, show);
				break;

			case 0x15:
				read(fil, &direct.TS, 2);
				read(fil, &direct.pause, 2);
				read(fil, &direct.used, 1);
				read(fil, &direct.l1, 1);
				read(fil, &direct.l2, 1);
				read(fil, &direct.l3, 1);

				len=direct.l1+direct.l2*256+direct.l3*65536;

				data=malloc(len);
				read(fil, data, len);

				if ((direct.TS!=158)&&(direct.TS!=79))
				{
					sprintf(tstring,"Number of T states per sample = %d unsupported. Supported values are 158 and 79.", direct.TS);
					MessageBoxErr(tstring);
				}
				else
					AddTapeBlock("", id, len, data, sizeof(direct), &direct, show);

				break;

			default : 
				sprintf(tstring,"ReadTZX : unknown block ID=#%X", id);
				MessageBoxErr(tstring);
				return;
		}
	}
}

void ReadTAP(char * filename)
{
	unsigned short len;
	ROM_bl_type rom;
	unsigned int readed;
	unsigned char data[65536];

	int fil;


	FreeTape(NULL, NULL, NULL);

	fil=open(filename, O_RDONLY);

	if (fil==-1)
	{
		sprintf(tstring,"ReadTAP : %s - can't open file", filename);
		MessageBoxErr(tstring);
		return;
	}

	while (TRUE)
	{
		readed=read(fil, &len, 2);

		if (readed<2)
		{
			close(fil);
			tape_type="tap";
			sprintf(tape_filename,filename);
			tape_SetActiveAndPause(tapes);
			return;
		}

		readed=read(fil, data, len);

		if (readed!=len)
		{
			close(fil);
			sprintf(tstring,"ReadTAP %s : Corrupted file !", filename);
			MessageBoxErr(tstring);
			return;
		}

		if (len)
		{
			rom.len=len;
			rom.pause=1000;

			AddTapeBlock("", 0x10, len, data, sizeof(rom), &rom, 1);
		}
		else
			printf("Zero-length Block !\n");
	}
}


typedef struct {                                                                                              

	unsigned short type;                                                         
	unsigned short channels;                                                             
	unsigned int SamplesPerSec;                                                        
	unsigned int AvgBytesPerSec;                                                       
	unsigned short align;                                                                             
	unsigned short bits;                                                              
} IDWave;  

void ReadWAV(char * filename)
{
	IDWave id;
	int fil;
	unsigned int len32;

	signed short data16;
	unsigned char data8;
	unsigned int i;
	unsigned char * data;
	unsigned int true_len;

	signed short v161, v162;
	unsigned char v81,  v82;

	unsigned char bit;

	unsigned int counter=0;

	direct_recT direct;

	unsigned char used=0;


	FreeTape(NULL, NULL, NULL);

	fil=open(filename, O_RDONLY);

	if (fil==-1)
	{
		sprintf(tstring,"ReadWAV : %s - can't open file", filename);
		MessageBoxErr(tstring);
		return;
	}	

	lseek(fil, 0x14, SEEK_SET);
	read(fil, &id.type, sizeof(id.type));
	read(fil, &id.channels, sizeof(id.channels));
	read(fil, &id.SamplesPerSec, sizeof(id.SamplesPerSec));
	lseek(fil, 6, SEEK_CUR);
	read(fil, &id.bits, sizeof(id.bits));

	if (id.type!=1)
	{
		MessageBoxErr("ReadWAV : Only PCM files supported !");
		close(fil);
		return;
	}

	if ((id.bits!=8)&&(id.bits!=16))
	{
		sprintf(tstring,"ReadWAV : bits = %d unsupported. Only 8 and 16 bit files supported !", id.bits);

		MessageBoxErr(tstring);
		close(fil);
		return;
	}

	if ((id.channels!=2)&&(id.channels!=1))
	{
		MessageBoxErr("ReadWAV : Only MONO and STEREO files supported !");
		close(fil);
		return;
	}

	if ((id.SamplesPerSec!=11025)&&(id.SamplesPerSec!=44100)&&(id.SamplesPerSec!=22050))
	{
		sprintf(tstring, "SamplesPerSec=%d unsupported. Supported SamplesPerSec are : 11025, 22050, 44100", id.SamplesPerSec);

		MessageBoxErr(tstring);
		close(fil);
		return;
	}

	lseek(fil, 4, SEEK_CUR);
	read(fil, &len32, sizeof(len32));

	true_len=len32;
	if (id.SamplesPerSec==11025) true_len*=2;
	if (id.bits==16) { true_len/=2; len32/=2; } 
	if (id.channels==2) { true_len/=2; len32/=2; } 

	true_len/=8;
	true_len++;


	data=malloc(true_len);
	if (data==NULL)
	{
		MessageBoxErr("ReadWAV : malloc failed. This is bug. Report it.");
		return;
	}

	for (i=0; i<len32; i++)
	{
		if (id.channels==1)
		{
			if (id.bits==16) read (fil, &data16, 2);
			else read (fil, &data8, 1);
		}
		else
		{
			if (id.bits==16)
			{
				read (fil, &v161, 2);
				read (fil, &v162, 2);
				data16=v161/2+v162/2;
			}
			else 
			{
				read (fil, &v81, 1);
				read (fil, &v82, 1);
				data8=v81/2+v82/2;
			}
		}

		if (id.bits==8)
		{
			if (data8>127) bit=1;
			else 				bit=0;
		}
		else
		{
			if (data16&0x8000) bit=0;
			else 			  		 bit=1;
		}

		if (id.SamplesPerSec==11025)

		{
			b2bset(data, counter++, bit);
			used++; if (used==9) used=1;
			b2bset(data, counter++, bit);
			used++; if (used==9) used=1;
		}
		else
		{
			b2bset(data, counter++, bit);
			used++; if (used==9) used=1;
		}

		if (((i/1000000*1000000)==i)||(!i))
			printf("Reading %s. %d%c done...\n", filename, i*100/len32, '%');

	}

	printf("Reading %s. 100%c done.\n", filename, '%');

	if (id.SamplesPerSec==44100) direct.TS=79;
	else 								  direct.TS=158;

	direct.pause=0;
	direct.used=used;
	direct.l3=(true_len&0xFF0000)/65536;
	direct.l2=(true_len&0x00FF00)/256;
	direct.l1= true_len&0x0000FF;

	AddTapeBlock("", 0x15, true_len, data, sizeof(direct), &direct, 1);

	close(fil);
	tape_type="wav";
	sprintf(tape_filename,filename);
	tape_SetActiveAndPause(tapes);
	return;
}

int load_tape(char *filename)
{
	char ext[4];
	char extention[5]={0};
	
	strncpy(extention,&filename[strlen(filename)-4],4);

	if (extention[3]=='/')
	{
		ERR_PR("Directory selected !");
		return(0);
	}

	if (strlen(filename)<5)
	{
		ERR_PR("Unknown file type !");
		return(0);
	}

	sprintf(ext,"%s",&filename[strlen(filename)-3]);

	if (strcasecmp(ext,"tzx")==0)
	{
		ReadTZX(filename);
		return(1);
	}

	if (strcasecmp(ext,"tap")==0)
	{
		ReadTAP(filename);
		return(1);
	}

	if (strcasecmp(ext,"wav")==0)
	{
		ReadWAV(filename);
		return(1);
	}
	
	return(0);
}

void tape_some_selected(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmFileSelectionBoxCallbackStruct * cbs;
{
	char * filename;
	char * directory;

	XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &filename);
	XmStringGetLtoR(cbs->dir, XmSTRING_DEFAULT_CHARSET, &directory);

	sprintf(tape_directory,directory);

	if(!load_tape(filename))
	{
		tounmanage=w;
		MessageBoxEx("Cannot load tape file!");
	}
	
	XtUnmanageChild(w);
	XmProcessTraversal(drawing_a, XmTRAVERSE_CURRENT);	
}

void tape_create_selectFNdialog(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	Widget dialog;

	dialog = XmCreateFileSelectionDialog(first_window, "Tape image selection", NULL, 0);

	XtVaSetValues(dialog,
		XmNdirectory,XmStringCreate (tape_directory,XmFONTLIST_DEFAULT_TAG),
		NULL);

	XtAddCallback(dialog, XmNcancelCallback, (XtCallbackProc)cancel_open_file, NULL);
	XtAddCallback(dialog, XmNokCallback, (XtCallbackProc)tape_some_selected, NULL);

	XtManageChild(dialog);
}

tape_struct * FindTapeByPosition(int p)
{
	tape_struct * r;


	r=tapes;

	if (r==NULL) return (NULL);

	while (TRUE)
	{
		if (r->position==p) return(r);
		r=r->next;

		if (r==NULL)
		{
			MessageBoxErr("FindTapeByPosition failed. This is bug. Report it.");
			return(NULL);
		}
	}
}

void tape_IsPlayableV(tape_struct * t)
{
	if (!t)return;


	if ((t->id==0x32)||(t->id==0x33)||(t->id==0x21)) 
		EnableWidget(tape_view);
	else
		DisableWidget(tape_view);
}

void tape_IsPlayable(tape_struct * t)
{
	if (!t)return;


	if (t->id!=0x21)
		EnableWidget(tape_delete);
	else
		DisableWidget(tape_delete);

	EnableWidget(tape_play);

	tape_IsPlayableV(t);
}

void tape_lb_selected(list_w, client_data, cbs)
	Widget list_w;
	XtPointer client_data;
	XmListCallbackStruct *cbs; 
{
	int num;
	int * selected[20];


	if (tape_paused||(tape_pos<tape_len)) 
	{
		XmListGetSelectedPos(tape_lb, selected, &num);
		if (num!=1) return;
		tape_IsPlayableV(FindTapeByPosition(*selected[0]));
		return;
	}

	if (client_data!=(XtPointer)1)
	{
		DisableWidget(tape_delete);
		DisableWidget(tape_view);

		DisableWidget(tape_play);
		DisableWidget(tape_stop);
		DisableWidget(tape_pause);
	}

	XmListGetSelectedPos(tape_lb, selected, &num);

	if (num!=1)
	{
		tape_next=NULL;
		return;
	}

	tape_next=FindTapeByPosition(*selected[0]);
	tape_IsPlayable(tape_next);

	EnsureVisibleAndSelect(*selected[0]);
}

void tape_playF(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	if (direct_recording)
	{
		MessageBoxErr("Can't play. Emulator uses real tape.");
		return;
	}

	if (tape_paused) 
	{
		tape_paused=0;

		EnableWidget(tape_stop);
		EnableWidget(tape_pause);
		DisableWidget(tape_play);

		MaxSpeenND_Start();
		if (tape_pos<tape_len) return;

		TapeNextNext();
	}

	tapeFill_tape(1);
}

char tape_Group2TextT[65535];
char * tape_Group2Text(tape_struct * t)
{
	char string[256];

	

	t=t->next;
	bzero(tape_Group2TextT, sizeof(tape_Group2TextT));

	while (TRUE)
	{
		sprintf(string,"%-12s %8d %s\n", Description(t->id), t->len, Details(t->id, t->ilen, t->info, t->len, t->data1));
		strcat(tape_Group2TextT, string);

		t=t->next;
		if (t->id==0x22) break;
	}

	tape_Group2TextT[strlen(tape_Group2TextT)-1]=0;
	return(tape_Group2TextT);
}

void tape_viewF(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	char * info="";

	Widget dialog=NULL;
	Widget pane;
	Widget form; 
	Widget Text1;
	Widget button;

	int i, xlen=0, ylen=1, xlenmax=0;

	char title[255]={0};
	int mnogo=0;

	int * selected[20];
	tape_struct * tape_next;
	int num;


	XmListGetSelectedPos(tape_lb, selected, &num);
	if (num!=1) return;
	tape_next=FindTapeByPosition(*selected[0]);	

	if (tape_next->id==0x32)
	{
		info=tape_GAInfo(tape_next->data1);

		dialog = XtVaCreatePopupShell("",
				xmDialogShellWidgetClass, first_window,
				XmNtitle,  "Archive Info",
				NULL);	
	}

	if (tape_next->id==0x33)
	{
		info=tape_hinfo(tape_next->len/3, (void *)tape_next->data1);

		dialog = XtVaCreatePopupShell("",
				xmDialogShellWidgetClass, first_window,
				XmNtitle,  "Hardware Type",
				NULL);	
	}	

	if (tape_next->id==0x21)
	{
		info=tape_Group2Text(tape_next);

		strncpy(title, tape_next->data1, tape_next->len);

		dialog = XtVaCreatePopupShell("",
				xmDialogShellWidgetClass, first_window,
				XmNtitle,  title,
				NULL);	
	}	

	for (i=0; i<strlen(info); i++)
	{
		if (info[i]=='\n') 
		{
			ylen++;
			if (xlenmax<xlen) xlenmax=xlen;
			xlen=-1;
		}

		xlen++;
	}
	if (xlenmax<xlen) xlenmax=xlen;

	if (ylen>35) {ylen=35; mnogo=1;}


	pane = XtVaCreateWidget("pane", xmPanedWindowWidgetClass, dialog,
			XmNsashWidth,  1, /* try to "hide" resizing sash.  PanedWindow */
			XmNsashHeight, 1, /* won't let us set to 0, so 1 will have to do */
			NULL);

	form = XtVaCreateWidget("form", xmFormWidgetClass, pane, NULL);

	n = 0;
	XtSetArg(args[n], XmNcolumns, xlenmax); n++;
	XtSetArg(args[n], XmNrows, ylen); n++;
	XtSetArg(args[n], XmNvalue, info); n++;
	XtSetArg(args[n], XmNeditable, False); n++;
	XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;


	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNfontList, fontlist1); n++; 
	XtSetArg(args[n], XmNscrollHorizontal,  False); n++;

	if (mnogo)
		Text1 = XmCreateScrolledText(form, "Text1", args, n);
	else
		Text1 = XmCreateText(form, "Text1", args, n);

	XtManageChild(Text1);

	n = 0;
	XtSetArg(args[n], XmNlabelString,  XmStringCreate (" Close ",XmFONTLIST_DEFAULT_TAG)); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNshadowThickness, 1); n++; 
	XtSetArg(args[n], XmNhighlightThickness,1); n++; 
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;

	if (mnogo)
		XtSetArg(args[n], XmNtopWidget, XtParent(Text1)); 
	else
		XtSetArg(args[n], XmNtopWidget, Text1); 
	n++;

	button=XmCreatePushButton(form, "", args, n);
	XtManageChild(button);
	XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) CloseDialog, NULL);

	XtManageChild(form);
	XtManageChild(pane);
	XtPopup(dialog, XtGrabNone);
	XRaiseWindow(display,XtWindow(dialog));
}

void tape_stopF(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	TapeNextNext();

	tape_pos=tape_len=0; 
	showQTape=0;

	tape_IsPlayable(tape_next);

	DisableWidget(tape_stop);
	DisableWidget(tape_pause);

	tape_paused=0;

	MaxSpeenND_Stop();
}

void tape_pauseF(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	tape_paused=1;

	EnableWidget(tape_stop);
	DisableWidget(tape_pause);
	EnableWidget(tape_play);

	TapeSetString("TAPE PAUSED");
	MaxSpeenND_Stop();
}

void SaveTAP(char * filename)
{
	int fil;
	tape_struct * t;

	unsigned short len16;


	if (tapes==NULL) return;

	fil=creat(filename, 00644);

	if(fil==-1)
	{
		sprintf(tstring,"SaveTAP : Can't create %s. You must be able to write this directory.", filename);
		MessageBoxErr(tstring);
		return;
	}


	t=tapes;

	while (TRUE)
	{
		len16=t->len;
		if (t->id==0x10) 
		{
			write(fil,&len16,2);	
			write(fil,t->data1,len16);
		}

		t=t->next;
		if (!t) break;
	}

	close(fil);

	tape_type="tap";
	sprintf(tape_filename,filename);


}

void SaveTZX(char * filename)
{
	int fil;
	tape_struct * t;
	unsigned char eof=0x1a;
	unsigned char major=1, minor=13;

	direct_recT * direct;
	turbo_block_type * turbo;
	ROM_bl_type * rom;
	unsigned short * len16;
	Pure_toneT * tone;
	Pure_dataT * data;
	signed short * Signed;
	unsigned char len8;
	unsigned short Len16;
	zxtapeT * zx;


	if (tapes==NULL) return;

	fil=creat(filename, 00644);

	if(fil==-1)
	{
		sprintf(tstring,"SaveTZX : Can't create %s. You must be able to write this directory.", filename);
		MessageBoxErr(tstring);
		return;
	}

	if (tapes->id!='Z')
	{
		write(fil,"ZXTape!",7);	
		write(fil,&eof,1);
		write(fil,&major,1);
		write(fil,&minor,1);
	}

	t=tapes;

	while (TRUE)
	{
		write(fil, &t->id, 1);

		switch (t->id)
		{
			case 0x15:
				direct=t->info;
				write(fil, &direct->TS, 2);
				write(fil, &direct->pause, 2);
				write(fil, &direct->used, 1);
				write(fil, &direct->l1, 1);
				write(fil, &direct->l2, 1);
				write(fil, &direct->l3, 1);
				write(fil, t->data1, t->len);
				break;

			case 'Z':
				zx=t->info;
				write(fil,"XTape!",6);	
				write(fil,&eof,1);
				write(fil,&zx->major,1);
				write(fil,&zx->minor,1);
				break;

			case 0x10:
				rom=t->info;
				write(fil, &rom->pause, 2);
				write(fil, &rom->len, 2);
				write(fil, t->data1, t->len);
				break;

			case 0x11:
				turbo=t->info;
				write(fil, &turbo->pilotL, 2);
				write(fil, &turbo->syncFL, 2);
				write(fil, &turbo->syncSL, 2);
				write(fil, &turbo->zeroL, 2);
				write(fil, &turbo->oneL, 2);

				write(fil, &turbo->pilot_toneL_inPulses, 2);
				write(fil, &turbo->used_bits, 1);
				write(fil, &turbo->pause, 2);
				write(fil, &turbo->l1, 1);

				write(fil, &turbo->l2, 1);
				write(fil, &turbo->l3, 1);
				write(fil, t->data1, t->len);
				break;

			case 0x12:
				tone=t->info;
				write(fil, &tone->len, 2);
				write(fil, &tone->n, 2);

				break;

			case 0x13:
				len8=t->len/2;
				write(fil, &len8, 1);
				write(fil, t->data1, t->len);
				break;

			case 0x14:
				data=t->info;
				write(fil, &data->z, 2);
				write(fil, &data->o, 2);
				write(fil, &data->used, 1);
				write(fil, &data->pause, 2);
				write(fil, &data->l1, 1);
				write(fil, &data->l2, 1);
				write(fil, &data->l3, 1);
				write(fil, t->data1, t->len);
				break;

			case 0x20:
				len16=t->info;
				write(fil, len16, 2);
				break;

			case 0x21:
				len8=t->len;
				write(fil, &len8, 1);
				write(fil, t->data1, t->len);
				break;

			case 0x22:
				break;

			case 0x23:
				Signed=t->info;
				write(fil, Signed, 2);
				break;

			case 0x24:
				len16=t->info;
				write(fil, len16, 2);
				break;

			case 0x25:
				break;

			case 0x30:
				len8=t->len;
				write(fil, &len8, 1);
				write(fil, t->data1, t->len);
				break;

			case 0x32:
				Len16=t->len;
				write(fil, &Len16, 2);
				write(fil, t->data1, t->len);
				break;

			case 0x33:
				len8=t->len/3;
				write(fil, &len8, 1);
				write(fil, t->data1, t->len);
				break;

			case 0x35:
				write(fil, t->info, 0x16);
				write(fil, &t->len, 4);
				write(fil, t->data1, t->len);
				break;


			default:
				sprintf(tstring, "SaveTZX : Unknown ID=#%X. This is BUG. Report it.", t->id);
				MessageBoxErr(tstring);
				close(fil);
				return;
		}

		t=t->next;
		if (!t) break;
	}

	close(fil);
}

void SaveWAV(char * filename)
{
	int fil;
	tape_struct * t;
	unsigned int len=0;
	unsigned int full_len;
	unsigned int temp;
	unsigned short temp16;
	unsigned int i;
	unsigned char byte;
	unsigned char Data=0;


	if (tapes==NULL) return;

	fil=creat(filename, 00644);

	if(fil==-1)
	{
		sprintf(tstring,"SaveWAV : Can't create %s. You must be able to write this directory.", filename);
		MessageBoxErr(tstring);
		return;
	}


	t=tapes;

	while (TRUE)
	{
		Fill(tapeS, &len, t);

		t=t->next;
		if (!t) break;
	}

	full_len=len/*dlina viborki*/+8/*zagolovok RIFF fajla*/+12/*Zagolovok kuska WAV*/+16/*kusok WAV*/+8/*identifikator vyborki*/;

	write(fil,"RIFF",4);
	temp=full_len-8;
	write(fil,&temp,4);
	write(fil,"WAVEfmt ",8);
	temp=0x10;
	write(fil,&temp,4);
	temp16=1;
	write(fil,&temp16,2);
	write(fil,&temp16,2);
	temp=44100;
	write(fil,&temp,4);
	write(fil,&temp,4);
	write(fil,&temp16,2);
	temp16=8;
	write(fil,&temp16,2);
	write(fil,"data",4);
	temp=len;
	write(fil,&temp,4);
	write(fil,&Data,1);

	for (i=0; i<len; i++)
	{
		byte=b2bget(tapeS, i);
		if (byte) byte=250;

		write(fil, &byte, 1);

		if (((i/1000000*1000000)==i)||(!i))
			printf("Writing %s. %d%c done...\n", filename, i*100/len, '%');
	}

	printf("Writing %s. 100%c done.\n", filename, '%');
	close (fil);

	tape_type="wav";
	sprintf(tape_filename,filename);

	/* chegoto ya tuta hotel. Chego imenno - me pomnu. !!! */
}

void tape_SaveIt(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	char * c;

	c=(char *)client_data;

	if (!strcmp(c,"tap")) SaveTAP(filenameT);
	if (!strcmp(c,"wav")) SaveWAV(filenameT);
	if (!strcmp(c,"tzx")) SaveTZX(filenameT);

	XtUnmanageChild(tounmanage);
	XmProcessTraversal(drawing_a, XmTRAVERSE_CURRENT);
}

void tape_saveFormatUjeVibranIchtotoTamTipaImeniFailaToje(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmFileSelectionBoxCallbackStruct *cbs;
{
	char * filename;
	char * directory;
	char extention[5]={0};

	char * c;
	void * p;                                                    


	XtVaGetValues(w, XmNuserData, &p, NULL);
	c=(char *)p;

	XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &filename);
	XmStringGetLtoR(cbs->dir, XmSTRING_DEFAULT_CHARSET, &directory);

	sprintf(tape_directory,directory);

	strncpy(extention,&filename[strlen(filename)-4],4);

	if (extention[3]=='/')
	{
		tounmanage=w;
		MessageBoxEx("Directory selected !");
		return;
	}

	if (strcasecmp(&extention[1],c)==0)
		sprintf(filenameT,"%s",filename);
	else
		sprintf(filenameT,"%s.%s",filename,c);

	if (FileExists(filenameT))
	{
		tounmanage=w;
		MessageBoxOverwrite((XtCallbackProc)tape_SaveIt, c);
	}
	else
	{
		if (!strcmp(c,"tap")) SaveTAP(filenameT);
		if (!strcmp(c,"wav")) SaveWAV(filenameT);
		if (!strcmp(c,"tzx")) SaveTZX(filenameT);

		XtUnmanageChild(w);
		XmProcessTraversal(drawing_a, XmTRAVERSE_CURRENT);
	}
}

void tape_saveFormatUjeVibran(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	Widget dialog;


	CloseDialog1pm(tape_saveFB, NULL, NULL);

	dialog = XmCreateFileSelectionDialog(first_window, "Save snapshot", NULL, 0);

	XtVaSetValues(dialog,
		XmNdirectory,XmStringCreate(tape_directory,XmFONTLIST_DEFAULT_TAG),
		XmNuserData, client_data,
		NULL);

	XtAddCallback(dialog, XmNcancelCallback, (XtCallbackProc)cancel_open_file, NULL);
	XtAddCallback(dialog, XmNokCallback, (XtCallbackProc)tape_saveFormatUjeVibranIchtotoTamTipaImeniFailaToje, NULL);

	XtManageChild(dialog);	
}

int VseBloki10(void)
{
	tape_struct * t;


	t=tapes;

	if (t==NULL) return (False);

	while (TRUE)
	{
		if ((t->id!=0x10)&&(t->id!='Z')&&(!NadoPropustitEtotTapeBlock(t)))return (False);
		t=t->next;
		if (!t) break;
	}

	return (True);
}

int MojnoPisatWAV(void)
{
	tape_struct * t;
	unsigned short * value;


	t=tapes;

	if (t==NULL) return (False);

	while (TRUE)
	{
		if ((t->id==0x23)||(t->id==0x25)||(t->id==0x24)) return(False);

		if (t->id==0x20)
		{
			value=(unsigned short * )t->info;

			if (!(*value)) 
				return (False);
		}

		t=t->next;
		if (!t) break;
	}

	return (True);
}

void tape_saveF(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	static Widget dialog;
	static Widget pane;
	static Widget form; 

	Widget button, label, sep;
	Widget sep1, rc;
	static Widget btap, bwav;


	if (!tapes)
	{
		MessageBoxErr("Nothing to save !");
		return;
	}

	if (!dialog)
	{
		dialog = XtVaCreatePopupShell("",
				xmDialogShellWidgetClass, first_window,
				XmNtitle,  "",
				NULL);

		pane = XtVaCreateWidget("pane", xmPanedWindowWidgetClass, dialog,
				XmNsashWidth,  1, /* try to "hide" resizing sash.  PanedWindow */
				XmNsashHeight, 1, /* won't let us set to 0, so 1 will have to do */
				NULL);

		form = XtVaCreateWidget("form", xmFormWidgetClass, pane, NULL);

		label=XtVaCreateManagedWidget("", 
				xmLabelWidgetClass, form,
				XmNlabelString, XmStringCreate ("Please choose format of the output file :",XmFONTLIST_DEFAULT_TAG),
				XmNleftAttachment, XmATTACH_FORM,
				XmNtopAttachment, XmATTACH_FORM,
				NULL);

		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
		XtSetArg(args[n], XmNtopWidget, label); n++;
		XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
		XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;

		sep=XmCreateSeparator(form, "", args, n);
		XtManageChild(sep);


		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
		XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
		XtSetArg(args[n], XmNtopWidget, sep); n++;
		XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;

		rc = XmCreateRowColumn(form, "rowcol", args, n);


		button = XtVaCreateManagedWidget(" .TZX ", 
				xmPushButtonWidgetClass, rc, 
				NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) tape_saveFormatUjeVibran, (XtPointer)"tzx");

		btap = XtVaCreateManagedWidget(" .TAP ", 
				xmPushButtonWidgetClass, rc, 
				NULL);
		XtAddCallback(btap, XmNactivateCallback, (XtCallbackProc) tape_saveFormatUjeVibran, (XtPointer)"tap");

		bwav = XtVaCreateManagedWidget(" .WAV ", 
				xmPushButtonWidgetClass, rc, 
				NULL);
		XtAddCallback(bwav, XmNactivateCallback, (XtCallbackProc) tape_saveFormatUjeVibran, (XtPointer)"wav");

		n = 0;
		XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
		XtSetArg(args[n], XmNwidth, 30); n++;
		sep1=XmCreateSeparator(rc, "", args, n);
		XtManageChild(sep1);

		tape_saveFB = XtVaCreateManagedWidget(" Don't save ", 
				xmPushButtonWidgetClass, rc, 
				NULL);
		XtAddCallback(tape_saveFB, XmNactivateCallback, (XtCallbackProc) CloseDialog1pm, NULL);

		XtManageChild(rc);

		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
		XtSetArg(args[n], XmNtopWidget, rc); n++;
		XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
		XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;

		sep=XmCreateSeparator(form, "", args, n);
		XtManageChild(sep);
	}

	XtManageChild(form);
	XtManageChild(pane);
	XtPopup(dialog, XtGrabNone);
	XRaiseWindow(display,XtWindow(dialog));

	if (!VseBloki10()) DisableWidget(btap); 
	else EnableWidget(btap);

	if (!MojnoPisatWAV()) DisableWidget(bwav);
	else EnableWidget(bwav);
}

void uberi_diru_v_Teipah(int udalit, tape_struct * active)
{
	tape_struct * t;


	t=tapes;


	while (TRUE)
	{
		if ((t->position>udalit)&&(t->position))t->position--;

		t=t->next;
		if (!t) break;
	}


	XmListDeletePos(tape_lb, udalit);

	EnsureVisibleAndSelect(active->position);	
	tape_IsPlayable(active);	

	tape_next=active;
}

tape_struct * TapeFindParent(tape_struct * arg)
{
	tape_struct * t;


	t=tapes;

	while (TRUE)
	{
		if (t->next==arg)return(t);

		t=t->next;
		if (!t) break;
	}

	printf("TapeFindParent failed. This is bug. Report it.\n");
	ExitWithError(-1, "");
	return(NULL); /* :) */
}

void TapeDeleteBlock(tape_struct * t)
{
	int n;


	if (tapes==NULL) return;

	if ((t==tapes)&&(t->next==NULL))
	{FreeTape(NULL, NULL, NULL); return;}

	if (t==tapes)
	{
		n=t->position;
		tapes=t->next;

		if (t->len) free(t->data1);
		if (t->ilen) free(t->info);
		free(t);

		uberi_diru_v_Teipah(n, tapes);
		return;
	}

	if (t->next==NULL)
	{
		n=t->position;
		TapeFindParent(t)->next=NULL;


		if (t->len) free(t->data1);
		if (t->ilen) free(t->info);
		free(t);

		uberi_diru_v_Teipah(n, tapes);
		return;
	}

	n=t->position;
	TapeFindParent(t)->next=t->next;

	uberi_diru_v_Teipah(n, t->next);

	if (t->len) free(t->data1);
	if (t->ilen) free(t->info);
	free(t);
}



tape_struct * todelete;

void tape_deleteF_Confirmed(void)
{
	TapeDeleteBlock(todelete);
}

void tape_deleteF(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	todelete=tape_next;

	sprintf(tstring, "This will delete block <%s - %s>. Are you sure ?", Description(tape_next->id), Details(tape_next->id, tape_next->ilen, tape_next->info, tape_next->len, tape_next->data1));
	MessageBoxOkCan((XtCallbackProc)tape_deleteF_Confirmed, NULL, NULL, tstring);	
}

void tape_loading_methodDecrease(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	if (tape_loading_method==0) return;

	tape_loading_method--;

	if (tape_loading_method==0)XmTextSetString(tape_q,"Slow loading");
	if (tape_loading_method==1)XmTextSetString(tape_q,"Fast loading");
}

void tape_loading_methodIncrease(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	if (tape_loading_method==1) return;

	tape_loading_method++;

	if (tape_loading_method==0)XmTextSetString(tape_q,"Slow loading");
	if (tape_loading_method==1)XmTextSetString(tape_q,"Fast loading");
}

void settings_h(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	static Widget dialog;
	static Widget pane;
	static Widget form; 

	Widget tab_wid, frame;
	Widget child1;
	Widget radio_box, button, label, separator, rc, separator1;
	Widget label1, radio_box1;
	Widget ww, two, three, four, five;
	Widget www;
	Widget ss_ww, ss_two, ss_three;
	Widget SettingsForm;

	int f1=0,f2=0,f3=0,f4=0,f5=0,f6=0,f7=0,f8=0,f9=0;
	Boolean s1=False,s2=False,s3=False,s4=False,s5;
	Boolean sz1,sz2;
	Boolean r1,r2,r3;
	Boolean t1,t2;


	if (!dialog)
	{
		dialog = XtVaCreatePopupShell("Settings",
				xmDialogShellWidgetClass, first_window,
				NULL);

		pane = XtVaCreateWidget("pane", xmPanedWindowWidgetClass, 	dialog,
				XmNsashWidth,  1, /* try to "hide" resizing sash.  PanedWindow */
				XmNsashHeight, 1, /* won't let us set to 0, so 1 will have to do */
				NULL);

		form = XtVaCreateWidget("form", xmFormWidgetClass, pane, NULL);

		tab_wid = XtVaCreateWidget("Tab", xmTabWidgetClass, form,
				XmNleftAttachment, XmATTACH_FORM,
				XmNrightAttachment, XmATTACH_FORM,
				XmNtopAttachment, XmATTACH_FORM,
				NULL);

		{
			child1 = XtVaCreateWidget("Speeds", xmFormWidgetClass, tab_wid,
					NULL);

			frame = XtVaCreateWidget("Frame", xmFrameWidgetClass, child1,
					XmNleftAttachment, XmATTACH_FORM,
					XmNrightAttachment, XmATTACH_FORM,
					XmNtopAttachment, XmATTACH_FORM,
					XmNbottomAttachment, XmATTACH_FORM,
					XmNmarginWidth,  5,
					XmNmarginHeight, 5,
					NULL);

			XtVaCreateManagedWidget("Speeds", xmLabelWidgetClass, frame,
				XmNchildType, XmFRAME_TITLE_CHILD,
				NULL);

			SettingsForm=XtVaCreateWidget("form", xmFormWidgetClass, 
					frame, 
					NULL);

			{
				sscanf(predefined_freqs,"%d%d%d%d%d%d%d%d%d",&f1,&f2,&f3,&f4,&f5,&f6,&f7,&f8,&f9);

				label=XtVaCreateManagedWidget("add_label", xmLabelWidgetClass, SettingsForm,
						XmNlabelString, XmStringCreate ("Emulator Speed :",XmFONTLIST_DEFAULT_TAG),
						XmNleftAttachment,  XmATTACH_FORM,
						NULL);

				scale2 = XtVaCreateManagedWidget("Emulator speed",
						xmScaleWidgetClass, SettingsForm,
						XmNtitleString, XmStringCreate ("Emulator speed, %",XmFONTLIST_DEFAULT_TAG) ,
						XmNminimum,       10,
						XmNmaximum,       200,
						XmNdecimalPoints, 0,
						XmNshowValue,     True,
						XmNorientation,XmHORIZONTAL,
						XmNwidth,         400,
						XmNvalue,         emulator_speed,
						XmNleftAttachment,  XmATTACH_FORM,
						XmNrightAttachment,  XmATTACH_FORM,
						XmNtopWidget,  label,
						XmNtopAttachment,  XmATTACH_WIDGET,
						NULL);

				n = 0;
				XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
				XtSetArg(args[n], XmNtopWidget,  scale2); n++;
				XtSetArg(args[n], XmNtopAttachment,  XmATTACH_WIDGET); n++;
				XtSetArg(args[n], XmNleftAttachment,  XmATTACH_FORM); n++;
				XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
				XtSetArg(args[n], XmNheight,20);n++;

				separator=XmCreateSeparator(SettingsForm, "", args, n);
				XtManageChild(separator);

				label=XtVaCreateManagedWidget("add_label", xmLabelWidgetClass, SettingsForm,
						XmNlabelString, XmStringCreate ("Z80 Speed :",XmFONTLIST_DEFAULT_TAG),
						XmNleftAttachment,  XmATTACH_FORM,
						XmNtopWidget, separator,
						XmNtopAttachment,  XmATTACH_WIDGET,
						NULL);

				n = 0;
				XtSetArg(args[n], XmNleftWidget,  label); n++;
				XtSetArg(args[n], XmNrightAttachment,  XmATTACH_FORM); n++;
				XtSetArg(args[n], XmNtopWidget,  separator); n++;
				XtSetArg(args[n], XmNtopAttachment,  XmATTACH_WIDGET); n++;
				XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;

				rc = XmCreateRowColumn(SettingsForm, "rowcol", args, n);
				XtManageChild(rc);

				AddZ80FButton(rc,f1);
				AddZ80FButton(rc,f2);
				AddZ80FButton(rc,f3);
				AddZ80FButton(rc,f4);
				AddZ80FButton(rc,f5);
				AddZ80FButton(rc,f6);
				AddZ80FButton(rc,f7);
				AddZ80FButton(rc,f8);
				AddZ80FButton(rc,f9);

				scale1 = XtVaCreateManagedWidget("Z80 Speed, %",
						xmScaleWidgetClass, SettingsForm,
						XmNtitleString, XmStringCreate ("Z80 Speed, %",XmFONTLIST_DEFAULT_TAG) ,
						XmNminimum,       100,
						XmNmaximum,       20000,
						XmNdecimalPoints, 1,
						XmNshowValue,     True,
						XmNorientation,XmHORIZONTAL,
						XmNvalue,          z80_spd_new*100*10/35,
						XmNtopWidget, rc,
						XmNtopAttachment,  XmATTACH_WIDGET,
						XmNleftAttachment,  XmATTACH_FORM,
						XmNrightAttachment,  XmATTACH_FORM,
						NULL);

				scale = XtVaCreateManagedWidget("Z80 Speed in Mhz",
						xmScaleWidgetClass, SettingsForm,
						XmNtitleString, XmStringCreate ("Z80 Speed, in Mhz",XmFONTLIST_DEFAULT_TAG) ,
						XmNminimum,       3,
						XmNmaximum,       700,
						XmNdecimalPoints, 1,
						XmNshowValue,     True,
						XmNorientation,XmHORIZONTAL,
						XmNvalue,         z80_spd_new,
						XmNtopWidget,     scale1,
						XmNtopAttachment,  XmATTACH_WIDGET,
						XmNleftAttachment,  XmATTACH_FORM,
						XmNrightAttachment,  XmATTACH_FORM,
						NULL);

				XtManageChild(scale);

				XtAddCallback(scale, XmNvalueChangedCallback, (XtCallbackProc) setZ80spd, NULL);
				XtAddCallback(scale, XmNdragCallback, (XtCallbackProc) setZ80spd, NULL);

				XtAddCallback(scale1, XmNvalueChangedCallback, (XtCallbackProc) setZ80spd_ps, NULL);
				XtAddCallback(scale1, XmNdragCallback, (XtCallbackProc) setZ80spd_ps, NULL);

				XtAddCallback(scale2, XmNvalueChangedCallback, (XtCallbackProc) set_emulator_spd, NULL);
				XtAddCallback(scale2, XmNdragCallback, (XtCallbackProc) set_emulator_spd, NULL);
			}

			XtManageChild(SettingsForm); XtManageChild(frame); XtManageChild(child1);
		}


		{
			child1 = XtVaCreateWidget("Architecture", xmFormWidgetClass, tab_wid,
					NULL);

			frame = XtVaCreateWidget("Frame", xmFrameWidgetClass, child1,
					XmNleftAttachment, XmATTACH_FORM,
					XmNrightAttachment, XmATTACH_FORM,
					XmNtopAttachment, XmATTACH_FORM,
					XmNbottomAttachment, XmATTACH_FORM,
					XmNmarginWidth,  5,
					XmNmarginHeight, 5,
					NULL);

			XtVaCreateManagedWidget("Architecture", xmLabelWidgetClass, frame,
				XmNchildType, XmFRAME_TITLE_CHILD,
				NULL);

			SettingsForm=XtVaCreateWidget("form", xmFormWidgetClass, 
					frame, NULL);

			{
				if (strcasecmp(Mode,"48")==0)
					s1=True;	
				if (strcasecmp(Mode,"128")==0)
					s2=True;
				if (strcasecmp(Mode,"Pentagon")==0)
					s3=True;
				if (strcasecmp(Mode,"Scorpion")==0)
					s4=True;

				radio_box = XmCreateRadioBox(SettingsForm, "Reset mode", NULL, 0);

				two_48=XtVaCreateManagedWidget("ZX-Spectrum 48K",
						xmToggleButtonGadgetClass, radio_box, 
						XmNset,s1,
						NULL);
				XtAddCallback(two_48, XmNvalueChangedCallback, (XtCallbackProc) toggled_mode, (XtPointer) 0);

				two_128= XtVaCreateManagedWidget("ZX-Spectrum 128K",
						xmToggleButtonGadgetClass, radio_box, 
						XmNset,s2,
						NULL);
				XtAddCallback(two_128, XmNvalueChangedCallback, (XtCallbackProc) toggled_mode, (XtPointer) 1);

				two_Pentagon= XtVaCreateManagedWidget("Pentagon 128K",
						xmToggleButtonGadgetClass, radio_box, 
						XmNset,s3,
						NULL);
				XtAddCallback(two_Pentagon, XmNvalueChangedCallback, (XtCallbackProc) toggled_mode, (XtPointer) 2);

				two_Scorpion= XtVaCreateManagedWidget("Scorpion 256K",
						xmToggleButtonGadgetClass, radio_box, 
						XmNset,s4,
						NULL);
				XtAddCallback(two_Scorpion, XmNvalueChangedCallback, (XtCallbackProc) toggled_mode, (XtPointer) 3);

				XtManageChild(radio_box);
			}

			XtManageChild(SettingsForm); XtManageChild(frame); XtManageChild(child1);
		}


		{
			child1 = XtVaCreateWidget("Screen", xmFormWidgetClass, tab_wid,
					NULL);

			frame = XtVaCreateWidget("Frame", xmFrameWidgetClass, child1,
					XmNleftAttachment, XmATTACH_FORM,
					XmNrightAttachment, XmATTACH_FORM,
					XmNtopAttachment, XmATTACH_FORM,
					XmNbottomAttachment, XmATTACH_FORM,
					XmNmarginWidth,  5,
					XmNmarginHeight, 5,
					NULL);

			XtVaCreateManagedWidget("Screen", xmLabelWidgetClass, frame,
				XmNchildType, XmFRAME_TITLE_CHILD,
				NULL);

			SettingsForm=XtVaCreateWidget("form", xmFormWidgetClass, 
					frame, NULL);

			{
				sz1=sz2=False;

				if (screen_size==1)sz1=True;
				if (screen_size==2)sz2=True;

				s1=s2=s3=s4=s5=False;

				if (XLib)
					s5=True;	
				else
				{
					if (refresh_fr==50)s1=True;
					if (refresh_fr==25)s2=True;
					if (refresh_fr==16)s3=True;
					if (refresh_fr==8)s4=True;
				}	

				label=XtVaCreateManagedWidget("add_label", xmLabelWidgetClass, SettingsForm,
						XmNlabelString, XmStringCreate ("Screen refresh method :",XmFONTLIST_DEFAULT_TAG),
						XmNleftAttachment,  XmATTACH_FORM,
						NULL);

				n = 0;
				XtSetArg(args[n], XmNtopWidget,  label); n++;
				XtSetArg(args[n], XmNtopAttachment,  XmATTACH_WIDGET); n++;
				XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;

				radio_box = XmCreateRadioBox(SettingsForm, "Screen Refresh Rate", args, n);

				ww= XtVaCreateManagedWidget("MIT-SHM 50 FPS",
						xmToggleButtonGadgetClass, radio_box, 
						XmNset,s1,
						NULL);
				XtAddCallback(ww, XmNvalueChangedCallback, (XtCallbackProc)toggled, (XtPointer) 1);

				two = XtVaCreateManagedWidget("MIT-SHM 25 FPS",
						xmToggleButtonGadgetClass, radio_box, 
						XmNset,s2,
						NULL);
				XtAddCallback(two, XmNvalueChangedCallback, (XtCallbackProc)toggled, (XtPointer) 2);

				three = XtVaCreateManagedWidget("MIT-SHM 16 FPS",
						xmToggleButtonGadgetClass, radio_box,
						XmNset,s3,
						NULL);
				XtAddCallback(three, XmNvalueChangedCallback, (XtCallbackProc)toggled, (XtPointer) 3);

				four = XtVaCreateManagedWidget("MIT-SHM 8 FPS",
						xmToggleButtonGadgetClass, radio_box,
						XmNset,s4,
						NULL);
				XtAddCallback(four, XmNvalueChangedCallback, (XtCallbackProc)toggled, (XtPointer) 4);

				five = XtVaCreateManagedWidget("XLib",
						xmToggleButtonGadgetClass, radio_box,
						XmNset,s5,
						NULL);
				XtAddCallback(five, XmNvalueChangedCallback, (XtCallbackProc)toggled, (XtPointer) 5);


				XtManageChild(radio_box);

				radio_box1=radio_box;

				n = 0;

				XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
				XtSetArg(args[n], XmNleftWidget,  label); n++;
				XtSetArg(args[n], XmNleftAttachment,  XmATTACH_WIDGET); n++;
				XtSetArg(args[n], XmNtopAttachment,  XmATTACH_FORM); n++;
				XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
				XtSetArg(args[n], XmNwidth,20);n++;

				separator=XmCreateSeparator(SettingsForm, "", args, n);
				XtManageChild(separator);


				label1=XtVaCreateManagedWidget("add_label 1", xmLabelWidgetClass, SettingsForm,
						XmNlabelString, XmStringCreate ("Screen Size :",XmFONTLIST_DEFAULT_TAG),
						XmNleftWidget,  separator,
						XmNleftAttachment, XmATTACH_WIDGET,
						NULL);

				n = 0;
				XtSetArg(args[n], XmNtopWidget,  label1); n++;
				XtSetArg(args[n], XmNtopAttachment,  XmATTACH_WIDGET); n++;

				XtSetArg(args[n], XmNleftWidget,  separator); n++;
				XtSetArg(args[n], XmNleftAttachment,  XmATTACH_WIDGET); n++;

				radio_box = XmCreateRadioBox(SettingsForm, " Screen Size     ", args, n);

				ww= XtVaCreateManagedWidget("Single size",
						xmToggleButtonGadgetClass, radio_box, 
						XmNset,sz1,
						NULL);
				XtAddCallback(ww, XmNvalueChangedCallback, (XtCallbackProc)toggled_sz, (XtPointer) 1);

				two = XtVaCreateManagedWidget("Double size      ",
						xmToggleButtonGadgetClass, radio_box, 
						XmNset,sz2,
						NULL);
				XtAddCallback(two, XmNvalueChangedCallback,(XtCallbackProc)toggled_sz, (XtPointer) 2);

				XtManageChild(radio_box);

				n = 0;
				XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
				XtSetArg(args[n], XmNheight,10);n++;
				XtSetArg(args[n], XmNleftWidget,  separator); n++;
				XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
				XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
				XtSetArg(args[n], XmNtopWidget,  radio_box); n++;
				XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;

				separator1=XmCreateSeparator(SettingsForm, "", args, n);
				XtManageChild(separator1);

				n = 0;
				XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
				XtSetArg(args[n], XmNwidth, SEPARATOR_WIDTH); n++;
				XtSetArg(args[n], XmNmargin,10);n++;
				XtSetArg(args[n], XmNleftWidget,  separator); n++;
				XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
				XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
				XtSetArg(args[n], XmNtopWidget,  separator1); n++;
				separator=XmCreateSeparator(SettingsForm, "", args, n);
				XtManageChild(separator);

				n = 0;
				XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
				XtSetArg(args[n], XmNwidth, SEPARATOR_WIDTH); n++;
				XtSetArg(args[n], XmNmargin,10);n++;
				XtSetArg(args[n], XmNleftWidget,  separator); n++;
				XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
				XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
				XtSetArg(args[n], XmNtopWidget,  radio_box); n++;
				separator=XmCreateSeparator(SettingsForm, "", args, n);
				XtManageChild(separator);

				label1=XtVaCreateManagedWidget("add_label 1", xmLabelWidgetClass, SettingsForm,
						XmNlabelString, XmStringCreate ("Effects :",XmFONTLIST_DEFAULT_TAG),
						XmNleftWidget,  separator,
						XmNleftAttachment, XmATTACH_WIDGET,
						XmNtopWidget,  separator1,
						XmNtopAttachment, XmATTACH_WIDGET,
						NULL);

				www=XtVaCreateManagedWidget("Filtering",
						xmToggleButtonGadgetClass, SettingsForm, 
						XmNset,interpolyatsia,
						XmNleftWidget,  separator,
						XmNleftAttachment, XmATTACH_WIDGET,
						XmNtopWidget,  label1,
						XmNtopAttachment, XmATTACH_WIDGET,
						XmNhighlightThickness,0, 
						NULL);

				XtAddCallback(www, XmNvalueChangedCallback,(XtCallbackProc)toggled_interpolation, (XtPointer) 2);

				www=XtVaCreateManagedWidget("Scan",
						xmToggleButtonGadgetClass, SettingsForm, 
						XmNset,scan,
						XmNleftWidget,  separator,
						XmNleftAttachment, XmATTACH_WIDGET,
						XmNtopWidget,  www,
						XmNtopAttachment, XmATTACH_WIDGET,
						XmNhighlightThickness,0, 
						NULL);

				XtAddCallback(www, XmNvalueChangedCallback,(XtCallbackProc)toggled_scan, (XtPointer) 2);
			}

			XtManageChild(SettingsForm); XtManageChild(frame); XtManageChild(child1);
		}


		{
			child1 = XtVaCreateWidget("Sound", xmFormWidgetClass, tab_wid,
					NULL);

			frame = XtVaCreateWidget("Frame", xmFrameWidgetClass, child1,
					XmNleftAttachment, XmATTACH_FORM,
					XmNrightAttachment, XmATTACH_FORM,
					XmNtopAttachment, XmATTACH_FORM,
					XmNbottomAttachment, XmATTACH_FORM,
					XmNmarginWidth,  5,
					XmNmarginHeight, 5,
					NULL);

			XtVaCreateManagedWidget("Sound", xmLabelWidgetClass, frame,
				XmNchildType, XmFRAME_TITLE_CHILD,
				NULL);

			SettingsForm=XtVaCreateWidget("form", xmFormWidgetClass, 
					frame, NULL);

			{
				t1=t2=r1=r2=r3=s1=s2=s3=False;

				switch (stereo_mode)
				{
					case 0: s1=True; break;
					case 1: s2=True; break;
					case 2: s3=True; break;
				}

				switch (Sound_Freq)
				{
					case 44100: r1=True; break;
					case 22050: r2=True; break;
					case 11025: r3=True; break;
				}

				if (sound) t1=True;
				else t2=True;      

				label=XtVaCreateManagedWidget("add_label", xmLabelWidgetClass, SettingsForm,
						XmNlabelString, XmStringCreate ("Enabling sound :",XmFONTLIST_DEFAULT_TAG),
						XmNleftAttachment,  XmATTACH_FORM,
						NULL);

				n = 0;
				XtSetArg(args[n], XmNtopWidget,  label); n++;
				XtSetArg(args[n], XmNtopAttachment,  XmATTACH_WIDGET); n++;

				radio_box = XmCreateRadioBox(SettingsForm, "", args, n);

				four1_ena = XtVaCreateManagedWidget("Enabled",
						xmToggleButtonGadgetClass, radio_box,
						XmNset, t1,
						NULL);
				XtAddCallback(four1_ena, XmNvalueChangedCallback, (XtCallbackProc)toggled_sound_ena, (XtPointer) 1);

				four1 = XtVaCreateManagedWidget("Disabled",
						xmToggleButtonGadgetClass, radio_box,
						XmNset, t2,
						NULL);
				XtAddCallback(four1, XmNvalueChangedCallback, (XtCallbackProc)toggled_sound_ena, (XtPointer) 0);

				XtManageChild(radio_box);

				n = 0;
				XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
				XtSetArg(args[n], XmNleftWidget,  label); n++;
				XtSetArg(args[n], XmNleftAttachment,  XmATTACH_WIDGET); n++;
				XtSetArg(args[n], XmNtopAttachment,  XmATTACH_FORM); n++;
				XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
				XtSetArg(args[n], XmNwidth,20);n++;
				XtSetArg(args[n], XmNmargin,10);n++;

				separator1=XmCreateSeparator(SettingsForm, "", args, n);
				XtManageChild(separator1);

				n = 0;
				XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
				XtSetArg(args[n], XmNtopWidget,  radio_box); n++;
				XtSetArg(args[n], XmNtopAttachment,  XmATTACH_WIDGET); n++;
				XtSetArg(args[n], XmNleftAttachment,  XmATTACH_FORM); n++;
				XtSetArg(args[n], XmNrightAttachment,  XmATTACH_WIDGET); n++;
				XtSetArg(args[n], XmNrightWidget, separator1); n++;
				XtSetArg(args[n], XmNheight,20);n++;

				separator=XmCreateSeparator(SettingsForm, "", args, n);
				XtManageChild(separator);

				label=XtVaCreateManagedWidget("add_label", xmLabelWidgetClass, SettingsForm,
						XmNlabelString, XmStringCreate ("Stereo mode :",XmFONTLIST_DEFAULT_TAG),
						XmNtopWidget,  separator,
						XmNtopAttachment, XmATTACH_WIDGET,
						NULL);

				n = 0;
				XtSetArg(args[n], XmNtopWidget,  label); n++;
				XtSetArg(args[n], XmNtopAttachment,  XmATTACH_WIDGET); n++;
				/*
				XtSetArg(args[n], XmNleftWidget,  separator); n++;
				XtSetArg(args[n], XmNleftAttachment,  XmATTACH_WIDGET); n++;
				*/
				radio_box = XmCreateRadioBox(SettingsForm, "", args, n);

				ww1= XtVaCreateManagedWidget("ACB Stereo",
						xmToggleButtonGadgetClass, radio_box, 
						XmNset,s1,
						NULL);
				XtAddCallback(ww1, XmNvalueChangedCallback, (XtCallbackProc)toggled_sound, (XtPointer) 1);

				two1 = XtVaCreateManagedWidget("ABC Stereo",
						xmToggleButtonGadgetClass, radio_box, 
						XmNset,s2,
						NULL);
				XtAddCallback(two1, XmNvalueChangedCallback, (XtCallbackProc)toggled_sound, (XtPointer) 2);

				three1 = XtVaCreateManagedWidget("Mono",
						xmToggleButtonGadgetClass, radio_box,
						XmNset,s3,
						NULL);
				XtAddCallback(three1, XmNvalueChangedCallback, (XtCallbackProc)toggled_sound, (XtPointer) 3);

				XtManageChild(radio_box);


				label=XtVaCreateManagedWidget("add_label 1", xmLabelWidgetClass, SettingsForm,
						XmNlabelString, XmStringCreate ("Sampling rate :",XmFONTLIST_DEFAULT_TAG),
						XmNleftWidget,  separator1,
						XmNleftAttachment, XmATTACH_WIDGET,
						NULL);

				n = 0;
				XtSetArg(args[n], XmNtopWidget,  label); n++;
				XtSetArg(args[n], XmNtopAttachment,  XmATTACH_WIDGET); n++;
				XtSetArg(args[n], XmNleftWidget,  separator1); n++;
				XtSetArg(args[n], XmNleftAttachment,  XmATTACH_WIDGET); n++;

				radio_box = XmCreateRadioBox(SettingsForm, "Stereo mode", args, n);

				ss_ww= XtVaCreateManagedWidget("44100 Hz",
						xmToggleButtonGadgetClass, radio_box, 
						XmNset,r1,
						NULL);
				XtAddCallback(ss_ww, XmNvalueChangedCallback, (XtCallbackProc)toggled_sound_freq, (XtPointer) 1);

				ss_two = XtVaCreateManagedWidget("22050 Hz",
						xmToggleButtonGadgetClass, radio_box, 
						XmNset,r2,
						NULL);
				XtAddCallback(ss_two, XmNvalueChangedCallback, (XtCallbackProc)toggled_sound_freq, (XtPointer) 2);

				ss_three = XtVaCreateManagedWidget("11025 Hz",
						xmToggleButtonGadgetClass, radio_box,
						XmNset,r3,
						NULL);
				XtAddCallback(ss_three, XmNvalueChangedCallback, (XtCallbackProc)toggled_sound_freq, (XtPointer) 3);

				XtManageChild(radio_box);


				n = 0;
				XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
				XtSetArg(args[n], XmNleftWidget,  label); n++;
				XtSetArg(args[n], XmNleftAttachment,  XmATTACH_WIDGET); n++;
				XtSetArg(args[n], XmNtopAttachment,  XmATTACH_FORM); n++;
				XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
				XtSetArg(args[n], XmNwidth,20);n++;
				XtSetArg(args[n], XmNmargin,10);n++;

				separator=XmCreateSeparator(SettingsForm, "", args, n);
				XtManageChild(separator);

				label=XtVaCreateManagedWidget("add_label 1", xmLabelWidgetClass, SettingsForm,
						XmNlabelString, XmStringCreate ("Additional settings :",XmFONTLIST_DEFAULT_TAG),
						XmNleftWidget,  separator,
						XmNleftAttachment, XmATTACH_WIDGET,
						NULL);


				n = 0;
				XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
				XtSetArg(args[n], XmNleftWidget,  separator); n++;
				XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
				XtSetArg(args[n], XmNtopWidget,  label); n++;
				XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;

				rc = XmCreateRowColumn(SettingsForm, "rowcol", args, n);

				XtVaCreateManagedWidget("add_label 1", xmLabelWidgetClass, rc,
					XmNlabelString, XmStringCreate ("Output device :",XmFONTLIST_DEFAULT_TAG),
					XmNwidth,100,
					XmNrecomputeSize,0,
					NULL);

				ss_dev=XtVaCreateManagedWidget("", xmTextWidgetClass, rc,
						XmNwidth,80,
						XmNeditable, True,
						XmNmaxLength,255,
						NULL);

				n = 0;
				XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
				tape_rc_rc2 = XmCreateRowColumn(rc, "rowcol", args, n);

				n = 0;
				XtSetArg(args[n], XmNlabelString,  XmStringCreate (" Apply ",XmFONTLIST_DEFAULT_TAG)); n++;
				XtSetArg(args[n], XmNshadowThickness, 1); n++; 
				XtSetArg(args[n], XmNhighlightThickness,1); n++; 

				button=XmCreatePushButton(tape_rc_rc2, "", args, n);
				XtManageChild(button);
				XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) setSNDDev, NULL);

				XtManageChild(tape_rc_rc2);
				XtManageChild(rc);

				/* tape_dev */
				n = 0;
				XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
				XtSetArg(args[n], XmNleftWidget,  separator); n++;
				XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
				XtSetArg(args[n], XmNtopWidget,  rc); n++;
				XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;

				rc = XmCreateRowColumn(SettingsForm, "rowcol", args, n);

				tape_dev_label=XtVaCreateManagedWidget("add_label 1", 
						xmLabelWidgetClass, rc,
						XmNlabelString, XmStringCreate ("Input device :",XmFONTLIST_DEFAULT_TAG),
						XmNwidth,100,
						XmNrecomputeSize,0,
						NULL);

				tape_dev=XtVaCreateManagedWidget("", 
						xmTextWidgetClass, rc,
						XmNwidth,80,
						XmNeditable, True,
						XmNmaxLength,255,
						NULL);

				n = 0;
				XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
				tape_rc_rc2 = XmCreateRowColumn(rc, "rowcol", args, n);

				n = 0;
				XtSetArg(args[n], XmNlabelString,  XmStringCreate (" Apply ",XmFONTLIST_DEFAULT_TAG)); n++;
				XtSetArg(args[n], XmNshadowThickness, 1); n++; 
				XtSetArg(args[n], XmNhighlightThickness,1); n++; 

				tape_dev_button=XmCreatePushButton(tape_rc_rc2, "", args, n);
				XtManageChild(tape_dev_button);

				XtAddCallback(tape_dev_button, XmNactivateCallback, (XtCallbackProc) setRecDev, NULL);

				XtManageChild(tape_rc_rc2);
				XtManageChild(rc);

				n = 0;
				XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
				XtSetArg(args[n], XmNleftWidget,  separator); n++;
				XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
				XtSetArg(args[n], XmNtopWidget,  rc); n++;
				XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;

				rc = XmCreateRowColumn(SettingsForm, "rowcol", args, n);

				ss_slider=XtVaCreateManagedWidget("Beeper volume",
						xmScaleWidgetClass, rc,
						XmNtitleString, XmStringCreate ("Beeper volume",XmFONTLIST_DEFAULT_TAG),
						XmNminimum,       0,
						XmNmaximum,       15,
						XmNdecimalPoints, 0,
						XmNshowValue,     True,
						XmNorientation, XmHORIZONTAL,
						XmNwidth,         100,
						XmNvalue,         beeper_volume,
						NULL);

				XtAddCallback(ss_slider, XmNvalueChangedCallback, (XtCallbackProc) setBeeper_Volume, NULL);
				XtAddCallback(ss_slider, XmNdragCallback, (XtCallbackProc) setBeeper_Volume, NULL);

				XtManageChild(rc);

				ShowSSKakNado();
				XmTextSetString(ss_dev, audio_name);  
				XmTextSetString(tape_dev, sound_device_nameR);	
			}

			XtManageChild(SettingsForm); XtManageChild(frame); XtManageChild(child1);
		}


		{
			child1 = XtVaCreateWidget("Joystick & mouse", xmFormWidgetClass, tab_wid,
					NULL);

			frame = XtVaCreateWidget("Frame", xmFrameWidgetClass, child1,
					XmNleftAttachment, XmATTACH_FORM,
					XmNrightAttachment, XmATTACH_FORM,
					XmNtopAttachment, XmATTACH_FORM,
					XmNbottomAttachment, XmATTACH_FORM,
					XmNmarginWidth,  5,
					XmNmarginHeight, 5,
					NULL);

			XtVaCreateManagedWidget("Joystick & mouse", xmLabelWidgetClass, frame,
				XmNchildType, XmFRAME_TITLE_CHILD,
				NULL);

			SettingsForm=XtVaCreateWidget("form", xmFormWidgetClass, 
					frame, NULL);

			{
				s1=s2=s3=False;

				if (joy_type==0)
					s1=True;

				if (joy_type==1)
					s2=True;
				if (joy_type==2)
					s3=True;

				label=XtVaCreateManagedWidget("add_label", xmLabelWidgetClass, SettingsForm,
						XmNlabelString, XmStringCreate ("Joystick type :",XmFONTLIST_DEFAULT_TAG),
						XmNleftAttachment,  XmATTACH_FORM,
						NULL);


				n = 0;
				XtSetArg(args[n], XmNtopWidget,  label); n++;
				XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;

				radio_box = XmCreateRadioBox(SettingsForm, "Joystick type", args, n);

				two=XtVaCreateManagedWidget("Kempston",
						xmToggleButtonGadgetClass, radio_box, 
						XmNset,s1,
						NULL);
				XtAddCallback(two, XmNvalueChangedCallback, (XtCallbackProc)toggled_joy, (XtPointer) 0);

				two = XtVaCreateManagedWidget("Sinclair",
						xmToggleButtonGadgetClass, radio_box, 
						XmNset,s2,
						NULL);
				XtAddCallback(two, XmNvalueChangedCallback, (XtCallbackProc)toggled_joy, (XtPointer) 1);

				two = XtVaCreateManagedWidget("Cursor",
						xmToggleButtonGadgetClass, radio_box, 
						XmNset,s3,
						NULL);
				XtAddCallback(two, XmNvalueChangedCallback, (XtCallbackProc) toggled_joy, (XtPointer) 2);

				XtManageChild(radio_box);


				n = 0;
				XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
				XtSetArg(args[n], XmNleftWidget,  label); n++;
				XtSetArg(args[n], XmNleftAttachment,  XmATTACH_WIDGET); n++;
				XtSetArg(args[n], XmNtopAttachment,  XmATTACH_FORM); n++;
				XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
				XtSetArg(args[n], XmNwidth,20);n++;
				XtSetArg(args[n], XmNmargin,10);n++;

				separator=XmCreateSeparator(SettingsForm, "", args, n);
				XtManageChild(separator);

				label=XtVaCreateManagedWidget("add_label", xmLabelWidgetClass, SettingsForm,
						XmNlabelString, XmStringCreate ("Kempston mouse :",XmFONTLIST_DEFAULT_TAG),
						XmNleftAttachment,  XmATTACH_WIDGET,
						XmNleftWidget,separator,
						NULL);

				n = 0;
				XtSetArg(args[n], XmNtopWidget,  label); n++;
				XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
				XtSetArg(args[n], XmNleftWidget,  separator); n++;
				XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;

				radio_box = XmCreateRadioBox(SettingsForm, "Joystick type", args, n);

				two=XtVaCreateManagedWidget("On",
						xmToggleButtonGadgetClass, radio_box, 
						XmNset,kempston_mouse,
						NULL);
				XtAddCallback(two, XmNvalueChangedCallback, (XtCallbackProc) toggled_km, (XtPointer) 1);

				two = XtVaCreateManagedWidget("Off",
						xmToggleButtonGadgetClass, radio_box, 
						XmNset,1-kempston_mouse,
						NULL);
				XtAddCallback(two, XmNvalueChangedCallback, (XtCallbackProc) toggled_km, (XtPointer) 0);

				XtManageChild(radio_box);
			}

			XtManageChild(SettingsForm); XtManageChild(frame); XtManageChild(child1);
		}

		XtManageChild(tab_wid);

		button = XtVaCreateManagedWidget(" Close ", 
				xmPushButtonWidgetClass, form, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1, 
				XmNrightAttachment, XmATTACH_FORM, 
				XmNtopWidget, tab_wid, 
				XmNtopAttachment, XmATTACH_WIDGET, 
				XmNbottomAttachment, XmATTACH_FORM, 
				NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) CloseDialog, NULL);
	}

	XtManageChild(form);
	XtManageChild(pane);
	XtPopup(dialog, XtGrabNone);
	XRaiseWindow(display,XtWindow(dialog));

	FixHeight(dialog);
}

void tape_settings_h(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	static Widget dialog;
	static Widget pane;
	static Widget form; 

	Widget button;
	Widget p; 
	static Widget f=NULL;
	static Widget f1=NULL;
	Widget rc, rc1;

	Widget tapeSBA1, tapeSBA2;


	Colormap colormap;
	int colorcells;
	XColor color;
	XGCValues gcv;
	int i,j;


	if (!dialog)
	{
		dialog = XtVaCreatePopupShell("VirtualTape_main",
				xmDialogShellWidgetClass, first_window,
				NULL);

		pane = XtVaCreateWidget("pane", xmPanedWindowWidgetClass, dialog,
				XmNsashWidth,  1, /* try to "hide" resizing sash.  PanedWindow */
				XmNsashHeight, 1, /* won't let us set to 0, so 1 will have to do */
				NULL);

		form = XtVaCreateWidget("form", xmFormWidgetClass, pane, NULL);


		p = XtVaCreateWidget("pane",
				xmPanedWindowWidgetClass, form,
				XmNleftAttachment, XmATTACH_FORM,
				XmNrightAttachment, XmATTACH_FORM, 
				XmNbottomAttachment, XmATTACH_FORM,
				XmNtopAttachment, XmATTACH_FORM,
				XmNsashWidth,  1, /* try to "hide" resizing sash.  PanedWindow */
				XmNsashHeight, 1, /* won't let us set to 0, so 1 will have to do */
				NULL);

		n=0;
		XtSetArg(args[n], XmNvisibleItemCount, 10); n++;
		XtSetArg(args[n], XmNwidth, 400); n++;
		XtSetArg(args[n], XmNfontList, fontlist1); n++; 
		XtSetArg(args[n], XmNselectionPolicy,  XmSINGLE_SELECT); n++;
		XtSetArg(args[n],XmNpaneMinimum,    35); n++;

		tape_lb= XmCreateScrolledList(p, "tape_list", args, n);
		XtManageChild(tape_lb);

		XtAddCallback(tape_lb, XmNsingleSelectionCallback, (XtCallbackProc) tape_lb_selected, NULL);

		f = XtVaCreateWidget("form", 
				xmFormWidgetClass, p,
				NULL);

		n = 0;
		XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
		XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
		XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
		XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
		XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;

		rc1 = XmCreateRowColumn(f, "rowcol", args, n);

		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		XtSetArg(args[n], XmNmarginHeight, 0); n++;

		rc = XmCreateRowColumn(rc1, "rowcol", args, n);

		button = XtVaCreateManagedWidget(" Load image ", 
				xmPushButtonWidgetClass, rc, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1, 
				XmNmarginHeight, 3,
				NULL);

		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) tape_create_selectFNdialog, NULL);

		tape_eject = XtVaCreateManagedWidget(" Eject image ", 
				xmPushButtonWidgetClass, rc, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1, 
				XmNmarginHeight, 3,
				NULL);
		XtAddCallback(tape_eject, XmNactivateCallback, (XtCallbackProc) FreeTape, NULL);

		tape_saveAs = XtVaCreateManagedWidget(" Save as ", 
				xmPushButtonWidgetClass, rc, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1, 
				XmNmarginHeight, 3,
				NULL);
		XtAddCallback(tape_saveAs, XmNactivateCallback, (XtCallbackProc) tape_saveF, NULL);

		n = 0;
		XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
		XtSetArg(args[n], XmNwidth, 10); n++;
		tape_sep1=XmCreateSeparator(rc, "", args, n);
		XtManageChild(tape_sep1);

		n = 0;
		XtSetArg(args[n], XmNhighlightThickness, 1); n++;
		XtSetArg(args[n], XmNshadowThickness, 1); n++;
		XtSetArg(args[n], XmNarrowDirection, XmARROW_RIGHT); n++;
		tape_play = XmCreateArrowButton(rc, "arrowbtn", args, n);
		XtManageChild(tape_play);

		AddTip(tape_play, "Play");
		XtAddCallback(tape_play, XmNactivateCallback, (XtCallbackProc) tape_playF, NULL);

		tape_pause = XtVaCreateManagedWidget("Pause", 
				xmPushButtonWidgetClass, rc, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1, 
				NULL);
		XtAddCallback(tape_pause, XmNactivateCallback, (XtCallbackProc) tape_pauseF, NULL);

		tape_stop = XtVaCreateManagedWidget("Stop", 
				xmPushButtonWidgetClass, rc, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1, 
				XmNmarginHeight, 3,
				NULL);
		XtAddCallback(tape_stop, XmNactivateCallback, (XtCallbackProc) tape_stopF, NULL);

		n = 0;
		XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
		XtSetArg(args[n], XmNwidth, 10); n++;
		tape_sep2=XmCreateSeparator(rc, "", args, n);
		XtManageChild(tape_sep2);

		tape_delete = XtVaCreateManagedWidget(" Delete ", 
				xmPushButtonWidgetClass, rc, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1, 
				XmNmarginHeight, 3,
				NULL);
		XtAddCallback(tape_delete, XmNactivateCallback, (XtCallbackProc) tape_deleteF, NULL);

		tape_view = XtVaCreateManagedWidget(" View ", 
				xmPushButtonWidgetClass, rc, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1, 
				XmNmarginHeight, 3,
				NULL);
		XtAddCallback(tape_view, XmNactivateCallback, (XtCallbackProc) tape_viewF, NULL);

		XtManageChild(rc);

		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		tape_sc_label=XmCreateSeparator(rc1, "", args, n);
		XtManageChild(tape_sc_label);

		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		XtSetArg(args[n], XmNmarginHeight, 0); n++;
		tape_rc1 = XmCreateRowColumn(rc1, "rowcol", args, n);

		tape_sc_ROMb = XtVaCreateManagedWidget(" Tape Recovery Tool ", 
				xmToggleButtonWidgetClass, tape_rc1, 
				XmNhighlightThickness, 1, 
				XmNmarginHeight, 3,
				XmNindicatorOn, False,
				XmNshadowThickness, 1,
				XmNfillOnSelect, True,
				NULL);
		XtAddCallback(tape_sc_ROMb, XmNvalueChangedCallback, (XtCallbackProc)tape_sc_ROM_begin, NULL);
		AddTip(tape_sc_ROMb, "Get ROM blocks from the real tape recorder using sound card");

		tape_sc_rec = XtVaCreateManagedWidget(" Direct Recording ", 
				xmToggleButtonWidgetClass, tape_rc1, 
				XmNhighlightThickness, 1, 
				XmNindicatorOn, False,
				XmNshadowThickness, 1,
				XmNfillOnSelect, True,
				XmNmarginHeight, 3,
				NULL);
		XtAddCallback(tape_sc_rec, XmNvalueChangedCallback, (XtCallbackProc)Direct, NULL);
		AddTip(tape_sc_rec, "Get Direct Recording blocks from the real tape recorder using sound card");

		tape_em_rec = XtVaCreateManagedWidget(" Direct MIC ", 
				xmToggleButtonWidgetClass, tape_rc1, 
				XmNhighlightThickness, 1, 
				XmNindicatorOn, False,
				XmNshadowThickness, 1,
				XmNfillOnSelect, True,
				XmNmarginHeight, 3,
				NULL);

		AddTip(tape_em_rec, "Get Direct Recording blocks from the emulated MIC port");
		XtAddCallback(tape_em_rec, XmNvalueChangedCallback, (XtCallbackProc)tape_DirectMIC, NULL);

		n = 0;
		XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
		XtSetArg(args[n], XmNwidth, 10); n++;
		tape_ezhe_sep=XmCreateSeparator(tape_rc1, "", args, n);
		XtManageChild(tape_ezhe_sep);

		tape_sc_lev=XtVaCreateManagedWidget("", 
				xmDrawingAreaWidgetClass, tape_rc1, 
				XmNwidth, 50, 
				NULL);

		XtAddCallback(tape_sc_lev,  XmNexposeCallback, (XtCallbackProc) drawing_events_sc_vol, NULL);

		gcv.foreground = BlackPixelOfScreen(XtScreen(tape_sc_lev));
		gcv.background = WhitePixelOfScreen(XtScreen(tape_sc_lev));
		gclev = XCreateGC(display, RootWindowOfScreen(XtScreen(tape_sc_lev)),
				GCForeground|GCBackground, &gcv);

		colormap=DefaultColormapOfScreen(XtScreen(tape_sc_lev));
		colorcells=0;
		while(Palettelev && Palettelev[3*colorcells++]!=-1);

		palettelev=(unsigned long*)malloc(colorcells*sizeof(unsigned long));

		for(i=j=0;i<colorcells;i++)
		{
			color.flags=DoRed|DoGreen|DoBlue;
			color.red=Palettelev[i*3]<<8;
			color.green=Palettelev[i*3+1]<<8;
			color.blue=Palettelev[i*3+2]<<8;

			if(XAllocColor(display,colormap,&color))
				palettelev[j++]=color.pixel;
		}

		XSetWindowColormap(display,RootWindowOfScreen(XtScreen(tape_sc_lev)),colormap);


		XtManageChild(tape_rc1);
		XtManageChild(rc1);
		XtManageChild(f); 

		f1 = XtVaCreateWidget("form", 
				xmFormWidgetClass, p,
				NULL);

		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		XtSetArg(args[n], XmNmarginHeight, 0); n++;
		XtSetArg(args[n], XmNspacing, 0); n++;
		XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;

		tape_rc3 = XmCreateRowColumn(f1, "rowcol", args, n);
		XtManageChild(tape_rc3);

		n = 0;
		XtSetArg(args[n], XmNhighlightThickness, 0); n++;
		XtSetArg(args[n], XmNshadowThickness, 0); n++;
		XtSetArg(args[n], XmNarrowDirection, XmARROW_LEFT); n++;

		tapeSBA1 = XmCreateArrowButton(tape_rc3, "arrowbtn", args, n);
		XtManageChild(tapeSBA1);
		XtAddCallback(tapeSBA1, XmNactivateCallback, (XtCallbackProc) tape_loading_methodDecrease, NULL);

		n = 0;
		XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
		tapedrc = XmCreateRowColumn(tape_rc3, "rowcol", args, n);

		tape_q=XtVaCreateManagedWidget("", xmTextWidgetClass, tapedrc,
				XmNwidth,175,
				XmNeditable, False,
				XmNmaxLength,255,
				XmNhighlightThickness, 0,
				XmNshadowThickness, 2,
				NULL);

		XtManageChild(tapedrc);

		n = 0;
		XtSetArg(args[n], XmNhighlightThickness, 0); n++;
		XtSetArg(args[n], XmNshadowThickness, 0); n++;
		XtSetArg(args[n], XmNarrowDirection, XmARROW_RIGHT); n++;
		XtSetArg(args[n], XmNvalue, XmStringCreateSimple("aaa")); n++;

		tapeSBA2 = XmCreateArrowButton(tape_rc3, "arrowbtn", args, n);
		XtManageChild(tapeSBA2);
		XtAddCallback(tapeSBA2, XmNactivateCallback, (XtCallbackProc) tape_loading_methodIncrease, NULL);


		n = 0;
		XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
		XtSetArg(args[n], XmNwidth, 20); n++;
		tape_s1=XmCreateSeparator(tape_rc3, "", args, n);
		XtManageChild(tape_s1);

		button=XtVaCreateManagedWidget("Tape traps",
				xmToggleButtonGadgetClass, tape_rc3, 
				XmNset, tape_traps,
				XmNhighlightThickness,0, 				
				NULL);
		XtAddCallback(button, XmNvalueChangedCallback,(XtCallbackProc)toggled_tape, (XtPointer) 2);

		/*
		n = 0;
		XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
		XtSetArg(args[n], XmNwidth, 20); n++;
		tape_separator=XmCreateSeparator(tape_rc3, "", args, n);
		XtManageChild(tape_separator);
		*/


		button = XtVaCreateManagedWidget(" Close ", 
				xmPushButtonWidgetClass, f1, 
				XmNhighlightThickness, 1, 
				XmNshadowThickness, 1,
				XmNrightAttachment, XmATTACH_FORM,
				XmNbottomAttachment, XmATTACH_FORM,
				XmNmarginHeight, 4,
				NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) CloseDialog2pm, NULL);

		XtManageChild(f1); 

		XtManageChild(p);	

		DisableWidget(tape_play);
		DisableWidget(tape_stop);
		DisableWidget(tape_pause);
		DisableWidget(tape_delete);
		DisableWidget(tape_view);
	}

	if (!client_data)
	{	
		XtManageChild(form);
		XtManageChild(pane);
		XtPopup(dialog, XtGrabNone);
		XRaiseWindow(display,XtWindow(dialog));

		FixPaneH(f);
		FixPaneH(f1); 
		FixWidth(dialog);

		if (tape_loading_method==0)XmTextSetString(tape_q,"Slow loading");
		if (tape_loading_method==1)XmTextSetString(tape_q,"Fast loading");
		if (tape_loading_method==2)XmTextSetString(tape_q,"No screen update");
	}
}

static XtSignalId signalID;
static void signalCB(XtPointer clientData, XtSignalId *id)
{
	ROM_bl_type * ROMbl;


	if (*id == signalID)
	{
		ROMbl=message.data;

		sprintf(tstring, " Pa=%d", ROMbl->pause);
		strcat(infobuffer, tstring);

		AddTapeBlock(infobuffer, 0x10, ROMbl->len, message.data2, sizeof(ROMbl), ROMbl, 1);
		free(message.data);
		free(message.data2);
	}
}	

static void handler1(int sig)
{
	if (sig == SIGUSR1)
		XtNoticeSignal(signalID);
}

static XtSignalId signalID1;
static void signalCB1(XtPointer clientData, XtSignalId *id)
{
	tape_show_rec_vol((unsigned char)(int)message.data1);
}	

static void handler2(int sig)
{
	if (sig == SIGUSR2)
		XtNoticeSignal(signalID1);
}

unsigned long long otime=0;
unsigned long long ntime;

Boolean video(XtPointer unused)
{
	if (ready)
	{
		if ((!sound)&&(!direct_recording))
		{
			ntime=GetCurrentTime();

			if ((ntime-otime)<timeout)
				return(0);
		}

		timerfunc();
		otime=ntime;
	}

	return(0);
}

Boolean WM_set_close_callback(shell, callback, client_data)
	Widget       shell ;
	void         (*callback)() ;
	XtPointer    client_data ;
{
	extern Atom XmInternAtom(Display *, char *, Boolean) ;

	Display *display  = (Display *) 0 ;
	Atom     property = (Atom) 0 ;
	Atom     protocol = (Atom) 0 ;


	if (shell == (Widget) 0) {
		return False ;
	}

	if ((display = XtDisplay(shell)) == (Display *) 0) {
		return False ;
	}

	if ((property = XmInternAtom(display,
					"WM_PROTOCOLS",
					False)) == (Atom) 0) {
		return False ;
	}

	if ((protocol = XmInternAtom(display,
					"WM_DELETE_WINDOW",
					True)) == (Atom) 0) {
		return False ;
	}

	XmAddProtocols(shell, property, &protocol, 1) ;

	XmAddProtocolCallback(shell,
		property,
		protocol,
		callback,
		client_data) ;

	return True ;
}

void network_h(w, client_data, cbs)
	Widget w;
	XtPointer client_data;
	XmPushButtonCallbackStruct *cbs;
{
	NajatKnopku(networkB, False);
	MessageBoxErr("Not completed yet");
}

void usage(char *name)
{
	printf(
	"\nUGluk spectrum emulator v.%s\n"
	"\nUSAGE:\n%s [OPTIONS]\n"
	"Options:\n"
	"-h      Print this help and exit\n"
	"-d<n>=filename     insert disk image into drive<n> (n=1..4)\n"
	"-tape=filename     insert tape image\n"
	"-snap=filename     load snapshot\n"
	"\n"
	,VERSION,name);
	return;	
}

int main(argc, argv)
	int argc;
	char **argv;
{	
	int i=0,dnum=0;
	char load_snap[300];
	
	XFontStruct * font1;  
	XFontStruct * font2;

	Widget pane;
	Widget last;

	*tape_filename=0;
	*load_snap=0;
	LoadDefaults();
	
	DBG_PR("parsing command line...");
	
	for(i=1;i<argc;++i)
	{
		if(*(argv[i])!='-') /* Not an option but a filename */
		{

		}
		else /* option */
		{
			char *opt=(argv[i]+1);
			
			if(!strcmp(opt,"h"))
			{
				usage(argv[0]);
				exit(0);
			}
			else if(!strncmp(opt,"d",1))
			{
				opt+=1;
				dnum=atoi(opt);
				while(isdigit(*opt)) ++opt;
				
				if(*opt=='=' && dnum > 0 && dnum < 5)
				{
					++opt;
					strcpy(discs[dnum-1].filename,opt);
					DBG_PR("using %s as disk #%d",discs[dnum-1].filename,dnum);
				}
				else
				{
					ERR_PR("Incorrect option: %s", argv[i]);
				}					
			}
			else if(!strncmp(opt,"tape=",5))
			{
				opt+=5;
				strcpy(tape_filename,opt);
			}
			else if(!strncmp(opt,"snap=",5))
			{
				opt+=5;
				strcpy(load_snap,opt);
			}			
			else 
			{
				ERR_PR("Unknown option: -%s!\n"
					"use -h option to get help",opt);
				exit(1);
			}
		}
		
	}

#if defined FUSE_engine
	z80_init();	
#endif 

	XColors32_2=(unsigned long long *)XColors32_help;

	FillXLib_Help_Array();
	FillParityTBL();
	WindowedModeStorage.FullScreen=0;

	px_up=(Pixmap)malloc(ICON_BUFFER_LEN);
	aaa=(Pixmap)malloc(ICON_BUFFER_LEN);

	appshell = XtVaAppInitialize(&app_context,                                                  
			"UGluk ZX-Spectrum emulator",                                                            
			NULL, 0,                                         
			&argc, argv,                                                               
			NULL,                                             
			NULL);                                   

	display = XtDisplay (appshell);

	PixmapsAllocAndFill();

	{
		mainpid=getpid();

		signalID = XtAppAddSignal(app_context, signalCB, 0);
		signal(SIGUSR1, handler1);

		signalID1 = XtAppAddSignal(app_context, signalCB1, 0);
		signal(SIGUSR2, handler2);
	}		

	font1 = XLoadQueryFont(display,"fixed");                             
	if (font1==NULL)
	{
		printf("Unable Load fixed Font. Exiting.\n");
		exit(-1);
	}
	fontlist1 = XmFontListCreate(font1,"chset1");

	font2 = XLoadQueryFont(display,"-*-*-*-*-*-*-6-*-*-*-*-*-*-*");                             
	if (font2==NULL)
	{
		printf("Unable Load font -*-*-*-*-*-*-6-*-*-*-*-*-*-* ---> Exiting.\n");
		exit(-1);
	}
	fontlist2 = XmFontListCreate(font2,"chset2");

	first_window=XtVaCreateManagedWidget("first_w",
			xmFormWidgetClass, appshell, 
			NULL);
	XtManageChild(first_window);

	Dialog = XtVaCreatePopupShell("",
			xmDialogShellWidgetClass, appshell,
			XmNtitle,  "UGluk ZX-Spectrum emulator",
			NULL);

	pane = XtVaCreateWidget("pane", xmPanedWindowWidgetClass, Dialog,
			XmNsashWidth,  1,
			XmNsashHeight, 1, 
			NULL);

	main_window = XtVaCreateWidget("form", xmFormWidgetClass, pane, 
			NULL);

	n = 0;
	XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
	XtSetArg(args[n], XmNspacing,1);n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;

	ToolBar = XmCreateForm(main_window, "rowcol", args, n);

# define SPACE_0 1
# define SPACE_1 5

	last=AddButton(ToolBar,ICONPATH"/reset.xpm",reset_h,"Reset",ICON_SIZE,ICON_SIZE,NULL,0,NULL,1);
	last=AddButton(ToolBar,ICONPATH"/pause.xpm",emu_go_pause_h,"Pause",ICON_SIZE,ICON_SIZE,&emu_go_pause_b,SPACE_0,last,1);

	last=AddButton(ToolBar,ICONPATH"/open.xpm",open_sn_h,"Load snapshot",ICON_SIZE,ICON_SIZE,NULL,SPACE_1,emu_go_pause_b,1);
	last=AddButton(ToolBar,ICONPATH"/save.xpm",save_sn_h,"Save snapshot",ICON_SIZE,ICON_SIZE,NULL,SPACE_0,last,1),

	last=AddButton(ToolBar,ICONPATH"/disc.xpm",disc_settings_h,"Disk selection",ICON_SIZE,ICON_SIZE,NULL,SPACE_1,last,1);
	last=AddButton(ToolBar,ICONPATH"/tape.xpm",tape_settings_h,"Virtual Tape",ICON_SIZE,ICON_SIZE,NULL,SPACE_0,last,1);

	last=AddButton(ToolBar,ICONPATH"/settings.xpm",settings_h,"Settings",ICON_SIZE,ICON_SIZE,NULL,SPACE_1,last,1);

#if defined XF86VMODE
	FullScreenB=AddButtonT(ToolBar,ICONPATH"/fullscreen.xpm",FullScreen,"Full Screen",ICON_SIZE,ICON_SIZE, SPACE_0, last);
	last=FullScreenB;
#endif

	DumpAudioButton=AddButtonT(ToolBar,ICONPATH"/dump_s.xpm",Dump_Audio_dialog_create, "Dump sound into file", ICON_SIZE, ICON_SIZE, SPACE_1, last);
	Direct_TB=AddButtonT(ToolBar,ICONPATH"/direct_rec.xpm",direct_tape_start, "Direct Tape - Use real tape recorder", ICON_SIZE, ICON_SIZE, SPACE_0, DumpAudioButton);

	AddButton(ToolBar,ICONPATH"/poke.xpm",poke_h, "POKEs", ICON_SIZE,ICON_SIZE,NULL,4,networkB,1);

	XtManageChild(ToolBar);

	LookForIniFileEx();
	
	if (ApplyParameters()==errors) exit(0);


	XtManageChild(main_window);
	XtManageChild(pane);
	XtManageChild (Dialog);
	XtPopup(Dialog, XtGrabNone);

	toggled_sz(NULL, screen_size, NULL);

	WM_set_close_callback(Dialog, exitPoF10, NULL);

	atexit(Exiting1);

	XtAddEventHandler(Dialog, FocusChangeMask, 0, (XtEventHandler)change_focus, NULL);

	if (strcmp(Mode,"48")!=0)
		Set128kMode();
	else
		Set48kMode();

	if (!wpid) wpid=XtAppAddWorkProc(app_context, video, NULL);

	tape_settings_h(main_window, 1, NULL);	
	disc_settings_h(main_window, 1, NULL);

	/*load snapshot, if given*/
	if(*load_snap)
	{
		if(!open_snapshot(load_snap))
		{
			ERR_PR("Cannot load snapshot file: %s", load_snap);
		}
		else
		{
			DBG_PR("loaded %s as snapshot",load_snap);
		}
	}
	
	/*load tape file, if it was given*/
	
	if(*tape_filename)
	{
		if(!load_tape(tape_filename))
		{
			ERR_PR("Cannot load tape file: %s", tape_filename);
		}
		else
		{
			DBG_PR("loaded %s as tape file", tape_filename);
		}
	}
	
	gui_running=1;
	
	XtAppMainLoop(app_context);

	return(0);
}

void ApplySoundRegister(int r, int v)
{
	if (r<=AY_ESHAPE)
		Regs1[r]=v;

	switch( r )
	{
		case AY_AFINE:
		case AY_ACOARSE:
			Regs1[AY_ACOARSE] &= 0x0f;
			GeneratorA_period = (Regs1[AY_AFINE] + 256 * Regs1[AY_ACOARSE]) * UpdateStep / STEP;
			if (GeneratorA_period == 0)GeneratorA_period=UpdateStep / STEP;
			break;

		case AY_BFINE:
		case AY_BCOARSE:
			Regs1[AY_BCOARSE] &= 0x0f;
			GeneratorB_period = (Regs1[AY_BFINE] + 256 * Regs1[AY_BCOARSE]) * UpdateStep / STEP;
			if (GeneratorB_period == 0)GeneratorB_period=UpdateStep / STEP;

			break;

		case AY_CFINE:
		case AY_CCOARSE:
			Regs1[AY_CCOARSE] &= 0x0f;
			GeneratorC_period = (Regs1[AY_CFINE] + 256 * Regs1[AY_CCOARSE]) * UpdateStep / STEP;
			if (GeneratorC_period == 0)GeneratorC_period=UpdateStep / STEP;
			break;

		case AY_AVOL:
			Regs1[AY_AVOL] &= 0x1f;

			if (avol_max<Regs1[AY_AVOL])avol_max=Regs1[AY_AVOL];

			break;

		case AY_BVOL:
			Regs1[AY_BVOL] &= 0x1f;

			if (bvol_max<Regs1[AY_BVOL])bvol_max=Regs1[AY_BVOL];

			break;

		case AY_CVOL:
			Regs1[AY_CVOL] &= 0x1f;

			if (cvol_max<Regs1[AY_CVOL])cvol_max=Regs1[AY_CVOL];

			break;

		case AY_ENABLE: 

			if ((Regs1[AY_ENABLE]&1))
				channelA_enabled=1;
			else
				channelA_enabled=0;

			if ((Regs1[AY_ENABLE]&2))
				channelB_enabled=1;
			else
				channelB_enabled=0;

			if ((Regs1[AY_ENABLE]&4))
				channelC_enabled=1;
			else
				channelC_enabled=0;

			if ((Regs1[AY_ENABLE]&8))
				noiseA_enabled=1;
			else
				noiseA_enabled=0;

			if ((Regs1[AY_ENABLE]&16))
				noiseB_enabled=1;
			else
				noiseB_enabled=0;

			if ((Regs1[AY_ENABLE]&32))
				noiseC_enabled=1;
			else
				noiseC_enabled=0;

			break;

		case AY_NOISEPER:                                                                          
			Regs1[AY_NOISEPER] &= 0x1f;                                                    
			PeriodN = Regs1[AY_NOISEPER] * UpdateStep / STEP;                           
			if (PeriodN == 0) PeriodN = UpdateStep / STEP;                             
			break;         

		case AY_EFINE:                                                                             
		case AY_ECOARSE:                                                                           
			periodE = ((Regs1[AY_EFINE] + 256 * Regs1[AY_ECOARSE])) * UpdateStep / STEP;                                                                                               
			if (periodE == 0) periodE = UpdateStep / STEP / 2;                         
			break;      


		case AY_ESHAPE: 
			Regs1[AY_ESHAPE] &= 0x0f;  

			switch(Regs1[AY_ESHAPE])
			{
				case 0 :
				case 1 :
				case 2 :
				case 3 :
					cont=0;
					att=0;
					break;

				case 4 :
				case 5 :
				case 6 :
				case 7 :
					cont=0;
					att=1;
					break;

				case 8:
					cont=1;
					att=0;
					alt=0;
					hold=0;
					break;

				case 9:
					cont=1;
					att=0;
					alt=0;
					hold=1;
					break;

				case 10:
					cont=1;
					att=0;
					alt=1;
					hold=0;
					break;

				case 11:
					cont=1;
					att=0;
					alt=1;
					hold=1;
					break;

				case 12:
					cont=1;
					att=1;
					alt=0;
					hold=0;
					break;


				case 13:
					cont=1;
					att=1;
					alt=0;
					hold=1;
					break;

				case 14:
					cont=1;
					att=1;
					alt=1;
					hold=0;
					break;

				case 15:
					cont=1;
					att=1;
					alt=1;
					hold=1;
					break;
			}

			Envelope_counter=0;

			if (att) env_volume=0;
			else env_volume=15;

			up=att;
			holded=0;

			break;


		case BEEPER :
			if (v) bpr=VolTable[beeper_volume];
			else bpr=0;
			break;
	}	
}

void Mix(unsigned short * sound_buffer, int Sound_Freq, int smezhenie, int n, ...)
{
	va_list ap;
	int i,j;


	va_start(ap, n);

	for (i=0; i<n; i++)
		mixing_ch[i]=va_arg(ap,unsigned short *);

	switch (Sound_Freq)
	{
		case 44100:
			for (i=0; i<SOUND_TICKS_PER_FRAME; i++)
			{
				sound_buffer[i*2+smezhenie]=0;

				for (j=0; j<n; j++)
					sound_buffer[i*2+smezhenie]+=mixing_ch[j][i]/n;
			}
			break;

		case 22050:
			for (i=0; i<(SOUND_TICKS_PER_FRAME_2); i++)
			{
				sound_buffer[i*2+smezhenie]=0;

				for (j=0; j<n; j++)
					sound_buffer[i*2+smezhenie]+=mixing_ch[j][i*2]/n;
			}
			break;

		case 11025:
			for (i=0; i<(SOUND_TICKS_PER_FRAME_4); i++)
			{
				sound_buffer[i*2+smezhenie]=0;

				for (j=0; j<n; j++)
					sound_buffer[i*2+smezhenie]+=mixing_ch[j][i*4]/n;
			}
			break;
	}		
}

void Envelope__Step(void)
{
	if (holded) return;

	/* is it correct ??? */
	if ((alt ? periodE : (periodE*2))>Envelope_counter)
		Envelope_counter++;
	else
	{
		Envelope_counter=0;

		if (up)
		{ 
			if (env_volume<15) env_volume++;
			else
			{
				if (cont==0) 
				{
					holded=1;
					env_volume=0;
					goto LQ;
				}
				if (hold)
				{
					if (alt)env_volume=0;
					holded=1;
					goto LQ;	
				}

				if (alt)up=0;
				else env_volume=0;
			}
		}
		else
		{
			if (env_volume>0) env_volume--;
			else
			{
				if (cont==0) 
				{
					holded=1;
					goto LQ;
				}
				if (hold)
				{
					if (alt)env_volume=15;
					holded=1;
					goto LQ;	
				}
				if (alt)up=1;
				else env_volume=15;
			}
		}
	}

	LQ: ;
}


void UpdateSoundBuffer(void)
{
	int i;
	int j;


	if ((!sound)&&(sound_fil==-1)) return;

	/* zapolnyaem pole pos */
	if (PSGcounter>0)
	{
		if (tcounter==0)tcounter++;	

		for (i=0; i<PSGcounter; i++)
			PSGARRAY[i].pos=(SOUND_TICKS_PER_FRAME-1)*PSGARRAY[i].tcounter/tcounter;
	}	

	/* generim zvuk */
	j=0;
	for (i=0; i<SOUND_TICKS_PER_FRAME; i++)
	{	
		if (PSGcounter>0)
		{
			while (i==PSGARRAY[j].pos)
			{
				ApplySoundRegister(PSGARRAY[j].r,PSGARRAY[j].v);

				PSGARRAY[j].pos=SOUND_TICKS_PER_FRAME;

				j++;	

				if (j>=SOUND_ARRAY_LEN) break;
			}
		}	

		/* return; */

		Envelope__Step();


		/* Generator A step */
		if (GeneratorA_counter>=GeneratorA_period)	
			GeneratorA_counter=0;

		if (GeneratorA_counter<(GeneratorA_period/2))
			Atone=1;
		else
			Atone=0;

		GeneratorA_counter++;

		/* Noice A Step */
		if (NoiceA_counter>=PeriodN)	
		{
			NoiceA_counter=0;
			rndA=random();
		}

		if (rndA&1)
			Anoice=1;
		else
			Anoice=0;

		NoiceA_counter++;

		soundA[i]=( ((Atone | channelA_enabled) & (Anoice | noiseA_enabled)) | !GeneratorA_period);
		soundA[i] = (soundA[i]) ? (Regs1[AY_AVOL]&0x10) ? VolTable[env_volume] : VolTable[Regs1[AY_AVOL]] : 0;

		/* Generator B step */
		if (GeneratorB_counter>=GeneratorB_period)	
			GeneratorB_counter=0;

		if (GeneratorB_counter<(GeneratorB_period/2))
			Btone=1;
		else
			Btone=0;

		GeneratorB_counter++;

		/* Noice B Step */
		if (NoiceB_counter>=PeriodN)	
		{
			NoiceB_counter=0;
			rndB=random();
		}

		if (rndB&1)
			Bnoice=1;
		else
			Bnoice=0;

		NoiceB_counter++;

		soundB[i]=( ((Btone | channelB_enabled) & (Bnoice | noiseB_enabled)) | !GeneratorB_period);
		soundB[i] = (soundB[i]) ? (Regs1[AY_BVOL]&0x10) ? VolTable[env_volume] : VolTable[Regs1[AY_BVOL]] : 0;

		/* Generator C step */
		if (GeneratorC_counter>=GeneratorC_period)	
			GeneratorC_counter=0;

		if (GeneratorC_counter<(GeneratorC_period/2))
			Ctone=1;
		else
			Ctone=0;

		GeneratorC_counter++;

		/* Noice C Step */
		if (NoiceC_counter>=PeriodN)	
		{
			NoiceC_counter=0;
			rndC=random();
		}

		if (rndC&1)
			Cnoice=1;
		else
			Cnoice=0;

		NoiceC_counter++;

		soundC[i]=( ((Ctone | channelC_enabled) & (Cnoice | noiseC_enabled)) | !GeneratorC_period);
		soundC[i] = (soundC[i]) ? (Regs1[AY_CVOL]&0x10) ? VolTable[env_volume] : VolTable[Regs1[AY_CVOL]] : 0;

		/* Beeper Step */
		beeper_buffer[i]=bpr;
	}

	/***** Mix & Write *****/
	if (sound_fil!=-1)
	{
		if (stereo_mode==2)
		{
			Mix(sound_bufferD, 44100, 0,4,soundA,soundB,soundC,beeper_buffer);
			Mix(sound_bufferD, 44100, 1,4,soundA,soundB,soundC,beeper_buffer);
		}

		if (stereo_mode==1)
		{
			Mix(sound_bufferD, 44100, 0,3,soundA,soundB,beeper_buffer);
			Mix(sound_bufferD, 44100, 1,3,soundC,soundB,beeper_buffer);
		}	

		if (stereo_mode==0)
		{
			Mix(sound_bufferD, 44100, 0,3,soundA,soundC,beeper_buffer);
			Mix(sound_bufferD, 44100, 1,3,soundB,soundC,beeper_buffer);
		}

		write(sound_fil, sound_bufferD, SOUND_TICKS_PER_FRAME*4);
	}

	if (stereo_mode==2)
	{
		Mix(sound_buffer, Sound_Freq, 0,4,soundA,soundB,soundC,beeper_buffer);
		Mix(sound_buffer, Sound_Freq, 1,4,soundA,soundB,soundC,beeper_buffer);
	}

	if (stereo_mode==1)
	{
		Mix(sound_buffer, Sound_Freq, 0,3,soundA,soundB,beeper_buffer);
		Mix(sound_buffer, Sound_Freq, 1,3,soundC,soundB,beeper_buffer);
	}	

	if (stereo_mode==0)
	{
		Mix(sound_buffer, Sound_Freq, 0,3,soundA,soundC,beeper_buffer);
		Mix(sound_buffer, Sound_Freq, 1,3,soundB,soundC,beeper_buffer);
	}

	/****** Mix End *********/

	PSGcounter=0;
	tcounter=0;

	if (sound)
	{
		switch (Sound_Freq)
		{
			case 44100:
				write(audio,sound_buffer,SOUND_TICKS_PER_FRAME*4); /* stereo, 16 bit */
				break;
			case 22050:
				write(audio,sound_buffer,SOUND_TICKS_PER_FRAME_2*4); /* stereo, 16 bit */
				break;
			case 11025:
				write(audio,sound_buffer,SOUND_TICKS_PER_FRAME_4*4); /* stereo, 16 bit */
				break;
		}
	}	
}
