/*
 * Unreal WD1793 Emulation library
 * emulation core written by SMT (http://sourceforge.net/projects/unrealspeccy)
 * ported to GNU C++ and modularized by boo_boo
 *
 * mail me: boo_boo(^at^)inbox.ru
 *
 */

#ifndef _WD1793_UNREAL__
#define _WD1793_UNREAL__

enum DIMAGE_TYPE
{
   imgTRD, imgFDI, imgTD0, imgUDI, imgUnknown
};

#ifndef _WD1793_UNREAL_SELF_INCLUDE

#ifdef __cplusplus
extern "C" {
#endif

/*
wd1793_in: read from wd1793 port
port -- port to read from
time -- time in tacts of Z80 since start
err -- pointer to error flag (0=no errors)
*/
extern unsigned char wd1793_in(unsigned char port, unsigned long long time, int *err);

/*
wd1793_out: write to wd1793 port
port -- port to write to
val -- value to write
time -- time in tacts of Z80 since start
err -- pointer to error flag (0=no errors)
*/
extern void wd1793_out(unsigned char port, unsigned char val, unsigned long long time, int *err);

/*
wd1793_load_dimage: load disk image <filename> to <drive=0,1,2 or 3>
*/
extern int wd1793_load_dimage(char *filename, int drive);

/*
wd1793_eject_dimage: eject disk image from <drive>
*/
extern void wd1793_eject_dimage(int drive);

/*
wd1793_get_status_reg: get wd1793 status register
*/
extern unsigned char wd1793_get_status_reg();

/*
wd1793_set_appendboot: automatically append boot from file <boot_name> to TRDOS-disks, if there's no boot.B
*/
extern void wd1793_set_appendboot(char *boot_name);

/*
wd1793_set_trd_interleave: set interleave for trd disks
*/
extern void wd1793_set_trd_interleave(int iv);

/*
wd1793_set_nodelay: set emulation of delays on or off
*/
extern void wd1793_set_nodelay(int nodelay);

/*
wd1793_is_disk_changed: returns 1 if disk in <drive> was modifyed
*/
extern int wd1793_is_disk_changed(int drive);

/*
wd1793_save_dimage: save disk in <drive> to <filename>, in format <type>
*/
extern int wd1793_save_dimage(char *filename, int drive, enum DIMAGE_TYPE type);

/*
wd1793_is_disk_loaded: returns 1 if there's disk in <drive>
*/
extern int wd1793_is_disk_loaded(int drive);

/*
wd1793_set_disk_wprotected: set write protection for disk in <drive>, 1=protected, 0=not
*/
extern void wd1793_set_disk_wprotected(int drive, int wp);

/*
wd1793_is_disk_wprotected: returns 1 if disk in <drive> is write-protected
*/
extern int wd1793_is_disk_wprotected(int drive);

#ifdef __cplusplus
}
#endif
	
#endif

#endif
