    .inesprg    2
    .ineschr    1
    .inesmir    1
    .inesmap    0

    .bank 0
    .org $8000

PPU_CTRL		equ $2000
PPU_MASK		equ $2001
PPU_STATUS		equ $2002
PPU_SCROLL		equ $2005
PPU_ADDR		equ $2006
PPU_DATA		equ $2007
PPU_FRAMECNT	equ $4017
DMC_FREQ		equ $4010
CTRL_PORT1		equ $4016

TEMP			equ $20

BLIT_DELAY		equ $eb
BLIT_MODE		equ $ec
BLIT_SET		equ $ed
BLIT_TYPE		equ $ef
BLIT_PTR		equ $f0	;2 bytes
BLIT_CNT		equ $f2
NAME_PAGE		equ $f4
PAGE_CUR		equ $f5
BG_STATE		equ $f6
BG_WAIT_CNT		equ $f7
BG_CHANGE_CNT	equ $f8
BG_OFFX			equ $f9
BG_OFF1			equ $fa
BG_OFF2			equ $fc
RAND_SEED		equ $fe

FRAME_CNT		equ $ff

OAM_ADDR		equ $0300
SPR_VARS		equ $0400

STATE_WAIT		equ 0
STATE_OUT		equ 1
STATE_IN		equ 2
STATE_BLIT		equ 3

BLIT_SIZE		equ $20



reset

;init hardware

    sei
    ldx #$40
    stx PPU_FRAMECNT
    ldx #$ff
    txs
    inx
    stx PPU_MASK
    stx DMC_FREQ
	lda #%10000000
    sta PPU_CTRL

	jsr waitVBlank

    txa
clearRAM
    sta $000,x
    sta $100,x
    sta $200,x
    sta $300,x
    sta $400,x
    sta $500,x
    sta $600,x
    sta $700,x
    inx
    bne clearRAM

	jsr waitVBlank
	lda #$00
	sta PPU_SCROLL
	sta PPU_SCROLL

clearVRAM
	lda #$00
	sta PPU_ADDR
	sta PPU_ADDR
	ldx #$00
.1
	ldy #$40
.2
	sta PPU_DATA
	iny
	bne .2
	inx
	bne .1

	lda #0
	sta FRAME_CNT

initDemo

	lda #0				;init music
	jsr $ac00

	lda #1
	sta RAND_SEED

	ldx #0				;init OAM copy
.1
	lda #240
	sta OAM_ADDR,x
	lda #0
	sta SPR_VARS,x
	inx
	jsr rand
	and #$03
	clc
	adc #$30
	sta OAM_ADDR,x
	jsr rand
	ora #$80
	sta SPR_VARS,x
	inx
	txa
	sta SPR_VARS,x
	jsr rand
	and #$c0
	sta OAM_ADDR,x
	inx
	jsr rand
	sta OAM_ADDR,x
	inx
	bne .1

	lda #154		;sprite 0
	sta OAM_ADDR
	lda #$2f
	sta OAM_ADDR+1
	lda #$20
	sta OAM_ADDR+2
	lda #0
	sta OAM_ADDR+3

;sprite palettes

	lda #$3f
	sta $2006
	lda #$10
	sta $2006
	lda #$03
	sta $2007
	lda #$03
	sta $2007
	lda #$03
	sta $2007
	lda #$30
	sta $2007

;background palettes

	lda #$3f
	sta $2006
	lda #$00
	sta $2006
	ldx #$03
	stx $2007
	lda #$22
	sta $2007
	lda #$03
	sta $2007
	lda #$03
	sta $2007
	stx $2007
	lda #$22
	sta $2007
	lda #$30
	sta $2007
	lda #$11
	sta $2007
	stx $2007
	lda #$11
	sta $2007
	lda #$21
	sta $2007
	lda #$30
	sta $2007
	stx $2007
	lda #$1b
	sta $2007
	lda #$2b
	sta $2007
	lda #$30
	sta $2007


	ldx #LOW(bgNameTable)
	ldy #HIGH(bgNameTable)
	lda #$20
	sta PPU_ADDR
	lda #$00
	sta PPU_ADDR
	jsr unrle

	ldx #LOW(bgNameTable)
	ldy #HIGH(bgNameTable)
	lda #$24
	sta PPU_ADDR
	lda #$00
	sta PPU_ADDR
	jsr unrle

	lda #%00011110	;enable display
	sta PPU_MASK

	lda #0
	sta BG_OFF1
	sta BG_OFF1+1
	sta BG_OFF2
	sta BG_OFF2+1
	sta BG_OFFX
	sta NAME_PAGE

	jsr waitNMI
	lda #STATE_WAIT
	jsr stateSet

mainLoop
	jsr waitNMI

	lda FRAME_CNT
	and #%00010000
	ora #%10000000
	sta PPU_CTRL

	lda BG_STATE
	cmp #STATE_BLIT
	beq blit
	jmp blitSkip
blit
	lda BLIT_TYPE
	beq blitVisible
	jmp blitHidden

blitVisible
	lda #0
	sta PPU_MASK

	lda BLIT_SET+1
	cmp #$02
	bne .blit
	lda BLIT_SET
	cmp #$60
	bne .blit

	lda BLIT_DELAY
	beq .change
	dec BLIT_DELAY
	jmp .blitSkip

.change
	lda BLIT_MODE
	cmp #1
	bne .change1
	lda #STATE_IN
	jsr stateSet
	jmp .blitSkip
.change1
	lda #1
	sta BLIT_MODE
	lda #0
	sta BLIT_SET
	sta BLIT_SET+1

	jmp .blitSkip

.blit
	lda #8					;how many bytes per frame
	sta TEMP+4
.loop
	lda #LOW(bgRandTable)	;get offset in rand table
	clc
	adc BLIT_SET
	sta TEMP
	lda #HIGH(bgRandTable)
	adc BLIT_SET+1
	sta TEMP+1
	lda TEMP
	clc
	adc BLIT_SET
	sta TEMP
	lda TEMP+1
	adc BLIT_SET+1
	sta TEMP+1

	ldy #0					;get offset from rand table
	lda [TEMP],y
	sta TEMP+2
	iny
	lda [TEMP],y
	sta TEMP+3

	lda TEMP+2				;get source offset of nametable
	clc
	adc BLIT_PTR
	sta TEMP
	lda TEMP+3
	adc BLIT_PTR+1
	sta TEMP+1

	ldy #0					;get byte from source nametable
	lda [TEMP],y
	tax

	lda TEMP+3				;set VRAM offset
	ora #$20
	sta PPU_ADDR
	lda TEMP+2
	sta PPU_ADDR

	lda BLIT_MODE
	beq .1
	ldx #0
.1
	stx PPU_DATA

	inc BLIT_SET
	bne .2
	inc BLIT_SET+1
.2
	dec TEMP+4
	bne .loop

.blitSkip
	jmp blitOk

blitHidden
	lda #0
	sta PPU_MASK

	lda BLIT_CNT+1
	ora #$24
	sta PPU_ADDR
	lda BLIT_CNT
	sta PPU_ADDR

	ldy #0
	ldx #BLIT_SIZE
.1
	lda [BLIT_PTR],y
	sta PPU_DATA
	iny
	dex
	bne .1

	lda BLIT_PTR
	clc
	adc #BLIT_SIZE
	sta BLIT_PTR
	lda BLIT_PTR+1
	adc #0
	sta BLIT_PTR+1

	lda BLIT_CNT
	clc
	adc #BLIT_SIZE
	sta BLIT_CNT
	lda BLIT_CNT+1
	adc #0
	sta BLIT_CNT+1

	lda BLIT_CNT+1
	cmp #$02
	bne blitOk
	lda BLIT_CNT
	cmp #$60
	bne blitOk
	lda #STATE_IN
	sta BG_STATE
blitOk

	lda #%00011110
	sta PPU_MASK

blitSkip

	jsr movePages

scrollPage
	lda NAME_PAGE
	sta PPU_ADDR
	lda #$00
	sta PPU_ADDR

	lda BG_OFFX
	sta PPU_SCROLL
	lda BLIT_TYPE
	beq .1
	lda FRAME_CNT
	and #$1f
	tax
	lda bgScrollTable,x
.1
	sta PPU_SCROLL

	lda #0				;DMA transfer of OAM
	sta $2003
	lda #HIGH(OAM_ADDR)
	sta $4014

	jsr $ac03			;play music

moveSprites
	ldx #4
.1
	lda SPR_VARS+2,x
	beq .2
	dec SPR_VARS+2,x
	jmp .4
.2
	lda SPR_VARS,x
	adc SPR_VARS+1,x
	sta SPR_VARS,x
	bcc .3
	inc OAM_ADDR,x
.3
	jsr rand
	and #$01
	beq .4
	dec OAM_ADDR+3,x
.4
	inx
	inx
	inx
	inx
	bne .1

waitSprite0
	ldx #%00010100
	lda #$02
	ldy #$60

.1
	bit PPU_STATUS
	bvs .1
.2
	bit PPU_STATUS
	bvc .2

	stx PPU_MASK
	sta PPU_ADDR
	sty PPU_ADDR

	lda BG_OFF1+1
	sta PPU_SCROLL
	lda #0
	sta PPU_SCROLL

	lda #%00011110
	sta PPU_MASK

delay
	ldy #4
	ldx #180
.1
	dex
	bne .1
	dey
	bne .1

	lda BG_OFF2+1
	sta PPU_SCROLL
	lda #0
	sta PPU_SCROLL

moveBG
	clc
	lda BG_OFF1
	adc #$60
	sta BG_OFF1
	lda BG_OFF1+1
	adc #0
	sta BG_OFF1+1

	clc
	lda BG_OFF2
	adc #$80
	sta BG_OFF2
	lda BG_OFF2+1
	adc #0
	sta BG_OFF2+1

	jmp mainLoop


movePages
	lda BG_STATE
	cmp #STATE_WAIT
	beq .wait
	cmp #STATE_OUT
	beq .out
	cmp #STATE_IN
	beq .in
	rts

.wait
	dec BG_WAIT_CNT
	bne .wait0
	lda #STATE_OUT
	jsr stateSet
.wait0
	rts

.out
	ldx BG_CHANGE_CNT
	lda bgChangeTable+64,x
	sta BG_OFFX
	inc BG_CHANGE_CNT
	lda BG_CHANGE_CNT
	cmp #64
	bne .out0
	lda #STATE_IN
	jsr stateSet
.out0
	rts

.in
	ldx BG_CHANGE_CNT
	lda bgChangeTable,x
	sta BG_OFFX
	inc BG_CHANGE_CNT
	lda BG_CHANGE_CNT
	cmp #64
	bne .in0
	lda #STATE_WAIT
	jsr stateSet
.in0
	rts


stateSet
	sta BG_STATE
	cmp #STATE_WAIT
	beq .wait
	cmp #STATE_OUT
	beq .out
	cmp #STATE_IN
	beq .in
	rts
.wait
	lda #150
	sta BG_WAIT_CNT
	lda #0
	sta BG_OFFX
	rts
.out
	lda #0
	sta BG_CHANGE_CNT
	sta NAME_PAGE
	lda #$ff
	sta BG_OFFX

	rts
.in
	lda #0
	sta BG_CHANGE_CNT
	lda #$04
	sta NAME_PAGE
	lda #$ff
	sta BG_OFFX

	lda PAGE_CUR
	inc PAGE_CUR
	asl a
	tax
	lda pageList,x
	sta BLIT_PTR
	lda pageList+1,x
	sta BLIT_PTR+1
	bne .in0
	lda #0
	sta PAGE_CUR
	jmp .in
.in0

	lda #$3f			;set palette
	sta PPU_ADDR
	lda #$08
	sta PPU_ADDR

	ldx #8
	ldy #0
	lda [BLIT_PTR],y	;set blit type
	sta BLIT_TYPE
	iny
.in1
	lda [BLIT_PTR],y
	sta PPU_DATA
	iny
	dex
	bne .in1

	lda BLIT_PTR		;move pointer by 9 bytes
	clc
	adc #9
	sta BLIT_PTR
	lda BLIT_PTR+1
	adc #0
	sta BLIT_PTR+1

	lda #$23			;set attributes
	ldx BLIT_TYPE
	beq .in2
	ora #$04
.in2
	sta PPU_ADDR
	lda #$c0
	sta PPU_ADDR

	ldx #$40
	ldy #0
.in3
	lda [BLIT_PTR],y
	sta PPU_DATA
	iny
	dex
	bne .in3

	lda BLIT_PTR		;move pointer by 64 bytes
	clc
	adc #$40
	sta BLIT_PTR
	lda BLIT_PTR+1
	adc #0
	sta BLIT_PTR+1

	lda #0				;reset blit counter
	sta BLIT_CNT
	sta BLIT_CNT+1

	lda BLIT_TYPE
	bne .in4

	lda #0				;set variables for visible blit
	sta BLIT_SET
	sta BLIT_SET+1
	sta BLIT_MODE
	lda #150
	sta BLIT_DELAY
.in4

	lda #STATE_BLIT
	sta BG_STATE

	rts

rand				;Galois random generator, found somewhere
	lda RAND_SEED
	asl a
	bcc .1
	eor #$cf
.1
	sta RAND_SEED
	rts


waitVBlank
    bit PPU_STATUS
.1
    bit PPU_STATUS
    bpl .1
	rts


waitNMI
	lda FRAME_CNT
.1
	cmp FRAME_CNT
	beq .1
	rts


nmi
	inc FRAME_CNT
    rti


	.include "rle.asm"


bgScrollTable
	.db $08,$07,$07,$07,$06,$06,$05,$04,$04,$03,$02,$01,$01,$00,$00,$00
	.db $00,$00,$00,$00,$00,$01,$02,$02,$03,$04,$05,$05,$06,$07,$07,$07

bgChangeTable
	.db $e8,$d3,$c0,$ae,$9f,$90,$83,$77,$6d,$63,$5a,$52,$4a,$44,$3d,$38
	.db $33,$2e,$2a,$26,$23,$20,$1d,$1a,$18,$15,$13,$12,$10,$0f,$0d,$0c
	.db $0b,$0a,$09,$08,$07,$07,$06,$05,$05,$04,$04,$04,$03,$03,$03,$02
	.db $02,$02,$02,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00
	.db $ff,$ff,$ff,$fe,$fe,$fd,$fc,$fb,$fa,$f9,$f8,$f6,$f5,$f3,$f1,$f0
	.db $ed,$eb,$e9,$e7,$e4,$e2,$df,$dc,$d9,$d6,$d3,$cf,$cc,$c8,$c5,$c1
	.db $bd,$b9,$b5,$b0,$ac,$a7,$a3,$9e,$99,$94,$8f,$8a,$84,$7f,$79,$73
	.db $6d,$68,$61,$5b,$55,$4e,$48,$41,$3a,$33,$2c,$25,$1e,$16,$0f,$07

bgRandTable
	.dw $00d1,$00ff,$0248,$0075,$0043,$005e,$0179,$002b
	.dw $004c,$0214,$0228,$0147,$01a4,$024c,$025f,$0008
	.dw $0131,$01b7,$007d,$0095,$0026,$0071,$005c,$003e
	.dw $01f4,$00fe,$00d8,$0249,$00a6,$00c0,$0124,$01aa
	.dw $020e,$0081,$01c1,$00dc,$0210,$00b6,$01bd,$0063
	.dw $0117,$0251,$0067,$0084,$0055,$00cf,$0219,$0087
	.dw $019f,$012e,$01e5,$0092,$0243,$00d3,$01a5,$01ce
	.dw $0120,$007c,$01ae,$010d,$01f1,$01ad,$006c,$01eb
	.dw $01f2,$01df,$0144,$001d,$0135,$01cb,$0132,$01b6
	.dw $0160,$0038,$016d,$00d7,$008b,$0130,$0035,$01d7
	.dw $025b,$01cc,$013c,$00bb,$0110,$00df,$01a9,$007a
	.dw $00bc,$01f9,$0211,$0197,$00d0,$013a,$0155,$00ec
	.dw $0212,$0022,$00db,$00ce,$0049,$014e,$0123,$004f
	.dw $01d8,$0231,$00c6,$0062,$0193,$0145,$00b8,$021c
	.dw $00a1,$0027,$021a,$00a0,$024b,$01dd,$013e,$0119
	.dw $0184,$01da,$013f,$0146,$018a,$0156,$01cd,$019b
	.dw $004e,$0174,$0255,$00dd,$006a,$00de,$0128,$0207
	.dw $01e3,$01bf,$01db,$01fa,$00ee,$00e6,$020b,$01f5
	.dw $0221,$00ed,$0090,$01fb,$0203,$011f,$0256,$0057
	.dw $00da,$01c3,$01a1,$00c7,$0097,$01de,$0044,$00f0
	.dw $0245,$0129,$0238,$0242,$01e4,$024e,$0226,$01fc
	.dw $01d6,$01e8,$0230,$01b0,$0016,$00bd,$0101,$0039
	.dw $0220,$0198,$017e,$0014,$0091,$0047,$0151,$0168
	.dw $00f1,$0046,$0225,$006d,$0232,$0235,$017a,$01d9
	.dw $018b,$01cf,$004d,$0170,$0050,$01a6,$00ae,$00ef
	.dw $014b,$0116,$01e6,$0040,$00b4,$001c,$00b0,$015d
	.dw $0031,$01e2,$0080,$0196,$01ee,$021d,$0074,$0007
	.dw $0094,$023e,$0223,$010f,$0216,$00a5,$00b3,$0104
	.dw $006b,$00fb,$003d,$011b,$019a,$0107,$01c0,$014d
	.dw $0114,$0182,$0024,$0012,$00c1,$00ea,$003b,$0142
	.dw $020a,$01d5,$025d,$021e,$0064,$00be,$0159,$0077
	.dw $00f5,$01d4,$0139,$025a,$012f,$024a,$0233,$00a9
	.dw $015c,$011d,$0143,$00d2,$01f3,$007b,$01e1,$00e9
	.dw $005b,$0158,$0086,$01dc,$0060,$0175,$020f,$0188
	.dw $0056,$0227,$0118,$0246,$0254,$008d,$01ab,$0157
	.dw $0183,$01d1,$0244,$0180,$022f,$0099,$005f,$0045
	.dw $0054,$01ba,$00b5,$0215,$00e8,$0190,$00af,$00a4
	.dw $0236,$0253,$0194,$011e,$0033,$0229,$0252,$0036
	.dw $00c8,$00b9,$002d,$0140,$00c9,$0066,$0121,$00d6
	.dw $0137,$0208,$00cd,$01e0,$0258,$0187,$0013,$0134
	.dw $0015,$018f,$0020,$01e9,$00e1,$00fd,$00e7,$012b
	.dw $01ef,$005a,$001b,$01c5,$00f8,$0237,$01f8,$0222
	.dw $00f6,$0125,$01c7,$0070,$0109,$01b8,$0078,$01c2
	.dw $00cc,$00c2,$01a7,$015a,$00e0,$011c,$01c8,$00ab
	.dw $0217,$003f,$01b3,$0181,$003c,$020c,$01c4,$00b1
	.dw $01a8,$01d2,$006e,$0048,$0206,$006f,$0218,$01f7
	.dw $015e,$0195,$012d,$00f4,$012c,$01ac,$0150,$009b
	.dw $002f,$0002,$00e2,$0200,$00f9,$008c,$013d,$022d
	.dw $01b2,$01e7,$00ad,$0186,$014f,$0166,$008f,$0112
	.dw $0169,$00a3,$0042,$0149,$0177,$019d,$007e,$01bb
	.dw $01b1,$0030,$017f,$015b,$00cb,$009a,$0209,$0098
	.dw $01ff,$0009,$012a,$0053,$002a,$0059,$014a,$0017
	.dw $015f,$018e,$00c3,$0023,$0234,$0154,$0239,$0152
	.dw $01c9,$0093,$0079,$0176,$0088,$0103,$00a2,$0185
	.dw $0172,$023b,$016c,$0259,$0028,$000c,$01bc,$00eb
	.dw $005d,$018c,$001e,$00d4,$0173,$0250,$0100,$0085
	.dw $008e,$023d,$0073,$0205,$020d,$023f,$022a,$0032
	.dw $019c,$0083,$009d,$00d9,$0096,$0257,$001f,$0148
	.dw $022b,$01b9,$0161,$00e5,$016b,$0061,$00fa,$0133
	.dw $0018,$007f,$0247,$002c,$00a7,$01fd,$0241,$0163
	.dw $017b,$00ba,$0102,$00f2,$00d5,$01d3,$0192,$01a3
	.dw $01ea,$01f6,$022e,$0010,$0113,$0041,$0072,$00f7
	.dw $00e4,$00c4,$022c,$023a,$0191,$00c5,$010e,$010b
	.dw $0240,$01a0,$0034,$0069,$0006,$004b,$0115,$0021
	.dw $018d,$00ac,$01ed,$0162,$003a,$0058,$00e3,$0167
	.dw $0029,$021f,$0005,$004a,$0136,$0011,$009c,$0089
	.dw $008a,$025e,$0082,$0122,$013b,$01b5,$01f0,$010a
	.dw $01af,$00a8,$024f,$0019,$0213,$00aa,$023c,$017c
	.dw $000b,$0171,$0000,$01fe,$0202,$0141,$0076,$0051
	.dw $0153,$0224,$009f,$009e,$01ca,$016a,$025c,$001a
	.dw $01b4,$0105,$01c6,$0025,$000d,$024d,$0164,$016e
	.dw $0106,$0189,$0178,$00fc,$014c,$00ca,$01be,$000f
	.dw $01a2,$019e,$0165,$011a,$0127,$00f3,$0138,$0068
	.dw $0111,$0108,$0201,$0037,$0065,$00bf,$021b,$0126
	.dw $010c,$0003,$0199,$01ec,$0004,$0204,$002e,$01d0
	.dw $016f,$00b2,$000e,$0052,$00b7,$0001,$017d,$000a

pageList
	.dw page0,page1,page2,page3,page4,page5,page6,page7,page8,page9,0

bgNameTable
	.incbin "back.rle"

page0
	.db 0
	.db $03,$11,$21,$30,$03,$1b,$2b,$30
	.incbin "year.bin"

page1
	.db 1
	.db $03,$14,$24,$30,$03,$22,$31,$30
	.incbin "text1.bin"

page2
	.db 0
	.db $03,$14,$34,$3d,$03,$11,$23,$30
	.incbin "megaman.bin"

page3
	.db 1
	.db $03,$14,$24,$30,$03,$17,$28,$30
	.incbin "text2.bin"

page4
	.db 0
	.db $03,$18,$38,$30,$03,$1c,$2b,$30
	.incbin "bomber.bin"

page5
	.db 1
	.db $03,$18,$38,$30,$03,$1a,$29,$30
	.incbin "text3.bin"

page6
	.db 0
	.db $03,$14,$34,$30,$03,$17,$36,$30
	.incbin "contra.bin"

page7
	.db 1
	.db $03,$22,$31,$30,$03,$19,$29,$30
	.incbin "text4.bin"

	.bank 1
	.org $a2e2-$80
	.incbin "music.nsf"

	.bank 3

	.org $e000

page8
	.db 0
	.db $03,$12,$21,$30,$03,$27,$29,$30
	.incbin "mario.bin"

page9
	.db 1
	.db $03,$19,$29,$30,$03,$1c,$2c,$30
	.incbin "text5.bin"

    .org  $fffa
    .dw   nmi
    .dw   reset

	.bank 4
	.incbin "back.chr"